/*
 * Decompiled with CFR 0.152.
 */
package coins.flow;

import coins.flow.BBlock;
import coins.flow.FlowAnalSymVector;
import coins.flow.FlowError;
import coins.flow.NodeIterator;
import coins.flow.NodeListIterator;
import coins.flow.SubpFlow;
import coins.ir.IR;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.ConstNode;
import coins.ir.hir.HIR;
import coins.ir.hir.HIR_Impl;
import coins.ir.hir.HirIterator;
import coins.ir.hir.HirList;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubscriptedExp;
import coins.sym.FlowAnalSym;
import coins.sym.StructType;
import coins.sym.Sym;
import coins.sym.Type;
import coins.sym.Var;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;

public class FlowUtil {
    public static IR getChild1(IR pIR) {
        if (pIR instanceof HIR) {
            return pIR.getChild1();
        }
        throw new FlowError();
    }

    public static IR getChild2(IR pIR) {
        if (pIR instanceof HIR) {
            return pIR.getChild2();
        }
        throw new FlowError();
    }

    public static FlowAnalSym flowAnalSym(IR pIR) {
        if (pIR instanceof HIR) {
            Sym lSym = pIR.getSym();
            if (lSym instanceof FlowAnalSym) {
                return (FlowAnalSym)lSym;
            }
        } else {
            throw new FlowError();
        }
        return null;
    }

    public static FlowAnalSym derefedFlowAnalSym(IR pIR) {
        Sym lSym;
        if (pIR instanceof HIR && (lSym = pIR.getSym()) instanceof FlowAnalSym && ((HIR)pIR.getParent()).getOperator() != 64) {
            return (FlowAnalSym)lSym;
        }
        return null;
    }

    public static int getChildCount(IR pIR) {
        int lChildCount = 0;
        if (!(pIR instanceof HIR)) {
            throw new FlowError();
        }
        lChildCount = ((HIR)pIR).getChildCount();
        return lChildCount;
    }

    public static boolean isConstNode(IR pIR) {
        return pIR instanceof ConstNode;
    }

    public static FlowAnalSymVector globalSymVector(SubpFlow pSubpFlow) {
        FlowAnalSymVector lGlobal = pSubpFlow.flowAnalSymVector();
        for (int lIndex = 0; lIndex < pSubpFlow.getUsedSymCount(); ++lIndex) {
            FlowAnalSym lSym = pSubpFlow.getIndexedSym(lIndex);
            if (!(lSym instanceof Var) || !lSym.isGlobal()) continue;
            lGlobal.setBit(lIndex);
        }
        return lGlobal;
    }

    public static FlowAnalSymVector staticSymVector(SubpFlow pSubpFlow) {
        FlowAnalSymVector lStatic = pSubpFlow.flowAnalSymVector();
        for (int lIndex = 0; lIndex < pSubpFlow.getUsedSymCount(); ++lIndex) {
            FlowAnalSym lSym = pSubpFlow.getIndexedSym(lIndex);
            if (!(lSym instanceof Var) || ((Var)((Object)lSym)).getStorageClass() != 6) continue;
            lStatic.setBit(lIndex);
        }
        return lStatic;
    }

    public static List bfSearch(BBlock pEntry, BBlock pExit, boolean pForward) {
        ArrayList<BBlock> lBFList = new ArrayList<BBlock>();
        lBFList.add(pEntry);
        FlowUtil.bfs(lBFList, pExit, 0, pForward);
        return lBFList;
    }

    private static void bfs(List pBFList, BBlock pExit, int pPos, boolean pForward) {
        BBlock lCurrent = (BBlock)pBFList.get(pPos);
        if (lCurrent != pExit) {
            List lSuccList = pForward ? lCurrent.getSuccList() : lCurrent.getPredList();
            for (BBlock lSucc : lSuccList) {
                if (pBFList.contains(lSucc)) continue;
                pBFList.add(lSucc);
            }
        }
        if (pPos < pBFList.size() - 1) {
            FlowUtil.bfs(pBFList, pExit, ++pPos, pForward);
        }
    }

    public static HirIterator hirIterator(HIR pSubtree) {
        return new HirIt(pSubtree, true);
    }

    public static NodeIterator nodeIterator(IR pIR) {
        if (pIR instanceof HIR) {
            return new HirIt0(pIR);
        }
        return null;
    }

    public static NodeListIterator nodeListIterator(IR pIR) {
        return FlowUtil.nodeListIterator(pIR, true, true);
    }

    public static NodeListIterator nodeListIterator(IR pIR, boolean pFromTop, boolean pFromLeft) {
        if (pIR instanceof HIR) {
            return new HirListIt0((HIR)pIR, pFromTop, pFromLeft);
        }
        throw new FlowError();
    }

    public static boolean isUnder(IR pAncestor, IR pDescendant) {
        if (pAncestor == null) {
            return false;
        }
        while (!pAncestor.equals(pDescendant)) {
            if (pDescendant.getParent() == null) {
                return false;
            }
            pDescendant = pDescendant.getParent();
        }
        return true;
    }

    public static String toString(HIR pHIR) {
        StringBuffer lBuff = new StringBuffer();
        if (pHIR == null) {
            return "";
        }
        lBuff.append("(");
        lBuff.append(pHIR.toStringShort());
        Sym lSym = pHIR.getSym();
        if (lSym != null) {
            lBuff.append(" " + lSym.getName());
        }
        for (int i = 1; i <= pHIR.getChildCount(); ++i) {
            lBuff.append(FlowUtil.toString((HIR)pHIR.getChild(i)));
        }
        lBuff.append(")");
        return lBuff.toString();
    }

    public static boolean shouldAssignFlowExpId(IR pIR) {
        if (pIR instanceof HIR) {
            switch (((HIR)pIR).getOperator()) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 9: 
                case 10: 
                case 11: 
                case 14: 
                case 15: 
                case 16: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 32: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 71: 
                case 73: 
                case 79: 
                case 80: {
                    return false;
                }
                case 7: 
                case 8: 
                case 12: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 33: 
                case 38: 
                case 39: 
                case 41: 
                case 42: 
                case 43: 
                case 46: 
                case 47: 
                case 48: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 58: 
                case 59: 
                case 60: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 70: 
                case 72: 
                case 76: 
                case 77: 
                case 78: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: 
                case 87: 
                case 88: 
                case 89: 
                case 90: 
                case 91: 
                case 92: 
                case 93: 
                case 94: 
                case 95: {
                    return true;
                }
            }
            throw new FlowError();
        }
        return false;
    }

    public static boolean isDefSymNode(IR pIR) {
        if (pIR instanceof HIR) {
            return ((HIR)pIR.getParent()).getOperator() == 22 && (HIR)pIR.getParent().getChild1() == pIR;
        }
        throw new FlowError();
    }

    public static boolean isCall(IR pIR) {
        if (pIR instanceof HIR) {
            return ((HIR)pIR).getOperator() == 33;
        }
        throw new FlowError();
    }

    public static boolean isLvalue(IR pIR) {
        if (pIR instanceof HIR) {
            switch (pIR.getOperator()) {
                case 7: 
                case 17: 
                case 19: 
                case 20: 
                case 67: 
                case 68: {
                    return true;
                }
            }
            return false;
        }
        throw new FlowError();
    }

    public static boolean notDereferenced(IR pIR) {
        int lOpCode;
        return pIR instanceof HIR && (lOpCode = ((HIR)pIR.getParent()).getOperator()) == 64;
    }

    private static void modSymsUnder(HIR pHIR, Set pModSyms, SubpFlow pSubpFlow) {
        Sym lSym = pHIR.getSym();
        int lOpCode = pHIR.getOperator();
        if (pHIR instanceof Stmt) {
            throw new FlowError("Invalid argument.");
        }
        if (lSym instanceof FlowAnalSym) {
            pModSyms.add(pHIR.getSym());
        }
        switch (lOpCode) {
            case 17: {
                FlowUtil.modSymsUnder(((SubscriptedExp)pHIR).getArrayExp(), pModSyms, pSubpFlow);
                break;
            }
            case 68: {
                pModSyms.addAll(pSubpFlow.setOfAddressTakenVariables());
                pModSyms.addAll(pSubpFlow.setOfGlobalVariables());
                break;
            }
            case 64: {
                break;
            }
            default: {
                for (int lChildNumber = 1; lChildNumber <= pHIR.getChildCount(); ++lChildNumber) {
                    FlowUtil.modSymsUnder((HIR)pHIR.getChild(lChildNumber), pModSyms, pSubpFlow);
                }
            }
        }
    }

    public static boolean mayBeExternalAddress(IR pIR) {
        HIR lHIR;
        if (pIR instanceof HIR && (lHIR = (HIR)pIR).getOperator() == 17) {
            return FlowUtil.mayBeExternalAddress(((SubscriptedExp)lHIR).getArrayExp());
        }
        return FlowUtil.readsFromIndefiniteAddress(pIR);
    }

    public static boolean readsFromIndefiniteAddress(IR pIR) {
        if (pIR instanceof HIR) {
            int lOpCode = ((HIR)pIR).getOperator();
            return lOpCode == 20 || lOpCode == 68 || lOpCode == 67;
        }
        throw new FlowError();
    }

    public static boolean isVolatile(IR pIR) {
        Sym lSym = pIR.getSym();
        return lSym == null ? false : lSym.getSymType().isVolatile();
    }

    public static boolean IsVarSyms(Sym pSym) {
        return FlowUtil.IsVarSymType(pSym.getSymType());
    }

    public static HIR getQualVarNode(HIR pNode) {
        if (pNode == null) {
            return null;
        }
        HIR lQualVarNode = FlowUtil.getComplexNode(pNode);
        if (lQualVarNode == null) {
            lQualVarNode = pNode.getOperator() == 19 ? (FlowUtil.isCommonQUAL(pNode) ? FlowUtil.getQualVarNode((HIR)pNode.getChild2()) : FlowUtil.getQualVarNode((HIR)pNode.getChild1())) : pNode;
        }
        if (((HIR_Impl)pNode).hirRoot.ioRoot.dbgHir.getLevel() > 3) {
            ((HIR_Impl)pNode).hirRoot.ioRoot.dbgFlow.print(5, " getQualVarNode " + pNode.toStringShort() + "=" + lQualVarNode.toStringShort());
        }
        return lQualVarNode;
    }

    public static boolean isCommonQUAL(HIR pNode) {
        if (pNode == null) {
            return false;
        }
        if (pNode.getOperator() != 19) {
            return false;
        }
        Type t = pNode.getType();
        if (t.getTypeKind() == 24 || t.getTypeKind() == 25) {
            Sym tag = ((StructType)t).getTag();
            if (tag == null) {
                return false;
            }
            if (tag.getFlag(15)) {
                return true;
            }
            if (FlowUtil.isCommonQUAL((HIR)pNode.getChild1())) {
                return true;
            }
            if (FlowUtil.isCommonQUAL((HIR)pNode.getChild2())) {
                return true;
            }
        }
        return true;
    }

    public static boolean isComplexQUAL(HIR pNode) {
        if (pNode.getOperator() != 19) {
            return false;
        }
        HIR c = FlowUtil.getComplexNode(pNode);
        return c != null;
    }

    public static HIR getComplexNode(HIR pNode) {
        if (pNode.getOperator() != 19) {
            return null;
        }
        HIR cNode = (HIR)pNode.getChild1();
        if (FlowUtil.isComplexNode(cNode)) {
            return cNode;
        }
        cNode = (HIR)pNode.getChild2();
        if (FlowUtil.isComplexNode(cNode)) {
            return cNode;
        }
        if (pNode.getOperator() == 19) {
            HIR Child = FlowUtil.getComplexNode((HIR)pNode.getChild1());
            if (Child != null) {
                return Child;
            }
            Child = FlowUtil.getComplexNode((HIR)pNode.getChild2());
            if (Child != null) {
                return Child;
            }
        }
        return null;
    }

    public static boolean isComplexNode(HIR pNode) {
        Type t;
        FlowAnalSym s = FlowUtil.flowAnalSym(pNode);
        if (s != null && (t = pNode.getType()).getTypeKind() == 24) {
            Type tsym = s.getSymType();
            Sym tag = ((StructType)tsym).getTag();
            if (tag == null) {
                return false;
            }
            if (tag.getFlag(14)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isComplexElemNode(HIR pNode) {
        if (FlowUtil.isComplexNode(pNode)) {
            return false;
        }
        HIR lParent = (HIR)pNode.getParent();
        return lParent.getOperator() == 19 && FlowUtil.isComplexQUAL(lParent);
    }

    public static boolean IsVarSymType(Type pType) {
        if (pType.getTypeKind() == 25) {
            return false;
        }
        return pType.getTypeKind() != 24;
    }

    public static List sortSetOfNodesByIndex(Set pSetOfNodes, int pMaxIndex) {
        HIR[] lNodeVector = new HIR[pMaxIndex * 2 + 1];
        ArrayList<HIR> lListOfNodes = new ArrayList<HIR>(pSetOfNodes.size() + 1);
        Iterator lSetIt = pSetOfNodes.iterator();
        while (lSetIt.hasNext()) {
            HIR lNode;
            lNodeVector[lNode.getIndex()] = lNode = (HIR)lSetIt.next();
        }
        for (int lIndex = 0; lIndex <= pMaxIndex; ++lIndex) {
            if (lNodeVector[lIndex] == null) continue;
            lListOfNodes.add(lNodeVector[lIndex]);
        }
        return lListOfNodes;
    }

    public static boolean isAssignLHS(HIR pHir) {
        if (pHir == null) {
            return false;
        }
        HIR lCurr = pHir;
        for (HIR lAncestor = (HIR)pHir.getParent(); lAncestor != null; lAncestor = (HIR)lAncestor.getParent()) {
            int lOpCode = lCurr.getOperator();
            if (lOpCode != 7 && lOpCode != 12 && lOpCode != 17 && lOpCode != 19 && lOpCode != 20) {
                return false;
            }
            if (lAncestor instanceof AssignStmt && lAncestor.getChild1() == lCurr) {
                return true;
            }
            lCurr = lAncestor;
        }
        return false;
    }

    public static HIR getAncestorAssign(HIR pHir) {
        HIR lParent;
        if (pHir == null) {
            return null;
        }
        if (pHir instanceof AssignStmt) {
            return pHir;
        }
        for (lParent = (HIR)pHir.getParent(); lParent != null && !(lParent instanceof AssignStmt) && !(lParent instanceof BlockStmt); lParent = (HIR)lParent.getParent()) {
        }
        return lParent;
    }

    private static class HirListIt0
    extends HirIt0
    implements NodeListIterator {
        ListIterator fListIt;
        boolean fFromTop;
        HirIt fHirIt;

        HirListIt0(HIR pHIR, boolean pFromTop, boolean pFromLeft) {
            this.fFromTop = pFromTop;
            this.fHirIt = new HirIt(pHIR, !(pFromTop ^ pFromLeft));
            this.fListIt = pFromTop ? this.fHirIt.fList.listIterator() : this.fHirIt.fList.listIterator(this.fHirIt.fList.size());
        }

        public boolean hasNext() {
            if (this.fFromTop) {
                return this.fListIt.hasNext();
            }
            return this.fListIt.hasPrevious();
        }

        public IR next() {
            if (this.fFromTop) {
                return (IR)this.fListIt.next();
            }
            return (IR)this.fListIt.previous();
        }

        public boolean hasPrevious() {
            if (this.fFromTop) {
                return this.fListIt.hasPrevious();
            }
            return this.fListIt.hasNext();
        }

        public int nextIndex() {
            if (this.fFromTop) {
                return this.fListIt.nextIndex();
            }
            return this.fHirIt.fList.size() - 1 - this.fListIt.previousIndex();
        }

        public IR previous() {
            if (this.fFromTop) {
                return (IR)this.fListIt.previous();
            }
            return (IR)this.fListIt.next();
        }

        public int previousIndex() {
            if (this.fFromTop) {
                return this.fListIt.previousIndex();
            }
            return this.fHirIt.fList.size() - 1 - this.fListIt.nextIndex();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }

        public void set(IR pIR) {
        }
    }

    private static class HirIt0
    implements NodeIterator {
        HirIt fHirIt;

        HirIt0(IR pIR) {
            this.fHirIt = new HirIt((HIR)pIR, true);
        }

        HirIt0() {
        }

        public boolean hasNext() {
            return this.fHirIt.hasNext();
        }

        public IR next() {
            return this.fHirIt.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean hasPrevious() {
            throw new FlowError();
        }

        public IR previous() {
            throw new FlowError();
        }
    }

    private static class HirIt
    implements HirIterator {
        List fList = new ArrayList();
        ListIterator fIt;

        HirIt(HIR pSubtree, boolean pFromTopAndLeft) {
            this.addUnder(pSubtree, pFromTopAndLeft);
            this.fIt = this.fList.listIterator();
        }

        private void addUnder(HIR pSubtree, boolean pFromTopAndLeft) {
            block10: {
                block11: {
                    int lOpCode;
                    block9: {
                        if (pSubtree == null) {
                            return;
                        }
                        this.fList.add(pSubtree);
                        lOpCode = pSubtree.getOperator();
                        if (lOpCode != 35) break block9;
                        for (Stmt lStmt = ((BlockStmt)pSubtree).getFirstStmt(); lStmt != null; lStmt = lStmt.getNextStmt()) {
                            this.addUnder(lStmt, pFromTopAndLeft);
                        }
                        break block10;
                    }
                    if (lOpCode != 14) break block11;
                    ArrayList<HIR> lArgs = new ArrayList<HIR>();
                    ListIterator lIt = ((HirList)pSubtree).iterator();
                    while (lIt.hasNext()) {
                        HIR lHir = (HIR)lIt.next();
                        if (pFromTopAndLeft) {
                            this.addUnder(lHir, pFromTopAndLeft);
                            continue;
                        }
                        lArgs.add(lHir);
                    }
                    if (pFromTopAndLeft) break block10;
                    ListIterator lListIt = lArgs.listIterator(lArgs.size());
                    while (lListIt.hasPrevious()) {
                        this.addUnder((HIR)lListIt.previous(), pFromTopAndLeft);
                    }
                    break block10;
                }
                int lChildCount = pSubtree.getChildCount();
                if (pFromTopAndLeft) {
                    for (int i = 1; i <= lChildCount; ++i) {
                        this.addUnder((HIR)pSubtree.getChild(i), pFromTopAndLeft);
                    }
                } else {
                    for (int i = lChildCount; i > 0; --i) {
                        this.addUnder((HIR)pSubtree.getChild(i), pFromTopAndLeft);
                    }
                }
            }
        }

        public HIR next() {
            return (HIR)this.fIt.next();
        }

        public boolean hasNext() {
            return this.fIt.hasNext();
        }

        public boolean hasNextStmt() {
            return false;
        }

        public HIR getNextExecutableNode() {
            throw new UnsupportedOperationException();
        }

        public Stmt getNextStmt() {
            throw new UnsupportedOperationException();
        }

        public Stmt nextStmt() {
            throw new UnsupportedOperationException();
        }

        public HIR getParentNode() {
            throw new UnsupportedOperationException();
        }

        public int getStackDepth() {
            throw new UnsupportedOperationException();
        }

        public HIR peekCurrent() {
            throw new UnsupportedOperationException();
        }

        public HIR peekNext() {
            return (HIR)this.fList.get(this.fIt.nextIndex());
        }

        public void replaceNext(HIR pHIR) {
            throw new UnsupportedOperationException();
        }
    }
}

