/*
 * Decompiled with CFR 0.152.
 */
package coins.flow;

import coins.FlowRoot;
import coins.HirRoot;
import coins.IoRoot;
import coins.SymRoot;
import coins.flow.BBlock;
import coins.flow.BBlockNodeIterator;
import coins.flow.BBlockSubtreeIterator;
import coins.flow.ControlFlow;
import coins.flow.ControlFlowImpl;
import coins.flow.DataFlow;
import coins.flow.DataFlowHirImpl;
import coins.flow.Flow;
import coins.flow.HirSubpFlow;
import coins.flow.HirSubpFlowImpl;
import coins.flow.InitiateFlowHir;
import coins.flow.MySubpFlow;
import coins.flow.ShowControlFlow;
import coins.flow.ShowDataFlow;
import coins.flow.SubpFlow;
import coins.flow.SubpFlowImpl;
import coins.ir.IrList;
import coins.ir.hir.BlockStmt;
import coins.ir.hir.HIR;
import coins.ir.hir.HirIterator;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.Program;
import coins.ir.hir.Stmt;
import coins.ir.hir.SubpDefinition;
import coins.sym.FlagBox;
import coins.sym.Subp;
import java.util.ListIterator;
import java.util.Map;

public class FlowImpl
implements Flow {
    public final FlowRoot flowRoot;
    public final IoRoot ioRoot;
    public final SymRoot symRoot;
    public final HirRoot hirRoot;
    public SubpFlow fSubpFlow;
    public Object fSubpFlowCurrent = null;
    public Subp fSubp;
    public ControlFlow fControlFlow;
    public DataFlow fDataFlow;
    protected FlagBox fFlowAnalState;
    protected int fFlowAnalStateLevel;
    public Map staticVariableMapOfSubp = null;
    public final int fDbgLevel;

    public FlowImpl() {
        this.flowRoot = null;
        this.ioRoot = null;
        this.symRoot = null;
        this.hirRoot = null;
        this.fDbgLevel = 0;
    }

    public FlowImpl(FlowRoot pFlowRoot) {
        this.flowRoot = pFlowRoot;
        this.ioRoot = pFlowRoot.ioRoot;
        this.symRoot = pFlowRoot.symRoot;
        this.hirRoot = pFlowRoot.hirRoot;
        this.fDbgLevel = this.ioRoot.dbgFlow.getLevel();
    }

    public ControlFlow controlFlowAnal(SubpFlow pSubpFlow) {
        SubpDefinition lSubpDef = pSubpFlow.getSubpDefinition();
        Subp lSubp = lSubpDef.getSubpSym();
        this.ioRoot.dbgFlow.println(1);
        if (this.fDbgLevel > 0) {
            this.dbg(1, "\nControl flow analysis of " + lSubp.getName());
        }
        Flow cfr_ignored_0 = this.flowRoot.flow;
        if (this.flowRoot.flow.getFlowAnalStateLevel() >= 1) {
            pSubpFlow.resetControlAndDataFlowInformation();
        }
        if (this.flowRoot.isHirAnalysis()) {
            if (this.fDbgLevel >= 4) {
                lSubpDef.printHir("before control flow analysis");
            }
            this.ioRoot.dbgFlow.println(2);
            this.flowRoot.controlFlow = new ControlFlowImpl(this.flowRoot, (HirSubpFlow)pSubpFlow, lSubpDef);
            if (this.fDbgLevel >= 3) {
                lSubpDef.printHir("after dividing into basic blocks");
            }
        }
        this.fControlFlow = this.flowRoot.controlFlow;
        ShowControlFlow sFlow = this.controlFlow().getShowControlFlow();
        if (this.fDbgLevel > 1) {
            sFlow.showAll();
        }
        this.flowRoot.fSubpFlow.getEntryBBlock().linkInDepthFirstOrder(lSubp);
        if (this.fDbgLevel >= 3) {
            this.ioRoot.printOut.print("\nBasic block information in depth first order.\n");
            for (BBlock lBBlock = this.flowRoot.fSubpFlow.getEntryBBlock(); lBBlock != null; lBBlock = lBBlock.getNextInDFO()) {
                this.ioRoot.printOut.print(" " + lBBlock.toStringDetail() + "\n");
            }
        }
        this.setFlowAnalStateLevel(2);
        pSubpFlow.setComputedFlag(4);
        if (this.flowRoot.isHirAnalysis()) {
            // empty if block
        }
        return this.flowRoot.controlFlow;
    }

    public DataFlow dataFlowAnal(SubpDefinition pSubpDef) {
        Subp lSubp = pSubpDef.getSubpSym();
        if (this.fDbgLevel > 0) {
            this.ioRoot.dbgFlow.println(1);
            this.dbg(1, "Data flow analysis of " + lSubp.getName() + " state " + this.fFlowAnalStateLevel);
        }
        SubpFlow lSubpFlow = this.flowRoot.fSubpFlow;
        ((SubpFlowImpl)lSubpFlow).initiateDataFlowAnal(pSubpDef);
        if (this.flowRoot.isHirAnalysis()) {
            InitiateFlowHir lInitiateFlowHir = new InitiateFlowHir();
            lInitiateFlowHir.initiateDataFlow(lSubpFlow);
            this.flowRoot.dataFlow = new DataFlowHirImpl(this.flowRoot, (HirSubpFlow)lSubpFlow);
        }
        this.fDataFlow = this.flowRoot.dataFlow;
        if (this.fDbgLevel >= 2) {
            this.dbg(2, "\nbegin findAll\n");
            this.fDataFlow.findAll();
            lSubpFlow.summarize();
            if (this.fDbgLevel >= 7) {
                this.dataFlow().showAll();
            }
            this.dataFlow().showSummary();
            if (this.flowRoot.isHirAnalysis()) {
                if (this.fDbgLevel >= 5) {
                    this.symRoot.symTable.printSymTableAllDetail(this.symRoot.symTableRoot);
                }
                if (this.ioRoot.dbgHir.getLevel() >= 3) {
                    // empty if block
                }
            }
        }
        this.setFlowAnalStateLevel(4);
        return this.flowRoot.dataFlow;
    }

    public void resetAllFlowInf(Subp pSubp) {
        SubpFlow lSubpFlow = this.flowRoot.fSubpFlow;
        if (lSubpFlow != null) {
            lSubpFlow.resetFlowSymLinkForRecordedSym();
            this.fControlFlow = null;
            this.fDataFlow = null;
            this.fSubpFlow = null;
            this.fSubpFlowCurrent = null;
        }
    }

    public SubpFlow getSubpFlow() {
        return this.fSubpFlow;
    }

    public Subp getSubpUnderAnalysis() {
        return this.fSubp;
    }

    public ControlFlow controlFlow() {
        return this.fControlFlow;
    }

    public DataFlow dataFlow() {
        return this.fDataFlow;
    }

    public DataFlow dataFlowAnal() {
        this.dbg(1, "\ndataFlowAnal()", "do data flow analysis for all subprograms\n");
        IrList subpDefList = ((Program)this.hirRoot.programRoot).getSubpDefinitionList();
        ListIterator subpDefIterator = subpDefList.iterator();
        while (subpDefIterator.hasNext()) {
            SubpDefinition subpDef = (SubpDefinition)subpDefIterator.next();
            if (subpDef == null) continue;
            HirSubpFlowImpl lHirSubpFlow = new HirSubpFlowImpl(this.flowRoot, subpDef);
            this.fSubpFlow = lHirSubpFlow;
            this.flowRoot.controlFlow = this.controlFlowAnal(lHirSubpFlow);
            this.flowRoot.dataFlow = this.dataFlowAnal(subpDef);
        }
        return this.fDataFlow;
    }

    public boolean getFlowAnalState(int pFlagId) {
        return this.fFlowAnalState.getFlag(pFlagId);
    }

    public void setFlowAnalState(int pFlagId, boolean pYesNo) {
        this.fFlowAnalState.setFlag(pFlagId, pYesNo);
    }

    public int getFlowAnalStateLevel() {
        return this.fFlowAnalStateLevel;
    }

    public void setFlowAnalStateLevel(int pStateLevel) {
        this.fFlowAnalStateLevel = pStateLevel;
        if (this.ioRoot.dbgFlow.getLevel() >= 2) {
            this.ioRoot.dbgFlow.print(2, " setFlowAnalStateLevel", "=" + pStateLevel);
        }
    }

    private void testHirModify(HIR pSubpBody) {
        Stmt lStmt;
        this.ioRoot.dbgHir.print(3, "testHirModify subpBody", ((Object)pSubpBody).toString());
        if (this.ioRoot.dbgHir.getLevel() >= 3 && pSubpBody.getOperator() == 21 && (lStmt = ((LabeledStmt)pSubpBody).getStmt()).getOperator() == 35) {
            BlockStmt lBlock1 = (BlockStmt)lStmt.copyWithOperands();
            this.ioRoot.dbgHir.println(3);
            this.ioRoot.dbgHir.print(3, "CopyWithOperands result", lStmt.toStringShort());
            lBlock1.print(0);
            BlockStmt lBlock2 = (BlockStmt)lStmt.copyWithOperandsChangingLabels(null);
            this.ioRoot.dbgHir.println(3);
            this.ioRoot.dbgHir.print(3, "CopyWithOperandsChangingLabel result", lStmt.toStringShort());
            LabeledStmt lStmt2 = this.hirRoot.hir.labeledStmt(this.symRoot.symTableCurrent.generateLabel(), lBlock2);
            lStmt2.print(0);
            ((BlockStmt)((LabeledStmt)pSubpBody).getStmt()).addLastStmt(lStmt2);
        }
    }

    private void testClone(HIR pSubpDef) {
        this.ioRoot.dbgHir.print(2, "testClone", ((SubpDefinition)pSubpDef).getSubpSym().getName());
        if (this.ioRoot.dbgHir.getLevel() >= 2) {
            HIR lSubpDef = pSubpDef.copyWithOperands();
            lSubpDef.print(1, true);
        }
    }

    private void testNodeIterator() {
        BBlock lBBlock;
        int lBlockNo;
        HIR lStmt;
        HIR lNode;
        if (this.ioRoot.dbgHir.getLevel() >= 4) {
            HirIterator lHirIterator;
            if (this.ioRoot.dbgHir.getLevel() >= 5) {
                this.ioRoot.printOut.print("\nHirIterator applied to programRoot");
                lHirIterator = this.hirRoot.hir.hirIterator(this.hirRoot.programRoot);
                while (lHirIterator.hasNext()) {
                    lNode = lHirIterator.next();
                    this.ioRoot.printOut.print("\nHir " + IoRoot.toStringObject(lNode));
                }
            }
            this.ioRoot.printOut.print("\nHirIterator");
            lHirIterator = this.hirRoot.hir.hirIterator(this.symRoot.subpCurrent.getHirBody());
            while (lHirIterator.hasNext()) {
                lNode = lHirIterator.next();
                this.ioRoot.printOut.print("\nHir " + IoRoot.toStringObject(lNode));
            }
            this.ioRoot.printOut.print("\nHirIterator getNextStmt");
            lHirIterator = this.hirRoot.hir.hirIterator(this.symRoot.subpCurrent.getHirBody());
            while (lHirIterator.hasNext()) {
                lStmt = lHirIterator.nextStmt();
                this.ioRoot.printOut.print("\n Stmt " + IoRoot.toStringObject(lStmt));
            }
            this.ioRoot.printOut.print("\nHirIterator getNextExecutableNode");
            lHirIterator = this.hirRoot.hir.hirIterator(this.symRoot.subpCurrent.getHirBody());
            while (lHirIterator.hasNext()) {
                lNode = lHirIterator.getNextExecutableNode();
                this.ioRoot.printOut.print("\nHir " + IoRoot.toStringObject(lNode));
            }
        }
        this.ioRoot.dbgHir.print(4, "BBlock", "SubtreeIterator ");
        SubpFlow lSubpFlow = this.flowRoot.fSubpFlow;
        for (lBlockNo = 1; lBlockNo <= lSubpFlow.getNumberOfBBlocks(); ++lBlockNo) {
            lBBlock = lSubpFlow.getBBlock(lBlockNo);
            this.ioRoot.dbgHir.print(4, "BBlock", "No: " + lBlockNo + " " + lBBlock.getBlockNumber() + " HirLink " + ((HIR)lBBlock.getIrLink()).toStringShort());
            BBlockSubtreeIterator lStmtIterator = lBBlock.bblockSubtreeIterator();
            while (lStmtIterator.hasNext()) {
                lStmt = (HIR)lStmtIterator.next();
                this.ioRoot.dbgHir.print(4, " Subtree", IoRoot.toStringObject(lStmt));
                if (lStmt == null) continue;
                this.ioRoot.dbgHir.print(4, " Parent " + IoRoot.toStringObject(lStmt.getParent()));
                if (this.ioRoot.dbgHir.getLevel() <= 4) continue;
                HirIterator lHirIterator2 = this.hirRoot.hir.hirIterator(lStmt);
                while (lHirIterator2.hasNext()) {
                    lNode = lHirIterator2.next();
                    this.ioRoot.printOut.print("\n  HirInStmt " + IoRoot.toStringObject(lNode));
                }
            }
        }
        if (this.ioRoot.dbgHir.getLevel() >= 4) {
            this.ioRoot.dbgHir.print(4, "BBlock", "NodeIterator ");
            for (lBlockNo = 1; lBlockNo <= lSubpFlow.getNumberOfBBlocks(); ++lBlockNo) {
                this.ioRoot.dbgHir.print(3, " NodeIterator", "for B" + lBlockNo);
                lBBlock = lSubpFlow.getBBlock(lBlockNo);
                BBlockNodeIterator lNodeIterator = lBBlock.bblockNodeIterator();
                while (lNodeIterator.hasNext()) {
                    lNode = (HIR)lNodeIterator.next();
                    this.ioRoot.printOut.print("\n  Node " + IoRoot.toStringObject(lNode));
                }
            }
        }
    }

    public void dbg(int level, String pHeader, Object pObject) {
        this.ioRoot.dbgFlow.printObject(level, pHeader, pObject);
        this.ioRoot.dbgFlow.println(level);
    }

    public void dbg(int level, Object pObject) {
        if (pObject == null) {
            this.ioRoot.dbgFlow.print(level, " null ");
        } else {
            this.ioRoot.dbgFlow.print(level, " " + pObject.toString());
        }
    }

    public void doHir() {
        this.dbg(1, "\ndoHir() ");
        IrList subpDefList = ((Program)this.hirRoot.programRoot).getSubpDefinitionList();
        ListIterator subpDefIterator = subpDefList.iterator();
        while (subpDefIterator.hasNext()) {
            SubpDefinition subpDef = (SubpDefinition)subpDefIterator.next();
            if (subpDef == null) continue;
            MySubpFlow lSubpFlow = new MySubpFlow(this.flowRoot, subpDef);
            this.fSubpFlow = lSubpFlow;
            this.doHir0(this.fSubpFlow.getSubpDefinition(), this.fSubpFlow);
        }
    }

    public void doHir0(SubpDefinition pSubpDef, SubpFlow pSubpFlow) {
        this.dbg(1, "\ndoHir0", " BEGIN " + pSubpDef.getSubpSym().getName());
        boolean lReturnValue = false;
        ControlFlow lControlFlow = this.controlFlowAnal(pSubpFlow);
        ShowControlFlow lShowControlFlow = new ShowControlFlow(pSubpFlow, lControlFlow);
        lShowControlFlow.showAll();
        DataFlow lDataFlow = this.dataFlowAnal(pSubpDef);
        ((MySubpFlow)pSubpFlow).computeTransparent();
        ShowDataFlow lShowDataFlow = new ShowDataFlow(lDataFlow);
        if (this.ioRoot.dbgFlow.getLevel() > 4) {
            lShowDataFlow.showAll();
        } else {
            lShowDataFlow.showSummary();
        }
        this.dbg(1, "\ndoHir0", " END");
    }
}

