/*
 * Decompiled with CFR 0.152.
 */
package coins.flow;

import coins.FlowRoot;
import coins.flow.DefUseChain;
import coins.flow.DefUseChainImpl;
import coins.flow.DefUseList;
import coins.flow.FlowError;
import coins.flow.FlowUtil;
import coins.ir.IR;
import coins.ir.hir.HIR;
import coins.sym.FlowAnalSym;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

public class DefUseListImpl
implements DefUseList {
    public final FlowRoot flowRoot;
    protected List fDefUseChainList = null;
    protected HashMap fDefUseMap;
    protected final FlowAnalSym fDefUseSym;
    protected HashMap fDefUseMapOfSym = null;

    public DefUseListImpl(FlowRoot pFlowRoot) {
        this.flowRoot = pFlowRoot;
        this.fDefUseMap = new HashMap();
        this.fDefUseSym = null;
        if (this.flowRoot.ioRoot.dbgFlow.getLevel() > 3) {
            this.flowRoot.ioRoot.dbgFlow.print(6, " DefUseListImpl ");
        }
    }

    public DefUseChain addDefUseChain(IR pDefNode) {
        if (this.flowRoot.ioRoot.dbgFlow.getLevel() > 3) {
            this.flowRoot.ioRoot.dbgFlow.print(6, " addDefUseChain " + pDefNode.toStringShort() + " ");
        }
        if (this.fDefUseMap.containsKey(pDefNode)) {
            return (DefUseChain)this.fDefUseMap.get(pDefNode);
        }
        DefUseChainImpl lDefUseChain = new DefUseChainImpl(this.flowRoot, pDefNode);
        this.fDefUseMap.put(pDefNode, lDefUseChain);
        return lDefUseChain;
    }

    public DefUseChain getDefUseChain(IR pDefNode) {
        DefUseChain lDefUseChain = (DefUseChain)this.fDefUseMap.get(pDefNode);
        if (lDefUseChain == null) {
            if (this.flowRoot.ioRoot.dbgFlow.getLevel() > 0) {
                this.flowRoot.ioRoot.dbgFlow.print(1, "\nDefUseChain corresponding to the Def node " + pDefNode + " not found.");
                this.print();
            }
            throw new FlowError("DefUseChain corresponding to the Def node " + pDefNode + " not found.");
        }
        return lDefUseChain;
    }

    public List getDefUseChainList() {
        if (this.fDefUseChainList == null) {
            this.fDefUseChainList = new ArrayList();
            Set lDefNodeSet = this.fDefUseMap.keySet();
            for (IR lDefNode : lDefNodeSet) {
                this.fDefUseChainList.add(lDefNode);
            }
        }
        return this.fDefUseChainList;
    }

    public List getDefUseChainListOfSym(FlowAnalSym pSym) {
        ArrayList<DefUseChain> lDefUseChainListOfSym;
        if (this.fDefUseMapOfSym == null) {
            this.fDefUseMapOfSym = new HashMap();
        }
        if (this.fDefUseMapOfSym.containsKey(pSym)) {
            lDefUseChainListOfSym = (ArrayList<DefUseChain>)this.fDefUseMapOfSym.get(pSym);
        } else {
            Set lDefNodeSet = this.fDefUseMap.keySet();
            lDefUseChainListOfSym = new ArrayList<DefUseChain>();
            for (HIR lDefNode : lDefNodeSet) {
                HIR lLHS = (HIR)lDefNode.getChild1();
                FlowAnalSym lSym = null;
                if (lLHS != null) {
                    lSym = lLHS.getSymOrExpId();
                }
                if (lSym != pSym) continue;
                DefUseChain lDefUseChain = this.getDefUseChain(lDefNode);
                lDefUseChainListOfSym.add(lDefUseChain);
            }
            this.fDefUseMapOfSym.put(pSym, lDefUseChainListOfSym);
        }
        if (this.flowRoot.ioRoot.dbgFlow.getLevel() >= 4) {
            this.flowRoot.ioRoot.dbgFlow.print(4, "\n getDefUseChainListOfSym " + pSym.getName());
            for (DefUseChain lDefUseChain2 : lDefUseChainListOfSym) {
                this.flowRoot.ioRoot.dbgFlow.print(4, "\n  " + lDefUseChain2.toStringByName());
            }
        }
        return lDefUseChainListOfSym;
    }

    DefUseChain getOrAddDefUseChain(IR pDefNode) {
        if (this.fDefUseMap.containsKey(pDefNode)) {
            return (DefUseChain)this.fDefUseMap.get(pDefNode);
        }
        return this.addDefUseChain(pDefNode);
    }

    public void print() {
        this.flowRoot.ioRoot.printOut.print("\nDefUseList ");
        DefUseChain lDefUseChain = null;
        List lDefNodeList = FlowUtil.sortSetOfNodesByIndex(this.fDefUseMap.keySet(), this.flowRoot.fSubpFlow.getIrIndexMax());
        for (HIR lDefNode : lDefNodeList) {
            if (lDefNode == null || (lDefUseChain = this.getDefUseChain(lDefNode)) == null) continue;
            this.flowRoot.ioRoot.printOut.print("\n " + lDefUseChain.toStringByName());
        }
    }
}

