/*
 * Decompiled with CFR 0.152.
 */
package coins.flow;

import coins.FlowRoot;
import coins.flow.BBlock;
import coins.flow.BBlockHirNodeIteratorImpl;
import coins.flow.BBlockHirSubtreeIteratorImpl;
import coins.flow.BBlockNodeIterator;
import coins.flow.BBlockSubtreeIterator;
import coins.flow.DefVector;
import coins.flow.DefVectorImpl;
import coins.flow.Edge;
import coins.flow.EdgeImpl;
import coins.flow.ExpVector;
import coins.flow.ExpVectorImpl;
import coins.flow.FlowAnalSymVector;
import coins.flow.FlowAnalSymVectorImpl;
import coins.flow.SubpFlow;
import coins.ir.IR;
import coins.ir.hir.HIR;
import coins.ir.hir.LabeledStmt;
import coins.sym.ExpId;
import coins.sym.FlagBox;
import coins.sym.FlagBoxImpl;
import coins.sym.FlowAnalSym;
import coins.sym.Label;
import coins.sym.Subp;
import coins.sym.Sym;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public abstract class BBlockImpl
implements BBlock {
    public final FlowRoot flowRoot;
    public final SubpFlow subpFlow;
    protected int fBBlockNumber;
    protected IR fIrLink;
    protected LinkedList fPredList;
    protected LinkedList fSuccList;
    protected LinkedList fPredEdgeList;
    protected LinkedList fSuccEdgeList;
    protected BBlock fImmediateDominator;
    protected BBlock fImmediatePostDominator;
    protected LinkedList fDominatedChildren;
    protected LinkedList fPostDominatedChildren;
    protected BBlock fNextInDFO;
    protected BBlock fNextInInverseDFO;
    protected FlagBox fFlagBox;
    protected Object fWork;
    protected Object fWorkFA;
    protected HashMap fExpNodeListMap = new HashMap();
    protected DefVector fDef;
    protected DefVector fKill;
    protected DefVector fIn;
    protected DefVector fOut;
    protected DefVector fReach;
    protected ExpVector fEGen;
    protected ExpVector fEKill;
    protected ExpVector fEKillAll;
    protected ExpVector fAvailIn;
    protected ExpVector fAvailOut;
    protected FlowAnalSymVector fDefined;
    protected FlowAnalSymVector fExposed;
    protected FlowAnalSymVector fLiveIn;
    protected FlowAnalSymVector fLiveOut;
    protected FlowAnalSymVector fDefIn;
    protected FlowAnalSymVector fDefOut;
    protected FlowAnalSymVector fUsed;
    protected Set fDefNodes;
    public final int fDbgLevel;
    protected coins.aflow.BBlock aflowBBlock;
    public HIR fControlTransfer;

    public BBlockImpl() {
        this.flowRoot = null;
        this.subpFlow = null;
        this.fDbgLevel = 0;
    }

    public BBlockImpl(FlowRoot pFlowRoot, int pBBlockNumber) {
        this.flowRoot = pFlowRoot;
        this.subpFlow = pFlowRoot.fSubpFlow;
        this.fBBlockNumber = pBBlockNumber;
        this.initiateFields();
        this.fFlagBox = new FlagBoxImpl();
        this.fDbgLevel = this.flowRoot.ioRoot.dbgFlow.getLevel();
        this.fControlTransfer = null;
    }

    protected void initiateFields() {
        this.fPredList = new LinkedList();
        this.fSuccList = new LinkedList();
        this.fPredEdgeList = new LinkedList();
        this.fSuccEdgeList = new LinkedList();
        this.fFlagBox = new FlagBoxImpl();
    }

    public int getBlockNumber() {
        return this.fBBlockNumber;
    }

    public IR getIrLink() {
        return this.fIrLink;
    }

    public void setIrLink(LabeledStmt pLabeledStmt) {
        if (this.fDbgLevel > 0) {
            this.flowRoot.ioRoot.dbgFlow.print(1, "setIrLink", "should be overridden by BBlockHir");
        }
    }

    public Label getLabel() {
        Object lLabel = null;
        if (this.fIrLink != null && this.flowRoot.isHirAnalysis()) {
            return ((LabeledStmt)this.fIrLink).getLabel();
        }
        return null;
    }

    public List getPredList() {
        return this.fPredList;
    }

    public List getSuccList() {
        return this.fSuccList;
    }

    public Edge getPredEdge(BBlock pFromBBlock) {
        int lIndex = this.fPredList.indexOf(pFromBBlock);
        if (lIndex >= 0) {
            return (Edge)this.fPredEdgeList.get(lIndex);
        }
        return null;
    }

    public Edge getSuccEdge(BBlock pToBBlock) {
        int lIndex = this.fSuccList.indexOf(pToBBlock);
        if (lIndex >= 0) {
            return (Edge)this.fSuccEdgeList.get(lIndex);
        }
        return null;
    }

    public boolean isEntryBlock() {
        return this.fFlagBox.getFlag(7);
    }

    public boolean isExitBlock() {
        return this.fFlagBox.getFlag(8);
    }

    public boolean isLoopBackEdge(BBlock pPredecessor) {
        if (pPredecessor == null) {
            return false;
        }
        Edge lEdge = pPredecessor.getSuccEdge(this);
        if (lEdge != null) {
            return lEdge.flagBox().getFlag(11);
        }
        return false;
    }

    public BBlock getImmediateDominator() {
        return this.fImmediateDominator;
    }

    public void setImmediateDominator(BBlock pDominator) {
        this.fImmediateDominator = pDominator;
    }

    public List getDominatedChildren() {
        return this.fDominatedChildren;
    }

    public void setDominatedChildren(LinkedList pDominatedChildren) {
        this.fDominatedChildren = pDominatedChildren;
    }

    public BBlock getImmediatePostDominator() {
        return this.fImmediatePostDominator;
    }

    public void setImmediatePostDominator(BBlock pPostDominator) {
        this.fImmediatePostDominator = pPostDominator;
    }

    public List getPostDominatedChildren() {
        return this.fPostDominatedChildren;
    }

    public void setPostDominatedChildren(LinkedList pPostDominatedChildren) {
        this.fPostDominatedChildren = pPostDominatedChildren;
    }

    public BBlock getNextInDFO() {
        return this.fNextInDFO;
    }

    public void setNextInDFO(BBlock pNext) {
        this.fNextInDFO = pNext;
    }

    public BBlock getNextInInverseDFO() {
        return this.fNextInInverseDFO;
    }

    public void setNextInInverseDFO(BBlock pNext) {
        this.fNextInInverseDFO = pNext;
    }

    public void linkInDepthFirstOrder(Subp pSubp) {
        if (this.fDbgLevel > 0) {
            this.flowRoot.flow.dbg(2, "\nlinkInDepthFirstOrder", pSubp.getName());
        }
        ArrayList lBBlockTable = this.flowRoot.fSubpFlow.getBBlockTable();
        for (BBlock lBBlock : lBBlockTable) {
            if (lBBlock == null || lBBlock.getBBlockNumber() == 0) continue;
            lBBlock.setFlag(5, false);
            lBBlock.setFlag(6, false);
        }
        this.flowRoot.fSubpFlow.setPrevBBlockInSearch(null);
        ((BBlockImpl)this.flowRoot.fSubpFlow.getEntryBBlock()).dfoVisit();
    }

    private void dfoVisit() {
        BBlock lPrev = this.flowRoot.fSubpFlow.getPrevBBlockInSearch();
        if (lPrev != null) {
            lPrev.setNextInDFO(this);
            if (this.fDbgLevel > 0) {
                this.flowRoot.flow.dbg(3, " B" + lPrev.getBBlockNumber() + "-B" + this.getBBlockNumber());
            }
        }
        this.flowRoot.fSubpFlow.setPrevBBlockInSearch(this);
        this.setFlag(5, true);
        if (this.getSuccList() != null) {
            for (BBlock lBBlock : this.getSuccList()) {
                if (!lBBlock.getFlag(5)) {
                    ((BBlockImpl)lBBlock).dfoVisit();
                    continue;
                }
                if (lBBlock.getFlag(6)) continue;
                lBBlock.setFlag(9, true);
                this.setFlag(10, true);
            }
        }
        this.setFlag(6, true);
    }

    public void linkInInverseDepthFirstOrder(Subp pSubp) {
        if (this.fDbgLevel > 0) {
            this.flowRoot.flow.dbg(2, "\nlinkInInverseDepthFirstOrder", pSubp.getName());
        }
        ArrayList lBBlockTable = this.flowRoot.fSubpFlow.getBBlockTable();
        for (BBlock lBBlock : lBBlockTable) {
            if (lBBlock == null || lBBlock.getBBlockNumber() == 0) continue;
            lBBlock.setFlag(5, false);
            lBBlock.setFlag(6, false);
        }
        this.flowRoot.fSubpFlow.setPrevBBlockInSearch(null);
        ((BBlockImpl)this.flowRoot.fSubpFlow.getExitBBlock()).inverseDfoVisit();
    }

    private void inverseDfoVisit() {
        BBlock lPrev = this.flowRoot.fSubpFlow.getPrevBBlockInSearch();
        if (lPrev != null) {
            if (this.fDbgLevel > 0) {
                this.flowRoot.flow.dbg(3, " B" + lPrev.getBBlockNumber() + "-B" + this.getBBlockNumber());
            }
            lPrev.setNextInInverseDFO(this);
        }
        this.flowRoot.fSubpFlow.setPrevBBlockInSearch(this);
        this.setFlag(5, true);
        if (this.getPredList() != null) {
            for (BBlock lBBlock : this.getPredList()) {
                if (lBBlock.getFlag(5)) continue;
                ((BBlockImpl)lBBlock).inverseDfoVisit();
            }
        }
        this.setFlag(6, true);
    }

    public Object getWork() {
        return this.fWork;
    }

    public void setWork(Object pWork) {
        this.fWork = pWork;
    }

    public Object getWorkFA() {
        return this.fWorkFA;
    }

    public void setWorkFA(Object pWorkFA) {
        this.fWorkFA = pWorkFA;
    }

    public BBlockSubtreeIterator bblockSubtreeIterator() {
        return new BBlockHirSubtreeIteratorImpl(this.flowRoot, this);
    }

    public BBlockNodeIterator bblockNodeIterator() {
        return new BBlockHirNodeIteratorImpl(this.flowRoot, this);
    }

    public String toString() {
        return "BBlock" + this.fBBlockNumber;
    }

    public String toStringShort() {
        StringBuffer lBuffer = new StringBuffer("BBlock " + this.fBBlockNumber + " pred(");
        for (BBlock lBBlock : this.fPredList) {
            lBuffer.append(" " + lBBlock.getBlockNumber());
        }
        lBuffer.append(") succ( ");
        for (BBlock lBBlock : this.fSuccList) {
            lBuffer.append(" " + lBBlock.getBlockNumber());
        }
        lBuffer.append(")");
        return lBuffer.toString();
    }

    public String toStringDetail() {
        StringBuffer lBuffer = new StringBuffer();
        lBuffer = lBuffer.append(this.toStringShort()).append(this.getIrLink().toString());
        if (this.getFlag(7)) {
            lBuffer.append(" isEntry");
        }
        if (this.getFlag(8)) {
            lBuffer.append(" isExit");
        }
        if (this.getFlag(13)) {
            lBuffer.append(" hasCall");
        }
        if (this.getFlag(9)) {
            lBuffer.append(" loopHead");
        }
        if (this.getFlag(10)) {
            lBuffer.append(" loopTail");
        }
        if (this.getFlag(14)) {
            lBuffer.append(" ptrAssign");
        }
        if (this.getFlag(15)) {
            lBuffer.append(" usePtr");
        }
        if (this.getFlag(16)) {
            lBuffer.append(" hasStructUnion");
        }
        return lBuffer.toString();
    }

    public void printSubtrees() {
    }

    public void addToPredList(BBlock pPred) {
        List lList = this.getPredList();
        if (!lList.contains(pPred)) {
            lList.add(pPred);
            int lIndex = lList.indexOf(pPred);
            EdgeImpl lEdge = new EdgeImpl(this.flowRoot, pPred, this);
            this.fPredEdgeList.add(lIndex, lEdge);
        }
    }

    public void addToSuccList(BBlock pSucc) {
        List lList = this.getSuccList();
        if (!lList.contains(pSucc)) {
            lList.add(pSucc);
            int lIndex = lList.indexOf(pSucc);
            EdgeImpl lEdge = new EdgeImpl(this.flowRoot, this, pSucc);
            this.fSuccEdgeList.add(lIndex, lEdge);
        }
    }

    public void deleteFromPredList(BBlock pPred) {
        List lList = this.getPredList();
        if (lList.contains(pPred)) {
            int lIndex = lList.indexOf(pPred);
            lList.remove(pPred);
            this.fPredEdgeList.remove(lIndex);
        }
    }

    public void deleteFromSuccList(BBlock pSucc) {
        List lList = this.getSuccList();
        if (lList.contains(pSucc)) {
            int lIndex = lList.indexOf(pSucc);
            lList.remove(pSucc);
            this.fSuccEdgeList.remove(lIndex);
        }
    }

    public boolean getFlag(int pFlagNumber) {
        return this.fFlagBox.getFlag(pFlagNumber);
    }

    public void setFlag(int pFlagNumber, boolean pYesNo) {
        this.fFlagBox.setFlag(pFlagNumber, pYesNo);
    }

    public void allocateSpaceForDataFlowAnalysis(int pPointCount, int pDefCount, int pExpCount) {
        this.fDef = new DefVectorImpl(this.subpFlow);
        this.fKill = new DefVectorImpl(this.subpFlow);
        this.fIn = new DefVectorImpl(this.subpFlow);
        this.fOut = new DefVectorImpl(this.subpFlow);
        this.fReach = new DefVectorImpl(this.subpFlow);
        this.fDefined = new FlowAnalSymVectorImpl(this.subpFlow);
        this.fExposed = new FlowAnalSymVectorImpl(this.subpFlow);
        this.fEGen = new ExpVectorImpl(this.subpFlow);
        this.fEKill = new ExpVectorImpl(this.subpFlow);
        this.fEKillAll = new ExpVectorImpl(this.subpFlow);
        this.fAvailIn = new ExpVectorImpl(this.subpFlow);
        this.fAvailOut = new ExpVectorImpl(this.subpFlow);
        this.fLiveIn = new FlowAnalSymVectorImpl(this.subpFlow);
        this.fLiveOut = new FlowAnalSymVectorImpl(this.subpFlow);
        this.fDefIn = new FlowAnalSymVectorImpl(this.subpFlow);
        this.fDefOut = new FlowAnalSymVectorImpl(this.subpFlow);
        this.fUsed = new FlowAnalSymVectorImpl(this.subpFlow);
        this.fDefNodes = new HashSet();
        if (this.fDbgLevel > 3) {
            this.flowRoot.ioRoot.dbgFlow.print(4, "allocateSpaceForDataFlowAnalysis", "B" + this.getBlockNumber());
        }
    }

    public boolean isDef(int pPos) {
        if (!this.subpFlow.isComputed(23)) {
            this.flowRoot.dataFlow.findDefUse();
        }
        return this.fDef.getBit(pPos) == 1;
    }

    public boolean isKill(int pPos) {
        if (!this.subpFlow.isComputed(10)) {
            this.flowRoot.dataFlow.findKill();
        }
        return this.fKill.getBit(pPos) == 1;
    }

    public boolean isReach(int pPos) {
        if (!this.subpFlow.isComputed(11)) {
            this.flowRoot.dataFlow.findReach();
        }
        return this.fReach.getBit(pPos) == 1;
    }

    public boolean isDefined(Sym pSym) {
        if (!this.subpFlow.isComputed(12)) {
            this.flowRoot.dataFlow.findDefined();
        }
        return this.isSymExpOn(this.fDefined, pSym);
    }

    public boolean isUsed(Sym pSym) {
        if (!this.subpFlow.isComputed(23)) {
            this.flowRoot.dataFlow.findDefUse();
        }
        return this.isSymExpOn(this.fUsed, pSym);
    }

    public boolean isExposed(Sym pSym) {
        if (!this.subpFlow.isComputed(14)) {
            this.flowRoot.dataFlow.findExposed();
        }
        return this.isSymExpOn(this.fExposed, pSym);
    }

    public boolean isEGen(ExpId pExpId) {
        int lInx;
        if (!this.subpFlow.isComputed(15)) {
            this.flowRoot.dataFlow.findEGen();
        }
        return this.fEGen.getBit(lInx = pExpId.getIndex()) == 1;
    }

    public boolean isEKill(ExpId pExpId) {
        int lInx;
        if (!this.subpFlow.isComputed(16)) {
            this.flowRoot.dataFlow.findEKill();
        }
        return this.fEKill.getBit(lInx = pExpId.getIndex()) == 1;
    }

    public boolean isAvailIn(ExpId pExpId) {
        int lInx;
        if (!this.subpFlow.isComputed(18)) {
            this.flowRoot.dataFlow.findAvailInAvailOut();
        }
        return this.fAvailIn.getBit(lInx = pExpId.getIndex()) == 1;
    }

    public boolean isAvailOut(ExpId pExpId) {
        int lInx;
        if (!this.subpFlow.isComputed(18)) {
            this.flowRoot.dataFlow.findAvailInAvailOut();
        }
        return this.fAvailOut.getBit(lInx = pExpId.getIndex()) == 1;
    }

    public boolean isLiveIn(Sym pSym) {
        if (!this.subpFlow.isComputed(19)) {
            this.flowRoot.dataFlow.findLiveInLiveOut();
        }
        return this.isSymExpOn(this.fLiveIn, pSym);
    }

    public boolean isLiveOut(Sym pSym) {
        if (!this.subpFlow.isComputed(20)) {
            this.flowRoot.dataFlow.findLiveInLiveOut();
        }
        return this.isSymExpOn(this.fLiveOut, pSym);
    }

    public boolean isDefIn(Sym pSym) {
        if (!this.subpFlow.isComputed(21)) {
            this.flowRoot.dataFlow.findDefInDefOut();
        }
        return this.isSymExpOn(this.fDefIn, pSym);
    }

    public boolean isDefOut(Sym pSym) {
        if (!this.subpFlow.isComputed(22)) {
            this.flowRoot.dataFlow.findDefInDefOut();
        }
        return this.isSymExpOn(this.fDefOut, pSym);
    }

    protected boolean isSymExpOn(ExpVector pVector, Sym pSym) {
        boolean trueFalse = false;
        if (pSym != null) {
            switch (pSym.getSymKind()) {
                case 17: {
                    int lInx = ((FlowAnalSym)pSym).getIndex();
                    if (pVector.getBit(lInx) != 1) break;
                    trueFalse = true;
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    int lInx = ((FlowAnalSym)pSym).getIndex();
                    if (pVector.getBit(lInx) != 1) break;
                    trueFalse = true;
                    break;
                }
            }
        }
        return trueFalse;
    }

    public DefVector getDef() {
        if (!this.subpFlow.isComputed(9)) {
            this.flowRoot.dataFlow.findDef();
        }
        return this.fDef;
    }

    public void setDef(DefVector pVect) {
        this.fDef = pVect;
    }

    public DefVector getKill() {
        if (!this.subpFlow.isComputed(10)) {
            this.flowRoot.dataFlow.findKill();
        }
        return this.fKill;
    }

    public void setKill(DefVector pVect) {
        this.fKill = pVect;
    }

    public DefVector getReach() {
        if (!this.subpFlow.isComputed(11)) {
            this.flowRoot.dataFlow.findReach();
        }
        return this.fReach;
    }

    public void setReach(DefVector pVect) {
        this.fReach = pVect;
    }

    public FlowAnalSymVector getDefined() {
        if (!this.subpFlow.isComputed(12)) {
            this.flowRoot.dataFlow.findDefined();
        }
        return this.fDefined;
    }

    public void setDefined(FlowAnalSymVector pVect) {
        this.fDefined = pVect;
    }

    public FlowAnalSymVector getUsed() {
        if (!this.subpFlow.isComputed(13)) {
            this.flowRoot.dataFlow.findUsed();
        }
        return this.fUsed;
    }

    public void setUsed(FlowAnalSymVector pVect) {
        this.fUsed = pVect;
    }

    public FlowAnalSymVector getExposed() {
        if (!this.subpFlow.isComputed(14)) {
            this.flowRoot.dataFlow.findExposed();
        }
        return this.fExposed;
    }

    public void setExposed(FlowAnalSymVector pVect) {
        this.fExposed = pVect;
    }

    public ExpVector getEGen() {
        if (!this.subpFlow.isComputed(15)) {
            this.flowRoot.dataFlow.findEGen();
        }
        return this.fEGen;
    }

    public void setEGen(ExpVector pVect) {
        this.fEGen = pVect;
    }

    public ExpVector getEKill() {
        if (!this.subpFlow.isComputed(16)) {
            this.flowRoot.dataFlow.findEKill();
        }
        return this.fEKill;
    }

    public ExpVector getEKillAll() {
        if (!this.subpFlow.isComputed(16)) {
            this.flowRoot.dataFlow.findEKill();
        }
        return this.fEKillAll;
    }

    public void setEKill(ExpVector pVect) {
        this.fEKill = pVect;
    }

    public ExpVector getAvailIn() {
        if (!this.subpFlow.isComputed(17)) {
            this.flowRoot.dataFlow.findAvailInAvailOut();
        }
        return this.fAvailIn;
    }

    public void setAvailIn(ExpVector pVect) {
        this.fAvailIn = pVect;
    }

    public ExpVector getAvailOut() {
        if (!this.subpFlow.isComputed(18)) {
            this.flowRoot.dataFlow.findAvailInAvailOut();
        }
        return this.fAvailOut;
    }

    public void setAvailOut(ExpVector pVect) {
        this.fAvailOut = pVect;
    }

    public FlowAnalSymVector getLiveIn() {
        if (!this.subpFlow.isComputed(19)) {
            this.flowRoot.dataFlow.findLiveInLiveOut();
        }
        return this.fLiveIn;
    }

    public void setLiveIn(FlowAnalSymVector pVect) {
        this.fLiveIn = pVect;
    }

    public FlowAnalSymVector getLiveOut() {
        if (!this.subpFlow.isComputed(20)) {
            this.flowRoot.dataFlow.findLiveInLiveOut();
        }
        return this.fLiveOut;
    }

    public void setLiveOut(FlowAnalSymVector pVect) {
        this.fLiveOut = pVect;
    }

    public FlowAnalSymVector getDefIn() {
        if (!this.subpFlow.isComputed(21)) {
            this.flowRoot.dataFlow.findDefInDefOut();
        }
        return this.fDefIn;
    }

    public void setDefIn(FlowAnalSymVector pVect) {
        this.fDefIn = pVect;
    }

    public FlowAnalSymVector getDefOut() {
        if (!this.subpFlow.isComputed(22)) {
            this.flowRoot.dataFlow.findDefInDefOut();
        }
        return this.fDefOut;
    }

    public void setDefOut(FlowAnalSymVector pVect) {
        this.fDefOut = pVect;
    }

    public Set getDefNodes() {
        if (!this.subpFlow.isComputed(23)) {
            this.flowRoot.dataFlow.findDefUse();
        }
        return this.fDefNodes;
    }

    public void setDefNodes(Set pSet) {
        this.fDefNodes = pSet;
    }

    public SubpFlow getSubpFlow() {
        return this.subpFlow;
    }

    public int getBBlockNumber() {
        return this.fBBlockNumber;
    }

    public void setAflowBBlock(coins.aflow.BBlock pBBlock) {
        this.aflowBBlock = pBBlock;
    }

    public coins.aflow.BBlock getAflowBBlock() {
        return this.aflowBBlock;
    }

    public DefVector getReachVector() {
        return this.fReach;
    }

    public DefVector getDefVector() {
        return this.fDef;
    }

    public DefVector getKillVector() {
        return this.fKill;
    }

    public ExpVector getEGenVector() {
        return this.fEGen;
    }

    public ExpVector getEKillVector() {
        return this.fEKill;
    }

    public ExpVector getEKillAllVector() {
        return this.fEKillAll;
    }

    public ExpVector getAvailInVector() {
        return this.fAvailIn;
    }

    public ExpVector getAvailOutVector() {
        return this.fAvailOut;
    }

    public FlowAnalSymVector getDefinedVector() {
        return this.fDefined;
    }

    public FlowAnalSymVector getExposedVector() {
        return this.fExposed;
    }

    public FlowAnalSymVector getLiveInVector() {
        return this.fLiveIn;
    }

    public FlowAnalSymVector getLiveOutVector() {
        return this.fLiveOut;
    }

    public FlowAnalSymVector getDefInVector() {
        return this.fDefIn;
    }

    public FlowAnalSymVector getDefOutVector() {
        return this.fDefOut;
    }

    public FlowAnalSymVector getUsedVector() {
        return this.fUsed;
    }

    public void resetForDataFlowAnal() {
        this.fExpNodeListMap = new HashMap();
    }

    public HIR controlTransfer() {
        return this.fControlTransfer;
    }
}

