/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.CallStmt;
import coins.ffront.DeclManager;
import coins.ffront.EntryType;
import coins.ffront.FNumber;
import coins.ffront.FStmt;
import coins.ffront.FirToHir;
import coins.ffront.FortranCharacterExp;
import coins.ffront.HasConstValue;
import coins.ffront.HeaderStmt;
import coins.ffront.HirUtility;
import coins.ffront.Node;
import coins.ffront.StmtFuncParamType;
import coins.ffront.SubscrOrFunCallNode;
import coins.ffront.TypeUtility;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.sym.Param;
import coins.sym.PointerType;
import coins.sym.StructType;
import coins.sym.Subp;
import coins.sym.Sym;
import coins.sym.Type;
import coins.sym.Var;

public class Token
implements Node,
HasConstValue {
    FirToHir fHir;
    DeclManager fDeclMgr;
    HirUtility fHirUtil;
    TypeUtility fTypeUtil;
    private int lineNo;
    private String lexem;
    private int kind;

    Token(int n, String s, FirToHir pfHir) {
        this.lineNo = n;
        this.lexem = s.intern();
        this.kind = -1;
        this.addFHir(pfHir);
    }

    Token(int n, String s) {
        this(n, s, null);
    }

    Token(int n, String s, int k, FirToHir pfHir) {
        this.lineNo = n;
        this.lexem = s.intern();
        this.kind = k;
        this.addFHir(pfHir);
    }

    Token(int n, String s, int k) {
        this(n, s, k, null);
    }

    public Token addFHir(FirToHir pfHir) {
        this.fHir = pfHir;
        if (this.fHir != null) {
            this.fHirUtil = this.fHir.getHirUtility();
            this.fTypeUtil = this.fHir.getTypeUtility();
        }
        return this;
    }

    public Token setKind(int k) {
        this.kind = k;
        return this;
    }

    public String changeLexem() {
        this.lexem = (this.lexem + "_").intern();
        return this.lexem;
    }

    public Token copy() {
        return new Token(this.lineNo, this.lexem, this.kind, this.fHir);
    }

    public Token copy(String l) {
        return new Token(this.lineNo, l.intern(), this.kind, this.fHir);
    }

    public String toString() {
        return "line:" + this.lineNo + " \"" + this.lexem + "\" " + this.kindName();
    }

    public void print(int level, String spaces) {
        this.fHir.debugPrint(level, spaces + this.toString() + "\n");
    }

    public int getKind() {
        return this.kind;
    }

    public String getLexem() {
        return this.lexem;
    }

    public String kindName() {
        switch (this.kind) {
            case 269: {
                return "REAL";
            }
            case 268: {
                return "INTEGER";
            }
            case 271: {
                return "DOUBLE_PREC";
            }
            case 272: {
                return "LOGICAL";
            }
            case 270: {
                return "COMPLEX";
            }
            case 273: {
                return "CHARACTER";
            }
            case 285: {
                return "DIMENSION";
            }
            case 305: {
                return "PROGRAM";
            }
            case 261: {
                return "IDENT";
            }
            case 275: {
                return "LET";
            }
            case 257: {
                return "REAL_CONST";
            }
            case 260: {
                return "DOUBLE_CONST";
            }
            case 259: {
                return "INT_CONST";
            }
            case 290: {
                return "END";
            }
            case 264: {
                return "EOS";
            }
            case 263: {
                return "LABEL";
            }
            case 262: {
                return "LABEL_DEF";
            }
            case 258: {
                return "CHAR_CONST";
            }
        }
        return "" + this.kind;
    }

    public Exp makeIdentExp() {
        Var lVar;
        Exp const_e = this.fDeclMgr.getConstManager().getConstExp(this.lexem);
        if (const_e != null) {
            this.dp("makeExp from token(" + this.lexem + ") as constant");
            return const_e;
        }
        if (this.fDeclMgr.isEquivVariable(this.lexem)) {
            this.dp("- makeExp from token(" + this.lexem + ") as equivalence variable");
            return this.fDeclMgr.makeEquivVariableExp(this.lexem);
        }
        if (this.fDeclMgr.isBlockVariable(this.lexem)) {
            this.dp("- makeExp from token(" + this.lexem + ") as a part of block variable");
            return this.fDeclMgr.makeBlockVariableExp(this.lexem);
        }
        Sym lSym = this.fDeclMgr.searchSymOrAddVar(this.lexem);
        Type lType = lSym.getSymType();
        HIR hir = this.fDeclMgr.hir;
        if (lSym instanceof Subp) {
            HeaderStmt header = this.fDeclMgr.getProgramHeader();
            if (header.getLexem() == this.lexem) {
                this.dp("- At makeExp, function name identifier: " + this.lexem);
                return header.getReturnVarToken().makeExp();
            }
            if (this.fDeclMgr.isDefinedInLocal(lSym)) {
                this.dp("- Token#makeExp/External Exp: " + this.lexem);
                return hir.exp(64, hir.subpNode((Subp)lSym));
            }
            this.dp("- Token#makeExp from token(" + this.lexem + ") as variable");
            return hir.varNode(this.fDeclMgr.defineVar(this.lexem));
        }
        if (lSym instanceof Var) {
            lVar = (Var)lSym;
        } else {
            this.fHir.printMsgFatal("not a variable/subprogram " + this + "(" + lSym.getClass() + ")");
            lVar = this.fDeclMgr.searchOrAddVar(this.lexem);
        }
        if (lVar instanceof Param) {
            if (lType instanceof StmtFuncParamType) {
                StmtFuncParamType stmtFuncParamType = (StmtFuncParamType)lType;
                SubscrOrFunCallNode stmtFunCall = stmtFuncParamType.getStmtFunCall();
                int paramIndex = stmtFuncParamType.getParamIndex();
                this.dp("- Token#makeExp from token(" + this.lexem + ") as StmtFuncParamType");
                return stmtFunCall.getAParamAt(paramIndex);
            }
            if ((lType = ((PointerType)lType).getPointedType()) instanceof StructType) {
                this.dp("- Token#makeExp(" + this.lexem + ") as complex parameter");
                return this.fHirUtil.makeComplexExp(hir.contentsExp(hir.varNode(lVar)));
            }
            this.dp("- Token#makeExp(" + this.lexem + ") as parameter variable");
            return hir.contentsExp(hir.varNode(lVar));
        }
        if (lType instanceof StructType) {
            this.dp("- Token#makeExp(" + this.lexem + ") as complex");
            return this.fHirUtil.makeComplexExpFromVar(lVar);
        }
        if (lType instanceof EntryType) {
            this.dp("- Token#makeExp(" + this.lexem + ") as entry");
            return this.fDeclMgr.getProgramHeader().getReturnVarToken().makeExp();
        }
        this.dp("- Token#makeExp(" + this.lexem + ") as variable");
        return hir.varNode(lVar);
    }

    public Exp makeExp() {
        this.fDeclMgr = this.fHir.getDeclManager();
        this.dp("Token#makeExp: " + this.getLexem() + " as " + this.kindName());
        switch (this.kind) {
            case 261: {
                Exp exp = this.makeIdentExp();
                Type type = exp.getType();
                if (this.fHir.getTypeUtility().isFortranCharacterType(type)) {
                    return this.fHirUtil.makeFortranCharacterExp(this.fHir.getHir().decayExp(exp), this.fTypeUtil.getFortranCharacterLengthExp(type, this));
                }
                return exp;
            }
            case 259: {
                return this.fHirUtil.makeIntConstNode(this.lexem);
            }
            case 257: {
                return this.fHirUtil.makeFloatConstNode(this.lexem);
            }
            case 258: {
                return this.fHirUtil.makeCharsConstNode(this.lexem);
            }
            case 266: {
                return this.fHirUtil.makeTrueConstNode();
            }
            case 267: {
                return this.fHirUtil.makeFalseConstNode();
            }
            case 260: {
                return this.fHirUtil.makeDoubleConstNode(this.lexem.replace('D', 'E'));
            }
        }
        if (this.lexem == "*") {
            return null;
        }
        this.fHir.printMsgFatal("unknown token " + this);
        return null;
    }

    public Exp makeArgAddr(FStmt pCallStmt) {
        this.fDeclMgr = this.fHir.getDeclManager();
        HIR hir = this.fDeclMgr.hir;
        switch (this.kind) {
            case 261: {
                Exp const_e = this.fDeclMgr.getConstManager().getConstArgAddr(this.getLexem(), pCallStmt);
                if (const_e != null) {
                    return const_e;
                }
                if (this.fDeclMgr.isEquivVariable(this.lexem)) {
                    this.dp("- Token#makeArgAddr(" + this.lexem + ") as equivalence variable");
                    return hir.exp(64, this.fDeclMgr.makeEquivVariableExp(this.lexem));
                }
                if (this.fDeclMgr.isBlockVariable(this.lexem)) {
                    this.dp("- Token#makeArgAddr(" + this.lexem + ") as a part of block variable");
                    return hir.exp(64, this.fDeclMgr.makeBlockVariableExp(this.lexem));
                }
                Sym lSym = this.fDeclMgr.searchSymOrAddVar(this.lexem);
                if (lSym instanceof Subp) {
                    HeaderStmt header = this.fDeclMgr.getProgramHeader();
                    if (header.getLexem() == this.lexem) {
                        this.dp("* At makeArgAddr, function name variable: " + this.lexem);
                        return header.getReturnVarToken().makeArgAddr(pCallStmt);
                    }
                    this.dp("Token#makeArgAddr: function name " + this.lexem);
                    return this.fHirUtil.makeSubpExp((Subp)lSym);
                }
                if (!(lSym instanceof Var)) {
                    this.fHir.printMsgFatal("undefined " + this.lexem);
                    return null;
                }
                Var lVar = (Var)lSym;
                Type lType = lVar.getSymType();
                if (lVar instanceof Param) {
                    return hir.varNode(lVar);
                }
                return hir.exp(64, hir.varNode(lVar));
            }
            case 263: {
                if (pCallStmt instanceof CallStmt) {
                    CallStmt callStmt = (CallStmt)pCallStmt;
                    callStmt.fLabels.addLast(this);
                    callStmt.hasAltReturn = true;
                    return null;
                }
                this.fHir.printMsgFatal("label as argument");
                return null;
            }
            case 257: 
            case 259: 
            case 260: {
                return this.fHirUtil.makeArgAddr(pCallStmt, this.makeExp());
            }
            case 258: {
                return ((FortranCharacterExp)this.makeExp()).getBody();
            }
            case 266: 
            case 267: {
                return this.fHirUtil.makeArgAddr(pCallStmt, this.makeExp());
            }
        }
        this.fHir.printMsgFatal("unknown token " + this);
        return null;
    }

    void dp(String str) {
        this.fHir.dp(str);
    }

    public FNumber getConstValue() {
        switch (this.kind) {
            case 259: {
                return FNumber.make(Integer.parseInt(this.lexem));
            }
            case 257: {
                return FNumber.make(Float.parseFloat(this.lexem));
            }
            case 260: {
                return FNumber.make(Double.parseDouble(this.lexem));
            }
            case 261: {
                return this.fHir.getDeclManager().getConstManager().getConstValue(this.lexem);
            }
        }
        return null;
    }

    public int getLineNo() {
        return this.lineNo;
    }
}

