/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.FStmt;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.I77Utils;
import coins.ffront.Node;
import coins.ffront.Pair;
import coins.sym.Sym;

class ReadStmt
extends FStmt {
    FirList ciList;
    FirList optIoList;
    Node fmt_;
    boolean fmt_given_ = false;

    public ReadStmt(FirList cList, FirList ioList, int line, FirToHir pfHir) {
        super(line, pfHir);
        this.fmt_ = null;
        this.ciList = cList;
        this.optIoList = ioList;
    }

    public ReadStmt(Node fmt, FirList ioList, int line, FirToHir pfHir) {
        super(line, pfHir);
        this.fmt_ = fmt;
        this.fmt_given_ = true;
        this.optIoList = ioList;
        this.ciList = null;
    }

    public void print(int level, String spaces) {
        super.print(level, spaces);
        this.fHir.debugPrint(level, spaces + "ReadStmt" + "\n");
        if (this.ciList != null) {
            this.ciList.print(level, spaces + "cfg  ");
        }
        if (this.optIoList != null) {
            this.optIoList.print(level, spaces + "out  ");
        }
    }

    public String toString() {
        return super.toString() + " READ statement";
    }

    public void process() {
        I77Utils i77utils = new I77Utils(this.fHir);
        Sym sym = this.fHir.getSym();
        i77utils.readInit(this.ciList, this.fmt_, this.fmt_given_);
        this.addGeneratedStmt(i77utils.io_start());
        if (this.optIoList != null) {
            for (Node n : this.optIoList) {
                if (n instanceof Pair) {
                    this.addGeneratedStmt(i77utils.dolist((Pair)n));
                    continue;
                }
                this.addGeneratedStmt(i77utils.io_do(n));
            }
        }
        this.addGeneratedStmt(i77utils.io_end());
        super.process();
    }
}

