/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.FStmt;
import coins.ffront.FirToHir;
import coins.ffront.Node;
import coins.ffront.Quad;
import coins.ffront.Token;
import coins.ffront.UnaryNode;
import coins.ir.hir.Exp;
import coins.ir.hir.Stmt;

public class LabeledDoStmt
extends FStmt {
    private Token doLabel;
    private Quad doSpec;
    private Exp leftExp;
    private boolean stepIsPositive = true;

    public LabeledDoStmt(Token pLabel, Node pDoSpec, int line, FirToHir pfHir) {
        super(line, pfHir);
        this.doLabel = pLabel;
        this.doSpec = (Quad)pDoSpec;
    }

    public void print(int level, String spaces) {
        super.print(level, spaces);
        this.dp("LabeledDo " + this.doLabel + "\n");
        this.doLabel.print(level, spaces + "  ");
        this.doSpec.print(level, spaces + "  ");
    }

    public String toString() {
        return super.toString() + " LabeledDoStmt statement " + this.doLabel;
    }

    public void process() {
        super.process();
    }

    public String getDoLabelString() {
        return this.doLabel.getLexem();
    }

    public Stmt makeInitStmt() {
        this.leftExp = this.doSpec.left.makeExp();
        Exp initExp = this.doSpec.right.makeExp();
        initExp = this.fHirUtil.checkAssignExpType(this.leftExp, initExp);
        this.stmt = this.fHirUtil.makeAssignStmt(this.leftExp, initExp);
        return this.stmt;
    }

    public Exp makeCondExp() {
        int relOp = this.stepIsPositive ? 56 : 54;
        return this.hir.exp(relOp, this.leftExp, this.doSpec.extra.makeExp());
    }

    public Stmt makeStepStmt() {
        Exp stepExp;
        Node optStep = this.doSpec.last;
        if (optStep == null) {
            stepExp = this.fHirUtil.makeConstInt1Node();
        } else {
            stepExp = optStep.makeExp();
            if (optStep instanceof UnaryNode && ((UnaryNode)optStep).op == 63) {
                this.stepIsPositive = false;
            }
        }
        stepExp = this.fHirUtil.checkAssignExpType(this.leftExp, stepExp);
        Exp binaryExp = this.hir.exp(38, this.leftExp, stepExp);
        return this.fHirUtil.makeAssignStmt(this.leftExp, binaryExp);
    }
}

