/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.BaseManager;
import coins.ffront.CommonManager;
import coins.ffront.DeclManager;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.Node;
import coins.ffront.Pair;
import coins.ffront.Token;
import coins.ir.IrList;
import coins.ir.hir.Exp;
import coins.ir.hir.QualifiedExp;
import coins.ir.hir.VarNode;
import coins.sym.Elem;
import coins.sym.StructType;
import coins.sym.Sym;
import coins.sym.SymTable;
import coins.sym.Type;
import coins.sym.UnionType;
import coins.sym.Var;
import coins.sym.VectorType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class EquivManager
extends BaseManager {
    Map id_to_variable_table_ = new HashMap();
    List equivalence_variables_list_;
    Map in_block_var_table_ = new HashMap();
    SymTable global_symbol_table_;
    SymTable current_sym_table_;
    String unit_name_;
    DeclManager fDeclMgr;
    CommonManager fCommonMgr;

    EquivManager(FirToHir fth, CommonManager cmgr, DeclManager declm) {
        super(fth);
        this.equivalence_variables_list_ = new LinkedList();
        this.fDeclMgr = declm;
        this.fCommonMgr = cmgr;
    }

    Exp makeExp(String ident) {
        Exp exp;
        Var v = (Var)this.id_to_variable_table_.get(ident);
        String block_var_id = (String)this.in_block_var_table_.get(ident);
        if (block_var_id != null) {
            Elem e1 = this.fTypeUtil.searchElem((this.fCommonMgr.unit_name_ + "_" + block_var_id).intern(), v.getSymType());
            Elem e2 = this.fTypeUtil.searchElem(ident, e1.getSymType());
            Elem e3 = this.fTypeUtil.searchElem("val", e2.getSymType());
            exp = this.hir.qualifiedExp(this.hir.qualifiedExp(this.hir.qualifiedExp(this.hir.varNode(v), this.hir.elemNode(e1)), this.hir.elemNode(e2)), this.hir.elemNode(e3));
        } else {
            Elem ue = this.fTypeUtil.searchElem(ident, v.getSymType());
            Elem se = this.fTypeUtil.searchElem("val", ue.getSymType());
            VarNode ve = this.hir.varNode(v);
            QualifiedExp qe = this.hir.qualifiedExp(ve, this.hir.elemNode(ue));
            exp = this.hir.qualifiedExp(qe, this.hir.elemNode(se));
        }
        this.dp("make Equivalence var exp: " + ident);
        if (this.fTypeUtil.isComplexType(exp.getType())) {
            exp = this.fHirUtil.makeComplexExp(exp);
        }
        return exp;
    }

    Sym symEquivVariable(String ident) {
        Var v = (Var)this.id_to_variable_table_.get(ident);
        String block_var_id = (String)this.in_block_var_table_.get(ident);
        if (block_var_id != null) {
            Elem e1 = this.fTypeUtil.searchElem((this.fCommonMgr.unit_name_ + "_" + block_var_id).intern(), v.getSymType());
            Elem e2 = this.fTypeUtil.searchElem(ident, e1.getSymType());
            Elem e3 = this.fTypeUtil.searchElem("val", e2.getSymType());
            return e3;
        }
        Elem ue = this.fTypeUtil.searchElem(ident, v.getSymType());
        Elem se = this.fTypeUtil.searchElem("val", ue.getSymType());
        return se;
    }

    boolean isEquivVariable(String ident) {
        return this.id_to_variable_table_.get(ident) != null;
    }

    void processEquiv(String unit_name) {
        this.unit_name_ = ("p_unit_" + unit_name).intern();
        this.makeEquivVarsList();
        Iterator it = this.equivalence_variables_list_.iterator();
        int i = 0;
        while (it.hasNext()) {
            Type equivType;
            EquivGroup eg = (EquivGroup)it.next();
            String ident = "_equiv_in_" + this.unit_name_ + ++i;
            String block_var_id = eg.searchBlockVariable();
            if (block_var_id != null) {
                UnionType global_block_type = this.fCommonMgr.getGlobalBlockVarType(block_var_id);
                String elem_id = (this.fCommonMgr.unit_name_ + "_" + block_var_id).intern();
                equivType = eg.makeEquivTypeUnder(global_block_type.getSymTable());
                global_block_type.addElem(this.sym.defineElem(elem_id, equivType));
                eg.addIDsToTable(this.fCommonMgr.getGlobalBlockVar(block_var_id));
                global_block_type.finishUnionType(true);
            } else {
                equivType = eg.makeEquivTypeUnder(this.symRoot.symTableCurrent);
                Var v = this.sym.defineVar(ident, equivType);
                eg.addIDsToTable(v);
            }
            this.dp("Equivalence Variable: " + ident);
        }
    }

    void makeEquivVarsList() {
        for (FirList eql_line : this.fHir.f7Sym.equivList) {
            for (FirList eq_grp : eql_line) {
                EquivGroup eg = this.findAndAddToEquivGroup(eq_grp);
                if (eg == null) continue;
                this.equivalence_variables_list_.add(eg);
            }
        }
    }

    EquivGroup findAndAddToEquivGroup(FirList n) {
        for (EquivGroup eg : this.equivalence_variables_list_) {
            if (!eg.isContainNodes(n)) continue;
            eg.addElems(n);
            return null;
        }
        return new EquivGroup(n);
    }

    class EquivGroup {
        Map table_ = new HashMap();

        EquivGroup(FirList vars) {
            this.addElems(vars, 0);
        }

        void addIDsToTable(Var v) {
            Iterator it = this.table_.keySet().iterator();
            String block_id = null;
            while (it.hasNext()) {
                String ident = (String)it.next();
                if (!EquivManager.this.fCommonMgr.isBlockVariable(ident)) {
                    EquivManager.this.id_to_variable_table_.put(ident, v);
                    continue;
                }
                block_id = ident;
            }
            if (block_id != null) {
                for (String ident : this.table_.keySet()) {
                    if (EquivManager.this.fCommonMgr.isBlockVariable(ident)) continue;
                    EquivManager.this.in_block_var_table_.put(ident, block_id);
                }
            }
        }

        void addElems(FirList vars) {
            for (Node n : vars) {
                if (!this.isContainNode(n)) continue;
                this.addElems(vars, this.getHeight(this.getNodeLexem(n)) - this.getNodeHeight(n));
                break;
            }
        }

        void addElems(FirList vars, int base) {
            for (Node n : vars) {
                if (this.isContainNode(n)) continue;
                String ident = this.getNodeLexem(n);
                Type type = this.getNodeType(n);
                int height = this.getNodeHeight(n);
                this.table_.put(ident, new EquivElem(ident, type, height + base));
            }
        }

        int getNodeHeight(Node n) {
            String id = this.getNodeLexem(n);
            boolean is_block_var = EquivManager.this.fCommonMgr.isBlockVariable(id);
            if (n instanceof Pair) {
                Type type = this.getNodeType(n);
                if (type == null) {
                    EquivManager.this.printMsgFatal("subscript on not dimension variable: " + id);
                }
                if (type instanceof VectorType) {
                    VectorType vt = (VectorType)type;
                    long elem_size = vt.getElemType().getSizeValue();
                    if (elem_size == 0L) {
                        EquivManager.this.printMsgFatal("unknown table size");
                    }
                    FirList dims = (FirList)((Pair)n).getRight();
                    Iterator dit = dims.iterator();
                    int[] dimcount = new int[7];
                    int[] dimsize = new int[7];
                    int d = 0;
                    int h = 0;
                    type = vt;
                    while (dit.hasNext()) {
                        vt = (VectorType)type;
                        Token t = (Token)dit.next();
                        dimsize[d] = (int)vt.getElemType().getSizeValue();
                        dimcount[d] = (int)((long)t.getConstValue().intValue() - vt.getLowerBound());
                        type = vt.getElemType();
                        ++d;
                    }
                    for (int i = 0; i < d; ++i) {
                        h += dimcount[i] * dimsize[d - i - 1];
                    }
                    if (is_block_var) {
                        h += EquivManager.this.fCommonMgr.getHeightOnBlockVar(id);
                    }
                    return h;
                }
            } else {
                if (is_block_var) {
                    return EquivManager.this.fCommonMgr.getHeightOnBlockVar(id);
                }
                return 0;
            }
            EquivManager.this.printMsgFatal("unknown equivalence target type variable: " + id);
            return 0;
        }

        int getHeight(String ident) {
            EquivElem e = (EquivElem)this.table_.get(ident);
            return e.height_;
        }

        int getMaxHeight() {
            int max = 0;
            Iterator it = this.table_.keySet().iterator();
            while (it.hasNext()) {
                EquivElem ee = (EquivElem)this.table_.get(it.next());
                max = max < ee.height_ ? ee.height_ : max;
            }
            return max;
        }

        String searchBlockVariable() {
            Iterator it = this.table_.keySet().iterator();
            while (it.hasNext()) {
                EquivElem ee = (EquivElem)this.table_.get(it.next());
                if (!EquivManager.this.fCommonMgr.isBlockVariable(ee.ident_)) continue;
                return ee.ident_;
            }
            return null;
        }

        Type makeEquivTypeUnder(SymTable c_table) {
            Object b_table = null;
            SymTable current_table = EquivManager.this.symRoot.symTableCurrent;
            EquivManager.this.symRoot.symTableCurrent = c_table;
            Iterator it = this.table_.keySet().iterator();
            IrList list = EquivManager.this.hir.irList();
            int max = this.getMaxHeight();
            while (it.hasNext()) {
                EquivElem ee = (EquivElem)this.table_.get(it.next());
                if (EquivManager.this.fDeclMgr.isBlockVariable(ee.ident_)) {
                    if (ee.height_ == max) continue;
                    EquivManager.this.printMsgFatal("Can't extend common block by equivalence: " + ee.ident_);
                    continue;
                }
                list.add(this.addUnionElem(ee, max, c_table));
            }
            Sym tag = c_table.generateTag();
            UnionType utype = EquivManager.this.sym.unionType(list, tag);
            tag.setSymType(utype);
            utype.setSymTable(c_table);
            tag.setSymType(utype);
            EquivManager.this.symRoot.symTableCurrent = current_table;
            utype.finishUnionType(true);
            return utype;
        }

        Elem addUnionElem(EquivElem ee, int max, SymTable c_table) {
            IrList list = EquivManager.this.hir.irList();
            SymTable current_table = EquivManager.this.symRoot.symTableCurrent;
            SymTable b_table = EquivManager.this.symRoot.symTableCurrent.pushSymTable(null);
            int h = max - ee.height_;
            if (h != 0) {
                VectorType vt = EquivManager.this.sym.vectorType(EquivManager.this.fTypeUtil.getCharType(), h);
                list.add(EquivManager.this.sym.defineElem("padding", vt));
            }
            list.add(EquivManager.this.sym.defineElem("val", ee.type_));
            Sym s = current_table.searchLocal(ee.ident_, 8);
            if (s != null) {
                s.remove();
            }
            EquivManager.this.symRoot.symTableCurrent.reopenSymTable(current_table);
            Sym tag = c_table.generateTag();
            StructType stype = EquivManager.this.sym.structType(list, tag);
            stype.setSymTable(b_table);
            tag.setSymType(stype);
            return EquivManager.this.sym.defineElem(ee.ident_, stype);
        }

        boolean isContainNode(Node n) {
            String ident = this.getNodeLexem(n);
            return this.table_.get(ident) != null;
        }

        boolean isContainNodes(FirList vars) {
            for (Node n : vars) {
                if (!this.isContainNode(n)) continue;
                return true;
            }
            return false;
        }

        String getNodeLexem(Node n) {
            return n instanceof Token ? ((Token)n).getLexem() : ((Token)((Pair)n).getLeft()).getLexem();
        }

        Type getNodeType(Node n) {
            String id = this.getNodeLexem(n);
            Sym s = EquivManager.this.fDeclMgr.isBlockVariable(id) ? EquivManager.this.fDeclMgr.symBlockVariable(id) : EquivManager.this.fDeclMgr.searchOrAddVar(id);
            return s.getSymType();
        }

        public String toString() {
            StringBuffer ret = new StringBuffer("--\n");
            Iterator it = this.table_.keySet().iterator();
            while (it.hasNext()) {
                EquivElem ee = (EquivElem)this.table_.get(it.next());
                ret.append("  * ");
                ret.append(ee.toString() + "/" + (this.getMaxHeight() - ee.height_) + "\n");
            }
            return ret.toString();
        }

        class EquivElem {
            public String ident_;
            public Type type_;
            public int height_;

            EquivElem(String id, Type t, int h) {
                EquivManager.this.dp("EquivElem: " + id);
                this.ident_ = id;
                this.type_ = t;
                this.height_ = h;
            }

            public String toString() {
                return "(" + this.ident_ + " as " + this.type_ + "(" + this.height_ + "))";
            }
        }
    }
}

