/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.BaseManager;
import coins.ffront.DeclManager;
import coins.ffront.FirList;
import coins.ffront.FirToHir;
import coins.ffront.Pair;
import coins.ffront.Token;
import coins.ir.IrList;
import coins.ir.hir.Exp;
import coins.sym.Elem;
import coins.sym.StructType;
import coins.sym.Sym;
import coins.sym.SymTable;
import coins.sym.Type;
import coins.sym.UnionType;
import coins.sym.Var;
import coins.sym.VectorType;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;

public class CommonManager
extends BaseManager {
    Map id_table_ = new HashMap();
    Map bk_table_ = new HashMap();
    SymTable g_sym_table_;
    SymTable c_sym_table_;
    String unit_name_;
    DeclManager fDeclMgr;

    CommonManager(FirToHir fth, DeclManager declm) {
        super(fth);
        this.fDeclMgr = declm;
    }

    void processCommon(String unit_name) {
        this.g_sym_table_ = this.symRoot.symTableRoot;
        this.c_sym_table_ = this.symRoot.symTableCurrent;
        this.symRoot.symTableCurrent.reopenSymTable(this.g_sym_table_);
        this.unit_name_ = ("p_unit_" + unit_name).intern();
        for (Pair p : this.fHir.f7Sym.commonList) {
            Token t = (Token)p.getLeft();
            String block_name = t == null ? "__ANONYMOUS_BLOCK__" : "BLOCK__" + t.getLexem() + "__";
            block_name = block_name.intern();
            FirList block_vars = (FirList)p.getRight();
            FirList registed_vars = (FirList)this.bk_table_.get(block_name);
            if (registed_vars != null) {
                registed_vars.addAll(block_vars);
                continue;
            }
            this.bk_table_.put(block_name, block_vars);
        }
        for (String block_name : this.bk_table_.keySet()) {
            FirList vars = (FirList)this.bk_table_.get(block_name);
            this.makeBlockStructure(block_name, vars);
        }
        this.symRoot.symTableCurrent.reopenSymTable(this.c_sym_table_);
    }

    void makeBlockStructure(String name, FirList list) {
        SymTable base_table;
        UnionType union_type;
        Sym tag;
        Iterator it = list.iterator();
        StructType bk_type = null;
        IrList elems = this.hir.irList();
        Sym block_parent = this.g_sym_table_.searchLocal(name, 8);
        if (block_parent == null) {
            tag = this.g_sym_table_.generateTag(("tag_" + name).intern());
            union_type = this.sym.unionType(this.hir.irList(), tag);
            tag.setSymType(union_type);
            union_type.setSymTable(this.g_sym_table_);
            base_table = this.g_sym_table_.pushSymTable(null);
            this.g_sym_table_.popSymTable();
            union_type.setSymTable(base_table);
            block_parent = this.defineGlobalVal(name, union_type);
        } else {
            union_type = (UnionType)block_parent.getSymType();
            base_table = union_type.getSymTable();
        }
        this.g_sym_table_.reopenSymTable(base_table);
        base_table.pushSymTable(null);
        while (it.hasNext()) {
            Type type;
            Pair p = (Pair)it.next();
            Token t = (Token)p.getLeft();
            FirList dims = (FirList)p.getRight();
            String ident = t.getLexem();
            Sym s = this.c_sym_table_.searchLocal(ident, 8);
            if (s != null) {
                type = s.getSymType();
                s.remove();
            } else {
                type = this.fDeclMgr.getImplicitType(ident);
            }
            if (dims != null) {
                Type vtype;
                if (s != null && (vtype = s.getSymType()) instanceof VectorType && !this.fTypeUtil.isFortranCharacterVectorType((VectorType)vtype)) {
                    this.printMsgFatal("Can't put this array in block. Already defined: " + ident);
                    continue;
                }
                type = this.fTypeUtil.getArrayType(type, dims, this.fDeclMgr);
            }
            elems.add(this.sym.defineElem(ident, type));
            this.id_table_.put(ident, block_parent);
            this.dp("common val : " + ident + " as " + type);
        }
        this.g_sym_table_.reopenSymTable(base_table);
        tag = base_table.generateTag();
        bk_type = this.sym.structType(elems, tag);
        tag.setSymType(bk_type);
        tag.setFlag(15, true);
        bk_type.setSymTable(base_table);
        union_type.addElem(this.sym.defineElem(this.unit_name_, bk_type));
        union_type.finishUnionType(false);
        this.g_sym_table_.reopenSymTable(this.g_sym_table_);
    }

    Var defineGlobalVal(String ident, Type type) {
        Var v = null;
        v = (Var)this.g_sym_table_.define(ident, 8, null);
        v.setSymType(type);
        v.setVisibility(2);
        v.setStorageClass(6);
        return v;
    }

    Exp makeExp(String ident) {
        Var bkvar = (Var)this.id_table_.get(ident);
        if (bkvar == null) {
            this.printMsgFatal("no such block variable : " + ident);
            return null;
        }
        Elem belem = this.fTypeUtil.searchElem(this.unit_name_, bkvar.getSymType());
        Elem elem = this.fTypeUtil.searchElem(ident, belem.getSymType());
        Exp exp = this.hir.qualifiedExp(this.hir.qualifiedExp(this.hir.varNode(bkvar), this.hir.elemNode(belem)), this.hir.elemNode(elem));
        this.dp("Common Var: " + ident);
        this.dp("Common exp: " + exp);
        if (this.fTypeUtil.isComplexType(exp.getType())) {
            exp = this.fHirUtil.makeComplexExp(exp);
        }
        return exp;
    }

    boolean isBlockVariable(String ident) {
        return this.id_table_.get(ident) != null;
    }

    Sym symBlockVariable(String ident) {
        Var bkvar = (Var)this.id_table_.get(ident);
        if (bkvar == null) {
            this.printMsgFatal("no such block variable : " + ident);
            return null;
        }
        Elem belem = this.fTypeUtil.searchElem(this.unit_name_, bkvar.getSymType());
        Elem elem = this.fTypeUtil.searchElem(ident, belem.getSymType());
        return elem;
    }

    UnionType getGlobalBlockVarType(String ident) {
        Var bkvar = (Var)this.id_table_.get(ident);
        if (bkvar == null) {
            this.printMsgFatal("no such block variable : " + ident);
            return null;
        }
        return (UnionType)bkvar.getSymType();
    }

    Var getGlobalBlockVar(String ident) {
        Var bkvar = (Var)this.id_table_.get(ident);
        if (bkvar == null) {
            this.printMsgFatal("no such block variable : " + ident);
            return null;
        }
        return bkvar;
    }

    int getHeightOnBlockVar(String ident) {
        int height = 0;
        Var bkvar = (Var)this.id_table_.get(ident);
        if (bkvar == null) {
            this.printMsgFatal("no such block variable: " + ident);
            return -1;
        }
        Elem belem = this.fTypeUtil.searchElem(this.unit_name_, bkvar.getSymType());
        IrList list = ((StructType)belem.getSymType()).getElemList();
        ListIterator it = list.iterator();
        while (it.hasNext()) {
            Elem elem = (Elem)it.next();
            if (elem.getName() == ident) {
                return height;
            }
            height = (int)((long)height + elem.getSymType().getSizeValue());
        }
        this.printMsgFatal("no such block variable: " + ident);
        return -1;
    }

    void setInitialValue(String lexem, Exp exp) {
    }

    void commitInitialValue() {
    }
}

