/*
 * Decompiled with CFR 0.152.
 */
package coins.ffront;

import coins.ffront.FStmt;
import coins.ffront.FirToHir;
import coins.ffront.Node;
import coins.ffront.Token;
import coins.ir.hir.Exp;
import coins.ir.hir.Stmt;
import coins.ir.hir.VarNode;
import coins.sym.Type;

public class ArithIfStmt
extends FStmt {
    private Node fExp;
    private Token fMinusLab;
    private Token fZeroLab;
    private Token fPlusLab;

    public ArithIfStmt(Node pNode, Token pMinusLab, Token pZeroLab, Token pPlusLab, int line, FirToHir pfHir) {
        super(line, pfHir);
        this.fExp = pNode;
        this.fMinusLab = pMinusLab;
        this.fZeroLab = pZeroLab;
        this.fPlusLab = pPlusLab;
    }

    public void print(int level, String spaces) {
        super.print(level, spaces);
        this.dp("= ArithIfStmt\n");
        this.fExp.print(level, spaces + "  ");
        this.fMinusLab.print(level, spaces + "  ");
        this.fZeroLab.print(level, spaces + "  ");
        this.fPlusLab.print(level, spaces + "  ");
    }

    public String toString() {
        return super.toString() + "ArithIf statement";
    }

    public void process() {
        Exp lExp = this.fExp.makeExp();
        Type lType = lExp.getType();
        Exp constZeroNode = this.fHirUtil.makeTyped0Node(lType);
        if (!(this.fExp instanceof Token)) {
            VarNode leftExp = this.hir.varNode(this.fESMgr.makeTempVar(lType));
            this.addGeneratedStmt(this.fHirUtil.makeAssignStmt(leftExp, lExp));
            lExp = leftExp;
        }
        Stmt gotoStmtMinus = this.fESMgr.makeGotoStmt(this.fMinusLab);
        Stmt gotoStmtZero = this.fESMgr.makeGotoStmt(this.fZeroLab);
        Stmt gotoStmtPlus = this.fESMgr.makeGotoStmt(this.fPlusLab);
        Exp minusExp = this.hir.exp(55, lExp, constZeroNode);
        Exp plusExp = this.hir.exp(53, lExp, constZeroNode);
        this.stmt = this.hir.ifStmt(minusExp, gotoStmtMinus, gotoStmtZero);
        this.stmt = this.hir.ifStmt(plusExp, gotoStmtPlus, this.stmt);
        super.process();
    }
}

