/*
 * Decompiled with CFR 0.152.
 */
package coins.drivergen.process;

import coins.HirRoot;
import coins.IoRoot;
import coins.PassException;
import coins.backend.util.ImList;
import coins.driver.CoinsOptions;
import coins.driver.CompileSpecification;
import coins.driver.Suffix;
import coins.driver.Trace;
import coins.drivergen.InputIr;
import coins.drivergen.Options;
import coins.drivergen.ProcessException;
import coins.drivergen.process.Navigator;
import coins.drivergen.process.Process;
import coins.hir2lir.ConvToNewLIR;
import coins.ir.hir.HIR;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class MakeNewLirFromHir
extends Process {
    public static final Navi navi = new Navi();
    private String myName = navi.name();

    MakeNewLirFromHir(InputIr ir, Options opt) {
        super(ir, opt);
    }

    public void go() throws ProcessException, PassException, IOException {
        HirRoot hirRoot = InputIr.hirRoot;
        IoRoot io = Options.io;
        Suffix suffix = Options.suffix;
        if (!this.canStart()) {
            throw new PassException(this.myName, "can't start this process");
        }
        if (suffix.getSuffixOption() != null) {
            this.opt.trace.trace(this.myName, 5000, "suffix option: " + suffix.getSuffixOption());
        }
        try {
            InputIr.sexp = this.makeNewLirFromHir(InputIr.hirRoot, Options.io, Options.sourceFile, Options.out);
        }
        catch (ProcessException e) {
            throw new ProcessException(this.opt, this.myName, "something");
        }
        catch (Exception e) {
            System.out.println(this.myName + " Fatal error");
        }
        InputIr.condition = 3;
    }

    public boolean canStart() {
        if (InputIr.hirRoot == null) {
            System.out.println("no ir.hirRoot");
            return false;
        }
        return InputIr.condition == 2;
    }

    private ImList makeNewLirFromHir(HirRoot hirRoot, IoRoot io, File sourceFile, OutputStream out) throws PassException {
        CompileSpecification spec = this.opt.spec;
        CoinsOptions coinsOptions = this.opt.coinsOptions;
        Trace trace = this.opt.trace;
        trace.trace(this.myName, 5000, "Make new LIR from HIR");
        if (trace.shouldTrace("HIR", 1)) {
            trace.trace("HIR", 1, "HIR before HirToNewLir conversion");
            ((HIR)hirRoot.programRoot).print(0, true);
        }
        if (trace.shouldTrace("Sym", 2)) {
            trace.trace("Sym", 2, "Sym before HirToNewLir conversion ");
            hirRoot.symRoot.symTable.printSymTableAll(hirRoot.symRoot.symTableRoot);
            hirRoot.symRoot.symTableConst.printSymTable();
        }
        ConvToNewLIR newconvert = new ConvToNewLIR(sourceFile, out, hirRoot);
        ImList sexp = newconvert.doConvert((HIR)hirRoot.programRoot);
        return sexp;
    }

    private static class Navi
    implements Navigator {
        private Navi() {
        }

        public String name() {
            return "MakeNewLirFromHir";
        }

        public String subject() {
            return "make Lir(new) from Hir.";
        }

        public int precondition() {
            return 2;
        }

        public int postcondition() {
            return 3;
        }

        public boolean isExternalCommand() {
            return false;
        }

        public void go(InputIr ir, Options op) {
            try {
                new MakeNewLirFromHir(ir, op).go();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }
}

