/*
 * Decompiled with CFR 0.152.
 */
package coins.drivergen.process;

import coins.HirRoot;
import coins.IoRoot;
import coins.PassException;
import coins.SymRoot;
import coins.casttohir.ToHir;
import coins.casttohir.ToHirBase;
import coins.casttohir.ToHirBaseOpt;
import coins.casttohir.ToHirC;
import coins.casttohir.ToHirC2;
import coins.casttohir.ToHirCOpt;
import coins.casttohir.ToHirCOpt2;
import coins.driver.CoinsOptions;
import coins.driver.CompileSpecification;
import coins.driver.Suffix;
import coins.driver.Trace;
import coins.drivergen.InputIr;
import coins.drivergen.Options;
import coins.drivergen.ProcessException;
import coins.drivergen.process.Navigator;
import coins.drivergen.process.Process;
import coins.ir.hir.HIR;
import coins.ir.hir.Program;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;

public class MakeHirFromSource
extends Process {
    public static final Navi navi = new Navi();
    private String myName = navi.name();

    MakeHirFromSource(InputIr ir, Options opt) {
        super(ir, opt);
    }

    public void go() throws ProcessException, PassException, IOException {
        if (!this.canStart()) {
            throw new PassException(this.myName, "can't start this process");
        }
        try {
            this.makeHirFromSource(Options.sourceFile, InputIr.hirRoot, Options.suffix, Options.in, Options.io);
        }
        catch (ProcessException e) {
            throw new ProcessException(this.opt, this.myName, "something");
        }
        catch (Exception e) {
            System.out.println(this.myName + " Fatal error");
            System.out.println(this.myName + " Fatal error " + e);
        }
        InputIr.condition = 2;
    }

    public boolean canStart() {
        return InputIr.condition == 1;
    }

    private HIR makeHirCFromCSource(HirRoot hirRoot, InputStream in, IoRoot io) throws IOException, PassException {
        CompileSpecification spec = this.opt.spec;
        Trace trace = this.opt.trace;
        trace.trace(this.myName, 5000, "makeHirCFromCSource");
        CoinsOptions coinsOptions = this.opt.coinsOptions;
        boolean fromcSpecified = false;
        if (coinsOptions.isSet("hirOpt")) {
            fromcSpecified = this.includedInDelimitedList("fromc", '/', coinsOptions.getArg("hirOpt"));
        }
        ToHir tohir = new ToHir(hirRoot, coinsOptions.isSet("oldlir"), fromcSpecified);
        new ToHirC(tohir).astToHirC(in);
        new ToHirC2(tohir).visitProgram();
        if (fromcSpecified) {
            new ToHirCOpt2(tohir).visitProgram();
        } else {
            new ToHirCOpt(tohir).visitProgram();
        }
        Program hir = (Program)hirRoot.programRoot;
        if (trace.shouldTrace("HIR", 4)) {
            trace.trace("HIR", 4, "\nHIR-C ");
            hir.setIndexNumberToAllNodes(1);
            hir.print(0);
        }
        if (io.addToTotalErrorCount(0) > 0) {
            throw new PassException(io.getSourceFile(), "Ast to HIR-C", "Error(s) in parsing source.");
        }
        return hir;
    }

    private HIR makeHirBaseFromC(HirRoot hirRoot, HIR hir, IoRoot io) throws IOException, PassException {
        CompileSpecification spec = this.opt.spec;
        CoinsOptions coinsOptions = this.opt.coinsOptions;
        Trace trace = this.opt.trace;
        trace.trace(this.myName, 5000, "makeHirBaseFromC");
        boolean fromcSpecified = false;
        if (coinsOptions.isSet("hirOpt")) {
            fromcSpecified = this.includedInDelimitedList("fromc", '/', coinsOptions.getArg("hirOpt"));
        }
        ToHir tohir = new ToHir(hirRoot, coinsOptions.isSet("oldlir"), fromcSpecified);
        new ToHirBase(tohir).visitProgram();
        if (fromcSpecified) {
            new ToHirBaseOpt(tohir).visitProgram();
        }
        hir.setIndexNumberToAllNodes(1);
        if (trace.shouldTrace("HIR", 3)) {
            trace.trace("HIR", 3, "\nHIR-base ");
            hir.print(0);
        }
        if (trace.shouldTrace("Sym", 3)) {
            trace.trace("Sym", 3, "\nSym after HIR generation ");
            SymRoot symroot = hirRoot.symRoot;
            symroot.symTable.printSymTableAllDetail(symroot.symTableRoot);
        }
        if (io.addToTotalErrorCount(0) > 0) {
            throw new PassException(io.getSourceFile(), "HIR-C to HIR-Base", "Error(s) in making HIR-Base.");
        }
        if (hir.isTree()) {
            trace.trace("HIR", 2, "\nHIR-base does not violate tree structure.");
        }
        return hir;
    }

    private HIR readHIR(File sourceFile, HirRoot hirRoot, InputStream in, IoRoot io) throws IOException, PassException {
        ObjectInputStream oin = new ObjectInputStream(in);
        try {
            return (HIR)oin.readObject();
        }
        catch (ClassNotFoundException e) {
            io.msgError.put(sourceFile + ": class not found: " + e.getMessage());
            throw new PassException(sourceFile, this.myName, "class not found: " + e.getMessage());
        }
    }

    private void makeHirFromSource(File sourceFile, HirRoot hirRoot, Suffix suffix, InputStream in, IoRoot io) throws IOException, PassException {
        if (suffix.getLanguageName().equals("C")) {
            hirRoot.programRoot = this.makeHirCFromCSource(hirRoot, in, io);
            hirRoot.programRoot = this.makeHirBaseFromC(hirRoot, (HIR)hirRoot.programRoot, io);
        } else if (suffix.getLanguageName().equals("HIR")) {
            hirRoot.programRoot = this.readHIR(sourceFile, hirRoot, in, io);
        } else {
            io.msgError.put(sourceFile + ": Unknown programming language: " + suffix.getLanguageName());
            throw new PassException(this.myName, "Unknown language " + suffix.getLanguageName());
        }
    }

    private boolean includedInDelimitedList(String term, char delimiter, String list) {
        int i;
        while ((i = list.indexOf(delimiter)) != -1) {
            if (term.equals(list.substring(0, i))) {
                return true;
            }
            list = list.substring(i + 1);
        }
        return term.equals(list);
    }

    private static class Navi
    implements Navigator {
        private Navi() {
        }

        public String name() {
            return "MakeHirFromSource";
        }

        public String subject() {
            return "make Hir from source file.";
        }

        public int precondition() {
            return 1;
        }

        public int postcondition() {
            return 2;
        }

        public boolean isExternalCommand() {
            return false;
        }

        public void go(InputIr ir, Options op) {
            try {
                new MakeHirFromSource(ir, op).go();
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
    }
}

