/*
 * Decompiled with CFR 0.152.
 */
package coins.driver;

import coins.FatalError;
import coins.driver.CommandLine;
import coins.driver.CompileSpecification;
import coins.driver.Suffix;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class SuffixFactory {
    public static final String DEFAULT_SUFFIX_FILE = "suffixes";
    private static final char COLUMN_DELIMITER = ',';
    private static final char SUFFIX_SPECS_DELIMITER = '/';
    private static final String OBJECT = "o";
    private static Map fSuffixTable;
    private static Suffix fObjectFileSuffix;
    private static String defaultSuffixRule;

    static void defaultInitialize(CompileSpecification pSpec) {
        pSpec.getTrace().trace("Driver", 9, "The inner default is used for suffix rule");
        SuffixFactory.initialize(defaultSuffixRule, pSpec);
    }

    static void initialize(CompileSpecification pSpec) {
        SuffixFactory.initialize(new File(DEFAULT_SUFFIX_FILE), pSpec);
    }

    static void initialize() {
        SuffixFactory.initialize(new CommandLine());
    }

    private static List splitString(String pString, char pDelimiter) {
        ArrayList<String> lBuffer = new ArrayList<String>();
        int lLen = pString.length();
        int lIndex = 0;
        while (lIndex < lLen) {
            String lNextPart;
            int lDelimiterIndex = pString.indexOf(pDelimiter, lIndex);
            if (lDelimiterIndex == -1) {
                lNextPart = pString.substring(lIndex).trim();
                lIndex = lLen;
            } else {
                lNextPart = pString.substring(lIndex, lDelimiterIndex).trim();
                lIndex = lDelimiterIndex + 1;
            }
            lBuffer.add(lNextPart);
        }
        return lBuffer;
    }

    static boolean initialize(BufferedReader pReader, String pFile, CompileSpecification pSpec) throws IOException {
        fSuffixTable = new Hashtable();
        String line = pReader.readLine();
        List lFields = SuffixFactory.splitString(line, ',');
        if (lFields.size() < 2 || !lFields.get(0).equals("#SRD")) {
            pSpec.getWarning().warning("Driver", "Suffix file (" + pFile + ") format error: " + (String)lFields.get(0));
            return false;
        }
        int formatVersion = Integer.parseInt((String)lFields.get(1));
        if (formatVersion == 2) {
            block4: while ((line = pReader.readLine()) != null) {
                lFields = SuffixFactory.splitString(line, ',');
                switch (lFields.size()) {
                    case 0: {
                        continue block4;
                    }
                    case 6: {
                        List lSuffixStrings = SuffixFactory.splitString((String)lFields.get(0), '/');
                        for (String lSuffixSpec : lSuffixStrings) {
                            String lSuffixOption;
                            String lSuffixString;
                            if (lSuffixSpec.endsWith(")")) {
                                lSuffixString = lSuffixSpec.substring(0, lSuffixSpec.indexOf(40)).trim();
                                lSuffixOption = lSuffixSpec.substring(lSuffixSpec.indexOf(40) + 1, lSuffixSpec.lastIndexOf(41)).trim();
                            } else {
                                lSuffixString = lSuffixSpec;
                                lSuffixOption = null;
                            }
                            Suffix s = new Suffix(lSuffixString, lSuffixOption, (String)lFields.get(1), (String)lFields.get(2), (String)lFields.get(3), (String)lFields.get(4), (String)lFields.get(5), !((String)lFields.get(3)).equals("-"), !((String)lFields.get(4)).equals("-"), !((String)lFields.get(5)).equals("-"));
                            s.checkIntegrity(pSpec);
                            if (lSuffixOption == null) {
                                fSuffixTable.put(lSuffixString, s);
                                continue;
                            }
                            fSuffixTable.put(lSuffixString + "(" + lSuffixOption + ")", s);
                        }
                        continue block4;
                    }
                }
                pSpec.getWarning().warning("Driver", "Suffix file (" + pFile + ") format error: " + (String)lFields.get(0));
            }
            fObjectFileSuffix = new Suffix(OBJECT, null, "object", "Object file", "-", "-", "-", false, false, false);
            return true;
        }
        pSpec.getWarning().warning("Driver", "Suffix file (" + pFile + ") unknown format version: " + formatVersion);
        return false;
    }

    static void initialize(File pFile, CompileSpecification pSpec) {
        try {
            BufferedReader lReader = new BufferedReader(new FileReader(pFile));
            if (!SuffixFactory.initialize(lReader, pFile.getAbsolutePath(), pSpec)) {
                SuffixFactory.defaultInitialize(pSpec);
            }
        }
        catch (IOException lException) {
            pSpec.getWarning().warning("Driver", "Cannot read suffix database file. Using default setting: " + lException.getMessage());
            SuffixFactory.defaultInitialize(pSpec);
        }
    }

    static void initialize(String pString, CompileSpecification pSpec) {
        try {
            StringReader lReader = new StringReader(pString);
            if (!SuffixFactory.initialize(new BufferedReader(lReader), "default suffix rule", pSpec)) {
                throw new FatalError("Internal error: a default suffix rule is wrong.");
            }
        }
        catch (IOException lException) {
            throw new FatalError("Internal error: IOException with StringReader");
        }
    }

    static void initialize(InputStream pIn, String pFile, CompileSpecification pSpec) {
        try {
            if (!SuffixFactory.initialize(new BufferedReader(new InputStreamReader(pIn)), pFile, pSpec)) {
                SuffixFactory.defaultInitialize(pSpec);
            }
        }
        catch (IOException lException) {
            pSpec.getWarning().warning("Driver", "Cannot read suffix database file. Using default setting: " + lException.getMessage());
            SuffixFactory.defaultInitialize(pSpec);
        }
    }

    public static Suffix getSuffix(File file) {
        return SuffixFactory.getSuffix(file, null);
    }

    public static synchronized Suffix getSuffix(File file, String option) {
        String lName;
        int lIndex;
        if (fSuffixTable == null) {
            SuffixFactory.initialize();
        }
        String lSuffix = (lIndex = (lName = file.getName()).lastIndexOf(46)) == -1 ? "" : lName.substring(lIndex + 1);
        return SuffixFactory.getSuffix(lSuffix, option);
    }

    public static Suffix getSuffix(String suffixString) {
        return SuffixFactory.getSuffix(suffixString, null);
    }

    public static Suffix getSuffix(String suffixString, String option) {
        String lSuffixSpec;
        if (option != null && !option.equals("") && fSuffixTable.containsKey(lSuffixSpec = suffixString + "(" + option + ")")) {
            return (Suffix)fSuffixTable.get(lSuffixSpec);
        }
        if (fSuffixTable.containsKey(suffixString)) {
            return (Suffix)fSuffixTable.get(suffixString);
        }
        return fObjectFileSuffix;
    }

    static {
        defaultSuffixRule = "#SRD, 2, Suffix rule DB file, format version 2\nc,\t\tC,\t\tC source,\t\t\t\ti,s,o\nc(out-newlir),\tC,\t\tC source,\t\t\t\ti,lir,-\ni,\t\tC,\t\tpreprocessed C source,\t\t\t-,s,o\ncc/cpp/cxx/C,\tC++,\t\tC++ source,\t\t\t\tii,s,o\nii,\t\tC++,\t\tpreprocessed C++ source,\t\t-,s,o\njava,\t\tJava,\t\tJava source,\t\t\t\t-,class,-\njava(native),\tJava,\t\tJava source (native compile),\t\t-,s,o\nf,\t\tFORTRAN,\tFORTRAN source,\t\t\t\t-,s,o\nlir,\t\tLIR,\t\tnew LIR,\t\t\t\t-,s,o\nS,\t\tAssembler,\tassembly source (need preprocess),\ts,-,o\ns,\t\tAssembler,\tassembly source,\t\t\t-,-,o\n";
    }
}

