/*
 * Decompiled with CFR 0.152.
 */
package coins.driver;

import coins.driver.CompileSpecification;
import coins.driver.SuffixFactory;
import coins.driver.Warning;

public class Suffix {
    private String fSuffixString;
    private String fSuffixOption;
    private String fDescription;
    private String fLanguageName;
    private String fAfterPreprocess;
    private String fAfterCompile;
    private String fAfterAssemble;
    boolean fIsPreprocessRequired;
    boolean fIsCompileRequired;
    boolean fIsAssembleRequired;

    Suffix(String pSuffixString, String pSuffixOption, String pLanguageName, String pDescription, String pAfterPreprocess, String pAfterCompile, String pAfterAssemble, boolean pIsPreprocessRequired, boolean pIsCompileRequired, boolean pIsAssembleRequired) {
        this.fSuffixString = pSuffixString;
        this.fSuffixOption = pSuffixOption;
        this.fDescription = pDescription;
        this.fLanguageName = pLanguageName;
        this.fAfterPreprocess = pAfterPreprocess;
        this.fAfterCompile = pAfterCompile;
        this.fAfterAssemble = pAfterAssemble;
        this.fIsPreprocessRequired = pIsPreprocessRequired;
        this.fIsCompileRequired = pIsCompileRequired;
        this.fIsAssembleRequired = pIsAssembleRequired;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public String getLanguageName() {
        return this.fLanguageName;
    }

    public String getSuffixOption() {
        return this.fSuffixOption;
    }

    public Suffix afterPreprocess() {
        return SuffixFactory.getSuffix(this.fAfterPreprocess);
    }

    public Suffix afterCompile() {
        return SuffixFactory.getSuffix(this.fAfterCompile);
    }

    public Suffix afterAssemble() {
        return SuffixFactory.getSuffix(this.fAfterAssemble);
    }

    public boolean isPreprocessRequired() {
        return this.fIsPreprocessRequired;
    }

    public boolean isCompileRequired() {
        return this.fIsCompileRequired;
    }

    public boolean isAssembleRequired() {
        return this.fIsAssembleRequired;
    }

    public String toString() {
        return this.fSuffixString;
    }

    private void sameSuffixWarning(String pPass, String pOpt, CompileSpecification pSpec) {
        Warning lWarning = pSpec.getWarning();
        lWarning.warning("Driver", "Suffix rule record " + this.fSuffixString + (this.fSuffixOption == null ? "" : "(" + this.fSuffixOption + ")") + ": a suffix after " + pPass + " is same as a source suffix (i.e., specifying " + pOpt + " will destroy the source file).");
    }

    void checkIntegrity(CompileSpecification pSpec) {
        if (this.fSuffixString.equals(this.fAfterPreprocess)) {
            this.sameSuffixWarning("preprocess", "-E", pSpec);
        }
        if (this.fSuffixString.equals(this.fAfterCompile)) {
            this.sameSuffixWarning("compile", "-S", pSpec);
        }
        if (this.fSuffixString.equals(this.fAfterAssemble)) {
            this.sameSuffixWarning("assemble", "-c", pSpec);
        }
    }
}

