/*
 * Decompiled with CFR 0.152.
 */
package coins.driver;

import coins.HirRoot;
import coins.IoRoot;
import coins.PassException;
import coins.SymRoot;
import coins.driver.CompileSpecification;
import coins.driver.Driver;
import coins.driver.Suffix;
import coins.ffront.F77Scanner;
import coins.ffront.Parser;
import coins.ir.hir.HIR;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class F77Driver
extends Driver {
    protected static final String LIBF2C_LOCATION = "libf2cLocation";

    public static void main(String[] args) {
        new F77Driver().go(args);
    }

    protected void setDefaultLinkerOptions(CompileSpecification spec, List options) {
        super.setDefaultLinkerOptions(spec, options);
        String s = this.defaultSettings.getProperty(LIBF2C_LOCATION);
        if (s != null && !s.equals("")) {
            options.add("-L" + s);
        }
        options.add("-lf2c");
        options.add("-lm");
    }

    protected HIR makeHirFromFortranSource(File sourceFile, HirRoot hirRoot, InputStream in, IoRoot io) throws IOException, PassException {
        F77Scanner scanner = null;
        SymRoot symRoot = hirRoot.symRoot;
        try {
            scanner = new F77Scanner(in, io);
        }
        catch (RuntimeException re) {
            throw re;
        }
        catch (Exception e) {
            io.msgError.put("syntax erorr: " + e.getMessage());
            throw new PassException(sourceFile, "FORTRAN preprocessor", "syntax error: " + e.getMessage());
        }
        Parser yyparser = new Parser(symRoot, hirRoot, io, scanner);
        try {
            yyparser.yyparse(scanner);
        }
        catch (Parser.yyException ye) {
            io.msgError.put("syntax error: " + ye.getMessage());
            throw new PassException(sourceFile, "FORTRAN parser", "syntax error: " + ye.getMessage());
        }
        if (io.getCompileSpecification().getCoinsOptions().isSet("printhir")) {
            hirRoot.programRoot.print(0);
            io.printOut.print("\n");
            symRoot.symTable.printSymTableAllDetail(symRoot.symTableRoot);
            symRoot.symTableConst.printSymTableDetail();
            io.printOut.print("\n");
        }
        return (HIR)hirRoot.programRoot;
    }

    protected void makeHirFromSource(File sourceFile, HirRoot hirRoot, Suffix suffix, InputStream in, IoRoot io) throws IOException, PassException {
        hirRoot.programRoot = this.makeHirFromFortranSource(sourceFile, hirRoot, in, io);
    }
}

