/*
 * Decompiled with CFR 0.152.
 */
package coins.cfront;

final class SymbolTable {
    private Entry[] entries;
    private int count = 0;
    private int threshold;
    private SymbolTable parent;

    public void show() {
        for (int i = 0; i < this.entries.length; ++i) {
            Entry e = this.entries[i];
            int n = 0;
            while (e != null) {
                ++n;
                e = e.next;
            }
            System.out.print(n + ",");
        }
        System.out.println(".");
    }

    public SymbolTable() {
        this(101, null);
    }

    public SymbolTable(SymbolTable _parent) {
        this(101, _parent);
    }

    public SymbolTable(int n, SymbolTable _parent) {
        this.entries = new Entry[n];
        this.threshold = n * 3 / 4;
        this.parent = _parent;
    }

    public SymbolTable getParent() {
        return this.parent;
    }

    public void putInt(String internalRep, int value) {
        this.put(internalRep, new Integer(value));
    }

    public int getInt(String internalRep) {
        Integer i = (Integer)this.get(internalRep);
        if (i == null) {
            return -1;
        }
        return i;
    }

    public Object get(String internalRep) {
        if (internalRep != null) {
            Entry[] ent = this.entries;
            int index = (System.identityHashCode(internalRep) & Integer.MAX_VALUE) % ent.length;
            Entry e = ent[index];
            while (e != null) {
                if (e.key == internalRep) {
                    return e.value;
                }
                e = e.next;
            }
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.get(internalRep);
    }

    public Object getLocal(String internalRep) {
        if (internalRep != null) {
            Entry[] ent = this.entries;
            int index = (System.identityHashCode(internalRep) & Integer.MAX_VALUE) % ent.length;
            Entry e = ent[index];
            while (e != null) {
                if (e.key == internalRep) {
                    return e.value;
                }
                e = e.next;
            }
        }
        return null;
    }

    public Object put(String internalRep, Object value) {
        if (internalRep == null) {
            return null;
        }
        Entry[] ent = this.entries;
        int hash = System.identityHashCode(internalRep);
        int index = (hash & Integer.MAX_VALUE) % ent.length;
        Entry e = ent[index];
        while (e != null) {
            if (e.key == internalRep) {
                Object old = e.value;
                e.value = value;
                return old;
            }
            e = e.next;
        }
        if (this.count >= this.threshold) {
            this.rehash();
            ent = this.entries;
            index = (hash & Integer.MAX_VALUE) % ent.length;
        }
        ent[index] = e = new Entry(internalRep, value, ent[index]);
        ++this.count;
        return null;
    }

    private void rehash() {
        int oldSize = this.entries.length;
        Entry[] oldEnt = this.entries;
        int newSize = (oldSize << 1) + 1;
        Entry[] newEnt = new Entry[newSize];
        this.threshold = newSize * 3 >> 2;
        this.entries = newEnt;
        int i = oldSize;
        while (i-- > 0) {
            Entry old = oldEnt[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (System.identityHashCode(e.key) & Integer.MAX_VALUE) % newSize;
                e.next = newEnt[index];
                newEnt[index] = e;
            }
        }
    }

    private class Entry {
        Entry next;
        Object key;
        Object value;

        Entry(Object k, Object v, Entry n) {
            this.next = n;
            this.key = k;
            this.value = v;
        }
    }
}

