/*
 * Decompiled with CFR 0.152.
 */
package coins.cfront;

import coins.ast.Declarator;
import coins.ast.TokenId;
import coins.ast.TypeId;
import coins.cfront.Lex;
import coins.cfront.OldFuncArgs;
import coins.cfront.ParseError;
import coins.cfront.Parser;

class EncodedType
implements TokenId,
TypeId {
    private static final int SIZE = 8;
    private int pos = 8;
    private byte[] buffer = new byte[8];
    private long arrayParamSize = 0L;
    private int storageClass = 0;
    public static int FUNCTION_TYPE_SIZE = -1;

    EncodedType() {
    }

    void clear() {
        this.pos = this.buffer.length;
    }

    char top() {
        return (char)(this.buffer[this.pos] & 0xFF);
    }

    void copy(EncodedType etype) {
        this.clear();
        this.insert(etype);
    }

    void insert(char c) {
        if (this.pos == 0) {
            this.increase();
        }
        this.buffer[--this.pos] = (byte)c;
    }

    void insert(String s) {
        int len = s.length();
        while (this.pos - len < 0) {
            this.increase();
        }
        while (len > 0) {
            this.buffer[--this.pos] = (byte)s.charAt(--len);
        }
    }

    void insert(byte[] b) {
        int len = b.length;
        while (this.pos - len < 0) {
            this.increase();
        }
        while (len > 0) {
            this.buffer[--this.pos] = b[--len];
        }
    }

    void insert(EncodedType etype) {
        byte[] src = etype.buffer;
        int srcPos = etype.pos;
        int srcLen = src.length;
        int len = srcLen - srcPos;
        while (this.pos - len < 0) {
            this.increase();
        }
        while (srcLen > srcPos) {
            this.buffer[--this.pos] = src[--srcLen];
        }
    }

    void insertCv(int cv) {
        int i;
        int cv_t;
        switch (cv) {
            case 303: {
                cv_t = 67;
                break;
            }
            case 319: {
                cv_t = 86;
                break;
            }
            default: {
                return;
            }
        }
        for (i = this.pos; i < this.buffer.length && (this.buffer[i] == 65 || this.buffer[i] == 63 || 48 <= this.buffer[i] && this.buffer[i] <= 57); ++i) {
        }
        if (this.buffer[i] == 67 ? cv_t == 67 || this.buffer[i + 1] == 86 : this.buffer[i] == 86 && (cv_t == 86 || this.buffer[i + 1] == 67)) {
            return;
        }
        this.insertCv(i, cv_t);
    }

    void insertCv(int insertpos, int cv_t) {
        if (this.pos == 0) {
            insertpos += this.buffer.length;
            this.increase();
        }
        for (int i = this.pos; i < insertpos; ++i) {
            this.buffer[i - 1] = this.buffer[i];
        }
        this.buffer[insertpos - 1] = (byte)cv_t;
        --this.pos;
    }

    void insertDim(long d) {
        if (d < 0L) {
            this.insert('?');
        } else if (d == 0L) {
            this.insert('0');
        } else {
            while (d > 0L) {
                this.insert((char)(48L + d % 10L));
                d /= 10L;
            }
        }
        this.insert('A');
    }

    void setArraySize(int n, Lex lex) throws ParseError {
        int i;
        char c1 = '\u0000';
        char c2 = '\u0000';
        byte[] type = this.buffer;
        int len = type.length;
        if (lex.fDbgLevel > 3) {
            lex.debug.print(5, " setArraySize " + n + " len " + len + " " + type);
        }
        if ((i = this.pos) < len) {
            char c = (char)(type[i] & 0xFF);
            if (c == 'C' || c == 'V') {
                c1 = c;
            } else if (c == 'S' || c == 'U') {
                c2 = c;
            } else {
                if (c == '<') {
                    return;
                }
                if (c == 'A') {
                    if ((type[i + 1] & 0xFF) == 63) {
                        this.pos = i + 2;
                        this.insertDim(n);
                        if (c1 != '\u0000') {
                            this.insert(c1);
                        }
                        if (c2 != '\u0000') {
                            this.insert(c2);
                        }
                        return;
                    }
                    if (EncodedType.getArraySize(type, i + 1) >= n) {
                        return;
                    }
                    throw new ParseError(lex, "excess elements in array initializer " + n + " size " + EncodedType.getArraySize(type, i + 1));
                }
                if (c == 'P' && (type[i + 1] & 0xFF) == 99) {
                    this.setArraySizeIfCharArray(n, lex);
                    return;
                }
            }
            throw new ParseError(lex, "incompatible initial value");
        }
    }

    private static int getArraySize(byte[] type, int i) {
        int c;
        int s = 0;
        while (48 <= (c = type[i++] & 0xFF) && c <= 57) {
            s = s * 10 + c - 48;
        }
        return s;
    }

    int getArraySize() {
        return EncodedType.getArraySize(this.buffer, this.pos + 1);
    }

    void setArraySizeIfCharArray(int n, Lex lex) throws ParseError {
        char c1 = '\u0000';
        char c2 = '\u0000';
        byte[] type = this.buffer;
        int len = type.length;
        if (lex.fDbgLevel > 3) {
            lex.debug.print(5, " setArraySizeIfCharArray " + n + " len " + len + " " + type);
        }
        for (int i = this.pos; i < len; ++i) {
            char c = (char)(type[i] & 0xFF);
            if (c == 'C' || c == 'V') {
                c1 = c;
                continue;
            }
            if (c == 'S' || c == 'U') {
                c2 = c;
                continue;
            }
            if (c == 'P' && EncodedType.getTypeChar(type, i + 1) == 99) {
                return;
            }
            if (c == 'A') {
                if ((type[i + 1] & 0xFF) == 63) {
                    if (EncodedType.getTypeChar(type, i + 2) == 99) {
                        this.pos = i + 2;
                        this.insertDim(n);
                        if (c1 != '\u0000') {
                            this.insert(c1);
                        }
                        if (c2 != '\u0000') {
                            this.insert(c2);
                        }
                        return;
                    }
                } else {
                    if (EncodedType.getArraySizeForChar(type, i + 1, lex) >= n) {
                        return;
                    }
                    if (EncodedType.getArraySizeForChar(type, i + 1, lex) == n - 1) {
                        lex.warning.put("excess 1 char in array initiation " + lex.getString());
                        return;
                    }
                    throw new ParseError(lex, "excess elements in array initializer");
                }
            }
            throw new ParseError(lex, "incompatible initial value");
        }
    }

    private static int getArraySizeForChar(byte[] type, int i, Lex lex) throws ParseError {
        int c;
        int s = 0;
        while (48 <= (c = type[i++] & 0xFF) && c <= 57) {
            s = s * 10 + c - 48;
        }
        while (c == 67 || c == 86 || c == 85 || c == 83) {
            c = type[i++] & 0xFF;
        }
        if (c == 99) {
            return s;
        }
        throw new ParseError(lex, "incompatible initial value");
    }

    boolean hasIncompleteArray() {
        for (int i = this.pos; i < this.buffer.length; ++i) {
            if ((this.buffer[i] & 0xFF) != 63) continue;
            return true;
        }
        return false;
    }

    void insertStruct(String name) {
        this.insert('>');
        this.insert(name);
        this.insert('<');
    }

    void insertUnion(String name) {
        this.insert(')');
        this.insert(name);
        this.insert('(');
    }

    void insertEnum(String name) {
        this.insert(']');
        this.insert(name);
        this.insert('[');
    }

    void insertArgTypes(OldFuncArgs args) {
        while (args != null) {
            this.insert(((Declarator)args.arg).getType());
            args = args.next;
        }
    }

    boolean dereference() {
        int i = EncodedType.getTypeChar0(this.buffer, this.pos);
        int c = this.buffer[i] & 0xFF;
        if (c == 80) {
            this.pos = i + 1;
            return true;
        }
        if (c == 65) {
            while (48 <= (c = this.buffer[++i] & 0xFF) && c <= 57 || c == 63) {
            }
            this.pos = i;
            return true;
        }
        return false;
    }

    boolean toReturnType() {
        int i = EncodedType.getTypeChar0(this.buffer, this.pos);
        int c = this.buffer[i] & 0xFF;
        if (c == 70) {
            int len = this.buffer.length;
            while ((this.buffer[i++] & 0xFF) != 36) {
                if (i < len) continue;
                return false;
            }
            this.pos = i;
            return true;
        }
        return false;
    }

    int getTypeChar() {
        return EncodedType.getTypeChar(this.buffer, this.pos);
    }

    String getTagName() {
        return EncodedType.getTagName(this.buffer, this.pos);
    }

    static String getTagName(byte[] type, int pos) {
        int end;
        int i = EncodedType.getTypeChar0(type, pos);
        switch (type[i] & 0xFF) {
            case 60: {
                end = 62;
                break;
            }
            case 40: {
                end = 41;
                break;
            }
            case 91: {
                end = 93;
                break;
            }
            default: {
                return null;
            }
        }
        StringBuffer sbuf = new StringBuffer();
        int len = type.length;
        while (++i < len) {
            int c = type[i] & 0xFF;
            if (c == end) {
                return sbuf.toString();
            }
            sbuf.append((char)c);
        }
        return null;
    }

    int save() {
        return this.buffer.length - this.pos;
    }

    void restore(int p) {
        this.pos = this.buffer.length - p;
    }

    private void increase() {
        int length = this.buffer.length;
        int oldPos = this.pos;
        byte[] buf2 = new byte[length * 2];
        System.arraycopy(this.buffer, oldPos, buf2, oldPos + length, length - oldPos);
        this.buffer = buf2;
        this.pos = oldPos + length;
    }

    byte[] get() {
        int len = this.buffer.length - this.pos;
        byte[] buf = new byte[len];
        System.arraycopy(this.buffer, this.pos, buf, 0, len);
        return buf;
    }

    public static int getTypeChar(byte[] type, int start) {
        int i = EncodedType.getTypeChar0(type, start);
        if (i >= 0) {
            return type[i] & 0xFF;
        }
        return 118;
    }

    private static int getTypeChar0(byte[] type, int start) {
        int len = type.length;
        for (int i = start; i < len; ++i) {
            int c = type[i] & 0xFF;
            if (c == 67 || c == 86 || c == 83 || c == 85) continue;
            return i;
        }
        return -1;
    }

    public void bePointer() {
        if (!this.isArray()) {
            return;
        }
        int i = EncodedType.getTypeChar0(this.buffer, this.pos);
        if (i < 0) {
            return;
        }
        int c = this.buffer[i] & 0xFF;
        if (c == 65) {
            while (48 <= (c = this.buffer[++i] & 0xFF) && c <= 57 || c == 63) {
            }
            this.pos = i - 1;
            this.buffer[this.pos] = 80;
        }
    }

    public boolean isSigned() {
        byte[] type = this.buffer;
        int len = type.length;
        for (int i = this.pos; i < len; ++i) {
            int c = type[i] & 0xFF;
            if (c == 67 || c == 86) continue;
            return c != 85;
        }
        return false;
    }

    boolean isFunction() {
        return EncodedType.isFunction(this.buffer, this.pos);
    }

    public static boolean isFunction(byte[] type, int pos) {
        return EncodedType.getTypeChar(type, pos) == 70;
    }

    boolean isPointer() {
        return EncodedType.isPointer(this.buffer, this.pos);
    }

    public static boolean isPointer(byte[] type, int pos) {
        int c = EncodedType.getTypeChar(type, pos);
        return c == 80 || c == 65;
    }

    boolean isArray() {
        return EncodedType.isArray(this.buffer, this.pos);
    }

    public static boolean isArray(byte[] type, int pos) {
        return EncodedType.getTypeChar(type, pos) == 65;
    }

    public boolean isValue() {
        return EncodedType.isValue(this.buffer, this.pos);
    }

    public static boolean isValue(byte[] type, int pos) {
        int c = EncodedType.getTypeChar(type, pos);
        return c != 70 && c != 60 && c != 40;
    }

    public boolean isValueOrFunction() {
        int c = EncodedType.getTypeChar(this.buffer, this.pos);
        return c != 60 && c != 40;
    }

    boolean isLongLong() {
        return EncodedType.isLongLong(this.buffer, this.pos);
    }

    public static boolean isLongLong(byte[] type, int pos) {
        return EncodedType.getTypeChar(type, pos) == 106;
    }

    boolean isIndex() {
        return EncodedType.isIndex(this.buffer, this.pos);
    }

    public static boolean isIndex(byte[] type, int pos) {
        int c = EncodedType.getTypeChar(type, pos);
        return c == 105 || c == 99 || c == 115 || c == 108 || c == 106 || c == 91;
    }

    boolean isInteger() {
        return EncodedType.isInteger(this.buffer, this.pos);
    }

    public static boolean isInteger(byte[] type, int pos) {
        int c = EncodedType.getTypeChar(type, pos);
        return c == 105 || c == 99 || c == 115 || c == 108 || c == 106 || c == 91;
    }

    boolean isNumber() {
        return EncodedType.isNumber(this.buffer, this.pos);
    }

    public static boolean isNumber(byte[] type, int pos) {
        int c = EncodedType.getTypeChar(type, pos);
        return c == 105 || c == 99 || c == 115 || c == 108 || c == 106 || c == 91 || c == 102 || c == 100 || c == 114;
    }

    public boolean isDouble() {
        return EncodedType.isDouble(this.buffer, this.pos);
    }

    public static boolean isDouble(byte[] type, int pos) {
        int c = EncodedType.getTypeChar(type, pos);
        return c == 102 || c == 100 || c == 114;
    }

    public boolean isFloatType() {
        return EncodedType.getTypeChar(this.buffer, this.pos) == 102;
    }

    public boolean isDoubleType() {
        return EncodedType.getTypeChar(this.buffer, this.pos) == 100;
    }

    public boolean isLongDoubleType() {
        return EncodedType.getTypeChar(this.buffer, this.pos) == 114;
    }

    public EncodedType getArrayElemType() {
        int lElemPos = this.pos;
        EncodedType etype3 = new EncodedType();
        int len = this.buffer.length;
        etype3.buffer = new byte[len];
        System.arraycopy(this.buffer, 0, etype3.buffer, 0, len);
        int c = etype3.buffer[lElemPos] & 0xFF;
        if (c == 65) {
            while (48 <= (c = this.buffer[++lElemPos] & 0xFF) && c <= 57 || c == 63) {
            }
            etype3.pos = lElemPos;
            return etype3;
        }
        System.out.println("Non array in EncodedType.getArrayElemType" + this.toString());
        return null;
    }

    public EncodedType getDeclaratorType(Declarator pDecl) {
        EncodedType etype3 = new EncodedType();
        byte[] lType = pDecl.getType();
        int len = lType.length;
        etype3.buffer = new byte[len];
        System.arraycopy(lType, 0, etype3.buffer, 0, len);
        int pos = 0;
        int c = etype3.buffer[pos] & 0xFF;
        while ((c = etype3.buffer[pos++] & 0xFF) == 0) {
        }
        etype3.pos = pos - 1;
        return etype3;
    }

    public boolean isStruct() {
        return EncodedType.getTypeChar(this.buffer, this.pos) == 60;
    }

    boolean isChar() {
        return EncodedType.isChar(this.buffer, this.pos);
    }

    public static boolean isChar(byte[] type, int pos) {
        int c = EncodedType.getTypeChar(type, pos);
        return c == 99;
    }

    boolean isVoid() {
        return EncodedType.isVoid(this.buffer, this.pos);
    }

    public static boolean isVoid(byte[] type, int pos) {
        int c = EncodedType.getTypeChar(type, pos);
        return c == 118;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        for (int i = this.pos; i < this.buffer.length; ++i) {
            sbuf.append((char)this.buffer[i] + "-" + this.buffer[i] + " ");
        }
        return sbuf.toString();
    }

    public long computeSizeof(Parser parser) throws ParseError {
        return EncodedType.computeSizeof(parser, this.buffer, this.pos);
    }

    public static long computeSizeof(Parser parser, byte[] type, int pos) throws ParseError {
        int c = EncodedType.getTypeChar(type, pos);
        if (parser.lex.fDbgLevel > 3) {
            parser.debug.print(5, " computeSizeof " + type[pos] + " pos " + pos + " " + c + " " + (char)c + " " + Character.forDigit(c, 10) + " value " + parser.evaluator.toSize[c]);
        }
        if (c == 99) {
            return parser.evaluator.toSize[99];
        }
        if (c == 115) {
            return parser.evaluator.toSize[115];
        }
        if (c == 105 || c == 91) {
            return parser.evaluator.toSize[105];
        }
        if (c == 108) {
            return parser.evaluator.toSize[108];
        }
        if (c == 106) {
            return parser.evaluator.toSize[106];
        }
        if (c == 102) {
            return parser.evaluator.toSize[102];
        }
        if (c == 100) {
            return parser.evaluator.toSize[100];
        }
        if (c == 114) {
            return parser.evaluator.toSize[114];
        }
        if (c == 60) {
            long lSize = parser.sizeofStruct(EncodedType.getTagName(type, pos));
            if (parser.fDbgLevel > 3) {
                parser.debug.print(5, " computeSizeof " + lSize + " ");
            }
            return lSize;
        }
        if (c == 40) {
            long lSize = parser.sizeofUnion(EncodedType.getTagName(type, pos));
            if (parser.fDbgLevel > 3) {
                parser.debug.print(5, " computeSizeof " + lSize + " ");
            }
            return lSize;
        }
        if (c == 80) {
            return parser.evaluator.toSize[80];
        }
        if (c == 65) {
            int i = pos + 1;
            c = type[i] & 0xFF;
            if (c == 63) {
                return 0L;
            }
            long size = 0L;
            while (48 <= c && c <= 57) {
                size = size * 10L + (long)c - 48L;
                c = type[++i] & 0xFF;
            }
            return size *= EncodedType.computeSizeof(parser, type, i);
        }
        if (parser.fDbgLevel > 3) {
            parser.debug.print(5, " computeSizeof return -1 \n");
        }
        return -1L;
    }

    public static String toString(byte[] type) {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < type.length; ++i) {
            sbuf.append((char)type[i]);
        }
        return sbuf.toString();
    }

    public long getArrayParamSize() {
        return this.arrayParamSize;
    }

    public void setArrayParamSize(long s) {
        this.arrayParamSize = s;
    }

    public EncodedType getReturnValueType() {
        EncodedType etype3 = new EncodedType();
        int index3 = 0;
        if (this.isFunction()) {
            boolean lFound = false;
            int c = 0;
            int len = this.buffer.length;
            for (int index = 0; index < len; ++index) {
                c = this.buffer[index] & 0xFF;
                if (!lFound && c == 36) {
                    lFound = true;
                    etype3.buffer = new byte[len - index + 1];
                    continue;
                }
                if (!lFound) continue;
                etype3.buffer[index3] = this.buffer[index];
                ++index3;
            }
            etype3.pos = 0;
        }
        return etype3;
    }

    void ellipsisToVoid() {
        if (this.buffer[this.pos] == 70 && this.buffer[this.pos + 1] == 101) {
            this.buffer[this.pos + 1] = 118;
        }
    }

    void setStorageClass(int s) {
        this.storageClass = s;
    }

    int getStorageClass() {
        return this.storageClass;
    }
}

