/*
 * Decompiled with CFR 0.152.
 */
package coins.casttohir;

import coins.ast.Expr;
import coins.ast.TypeId;
import coins.casttohir.ToHir;
import coins.ir.IrList;
import coins.ir.hir.HIR;
import coins.sym.Elem;
import coins.sym.StructType;
import coins.sym.Subp;
import coins.sym.SubpType;
import coins.sym.Sym;
import coins.sym.SymImpl;
import coins.sym.SymTable;
import coins.sym.Type;
import coins.sym.UnionType;
import coins.sym.Var;
import coins.sym.VectorType;
import java.util.HashMap;
import java.util.ListIterator;

public class ToHirSym
implements TypeId {
    private byte[] byteArray;
    private int byteIndex;
    private HashMap tagMap = new HashMap();
    private final ToHir toHir;
    private final HIR hir;
    private final Sym sym;
    private static final String CONST_SUFFIX = "#const";
    private static final String VOLATILE_SUFFIX = "#volatile";
    protected int fDbgLevel;

    ToHirSym(ToHir tohir) {
        this.toHir = tohir;
        this.hir = this.toHir.hirRoot.hir;
        this.sym = this.toHir.hirRoot.sym;
        this.fDbgLevel = this.toHir.ioRoot.dbgToHir.getLevel();
        this.message(1, "ToHirSym\n");
    }

    private void message(int level, String mes) {
        this.toHir.debug.print(level, "Sy", mes);
    }

    void makeQualifiedTypes(Type t, String tagname) {
        Type ct = null;
        Type vt = null;
        String newtagname = (tagname + CONST_SUFFIX).intern();
        if (this.fDbgLevel > 0) {
            this.message(4, "makeQualifiedTypes tagName=" + newtagname + " based on " + t.toStringShort());
        }
        if (this.toHir.symRoot.symTableCurrent.search(newtagname, 11) != null) {
            ct = this.makeQualifiedType(t, CONST_SUFFIX);
        }
        if (this.toHir.symRoot.symTableCurrent.search(newtagname = (tagname + VOLATILE_SUFFIX).intern(), 11) != null) {
            vt = this.makeQualifiedType(t, VOLATILE_SUFFIX);
        }
        if (this.toHir.symRoot.symTableCurrent.search(newtagname = (tagname + CONST_SUFFIX + VOLATILE_SUFFIX).intern(), 11) != null) {
            if (ct != null) {
                this.makeQualifiedType(ct, VOLATILE_SUFFIX);
            } else if (vt != null) {
                this.makeQualifiedType(vt, CONST_SUFFIX);
            } else {
                this.toHir.fatal("makeQualifiedTypes: " + newtagname);
            }
        }
    }

    public Type convertType(byte[] b) {
        this.byteArray = b;
        this.byteIndex = 0;
        if (this.fDbgLevel > 3) {
            this.message(6, "convertType  TYPE=" + new String(b));
        }
        return this.cnvType();
    }

    private Type cnvType() {
        switch (this.byteArray[this.byteIndex++]) {
            case 67: {
                return this.makeQualifiedType(this.cnvType(), CONST_SUFFIX);
            }
            case 86: {
                return this.makeQualifiedType(this.cnvType(), VOLATILE_SUFFIX);
            }
            case 83: {
                return this.cnvSigned();
            }
            case 85: {
                return this.cnvUnsigned();
            }
            case 60: {
                return this.cnvStruct();
            }
            case 62: {
                this.toHir.fatal("cnvTypeStruct");
            }
            case 40: {
                return this.cnvUnion();
            }
            case 41: {
                this.toHir.fatal("cnvTypeUnion");
            }
            case 91: {
                return this.cnvEnum();
            }
            case 93: {
                this.toHir.fatal("cnvTypeEnum");
            }
            case 80: {
                return this.sym.pointerType(this.cnvType());
            }
            case 65: {
                return this.cnvArray();
            }
            case 70: {
                return this.cnvFunction();
            }
            case 101: {
                return null;
            }
            case 99: {
                return this.toHir.symRoot.getCharType();
            }
            case 115: {
                return this.toHir.symRoot.typeShort;
            }
            case 105: {
                return this.toHir.symRoot.typeInt;
            }
            case 108: {
                return this.toHir.symRoot.typeLong;
            }
            case 106: {
                return this.toHir.symRoot.typeLongLong;
            }
            case 102: {
                return this.toHir.symRoot.typeFloat;
            }
            case 100: {
                return this.toHir.symRoot.typeDouble;
            }
            case 114: {
                return this.toHir.symRoot.typeLongDouble;
            }
            case 118: {
                return this.toHir.symRoot.typeVoid;
            }
        }
        this.toHir.fatal("cnvType: " + (char)this.byteArray[this.byteIndex - 1] + " of " + new String(this.byteArray));
        return this.toHir.symRoot.typeVoid;
    }

    private Type makeQualifiedType(Type t, String suffix) {
        if (this.fDbgLevel > 0) {
            this.message(6, "makeQualifiedType suffix=" + suffix + " based on " + t.toStringShort());
        }
        switch (t.getTypeKind()) {
            case 24: {
                StructType strct;
                String tagname = this.addSuffix(((StructType)t).getTag().getName(), suffix);
                SymTable tgt = this.toHir.symRoot.symTableCurrent.searchTableHaving(t);
                Sym tag = tgt.search(tagname, 11);
                if (tag == null) {
                    tag = tgt.generateTag(tagname);
                }
                if ((strct = (StructType)tag.getSymType()) == null) {
                    strct = this.sym.structType(null, tag);
                    strct.setOrigin(t);
                    tag.setSymType(strct);
                }
                if (this.fDbgLevel > 0) {
                    this.message(6, " elemSize " + strct.getElemList().size() + " elemListSize " + t.getElemList().size());
                }
                if (strct.getElemList().size() < t.getElemList().size()) {
                    SymTable bak = this.toHir.symRoot.symTableCurrent;
                    this.toHir.symRoot.symTableCurrent = tgt;
                    this.toHir.symRoot.symTableCurrent.pushSymTable(strct);
                    strct.getElemList().clear();
                    ListIterator i = t.getElemList().iterator();
                    while (i.hasNext()) {
                        Elem oldelem = (Elem)i.next();
                        Type type = this.makeQualifiedType(oldelem.getSymType(), suffix);
                        Elem elem = this.sym.defineElem(oldelem.getName(), type);
                        if (oldelem.isBitField()) {
                            elem.setBitFieldSize(oldelem.getBitSize());
                        }
                        elem.setDefinedFile(oldelem.getDefinedFile());
                        elem.setDefinedLine(oldelem.getDefinedLine());
                        strct.addElem(elem);
                    }
                    this.toHir.symRoot.symTableCurrent.popSymTable();
                    this.toHir.symRoot.symTableCurrent = bak;
                    strct.finishStructType(true);
                }
                return strct;
            }
            case 25: {
                UnionType unon;
                String tagname = this.addSuffix(((UnionType)t).getTag().getName(), suffix);
                SymTable tgt = this.toHir.symRoot.symTableCurrent.searchTableHaving(t);
                Sym tag = tgt.search(tagname, 11);
                if (tag == null) {
                    tag = tgt.generateTag(tagname);
                }
                if ((unon = (UnionType)tag.getSymType()) == null) {
                    unon = this.sym.unionType(null, tag);
                    unon.setOrigin(t);
                    tag.setSymType(unon);
                }
                if (this.fDbgLevel > 0) {
                    this.message(6, " elemSize " + unon.getElemList().size() + " elemListSize " + t.getElemList().size());
                }
                if (unon.getElemList().size() < t.getElemList().size()) {
                    SymTable bak = this.toHir.symRoot.symTableCurrent;
                    this.toHir.symRoot.symTableCurrent = tgt;
                    this.toHir.symRoot.symTableCurrent.pushSymTable(unon);
                    unon.getElemList().clear();
                    ListIterator i = t.getElemList().iterator();
                    while (i.hasNext()) {
                        Elem oldelem = (Elem)i.next();
                        Type type = this.makeQualifiedType(oldelem.getSymType(), suffix);
                        Elem elem = this.sym.defineElem(oldelem.getName(), type);
                        elem.setDefinedFile(oldelem.getDefinedFile());
                        elem.setDefinedLine(oldelem.getDefinedLine());
                        unon.addElem(elem);
                    }
                    this.toHir.symRoot.symTableCurrent.popSymTable();
                    this.toHir.symRoot.symTableCurrent = bak;
                    unon.finishUnionType(true);
                }
                return unon;
            }
            case 27: {
                this.toHir.error("ISO C forbids qualified function types");
                return t;
            }
            case 23: {
                t = this.sym.vectorType(this.makeQualifiedType(((VectorType)t).getElemType(), suffix), ((VectorType)t).getElemCount());
            }
        }
        return suffix == CONST_SUFFIX ? t.makeConstType() : (suffix == VOLATILE_SUFFIX ? t.makeVolatileType() : t);
    }

    private String addSuffix(String name, String suffix) {
        if (name.indexOf(suffix) >= 0) {
            return name;
        }
        if (suffix == CONST_SUFFIX) {
            int index = name.indexOf(VOLATILE_SUFFIX);
            name = index >= 0 ? name.substring(0, index) + CONST_SUFFIX + VOLATILE_SUFFIX : name + CONST_SUFFIX;
        } else if (suffix == VOLATILE_SUFFIX) {
            name = name + VOLATILE_SUFFIX;
        }
        return name.intern();
    }

    private Type cnvSigned() {
        switch (this.byteArray[this.byteIndex++]) {
            case 99: {
                return this.toHir.symRoot.typeChar;
            }
            case 115: {
                return this.toHir.symRoot.typeShort;
            }
            case 105: {
                return this.toHir.symRoot.typeInt;
            }
            case 108: {
                return this.toHir.symRoot.typeLong;
            }
            case 106: {
                return this.toHir.symRoot.typeLongLong;
            }
        }
        this.toHir.error("cannot declare 'signed'");
        return this.toHir.symRoot.typeInt;
    }

    private Type cnvUnsigned() {
        switch (this.byteArray[this.byteIndex++]) {
            case 99: {
                return this.toHir.symRoot.typeU_Char;
            }
            case 115: {
                return this.toHir.symRoot.typeU_Short;
            }
            case 105: {
                return this.toHir.symRoot.typeU_Int;
            }
            case 108: {
                return this.toHir.symRoot.typeU_Long;
            }
            case 106: {
                return this.toHir.symRoot.typeU_LongLong;
            }
        }
        this.toHir.error("cannot declare 'unsigned'");
        return this.toHir.symRoot.typeU_Int;
    }

    private Type cnvStruct() {
        Sym tag = this.cnvTag('>');
        Type type = tag.getSymType();
        if (type == null) {
            SymTable bak = this.toHir.symRoot.symTableCurrent;
            this.toHir.symRoot.symTableCurrent = this.getNormalTable();
            type = this.sym.structType(null, tag);
            this.toHir.symRoot.symTableCurrent = bak;
            tag.setSymType(type);
            ((StructType)type).setTag(tag);
        } else if (type.getTypeKind() != 24) {
            this.toHir.error("'" + tag.getName() + "' is not struct tag");
        }
        return type;
    }

    private Type cnvUnion() {
        Sym tag = this.cnvTag(')');
        Type type = tag.getSymType();
        if (type == null) {
            SymTable bak = this.toHir.symRoot.symTableCurrent;
            this.toHir.symRoot.symTableCurrent = this.getNormalTable();
            type = this.sym.unionType(null, tag);
            this.toHir.symRoot.symTableCurrent = bak;
            tag.setSymType(type);
            ((UnionType)type).setTag(tag);
        } else if (type.getTypeKind() != 25) {
            this.toHir.error("'" + tag.getName() + "' is not union tag");
        }
        return type;
    }

    private Type cnvEnum() {
        Sym tag = this.cnvTag(']');
        Type type = tag.getSymType();
        if (type == null) {
            SymTable bak = this.toHir.symRoot.symTableCurrent;
            this.toHir.symRoot.symTableCurrent = this.getNormalTable();
            type = this.sym.enumType(null, tag);
            this.toHir.symRoot.symTableCurrent = bak;
            tag.setSymType(type);
        } else if (type.getTypeKind() != 21) {
            this.toHir.error("'" + tag.getName() + "' is not enum tag");
        }
        return type;
    }

    private Type cnvArray() {
        long size = 0L;
        if (this.byteArray[this.byteIndex] == 63) {
            ++this.byteIndex;
            size = 0L;
        } else {
            byte c = this.byteArray[this.byteIndex];
            while (48 <= c && c <= 57) {
                size = size * 10L + (long)c - 48L;
                c = this.byteArray[++this.byteIndex];
            }
            if (size == 0L) {
                this.toHir.warning("ISO C forbids zero-size array");
            }
        }
        Type elemtype = this.cnvType();
        if (elemtype.getSizeExp() == null) {
            this.toHir.error("elements of array have incomplete type");
            elemtype = this.toHir.symRoot.typeInt;
        }
        if (elemtype.getTypeKind() == 15) {
            this.toHir.error("declaration as array of voids");
            elemtype = this.toHir.symRoot.typeInt;
        }
        if (elemtype.getTypeKind() == 27) {
            this.toHir.error("declaration as array of functions");
            elemtype = this.toHir.symRoot.typeInt;
        }
        Type type = this.sym.vectorType(elemtype, size);
        if (elemtype.isConst()) {
            type = type.makeConstType();
        }
        return type;
    }

    private Type cnvFunction() {
        IrList il = this.hir.irList();
        boolean optionalparam = false;
        boolean noparamspec = true;
        while (this.byteArray[this.byteIndex] != 36) {
            Type t = this.cnvType();
            if (t == null) {
                if (il.size() <= 0) continue;
                optionalparam = true;
                continue;
            }
            if (t == this.toHir.symRoot.typeVoid) {
                if (il.size() > 0 || this.byteArray[this.byteIndex] != 36) {
                    this.toHir.error("invalid function parameter type 'void'");
                }
                noparamspec = false;
                continue;
            }
            switch (t.getTypeKind()) {
                case 23: {
                    t = this.sym.pointerType(((VectorType)t).getElemType());
                    break;
                }
                case 27: {
                    t = this.sym.pointerType((SubpType)t);
                }
            }
            il.add(t);
            noparamspec = false;
        }
        ++this.byteIndex;
        Type rettype = this.cnvType();
        if (rettype.isConst() || rettype.isVolatile()) {
            rettype = rettype.getUnqualifiedType();
            this.toHir.warning("type qualifiers ignored on function return type");
        }
        return this.sym.subpType(rettype, il, optionalparam, noparamspec, null);
    }

    private SymTable getNormalTable() {
        SymTable table = this.toHir.symRoot.symTableCurrent;
        if (this.fDbgLevel > 3) {
            this.message(6, "getNormalTable OWNERSYM=" + table.getOwner());
        }
        while (table.getOwner() != null && table.getOwner().getSymKind() == 13) {
            table = table.getParent();
            if (this.fDbgLevel <= 3) continue;
            this.message(6, "getNormalTable PARENTOWNERSYM=" + table.getOwner());
        }
        return table;
    }

    private Sym cnvTag(char nameend) {
        int index = this.byteIndex;
        while ((char)this.byteArray[this.byteIndex++] != nameend) {
        }
        String tagname = new String(this.byteArray, index, this.byteIndex - 1 - index).intern();
        Sym tag = this.getNormalTable().search(tagname, 11);
        if (tag == null) {
            tag = this.getNormalTable().generateTag(tagname);
        }
        return tag;
    }

    void declareType(Type type, String name) {
        Sym s;
        if (this.fDbgLevel > 3) {
            this.message(4, "declareType NAME=" + name + " TYPE=" + type);
        }
        if ((s = this.toHir.searchLocalOrdinaryId(name)) == null) {
            ((SymImpl)this.sym).definedType(name, type, this.toHir.symRoot.symTableCurrent.getOwner());
        } else if (s.getSymKind() != 13) {
            this.toHir.error("symbol '" + name + "' is redeclared in different kind");
        } else if (s.getSymType() != type) {
            this.toHir.error("redefinition of typedef '" + name + "'");
        }
    }

    Subp declareGlobalFunction(int storage, SubpType type, String name, boolean init) {
        if (this.fDbgLevel > 3) {
            this.message(4, "declareGlobalFunction NAME=" + name + " TYPE=" + type + " STORAGE=" + storage);
        }
        int oldvisible = 0;
        int newvisible = 1;
        Sym s = this.toHir.searchGlobalOrdinaryId(name);
        if (s == null) {
            SymTable table = this.toHir.symRoot.symTableCurrent;
            this.toHir.symRoot.symTableCurrent = this.toHir.symRoot.symTableRoot;
            s = this.sym.defineSubp(name, type.getReturnType());
            this.toHir.symRoot.symTableCurrent = table;
            s.setSymType(type);
        } else {
            if (s.getSymKind() != 12) {
                this.toHir.error("symbol '" + name + "' is redeclared in different kind");
                return null;
            }
            Type t = this.toHir.compositeType(s.getSymType(), type, true);
            if (t == null) {
                this.toHir.error("function '" + name + "' is redeclared in different type");
            } else {
                s.setSymType(t);
            }
            oldvisible = ((Subp)s).getVisibility();
        }
        switch (storage) {
            case 0: {
                break;
            }
            case 1: {
                newvisible = 5;
                break;
            }
            case 2: {
                if (!init) break;
                this.toHir.warning("function '" + name + "' is defined though declared 'extern'");
                break;
            }
            case 4: {
                this.toHir.warning("cannot use storage class 'auto' here");
                newvisible = 5;
                break;
            }
            case 16: {
                this.toHir.warning("cannot use storage class 'register' here");
                newvisible = 5;
                break;
            }
            case 8: {
                this.toHir.warning("storage class 'inline' is disregarded");
                break;
            }
            default: {
                this.toHir.fatal("declareFunction");
            }
        }
        if (newvisible == 1 && init) {
            newvisible = 2;
        }
        if (oldvisible < newvisible) {
            ((Subp)s).setVisibility(newvisible);
        }
        return (Subp)s;
    }

    Subp declareLocalFunction(int storage, SubpType type, String name) {
        return this.declareGlobalFunction(storage, type, name, false);
    }

    Var declareGlobalVariable(int storage, Type type, String name, Expr ini) {
        int newvisible;
        if (this.fDbgLevel > 3) {
            this.message(4, "declareGlobalVariable NAME=" + name + " TYPE=" + type + " STORAGE=" + storage);
        }
        int oldvisible = 0;
        Sym s = this.toHir.searchGlobalOrdinaryId(name);
        if (s == null) {
            SymTable table = this.toHir.symRoot.symTableCurrent;
            this.toHir.symRoot.symTableCurrent = this.toHir.symRoot.symTableRoot;
            s = this.sym.defineVar(name, type);
            this.toHir.symRoot.symTableCurrent = table;
            s.setSymType(type);
        } else {
            if (s.getSymKind() != 8) {
                this.toHir.error("symbol '" + name + "' is redeclared in different kind");
                return null;
            }
            Type t = this.toHir.compositeType(s.getSymType(), type, true);
            if (t == null) {
                this.toHir.error("variable '" + name + "' is redeclared in different type");
            } else {
                s.setSymType(t);
            }
            oldvisible = ((Var)s).getVisibility();
        }
        switch (storage) {
            case 0: {
                newvisible = 2;
                break;
            }
            case 1: {
                newvisible = 5;
                break;
            }
            case 2: {
                newvisible = 1;
                if (ini == null) break;
                this.toHir.warning("variable '" + name + "' initialized though declared 'extern'");
                newvisible = 2;
                break;
            }
            case 4: {
                newvisible = 5;
                this.toHir.warning("cannot use storage class 'auto' here");
                break;
            }
            case 16: {
                newvisible = 5;
                this.toHir.warning("cannot use storage class 'register' here");
                break;
            }
            case 8: {
                newvisible = 2;
                this.toHir.warning("storage class 'inline' is disregarded");
                break;
            }
            default: {
                newvisible = 1;
                this.toHir.fatal("declareVariable");
            }
        }
        if (oldvisible < newvisible) {
            ((Var)s).setVisibility(newvisible);
        }
        ((Var)s).setStorageClass(6);
        return (Var)s;
    }

    Var declareLocalVariable(int storage, Type type, String name, Expr ini) {
        Sym s;
        if (storage == 2) {
            return this.declareGlobalVariable(storage, type, name, ini);
        }
        if (this.fDbgLevel > 3) {
            this.message(4, "declareLocalVariable NAME=" + name + " TYPE=" + type + " STORAGE=" + storage);
        }
        if ((s = this.toHir.searchLocalOrdinaryId(name)) != null) {
            if (s.getSymKind() != 8 && s.getSymKind() != 9) {
                this.toHir.error("symbol '" + name + "' is redeclared in different kind");
                return null;
            }
            this.toHir.error("variable '" + name + "' is redeclared");
            return (Var)s;
        }
        s = this.sym.defineVar(name, type);
        s.setSymType(type);
        int newstorage = 7;
        switch (storage) {
            case 0: {
                break;
            }
            case 1: {
                newstorage = 6;
                break;
            }
            case 4: {
                break;
            }
            case 16: {
                break;
            }
            case 8: {
                this.toHir.warning("storage class 'inline' is disregarded");
                break;
            }
            default: {
                this.toHir.fatal("declareLocallVariable: " + storage);
            }
        }
        if (type.getSizeValue() <= 0L) {
            this.toHir.error("'" + name + "' is incomplete type or size 0");
        }
        ((Var)s).setStorageClass(newstorage);
        ((Var)s).setVisibility(4);
        return (Var)s;
    }
}

