/*
 * Decompiled with CFR 0.152.
 */
package coins.casttohir;

import coins.casttohir.ToHir;
import coins.ir.hir.Exp;
import coins.ir.hir.HIR;
import coins.sym.PointerType;
import coins.sym.Sym;
import coins.sym.Type;
import coins.sym.VectorType;

class ToHirCast {
    private Type[] toUnsigned;
    private Type[] toSigned;
    private final ToHir toHir;
    private final HIR hir;
    private final Sym sym;
    protected int fDbgLevel;

    ToHirCast(ToHir tohir) {
        this.toHir = tohir;
        this.hir = tohir.hirRoot.hir;
        this.sym = tohir.hirRoot.sym;
        this.fDbgLevel = tohir.hirRoot.ioRoot.dbgToHir.getLevel();
        this.toHir.debug.print(1, "ToHirCast\n");
        this.toUnsigned = new Type[]{null, null, null, this.toHir.symRoot.typeU_Short, this.toHir.symRoot.typeU_Int, this.toHir.symRoot.typeU_Long, this.toHir.symRoot.typeU_LongLong, this.toHir.symRoot.typeU_Char, this.toHir.symRoot.typeU_Char, this.toHir.symRoot.typeU_Short, this.toHir.symRoot.typeU_Int, this.toHir.symRoot.typeU_Long, this.toHir.symRoot.typeU_LongLong, null, null, null, this.toHir.symRoot.typeFloat, this.toHir.symRoot.typeDouble, this.toHir.symRoot.typeLongDouble};
        this.toSigned = new Type[]{null, null, null, this.toHir.symRoot.typeShort, this.toHir.symRoot.typeInt, this.toHir.symRoot.typeLong, this.toHir.symRoot.typeLongLong, this.toHir.symRoot.typeChar, this.toHir.symRoot.typeChar, this.toHir.symRoot.typeShort, this.toHir.symRoot.typeInt, this.toHir.symRoot.typeLong, this.toHir.symRoot.typeLongLong, null, null, null, this.toHir.symRoot.typeFloat, this.toHir.symRoot.typeDouble, this.toHir.symRoot.typeLongDouble};
    }

    private void message(int level, String mes) {
        this.toHir.debug.print(level, "Ca", mes);
    }

    private void warning(Type t1, Type t2) {
        this.toHir.warning("implicit cast from " + t2 + " to " + t1);
    }

    private void error(Type t1, Type t2) {
        this.toHir.error("invalid cast from " + t2 + " to " + t1);
    }

    Exp cast(Type t1, Exp e2) {
        Type t2;
        if (this.fDbgLevel > 3) {
            this.message(6, "cast T1=" + t1 + " E2=" + e2);
        }
        if (t1 == (t2 = e2.getType())) {
            return e2;
        }
        if (t1.getUnqualifiedType() == t2.getUnqualifiedType()) {
            return this.hir.convExp(t1, e2);
        }
        switch (t1.getTypeKind()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 21: {
                return this.castToInteger(t1, t2, e2);
            }
            case 16: 
            case 17: 
            case 18: {
                return this.castToFloat(t1, t2, e2);
            }
            case 22: {
                return this.castToPointer(t1, t2, e2);
            }
        }
        this.error(t1, t2);
        return e2;
    }

    private Exp castToInteger(Type t1, Type t2, Exp e2) {
        switch (e2.getType().getTypeKind()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 18: 
            case 21: {
                return this.hir.convExp(t1, e2);
            }
            case 22: {
                return this.hir.convExp(t1, e2);
            }
        }
        this.error(t1, e2.getType());
        return e2;
    }

    private Exp castToFloat(Type t1, Type t2, Exp e2) {
        switch (t2.getTypeKind()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 13: 
            case 14: 
            case 21: {
                if (t2.getSizeValue() < this.toHir.symRoot.typeInt.getSizeValue()) {
                    return this.hir.convExp(t1, this.hir.convExp(this.toHir.symRoot.typeInt, e2));
                }
                return this.hir.convExp(t1, e2);
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                if (t2.getSizeValue() < this.toHir.symRoot.typeInt.getSizeValue()) {
                    return this.hir.convExp(t1, this.hir.convExp(this.toHir.symRoot.typeU_Int, e2));
                }
                return this.hir.convExp(t1, e2);
            }
            case 16: 
            case 17: 
            case 18: {
                return this.hir.convExp(t1, e2);
            }
        }
        this.error(t1, t2);
        return e2;
    }

    private Exp castToPointer(Type t1, Type t2, Exp e2) {
        switch (t2.getTypeKind()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 21: {
                return this.hir.convExp(t1, e2);
            }
            case 14: {
                return e2;
            }
            case 22: {
                return this.hir.convExp(t1, e2);
            }
            case 23: {
                e2 = this.toHir.decayExp(e2);
                if (t1 == e2.getType()) {
                    return e2;
                }
                return this.hir.convExp(t1, e2);
            }
        }
        this.error(t1, t2);
        return e2;
    }

    Exp iPromotion(Exp e) {
        Type t = e.getType();
        if (t.getTypeRank() < this.toHir.symRoot.typeInt.getTypeRank()) {
            if (t.getSizeValue() >= this.toHir.symRoot.typeInt.getSizeValue() && t.isUnsigned()) {
                return this.hir.convExp(this.toHir.symRoot.typeU_Int, e);
            }
            return this.hir.convExp(this.toHir.symRoot.typeInt, e);
        }
        return e;
    }

    Exp siPromotion(Exp e) {
        Type t = e.getType();
        int r = t.getTypeRank();
        if (this.toHir.isIntegral(t)) {
            if (r < this.toHir.symRoot.typeInt.getTypeRank()) {
                return this.hir.convExp(this.toHir.symRoot.typeInt, e);
            }
            if (t.isUnsigned()) {
                return this.hir.convExp(this.toSigned[t.getTypeKind()], e);
            }
        }
        return e;
    }

    Exp daPromotion(Exp e) {
        Type t = e.getType();
        if (this.toHir.isIntegral(t) && t.getTypeRank() < this.toHir.symRoot.typeInt.getTypeRank()) {
            return this.hir.convExp(this.toHir.symRoot.typeInt, e);
        }
        if (t.getTypeKind() == 16) {
            return this.hir.convExp(this.toHir.symRoot.typeDouble, e);
        }
        return e;
    }

    Exp assignCast(Type t1, Exp e2) {
        if (t1.getSizeExp() == null) {
            this.toHir.error("lvalue is incomplete type.");
            return null;
        }
        Type t2 = e2.getType();
        int k1 = t1.getTypeKind();
        int k2 = t2.getTypeKind();
        if (!(k1 != 23 || k2 != 23 || ((VectorType)t1).getElemType().getTypeKind() != 8 && ((VectorType)t1).getElemType().getTypeKind() != 7 || ((VectorType)t2).getElemType().getTypeKind() != 8 && ((VectorType)t2).getElemType().getTypeKind() != 7)) {
            return e2;
        }
        if (this.toHir.isArithmetic(t1) && this.toHir.isArithmetic(t2)) {
            return this.cast(t1, e2);
        }
        if ((k1 == 24 || k1 == 25) && this.toHir.isCompatible(t1, t2, false)) {
            return e2;
        }
        if (k1 == 22 && k2 == 22) {
            Type ptd2;
            Type ptd1 = ((PointerType)t1).getPointedType();
            if (this.toHir.isCompatible(ptd1, ptd2 = ((PointerType)t2).getPointedType(), false) || ptd1.getTypeKind() == 15 || ptd2.getTypeKind() == 15) {
                if (!this.toHir.isModifierIncluded(ptd1, ptd2)) {
                    this.toHir.warning("implicit cast to disregard qualifiers of pointer target type");
                }
            } else {
                this.toHir.warning("implicit cast to incompatible pointer types");
            }
            return this.hir.convExp(t1, e2);
        }
        if (k1 == 22 && this.toHir.isIntegral(t2) || k2 == 22 && this.toHir.isIntegral(t1)) {
            return this.cast(t1, e2);
        }
        return null;
    }

    Type getUacType(Type t1, Type t2) {
        int r1 = t1.getTypeRank();
        int r2 = t2.getTypeRank();
        if (this.fDbgLevel > 3) {
            this.message(8, "getUacType  LEFT=" + t1 + "(" + r1 + ")  RIGHT=" + t2 + "(" + r2 + ")");
        }
        if (r1 < r2) {
            Type t = t1;
            t1 = t2;
            t2 = t;
            int r = r1;
            r1 = r2;
            r2 = r;
        }
        if (r2 <= 0) {
            return null;
        }
        if (r1 < this.toHir.symRoot.typeInt.getTypeRank()) {
            long sint = this.toHir.symRoot.typeInt.getSizeValue();
            if (t1.getSizeValue() >= sint && t1.isUnsigned() || t2.getSizeValue() >= sint && t2.isUnsigned()) {
                return this.toHir.symRoot.typeU_Int;
            }
            return this.toHir.symRoot.typeInt;
        }
        if (t1.getSizeValue() > t2.getSizeValue()) {
            return t1.getUnqualifiedType();
        }
        if (t1.isUnsigned() || t2.isUnsigned()) {
            return this.toUnsigned[t1.getTypeKind()];
        }
        return t1.getUnqualifiedType();
    }

    Type getCompareType(Type t1, Type t2) {
        int r1 = t1.getTypeRank();
        int r2 = t2.getTypeRank();
        if (r1 < 0 && (r2 & 1) == 1) {
            return t1;
        }
        if ((r1 & 1) == 1 && r2 < 0) {
            return t2;
        }
        if (r1 < 0 && r2 < 0) {
            Type ptd1 = ((PointerType)t1).getPointedType();
            Type ptd2 = ((PointerType)t2).getPointedType();
            if (ptd1.getTypeKind() == 15) {
                return t2;
            }
            if (ptd2.getTypeKind() == 15) {
                return t1;
            }
            Type ptd = this.toHir.compositeType(ptd1, ptd2, false);
            if (ptd == null) {
                this.toHir.warning("comparison of distinct pointer types lacks a cast");
                ptd = this.toHir.symRoot.typeVoid;
            }
            return this.sym.pointerType(ptd);
        }
        return this.getUacType(t1, t2);
    }

    Type getSelectType(Type t2, Type t3) {
        Type t = null;
        int k2 = t2.getTypeKind();
        int k3 = t3.getTypeKind();
        t = this.getUacType(t2, t3);
        if (t != null) {
            return t;
        }
        if ((k2 == 24 || k2 == 25) && (t = this.toHir.compositeType(t2, t3, false)) != null) {
            return t;
        }
        if (k2 == 15 && k3 == 15) {
            return this.toHir.symRoot.typeVoid;
        }
        if (k2 == 22 && k3 == 22) {
            Type ptd2 = ((PointerType)t2).getPointedType();
            Type ptd3 = ((PointerType)t3).getPointedType();
            if (ptd2.getTypeKind() == 15 || ptd3.getTypeKind() == 15) {
                return this.toHir.typeVoidPtr;
            }
            t = this.toHir.compositeType(ptd2, ptd3, false);
            if (t != null) {
                return this.sym.pointerType(t);
            }
        }
        if (k2 == 22 && this.toHir.isIntegral(t3)) {
            return t2.getUnqualifiedType();
        }
        if (this.toHir.isIntegral(t2) && k3 == 22) {
            return t3.getUnqualifiedType();
        }
        return null;
    }

    Type getPointerOpType(Type t1, Type t2) {
        if (t1.getTypeKind() == 22 && this.toHir.isIntegral(t2)) {
            Type ptd = ((PointerType)t1).getPointedType();
            if (ptd.getSizeValue() <= 0L) {
                this.toHir.error("pointed type is incomplete type or its size is 0: " + t1);
            }
            return t1.getUnqualifiedType();
        }
        return null;
    }
}

