/*
 * Decompiled with CFR 0.152.
 */
package coins.casttohir;

import coins.casttohir.SideEffectCutter;
import coins.casttohir.ToC;
import coins.casttohir.ToHir;
import coins.casttohir.ToHirCOpt;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.SymNode;
import coins.ir.hir.VarNode;
import coins.sym.Const;
import coins.sym.Sym;
import coins.sym.Type;

public class ToHirCOpt2
extends ToHirCOpt {
    protected ToHirCOpt2 toOpt;
    protected final SideEffectCutter cutter;
    private static final int BIG = 4;
    private static final int MAX = 2;
    private static final int EQUAL = 0;
    private static final int MIN = -2;
    private static final int SMALL = -4;
    private static final int CANNOT = 9;
    private static final int CANNOT2 = -9;

    public ToHirCOpt2(ToHir tohir) {
        super(tohir);
        this.message(1, "ToHirCOpt2\n");
        this.cutter = new SideEffectCutter(tohir, this.buffer);
    }

    protected ToHirCOpt2 sureChild() {
        if (this.toOpt == null) {
            this.toOpt = new ToHirCOpt2(this.toHir);
        }
        return this.toOpt;
    }

    protected void message(int level, String mes) {
        this.toHir.debug.print(level, "CP", mes);
    }

    protected Exp atAdd(Exp e) {
        super.atAdd(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        if (this.is0(e1)) {
            if (this.fDbgLevel > 3) {
                this.message(4, "0+v 0-v --> v: " + ToC.tos(e));
            }
            return e2;
        }
        if (this.is0(e2)) {
            if (this.fDbgLevel > 3) {
                this.message(4, "v+0 v-0 --> v: " + ToC.tos(e));
            }
            return e1;
        }
        return e;
    }

    protected Exp atSub(Exp e) {
        Type t1;
        super.atSub(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        if (this.is0(e1)) {
            if (this.fDbgLevel > 3) {
                this.message(4, "0+v 0-v --> v: " + ToC.tos(e));
            }
            return e2;
        }
        if (this.is0(e2)) {
            if (this.fDbgLevel > 3) {
                this.message(4, "v+0 v-0 --> v: " + ToC.tos(e));
            }
            return e1;
        }
        if (e1.getOperator() == 7 && e2.getOperator() == 7 && ((VarNode)e1).getVar() == ((VarNode)e2).getVar() && !(t1 = e1.getType()).isVolatile() && this.toHir.isIntegral(t1)) {
            return this.toCast.cast(t1, this.toHir.new0Node());
        }
        return e;
    }

    protected Exp atMul(Exp e) {
        super.atMul(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        if (this.is0(e1)) {
            if (this.fDbgLevel > 3) {
                this.message(4, "0*v --> 0: " + ToC.tos(e));
            }
            this.cutter.visitExp(e2);
            return this.toHir.new0Node();
        }
        if (this.is0(e2)) {
            if (this.fDbgLevel > 3) {
                this.message(4, "v*0 --> 0: " + ToC.tos(e));
            }
            this.cutter.visitExp(e1);
            return this.toHir.new0Node();
        }
        return e;
    }

    protected Exp atDiv(Exp e) {
        super.atDiv(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        if (this.is0(e2)) {
            this.toHir.warning("Division by zero.");
        } else if (this.is1(e2)) {
            if (this.fDbgLevel > 3) {
                this.message(4, "v/1 --> v: " + ToC.tos(e));
            }
            return e1;
        }
        return e;
    }

    protected Exp atMod(Exp e) {
        super.atMod(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        if (this.is0(e2)) {
            this.toHir.warning("Division by zero.");
        } else if (this.is1(e2)) {
            if (this.fDbgLevel > 3) {
                this.message(4, "v%1 --> 0: " + ToC.tos(e));
            }
            this.cutter.visitExp(e1);
            return this.toHir.new0Node();
        }
        return e;
    }

    protected Exp atAnd(Exp e) {
        super.atAnd(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        if (this.is0(e1)) {
            if (this.fDbgLevel > 3) {
                this.message(4, "0&v --> 0" + e);
            }
            this.cutter.visitExp(e2);
            return this.toHir.new0Node();
        }
        if (this.is0(e2)) {
            if (this.fDbgLevel > 3) {
                this.message(4, "v&0 --> 0: " + ToC.tos(e));
            }
            this.cutter.visitExp(e1);
            return this.toHir.new0Node();
        }
        if (e1.getOperator() == 5 && this.masksPerfectly(e2, (Const)e1.getSym())) {
            if (this.fDbgLevel > 3) {
                this.message(4, "ALL1&v --> v: " + ToC.tos(e));
            }
            return e2;
        }
        if (e2.getOperator() == 5 && this.masksPerfectly(e1, (Const)e2.getSym())) {
            if (this.fDbgLevel > 3) {
                this.message(4, "v&ALL1 --> v: " + ToC.tos(e));
            }
            return e1;
        }
        return e;
    }

    protected Exp atOr(Exp e) {
        super.atOr(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        if (this.is0(e1)) {
            if (this.fDbgLevel > 3) {
                this.message(4, "0|v --> v: " + ToC.tos(e));
            }
            return e2;
        }
        if (this.is0(e2)) {
            if (this.fDbgLevel > 3) {
                this.message(4, "v|0 --> v: " + ToC.tos(e));
            }
            return e1;
        }
        if (e1.getOperator() == 5 && this.masksPerfectly(e2, (Const)e1.getSym())) {
            if (this.fDbgLevel > 3) {
                this.message(4, "ALL1|v --> ALL1: " + ToC.tos(e));
            }
            this.cutter.visitExp(e2);
            return e1;
        }
        if (e2.getOperator() == 5 && this.masksPerfectly(e1, (Const)e2.getSym())) {
            if (this.fDbgLevel > 3) {
                this.message(4, "v|ALL1 --> ALL1: " + ToC.tos(e));
            }
            this.cutter.visitExp(e1);
            return e2;
        }
        return e;
    }

    protected Exp atXor(Exp e) {
        super.atXor(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        if (this.is0(e1)) {
            if (this.fDbgLevel > 3) {
                this.message(4, "v^0 --> v: " + ToC.tos(e));
            }
            return e2;
        }
        if (this.is0(e2)) {
            if (this.fDbgLevel > 3) {
                this.message(4, "0^v --> v: " + ToC.tos(e));
            }
            return e1;
        }
        return e;
    }

    protected Exp atCmpEq(Exp e) {
        Sym s2;
        Sym s1;
        super.atCmpEq(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        switch (this.getCompareRelation(e1, e2)) {
            case 0: {
                return this.alwaysTrue("==", e);
            }
            case -4: 
            case 4: {
                return this.alwaysFalse("==", e);
            }
        }
        if (e1.getOperator() == 5) {
            Exp tmp = e1;
            e1 = e2;
            e2 = tmp;
        }
        if (e1.getOperator() == 79 && e2.getOperator() == 5) {
            Exp e12 = e1.getExp2();
            Exp e13 = (Exp)e1.getChild(3);
            if (e12.getOperator() == 5 && e13.getOperator() == 5) {
                switch (this.getCompareRelationOfConst((Const)e12.getSym(), (Const)e2.getSym())) {
                    case 0: {
                        switch (this.getCompareRelationOfConst((Const)e13.getSym(), (Const)e2.getSym())) {
                            case -4: 
                            case 4: {
                                if (this.fDbgLevel > 3) {
                                    this.message(4, "simplize: " + ToC.tos(e));
                                }
                                return e1.getExp1();
                            }
                        }
                        break;
                    }
                    case -4: 
                    case 4: {
                        switch (this.getCompareRelationOfConst((Const)e13.getSym(), (Const)e2.getSym())) {
                            case 0: {
                                if (this.fDbgLevel > 3) {
                                    this.message(4, "imvert: " + ToC.tos(e));
                                }
                                return this.inverter.visitExp(e1.getExp1());
                            }
                        }
                    }
                }
            }
        }
        if ((s1 = this.findAddressedSym(e1)) != null) {
            s2 = this.findAddressedSym(e2);
            if (s2 != null) {
                if (this.fDbgLevel > 3) {
                    this.message(4, "addr==addr --> " + (s1 == s2) + ": " + ToC.tos(e));
                }
                return s1 == s2 ? this.toHir.newTrueNode() : this.toHir.newFalseNode();
            }
            Const c2 = this.findConstantSym(e2);
            if (c2 != null && c2.longValue() == 0L) {
                if (this.fDbgLevel > 3) {
                    this.message(4, "addr==0 --> false: " + ToC.tos(e));
                }
                return this.toHir.newFalseNode();
            }
        } else {
            Const c1 = this.findConstantSym(e1);
            if (c1 != null && c1.longValue() == 0L && (s2 = this.findAddressedSym(e2)) != null) {
                if (this.fDbgLevel > 3) {
                    this.message(4, "0==addr --> false: " + ToC.tos(e));
                }
                return this.toHir.newFalseNode();
            }
        }
        return e;
    }

    protected Exp atCmpNe(Exp e) {
        Sym s2;
        Sym s1;
        super.atCmpNe(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        switch (this.getCompareRelation(e1, e2)) {
            case 0: {
                return this.alwaysFalse("!=", e);
            }
            case -4: 
            case 4: {
                return this.alwaysTrue("!=", e);
            }
        }
        if (e1.getOperator() == 5) {
            Exp tmp = e1;
            e1 = e2;
            e2 = tmp;
        }
        if (e1.getOperator() == 79 && e2.getOperator() == 5) {
            Exp e12 = e1.getExp2();
            Exp e13 = (Exp)e1.getChild(3);
            if (e12.getOperator() == 5 && e13.getOperator() == 5) {
                switch (this.getCompareRelationOfConst((Const)e12.getSym(), (Const)e2.getSym())) {
                    case 0: {
                        switch (this.getCompareRelationOfConst((Const)e13.getSym(), (Const)e2.getSym())) {
                            case -4: 
                            case 4: {
                                if (this.fDbgLevel > 3) {
                                    this.message(4, "invert: " + ToC.tos(e));
                                }
                                return this.inverter.visitExp(e1.getExp1());
                            }
                        }
                        break;
                    }
                    case -4: 
                    case 4: {
                        switch (this.getCompareRelationOfConst((Const)e13.getSym(), (Const)e2.getSym())) {
                            case 0: {
                                if (this.fDbgLevel > 3) {
                                    this.message(4, "simplize: " + ToC.tos(e));
                                }
                                return e1.getExp1();
                            }
                        }
                    }
                }
            }
        }
        if ((s1 = this.findAddressedSym(e1)) != null) {
            s2 = this.findAddressedSym(e2);
            if (s2 != null) {
                if (this.fDbgLevel > 3) {
                    this.message(4, "addr!=addr --> " + (s1 != s2) + ": " + ToC.tos(e));
                }
                return s1 != s2 ? this.toHir.newTrueNode() : this.toHir.newFalseNode();
            }
            Const c2 = this.findConstantSym(e2);
            if (c2 != null && c2.longValue() == 0L) {
                if (this.fDbgLevel > 3) {
                    this.message(4, "addr!=0 --> true: " + ToC.tos(e));
                }
                return this.toHir.newTrueNode();
            }
        } else {
            Const c1 = this.findConstantSym(e1);
            if (c1 != null && c1.longValue() == 0L && (s2 = this.findAddressedSym(e2)) != null) {
                if (this.fDbgLevel > 3) {
                    this.message(4, "0!=addr --> true: " + ToC.tos(e));
                }
                return this.toHir.newTrueNode();
            }
        }
        return e;
    }

    protected Exp atCmpGt(Exp e) {
        super.atCmpGt(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        switch (this.getCompareRelation(e1, e2)) {
            case -4: 
            case -2: 
            case 0: {
                return this.alwaysFalse(">", e);
            }
            case 4: {
                return this.alwaysTrue(">", e);
            }
        }
        return e;
    }

    protected Exp atCmpGe(Exp e) {
        super.atCmpGe(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        switch (this.getCompareRelation(e1, e2)) {
            case -4: {
                return this.alwaysFalse(">=", e);
            }
            case 0: 
            case 2: 
            case 4: {
                return this.alwaysTrue(">=", e);
            }
        }
        return e;
    }

    protected Exp atCmpLt(Exp e) {
        super.atCmpLt(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        switch (this.getCompareRelation(e1, e2)) {
            case -4: {
                return this.alwaysTrue("<", e);
            }
            case 0: 
            case 2: 
            case 4: {
                return this.alwaysFalse("<", e);
            }
        }
        return e;
    }

    protected Exp atCmpLe(Exp e) {
        super.atCmpLe(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        switch (this.getCompareRelation(e1, e2)) {
            case -4: 
            case -2: 
            case 0: {
                return this.alwaysTrue("<=", e);
            }
            case 4: {
                return this.alwaysFalse("<=", e);
            }
        }
        return e;
    }

    protected Exp atLShift(Exp e) {
        super.atLShift(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        if (e2.getOperator() == 5) {
            long value = ((Const)e2.getSym()).longValue();
            if (value == 0L) {
                if (this.fDbgLevel > 3) {
                    this.message(4, "v<<0 --> v: " + ToC.tos(e));
                }
                return e1;
            }
            long size = 8L * e.getType().getSizeValue();
            if (value <= -size || size <= value) {
                this.toHir.warning("left shift of more than type size.");
                if (value <= -size && e.getType().isUnsigned() || size <= value) {
                    if (this.fDbgLevel > 3) {
                        this.message(4, "v<<MORE --> 0: " + ToC.tos(e));
                    }
                    this.cutter.visitExp(e1);
                    return this.toHir.new0Node();
                }
            }
        }
        return e;
    }

    protected Exp atARShift(Exp e) {
        super.atARShift(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        if (e2.getOperator() == 5) {
            long value = ((ConstNode)e2).getIntValue();
            if (value == 0L) {
                if (this.fDbgLevel > 3) {
                    this.message(4, "v>>0 --> v: " + ToC.tos(e));
                }
                return e1;
            }
            long size = 8L * e1.getType().getSizeValue();
            if (value <= -size || size <= value) {
                this.toHir.warning("arithmetic right shift of more than type size.");
                if (value <= -size || size <= value && e1.getType().isUnsigned()) {
                    if (this.fDbgLevel > 3) {
                        this.message(4, "v>>MORE --> 0: " + ToC.tos(e));
                    }
                    this.cutter.visitExp(e1);
                    return this.toHir.new0Node();
                }
            }
        }
        return e;
    }

    protected Exp atRShift(Exp e) {
        super.atRShift(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        if (e2.getOperator() == 5) {
            long value = ((ConstNode)e2).getIntValue();
            if (value == 0L) {
                if (this.fDbgLevel > 3) {
                    this.message(4, "v>>>0 --> v: " + ToC.tos(e));
                }
                return e1;
            }
            long size = 8L * e1.getType().getSizeValue();
            if (value <= -size || size <= value) {
                this.toHir.warning("right shift of more than type size.");
                if (this.fDbgLevel > 3) {
                    this.message(4, "v>>>MORE --> 0: " + ToC.tos(e));
                }
                this.cutter.visitExp(e1);
                return this.toHir.new0Node();
            }
        }
        return e;
    }

    protected Exp atOffset(Exp e) {
        Type t1;
        super.atOffset(e);
        Exp e1 = e.getExp1();
        Exp e2 = e.getExp2();
        if (e1.getOperator() == 7 && e2.getOperator() == 7 && ((VarNode)e1).getVar() == ((VarNode)e2).getVar() && !(t1 = e1.getType()).isVolatile()) {
            return this.toCast.cast(t1, this.toHir.new0Node());
        }
        return e;
    }

    protected Exp atLgAnd(Exp e) {
        ToHirCOpt2 child = this.sureChild();
        Exp e1 = child.visitExp(e.getExp1());
        if (e1.getOperator() == 5) {
            if (((ConstNode)e1).getIntValue() == 0) {
                if (this.fDbgLevel > 3) {
                    this.message(4, "false&&e2 --> false: " + ToC.tos(e));
                }
                this.buffer.addPrev(child.buffer);
                return e1;
            }
            if (this.fDbgLevel > 3) {
                this.message(4, "true&&e2 --> e2: " + ToC.tos(e));
            }
            this.buffer.addPrev(child.buffer);
            return this.visitExp(e.getExp2());
        }
        e.setChild1(child.buffer.toExp(e1));
        Exp e2 = child.visitExp(e.getExp2());
        e.setChild2(child.buffer.toExp(e2));
        return e;
    }

    protected Exp atLgOr(Exp e) {
        ToHirCOpt2 child = this.sureChild();
        Exp e1 = child.visitExp(e.getExp1());
        if (e1.getOperator() == 5) {
            if (((ConstNode)e1).getIntValue() == 0) {
                if (this.fDbgLevel > 3) {
                    this.message(4, "false||e2 --> e2: " + ToC.tos(e));
                }
                this.buffer.addPrev(child.buffer);
                return this.visitExp(e.getExp2());
            }
            if (this.fDbgLevel > 3) {
                this.message(4, "true||e2 --> true: " + ToC.tos(e));
            }
            this.buffer.addPrev(child.buffer);
            return e1;
        }
        e.setChild1(child.buffer.toExp(e1));
        Exp e2 = child.visitExp(e.getExp2());
        e.setChild2(child.buffer.toExp(e2));
        return e;
    }

    protected Exp atSelect(Exp e) {
        ToHirCOpt2 child = this.sureChild();
        Exp e1 = child.visitExp(e.getExp1());
        if (e1.getOperator() == 5) {
            if (e1.getConstSym().doubleValue() == 0.0) {
                if (this.fDbgLevel > 3) {
                    this.message(4, "false?e2:e3 --> e3: " + ToC.tos(e));
                }
                this.buffer.addPrev(child.buffer);
                return this.visitExp((Exp)e.getChild(3));
            }
            if (this.fDbgLevel > 3) {
                this.message(4, "true?e2:e3 --> e2: " + ToC.tos(e));
            }
            this.buffer.addPrev(child.buffer);
            return this.visitExp(e.getExp2());
        }
        e.setChild1(child.buffer.toExp(e1));
        e.setChild2(child.buffer.toExp(child.visitExp(e.getExp2())));
        e.setChild(3, child.buffer.toExp(child.visitExp((Exp)e.getChild(3))));
        return e;
    }

    private boolean is0(Exp e) {
        return e.getOperator() == 5 && this.toHir.isArithmetic(e.getType()) && e.getConstSym().doubleValue() == 0.0;
    }

    private boolean is1(Exp e) {
        return e.getOperator() == 5 && this.toHir.isArithmetic(e.getType()) && e.getConstSym().doubleValue() == 1.0;
    }

    private boolean masksPerfectly(Exp e1, Const c2) {
        if (this.toHir.isIntegral(e1.getType()) && this.toHir.isIntegral(c2.getSymType())) {
            long value;
            long max = -1L << (int)(e1.getType().getSizeValue() * 8L) ^ 0xFFFFFFFFFFFFFFFFL;
            return (max | (value = c2.longValue())) == value;
        }
        return false;
    }

    private Const findConstantSym(Exp e) {
        block4: while (true) {
            switch (e.getOperator()) {
                case 65: {
                    e = e.getExp1();
                    continue block4;
                }
                case 5: {
                    Const c = (Const)((ConstNode)e).getSym();
                    if (c.getSymKind() == 6) break block4;
                    return c;
                }
            }
            break;
        }
        return null;
    }

    private Sym findAddressedSym(Exp e) {
        block8: while (true) {
            switch (e.getOperator()) {
                case 65: {
                    if ((e = e.getExp1()).getType().getSizeValue() >= this.toHir.typeVoidPtr.getSizeValue()) continue block8;
                    return null;
                }
                case 64: 
                case 66: {
                    switch (e.getExp1().getOperator()) {
                        case 7: 
                        case 9: {
                            return ((SymNode)e.getExp1()).getSym();
                        }
                    }
                    return null;
                }
                case 5: {
                    Const c = (Const)((ConstNode)e).getSym();
                    if (c.getSymKind() != 6) break block8;
                    return c;
                }
            }
            break;
        }
        return null;
    }

    private int getCompareRelation(Exp e1, Exp e2) {
        if (e1.getOperator() == 5) {
            if (e2.getOperator() == 5) {
                return this.getCompareRelationOfConst((Const)e1.getSym(), (Const)e2.getSym());
            }
            return this.getCompareRelationOfType((Const)e1.getSym(), e2.getType());
        }
        if (e2.getOperator() == 5) {
            return -this.getCompareRelationOfType((Const)e2.getSym(), e1.getType());
        }
        return 9;
    }

    private int getCompareRelationOfConst(Const c1, Const c2) {
        if (this.toHir.isScalar(c1.getSymType()) && this.toHir.isScalar(c2.getSymType())) {
            double d1 = c1.doubleValue();
            double d2 = c2.doubleValue();
            if (this.fDbgLevel > 3) {
                this.message(6, "getCompareRelationOfConst D1=" + d1 + " D2=" + d2);
            }
            return d1 == d2 ? 0 : (d1 < d2 ? -4 : 4);
        }
        return 9;
    }

    private int getCompareRelationOfType(Const c1, Type t2) {
        Type t1 = c1.getSymType();
        Type t = this.toCast.getCompareType(t1, t2);
        if (this.toHir.isIntegral(t)) {
            if (t.isUnsigned()) {
                double d1 = c1.longValue();
                double max = Math.pow(256.0, t2.getSizeValue()) - 1.0;
                if (this.fDbgLevel > 3) {
                    this.message(6, "getCompareRelationOfType UNSIGNED D1=" + d1 + " MAX=" + max);
                }
                if (d1 < 0.0) {
                    d1 = d1 - -9.223372036854776E18 - -9.223372036854776E18;
                }
                if (d1 == 0.0) {
                    return -2;
                }
                if (d1 < max) {
                    return 9;
                }
                if (d1 == max) {
                    return 2;
                }
                return 4;
            }
            double d1 = c1.longValue();
            double min = -Math.pow(256.0, t2.getSizeValue()) / 2.0;
            double max = Math.pow(256.0, t2.getSizeValue()) / 2.0 - 1.0;
            if (this.fDbgLevel > 3) {
                this.message(6, "getCompareRelationOfType SIGNED D1=" + d1 + " MIN=" + min + " MAX=" + max);
            }
            if (d1 < min) {
                return -4;
            }
            if (d1 == min) {
                return -2;
            }
            if (d1 < max) {
                return 9;
            }
            if (d1 == max) {
                return 2;
            }
            return 4;
        }
        return 9;
    }

    private Exp alwaysTrue(String op, Exp e) {
        if (this.fDbgLevel > 3) {
            this.message(4, op + " --> true: " + ToC.tos(e));
        }
        this.cutter.visitExp(e);
        return this.toHir.newTrueNode();
    }

    private Exp alwaysFalse(String op, Exp e) {
        if (this.fDbgLevel > 3) {
            this.message(4, op + " --> false: " + ToC.tos(e));
        }
        this.cutter.visitExp(e);
        return this.toHir.newFalseNode();
    }
}

