/*
 * Decompiled with CFR 0.152.
 */
package coins.casttohir;

import coins.ir.IrList;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.BlockStmtImpl;
import coins.ir.hir.ConstNode;
import coins.ir.hir.Exp;
import coins.ir.hir.ExpStmt;
import coins.ir.hir.FunctionExp;
import coins.ir.hir.IfStmt;
import coins.ir.hir.JumpStmt;
import coins.ir.hir.LabeledStmt;
import coins.ir.hir.LoopStmt;
import coins.ir.hir.ReturnStmt;
import coins.ir.hir.Stmt;
import coins.ir.hir.StmtImpl;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SwitchStmt;
import coins.ir.hir.SymNode;
import coins.sym.Const;
import coins.sym.Label;
import coins.sym.Param;
import coins.sym.StringConst;
import coins.sym.Subp;
import coins.sym.Sym;
import coins.sym.SymIterator;
import coins.sym.SymTable;
import coins.sym.Var;
import java.util.ListIterator;

final class ToC {
    private static final String[] operators = new String[100];
    private static final int[] ranks = new int[100];
    private static final String[] visibility = new String[10];
    private static final String[] storage = new String[10];

    ToC() {
    }

    public static String getOp(int i) {
        return operators[i];
    }

    private static String getIndent(int n) {
        if (n <= 0) {
            return "";
        }
        StringBuffer buf = new StringBuffer(n);
        while (n-- > 0) {
            buf.append(' ');
        }
        return buf.toString();
    }

    public static String tos(SymTable t, int n) {
        if (t == null) {
            return "";
        }
        StringBuffer buf = new StringBuffer();
        String indent = ToC.getIndent(n);
        SymIterator i = t.getSymIterator();
        while (i.hasNext()) {
            Sym s = i.next();
            switch (s.getSymKind()) {
                case 8: {
                    Var var = (Var)s;
                    buf.append(indent).append(visibility[var.getVisibility()]).append(storage[var.getStorageClass()]).append(var.getSymType()).append(' ').append(s.getName());
                    if (var.getInitialValue() != null) {
                        buf.append("=").append(ToC.tos(var.getInitialValue()));
                    }
                    buf.append(";\n");
                    break;
                }
                case 12: {
                    Subp subp = (Subp)s;
                    buf.append(indent).append(visibility[subp.getVisibility()]).append(s.getName()).append('(');
                    ListIterator j = subp.getParamList().iterator();
                    while (j.hasNext()) {
                        Param param = (Param)j.next();
                        buf.append('\n').append(indent).append(' ').append(visibility[param.getVisibility()]).append(storage[param.getStorageClass()]).append(param.getSymType()).append(' ').append(param.getName()).append(',');
                    }
                    buf.append(')');
                    if (subp.getHirBody() != null) {
                        buf.append('\n').append(ToC.tos(subp.getHirBody(), n + 1));
                        break;
                    }
                    buf.append(";\n");
                }
            }
        }
        return buf.toString();
    }

    public static String tos(SubpDefinition h, int n) {
        return ToC.tos(h.getHirBody(), n + 1);
    }

    public static String tos(Stmt s, int n) {
        String indent = ToC.getIndent(n);
        if (s == null) {
            return indent + ";";
        }
        StringBuffer buf = new StringBuffer();
        switch (s.getOperator()) {
            case 35: {
                buf.append(indent).append("{\n").append(ToC.tos(((BlockStmtImpl)s).getSymTable(), n + 1));
                Stmt i = ((BlockStmtImpl)s).getFirstStmt();
                while (i != null) {
                    buf.append(ToC.tos(i, n + 1));
                    i = ((StmtImpl)i).getNextStmt();
                }
                buf.append(indent).append("}\n");
                break;
            }
            case 21: {
                buf.append(indent).append(((LabeledStmt)s).getLabel());
                if (((LabeledStmt)s).getStmt() != null) {
                    buf.append(":\n").append(ToC.tos(((LabeledStmt)s).getStmt(), n));
                    break;
                }
                buf.append(":;\n");
                break;
            }
            case 22: {
                buf.append(indent).append(ToC.tos(((AssignStmt)s).getLeftSide())).append(" = ").append(ToC.tos(((AssignStmt)s).getRightSide())).append(";\n");
                break;
            }
            case 23: {
                buf.append(indent).append("if( ").append(ToC.tos(((IfStmt)s).getIfCondition())).append(" )\n").append(ToC.tos(((IfStmt)s).getThenPart(), n + 1)).append(indent).append("else\n").append(ToC.tos(((IfStmt)s).getElsePart(), n + 1));
                break;
            }
            case 24: {
                buf.append(indent).append("while( ").append(ToC.tos(((LoopStmt)s).getLoopStartCondition())).append(" )\n").append(ToC.tos(((LoopStmt)s).getLoopBodyPart(), n + 1));
                break;
            }
            case 25: {
                buf.append(ToC.tos(((LoopStmt)s).getLoopInitPart(), n)).append(indent).append("for(; ").append(ToC.tos(((LoopStmt)s).getLoopStartCondition())).append("; )\n").append(indent).append("{\n").append(ToC.tos(((LoopStmt)s).getLoopBodyPart(), n + 1)).append(ToC.tos(((LoopStmt)s).getLoopStepPart(), n + 1)).append(indent).append("}\n");
                break;
            }
            case 26: {
                buf.append(indent).append("do\n").append(ToC.tos(((LoopStmt)s).getLoopBodyPart(), n + 1)).append(indent).append("while( ").append(ToC.tos(((LoopStmt)s).getLoopEndCondition())).append(indent).append(" ); )\n");
                break;
            }
            case 28: {
                buf.append(indent).append("goto ").append(((JumpStmt)s).getLabel()).append(";\n");
                break;
            }
            case 32: {
                buf.append(indent).append("switch( ").append(ToC.tos(((SwitchStmt)s).getSelectionExp())).append(" )\n");
                if (((SwitchStmt)s).getBodyStmt().getOperator() == 35) {
                    BlockStmtImpl block = (BlockStmtImpl)((SwitchStmt)s).getBodyStmt();
                    buf.append(indent).append("{\n").append(ToC.tos(block.getSymTable(), n + 1));
                    Stmt i = block.getFirstStmt();
                    while (i != null) {
                        Const c;
                        if (i.getOperator() == 21 && (c = ToC.getConstByLabel((SwitchStmt)s, ((LabeledStmt)i).getLabel())) != null) {
                            buf.append(indent).append("case ").append(c.intValue()).append(':');
                        } else {
                            buf.append(ToC.tos(i, n));
                        }
                        i = ((StmtImpl)i).getNextStmt();
                    }
                    buf.append(indent).append("}\n");
                    break;
                }
                buf.append(ToC.tos(((SwitchStmt)s).getBodyStmt(), n + 1));
                break;
            }
            case 34: {
                buf.append(indent).append("return ").append(ToC.tos(((ReturnStmt)s).getReturnValue())).append(";\n");
                break;
            }
            case 36: {
                buf.append(indent).append(ToC.tos(((ExpStmt)s).getExp())).append(";\n");
                break;
            }
            default: {
                buf.append(indent).append("STMTERR\n");
            }
        }
        return buf.toString();
    }

    private static Const getConstByLabel(SwitchStmt s, Label l) {
        for (int i = 0; i < s.getCaseCount(); ++i) {
            if (s.getCaseLabel(i) != l) continue;
            return s.getCaseConst(i);
        }
        return null;
    }

    public static String tos(Exp e) {
        if (e == null) {
            return "";
        }
        switch (e.getOperator()) {
            case 5: {
                Const y = ((ConstNode)e).getConstSym();
                switch (y.getSymKind()) {
                    case 4: {
                        return Long.toString(y.longValue());
                    }
                    case 5: {
                        return Double.toString(y.doubleValue());
                    }
                    case 6: {
                        return "\"" + ((StringConst)y).getStringBody() + "\"";
                    }
                }
                return "SYMERR";
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 12: {
                return ((SymNode)e).getSymNodeSym().getName();
            }
            case 17: {
                return ToC.tos(e, 1) + "[" + ToC.tos(e, 2) + "]";
            }
            case 66: 
            case 67: {
                return ToC.tos(e, 1);
            }
            case 70: {
                return "sizeof(" + ToC.tos(e.getExp1()) + ")";
            }
            case 33: {
                StringBuffer buf = new StringBuffer();
                buf.append(ToC.tos(e, 1)).append("(");
                IrList actuallist = ((FunctionExp)e).getParamList();
                int actualsize = actuallist.size();
                for (int i = 0; i < actualsize; ++i) {
                    if (i != 0) {
                        buf.append(",");
                    }
                    buf.append(ToC.tos((Exp)actuallist.get(i)));
                }
                buf.append(")");
                return buf.toString();
            }
            case 19: 
            case 20: 
            case 22: 
            case 38: 
            case 39: 
            case 41: 
            case 42: 
            case 43: 
            case 46: 
            case 47: 
            case 48: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 58: 
            case 59: 
            case 60: 
            case 76: 
            case 77: 
            case 78: 
            case 80: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 95: {
                return ToC.tos(e, 1) + operators[e.getOperator()] + ToC.tos(e, 2);
            }
            case 62: 
            case 63: 
            case 64: 
            case 68: 
            case 81: 
            case 82: 
            case 83: {
                return operators[e.getOperator()] + ToC.tos(e, 1);
            }
            case 65: {
                return "(" + e.getType() + ")" + ToC.tos(e, 1);
            }
            case 73: {
                return "NULL";
            }
            case 79: {
                return ToC.tos(e, 1) + "?" + ToC.tos(e, 2) + ":" + ToC.tos(e, 3);
            }
            case 84: 
            case 85: {
                return ToC.tos(e, 1) + operators[e.getOperator()];
            }
        }
        return "OPERR";
    }

    private static String tos(Exp e, int i) {
        int cr;
        Exp child = (Exp)e.getChild(i);
        if (child == null) {
            return "CHILDERR";
        }
        int pr = ranks[e.getOperator()];
        if (pr > (cr = ranks[child.getOperator()]) || pr == cr && i != 1) {
            return "(" + ToC.tos(child) + ")";
        }
        return ToC.tos(child);
    }

    static {
        ToC.ranks[5] = 99;
        ToC.ranks[6] = 99;
        ToC.ranks[7] = 99;
        ToC.ranks[8] = 99;
        ToC.ranks[9] = 99;
        ToC.ranks[10] = 99;
        ToC.ranks[11] = 99;
        ToC.ranks[12] = 99;
        ToC.ranks[33] = 16;
        ToC.ranks[17] = 16;
        ToC.ranks[19] = 16;
        ToC.operators[19] = ".";
        ToC.ranks[20] = 16;
        ToC.operators[20] = "->";
        ToC.ranks[84] = 16;
        ToC.operators[84] = "++";
        ToC.ranks[85] = 16;
        ToC.operators[85] = "--";
        ToC.ranks[82] = 15;
        ToC.operators[82] = "++";
        ToC.ranks[83] = 15;
        ToC.operators[83] = "--";
        ToC.ranks[63] = 15;
        ToC.operators[63] = "-";
        ToC.ranks[62] = 15;
        ToC.operators[62] = "~";
        ToC.ranks[81] = 15;
        ToC.operators[81] = "!";
        ToC.ranks[64] = 15;
        ToC.operators[64] = "&";
        ToC.ranks[68] = 15;
        ToC.operators[68] = "*";
        ToC.ranks[70] = 15;
        ToC.ranks[65] = 14;
        ToC.ranks[41] = 13;
        ToC.operators[41] = "*";
        ToC.ranks[42] = 13;
        ToC.operators[42] = "/";
        ToC.ranks[43] = 13;
        ToC.operators[43] = "%";
        ToC.ranks[38] = 12;
        ToC.operators[38] = "+";
        ToC.ranks[39] = 12;
        ToC.operators[39] = "-";
        ToC.ranks[76] = 12;
        ToC.operators[76] = "-";
        ToC.ranks[58] = 11;
        ToC.operators[58] = "<<";
        ToC.ranks[59] = 11;
        ToC.operators[59] = ">>>";
        ToC.ranks[60] = 11;
        ToC.operators[60] = ">>";
        ToC.ranks[53] = 10;
        ToC.operators[53] = ">";
        ToC.ranks[54] = 10;
        ToC.operators[54] = ">=";
        ToC.ranks[55] = 10;
        ToC.operators[55] = "<";
        ToC.ranks[56] = 10;
        ToC.operators[56] = "<=";
        ToC.ranks[51] = 9;
        ToC.operators[51] = "==";
        ToC.ranks[52] = 9;
        ToC.operators[52] = "!=";
        ToC.ranks[46] = 8;
        ToC.operators[46] = "&";
        ToC.ranks[48] = 7;
        ToC.operators[48] = "^";
        ToC.ranks[47] = 6;
        ToC.operators[47] = "|";
        ToC.ranks[77] = 5;
        ToC.operators[77] = "&&";
        ToC.ranks[78] = 4;
        ToC.operators[78] = "||";
        ToC.ranks[79] = 3;
        ToC.ranks[22] = 2;
        ToC.operators[22] = " = ";
        ToC.ranks[86] = 2;
        ToC.operators[86] = " += ";
        ToC.ranks[87] = 2;
        ToC.operators[87] = " -= ";
        ToC.ranks[88] = 2;
        ToC.operators[88] = " *= ";
        ToC.ranks[89] = 2;
        ToC.operators[89] = " /= ";
        ToC.ranks[90] = 2;
        ToC.operators[90] = " %= ";
        ToC.ranks[91] = 2;
        ToC.operators[91] = " <<= ";
        ToC.ranks[92] = 2;
        ToC.operators[92] = " >>= ";
        ToC.ranks[93] = 2;
        ToC.operators[93] = " &= ";
        ToC.ranks[94] = 2;
        ToC.operators[94] = " |= ";
        ToC.ranks[95] = 2;
        ToC.operators[95] = " ^= ";
        ToC.ranks[80] = 1;
        ToC.operators[80] = ",";
        ToC.visibility[1] = "EXTERN ";
        ToC.visibility[2] = "PUBLIC ";
        ToC.visibility[3] = "PROTECTED ";
        ToC.visibility[4] = "PRIVATE ";
        ToC.visibility[5] = "COMPILEUNIT ";
        ToC.storage[6] = "STATIC ";
        ToC.storage[7] = "AUTO ";
        ToC.storage[8] = "REGISTER ";
    }
}

