/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.util;

public class Misc {
    public static void sort(int[] a, int n) {
        Misc.quicksort(a, 0, n - 1);
    }

    private static void quicksort(int[] a, int m, int n) {
        int x;
        if (n <= m) {
            return;
        }
        int i = m - 1;
        int j = n;
        int v = a[n];
        while (true) {
            if (a[++i] < v) {
                continue;
            }
            while (--j > i && a[j] >= v) {
            }
            if (i >= j) break;
            x = a[i];
            a[i] = a[j];
            a[j] = x;
        }
        x = a[i];
        a[i] = a[n];
        a[n] = x;
        Misc.quicksort(a, m, i - 1);
        Misc.quicksort(a, i + 1, n);
    }

    public static int clp2(int x) {
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return x + 1;
    }

    public static boolean powersOf2(long x) {
        return (x - 1L & x) == 0L;
    }

    public static int binlog(long pattern) {
        int[] logtbl = new int[]{0, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};
        if (pattern == 0L) {
            return -1;
        }
        int n = 0;
        if ((pattern & 0xFFFFFFFFFFFFFFFFL) == 0L) {
            pattern >>= 32;
            n = 32;
        }
        if ((pattern & 0xFFFFL) == 0L) {
            pattern >>= 16;
            n += 16;
        }
        if ((pattern & 0xFFL) == 0L) {
            pattern >>= 8;
            n += 8;
        }
        if ((pattern & 0xFL) == 0L) {
            pattern >>= 4;
            n += 4;
        }
        return logtbl[(int)pattern & 0xF] + n;
    }

    public static int binlog(int pattern) {
        int[] logtbl = new int[]{0, 0, 1, 0, 2, 0, 1, 0, 3, 0, 1, 0, 2, 0, 1, 0};
        if (pattern == 0) {
            return -1;
        }
        int n = 0;
        if ((pattern & 0xFFFF) == 0) {
            pattern >>= 16;
            n = 16;
        }
        if ((pattern & 0xFF) == 0) {
            pattern >>= 8;
            n += 8;
        }
        if ((pattern & 0xF) == 0) {
            pattern >>= 4;
            n += 4;
        }
        return logtbl[pattern & 0xF] + n;
    }

    public static int count1s(int x) {
        int x1 = ((x & 0xAAAAAAAA) >>> 1) + (x & 0x55555555);
        int x2 = ((x1 & 0xCCCCCCCC) >>> 2) + (x1 & 0x33333333);
        int x3 = ((x2 & 0xF0F0F0F0) >>> 4) + (x2 & 0xF0F0F0F);
        int x4 = ((x3 & 0xFF00FF00) >>> 8) + (x3 & 0xFF00FF);
        int x5 = ((x4 & 0xFFFF0000) >>> 16) + (x4 & 0xFFFF);
        return x5;
    }
}

