/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.sym;

import coins.backend.Module;
import coins.backend.SyntaxError;
import coins.backend.sym.SymAuto;
import coins.backend.sym.SymStatic;
import coins.backend.sym.SymTemp;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SymTab {
    private Map table = new HashMap();
    private BiList list = new BiList();
    private Module module;

    public SymTab(Module mod) {
        this.module = mod;
    }

    public void clear() {
        this.table.clear();
        this.list.clear();
    }

    public static SymTab makeCopyForModule(Module mod, SymTab tab) {
        SymTab t = new SymTab(mod);
        t.table = (Map)((HashMap)tab.table).clone();
        t.list = tab.list.copy();
        return t;
    }

    public Symbol addSymbol(String name, int storage, int type, int boundary, String segment, String linkage, ImList opt) {
        SymStatic sym = new SymStatic(this, name, this.module.genSymbolId(), storage, type, boundary, segment, linkage, opt);
        this.table.put(name, sym);
        this.list.add(sym);
        return sym;
    }

    public Symbol addSymbol(String name, int storage, int type, int boundary, int offset, ImList opt) {
        SymAuto sym = new SymAuto(this, name, this.module.genSymbolId(), storage, type, boundary, offset, opt);
        this.table.put(name, sym);
        this.list.add(sym);
        return sym;
    }

    public Symbol addSymbol(Symbol original, int type) {
        SymTemp sym = new SymTemp(this, original, this.module.genSymbolId(), type);
        this.table.put(sym.name, sym);
        this.list.add(sym);
        return sym;
    }

    public Symbol addSymbol(ImList arg) throws SyntaxError {
        Symbol sym = Symbol.parseSymbol(this, this.module.genSymbolId(), arg);
        this.table.put(sym.name, sym);
        this.list.add(sym);
        return sym;
    }

    public Symbol get(String name) {
        return (Symbol)this.table.get(name.intern());
    }

    public void remove(String name) {
        this.list.remove(this.get(name));
        this.table.remove(name);
    }

    public void remove(Symbol sym) {
        this.list.remove(sym);
        this.table.remove(sym.name);
    }

    public void sanitize() {
        BiLink p = this.list.first();
        while (!p.atEnd()) {
            Symbol sym = (Symbol)p.elem();
            BiLink next = p.next();
            if (this.get(sym.name) != sym) {
                p.unlink();
            }
            p = next;
        }
    }

    public BiList symbols() {
        return this.list;
    }

    public Iterator iterator() {
        return this.list.iterator();
    }

    public void makeReverseIndex(Symbol[] vec) {
        BiLink p = this.list.first();
        while (!p.atEnd()) {
            Symbol sym;
            vec[sym.id] = sym = (Symbol)p.elem();
            p = p.next();
        }
    }

    public int idBound() {
        return this.module.symbolIdBound();
    }

    public void printStandardForm(PrintWriter out, String indent) {
        out.println(indent + "(SYMTAB");
        BiLink p = this.list.first();
        while (!p.atEnd()) {
            out.println(indent + "  " + ((Symbol)p.elem()).contents());
            p = p.next();
        }
        out.println(indent + ")");
    }

    public Object toSexp() {
        ImList q = ImList.list("SYMTAB");
        BiLink p = this.list.first();
        while (!p.atEnd()) {
            q = new ImList(((Symbol)p.elem()).toSexp(), q);
            p = p.next();
        }
        return q.destructiveReverse();
    }

    public void printIt(PrintWriter out) {
        out.println("Symbol table:");
        BiLink p = this.list.first();
        while (!p.atEnd()) {
            out.println("  " + ((Symbol)p.elem()).contents());
            p = p.next();
        }
    }

    public void printIt(PrintWriter out, boolean printReg) {
        out.println("Symbol table:");
        BiLink p = this.list.first();
        while (!p.atEnd()) {
            Symbol sym = (Symbol)p.elem();
            if (printReg || sym.name.charAt(0) != '%') {
                out.println("  " + sym.contents());
            }
            p = p.next();
        }
    }
}

