/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.sched;

import coins.backend.MachineParams;
import coins.backend.Type;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirNode;
import coins.backend.sched.Schedule;
import coins.backend.util.BiList;

public class LirNodeInf {
    static final int LOAD_LATENCY = 4;
    static final int PARALLEL_LATENCY = 0;
    static final LirNode MEM = new LirIconst(0, 0, 0L, null);
    static final LirNode STACK_REG = new LirIconst(0, 0, 0L, null);
    LirNode lirNode;
    Schedule schedule;
    MachineParams machineParams;

    LirNodeInf(LirNode ln, Schedule schedule) {
        this.lirNode = ln;
        this.schedule = schedule;
        this.machineParams = schedule.codeGen.getMachineParams();
    }

    BiList input() {
        BiList bl = new BiList();
        this.addRegUse(bl, this.lirNode);
        this.addMemUse(bl, this.lirNode);
        return bl;
    }

    BiList output() {
        BiList bl = new BiList();
        this.addRegDef(bl, this.lirNode);
        this.addMemDef(bl, this.lirNode);
        return bl;
    }

    int latency(int cost) {
        LirNode ln = this.lirNode;
        if (this.lirNode.opCode == 56) {
            return 0;
        }
        if (ln.opCode == 48) {
            int n = ln.nKids();
            if (n == 2 && ln.kid((int)1).opCode == 4) {
                return 1;
            }
            for (int i = 1; i < n; ++i) {
                if (!this.containsMEM(ln.kid(i)) || cost >= 4) continue;
                return 4;
            }
            return cost;
        }
        if (ln.isBranch()) {
            return 0;
        }
        return cost;
    }

    boolean containsMEM(LirNode ln) {
        switch (ln.opCode) {
            case 47: {
                return true;
            }
        }
        int n = ln.nKids();
        for (int i = 0; i < n; ++i) {
            if (!this.containsMEM(ln.kid(i))) continue;
            return true;
        }
        return false;
    }

    void addMemUse(BiList bl, LirNode ln) {
        int n = ln.nKids();
        switch (ln.opCode) {
            case 56: {
                for (int i = 0; i < n; ++i) {
                    this.addMemUse(bl, ln.kid(i));
                }
                break;
            }
            case 47: {
                bl.add(MEM);
                break;
            }
            case 48: {
                for (int i = 1; i < n; ++i) {
                    this.addMemUse(bl, ln.kid(i));
                }
                break;
            }
            case 53: {
                bl.add(MEM);
            }
            default: {
                for (int i = 0; i < n; ++i) {
                    this.addMemUse(bl, ln.kid(i));
                }
            }
        }
    }

    void addMemDef(BiList bl, LirNode ln) {
        switch (ln.opCode) {
            case 56: {
                for (int i = 0; i < ln.nKids(); ++i) {
                    this.addMemDef(bl, ln.kid(i));
                }
                break;
            }
            case 48: {
                this.addMemUse(bl, ln.kid(0));
                break;
            }
            case 53: {
                int n = ln.kid(2).nKids();
                for (int i = 0; i < n; ++i) {
                    this.addMemUse(bl, ln.kid(2).kid(i));
                }
                break;
            }
        }
    }

    void addRegUse(BiList bl, LirNode ln) {
        switch (ln.opCode) {
            case 56: {
                int n = ln.nKids();
                for (int i = n - 1; i >= 0; --i) {
                    this.addRegUse(bl, ln.kid(i));
                }
                break;
            }
            case 48: {
                if (!this.isRegisterOperand(ln.kid(0))) {
                    this.addRegUse(bl, ln.kid(0));
                }
                this.addRegUse(bl, ln.kid(1));
                break;
            }
            case 54: 
            case 58: {
                break;
            }
            case 53: {
                this.addRegUse(bl, ln.kid(0));
                this.addRegUse(bl, ln.kid(1));
                break;
            }
            case 6: 
            case 7: {
                LirNode temp = this.isStackReg(ln) ? STACK_REG : ln;
                if (bl.contains(temp)) break;
                bl.add(temp);
                break;
            }
            default: {
                int n = ln.nKids();
                for (int i = 0; i < n; ++i) {
                    this.addRegUse(bl, ln.kid(i));
                }
            }
        }
    }

    void addRegDef(BiList bl, LirNode ln) {
        switch (ln.opCode) {
            case 56: {
                int n = ln.nKids();
                for (int i = n - 1; i >= 0; --i) {
                    this.addRegDef(bl, ln.kid(i));
                }
                break;
            }
            case 48: {
                if (!this.isRegisterOperand(ln.kid(0))) break;
                this.addReg(bl, ln.kid(0));
                break;
            }
            case 58: {
                int n = ln.nKids();
                for (int i = 0; i < n; ++i) {
                    this.addReg(bl, ln.kid(i));
                }
                break;
            }
            case 53: {
                int n = ln.kid(2).nKids();
                for (int i = 0; i < n; ++i) {
                    this.addReg(bl, ln.kid(2).kid(i));
                }
                break;
            }
            case 54: {
                int n = ln.nKids();
                for (int i = 1; i < n; ++i) {
                    this.addReg(bl, ln.kid(i));
                }
                break;
            }
        }
    }

    void addReg(BiList bl, LirNode ln) {
        switch (ln.opCode) {
            case 6: 
            case 7: {
                LirNode temp = this.isStackReg(ln) ? STACK_REG : ln;
                if (bl.contains(temp)) break;
                bl.add(temp);
            }
        }
    }

    LirNode getCalleeReg(LirNode ln) {
        switch (ln.opCode) {
            case 56: {
                return this.getCalleeReg(ln.kid(0));
            }
            case 53: {
                LirNode callee = ln.kid(0);
                if (callee.opCode != 6) break;
                if (this.isStackReg(callee)) {
                    return STACK_REG;
                }
                return callee;
            }
        }
        return null;
    }

    private boolean isRegisterOperand(LirNode ln) {
        return ln.opCode == 6 || ln.opCode == 7 && ln.kid((int)0).opCode == 6;
    }

    private boolean isStackReg(LirNode ln) {
        if (!this.schedule.isX86) {
            return false;
        }
        if (ln.opCode == 7) {
            return this.isStackReg(ln.kid(0));
        }
        if (ln.opCode == 6) {
            return Type.tag(ln.type) == 4;
        }
        return false;
    }
}

