/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.sched;

import coins.backend.CantHappenException;
import coins.backend.lir.LirNode;
import coins.backend.sched.LirNodeInf;
import coins.backend.sched.Schedule;
import coins.backend.util.BiList;
import java.util.Iterator;

public class DependNode
implements Comparable {
    static final int LAST_TIME = 1000;
    static int counter = 0;
    int number = counter++;
    BiList trueDependOn = new BiList();
    BiList falseDependOn = new BiList();
    BiList dependOn;
    BiList beDepended = new BiList();
    LirNode instr;
    LirNodeInf lirInf;
    BiList input;
    BiList output;
    int latency;
    int scheduleTime;
    boolean visited = false;
    boolean dependMark = false;
    int pathLength = -1;
    int machineCodeSize;
    boolean hasDelaySlot;

    public DependNode(LirNode ln, Schedule schedule) {
        this.instr = ln;
        this.lirInf = new LirNodeInf(this.instr, schedule);
        this.input = this.lirInf.input();
        this.output = this.lirInf.output();
    }

    public int compareTo(Object dn) {
        return this.number - ((DependNode)dn).number;
    }

    void setMachineCodeSize(int size) {
        this.machineCodeSize = size;
    }

    void setLatency(int cost) {
        this.latency = this.lirInf.latency(cost);
    }

    public void letHaveDelaySlot() {
        this.hasDelaySlot = true;
    }

    public boolean hasDelaySlot() {
        return this.hasDelaySlot;
    }

    DependNode setScheduleTime(int n) {
        this.scheduleTime = this.instr.isBranch() || this.instr.opCode == 55 || this.instr.opCode == 56 ? 1000 : n;
        return this;
    }

    int scheduleTimeDcr() {
        if (this.scheduleTime > 0) {
            return this.scheduleTime--;
        }
        return 0;
    }

    boolean dependOn(DependNode dn) {
        LirNode ln;
        boolean trueDepend = false;
        boolean falseDepend = false;
        if (this == dn) {
            return false;
        }
        Iterator it = this.input.iterator();
        while (it.hasNext()) {
            ln = (LirNode)it.next();
            if (!this.contains(dn.output, ln)) continue;
            trueDepend = true;
        }
        it = this.output.iterator();
        while (it.hasNext()) {
            ln = (LirNode)it.next();
            if (!this.contains(dn.output, ln) && !this.contains(dn.input, ln)) continue;
            falseDepend = true;
        }
        if (trueDepend || falseDepend) {
            if (!dn.beDepended.contains(this)) {
                dn.beDepended.add(this);
            }
            if (trueDepend && !this.trueDependOn.contains(dn)) {
                this.trueDependOn.add(dn);
            }
            if (falseDepend && !this.falseDependOn.contains(dn)) {
                this.falseDependOn.add(dn);
            }
        }
        return trueDepend || falseDepend;
    }

    BiList dependOn(BiList list) {
        this.mark();
        this.dependMark = false;
        BiList dependList = new BiList();
        Iterator it = list.iterator();
        while (it.hasNext()) {
            DependNode dn = (DependNode)it.next();
            if (dn.dependMark) {
                dn.dependMark = false;
                dependList.add(dn);
            }
            if (dn != this) continue;
            break;
        }
        return dependList;
    }

    void mark() {
        DependNode dn;
        Iterator it = this.trueDependOn.iterator();
        while (it.hasNext()) {
            dn = (DependNode)it.next();
            if (dn.dependMark) continue;
            dn.dependMark = true;
            dn.mark();
        }
        it = this.falseDependOn.iterator();
        while (it.hasNext()) {
            dn = (DependNode)it.next();
            if (dn.dependMark) continue;
            dn.dependMark = true;
            dn.mark();
        }
    }

    public boolean deleteDepend(DependNode dn) {
        if (this.falseDependOn.removeEqual(dn) != null) {
            this.scheduleTime = this.instr.isBranch() || this.instr.opCode == 55 || this.instr.opCode == 56 ? 1000 : 0;
        }
        if (this.trueDependOn.removeEqual(dn) != null) {
            this.scheduleTime = this.instr.isBranch() || this.instr.opCode == 55 || this.instr.opCode == 56 ? 1000 : (dn.latency > 0 ? dn.latency - 1 : 0);
        }
        return this.trueDependOn.isEmpty() && this.falseDependOn.isEmpty();
    }

    public boolean isCall() {
        if (this.instr.opCode == 53) {
            return true;
        }
        return this.instr.opCode == 56 && this.instr.kid((int)0).opCode == 53;
    }

    LirNode getCalleeReg() {
        return this.lirInf.getCalleeReg(this.instr);
    }

    boolean contains(BiList bl, LirNode ln) {
        if (ln == LirNodeInf.MEM || ln == LirNodeInf.STACK_REG) {
            return bl.contains(ln);
        }
        Iterator it = bl.iterator();
        while (it.hasNext()) {
            LirNode nextLn = (LirNode)it.next();
            if (nextLn == LirNodeInf.MEM || nextLn == LirNodeInf.STACK_REG || !this.lirInf.machineParams.isOverlapped(ln, nextLn)) continue;
            return true;
        }
        return false;
    }

    int pathLength() {
        if (this.visited) {
            if (this.pathLength < 0) {
                throw new CantHappenException("cycle of DependNodes");
            }
            return this.pathLength;
        }
        this.visited = true;
        int maxLength = 0;
        Iterator it = this.beDepended.iterator();
        while (it.hasNext()) {
            DependNode dn = (DependNode)it.next();
            int length = dn.pathLength();
            if (length <= maxLength) continue;
            maxLength = length;
        }
        this.pathLength = this.latency + maxLength;
        return this.pathLength;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("\nDependNode number " + this.number + "\n");
        sb.append("  instruction:\n  ");
        sb.append(this.instr.toString() + (this.hasDelaySlot() ? " hasDelaySlot" : ""));
        sb.append("\n  input:\n  ");
        sb.append(this.input.toString());
        sb.append("\n  output:\n  ");
        sb.append(this.output.toString());
        sb.append("\n  latency:" + this.latency + "\n");
        sb.append("  scheduleTime:" + this.scheduleTime + "\n");
        sb.append("  trueDependOn: ");
        Iterator it = this.trueDependOn.iterator();
        while (it.hasNext()) {
            sb.append(((DependNode)it.next()).number + " ");
        }
        sb.append(",  falseDependOn: ");
        it = this.falseDependOn.iterator();
        while (it.hasNext()) {
            sb.append(((DependNode)it.next()).number + " ");
        }
        sb.append("\n  beDepended: ");
        it = this.beDepended.iterator();
        while (it.hasNext()) {
            sb.append(((DependNode)it.next()).number + " ");
        }
        return sb.toString();
    }
}

