/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.sched;

import coins.backend.Function;
import coins.backend.Root;
import coins.backend.lir.LirNode;
import coins.backend.sched.DependNode;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import java.util.Iterator;

public class DependGraph {
    static final int LAST_TIME = 1000;
    Function func;
    Root root;
    BiList schedulable;
    BiList unSchedulable;
    DependNode lastBranch;

    public DependGraph(Function f) {
        this.func = f;
        this.root = f.root;
        this.schedulable = new BiList();
        this.unSchedulable = new BiList();
        this.lastBranch = null;
    }

    public void newSegment() {
        this.schedulable = new BiList();
        this.unSchedulable = new BiList();
        this.lastBranch = null;
    }

    public void add(DependNode dn) {
        if (!this.foundDepend(dn)) {
            if (dn.instr.opCode == 55 || dn.instr.isBranch() || dn.instr.opCode == 56) {
                this.schedulable.add(dn.setScheduleTime(1000));
            } else {
                this.schedulable.add(dn.setScheduleTime(0));
            }
        } else {
            this.unSchedulable.add(dn);
        }
    }

    boolean foundDepend(DependNode dn) {
        DependNode node;
        boolean result = false;
        Iterator it = this.schedulable.iterator();
        while (it.hasNext()) {
            node = (DependNode)it.next();
            if (!dn.dependOn(node)) continue;
            result = true;
        }
        it = this.unSchedulable.iterator();
        while (it.hasNext()) {
            node = (DependNode)it.next();
            if (!dn.dependOn(node)) continue;
            result = true;
        }
        return result;
    }

    public void hasBranch(DependNode dn) {
        this.lastBranch = dn;
    }

    BiList scheduleInst() {
        BiList bl = new BiList();
        DependNode prevNode = null;
        DependNode prevPrevNode = null;
        while (!this.schedulable.isEmpty()) {
            DependNode dn = this.schedule();
            this.schedulable.remove(dn);
            if (dn.isCall() && dn.hasDelaySlot() && !bl.isEmpty() && prevNode.instr.opCode != 54) {
                LirNode ln = dn.getCalleeReg();
                if (ln == null || !prevNode.output.contains(ln)) {
                    bl.last().setElem(this.addDelayMark((LirNode)bl.last().elem()));
                } else if (prevPrevNode != null && !prevPrevNode.beDepended.contains(prevNode) && prevNode.machineCodeSize == 1 && prevPrevNode.instr.opCode != 54) {
                    bl.last().prev().setElem(this.addDelayMark((LirNode)bl.last().prev().elem()));
                }
            } else if (!dn.instr.isBranch() && dn.beDepended.isEmpty() && this.lastBranch != null && this.lastBranch.hasDelaySlot() && dn.instr.opCode != 54 && dn.instr.opCode != 56 && dn.machineCodeSize == 1) {
                dn.instr = this.addDelayMark(dn.instr);
            }
            bl.add(dn.instr);
            prevPrevNode = prevNode;
            prevNode = dn;
            this.findSchedulable(dn);
        }
        return bl;
    }

    private LirNode addDelayMark(LirNode ins) {
        return this.func.newLir.replaceOptions(ins, new ImList("&delay", ins.opt));
    }

    BiList scheduleLir() {
        BiList bl = new BiList();
        while (!this.schedulable.isEmpty()) {
            DependNode dn = this.schedule();
            this.schedulable.remove(dn);
            bl.add(dn.instr);
            this.findSchedulable(dn);
        }
        return bl;
    }

    DependNode schedule() {
        int minScheduleTime = 1000;
        Iterator it = this.schedulable.iterator();
        while (it.hasNext()) {
            DependNode dn1 = (DependNode)it.next();
            if (dn1.scheduleTime >= minScheduleTime) continue;
            minScheduleTime = dn1.scheduleTime;
        }
        int maxPathLength = -1;
        int maxLatency = -1;
        DependNode dnP = null;
        DependNode dnL = null;
        Iterator it2 = this.schedulable.iterator();
        while (it2.hasNext()) {
            int pathLength;
            DependNode dn1 = (DependNode)it2.next();
            if (dn1.scheduleTimeDcr() != minScheduleTime) continue;
            if (dn1.latency > maxLatency) {
                maxLatency = dn1.latency;
                dnL = dn1;
            }
            if ((pathLength = dn1.pathLength()) <= maxPathLength) continue;
            maxPathLength = pathLength;
            dnP = dn1;
        }
        if (maxLatency >= 4) {
            dnP = dnL;
        }
        if (this.root.traceOK("TMD", 1)) {
            this.root.debOut.println("----scheduled DependNode----");
            this.root.debOut.println(dnP);
        }
        return dnP;
    }

    void findSchedulable(DependNode dn) {
        Iterator it = this.unSchedulable.iterator();
        while (it.hasNext()) {
            DependNode node = (DependNode)it.next();
            if (!node.deleteDepend(dn)) continue;
            this.schedulable.add(node);
            this.unSchedulable.remove(node);
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("******DependGraph******\n");
        if (this.lastBranch != null) {
            sb.append("\n has last branch ------>\n");
        }
        sb.append("\nschedulable: -- list of schedulable nodes --\n");
        Iterator it = this.schedulable.iterator();
        while (it.hasNext()) {
            sb.append(((DependNode)it.next()).toString() + "\n");
        }
        sb.append("\nunSchedulable: -- list of unschedulable nodes --\n");
        it = this.unSchedulable.iterator();
        while (it.hasNext()) {
            sb.append(((DependNode)it.next()).toString() + "\n");
        }
        return sb.toString();
    }
}

