/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.opt;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.Type;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirFconst;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.util.BiLink;
import coins.backend.util.ImList;

public class SimpleOpt {
    public static final Trigger trig = new Trigger();
    private Function function;
    private LirFactory newLir;
    private BasicBlk[] regDefAtBlk;
    private long[] regIValue;
    private double[] regFValue;

    public void doIt(Function f) {
        this.function = f;
        FlowGraph flowGraph = f.flowGraph();
        this.newLir = f.newLir;
        int nsyms = f.localSymtab.idBound();
        this.regDefAtBlk = new BasicBlk[nsyms];
        this.regIValue = new long[nsyms];
        this.regFValue = new double[nsyms];
        BiLink p = flowGraph.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            BiLink q = blk.instrList().first();
            while (!q.atEnd()) {
                LirNode ins = (LirNode)q.elem();
                switch (ins.opCode) {
                    case 48: {
                        this.replaceNth(ins, 1, blk);
                        if (ins.kid((int)0).opCode == 47) {
                            this.optTree(ins.kid(0), blk);
                        }
                        if (ins.kid((int)0).opCode != 6) break;
                        int symid = ((LirSymRef)ins.kid((int)0)).symbol.id;
                        this.regDefAtBlk[symid] = null;
                        switch (Type.tag(ins.type)) {
                            case 2: {
                                if (ins.kid((int)1).opCode != 2) break;
                                this.regDefAtBlk[symid] = blk;
                                this.regIValue[symid] = ((LirIconst)ins.kid((int)1)).value;
                                break;
                            }
                            case 4: {
                                if (ins.kid((int)1).opCode != 3) break;
                                this.regDefAtBlk[symid] = blk;
                                this.regFValue[symid] = ((LirFconst)ins.kid((int)1)).value;
                            }
                        }
                        break;
                    }
                    case 53: {
                        this.replaceNth(ins, 0, blk);
                        this.replaceNth(ins, 1, blk);
                        if (ins.kid(2).nKids() <= 0) break;
                        LirNode lvalue = ins.kid(2).kid(0);
                        if (lvalue.opCode == 47) {
                            this.optTree(lvalue, blk);
                            break;
                        }
                        if (lvalue.opCode != 6) break;
                        this.regDefAtBlk[((LirSymRef)lvalue).symbol.id] = null;
                        break;
                    }
                    case 67: {
                        this.replaceNth(ins, 1, blk);
                        for (int j = 2; j < 3; ++j) {
                            for (int i = 0; i < ins.kid(j).nKids(); ++i) {
                                LirNode lvalue = ins.kid(j).kid(i);
                                if (lvalue.opCode == 47) {
                                    this.optTree(lvalue, blk);
                                    continue;
                                }
                                if (lvalue.opCode != 6) continue;
                                this.regDefAtBlk[((LirSymRef)lvalue).symbol.id] = null;
                            }
                        }
                        break;
                    }
                    case 50: {
                        this.replaceNth(ins, 0, blk);
                        LirNode target = null;
                        if (ins.kid((int)0).opCode != 2) break;
                        target = ((LirIconst)ins.kid((int)0)).value != 0L ? ins.kid(1) : ins.kid(2);
                        q.setElem(this.newLir.operator(49, 0, target, null));
                        blk.maintEdges();
                        break;
                    }
                    case 54: 
                    case 56: 
                    case 58: {
                        break;
                    }
                    default: {
                        this.optTree(ins, blk);
                    }
                }
                q = q.next();
            }
            p = p.next();
        }
    }

    private void replaceNth(LirNode node, int nth, BasicBlk blk) {
        LirNode newKid = this.optTree(node.kid(nth), blk);
        if (newKid != node.kid(nth)) {
            this.function.touch();
            node.setKid(nth, newKid);
        }
    }

    private LirNode optTree(LirNode node, BasicBlk blk) {
        if (node.opCode == 6) {
            int symid = ((LirSymRef)node).symbol.id;
            if (this.regDefAtBlk[symid] == blk) {
                switch (Type.tag(node.type)) {
                    case 2: {
                        return this.newLir.iconst(node.type, this.regIValue[symid], null);
                    }
                    case 4: {
                        return this.newLir.fconst(node.type, this.regFValue[symid], null);
                    }
                }
            }
            return node;
        }
        int n = node.nKids();
        for (int i = 0; i < n; ++i) {
            this.replaceNth(node, i, blk);
        }
        return this.newLir.foldConstant(node);
    }

    private static class Trigger
    implements LocalTransformer {
        private Trigger() {
        }

        public boolean doIt(Function func, ImList args) {
            new SimpleOpt().doIt(func);
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "SimpleOpt";
        }

        public String subject() {
            return "Simple Optimization (constant folding etc.)";
        }
    }
}

