/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.opt;

import coins.backend.CantHappenException;
import coins.backend.Data;
import coins.backend.Function;
import coins.backend.GlobalTransformer;
import coins.backend.LocalTransformer;
import coins.backend.Module;
import coins.backend.Type;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirNode;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.ImList;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;

public class Profiler {
    public static final Trigger trig = new Trigger();
    Module module;
    LirFactory lir;
    int counterType;
    int typeAddress;
    int counterSize;
    Symbol counterArray;
    int index;
    int nPositions = 512;
    int[] positions = new int[this.nPositions];
    int arraySize = 0;

    private void logPosition(int value) {
        if (this.arraySize >= this.nPositions) {
            int[] tmp = new int[this.nPositions * 2];
            for (int i = 0; i < this.nPositions; ++i) {
                tmp[i] = this.positions[i];
            }
            this.nPositions *= 2;
            this.positions = tmp;
        }
        this.positions[this.arraySize++] = value;
    }

    private static String stem(String old) {
        int pos = old.indexOf(46);
        return pos >= 0 ? old.substring(0, pos) : old;
    }

    private static boolean isIdentifier(char c) {
        return 'a' <= c && c <= 'z' || 'A' <= c && c <= 'Z' || '0' <= c && c <= '9' || c == '_';
    }

    private static String createIdentifier(String filename) {
        char[] str = filename.toCharArray();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < str.length; ++i) {
            if (!Profiler.isIdentifier(str[i])) continue;
            buf.append(str[i]);
        }
        return buf.toString();
    }

    Profiler(Module module) {
        this.module = module;
        this.lir = module.newLir;
        this.counterType = Type.type(2, 32L);
        this.typeAddress = module.targetMachine.typeAddress;
        this.counterSize = Type.bytes(this.counterType);
        String vecName = ("__" + Profiler.createIdentifier(Profiler.stem(module.name)) + "_countervec").intern();
        this.counterArray = module.addSymbol(vecName, 0, Type.type(1, 0L), 8, ".bss", "XREF", null);
        this.index = 0;
        module.apply(new LocalTrigger());
        this.logPosition(0);
        try {
            PrintWriter out = new PrintWriter(new FileOutputStream(Profiler.stem(module.name) + ".prf"));
            out.println("# counter table for " + module.name);
            out.println("# name: " + vecName);
            out.println("# size: " + this.counterSize + " * " + this.index);
            for (int i = 1; i < this.arraySize; ++i) {
                while (this.positions[i] != 0) {
                    out.print(this.positions[i] + " ");
                    ++i;
                }
                out.println();
            }
            out.flush();
        }
        catch (FileNotFoundException e) {
            throw new CantHappenException();
        }
    }

    class LocalTrigger
    implements LocalTransformer {
        LocalTrigger() {
        }

        public boolean doIt(Function func, ImList args) {
            FlowGraph flowGraph = func.flowGraph();
            BiLink p = flowGraph.basicBlkList.first();
            while (!p.atEnd()) {
                BasicBlk blk = (BasicBlk)p.elem();
                boolean first = true;
                BiLink q = blk.instrList().first();
                while (!q.atEnd()) {
                    int lineno;
                    LirNode ins = (LirNode)q.elem();
                    if (ins.opCode == 65 && (lineno = (int)((LirIconst)ins.kid((int)0)).value) != 0) {
                        if (first) {
                            LirNode s = Profiler.this.lir.node(48, Profiler.this.counterType, Profiler.this.lir.node(47, Profiler.this.counterType, Profiler.this.lir.node(10, Profiler.this.typeAddress, Profiler.this.lir.node(4, Profiler.this.typeAddress, Profiler.this.counterArray), Profiler.this.lir.iconst(Profiler.this.typeAddress, Profiler.this.index * Profiler.this.counterSize))), Profiler.this.lir.node(10, Profiler.this.counterType, Profiler.this.lir.node(47, Profiler.this.counterType, Profiler.this.lir.node(10, Profiler.this.typeAddress, Profiler.this.lir.node(4, Profiler.this.typeAddress, Profiler.this.counterArray), Profiler.this.lir.iconst(Profiler.this.typeAddress, Profiler.this.index * Profiler.this.counterSize))), Profiler.this.lir.iconst(Profiler.this.counterType, 1L)));
                            q.addAfter(s);
                            first = false;
                            ++Profiler.this.index;
                            Profiler.this.logPosition(0);
                        }
                        Profiler.this.logPosition(lineno);
                    }
                    q = q.next();
                }
                p = p.next();
            }
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "Profiler";
        }

        public String subject() {
            return "Profiler Code Insertion";
        }
    }

    public static class Trigger
    implements GlobalTransformer {
        int nCounters = 0;

        public boolean doIt(Module module, ImList args) {
            new Profiler(module);
            return true;
        }

        public String name() {
            return "Profiler";
        }

        public String subject() {
            return "Profiler Code Insertion";
        }
    }
}

