/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.opt;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.ana.DFST;
import coins.backend.ana.LoopAnalysis;
import coins.backend.cfg.BasicBlk;
import coins.backend.util.BiLink;
import coins.backend.util.ImList;

public class PreHeaders {
    public static final Trigger trig = new Trigger();

    public void doIt(Function f) {
        DFST dfst = (DFST)f.require(DFST.analyzer);
        LoopAnalysis loop = (LoopAnalysis)f.require(LoopAnalysis.analyzer);
        BiLink p = f.flowGraph().basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk entry = (BasicBlk)p.elem();
            if (loop.isLoop[entry.id] && !loop.multiEntry[entry.id]) {
                BasicBlk preHeader = f.flowGraph().insertNewBlkBefore(entry);
                BiLink q = entry.predList().first();
                while (!q.atEnd()) {
                    BasicBlk pred = (BasicBlk)q.elem();
                    if (pred != preHeader && !dfst.isAncestorOf(entry, pred)) {
                        pred.replaceSucc(entry, preHeader);
                    }
                    q = q.next();
                }
            }
            p = p.next();
        }
    }

    private static class Trigger
    implements LocalTransformer {
        private Trigger() {
        }

        public boolean doIt(Function func, ImList args) {
            new PreHeaders().doIt(func);
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "PreHeaders";
        }

        public String subject() {
            return "Pre-header Insertion";
        }
    }
}

