/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.opt;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.ana.DFST;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirNode;
import coins.backend.sym.Label;
import coins.backend.util.BiLink;
import coins.backend.util.ImList;

public class JumpOpt {
    public static final Trigger trig = new Trigger();

    public void doIt(Function f) {
        BasicBlk blk;
        FlowGraph g = f.flowGraph();
        DFST dfst = (DFST)f.require(DFST.analyzer);
        BasicBlk[] check = new BasicBlk[g.idBound()];
        BiLink p = g.basicBlkList.first();
        while (!p.atEnd()) {
            check[blk.id] = blk = (BasicBlk)p.elem();
            BiLink s = blk.succList().first();
            while (!s.atEnd()) {
                BasicBlk target = (BasicBlk)s.elem();
                BasicBlk destination = this.finalDestination(target, blk, check);
                if (destination != target) {
                    blk.replaceSucc(target, destination);
                }
                s = s.next();
            }
            p = p.next();
        }
        dfst = (DFST)f.require(DFST.analyzer);
        p = g.basicBlkList.first();
        while (!p.atEnd()) {
            blk = (BasicBlk)p.elem();
            BiLink next = p.next();
            if (dfst.dfn[blk.id] == 0 && blk != g.exitBlk()) {
                blk.clearEdges();
                p.unlink();
            }
            p = next;
        }
        p = g.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk nextBlk;
            blk = (BasicBlk)p.elem();
            while (!p.next().atEnd() && (nextBlk = (BasicBlk)p.next().elem()) != g.exitBlk() && blk.succList().length() == 1 && blk.succList().first().elem() == nextBlk && nextBlk.predList().length() == 1) {
                if (!blk.instrList().isEmpty()) {
                    BiLink lastp = blk.instrList().last();
                    switch (((LirNode)lastp.elem()).opCode) {
                        case 49: 
                        case 50: 
                        case 51: {
                            lastp.unlink();
                        }
                    }
                }
                blk.instrList().addAll(nextBlk.instrList());
                nextBlk.clearEdges();
                blk.maintEdges();
                p.next().unlink();
            }
            p = p.next();
        }
        g.touch();
    }

    private BasicBlk finalDestination(BasicBlk blk, BasicBlk mark, BasicBlk[] check) {
        if (check[blk.id] == mark) {
            return blk;
        }
        check[blk.id] = mark;
        if (blk.instrList().isEmpty()) {
            return blk;
        }
        LirNode ins = (LirNode)blk.instrList().first().elem();
        if (ins.opCode != 49) {
            return blk;
        }
        Label[] targets = ins.getTargets();
        return this.finalDestination(targets[0].basicBlk(), mark, check);
    }

    private static class Trigger
    implements LocalTransformer {
        private Trigger() {
        }

        public boolean doIt(Function func, ImList args) {
            new JumpOpt().doIt(func);
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "JumpOpt";
        }

        public String subject() {
            return "Jump Instruction Optimization";
        }
    }
}

