/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.opt;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.TargetMachine;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirNode;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;

public class If2Jumpc {
    public static final Trigger trig = new Trigger();
    private Function function;
    private TargetMachine tm;
    private LirFactory lir;

    public void doIt(Function f) {
        this.function = f;
        FlowGraph flowGraph = f.flowGraph();
        this.tm = f.module.targetMachine;
        this.lir = f.newLir;
        BiLink q = this.function.lirList().first();
        while (!q.atEnd()) {
            LirNode ins = (LirNode)q.elem();
            BiList pre = new BiList();
            this.replaceTree(ins, q);
            q = q.next();
        }
    }

    private LirNode replaceTree(LirNode node, BiLink here) {
        if (node.opCode == 60) {
            LirNode tmp = this.function.newTemp(node.type);
            LirNode thenl = this.lir.labelRef(this.function.newLabel());
            LirNode elsel = this.lir.labelRef(this.function.newLabel());
            LirNode merge = this.lir.labelRef(this.function.newLabel());
            LirNode cnode = this.replaceTree(node.kid(0), here);
            here.addBefore(this.lir.node(50, 0, cnode, thenl, elsel));
            here.addBefore(this.lir.node(52, 0, thenl));
            LirNode tnode = this.replaceTree(node.kid(1), here);
            here.addBefore(this.lir.node(48, node.type, tmp, tnode));
            here.addBefore(this.lir.node(49, 0, merge));
            here.addBefore(this.lir.node(52, 0, elsel));
            LirNode enode = this.replaceTree(node.kid(2), here);
            here.addBefore(this.lir.node(48, node.type, tmp, enode));
            here.addBefore(this.lir.node(52, 0, merge));
            return tmp;
        }
        int n = node.nKids();
        for (int i = 0; i < n; ++i) {
            node.setKid(i, this.replaceTree(node.kid(i), here));
        }
        return node;
    }

    private static class Trigger
    implements LocalTransformer {
        private Trigger() {
        }

        public boolean doIt(Function func, ImList args) {
            new If2Jumpc().doIt(func);
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "If2Jumpc";
        }

        public String subject() {
            return "Converting IFs to JUMPCs";
        }
    }
}

