/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.lir;

import coins.backend.CantHappenException;
import coins.backend.Op;
import coins.backend.Type;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNaryOp;
import coins.backend.lir.LirVisitor;
import coins.backend.lir.PickUpVariable;
import coins.backend.sym.Label;
import coins.backend.util.ImList;
import coins.backend.util.QuotedString;
import java.util.Iterator;

public abstract class LirNode {
    public final int id;
    public final int opCode;
    public final int type;
    public final ImList opt;

    LirNode(int id, int opCode, int type, ImList opt) {
        this.id = id;
        this.opCode = opCode;
        this.type = type;
        this.opt = opt == null ? ImList.Empty : opt;
    }

    public abstract LirNode makeCopy(LirFactory var1);

    public LirNode makeShallowCopy(LirFactory fac) {
        return this.makeCopy(fac);
    }

    public abstract LirNode replaceOptions(LirFactory var1, ImList var2);

    public int nSrcs() {
        return this.nKids();
    }

    public int nKids() {
        return 0;
    }

    public LirNode src(int n) {
        return this.kid(n);
    }

    public LirNode kid(int n) {
        throw new IllegalArgumentException();
    }

    public void setSrc(int n, LirNode src) {
        this.setKid(n, src);
    }

    public void setKid(int n, LirNode kid) {
        throw new IllegalArgumentException();
    }

    public Label[] getTargets() {
        switch (this.opCode) {
            case 49: {
                Label[] targets = new Label[]{((LirLabelRef)this.kid((int)0)).label};
                return targets;
            }
            case 50: {
                Label[] targets = new Label[]{((LirLabelRef)this.kid((int)1)).label, ((LirLabelRef)this.kid((int)2)).label};
                return targets;
            }
            case 51: {
                LirNaryOp cases = (LirNaryOp)this.kid(1);
                int n = cases.nKids();
                Label[] targets = new Label[n + 1];
                for (int i = 0; i < n; ++i) {
                    targets[i] = ((LirLabelRef)cases.kid((int)i).kid((int)1)).label;
                }
                targets[n] = ((LirLabelRef)this.kid((int)2)).label;
                return targets;
            }
            case 56: {
                return this.kid(0).getTargets();
            }
        }
        return null;
    }

    public void replaceLabel(Label x, Label y, LirFactory fac) {
        switch (this.opCode) {
            case 49: {
                if (((LirLabelRef)this.kid((int)0)).label != x) break;
                this.setKid(0, fac.labelRef(y));
                break;
            }
            case 50: {
                if (((LirLabelRef)this.kid((int)1)).label == x) {
                    this.setKid(1, fac.labelRef(y));
                }
                if (((LirLabelRef)this.kid((int)2)).label != x) break;
                this.setKid(2, fac.labelRef(y));
                break;
            }
            case 51: {
                LirNaryOp cases = (LirNaryOp)this.kid(1);
                int n = cases.kid.length;
                for (int i = 0; i < n; ++i) {
                    if (((LirLabelRef)cases.kid((int)i).kid((int)1)).label != x) continue;
                    cases.kid(i).setKid(1, fac.labelRef(y));
                }
                if (((LirLabelRef)this.kid((int)2)).label != x) break;
                this.setKid(2, fac.labelRef(y));
                break;
            }
            case 56: {
                this.kid(0).replaceLabel(x, y, fac);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public boolean isBranch() {
        switch (this.opCode) {
            case 49: 
            case 50: 
            case 51: {
                return true;
            }
            case 56: {
                int n = this.nKids();
                for (int i = 0; i < n; ++i) {
                    if (!this.kid(i).isBranch()) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public boolean isPhysicalRegister() {
        if (this.opCode == 7) {
            return this.kid(0).isPhysicalRegister();
        }
        return false;
    }

    public boolean isRegisterOperand() {
        return this.opCode == 6 || this.opCode == 7 && this.kid((int)0).opCode == 6;
    }

    public final void pickUpUses(PickUpVariable receiver) {
        switch (this.opCode) {
            case 56: {
                int n = this.nKids();
                for (int i = n - 1; i >= 0; --i) {
                    this.kid(i).pickUpUses(receiver);
                }
                break;
            }
            case 48: {
                if (!this.kid(0).isRegisterOperand()) {
                    this.kid(0).pickUpUses(receiver);
                }
                this.kid(1).pickUpUses(receiver);
                break;
            }
            case 54: 
            case 58: {
                break;
            }
            case 53: {
                this.kid(0).pickUpUses(receiver);
                this.kid(1).pickUpUses(receiver);
                int n = this.kid(2).nKids();
                for (int i = 0; i < n; ++i) {
                    if (this.kid((int)2).kid((int)i).opCode != 47) continue;
                    this.kid(2).kid(i).kid(0).pickUpUses(receiver);
                }
                break;
            }
            case 67: {
                int i;
                this.kid(1).pickUpUses(receiver);
                this.kid(3).pickUpUses(receiver);
                int n = this.kid(2).nKids();
                for (i = 0; i < n; ++i) {
                    if (this.kid((int)2).kid((int)i).opCode != 47) continue;
                    this.kid(2).kid(i).kid(0).pickUpUses(receiver);
                }
                n = this.kid(3).nKids();
                for (i = 0; i < n; ++i) {
                    if (this.kid((int)3).kid((int)i).opCode != 47) continue;
                    this.kid(3).kid(i).kid(0).pickUpUses(receiver);
                }
                break;
            }
            case 7: {
                if (this.kid((int)0).opCode != 6) {
                    this.kid(0).pickUpUses(receiver);
                    break;
                }
            }
            case 6: {
                receiver.meetVar(this);
                break;
            }
            default: {
                int n = this.nKids();
                for (int i = 0; i < n; ++i) {
                    this.kid(i).pickUpUses(receiver);
                }
            }
        }
    }

    public final void pickUpDefs(PickUpVariable receiver) {
        switch (this.opCode) {
            case 56: {
                int n = this.nKids();
                for (int i = n - 1; i >= 0; --i) {
                    this.kid(i).pickUpDefs(receiver);
                }
                break;
            }
            case 48: {
                this.kid(0).pickReg(receiver);
                break;
            }
            case 58: {
                int n = this.nKids();
                for (int i = 0; i < n; ++i) {
                    this.kid(i).pickReg(receiver);
                }
                break;
            }
            case 53: {
                int n = this.kid(2).nKids();
                for (int i = 0; i < n; ++i) {
                    this.kid(2).kid(i).pickReg(receiver);
                }
                break;
            }
            case 67: {
                int i;
                int n = this.kid(2).nKids();
                for (i = 0; i < n; ++i) {
                    this.kid(2).kid(i).pickReg(receiver);
                }
                n = this.kid(3).nKids();
                for (i = 0; i < n; ++i) {
                    this.kid(3).kid(i).pickReg(receiver);
                }
                break;
            }
            case 54: {
                int n = this.nKids();
                for (int i = 1; i < n; ++i) {
                    this.kid(i).pickReg(receiver);
                }
                break;
            }
        }
    }

    private final void pickReg(PickUpVariable receiver) {
        switch (this.opCode) {
            case 7: {
                if (this.kid((int)0).opCode != 6) break;
            }
            case 6: {
                receiver.meetVar(this);
            }
        }
    }

    public Object toSexp() {
        if (this.opCode == 52) {
            return ImList.list("DEFLABEL", new QuotedString(((LirLabelRef)this.kid((int)0)).label.toString()));
        }
        ImList list = ImList.Empty;
        if (this.opCode != 61) {
            list = new ImList(Op.toName(this.opCode), list);
        }
        if (this.type != 0) {
            list = new ImList(Type.toString(this.type), list);
        }
        int n = this.nKids();
        for (int i = 0; i < n; ++i) {
            list = new ImList(this.kid(i) == null ? "<null>" : this.kid(i).toSexp(), list);
        }
        ImList p = this.opt;
        while (!p.atEnd()) {
            list = new ImList(p.elem(), list);
            p = p.next();
        }
        return list.destructiveReverse();
    }

    public String toString() {
        if (this.opCode == 52) {
            return "(DEFLABEL \"" + ((LirLabelRef)this.kid((int)0)).label + "\")";
        }
        StringBuffer buf = new StringBuffer();
        buf.append("(");
        if (this.opCode == 61) {
            if (this.type != 0) {
                buf.append(Type.toString(this.type));
                buf.append(" ");
            }
        } else {
            buf.append(Op.toName(this.opCode));
            if (this.type != 0) {
                buf.append(" ");
                buf.append(Type.toString(this.type));
            }
            buf.append(" ");
        }
        int n = this.nKids();
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                buf.append(" ");
            }
            buf.append(this.kid(i) == null ? "<null>" : this.kid(i).toString());
        }
        if (!this.opt.atEnd()) {
            buf.append(" ");
            buf.append(this.opt.toStringWOParen());
        }
        buf.append(")");
        return buf.toString();
    }

    public int hashCode() {
        int n = this.nKids();
        int v = this.opCode + this.type;
        for (int i = 0; i < n; ++i) {
            v = v * 129 + this.kid(i).hashCode();
        }
        return v;
    }

    public boolean equals(Object x) {
        return x instanceof LirNode && ((LirNode)x).opCode == this.opCode && ((LirNode)x).type == this.type && this.opt.equals(((LirNode)x).opt);
    }

    public abstract void accept(LirVisitor var1);

    public String toStringExp() {
        switch (this.opCode) {
            case 10: {
                return this.kid(0).toStringExp() + "+" + this.kid(1).toStringExp();
            }
            case 11: {
                return this.kid(0).toStringExp() + "-" + this.kid(1).toStringExp();
            }
        }
        throw new CantHappenException("not an address expression: " + this);
    }

    public static class Scanner
    implements Iterator {
        private static final int DEFAULTSIZE = 16;
        LirNode scanned;
        LirNode[] useBuf;
        LirNode[] defBuf;
        LirNode[] clobberBuf;
        LirNode[] buf;
        int nUses;
        int nDefs;
        int nClobbers;
        int size;
        int ptr;

        public boolean hasNext() {
            return this.ptr < this.size;
        }

        public Object next() {
            if (this.ptr < this.size) {
                return this.buf[this.ptr++];
            }
            return null;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Iterator forUses(LirNode tree) {
            this.init(tree);
            this.buf = this.useBuf;
            this.size = this.nUses;
            this.ptr = 0;
            return this;
        }

        public Iterator forDefs(LirNode tree) {
            this.init(tree);
            this.buf = this.defBuf;
            this.size = this.nDefs;
            this.ptr = 0;
            return this;
        }

        public Iterator forClobbers(LirNode tree) {
            this.init(tree);
            this.buf = this.clobberBuf;
            this.size = this.nClobbers;
            this.ptr = 0;
            return this;
        }

        private void init(LirNode tree) {
            if (tree != this.scanned) {
                if (this.useBuf == null) {
                    this.useBuf = new LirNode[16];
                    this.defBuf = new LirNode[16];
                    this.clobberBuf = new LirNode[16];
                }
                this.nClobbers = 0;
                this.nDefs = 0;
                this.nUses = 0;
                this.scan(tree);
                this.scanned = tree;
            }
        }

        private void scan(LirNode tree) {
            switch (tree.opCode) {
                case 56: {
                    int n = tree.nKids();
                    for (int i = n - 1; i >= 0; --i) {
                        this.scan(tree.kid(i));
                    }
                    break;
                }
                case 48: {
                    this.scanLvalue(tree.kid(0));
                    this.scan(tree.kid(1));
                    break;
                }
                case 58: {
                    int n = tree.nKids();
                    for (int i = 0; i < n; ++i) {
                        if (this.nClobbers >= this.clobberBuf.length) {
                            this.clobberBuf = this.grow(this.clobberBuf);
                        }
                        this.clobberBuf[this.nClobbers++] = tree.kid(i);
                    }
                    break;
                }
                case 54: {
                    int n = tree.nKids();
                    for (int i = 1; i < n; ++i) {
                        this.scanLvalue(tree.kid(i));
                    }
                    break;
                }
                case 53: {
                    this.scan(tree.kid(0));
                    this.scan(tree.kid(1));
                    int n = tree.kid(2).nKids();
                    for (int i = 0; i < n; ++i) {
                        this.scanLvalue(tree.kid(2).kid(i));
                    }
                    break;
                }
                case 67: {
                    int i;
                    this.scan(tree.kid(1));
                    this.scan(tree.kid(3));
                    int n = tree.kid(2).nKids();
                    for (i = 0; i < n; ++i) {
                        this.scanLvalue(tree.kid(2).kid(i));
                    }
                    n = tree.kid(3).nKids();
                    for (i = 0; i < n; ++i) {
                        this.scanLvalue(tree.kid(3).kid(i));
                    }
                    break;
                }
                case 7: {
                    if (tree.kid((int)0).opCode != 6) {
                        this.scan(tree.kid(0));
                        break;
                    }
                }
                case 6: {
                    if (this.nUses >= this.useBuf.length) {
                        this.useBuf = this.grow(this.useBuf);
                    }
                    this.useBuf[this.nUses++] = tree;
                    break;
                }
                default: {
                    int n = tree.nKids();
                    for (int i = 0; i < n; ++i) {
                        this.scan(tree.kid(i));
                    }
                }
            }
        }

        private final void scanLvalue(LirNode tree) {
            switch (tree.opCode) {
                case 7: {
                    if (tree.kid((int)0).opCode != 6) {
                        this.scan(tree.kid(0));
                        break;
                    }
                }
                case 6: {
                    if (this.nDefs >= this.defBuf.length) {
                        this.defBuf = this.grow(this.defBuf);
                    }
                    this.defBuf[this.nDefs++] = tree;
                    break;
                }
                default: {
                    this.scan(tree);
                }
            }
        }

        private LirNode[] grow(LirNode[] buf) {
            LirNode[] newBuf = new LirNode[buf.length * 2];
            for (int i = 0; i < buf.length; ++i) {
                newBuf[i] = buf[i];
            }
            return newBuf;
        }
    }
}

