/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.lir;

import coins.backend.CantHappenException;
import coins.backend.Function;
import coins.backend.Module;
import coins.backend.Op;
import coins.backend.SyntaxError;
import coins.backend.Type;
import coins.backend.lir.LirBinOp;
import coins.backend.lir.LirFconst;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNaryOp;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirString;
import coins.backend.lir.LirSymRef;
import coins.backend.lir.LirUnaOp;
import coins.backend.sym.Label;
import coins.backend.sym.Symbol;
import coins.backend.util.ImList;
import coins.backend.util.Misc;
import coins.backend.util.QuotedString;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.Map;

public class LirFactory {
    private Module module;
    private int lirNodeIdCounter = 1;
    private Map constNodeHash = new HashMap();
    private Map refNodeHash = new HashMap();
    private static final boolean NewInfoFlag = false;
    private int labelVariantCounter = 1;
    public static final ImList optUntagged = new ImList("&untagged", ImList.Empty);

    public LirFactory(Module module) {
        this.module = module;
    }

    public int idBound() {
        return this.lirNodeIdCounter;
    }

    public int getLabelVariant() {
        return this.labelVariantCounter++;
    }

    private LirNode internNode(Map tbl, LirNode obj) {
        LirNode old = (LirNode)tbl.get(obj);
        if (old != null) {
            return old;
        }
        tbl.put(obj, obj);
        ++this.lirNodeIdCounter;
        return obj;
    }

    public LirNode stringconst(String string) {
        return this.internNode(this.constNodeHash, new LirString(this.lirNodeIdCounter, string));
    }

    public LirNode fconst(int type, double value, ImList opt) {
        return this.internNode(this.constNodeHash, new LirFconst(this.lirNodeIdCounter, type, value, opt));
    }

    public LirNode fconst(int type, double value) {
        return this.fconst(type, value, null);
    }

    public LirNode iconst(int type, long value, ImList opt) {
        return this.internNode(this.constNodeHash, new LirIconst(this.lirNodeIdCounter, type, value, opt));
    }

    public LirNode iconst(int type, long value) {
        return this.iconst(type, value, null);
    }

    public LirNode untaggedIconst(int type, long value) {
        return this.iconst(type, value, optUntagged);
    }

    public LirNode symRef(int opCode, int type, Symbol symbol, ImList opt) {
        if (opt == null) {
            opt = ImList.Empty;
        }
        return this.internNode(this.refNodeHash, new LirSymRef(this.lirNodeIdCounter, opCode, type, symbol, opt));
    }

    public LirNode symRef(Symbol symbol) {
        int op;
        int type = this.module.targetMachine.typeAddress;
        switch (symbol.storage) {
            case 2: {
                op = 6;
                type = symbol.type;
                break;
            }
            case 1: {
                op = 5;
                break;
            }
            case 0: {
                op = 4;
                break;
            }
            default: {
                throw new CantHappenException();
            }
        }
        return this.symRef(op, type, symbol, ImList.Empty);
    }

    public LirNode labelRef(int opCode, int type, Label label, ImList opt) {
        if (opt == null) {
            opt = ImList.Empty;
        }
        return this.internNode(this.refNodeHash, new LirLabelRef(this.lirNodeIdCounter, opCode, type, label, opt));
    }

    public LirNode labelRef(int opCode, int type, Label label, int variant, ImList opt) {
        if (opt == null) {
            opt = ImList.Empty;
        }
        return this.internNode(this.refNodeHash, new LirLabelRef(this.lirNodeIdCounter, opCode, type, label, variant, opt));
    }

    public LirNode labelRef(Label label) {
        return this.labelRef(8, this.module.targetMachine.typeAddress, label, ImList.Empty);
    }

    public LirNode labelRefVariant(Label label) {
        return this.labelRef(8, this.module.targetMachine.typeAddress, label, this.getLabelVariant(), ImList.Empty);
    }

    public LirNode operator(int opCode, int type, LirNode operand, ImList opt) {
        return new LirUnaOp(this.lirNodeIdCounter++, opCode, type, operand, opt);
    }

    public LirNode operator0(int opCode, int type, LirNode operand) {
        return this.operator(opCode, type, operand, null);
    }

    public LirNode operator(int opCode, int type, LirNode operand0, LirNode operand1, ImList opt) {
        return new LirBinOp(this.lirNodeIdCounter++, opCode, type, operand0, operand1, opt);
    }

    public LirNode operator0(int opCode, int type, LirNode operand0, LirNode operand1) {
        return this.operator(opCode, type, operand0, operand1, null);
    }

    public LirNode operator(int opCode, int type, LirNode operand0, LirNode operand1, LirNode operand2, ImList opt) {
        LirNode[] src = new LirNode[]{operand0, operand1, operand2};
        return new LirNaryOp(this.lirNodeIdCounter++, opCode, type, src, opt);
    }

    public LirNode operator0(int opCode, int type, LirNode operand0, LirNode operand1, LirNode operand2) {
        return this.operator(opCode, type, operand0, operand1, operand2, null);
    }

    public LirNode operator(int opCode, int type, LirNode[] operands, ImList opt) {
        return new LirNaryOp(this.lirNodeIdCounter++, opCode, type, operands, opt);
    }

    public LirNode operator0(int opCode, int type, LirNode[] operands) {
        return this.operator(opCode, type, operands, null);
    }

    public LirNode node(int opCode, int type, double value) {
        if (opCode != 3) {
            throw new CantHappenException();
        }
        return this.fconst(type, value);
    }

    public LirNode node(int opCode, int type, long value) {
        if (opCode != 2) {
            throw new CantHappenException();
        }
        return this.iconst(type, value);
    }

    public LirNode node(int opCode, int type, Symbol symbol) {
        return this.symRef(opCode, type, symbol, null);
    }

    public LirNode node(int opCode, int type, Label label) {
        return this.labelRef(opCode, type, label, null);
    }

    public LirNode node(int opCode, int type) {
        return this.operator(opCode, type, new LirNode[0], null);
    }

    public LirNode node(int opCode, int type, LirNode operand) {
        return this.operator(opCode, type, operand, null);
    }

    public LirNode node(int opCode, int type, LirNode operand0, LirNode operand1) {
        return this.operator(opCode, type, operand0, operand1, null);
    }

    public LirNode node(int opCode, int type, LirNode operand0, LirNode operand1, LirNode operand2) {
        return this.operator(opCode, type, operand0, operand1, operand2, null);
    }

    public LirNode node(int opCode, int type, LirNode[] operands) {
        return this.operator(opCode, type, operands, null);
    }

    public LirNode makeCopy(LirNode inst) {
        return inst.makeCopy(this);
    }

    public LirNode makeShallowCopy(LirNode inst) {
        return inst.makeShallowCopy(this);
    }

    public LirNode replaceOptions(LirNode inst, ImList newOpt) {
        return inst.replaceOptions(this, newOpt);
    }

    private String unquote(Object obj) {
        if (obj instanceof QuotedString) {
            return ((QuotedString)obj).body;
        }
        return (String)obj;
    }

    private long parseLong(String s) {
        int n;
        block3: for (n = s.length(); n > 0; --n) {
            switch (s.charAt(n - 1)) {
                case 'L': 
                case 'U': 
                case 'l': 
                case 'u': {
                    continue block3;
                }
            }
        }
        return Long.parseLong(s.substring(0, n));
    }

    public LirNode decodeLir(Object node, Function func, Module mod) throws SyntaxError {
        if (node instanceof QuotedString) {
            return this.stringconst(((QuotedString)node).body);
        }
        if (node instanceof String) {
            return this.stringconst((String)node);
        }
        if (!(node instanceof ImList)) {
            throw new SyntaxError("QuotedString or ImList expected");
        }
        ImList stmt = (ImList)node;
        int code = Op.toCode((String)stmt.elem());
        if (code < 0) {
            throw new SyntaxError("Unknown opcode: " + (String)stmt.elem());
        }
        ImList opt = stmt.scanOpt();
        switch (code) {
            case 2: {
                return this.iconst(Type.decode((String)stmt.elem2nd()), this.parseLong((String)stmt.elem3rd()), opt);
            }
            case 3: {
                return this.fconst(Type.decode((String)stmt.elem2nd()), Double.parseDouble((String)stmt.elem3rd()), opt);
            }
            case 4: 
            case 5: 
            case 6: {
                Symbol sym;
                int type = Type.decode((String)stmt.elem2nd());
                String name = this.unquote(stmt.elem3rd());
                if (func != null) {
                    sym = func.getSymbol(name);
                } else if (mod != null) {
                    sym = mod.getSymbol(name);
                } else {
                    throw new CantHappenException("Symbol reference outside function/module: " + name);
                }
                if (sym == null) {
                    throw new CantHappenException("Undefined symbol: " + name);
                }
                return this.symRef(code, type, sym, opt);
            }
            case 7: {
                int type = Type.decode((String)stmt.elem2nd());
                LirNode src = this.decodeLir((ImList)stmt.elem3rd(), func, mod);
                LirNode pos = this.decodeFixnum(stmt.elem4th());
                return this.operator(7, type, src, pos, opt);
            }
            case 8: {
                String v;
                String name = this.unquote(stmt.elem3rd());
                name = this.escapeLabel(name);
                if (func == null) {
                    throw new CantHappenException("LABEL reference outside function");
                }
                Label label = func.internLabel(name);
                if (!stmt.next().next().next().atEnd() && !(v = (String)stmt.elem4th()).startsWith("&")) {
                    int num = Integer.parseInt(v);
                    func.reserveLabelVariantNo(num);
                    return this.labelRef(8, this.module.targetMachine.typeAddress, label, num, opt);
                }
                return this.labelRef(8, this.module.targetMachine.typeAddress, label, opt);
            }
            case 52: {
                String name = this.unquote(stmt.elem2nd());
                name = this.escapeLabel(name);
                Label label = func.internLabel(name);
                return this.operator(code, 0, this.labelRef(label), opt);
            }
            case 22: {
                code = 24;
            }
            case 9: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 30: 
            case 47: {
                return this.operator(code, Type.decode((String)stmt.elem2nd()), this.decodeLir((ImList)stmt.elem3rd(), func, mod), opt);
            }
            case 49: {
                return this.operator(code, 0, this.decodeLir((ImList)stmt.elem2nd(), func, mod), opt);
            }
            case 32: {
                code = 31;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 27: 
            case 28: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 48: {
                return this.operator(code, Type.decode((String)stmt.elem2nd()), this.decodeLir((ImList)stmt.elem3rd(), func, mod), this.decodeLir((ImList)stmt.elem4th(), func, mod), opt);
            }
            case 50: {
                LirNode[] src = new LirNode[]{this.decodeLir((ImList)stmt.elem2nd(), func, mod), this.decodeLir((ImList)stmt.elem3rd(), func, mod), this.decodeLir((ImList)stmt.elem4th(), func, mod)};
                return this.operator(code, 0, src, opt);
            }
            case 53: {
                LirNode callee = this.decodeLir((ImList)stmt.elem2nd(), func, mod);
                int n = ((ImList)stmt.elem3rd()).length();
                LirNode[] inParam = new LirNode[n];
                int i = 0;
                ImList p = (ImList)stmt.elem3rd();
                while (!p.atEnd()) {
                    inParam[i++] = this.decodeLir((ImList)p.elem(), func, mod);
                    p = p.next();
                }
                n = ((ImList)stmt.elem4th()).length();
                LirNode[] outParam = new LirNode[n];
                i = 0;
                ImList p2 = (ImList)stmt.elem4th();
                while (!p2.atEnd()) {
                    outParam[i++] = this.decodeLir((ImList)p2.elem(), func, mod);
                    p2 = p2.next();
                }
                return this.operator(code, 0, callee, this.operator(61, 0, inParam, null), this.operator(61, 0, outParam, null), opt);
            }
            case 67: {
                LirNode body = this.decodeLir(stmt.elem2nd(), func, mod);
                int n = ((ImList)stmt.elem3rd()).length();
                LirNode[] inParam = new LirNode[n];
                int i = 0;
                ImList p = (ImList)stmt.elem3rd();
                while (!p.atEnd()) {
                    inParam[i++] = this.decodeLir((ImList)p.elem(), func, mod);
                    p = p.next();
                }
                n = ((ImList)stmt.elem4th()).length();
                LirNode[] outParam = new LirNode[n];
                i = 0;
                ImList p3 = (ImList)stmt.elem4th();
                while (!p3.atEnd()) {
                    outParam[i++] = this.decodeLir((ImList)p3.elem(), func, mod);
                    p3 = p3.next();
                }
                n = ((ImList)stmt.elem5th()).length();
                LirNode[] inoutParam = new LirNode[n];
                i = 0;
                ImList p4 = (ImList)stmt.elem5th();
                while (!p4.atEnd()) {
                    inoutParam[i++] = this.decodeLir((ImList)p4.elem(), func, mod);
                    p4 = p4.next();
                }
                return this.operator(code, 0, new LirNode[]{body, this.operator(61, 0, inParam, null), this.operator(61, 0, outParam, null), this.operator(61, 0, inoutParam, null)}, opt);
            }
            case 51: {
                LirNode value = this.decodeLir((ImList)stmt.elem2nd(), func, mod);
                ImList cases = (ImList)stmt.elem3rd();
                int n = cases.length();
                LirNode[] labels = new LirNode[n];
                int i = 0;
                ImList p = cases;
                while (!p.atEnd()) {
                    ImList c = (ImList)p.elem();
                    labels[i++] = this.operator(61, 0, this.decodeLir((ImList)c.elem(), func, mod), this.decodeLir((ImList)c.elem2nd(), func, mod), null);
                    p = p.next();
                }
                return this.operator(code, 0, value, this.operator(61, 0, labels, null), this.decodeLir((ImList)stmt.elem4th(), func, mod), opt);
            }
            case 54: 
            case 55: {
                int n = 1;
                for (ImList p = stmt.next().next(); p != opt; p = p.next()) {
                    ++n;
                }
                LirNode[] opr = new LirNode[n];
                ImList frame = (ImList)stmt.elem2nd();
                opr[0] = this.operator(61, 0, this.decodeFixnum(frame.elem()), this.decodeFixnum(frame.elem2nd()), null);
                int i = 1;
                for (ImList p = stmt.next().next(); p != opt; p = p.next()) {
                    opr[i++] = this.decodeLir((ImList)p.elem(), func, mod);
                }
                return this.operator(code, 0, opr, opt);
            }
            case 56: 
            case 57: 
            case 58: {
                int n = 0;
                for (ImList p = stmt.next(); p != opt; p = p.next()) {
                    ++n;
                }
                LirNode[] src = new LirNode[n];
                n = 0;
                for (ImList p = stmt.next(); p != opt; p = p.next()) {
                    src[n++] = this.decodeLir((ImList)p.elem(), func, mod);
                }
                return this.operator(code, 0, src, opt);
            }
            case 60: {
                return this.operator(60, Type.decode((String)stmt.elem2nd()), this.decodeLir((ImList)stmt.elem3rd(), func, mod), this.decodeLir((ImList)stmt.elem4th(), func, mod), this.decodeLir((ImList)stmt.elem5th(), func, mod), opt);
            }
            case 65: {
                int lineno = Integer.parseInt((String)stmt.elem2nd());
                return this.operator(code, 0, this.iconst(Type.type(2, 32L), lineno, optUntagged), opt);
            }
            case 66: {
                if (stmt.elem2nd() == "LINE") {
                    int lineno = Integer.parseInt((String)stmt.elem3rd());
                    return this.operator(65, 0, this.iconst(Type.type(2, 32L), lineno, optUntagged), opt);
                }
                return this.operator(66, 0, new LirNode[0], stmt.next());
            }
        }
        throw new SyntaxError("Unknown opCode");
    }

    private String escapeLabel(String n) {
        if (n.charAt(0) == '.') {
            return "_" + n.substring(1);
        }
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public LirNode decodeDataCompo(ImList node, Module module) throws SyntaxError {
        ImList opt = node.scanOpt();
        if (node.elem() == "SPACE") {
            return this.operator(63, 0, this.decodeFixnum(node.elem2nd()), opt);
        }
        if (node.elem() == "ZEROS") {
            return this.operator(64, 0, this.decodeFixnum(node.elem2nd()), opt);
        }
        int type = Type.decode((String)node.elem());
        node = node.next();
        int nelem = node.length();
        LirNode[] vec = new LirNode[nelem];
        for (int i = 0; i < nelem; ++i) {
            if (node.atEnd()) {
                throw new CantHappenException();
            }
            Object obj = node.elem();
            if (obj instanceof String) {
                if (Type.tag(type) == 2) {
                    vec[i] = this.iconst(type, Long.parseLong((String)obj));
                } else {
                    if (Type.tag(type) != 4) throw new CantHappenException();
                    vec[i] = this.fconst(type, Double.parseDouble((String)obj));
                }
            } else {
                vec[i] = this.decodeLir((ImList)obj, null, module);
            }
            node = node.next();
        }
        return this.operator(61, type, vec, opt);
    }

    private LirNode decodeFixnum(Object node) throws SyntaxError {
        if (node instanceof String) {
            return this.iconst(this.module.targetMachine.typeAddress, Long.parseLong((String)node), optUntagged);
        }
        if (node instanceof ImList && (String)((ImList)node).elem() == "INTCONST") {
            return this.iconst(Type.decode((String)((ImList)node).elem2nd()), Long.parseLong((String)((ImList)node).elem3rd()), optUntagged);
        }
        throw new SyntaxError("fixnum expected");
    }

    public LirNode evalTree(LirNode tree) {
        int n = tree.nKids();
        for (int i = 0; i < n; ++i) {
            LirNode node = this.evalTree(tree.kid(i));
            if (node == tree.kid(i)) continue;
            tree.setKid(i, node);
        }
        return this.foldConstant(tree);
    }

    public LirNode foldConstant(LirNode node) {
        long svalue0 = 0L;
        long svalue1 = 0L;
        long uvalue0 = 0L;
        long uvalue1 = 0L;
        double dvalue0 = 0.0;
        double dvalue1 = 0.0;
        boolean iconst0 = true;
        boolean iconst1 = true;
        boolean fconst0 = true;
        boolean fconst1 = true;
        int n = node.nKids();
        if (n >= 1) {
            switch (node.kid((int)0).opCode) {
                case 2: {
                    svalue0 = ((LirIconst)node.kid(0)).signedValue();
                    uvalue0 = ((LirIconst)node.kid(0)).unsignedValue();
                    fconst0 = false;
                    break;
                }
                case 3: {
                    dvalue0 = ((LirFconst)node.kid((int)0)).value;
                    iconst0 = false;
                    break;
                }
                default: {
                    fconst0 = false;
                    iconst0 = false;
                }
            }
        }
        if (n >= 2) {
            switch (node.kid((int)1).opCode) {
                case 2: {
                    svalue1 = ((LirIconst)node.kid(1)).signedValue();
                    uvalue1 = ((LirIconst)node.kid(1)).unsignedValue();
                    fconst1 = false;
                    break;
                }
                case 3: {
                    dvalue1 = ((LirFconst)node.kid((int)1)).value;
                    iconst1 = false;
                    break;
                }
                default: {
                    fconst1 = false;
                    iconst1 = false;
                }
            }
        }
        if (iconst0 && node.opCode == 60) {
            if (svalue0 != 0L) {
                return node.kid(1);
            }
            return node.kid(2);
        }
        if (iconst0 && iconst1) {
            long ivalue = 0L;
            int bits = Type.bits(node.type);
            long mask = (1L << bits) - 1L;
            switch (node.opCode) {
                case 9: {
                    ivalue = -svalue0;
                    break;
                }
                case 30: {
                    ivalue = svalue0 ^ 0xFFFFFFFFFFFFFFFFL;
                    break;
                }
                case 17: {
                    ivalue = svalue0;
                    break;
                }
                case 18: {
                    ivalue = uvalue0;
                    break;
                }
                case 19: {
                    ivalue = svalue0 & mask;
                    break;
                }
                case 25: {
                    if (Type.tag(node.type) != 4) break;
                    double fvalue = svalue0;
                    return this.fconst(node.type, fvalue);
                }
                case 26: {
                    if (Type.tag(node.type) != 4) break;
                    double fvalue = new BigInteger(Long.toHexString(uvalue0), 16).doubleValue();
                    return this.fconst(node.type, fvalue);
                }
                case 10: {
                    ivalue = svalue0 + svalue1;
                    break;
                }
                case 11: {
                    ivalue = svalue0 - svalue1;
                    break;
                }
                case 12: {
                    ivalue = svalue0 * svalue1;
                    break;
                }
                case 13: {
                    if (svalue1 == 0L) {
                        return node;
                    }
                    ivalue = svalue0 / svalue1;
                    break;
                }
                case 14: {
                    if (bits >= 64) {
                        return node;
                    }
                    if (uvalue1 == 0L) {
                        return node;
                    }
                    ivalue = uvalue0 / uvalue1;
                    break;
                }
                case 15: {
                    if (svalue1 == 0L) {
                        return node;
                    }
                    ivalue = svalue0 % svalue1;
                    break;
                }
                case 16: {
                    if (bits >= 64) {
                        return node;
                    }
                    if (uvalue1 == 0L) {
                        return node;
                    }
                    ivalue = uvalue0 % uvalue1;
                    break;
                }
                case 27: {
                    ivalue = svalue0 & svalue1;
                    break;
                }
                case 28: {
                    ivalue = svalue0 | svalue1;
                    break;
                }
                case 29: {
                    ivalue = svalue0 ^ svalue1;
                    break;
                }
                case 31: {
                    ivalue = svalue0 << (int)svalue1;
                    break;
                }
                case 32: {
                    ivalue = uvalue0 << (int)svalue1;
                    break;
                }
                case 33: {
                    ivalue = svalue0 >> (int)svalue1;
                    break;
                }
                case 34: {
                    ivalue = uvalue0 >>> (int)svalue1;
                    break;
                }
                case 35: {
                    ivalue = svalue0 == svalue1 ? 1L : 0L;
                    break;
                }
                case 36: {
                    ivalue = svalue0 != svalue1 ? 1L : 0L;
                    break;
                }
                case 37: {
                    ivalue = svalue0 < svalue1 ? 1L : 0L;
                    break;
                }
                case 38: {
                    ivalue = svalue0 <= svalue1 ? 1L : 0L;
                    break;
                }
                case 39: {
                    ivalue = svalue0 > svalue1 ? 1L : 0L;
                    break;
                }
                case 40: {
                    ivalue = svalue0 >= svalue1 ? 1L : 0L;
                    break;
                }
                case 41: {
                    if ((uvalue0 ^ uvalue1) < 0L) {
                        ivalue = uvalue0 < 0L ? 1L : 0L;
                        break;
                    }
                    ivalue = uvalue0 < uvalue1 ? 1L : 0L;
                    break;
                }
                case 42: {
                    if ((uvalue0 ^ uvalue1) < 0L) {
                        ivalue = uvalue0 < 0L ? 1L : 0L;
                        break;
                    }
                    ivalue = uvalue0 <= uvalue1 ? 1L : 0L;
                    break;
                }
                case 43: {
                    if ((uvalue0 ^ uvalue1) < 0L) {
                        ivalue = uvalue0 >= 0L ? 1L : 0L;
                        break;
                    }
                    ivalue = uvalue0 > uvalue1 ? 1L : 0L;
                    break;
                }
                case 44: {
                    if ((uvalue0 ^ uvalue1) < 0L) {
                        ivalue = uvalue0 >= 0L ? 1L : 0L;
                        break;
                    }
                    ivalue = uvalue0 >= uvalue1 ? 1L : 0L;
                    break;
                }
                default: {
                    return node;
                }
            }
            return this.iconst(node.type, ivalue);
        }
        if (fconst0 && fconst1) {
            double fvalue = 0.0;
            int ivalue = 0;
            switch (node.opCode) {
                case 35: {
                    ivalue = dvalue0 == dvalue1 ? 1 : 0;
                    break;
                }
                case 36: {
                    ivalue = dvalue0 != dvalue1 ? 1 : 0;
                    break;
                }
                case 37: {
                    ivalue = dvalue0 < dvalue1 ? 1 : 0;
                    break;
                }
                case 38: {
                    ivalue = dvalue0 <= dvalue1 ? 1 : 0;
                    break;
                }
                case 39: {
                    ivalue = dvalue0 > dvalue1 ? 1 : 0;
                    break;
                }
                case 40: {
                    ivalue = dvalue0 >= dvalue1 ? 1 : 0;
                    break;
                }
                default: {
                    switch (node.opCode) {
                        case 23: 
                        case 24: {
                            if (Type.tag(node.type) != 2) break;
                            return this.iconst(node.type, (long)dvalue0);
                        }
                        case 21: {
                            if (Type.bits(node.type) <= 32) {
                                fvalue = (float)dvalue0;
                                break;
                            }
                            fvalue = dvalue0;
                            break;
                        }
                        case 20: {
                            fvalue = dvalue0;
                            break;
                        }
                        case 10: {
                            fvalue = dvalue0 + dvalue1;
                            break;
                        }
                        case 11: {
                            fvalue = dvalue0 - dvalue1;
                            break;
                        }
                        case 12: {
                            fvalue = dvalue0 * dvalue1;
                            break;
                        }
                        case 13: {
                            fvalue = dvalue0 / dvalue1;
                            break;
                        }
                        default: {
                            return node;
                        }
                    }
                    return this.fconst(node.type, fvalue);
                }
            }
            return this.iconst(node.type, ivalue);
        }
        switch (node.opCode) {
            case 10: {
                if (iconst1 && node.kid((int)0).opCode == 10) {
                    if (node.kid((int)0).kid((int)1).opCode == 2) {
                        return this.node(10, node.type, node.kid(0).kid(0), this.iconst(node.type, ((LirIconst)node.kid(0).kid(1)).signedValue() + svalue1));
                    }
                    if (node.kid((int)0).kid((int)0).opCode == 2) {
                        return this.node(10, node.type, node.kid(0).kid(1), this.iconst(node.type, ((LirIconst)node.kid(0).kid(0)).signedValue() + svalue1));
                    }
                }
                if (iconst0 && node.kid((int)1).opCode == 10) {
                    if (node.kid((int)1).kid((int)1).opCode == 2) {
                        return this.node(10, node.type, node.kid(1).kid(0), this.iconst(node.type, ((LirIconst)node.kid(1).kid(1)).signedValue() + svalue0));
                    }
                    if (node.kid((int)1).kid((int)0).opCode == 2) {
                        return this.node(10, node.type, node.kid(1).kid(1), this.iconst(node.type, ((LirIconst)node.kid(1).kid(0)).signedValue() + svalue0));
                    }
                }
                if (iconst0 && svalue0 == 0L) {
                    return node.kid(1);
                }
                if (fconst0 && dvalue0 == 0.0) {
                    return node.kid(1);
                }
            }
            case 11: {
                if (iconst1 && svalue1 == 0L) {
                    return node.kid(0);
                }
                if (!fconst1 || dvalue1 != 0.0) break;
                return node.kid(0);
            }
            case 12: {
                if (iconst0 && svalue0 == 0L) {
                    return node.kid(0);
                }
                if (iconst0 && Misc.powersOf2(svalue0)) {
                    return this.foldConstant(this.makeMulShift(node.type, node.kid(1), svalue0));
                }
                if (iconst1 && svalue1 == 0L) {
                    return node.kid(1);
                }
                if (iconst1 && Misc.powersOf2(svalue1)) {
                    return this.foldConstant(this.makeMulShift(node.type, node.kid(0), svalue1));
                }
                if (fconst0 && dvalue0 == 0.0) {
                    return node.kid(0);
                }
                if (fconst0 && dvalue0 == 1.0) {
                    return node.kid(1);
                }
                if (fconst1 && dvalue1 == 0.0) {
                    return node.kid(1);
                }
                if (!fconst1 || dvalue1 != 1.0) break;
                return node.kid(0);
            }
            case 14: {
                if (!iconst1 || !Misc.powersOf2(svalue1)) break;
                return this.foldConstant(this.makeDivuShift(node.type, node.kid(0), svalue1));
            }
            case 13: {
                if (!iconst1 || svalue1 != 1L) break;
                return node.kid(0);
            }
            case 16: {
                if (!iconst1 || !Misc.powersOf2(svalue1)) break;
                return this.node(27, node.type, node.kid(0), this.iconst(node.type, svalue1 - 1L));
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                if (!iconst1 || svalue1 != 0L) break;
                return node.kid(0);
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                if (node.type != node.kid((int)0).type) break;
                return node.kid(0);
            }
        }
        return node;
    }

    private LirNode makeMulShift(int type, LirNode x, long val) {
        int n = Misc.binlog(val);
        if (n == 0) {
            return x;
        }
        return this.node(31, type, x, this.iconst(type, n));
    }

    private LirNode makeDivuShift(int type, LirNode x, long val) {
        int n = Misc.binlog(val);
        if (n == 0) {
            return x;
        }
        return this.node(34, type, x, this.iconst(type, n));
    }
}

