/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.gen;

import coins.backend.CantHappenException;
import coins.backend.Function;
import coins.backend.SyntaxError;
import coins.backend.Transformer;
import coins.backend.Type;
import coins.backend.ana.SaveRegisters;
import coins.backend.gen.AggregatePropagation;
import coins.backend.gen.CodeGenerator;
import coins.backend.gen.Rule;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirFconst;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirNode;
import coins.backend.lir.LirSymRef;
import coins.backend.sym.SymAuto;
import coins.backend.sym.SymStatic;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.backend.util.Misc;
import coins.backend.util.NumberSet;
import java.io.PrintWriter;

public class CodeGenerator_x86simd
extends CodeGenerator {
    State[] stateVec;
    private RewrState[] rewrStates;
    private static final Rule[] rulev = new Rule[4312];
    ImList regCallClobbers = ImList.list(ImList.list("REG", "I32", "%eax"), ImList.list("REG", "I32", "%ecx"), ImList.list("REG", "I32", "%edx"));
    static final int MAXREGPARAM = 6;

    void initRewriteLabeling() {
        this.rewrStates = new RewrState[0];
    }

    private void setRewrStates(int index, RewrState v) {
        if (index >= this.rewrStates.length) {
            RewrState[] w = new RewrState[Misc.clp2(index + 1)];
            for (int i = 0; i < this.rewrStates.length; ++i) {
                w[i] = this.rewrStates[i];
            }
            this.rewrStates = w;
        }
        this.rewrStates[index] = v;
    }

    private RewrState getRewrStates(int index) {
        if (index < this.rewrStates.length) {
            return this.rewrStates[index];
        }
        return null;
    }

    LirNode rewriteTree(LirNode tree, String phase, BiList pre, BiList post) {
        RewrState s = this.getRewrStates(tree.id);
        if (s != null && !s.rewritten) {
            return tree;
        }
        while (true) {
            int n = this.nActualOperands(tree);
            RewrState[] kidst = new RewrState[n];
            for (int i = 0; i < n; ++i) {
                LirNode r = this.rewriteTree(tree.kid(i), phase, pre, post);
                if (r != tree.kid(i)) {
                    tree.setKid(i, r);
                }
                kidst[i] = this.getRewrStates(tree.kid((int)i).id);
            }
            s = new RewrState();
            this.setRewrStates(tree.id, s);
            if (this.disableRewrite.contains(tree.id)) {
                return tree;
            }
            LirNode newTree = s.labelAndRewrite(tree, kidst, phase, pre, post);
            if (newTree == null) {
                return tree;
            }
            tree = newTree;
        }
    }

    private static void rrinit0() {
        CodeGenerator_x86simd.rulev[83] = new Rule(83, true, false, 46, "83: mregq -> regq", null, null, null, 0L, false, false, new int[]{3}, new String[]{null, "*reg-I64*"});
        CodeGenerator_x86simd.rulev[3994] = new Rule(3994, true, false, 3644, "3994: shfct -> regq", null, null, null, 0L, false, false, new int[]{3}, new String[]{null, "*reg-ebxecx-I64*"});
        CodeGenerator_x86simd.rulev[38] = new Rule(38, true, false, 23, "38: base -> regl", null, ImList.list(ImList.list("base", ImList.list(), "$1")), null, 0L, false, false, new int[]{4}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[42] = new Rule(42, true, false, 24, "42: index -> regl", null, ImList.list(ImList.list("index", "$1", "1")), null, 0L, false, false, new int[]{4}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[64] = new Rule(64, true, false, 37, "64: rcl -> regl", null, null, null, 0L, false, false, new int[]{4}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[73] = new Rule(73, true, false, 41, "73: mregl -> regl", null, null, null, 0L, false, false, new int[]{4}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[87] = new Rule(87, true, false, 48, "87: callarg -> regl", null, ImList.list(ImList.list("ind", "$1")), null, 0L, false, false, new int[]{4}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[3995] = new Rule(3995, true, false, 3644, "3995: shfct -> regl", null, null, null, 0L, false, false, new int[]{4}, new String[]{null, "*reg-ecx-I32*"});
        CodeGenerator_x86simd.rulev[4104] = new Rule(4104, true, false, 5, "4104: reglb -> regl", null, null, null, 0L, false, false, new int[]{4}, new String[]{"*reg-I32*", "*reg-I32*"});
        CodeGenerator_x86simd.rulev[66] = new Rule(66, true, false, 38, "66: rcw -> regw", null, null, null, 0L, false, false, new int[]{6}, new String[]{null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[77] = new Rule(77, true, false, 43, "77: mregw -> regw", null, null, null, 0L, false, false, new int[]{6}, new String[]{null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[3996] = new Rule(3996, true, false, 3644, "3996: shfct -> regw", null, null, null, 0L, false, false, new int[]{6}, new String[]{null, "*reg-cx-I16*"});
        CodeGenerator_x86simd.rulev[68] = new Rule(68, true, false, 39, "68: rcb -> regb", null, null, null, 0L, false, false, new int[]{7}, new String[]{null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[81] = new Rule(81, true, false, 45, "81: mregb -> regb", null, null, null, 0L, false, false, new int[]{7}, new String[]{null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[3997] = new Rule(3997, true, false, 3644, "3997: shfct -> regb", null, null, null, 0L, false, false, new int[]{7}, new String[]{null, "*reg-cl-I8*"});
        CodeGenerator_x86simd.rulev[4092] = new Rule(4092, true, false, 3646, "4092: regmemf -> regf", null, null, null, 0L, false, false, new int[]{8}, new String[]{null, "*reg-tmp-F32*"});
        CodeGenerator_x86simd.rulev[4090] = new Rule(4090, true, false, 3645, "4090: regmemd -> regd", null, null, null, 0L, false, false, new int[]{9}, new String[]{null, "*reg-tmp-F64*"});
        CodeGenerator_x86simd.rulev[16] = new Rule(16, true, false, 7, "16: regb -> xregb", null, null, null, 0L, false, false, new int[]{11}, new String[]{"*reg-I8*", null});
        CodeGenerator_x86simd.rulev[18] = new Rule(18, true, false, 4, "18: regl -> xregl", null, null, null, 0L, false, false, new int[]{12}, new String[]{"*reg-I32*", null});
        CodeGenerator_x86simd.rulev[17] = new Rule(17, true, false, 6, "17: regw -> xregw", null, null, null, 0L, false, false, new int[]{13}, new String[]{"*reg-I16*", null});
        CodeGenerator_x86simd.rulev[19] = new Rule(19, true, false, 3, "19: regq -> xregq", null, null, null, 0L, false, false, new int[]{14}, new String[]{"*reg-I64*", null});
        CodeGenerator_x86simd.rulev[20] = new Rule(20, true, false, 8, "20: regf -> xregf", null, null, null, 0L, false, false, new int[]{15}, new String[]{"*reg-tmp-F32*", null});
        CodeGenerator_x86simd.rulev[21] = new Rule(21, true, false, 9, "21: regd -> xregd", null, null, null, 0L, false, false, new int[]{16}, new String[]{"*reg-tmp-F64*", null});
        CodeGenerator_x86simd.rulev[24] = new Rule(24, true, false, 1, "24: regx -> xregx", null, null, null, 0L, false, false, new int[]{17}, new String[]{"*reg-simd-I128*", null});
        CodeGenerator_x86simd.rulev[25] = new Rule(25, true, false, 2, "25: regm -> xregm", null, null, null, 0L, false, false, new int[]{18}, new String[]{"*reg-simd-I64*", null});
        CodeGenerator_x86simd.rulev[32] = new Rule(32, true, false, 21, "32: asmcon -> con", null, null, null, 0L, false, false, new int[]{19}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[67] = new Rule(67, true, false, 38, "67: rcw -> con", null, ImList.list(ImList.list("imm", "$1")), null, 0L, false, false, new int[]{19}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[69] = new Rule(69, true, false, 39, "69: rcb -> con", null, ImList.list(ImList.list("imm", "$1")), null, 0L, false, false, new int[]{19}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[85] = new Rule(85, true, false, 47, "85: mrcq -> con", null, ImList.list(ImList.list("imm", "$1")), null, 0L, false, false, new int[]{19}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[33] = new Rule(33, true, false, 21, "33: asmcon -> sta", null, null, null, 0L, false, false, new int[]{20}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[86] = new Rule(86, true, false, 48, "86: callarg -> sta", null, null, null, 0L, false, false, new int[]{20}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[37] = new Rule(37, true, false, 23, "37: base -> asmcon", null, ImList.list(ImList.list("base", "$1", ImList.list())), null, 0L, false, false, new int[]{21}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[65] = new Rule(65, true, false, 37, "65: rcl -> asmcon", null, ImList.list(ImList.list("imm", "$1")), null, 0L, false, false, new int[]{21}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[54] = new Rule(54, true, false, 30, "54: addr -> base", null, ImList.list(ImList.list("addr", "$1", ImList.list())), null, 0L, false, false, new int[]{23}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[55] = new Rule(55, true, false, 30, "55: addr -> index", null, ImList.list(ImList.list("addr", ImList.list(), "$1")), null, 0L, false, false, new int[]{24}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[3932] = new Rule(3932, true, false, 4, "3932: regl -> addr", ImList.list(ImList.list("leal", "$1", "$0")), null, null, 0L, false, false, new int[]{30}, new String[]{"*reg-I32*", null});
        CodeGenerator_x86simd.rulev[82] = new Rule(82, true, false, 46, "82: mregq -> memq", null, null, null, 0L, false, false, new int[]{31}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[3993] = new Rule(3993, true, false, 3644, "3993: shfct -> memq", ImList.list(ImList.list("movb", "$1", "$0")), null, null, 0L, false, false, new int[]{31}, new String[]{"*reg-cl-I8*", null});
        CodeGenerator_x86simd.rulev[70] = new Rule(70, true, false, 40, "70: mrcl -> meml", null, null, null, 0L, false, false, new int[]{32}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[72] = new Rule(72, true, false, 41, "72: mregl -> meml", null, null, null, 0L, false, false, new int[]{32}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[74] = new Rule(74, true, false, 42, "74: mrcw -> memw", null, null, null, 0L, false, false, new int[]{33}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[76] = new Rule(76, true, false, 43, "76: mregw -> memw", null, null, null, 0L, false, false, new int[]{33}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[78] = new Rule(78, true, false, 44, "78: mrcb -> memb", null, null, null, 0L, false, false, new int[]{34}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[80] = new Rule(80, true, false, 45, "80: mregb -> memb", null, null, null, 0L, false, false, new int[]{34}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[3938] = new Rule(3938, true, false, 8, "3938: regf -> memf", ImList.list(ImList.list("movss", "$1", "$0")), null, null, 0L, false, false, new int[]{35}, new String[]{"*reg-tmp-F32*", null});
        CodeGenerator_x86simd.rulev[4093] = new Rule(4093, true, false, 3646, "4093: regmemf -> memf", null, null, null, 0L, false, false, new int[]{35}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[3937] = new Rule(3937, true, false, 9, "3937: regd -> memd", ImList.list(ImList.list("movsd", "$1", "$0")), null, null, 0L, false, false, new int[]{36}, new String[]{"*reg-tmp-F64*", null});
        CodeGenerator_x86simd.rulev[4091] = new Rule(4091, true, false, 3645, "4091: regmemd -> memd", null, null, null, 0L, false, false, new int[]{36}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[71] = new Rule(71, true, false, 40, "71: mrcl -> rcl", null, null, null, 0L, false, false, new int[]{37}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[75] = new Rule(75, true, false, 42, "75: mrcw -> rcw", null, null, null, 0L, false, false, new int[]{38}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[79] = new Rule(79, true, false, 44, "79: mrcb -> rcb", null, null, null, 0L, false, false, new int[]{39}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[3934] = new Rule(3934, true, false, 4, "3934: regl -> mrcl", ImList.list(ImList.list("movl", "$1", "$0")), null, null, 0L, false, false, new int[]{40}, new String[]{"*reg-I32*", null});
        CodeGenerator_x86simd.rulev[3935] = new Rule(3935, true, false, 6, "3935: regw -> mrcw", ImList.list(ImList.list("movw", "$1", "$0")), null, null, 0L, false, false, new int[]{42}, new String[]{"*reg-I16*", null});
        CodeGenerator_x86simd.rulev[3936] = new Rule(3936, true, false, 7, "3936: regb -> mrcb", ImList.list(ImList.list("movb", "$1", "$0")), null, null, 0L, false, false, new int[]{44}, new String[]{"*reg-I8*", null});
        CodeGenerator_x86simd.rulev[84] = new Rule(84, true, false, 47, "84: mrcq -> mregq", null, null, null, 0L, false, false, new int[]{46}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[3933] = new Rule(3933, true, false, 3, "3933: regq -> mrcq", ImList.list(ImList.list("movl", ImList.list("qlow", "$1"), ImList.list("qlow", "$0")), ImList.list("movl", ImList.list("qhigh", "$1"), ImList.list("qhigh", "$0"))), null, null, 0L, true, false, new int[]{47}, new String[]{"*reg-I64*", null});
        CodeGenerator_x86simd.rulev[26] = new Rule(26, false, false, 19, "26: con -> (INTCONST _)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86simd.rulev[629] = new Rule(629, false, true, 480, "629: _437 -> (INTCONST I8 1)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86simd.rulev[874] = new Rule(874, false, true, 721, "874: _678 -> (INTCONST I16 1)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86simd.rulev[43] = new Rule(43, false, true, 25, "43: _1 -> (INTCONST I32 2)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86simd.rulev[45] = new Rule(45, false, true, 26, "45: _2 -> (INTCONST I32 4)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86simd.rulev[47] = new Rule(47, false, true, 27, "47: _3 -> (INTCONST I32 8)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86simd.rulev[49] = new Rule(49, false, true, 28, "49: _4 -> (INTCONST I32 1)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86simd.rulev[52] = new Rule(52, false, true, 29, "52: _5 -> (INTCONST I32 3)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86simd.rulev[88] = new Rule(88, false, true, 49, "88: _6 -> (INTCONST I32 0)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86simd.rulev[99] = new Rule(99, false, true, 60, "99: _17 -> (INTCONST I32 5)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86simd.rulev[102] = new Rule(102, false, true, 63, "102: _20 -> (INTCONST I32 6)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86simd.rulev[105] = new Rule(105, false, true, 66, "105: _23 -> (INTCONST I32 7)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86simd.rulev[110] = new Rule(110, false, true, 71, "110: _28 -> (INTCONST I32 9)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86simd.rulev[113] = new Rule(113, false, true, 74, "113: _31 -> (INTCONST I32 10)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86simd.rulev[116] = new Rule(116, false, true, 77, "116: _34 -> (INTCONST I32 11)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86simd.rulev[119] = new Rule(119, false, true, 80, "119: _37 -> (INTCONST I32 12)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86simd.rulev[122] = new Rule(122, false, true, 83, "122: _40 -> (INTCONST I32 13)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86simd.rulev[125] = new Rule(125, false, true, 86, "125: _43 -> (INTCONST I32 14)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86simd.rulev[128] = new Rule(128, false, true, 89, "128: _46 -> (INTCONST I32 15)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86simd.rulev[30] = new Rule(30, false, false, 8, "30: regf -> (FLOATCONST F32 0.0)", ImList.list(ImList.list("xorl", "%edx", "%edx"), ImList.list("cvtsi2ss", "%edx", "$0")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[0], new String[]{"*reg-tmp-F32*"});
        CodeGenerator_x86simd.rulev[31] = new Rule(31, false, false, 8, "31: regf -> (FLOATCONST F32 1.0)", ImList.list(ImList.list("movl", ImList.list("imm", "1"), "%edx"), ImList.list("cvtsi2ss", "%edx", "$0")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[0], new String[]{"*reg-tmp-F32*"});
        CodeGenerator_x86simd.rulev[3866] = new Rule(3866, false, true, 3571, "3866: _3528 -> (FLOATCONST F32 1.0)", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86simd.rulev[28] = new Rule(28, false, false, 9, "28: regd -> (FLOATCONST F64 0.0)", ImList.list(ImList.list("xorl", "%edx", "%edx"), ImList.list("cvtsi2sd", "%eax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[0], new String[]{"*reg-tmp-F64*"});
        CodeGenerator_x86simd.rulev[29] = new Rule(29, false, false, 9, "29: regd -> (FLOATCONST F64 1.0)", ImList.list(ImList.list("movl", ImList.list("imm", "1"), "%edx"), ImList.list("cvtsi2sd", "%edx", "$0")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[0], new String[]{"*reg-tmp-F64*"});
        CodeGenerator_x86simd.rulev[27] = new Rule(27, false, false, 20, "27: sta -> (STATIC I32)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86simd.rulev[1] = new Rule(1, false, false, 11, "1: xregb -> (REG I8)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86simd.rulev[5] = new Rule(5, false, false, 13, "5: xregw -> (REG I16)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86simd.rulev[8] = new Rule(8, false, false, 12, "8: xregl -> (REG I32)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86simd.rulev[3951] = new Rule(3951, false, true, 3628, "3951: _3585 -> (REG I32 \"%esp\")", null, null, null, 0L, false, false, new int[0], null);
        CodeGenerator_x86simd.rulev[12] = new Rule(12, false, false, 15, "12: xregf -> (REG F32)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86simd.rulev[10] = new Rule(10, false, false, 14, "10: xregq -> (REG I64)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86simd.rulev[23] = new Rule(23, false, false, 18, "23: xregm -> (REG I64)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86simd.rulev[14] = new Rule(14, false, false, 16, "14: xregd -> (REG F64)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86simd.rulev[22] = new Rule(22, false, false, 17, "22: xregx -> (REG I128)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86simd.rulev[2] = new Rule(2, false, false, 11, "2: xregb -> (SUBREG I8)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86simd.rulev[3] = new Rule(3, false, false, 11, "3: xregb -> (SUBREG I8 xregl _)", null, null, null, 0L, false, false, new int[]{12, 0}, new String[]{null, "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4] = new Rule(4, false, false, 11, "4: xregb -> (SUBREG I8 xregw _)", null, null, null, 0L, false, false, new int[]{13, 0}, new String[]{null, "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[89] = new Rule(89, false, true, 50, "89: _7 -> (SUBREG I8 regx _6)", null, null, null, 0L, false, false, new int[]{1, 49}, null);
        CodeGenerator_x86simd.rulev[91] = new Rule(91, false, true, 52, "91: _9 -> (SUBREG I8 regx _4)", null, null, null, 0L, false, false, new int[]{1, 28}, null);
        CodeGenerator_x86simd.rulev[93] = new Rule(93, false, true, 54, "93: _11 -> (SUBREG I8 regx _1)", null, null, null, 0L, false, false, new int[]{1, 25}, null);
        CodeGenerator_x86simd.rulev[95] = new Rule(95, false, true, 56, "95: _13 -> (SUBREG I8 regx _5)", null, null, null, 0L, false, false, new int[]{1, 29}, null);
        CodeGenerator_x86simd.rulev[97] = new Rule(97, false, true, 58, "97: _15 -> (SUBREG I8 regx _2)", null, null, null, 0L, false, false, new int[]{1, 26}, null);
        CodeGenerator_x86simd.rulev[100] = new Rule(100, false, true, 61, "100: _18 -> (SUBREG I8 regx _17)", null, null, null, 0L, false, false, new int[]{1, 60}, null);
        CodeGenerator_x86simd.rulev[103] = new Rule(103, false, true, 64, "103: _21 -> (SUBREG I8 regx _20)", null, null, null, 0L, false, false, new int[]{1, 63}, null);
    }

    private static void rrinit100() {
        CodeGenerator_x86simd.rulev[106] = new Rule(106, false, true, 67, "106: _24 -> (SUBREG I8 regx _23)", null, null, null, 0L, false, false, new int[]{1, 66}, null);
        CodeGenerator_x86simd.rulev[108] = new Rule(108, false, true, 69, "108: _26 -> (SUBREG I8 regx _3)", null, null, null, 0L, false, false, new int[]{1, 27}, null);
        CodeGenerator_x86simd.rulev[111] = new Rule(111, false, true, 72, "111: _29 -> (SUBREG I8 regx _28)", null, null, null, 0L, false, false, new int[]{1, 71}, null);
        CodeGenerator_x86simd.rulev[114] = new Rule(114, false, true, 75, "114: _32 -> (SUBREG I8 regx _31)", null, null, null, 0L, false, false, new int[]{1, 74}, null);
        CodeGenerator_x86simd.rulev[117] = new Rule(117, false, true, 78, "117: _35 -> (SUBREG I8 regx _34)", null, null, null, 0L, false, false, new int[]{1, 77}, null);
        CodeGenerator_x86simd.rulev[120] = new Rule(120, false, true, 81, "120: _38 -> (SUBREG I8 regx _37)", null, null, null, 0L, false, false, new int[]{1, 80}, null);
        CodeGenerator_x86simd.rulev[123] = new Rule(123, false, true, 84, "123: _41 -> (SUBREG I8 regx _40)", null, null, null, 0L, false, false, new int[]{1, 83}, null);
        CodeGenerator_x86simd.rulev[126] = new Rule(126, false, true, 87, "126: _44 -> (SUBREG I8 regx _43)", null, null, null, 0L, false, false, new int[]{1, 86}, null);
        CodeGenerator_x86simd.rulev[129] = new Rule(129, false, true, 90, "129: _47 -> (SUBREG I8 regx _46)", null, null, null, 0L, false, false, new int[]{1, 89}, null);
        CodeGenerator_x86simd.rulev[189] = new Rule(189, false, true, 144, "189: _101 -> (SUBREG I8 regm _6)", null, null, null, 0L, false, false, new int[]{2, 49}, null);
        CodeGenerator_x86simd.rulev[191] = new Rule(191, false, true, 146, "191: _103 -> (SUBREG I8 regm _4)", null, null, null, 0L, false, false, new int[]{2, 28}, null);
        CodeGenerator_x86simd.rulev[193] = new Rule(193, false, true, 148, "193: _105 -> (SUBREG I8 regm _1)", null, null, null, 0L, false, false, new int[]{2, 25}, null);
        CodeGenerator_x86simd.rulev[195] = new Rule(195, false, true, 150, "195: _107 -> (SUBREG I8 regm _5)", null, null, null, 0L, false, false, new int[]{2, 29}, null);
        CodeGenerator_x86simd.rulev[197] = new Rule(197, false, true, 152, "197: _109 -> (SUBREG I8 regm _2)", null, null, null, 0L, false, false, new int[]{2, 26}, null);
        CodeGenerator_x86simd.rulev[199] = new Rule(199, false, true, 154, "199: _111 -> (SUBREG I8 regm _17)", null, null, null, 0L, false, false, new int[]{2, 60}, null);
        CodeGenerator_x86simd.rulev[201] = new Rule(201, false, true, 156, "201: _113 -> (SUBREG I8 regm _20)", null, null, null, 0L, false, false, new int[]{2, 63}, null);
        CodeGenerator_x86simd.rulev[203] = new Rule(203, false, true, 158, "203: _115 -> (SUBREG I8 regm _23)", null, null, null, 0L, false, false, new int[]{2, 66}, null);
        CodeGenerator_x86simd.rulev[265] = new Rule(265, false, true, 186, "265: _143 -> (SUBREG I8 xregx _6)", null, null, null, 0L, false, false, new int[]{17, 49}, null);
        CodeGenerator_x86simd.rulev[267] = new Rule(267, false, true, 188, "267: _145 -> (SUBREG I8 xregx _4)", null, null, null, 0L, false, false, new int[]{17, 28}, null);
        CodeGenerator_x86simd.rulev[269] = new Rule(269, false, true, 190, "269: _147 -> (SUBREG I8 xregx _1)", null, null, null, 0L, false, false, new int[]{17, 25}, null);
        CodeGenerator_x86simd.rulev[271] = new Rule(271, false, true, 192, "271: _149 -> (SUBREG I8 xregx _5)", null, null, null, 0L, false, false, new int[]{17, 29}, null);
        CodeGenerator_x86simd.rulev[273] = new Rule(273, false, true, 194, "273: _151 -> (SUBREG I8 xregx _2)", null, null, null, 0L, false, false, new int[]{17, 26}, null);
        CodeGenerator_x86simd.rulev[275] = new Rule(275, false, true, 196, "275: _153 -> (SUBREG I8 xregx _17)", null, null, null, 0L, false, false, new int[]{17, 60}, null);
        CodeGenerator_x86simd.rulev[277] = new Rule(277, false, true, 198, "277: _155 -> (SUBREG I8 xregx _20)", null, null, null, 0L, false, false, new int[]{17, 63}, null);
        CodeGenerator_x86simd.rulev[279] = new Rule(279, false, true, 200, "279: _157 -> (SUBREG I8 xregx _23)", null, null, null, 0L, false, false, new int[]{17, 66}, null);
        CodeGenerator_x86simd.rulev[281] = new Rule(281, false, true, 202, "281: _159 -> (SUBREG I8 xregx _3)", null, null, null, 0L, false, false, new int[]{17, 27}, null);
        CodeGenerator_x86simd.rulev[283] = new Rule(283, false, true, 204, "283: _161 -> (SUBREG I8 xregx _28)", null, null, null, 0L, false, false, new int[]{17, 71}, null);
        CodeGenerator_x86simd.rulev[285] = new Rule(285, false, true, 206, "285: _163 -> (SUBREG I8 xregx _31)", null, null, null, 0L, false, false, new int[]{17, 74}, null);
        CodeGenerator_x86simd.rulev[287] = new Rule(287, false, true, 208, "287: _165 -> (SUBREG I8 xregx _34)", null, null, null, 0L, false, false, new int[]{17, 77}, null);
        CodeGenerator_x86simd.rulev[289] = new Rule(289, false, true, 210, "289: _167 -> (SUBREG I8 xregx _37)", null, null, null, 0L, false, false, new int[]{17, 80}, null);
        CodeGenerator_x86simd.rulev[291] = new Rule(291, false, true, 212, "291: _169 -> (SUBREG I8 xregx _40)", null, null, null, 0L, false, false, new int[]{17, 83}, null);
        CodeGenerator_x86simd.rulev[293] = new Rule(293, false, true, 214, "293: _171 -> (SUBREG I8 xregx _43)", null, null, null, 0L, false, false, new int[]{17, 86}, null);
        CodeGenerator_x86simd.rulev[295] = new Rule(295, false, true, 216, "295: _173 -> (SUBREG I8 xregx _46)", null, null, null, 0L, false, false, new int[]{17, 89}, null);
        CodeGenerator_x86simd.rulev[366] = new Rule(366, false, true, 242, "366: _199 -> (SUBREG I8 xregm _6)", null, null, null, 0L, false, false, new int[]{18, 49}, null);
        CodeGenerator_x86simd.rulev[368] = new Rule(368, false, true, 244, "368: _201 -> (SUBREG I8 xregm _4)", null, null, null, 0L, false, false, new int[]{18, 28}, null);
        CodeGenerator_x86simd.rulev[370] = new Rule(370, false, true, 246, "370: _203 -> (SUBREG I8 xregm _1)", null, null, null, 0L, false, false, new int[]{18, 25}, null);
        CodeGenerator_x86simd.rulev[372] = new Rule(372, false, true, 248, "372: _205 -> (SUBREG I8 xregm _5)", null, null, null, 0L, false, false, new int[]{18, 29}, null);
        CodeGenerator_x86simd.rulev[374] = new Rule(374, false, true, 250, "374: _207 -> (SUBREG I8 xregm _2)", null, null, null, 0L, false, false, new int[]{18, 26}, null);
        CodeGenerator_x86simd.rulev[376] = new Rule(376, false, true, 252, "376: _209 -> (SUBREG I8 xregm _17)", null, null, null, 0L, false, false, new int[]{18, 60}, null);
        CodeGenerator_x86simd.rulev[378] = new Rule(378, false, true, 254, "378: _211 -> (SUBREG I8 xregm _20)", null, null, null, 0L, false, false, new int[]{18, 63}, null);
        CodeGenerator_x86simd.rulev[380] = new Rule(380, false, true, 256, "380: _213 -> (SUBREG I8 xregm _23)", null, null, null, 0L, false, false, new int[]{18, 66}, null);
        CodeGenerator_x86simd.rulev[6] = new Rule(6, false, false, 13, "6: xregw -> (SUBREG I16)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86simd.rulev[7] = new Rule(7, false, false, 13, "7: xregw -> (SUBREG I16 xregl _)", ImList.list(ImList.list("SUBREG", "$1")), null, null, 0L, false, false, new int[]{12, 0}, new String[]{null, "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[132] = new Rule(132, false, true, 92, "132: _49 -> (SUBREG I16 regx _6)", null, null, null, 0L, false, false, new int[]{1, 49}, null);
        CodeGenerator_x86simd.rulev[134] = new Rule(134, false, true, 94, "134: _51 -> (SUBREG I16 regx _4)", null, null, null, 0L, false, false, new int[]{1, 28}, null);
        CodeGenerator_x86simd.rulev[136] = new Rule(136, false, true, 96, "136: _53 -> (SUBREG I16 regx _1)", null, null, null, 0L, false, false, new int[]{1, 25}, null);
        CodeGenerator_x86simd.rulev[138] = new Rule(138, false, true, 98, "138: _55 -> (SUBREG I16 regx _5)", null, null, null, 0L, false, false, new int[]{1, 29}, null);
        CodeGenerator_x86simd.rulev[140] = new Rule(140, false, true, 100, "140: _57 -> (SUBREG I16 regx _2)", null, null, null, 0L, false, false, new int[]{1, 26}, null);
        CodeGenerator_x86simd.rulev[142] = new Rule(142, false, true, 102, "142: _59 -> (SUBREG I16 regx _17)", null, null, null, 0L, false, false, new int[]{1, 60}, null);
        CodeGenerator_x86simd.rulev[144] = new Rule(144, false, true, 104, "144: _61 -> (SUBREG I16 regx _20)", null, null, null, 0L, false, false, new int[]{1, 63}, null);
        CodeGenerator_x86simd.rulev[146] = new Rule(146, false, true, 106, "146: _63 -> (SUBREG I16 regx _23)", null, null, null, 0L, false, false, new int[]{1, 66}, null);
        CodeGenerator_x86simd.rulev[206] = new Rule(206, false, true, 160, "206: _117 -> (SUBREG I16 regm _6)", null, null, null, 0L, false, false, new int[]{2, 49}, null);
        CodeGenerator_x86simd.rulev[208] = new Rule(208, false, true, 162, "208: _119 -> (SUBREG I16 regm _4)", null, null, null, 0L, false, false, new int[]{2, 28}, null);
        CodeGenerator_x86simd.rulev[210] = new Rule(210, false, true, 164, "210: _121 -> (SUBREG I16 regm _1)", null, null, null, 0L, false, false, new int[]{2, 25}, null);
        CodeGenerator_x86simd.rulev[212] = new Rule(212, false, true, 166, "212: _123 -> (SUBREG I16 regm _5)", null, null, null, 0L, false, false, new int[]{2, 29}, null);
        CodeGenerator_x86simd.rulev[314] = new Rule(314, false, true, 218, "314: _175 -> (SUBREG I16 xregx _6)", null, null, null, 0L, false, false, new int[]{17, 49}, null);
        CodeGenerator_x86simd.rulev[316] = new Rule(316, false, true, 220, "316: _177 -> (SUBREG I16 xregx _4)", null, null, null, 0L, false, false, new int[]{17, 28}, null);
        CodeGenerator_x86simd.rulev[318] = new Rule(318, false, true, 222, "318: _179 -> (SUBREG I16 xregx _1)", null, null, null, 0L, false, false, new int[]{17, 25}, null);
        CodeGenerator_x86simd.rulev[320] = new Rule(320, false, true, 224, "320: _181 -> (SUBREG I16 xregx _5)", null, null, null, 0L, false, false, new int[]{17, 29}, null);
        CodeGenerator_x86simd.rulev[322] = new Rule(322, false, true, 226, "322: _183 -> (SUBREG I16 xregx _2)", null, null, null, 0L, false, false, new int[]{17, 26}, null);
        CodeGenerator_x86simd.rulev[324] = new Rule(324, false, true, 228, "324: _185 -> (SUBREG I16 xregx _17)", null, null, null, 0L, false, false, new int[]{17, 60}, null);
        CodeGenerator_x86simd.rulev[326] = new Rule(326, false, true, 230, "326: _187 -> (SUBREG I16 xregx _20)", null, null, null, 0L, false, false, new int[]{17, 63}, null);
        CodeGenerator_x86simd.rulev[328] = new Rule(328, false, true, 232, "328: _189 -> (SUBREG I16 xregx _23)", null, null, null, 0L, false, false, new int[]{17, 66}, null);
        CodeGenerator_x86simd.rulev[391] = new Rule(391, false, true, 258, "391: _215 -> (SUBREG I16 xregm _6)", null, null, null, 0L, false, false, new int[]{18, 49}, null);
        CodeGenerator_x86simd.rulev[393] = new Rule(393, false, true, 260, "393: _217 -> (SUBREG I16 xregm _4)", null, null, null, 0L, false, false, new int[]{18, 28}, null);
        CodeGenerator_x86simd.rulev[395] = new Rule(395, false, true, 262, "395: _219 -> (SUBREG I16 xregm _1)", null, null, null, 0L, false, false, new int[]{18, 25}, null);
        CodeGenerator_x86simd.rulev[397] = new Rule(397, false, true, 264, "397: _221 -> (SUBREG I16 xregm _5)", null, null, null, 0L, false, false, new int[]{18, 29}, null);
        CodeGenerator_x86simd.rulev[9] = new Rule(9, false, false, 12, "9: xregl -> (SUBREG I32)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86simd.rulev[149] = new Rule(149, false, true, 108, "149: _65 -> (SUBREG I32 regx _6)", null, null, null, 0L, false, false, new int[]{1, 49}, null);
        CodeGenerator_x86simd.rulev[151] = new Rule(151, false, true, 110, "151: _67 -> (SUBREG I32 regx _4)", null, null, null, 0L, false, false, new int[]{1, 28}, null);
        CodeGenerator_x86simd.rulev[153] = new Rule(153, false, true, 112, "153: _69 -> (SUBREG I32 regx _1)", null, null, null, 0L, false, false, new int[]{1, 25}, null);
        CodeGenerator_x86simd.rulev[155] = new Rule(155, false, true, 114, "155: _71 -> (SUBREG I32 regx _5)", null, null, null, 0L, false, false, new int[]{1, 29}, null);
        CodeGenerator_x86simd.rulev[215] = new Rule(215, false, true, 168, "215: _125 -> (SUBREG I32 regm _6)", null, null, null, 0L, false, false, new int[]{2, 49}, null);
        CodeGenerator_x86simd.rulev[217] = new Rule(217, false, true, 170, "217: _127 -> (SUBREG I32 regm _4)", null, null, null, 0L, false, false, new int[]{2, 28}, null);
        CodeGenerator_x86simd.rulev[339] = new Rule(339, false, true, 234, "339: _191 -> (SUBREG I32 xregx _6)", null, null, null, 0L, false, false, new int[]{17, 49}, null);
        CodeGenerator_x86simd.rulev[341] = new Rule(341, false, true, 236, "341: _193 -> (SUBREG I32 xregx _4)", null, null, null, 0L, false, false, new int[]{17, 28}, null);
        CodeGenerator_x86simd.rulev[343] = new Rule(343, false, true, 238, "343: _195 -> (SUBREG I32 xregx _1)", null, null, null, 0L, false, false, new int[]{17, 25}, null);
        CodeGenerator_x86simd.rulev[345] = new Rule(345, false, true, 240, "345: _197 -> (SUBREG I32 xregx _5)", null, null, null, 0L, false, false, new int[]{17, 29}, null);
        CodeGenerator_x86simd.rulev[404] = new Rule(404, false, true, 266, "404: _223 -> (SUBREG I32 xregm _6)", null, null, null, 0L, false, false, new int[]{18, 49}, null);
        CodeGenerator_x86simd.rulev[406] = new Rule(406, false, true, 268, "406: _225 -> (SUBREG I32 xregm _4)", null, null, null, 0L, false, false, new int[]{18, 28}, null);
        CodeGenerator_x86simd.rulev[13] = new Rule(13, false, false, 15, "13: xregf -> (SUBREG F32)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86simd.rulev[3778] = new Rule(3778, false, true, 3503, "3778: _3460 -> (SUBREG F32 regx _6)", null, null, null, 0L, false, false, new int[]{1, 49}, null);
        CodeGenerator_x86simd.rulev[3780] = new Rule(3780, false, true, 3505, "3780: _3462 -> (SUBREG F32 regx _4)", null, null, null, 0L, false, false, new int[]{1, 28}, null);
        CodeGenerator_x86simd.rulev[3782] = new Rule(3782, false, true, 3507, "3782: _3464 -> (SUBREG F32 regx _1)", null, null, null, 0L, false, false, new int[]{1, 25}, null);
        CodeGenerator_x86simd.rulev[3784] = new Rule(3784, false, true, 3509, "3784: _3466 -> (SUBREG F32 regx _5)", null, null, null, 0L, false, false, new int[]{1, 29}, null);
        CodeGenerator_x86simd.rulev[11] = new Rule(11, false, false, 14, "11: xregq -> (SUBREG I64)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86simd.rulev[15] = new Rule(15, false, false, 16, "15: xregd -> (SUBREG F64)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86simd.rulev[3788] = new Rule(3788, false, true, 3511, "3788: _3468 -> (SUBREG F64 regx _6)", null, null, null, 0L, false, false, new int[]{1, 49}, null);
        CodeGenerator_x86simd.rulev[3790] = new Rule(3790, false, true, 3513, "3790: _3470 -> (SUBREG F64 regx _4)", null, null, null, 0L, false, false, new int[]{1, 28}, null);
        CodeGenerator_x86simd.rulev[36] = new Rule(36, false, false, 22, "36: lab -> (LABEL I32)", null, null, null, 0L, false, false, new int[0], new String[]{null});
        CodeGenerator_x86simd.rulev[3639] = new Rule(3639, false, true, 3376, "3639: _3333 -> (NEG I8 _101)", null, null, null, 0L, false, false, new int[]{144}, null);
        CodeGenerator_x86simd.rulev[3641] = new Rule(3641, false, true, 3378, "3641: _3335 -> (NEG I8 _103)", null, null, null, 0L, false, false, new int[]{146}, null);
        CodeGenerator_x86simd.rulev[3643] = new Rule(3643, false, true, 3380, "3643: _3337 -> (NEG I8 _105)", null, null, null, 0L, false, false, new int[]{148}, null);
        CodeGenerator_x86simd.rulev[3645] = new Rule(3645, false, true, 3382, "3645: _3339 -> (NEG I8 _107)", null, null, null, 0L, false, false, new int[]{150}, null);
        CodeGenerator_x86simd.rulev[3647] = new Rule(3647, false, true, 3384, "3647: _3341 -> (NEG I8 _109)", null, null, null, 0L, false, false, new int[]{152}, null);
        CodeGenerator_x86simd.rulev[3649] = new Rule(3649, false, true, 3386, "3649: _3343 -> (NEG I8 _111)", null, null, null, 0L, false, false, new int[]{154}, null);
        CodeGenerator_x86simd.rulev[3651] = new Rule(3651, false, true, 3388, "3651: _3345 -> (NEG I8 _113)", null, null, null, 0L, false, false, new int[]{156}, null);
        CodeGenerator_x86simd.rulev[3653] = new Rule(3653, false, true, 3390, "3653: _3347 -> (NEG I8 _115)", null, null, null, 0L, false, false, new int[]{158}, null);
        CodeGenerator_x86simd.rulev[3656] = new Rule(3656, false, true, 3392, "3656: _3349 -> (NEG I8 _7)", null, null, null, 0L, false, false, new int[]{50}, null);
        CodeGenerator_x86simd.rulev[3658] = new Rule(3658, false, true, 3394, "3658: _3351 -> (NEG I8 _9)", null, null, null, 0L, false, false, new int[]{52}, null);
    }

    private static void rrinit200() {
        CodeGenerator_x86simd.rulev[3660] = new Rule(3660, false, true, 3396, "3660: _3353 -> (NEG I8 _11)", null, null, null, 0L, false, false, new int[]{54}, null);
        CodeGenerator_x86simd.rulev[3662] = new Rule(3662, false, true, 3398, "3662: _3355 -> (NEG I8 _13)", null, null, null, 0L, false, false, new int[]{56}, null);
        CodeGenerator_x86simd.rulev[3664] = new Rule(3664, false, true, 3400, "3664: _3357 -> (NEG I8 _15)", null, null, null, 0L, false, false, new int[]{58}, null);
        CodeGenerator_x86simd.rulev[3666] = new Rule(3666, false, true, 3402, "3666: _3359 -> (NEG I8 _18)", null, null, null, 0L, false, false, new int[]{61}, null);
        CodeGenerator_x86simd.rulev[3668] = new Rule(3668, false, true, 3404, "3668: _3361 -> (NEG I8 _21)", null, null, null, 0L, false, false, new int[]{64}, null);
        CodeGenerator_x86simd.rulev[3670] = new Rule(3670, false, true, 3406, "3670: _3363 -> (NEG I8 _24)", null, null, null, 0L, false, false, new int[]{67}, null);
        CodeGenerator_x86simd.rulev[3672] = new Rule(3672, false, true, 3408, "3672: _3365 -> (NEG I8 _26)", null, null, null, 0L, false, false, new int[]{69}, null);
        CodeGenerator_x86simd.rulev[3674] = new Rule(3674, false, true, 3410, "3674: _3367 -> (NEG I8 _29)", null, null, null, 0L, false, false, new int[]{72}, null);
        CodeGenerator_x86simd.rulev[3676] = new Rule(3676, false, true, 3412, "3676: _3369 -> (NEG I8 _32)", null, null, null, 0L, false, false, new int[]{75}, null);
        CodeGenerator_x86simd.rulev[3678] = new Rule(3678, false, true, 3414, "3678: _3371 -> (NEG I8 _35)", null, null, null, 0L, false, false, new int[]{78}, null);
        CodeGenerator_x86simd.rulev[3680] = new Rule(3680, false, true, 3416, "3680: _3373 -> (NEG I8 _38)", null, null, null, 0L, false, false, new int[]{81}, null);
        CodeGenerator_x86simd.rulev[3682] = new Rule(3682, false, true, 3418, "3682: _3375 -> (NEG I8 _41)", null, null, null, 0L, false, false, new int[]{84}, null);
        CodeGenerator_x86simd.rulev[3684] = new Rule(3684, false, true, 3420, "3684: _3377 -> (NEG I8 _44)", null, null, null, 0L, false, false, new int[]{87}, null);
        CodeGenerator_x86simd.rulev[3686] = new Rule(3686, false, true, 3422, "3686: _3379 -> (NEG I8 _47)", null, null, null, 0L, false, false, new int[]{90}, null);
        CodeGenerator_x86simd.rulev[4030] = new Rule(4030, false, false, 7, "4030: regb -> (NEG I8 regb)", ImList.list(ImList.list("negb", "$0")), null, null, 2L, false, false, new int[]{7}, new String[]{"*reg-I8*", "*reg-I8*"});
        CodeGenerator_x86simd.rulev[3689] = new Rule(3689, false, true, 3424, "3689: _3381 -> (NEG I16 _117)", null, null, null, 0L, false, false, new int[]{160}, null);
        CodeGenerator_x86simd.rulev[3691] = new Rule(3691, false, true, 3426, "3691: _3383 -> (NEG I16 _119)", null, null, null, 0L, false, false, new int[]{162}, null);
        CodeGenerator_x86simd.rulev[3693] = new Rule(3693, false, true, 3428, "3693: _3385 -> (NEG I16 _121)", null, null, null, 0L, false, false, new int[]{164}, null);
        CodeGenerator_x86simd.rulev[3695] = new Rule(3695, false, true, 3430, "3695: _3387 -> (NEG I16 _123)", null, null, null, 0L, false, false, new int[]{166}, null);
        CodeGenerator_x86simd.rulev[3698] = new Rule(3698, false, true, 3432, "3698: _3389 -> (NEG I16 _49)", null, null, null, 0L, false, false, new int[]{92}, null);
        CodeGenerator_x86simd.rulev[3700] = new Rule(3700, false, true, 3434, "3700: _3391 -> (NEG I16 _51)", null, null, null, 0L, false, false, new int[]{94}, null);
        CodeGenerator_x86simd.rulev[3702] = new Rule(3702, false, true, 3436, "3702: _3393 -> (NEG I16 _53)", null, null, null, 0L, false, false, new int[]{96}, null);
        CodeGenerator_x86simd.rulev[3704] = new Rule(3704, false, true, 3438, "3704: _3395 -> (NEG I16 _55)", null, null, null, 0L, false, false, new int[]{98}, null);
        CodeGenerator_x86simd.rulev[3706] = new Rule(3706, false, true, 3440, "3706: _3397 -> (NEG I16 _57)", null, null, null, 0L, false, false, new int[]{100}, null);
        CodeGenerator_x86simd.rulev[3708] = new Rule(3708, false, true, 3442, "3708: _3399 -> (NEG I16 _59)", null, null, null, 0L, false, false, new int[]{102}, null);
        CodeGenerator_x86simd.rulev[3710] = new Rule(3710, false, true, 3444, "3710: _3401 -> (NEG I16 _61)", null, null, null, 0L, false, false, new int[]{104}, null);
        CodeGenerator_x86simd.rulev[3712] = new Rule(3712, false, true, 3446, "3712: _3403 -> (NEG I16 _63)", null, null, null, 0L, false, false, new int[]{106}, null);
        CodeGenerator_x86simd.rulev[4032] = new Rule(4032, false, false, 6, "4032: regw -> (NEG I16 regw)", ImList.list(ImList.list("negw", "$0")), null, null, 2L, false, false, new int[]{6}, new String[]{"*reg-I16*", "*reg-I16*"});
        CodeGenerator_x86simd.rulev[3715] = new Rule(3715, false, true, 3448, "3715: _3405 -> (NEG I32 _125)", null, null, null, 0L, false, false, new int[]{168}, null);
        CodeGenerator_x86simd.rulev[3717] = new Rule(3717, false, true, 3450, "3717: _3407 -> (NEG I32 _127)", null, null, null, 0L, false, false, new int[]{170}, null);
        CodeGenerator_x86simd.rulev[3720] = new Rule(3720, false, true, 3452, "3720: _3409 -> (NEG I32 _65)", null, null, null, 0L, false, false, new int[]{108}, null);
        CodeGenerator_x86simd.rulev[3722] = new Rule(3722, false, true, 3454, "3722: _3411 -> (NEG I32 _67)", null, null, null, 0L, false, false, new int[]{110}, null);
        CodeGenerator_x86simd.rulev[3724] = new Rule(3724, false, true, 3456, "3724: _3413 -> (NEG I32 _69)", null, null, null, 0L, false, false, new int[]{112}, null);
        CodeGenerator_x86simd.rulev[3726] = new Rule(3726, false, true, 3458, "3726: _3415 -> (NEG I32 _71)", null, null, null, 0L, false, false, new int[]{114}, null);
        CodeGenerator_x86simd.rulev[4034] = new Rule(4034, false, false, 4, "4034: regl -> (NEG I32 regl)", ImList.list(ImList.list("negl", "$0")), null, null, 2L, false, false, new int[]{4}, new String[]{"*reg-I32*", "*reg-I32*"});
        CodeGenerator_x86simd.rulev[4103] = new Rule(4103, false, false, 8, "4103: regf -> (NEG F32 regf)", ImList.list(ImList.list("movl", ImList.list("imm", "2147483648"), "%edx"), ImList.list("movd", "%edx", "%XMM7"), ImList.list("xorps", "%XMM7", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I128", "%XMM7")), 2L, false, false, new int[]{8}, new String[]{"*reg-tmp-F32*", "*reg-tmp-F32*"});
        CodeGenerator_x86simd.rulev[3979] = new Rule(3979, false, false, 3, "3979: regq -> (NEG I64 regq)", ImList.list(ImList.list("negl", ImList.list("qlow", "$0")), ImList.list("adcl", ImList.list("imm", "0"), ImList.list("qhigh", "$0")), ImList.list("negl", ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{3}, new String[]{"*reg-I64*", "*reg-I64*"});
        CodeGenerator_x86simd.rulev[4098] = new Rule(4098, false, false, 9, "4098: regd -> (NEG F64 regd)", ImList.list(ImList.list("movl", ImList.list("imm", "128"), "%edx"), ImList.list("movd", "%edx", "%XMM7"), ImList.list("pslldq", ImList.list("imm", "7"), "%XMM7"), ImList.list("xorpd", "%XMM7", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I128", "%XMM7")), 2L, false, false, new int[]{9}, new String[]{"*reg-tmp-F64*", "*reg-tmp-F64*"});
        CodeGenerator_x86simd.rulev[471] = new Rule(471, false, true, 324, "471: _281 -> (ADD I8 _274 _280)", null, null, null, 0L, false, false, new int[]{317, 323}, null);
        CodeGenerator_x86simd.rulev[478] = new Rule(478, false, true, 331, "478: _288 -> (ADD I8 _281 _287)", null, null, null, 0L, false, false, new int[]{324, 330}, null);
        CodeGenerator_x86simd.rulev[485] = new Rule(485, false, true, 338, "485: _295 -> (ADD I8 _288 _294)", null, null, null, 0L, false, false, new int[]{331, 337}, null);
        CodeGenerator_x86simd.rulev[492] = new Rule(492, false, true, 345, "492: _302 -> (ADD I8 _295 _301)", null, null, null, 0L, false, false, new int[]{338, 344}, null);
        CodeGenerator_x86simd.rulev[499] = new Rule(499, false, true, 352, "499: _309 -> (ADD I8 _302 _308)", null, null, null, 0L, false, false, new int[]{345, 351}, null);
        CodeGenerator_x86simd.rulev[506] = new Rule(506, false, true, 359, "506: _316 -> (ADD I8 _309 _315)", null, null, null, 0L, false, false, new int[]{352, 358}, null);
        CodeGenerator_x86simd.rulev[513] = new Rule(513, false, true, 366, "513: _323 -> (ADD I8 _316 _322)", null, null, null, 0L, false, false, new int[]{359, 365}, null);
        CodeGenerator_x86simd.rulev[527] = new Rule(527, false, true, 379, "527: _336 -> (ADD I8 _329 _335)", null, null, null, 0L, false, false, new int[]{372, 378}, null);
        CodeGenerator_x86simd.rulev[534] = new Rule(534, false, true, 386, "534: _343 -> (ADD I8 _336 _342)", null, null, null, 0L, false, false, new int[]{379, 385}, null);
        CodeGenerator_x86simd.rulev[541] = new Rule(541, false, true, 393, "541: _350 -> (ADD I8 _343 _349)", null, null, null, 0L, false, false, new int[]{386, 392}, null);
        CodeGenerator_x86simd.rulev[548] = new Rule(548, false, true, 400, "548: _357 -> (ADD I8 _350 _356)", null, null, null, 0L, false, false, new int[]{393, 399}, null);
        CodeGenerator_x86simd.rulev[555] = new Rule(555, false, true, 407, "555: _364 -> (ADD I8 _357 _363)", null, null, null, 0L, false, false, new int[]{400, 406}, null);
        CodeGenerator_x86simd.rulev[562] = new Rule(562, false, true, 414, "562: _371 -> (ADD I8 _364 _370)", null, null, null, 0L, false, false, new int[]{407, 413}, null);
        CodeGenerator_x86simd.rulev[569] = new Rule(569, false, true, 421, "569: _378 -> (ADD I8 _371 _377)", null, null, null, 0L, false, false, new int[]{414, 420}, null);
        CodeGenerator_x86simd.rulev[583] = new Rule(583, false, true, 435, "583: _392 -> (ADD I8 _385 _391)", null, null, null, 0L, false, false, new int[]{428, 434}, null);
        CodeGenerator_x86simd.rulev[590] = new Rule(590, false, true, 442, "590: _399 -> (ADD I8 _392 _398)", null, null, null, 0L, false, false, new int[]{435, 441}, null);
        CodeGenerator_x86simd.rulev[597] = new Rule(597, false, true, 449, "597: _406 -> (ADD I8 _399 _405)", null, null, null, 0L, false, false, new int[]{442, 448}, null);
        CodeGenerator_x86simd.rulev[604] = new Rule(604, false, true, 456, "604: _413 -> (ADD I8 _406 _412)", null, null, null, 0L, false, false, new int[]{449, 455}, null);
        CodeGenerator_x86simd.rulev[611] = new Rule(611, false, true, 463, "611: _420 -> (ADD I8 _413 _419)", null, null, null, 0L, false, false, new int[]{456, 462}, null);
        CodeGenerator_x86simd.rulev[618] = new Rule(618, false, true, 470, "618: _427 -> (ADD I8 _420 _426)", null, null, null, 0L, false, false, new int[]{463, 469}, null);
        CodeGenerator_x86simd.rulev[625] = new Rule(625, false, true, 477, "625: _434 -> (ADD I8 _427 _433)", null, null, null, 0L, false, false, new int[]{470, 476}, null);
        CodeGenerator_x86simd.rulev[628] = new Rule(628, false, true, 479, "628: _436 -> (ADD I8 _101 _101)", null, null, null, 0L, false, false, new int[]{144, 144}, null);
        CodeGenerator_x86simd.rulev[630] = new Rule(630, false, true, 481, "630: _438 -> (ADD I8 _436 _437)", null, null, null, 0L, false, false, new int[]{479, 480}, null);
        CodeGenerator_x86simd.rulev[633] = new Rule(633, false, true, 484, "633: _441 -> (ADD I8 _103 _103)", null, null, null, 0L, false, false, new int[]{146, 146}, null);
        CodeGenerator_x86simd.rulev[634] = new Rule(634, false, true, 485, "634: _442 -> (ADD I8 _441 _437)", null, null, null, 0L, false, false, new int[]{484, 480}, null);
        CodeGenerator_x86simd.rulev[637] = new Rule(637, false, true, 488, "637: _445 -> (ADD I8 _105 _105)", null, null, null, 0L, false, false, new int[]{148, 148}, null);
        CodeGenerator_x86simd.rulev[638] = new Rule(638, false, true, 489, "638: _446 -> (ADD I8 _445 _437)", null, null, null, 0L, false, false, new int[]{488, 480}, null);
        CodeGenerator_x86simd.rulev[641] = new Rule(641, false, true, 492, "641: _449 -> (ADD I8 _107 _107)", null, null, null, 0L, false, false, new int[]{150, 150}, null);
        CodeGenerator_x86simd.rulev[642] = new Rule(642, false, true, 493, "642: _450 -> (ADD I8 _449 _437)", null, null, null, 0L, false, false, new int[]{492, 480}, null);
        CodeGenerator_x86simd.rulev[645] = new Rule(645, false, true, 496, "645: _453 -> (ADD I8 _109 _109)", null, null, null, 0L, false, false, new int[]{152, 152}, null);
        CodeGenerator_x86simd.rulev[646] = new Rule(646, false, true, 497, "646: _454 -> (ADD I8 _453 _437)", null, null, null, 0L, false, false, new int[]{496, 480}, null);
        CodeGenerator_x86simd.rulev[649] = new Rule(649, false, true, 500, "649: _457 -> (ADD I8 _111 _111)", null, null, null, 0L, false, false, new int[]{154, 154}, null);
        CodeGenerator_x86simd.rulev[650] = new Rule(650, false, true, 501, "650: _458 -> (ADD I8 _457 _437)", null, null, null, 0L, false, false, new int[]{500, 480}, null);
        CodeGenerator_x86simd.rulev[653] = new Rule(653, false, true, 504, "653: _461 -> (ADD I8 _113 _113)", null, null, null, 0L, false, false, new int[]{156, 156}, null);
        CodeGenerator_x86simd.rulev[654] = new Rule(654, false, true, 505, "654: _462 -> (ADD I8 _461 _437)", null, null, null, 0L, false, false, new int[]{504, 480}, null);
        CodeGenerator_x86simd.rulev[657] = new Rule(657, false, true, 508, "657: _465 -> (ADD I8 _115 _115)", null, null, null, 0L, false, false, new int[]{158, 158}, null);
        CodeGenerator_x86simd.rulev[658] = new Rule(658, false, true, 509, "658: _466 -> (ADD I8 _465 _437)", null, null, null, 0L, false, false, new int[]{508, 480}, null);
        CodeGenerator_x86simd.rulev[663] = new Rule(663, false, true, 513, "663: _470 -> (ADD I8 _469 _469)", null, null, null, 0L, false, false, new int[]{512, 512}, null);
        CodeGenerator_x86simd.rulev[666] = new Rule(666, false, true, 516, "666: _473 -> (ADD I8 _470 _472)", null, null, null, 0L, false, false, new int[]{513, 515}, null);
        CodeGenerator_x86simd.rulev[669] = new Rule(669, false, true, 519, "669: _476 -> (ADD I8 _475 _475)", null, null, null, 0L, false, false, new int[]{518, 518}, null);
        CodeGenerator_x86simd.rulev[672] = new Rule(672, false, true, 522, "672: _479 -> (ADD I8 _476 _478)", null, null, null, 0L, false, false, new int[]{519, 521}, null);
        CodeGenerator_x86simd.rulev[675] = new Rule(675, false, true, 525, "675: _482 -> (ADD I8 _481 _481)", null, null, null, 0L, false, false, new int[]{524, 524}, null);
        CodeGenerator_x86simd.rulev[678] = new Rule(678, false, true, 528, "678: _485 -> (ADD I8 _482 _484)", null, null, null, 0L, false, false, new int[]{525, 527}, null);
        CodeGenerator_x86simd.rulev[681] = new Rule(681, false, true, 531, "681: _488 -> (ADD I8 _487 _487)", null, null, null, 0L, false, false, new int[]{530, 530}, null);
        CodeGenerator_x86simd.rulev[684] = new Rule(684, false, true, 534, "684: _491 -> (ADD I8 _488 _490)", null, null, null, 0L, false, false, new int[]{531, 533}, null);
        CodeGenerator_x86simd.rulev[687] = new Rule(687, false, true, 537, "687: _494 -> (ADD I8 _493 _493)", null, null, null, 0L, false, false, new int[]{536, 536}, null);
        CodeGenerator_x86simd.rulev[690] = new Rule(690, false, true, 540, "690: _497 -> (ADD I8 _494 _496)", null, null, null, 0L, false, false, new int[]{537, 539}, null);
        CodeGenerator_x86simd.rulev[693] = new Rule(693, false, true, 543, "693: _500 -> (ADD I8 _499 _499)", null, null, null, 0L, false, false, new int[]{542, 542}, null);
        CodeGenerator_x86simd.rulev[696] = new Rule(696, false, true, 546, "696: _503 -> (ADD I8 _500 _502)", null, null, null, 0L, false, false, new int[]{543, 545}, null);
        CodeGenerator_x86simd.rulev[699] = new Rule(699, false, true, 549, "699: _506 -> (ADD I8 _505 _505)", null, null, null, 0L, false, false, new int[]{548, 548}, null);
        CodeGenerator_x86simd.rulev[702] = new Rule(702, false, true, 552, "702: _509 -> (ADD I8 _506 _508)", null, null, null, 0L, false, false, new int[]{549, 551}, null);
        CodeGenerator_x86simd.rulev[705] = new Rule(705, false, true, 555, "705: _512 -> (ADD I8 _511 _511)", null, null, null, 0L, false, false, new int[]{554, 554}, null);
        CodeGenerator_x86simd.rulev[708] = new Rule(708, false, true, 558, "708: _515 -> (ADD I8 _512 _514)", null, null, null, 0L, false, false, new int[]{555, 557}, null);
        CodeGenerator_x86simd.rulev[711] = new Rule(711, false, true, 560, "711: _517 -> (ADD I8 _7 _7)", null, null, null, 0L, false, false, new int[]{50, 50}, null);
        CodeGenerator_x86simd.rulev[712] = new Rule(712, false, true, 561, "712: _518 -> (ADD I8 _517 _437)", null, null, null, 0L, false, false, new int[]{560, 480}, null);
        CodeGenerator_x86simd.rulev[715] = new Rule(715, false, true, 564, "715: _521 -> (ADD I8 _9 _9)", null, null, null, 0L, false, false, new int[]{52, 52}, null);
        CodeGenerator_x86simd.rulev[716] = new Rule(716, false, true, 565, "716: _522 -> (ADD I8 _521 _437)", null, null, null, 0L, false, false, new int[]{564, 480}, null);
        CodeGenerator_x86simd.rulev[719] = new Rule(719, false, true, 568, "719: _525 -> (ADD I8 _11 _11)", null, null, null, 0L, false, false, new int[]{54, 54}, null);
        CodeGenerator_x86simd.rulev[720] = new Rule(720, false, true, 569, "720: _526 -> (ADD I8 _525 _437)", null, null, null, 0L, false, false, new int[]{568, 480}, null);
        CodeGenerator_x86simd.rulev[723] = new Rule(723, false, true, 572, "723: _529 -> (ADD I8 _13 _13)", null, null, null, 0L, false, false, new int[]{56, 56}, null);
        CodeGenerator_x86simd.rulev[724] = new Rule(724, false, true, 573, "724: _530 -> (ADD I8 _529 _437)", null, null, null, 0L, false, false, new int[]{572, 480}, null);
        CodeGenerator_x86simd.rulev[727] = new Rule(727, false, true, 576, "727: _533 -> (ADD I8 _15 _15)", null, null, null, 0L, false, false, new int[]{58, 58}, null);
    }

    private static void rrinit300() {
        CodeGenerator_x86simd.rulev[728] = new Rule(728, false, true, 577, "728: _534 -> (ADD I8 _533 _437)", null, null, null, 0L, false, false, new int[]{576, 480}, null);
        CodeGenerator_x86simd.rulev[731] = new Rule(731, false, true, 580, "731: _537 -> (ADD I8 _18 _18)", null, null, null, 0L, false, false, new int[]{61, 61}, null);
        CodeGenerator_x86simd.rulev[732] = new Rule(732, false, true, 581, "732: _538 -> (ADD I8 _537 _437)", null, null, null, 0L, false, false, new int[]{580, 480}, null);
        CodeGenerator_x86simd.rulev[735] = new Rule(735, false, true, 584, "735: _541 -> (ADD I8 _21 _21)", null, null, null, 0L, false, false, new int[]{64, 64}, null);
        CodeGenerator_x86simd.rulev[736] = new Rule(736, false, true, 585, "736: _542 -> (ADD I8 _541 _437)", null, null, null, 0L, false, false, new int[]{584, 480}, null);
        CodeGenerator_x86simd.rulev[739] = new Rule(739, false, true, 588, "739: _545 -> (ADD I8 _24 _24)", null, null, null, 0L, false, false, new int[]{67, 67}, null);
        CodeGenerator_x86simd.rulev[740] = new Rule(740, false, true, 589, "740: _546 -> (ADD I8 _545 _437)", null, null, null, 0L, false, false, new int[]{588, 480}, null);
        CodeGenerator_x86simd.rulev[743] = new Rule(743, false, true, 592, "743: _549 -> (ADD I8 _26 _26)", null, null, null, 0L, false, false, new int[]{69, 69}, null);
        CodeGenerator_x86simd.rulev[744] = new Rule(744, false, true, 593, "744: _550 -> (ADD I8 _549 _437)", null, null, null, 0L, false, false, new int[]{592, 480}, null);
        CodeGenerator_x86simd.rulev[747] = new Rule(747, false, true, 596, "747: _553 -> (ADD I8 _29 _29)", null, null, null, 0L, false, false, new int[]{72, 72}, null);
        CodeGenerator_x86simd.rulev[748] = new Rule(748, false, true, 597, "748: _554 -> (ADD I8 _553 _437)", null, null, null, 0L, false, false, new int[]{596, 480}, null);
        CodeGenerator_x86simd.rulev[751] = new Rule(751, false, true, 600, "751: _557 -> (ADD I8 _32 _32)", null, null, null, 0L, false, false, new int[]{75, 75}, null);
        CodeGenerator_x86simd.rulev[752] = new Rule(752, false, true, 601, "752: _558 -> (ADD I8 _557 _437)", null, null, null, 0L, false, false, new int[]{600, 480}, null);
        CodeGenerator_x86simd.rulev[755] = new Rule(755, false, true, 604, "755: _561 -> (ADD I8 _35 _35)", null, null, null, 0L, false, false, new int[]{78, 78}, null);
        CodeGenerator_x86simd.rulev[756] = new Rule(756, false, true, 605, "756: _562 -> (ADD I8 _561 _437)", null, null, null, 0L, false, false, new int[]{604, 480}, null);
        CodeGenerator_x86simd.rulev[759] = new Rule(759, false, true, 608, "759: _565 -> (ADD I8 _38 _38)", null, null, null, 0L, false, false, new int[]{81, 81}, null);
        CodeGenerator_x86simd.rulev[760] = new Rule(760, false, true, 609, "760: _566 -> (ADD I8 _565 _437)", null, null, null, 0L, false, false, new int[]{608, 480}, null);
        CodeGenerator_x86simd.rulev[763] = new Rule(763, false, true, 612, "763: _569 -> (ADD I8 _41 _41)", null, null, null, 0L, false, false, new int[]{84, 84}, null);
        CodeGenerator_x86simd.rulev[764] = new Rule(764, false, true, 613, "764: _570 -> (ADD I8 _569 _437)", null, null, null, 0L, false, false, new int[]{612, 480}, null);
        CodeGenerator_x86simd.rulev[767] = new Rule(767, false, true, 616, "767: _573 -> (ADD I8 _44 _44)", null, null, null, 0L, false, false, new int[]{87, 87}, null);
        CodeGenerator_x86simd.rulev[768] = new Rule(768, false, true, 617, "768: _574 -> (ADD I8 _573 _437)", null, null, null, 0L, false, false, new int[]{616, 480}, null);
        CodeGenerator_x86simd.rulev[771] = new Rule(771, false, true, 620, "771: _577 -> (ADD I8 _47 _47)", null, null, null, 0L, false, false, new int[]{90, 90}, null);
        CodeGenerator_x86simd.rulev[772] = new Rule(772, false, true, 621, "772: _578 -> (ADD I8 _577 _437)", null, null, null, 0L, false, false, new int[]{620, 480}, null);
        CodeGenerator_x86simd.rulev[777] = new Rule(777, false, true, 625, "777: _582 -> (ADD I8 _581 _581)", null, null, null, 0L, false, false, new int[]{624, 624}, null);
        CodeGenerator_x86simd.rulev[780] = new Rule(780, false, true, 628, "780: _585 -> (ADD I8 _582 _584)", null, null, null, 0L, false, false, new int[]{625, 627}, null);
        CodeGenerator_x86simd.rulev[783] = new Rule(783, false, true, 631, "783: _588 -> (ADD I8 _587 _587)", null, null, null, 0L, false, false, new int[]{630, 630}, null);
        CodeGenerator_x86simd.rulev[786] = new Rule(786, false, true, 634, "786: _591 -> (ADD I8 _588 _590)", null, null, null, 0L, false, false, new int[]{631, 633}, null);
        CodeGenerator_x86simd.rulev[789] = new Rule(789, false, true, 637, "789: _594 -> (ADD I8 _593 _593)", null, null, null, 0L, false, false, new int[]{636, 636}, null);
        CodeGenerator_x86simd.rulev[792] = new Rule(792, false, true, 640, "792: _597 -> (ADD I8 _594 _596)", null, null, null, 0L, false, false, new int[]{637, 639}, null);
        CodeGenerator_x86simd.rulev[795] = new Rule(795, false, true, 643, "795: _600 -> (ADD I8 _599 _599)", null, null, null, 0L, false, false, new int[]{642, 642}, null);
        CodeGenerator_x86simd.rulev[798] = new Rule(798, false, true, 646, "798: _603 -> (ADD I8 _600 _602)", null, null, null, 0L, false, false, new int[]{643, 645}, null);
        CodeGenerator_x86simd.rulev[801] = new Rule(801, false, true, 649, "801: _606 -> (ADD I8 _605 _605)", null, null, null, 0L, false, false, new int[]{648, 648}, null);
        CodeGenerator_x86simd.rulev[804] = new Rule(804, false, true, 652, "804: _609 -> (ADD I8 _606 _608)", null, null, null, 0L, false, false, new int[]{649, 651}, null);
        CodeGenerator_x86simd.rulev[807] = new Rule(807, false, true, 655, "807: _612 -> (ADD I8 _611 _611)", null, null, null, 0L, false, false, new int[]{654, 654}, null);
        CodeGenerator_x86simd.rulev[810] = new Rule(810, false, true, 658, "810: _615 -> (ADD I8 _612 _614)", null, null, null, 0L, false, false, new int[]{655, 657}, null);
        CodeGenerator_x86simd.rulev[813] = new Rule(813, false, true, 661, "813: _618 -> (ADD I8 _617 _617)", null, null, null, 0L, false, false, new int[]{660, 660}, null);
        CodeGenerator_x86simd.rulev[816] = new Rule(816, false, true, 664, "816: _621 -> (ADD I8 _618 _620)", null, null, null, 0L, false, false, new int[]{661, 663}, null);
        CodeGenerator_x86simd.rulev[819] = new Rule(819, false, true, 667, "819: _624 -> (ADD I8 _623 _623)", null, null, null, 0L, false, false, new int[]{666, 666}, null);
        CodeGenerator_x86simd.rulev[822] = new Rule(822, false, true, 670, "822: _627 -> (ADD I8 _624 _626)", null, null, null, 0L, false, false, new int[]{667, 669}, null);
        CodeGenerator_x86simd.rulev[825] = new Rule(825, false, true, 673, "825: _630 -> (ADD I8 _629 _629)", null, null, null, 0L, false, false, new int[]{672, 672}, null);
        CodeGenerator_x86simd.rulev[828] = new Rule(828, false, true, 676, "828: _633 -> (ADD I8 _630 _632)", null, null, null, 0L, false, false, new int[]{673, 675}, null);
        CodeGenerator_x86simd.rulev[831] = new Rule(831, false, true, 679, "831: _636 -> (ADD I8 _635 _635)", null, null, null, 0L, false, false, new int[]{678, 678}, null);
        CodeGenerator_x86simd.rulev[834] = new Rule(834, false, true, 682, "834: _639 -> (ADD I8 _636 _638)", null, null, null, 0L, false, false, new int[]{679, 681}, null);
        CodeGenerator_x86simd.rulev[837] = new Rule(837, false, true, 685, "837: _642 -> (ADD I8 _641 _641)", null, null, null, 0L, false, false, new int[]{684, 684}, null);
        CodeGenerator_x86simd.rulev[840] = new Rule(840, false, true, 688, "840: _645 -> (ADD I8 _642 _644)", null, null, null, 0L, false, false, new int[]{685, 687}, null);
        CodeGenerator_x86simd.rulev[843] = new Rule(843, false, true, 691, "843: _648 -> (ADD I8 _647 _647)", null, null, null, 0L, false, false, new int[]{690, 690}, null);
        CodeGenerator_x86simd.rulev[846] = new Rule(846, false, true, 694, "846: _651 -> (ADD I8 _648 _650)", null, null, null, 0L, false, false, new int[]{691, 693}, null);
        CodeGenerator_x86simd.rulev[849] = new Rule(849, false, true, 697, "849: _654 -> (ADD I8 _653 _653)", null, null, null, 0L, false, false, new int[]{696, 696}, null);
        CodeGenerator_x86simd.rulev[852] = new Rule(852, false, true, 700, "852: _657 -> (ADD I8 _654 _656)", null, null, null, 0L, false, false, new int[]{697, 699}, null);
        CodeGenerator_x86simd.rulev[855] = new Rule(855, false, true, 703, "855: _660 -> (ADD I8 _659 _659)", null, null, null, 0L, false, false, new int[]{702, 702}, null);
        CodeGenerator_x86simd.rulev[858] = new Rule(858, false, true, 706, "858: _663 -> (ADD I8 _660 _662)", null, null, null, 0L, false, false, new int[]{703, 705}, null);
        CodeGenerator_x86simd.rulev[861] = new Rule(861, false, true, 709, "861: _666 -> (ADD I8 _665 _665)", null, null, null, 0L, false, false, new int[]{708, 708}, null);
        CodeGenerator_x86simd.rulev[864] = new Rule(864, false, true, 712, "864: _669 -> (ADD I8 _666 _668)", null, null, null, 0L, false, false, new int[]{709, 711}, null);
        CodeGenerator_x86simd.rulev[867] = new Rule(867, false, true, 715, "867: _672 -> (ADD I8 _671 _671)", null, null, null, 0L, false, false, new int[]{714, 714}, null);
        CodeGenerator_x86simd.rulev[870] = new Rule(870, false, true, 718, "870: _675 -> (ADD I8 _672 _674)", null, null, null, 0L, false, false, new int[]{715, 717}, null);
        CodeGenerator_x86simd.rulev[4008] = new Rule(4008, false, false, 7, "4008: regb -> (ADD I8 regb mrcb)", ImList.list(ImList.list("addb", "$2", "$0")), null, null, 2L, false, false, new int[]{7, 44}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[4026] = new Rule(4026, false, false, 7, "4026: regb -> (ADD I8 mrcb regb)", ImList.list(ImList.list("addb", "$1", "$0")), null, null, 4L, false, false, new int[]{44, 7}, new String[]{"*reg-I8*", null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[873] = new Rule(873, false, true, 720, "873: _677 -> (ADD I16 _117 _117)", null, null, null, 0L, false, false, new int[]{160, 160}, null);
        CodeGenerator_x86simd.rulev[875] = new Rule(875, false, true, 722, "875: _679 -> (ADD I16 _677 _678)", null, null, null, 0L, false, false, new int[]{720, 721}, null);
        CodeGenerator_x86simd.rulev[878] = new Rule(878, false, true, 725, "878: _682 -> (ADD I16 _119 _119)", null, null, null, 0L, false, false, new int[]{162, 162}, null);
        CodeGenerator_x86simd.rulev[879] = new Rule(879, false, true, 726, "879: _683 -> (ADD I16 _682 _678)", null, null, null, 0L, false, false, new int[]{725, 721}, null);
        CodeGenerator_x86simd.rulev[882] = new Rule(882, false, true, 729, "882: _686 -> (ADD I16 _121 _121)", null, null, null, 0L, false, false, new int[]{164, 164}, null);
        CodeGenerator_x86simd.rulev[883] = new Rule(883, false, true, 730, "883: _687 -> (ADD I16 _686 _678)", null, null, null, 0L, false, false, new int[]{729, 721}, null);
        CodeGenerator_x86simd.rulev[886] = new Rule(886, false, true, 733, "886: _690 -> (ADD I16 _123 _123)", null, null, null, 0L, false, false, new int[]{166, 166}, null);
        CodeGenerator_x86simd.rulev[887] = new Rule(887, false, true, 734, "887: _691 -> (ADD I16 _690 _678)", null, null, null, 0L, false, false, new int[]{733, 721}, null);
        CodeGenerator_x86simd.rulev[892] = new Rule(892, false, true, 738, "892: _695 -> (ADD I16 _694 _694)", null, null, null, 0L, false, false, new int[]{737, 737}, null);
        CodeGenerator_x86simd.rulev[895] = new Rule(895, false, true, 741, "895: _698 -> (ADD I16 _695 _697)", null, null, null, 0L, false, false, new int[]{738, 740}, null);
        CodeGenerator_x86simd.rulev[898] = new Rule(898, false, true, 744, "898: _701 -> (ADD I16 _700 _700)", null, null, null, 0L, false, false, new int[]{743, 743}, null);
        CodeGenerator_x86simd.rulev[901] = new Rule(901, false, true, 747, "901: _704 -> (ADD I16 _701 _703)", null, null, null, 0L, false, false, new int[]{744, 746}, null);
        CodeGenerator_x86simd.rulev[904] = new Rule(904, false, true, 750, "904: _707 -> (ADD I16 _706 _706)", null, null, null, 0L, false, false, new int[]{749, 749}, null);
        CodeGenerator_x86simd.rulev[907] = new Rule(907, false, true, 753, "907: _710 -> (ADD I16 _707 _709)", null, null, null, 0L, false, false, new int[]{750, 752}, null);
        CodeGenerator_x86simd.rulev[910] = new Rule(910, false, true, 756, "910: _713 -> (ADD I16 _712 _712)", null, null, null, 0L, false, false, new int[]{755, 755}, null);
        CodeGenerator_x86simd.rulev[913] = new Rule(913, false, true, 759, "913: _716 -> (ADD I16 _713 _715)", null, null, null, 0L, false, false, new int[]{756, 758}, null);
        CodeGenerator_x86simd.rulev[916] = new Rule(916, false, true, 761, "916: _718 -> (ADD I16 _49 _49)", null, null, null, 0L, false, false, new int[]{92, 92}, null);
        CodeGenerator_x86simd.rulev[917] = new Rule(917, false, true, 762, "917: _719 -> (ADD I16 _718 _678)", null, null, null, 0L, false, false, new int[]{761, 721}, null);
        CodeGenerator_x86simd.rulev[920] = new Rule(920, false, true, 765, "920: _722 -> (ADD I16 _51 _51)", null, null, null, 0L, false, false, new int[]{94, 94}, null);
        CodeGenerator_x86simd.rulev[921] = new Rule(921, false, true, 766, "921: _723 -> (ADD I16 _722 _678)", null, null, null, 0L, false, false, new int[]{765, 721}, null);
        CodeGenerator_x86simd.rulev[924] = new Rule(924, false, true, 769, "924: _726 -> (ADD I16 _53 _53)", null, null, null, 0L, false, false, new int[]{96, 96}, null);
        CodeGenerator_x86simd.rulev[925] = new Rule(925, false, true, 770, "925: _727 -> (ADD I16 _726 _678)", null, null, null, 0L, false, false, new int[]{769, 721}, null);
        CodeGenerator_x86simd.rulev[928] = new Rule(928, false, true, 773, "928: _730 -> (ADD I16 _55 _55)", null, null, null, 0L, false, false, new int[]{98, 98}, null);
        CodeGenerator_x86simd.rulev[929] = new Rule(929, false, true, 774, "929: _731 -> (ADD I16 _730 _678)", null, null, null, 0L, false, false, new int[]{773, 721}, null);
        CodeGenerator_x86simd.rulev[932] = new Rule(932, false, true, 777, "932: _734 -> (ADD I16 _57 _57)", null, null, null, 0L, false, false, new int[]{100, 100}, null);
        CodeGenerator_x86simd.rulev[933] = new Rule(933, false, true, 778, "933: _735 -> (ADD I16 _734 _678)", null, null, null, 0L, false, false, new int[]{777, 721}, null);
        CodeGenerator_x86simd.rulev[936] = new Rule(936, false, true, 781, "936: _738 -> (ADD I16 _59 _59)", null, null, null, 0L, false, false, new int[]{102, 102}, null);
        CodeGenerator_x86simd.rulev[937] = new Rule(937, false, true, 782, "937: _739 -> (ADD I16 _738 _678)", null, null, null, 0L, false, false, new int[]{781, 721}, null);
        CodeGenerator_x86simd.rulev[940] = new Rule(940, false, true, 785, "940: _742 -> (ADD I16 _61 _61)", null, null, null, 0L, false, false, new int[]{104, 104}, null);
        CodeGenerator_x86simd.rulev[941] = new Rule(941, false, true, 786, "941: _743 -> (ADD I16 _742 _678)", null, null, null, 0L, false, false, new int[]{785, 721}, null);
        CodeGenerator_x86simd.rulev[944] = new Rule(944, false, true, 789, "944: _746 -> (ADD I16 _63 _63)", null, null, null, 0L, false, false, new int[]{106, 106}, null);
        CodeGenerator_x86simd.rulev[945] = new Rule(945, false, true, 790, "945: _747 -> (ADD I16 _746 _678)", null, null, null, 0L, false, false, new int[]{789, 721}, null);
        CodeGenerator_x86simd.rulev[950] = new Rule(950, false, true, 794, "950: _751 -> (ADD I16 _750 _750)", null, null, null, 0L, false, false, new int[]{793, 793}, null);
        CodeGenerator_x86simd.rulev[953] = new Rule(953, false, true, 797, "953: _754 -> (ADD I16 _751 _753)", null, null, null, 0L, false, false, new int[]{794, 796}, null);
        CodeGenerator_x86simd.rulev[956] = new Rule(956, false, true, 800, "956: _757 -> (ADD I16 _756 _756)", null, null, null, 0L, false, false, new int[]{799, 799}, null);
        CodeGenerator_x86simd.rulev[959] = new Rule(959, false, true, 803, "959: _760 -> (ADD I16 _757 _759)", null, null, null, 0L, false, false, new int[]{800, 802}, null);
        CodeGenerator_x86simd.rulev[962] = new Rule(962, false, true, 806, "962: _763 -> (ADD I16 _762 _762)", null, null, null, 0L, false, false, new int[]{805, 805}, null);
        CodeGenerator_x86simd.rulev[965] = new Rule(965, false, true, 809, "965: _766 -> (ADD I16 _763 _765)", null, null, null, 0L, false, false, new int[]{806, 808}, null);
        CodeGenerator_x86simd.rulev[968] = new Rule(968, false, true, 812, "968: _769 -> (ADD I16 _768 _768)", null, null, null, 0L, false, false, new int[]{811, 811}, null);
        CodeGenerator_x86simd.rulev[971] = new Rule(971, false, true, 815, "971: _772 -> (ADD I16 _769 _771)", null, null, null, 0L, false, false, new int[]{812, 814}, null);
        CodeGenerator_x86simd.rulev[974] = new Rule(974, false, true, 818, "974: _775 -> (ADD I16 _774 _774)", null, null, null, 0L, false, false, new int[]{817, 817}, null);
        CodeGenerator_x86simd.rulev[977] = new Rule(977, false, true, 821, "977: _778 -> (ADD I16 _775 _777)", null, null, null, 0L, false, false, new int[]{818, 820}, null);
        CodeGenerator_x86simd.rulev[980] = new Rule(980, false, true, 824, "980: _781 -> (ADD I16 _780 _780)", null, null, null, 0L, false, false, new int[]{823, 823}, null);
    }

    private static void rrinit400() {
        CodeGenerator_x86simd.rulev[983] = new Rule(983, false, true, 827, "983: _784 -> (ADD I16 _781 _783)", null, null, null, 0L, false, false, new int[]{824, 826}, null);
        CodeGenerator_x86simd.rulev[986] = new Rule(986, false, true, 830, "986: _787 -> (ADD I16 _786 _786)", null, null, null, 0L, false, false, new int[]{829, 829}, null);
        CodeGenerator_x86simd.rulev[989] = new Rule(989, false, true, 833, "989: _790 -> (ADD I16 _787 _789)", null, null, null, 0L, false, false, new int[]{830, 832}, null);
        CodeGenerator_x86simd.rulev[992] = new Rule(992, false, true, 836, "992: _793 -> (ADD I16 _792 _792)", null, null, null, 0L, false, false, new int[]{835, 835}, null);
        CodeGenerator_x86simd.rulev[995] = new Rule(995, false, true, 839, "995: _796 -> (ADD I16 _793 _795)", null, null, null, 0L, false, false, new int[]{836, 838}, null);
        CodeGenerator_x86simd.rulev[4013] = new Rule(4013, false, false, 6, "4013: regw -> (ADD I16 regw mrcw)", ImList.list(ImList.list("addw", "$2", "$0")), null, null, 2L, false, false, new int[]{6, 42}, new String[]{"*reg-I16*", "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[4022] = new Rule(4022, false, false, 6, "4022: regw -> (ADD I16 mrcw regw)", ImList.list(ImList.list("addw", "$1", "$0")), null, null, 4L, false, false, new int[]{42, 6}, new String[]{"*reg-I16*", null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[34] = new Rule(34, false, false, 21, "34: asmcon -> (ADD I32 asmcon con)", null, ImList.list(ImList.list("+", "$1", "$2")), null, 0L, false, false, new int[]{21, 19}, new String[]{null, null, null});
        CodeGenerator_x86simd.rulev[39] = new Rule(39, false, false, 23, "39: base -> (ADD I32 regl asmcon)", null, ImList.list(ImList.list("base", "$2", "$1")), null, 0L, false, false, new int[]{4, 21}, new String[]{null, "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[40] = new Rule(40, false, false, 23, "40: base -> (ADD I32 asmcon regl)", null, ImList.list(ImList.list("base", "$1", "$2")), null, 0L, false, false, new int[]{21, 4}, new String[]{null, null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[56] = new Rule(56, false, false, 30, "56: addr -> (ADD I32 base index)", null, ImList.list(ImList.list("addr", "$1", "$2")), null, 0L, false, false, new int[]{23, 24}, new String[]{null, null, null});
        CodeGenerator_x86simd.rulev[57] = new Rule(57, false, false, 30, "57: addr -> (ADD I32 index base)", null, ImList.list(ImList.list("addr", "$2", "$1")), null, 0L, false, false, new int[]{24, 23}, new String[]{null, null, null});
        CodeGenerator_x86simd.rulev[3366] = new Rule(3366, false, true, 3124, "3366: _3081 -> (ADD I32 _125 _125)", null, null, null, 0L, false, false, new int[]{168, 168}, null);
        CodeGenerator_x86simd.rulev[3368] = new Rule(3368, false, true, 3126, "3368: _3083 -> (ADD I32 _127 _127)", null, null, null, 0L, false, false, new int[]{170, 170}, null);
        CodeGenerator_x86simd.rulev[3594] = new Rule(3594, false, true, 3336, "3594: _3293 -> (ADD I32 _65 _65)", null, null, null, 0L, false, false, new int[]{108, 108}, null);
        CodeGenerator_x86simd.rulev[3596] = new Rule(3596, false, true, 3338, "3596: _3295 -> (ADD I32 _67 _67)", null, null, null, 0L, false, false, new int[]{110, 110}, null);
        CodeGenerator_x86simd.rulev[3598] = new Rule(3598, false, true, 3340, "3598: _3297 -> (ADD I32 _69 _69)", null, null, null, 0L, false, false, new int[]{112, 112}, null);
        CodeGenerator_x86simd.rulev[3600] = new Rule(3600, false, true, 3342, "3600: _3299 -> (ADD I32 _71 _71)", null, null, null, 0L, false, false, new int[]{114, 114}, null);
        CodeGenerator_x86simd.rulev[4003] = new Rule(4003, false, false, 4, "4003: regl -> (ADD I32 regl mrcl)", ImList.list(ImList.list("addl", "$2", "$0")), null, null, 2L, false, false, new int[]{4, 40}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4018] = new Rule(4018, false, false, 4, "4018: regl -> (ADD I32 mrcl regl)", ImList.list(ImList.list("addl", "$1", "$0")), null, null, 4L, false, false, new int[]{40, 4}, new String[]{"*reg-I32*", null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[3876] = new Rule(3876, false, true, 3580, "3876: _3537 -> (ADD F32 _3460 _3460)", null, null, null, 0L, false, false, new int[]{3503, 3503}, null);
        CodeGenerator_x86simd.rulev[3878] = new Rule(3878, false, true, 3582, "3878: _3539 -> (ADD F32 _3462 _3462)", null, null, null, 0L, false, false, new int[]{3505, 3505}, null);
        CodeGenerator_x86simd.rulev[3880] = new Rule(3880, false, true, 3584, "3880: _3541 -> (ADD F32 _3464 _3464)", null, null, null, 0L, false, false, new int[]{3507, 3507}, null);
        CodeGenerator_x86simd.rulev[3882] = new Rule(3882, false, true, 3586, "3882: _3543 -> (ADD F32 _3466 _3466)", null, null, null, 0L, false, false, new int[]{3509, 3509}, null);
        CodeGenerator_x86simd.rulev[4099] = new Rule(4099, false, false, 8, "4099: regf -> (ADD F32 regf regmemf)", ImList.list(ImList.list("addss", "$2", "$1")), null, null, 2L, false, false, new int[]{8, 3646}, new String[]{"*reg-tmp-F32*", "*reg-tmp-F32*", null});
        CodeGenerator_x86simd.rulev[3974] = new Rule(3974, false, false, 3, "3974: regq -> (ADD I64 regq mrcq)", ImList.list(ImList.list("addl", ImList.list("qlow", "$2"), ImList.list("qlow", "$0")), ImList.list("adcl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{3, 47}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86simd.rulev[3912] = new Rule(3912, false, true, 3612, "3912: _3569 -> (ADD F64 _3468 _3468)", null, null, null, 0L, false, false, new int[]{3511, 3511}, null);
        CodeGenerator_x86simd.rulev[3914] = new Rule(3914, false, true, 3614, "3914: _3571 -> (ADD F64 _3470 _3470)", null, null, null, 0L, false, false, new int[]{3513, 3513}, null);
        CodeGenerator_x86simd.rulev[4094] = new Rule(4094, false, false, 9, "4094: regd -> (ADD F64 regd regmemd)", ImList.list(ImList.list("addsd", "$2", "$1")), null, null, 2L, false, false, new int[]{9, 3645}, new String[]{"*reg-tmp-F64*", "*reg-tmp-F64*", null});
        CodeGenerator_x86simd.rulev[459] = new Rule(459, false, true, 312, "459: _269 -> (SUB I8 _101 _101)", null, null, null, 0L, false, false, new int[]{144, 144}, null);
        CodeGenerator_x86simd.rulev[465] = new Rule(465, false, true, 318, "465: _275 -> (SUB I8 _103 _103)", null, null, null, 0L, false, false, new int[]{146, 146}, null);
        CodeGenerator_x86simd.rulev[472] = new Rule(472, false, true, 325, "472: _282 -> (SUB I8 _105 _105)", null, null, null, 0L, false, false, new int[]{148, 148}, null);
        CodeGenerator_x86simd.rulev[479] = new Rule(479, false, true, 332, "479: _289 -> (SUB I8 _107 _107)", null, null, null, 0L, false, false, new int[]{150, 150}, null);
        CodeGenerator_x86simd.rulev[486] = new Rule(486, false, true, 339, "486: _296 -> (SUB I8 _109 _109)", null, null, null, 0L, false, false, new int[]{152, 152}, null);
        CodeGenerator_x86simd.rulev[493] = new Rule(493, false, true, 346, "493: _303 -> (SUB I8 _111 _111)", null, null, null, 0L, false, false, new int[]{154, 154}, null);
        CodeGenerator_x86simd.rulev[500] = new Rule(500, false, true, 353, "500: _310 -> (SUB I8 _113 _113)", null, null, null, 0L, false, false, new int[]{156, 156}, null);
        CodeGenerator_x86simd.rulev[507] = new Rule(507, false, true, 360, "507: _317 -> (SUB I8 _115 _115)", null, null, null, 0L, false, false, new int[]{158, 158}, null);
        CodeGenerator_x86simd.rulev[515] = new Rule(515, false, true, 367, "515: _324 -> (SUB I8 _7 _7)", null, null, null, 0L, false, false, new int[]{50, 50}, null);
        CodeGenerator_x86simd.rulev[521] = new Rule(521, false, true, 373, "521: _330 -> (SUB I8 _9 _9)", null, null, null, 0L, false, false, new int[]{52, 52}, null);
        CodeGenerator_x86simd.rulev[528] = new Rule(528, false, true, 380, "528: _337 -> (SUB I8 _11 _11)", null, null, null, 0L, false, false, new int[]{54, 54}, null);
        CodeGenerator_x86simd.rulev[535] = new Rule(535, false, true, 387, "535: _344 -> (SUB I8 _13 _13)", null, null, null, 0L, false, false, new int[]{56, 56}, null);
        CodeGenerator_x86simd.rulev[542] = new Rule(542, false, true, 394, "542: _351 -> (SUB I8 _15 _15)", null, null, null, 0L, false, false, new int[]{58, 58}, null);
        CodeGenerator_x86simd.rulev[549] = new Rule(549, false, true, 401, "549: _358 -> (SUB I8 _18 _18)", null, null, null, 0L, false, false, new int[]{61, 61}, null);
        CodeGenerator_x86simd.rulev[556] = new Rule(556, false, true, 408, "556: _365 -> (SUB I8 _21 _21)", null, null, null, 0L, false, false, new int[]{64, 64}, null);
        CodeGenerator_x86simd.rulev[563] = new Rule(563, false, true, 415, "563: _372 -> (SUB I8 _24 _24)", null, null, null, 0L, false, false, new int[]{67, 67}, null);
        CodeGenerator_x86simd.rulev[571] = new Rule(571, false, true, 423, "571: _380 -> (SUB I8 _26 _26)", null, null, null, 0L, false, false, new int[]{69, 69}, null);
        CodeGenerator_x86simd.rulev[577] = new Rule(577, false, true, 429, "577: _386 -> (SUB I8 _29 _29)", null, null, null, 0L, false, false, new int[]{72, 72}, null);
        CodeGenerator_x86simd.rulev[584] = new Rule(584, false, true, 436, "584: _393 -> (SUB I8 _32 _32)", null, null, null, 0L, false, false, new int[]{75, 75}, null);
        CodeGenerator_x86simd.rulev[591] = new Rule(591, false, true, 443, "591: _400 -> (SUB I8 _35 _35)", null, null, null, 0L, false, false, new int[]{78, 78}, null);
        CodeGenerator_x86simd.rulev[598] = new Rule(598, false, true, 450, "598: _407 -> (SUB I8 _38 _38)", null, null, null, 0L, false, false, new int[]{81, 81}, null);
        CodeGenerator_x86simd.rulev[605] = new Rule(605, false, true, 457, "605: _414 -> (SUB I8 _41 _41)", null, null, null, 0L, false, false, new int[]{84, 84}, null);
        CodeGenerator_x86simd.rulev[612] = new Rule(612, false, true, 464, "612: _421 -> (SUB I8 _44 _44)", null, null, null, 0L, false, false, new int[]{87, 87}, null);
        CodeGenerator_x86simd.rulev[619] = new Rule(619, false, true, 471, "619: _428 -> (SUB I8 _47 _47)", null, null, null, 0L, false, false, new int[]{90, 90}, null);
        CodeGenerator_x86simd.rulev[4009] = new Rule(4009, false, false, 7, "4009: regb -> (SUB I8 regb mrcb)", ImList.list(ImList.list("subb", "$2", "$0")), null, null, 2L, false, false, new int[]{7, 44}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[3325] = new Rule(3325, false, true, 3088, "3325: _3045 -> (SUB I16 _117 _117)", null, null, null, 0L, false, false, new int[]{160, 160}, null);
        CodeGenerator_x86simd.rulev[3327] = new Rule(3327, false, true, 3090, "3327: _3047 -> (SUB I16 _119 _119)", null, null, null, 0L, false, false, new int[]{162, 162}, null);
        CodeGenerator_x86simd.rulev[3329] = new Rule(3329, false, true, 3092, "3329: _3049 -> (SUB I16 _121 _121)", null, null, null, 0L, false, false, new int[]{164, 164}, null);
        CodeGenerator_x86simd.rulev[3331] = new Rule(3331, false, true, 3094, "3331: _3051 -> (SUB I16 _123 _123)", null, null, null, 0L, false, false, new int[]{166, 166}, null);
        CodeGenerator_x86simd.rulev[3517] = new Rule(3517, false, true, 3264, "3517: _3221 -> (SUB I16 _49 _49)", null, null, null, 0L, false, false, new int[]{92, 92}, null);
        CodeGenerator_x86simd.rulev[3519] = new Rule(3519, false, true, 3266, "3519: _3223 -> (SUB I16 _51 _51)", null, null, null, 0L, false, false, new int[]{94, 94}, null);
        CodeGenerator_x86simd.rulev[3521] = new Rule(3521, false, true, 3268, "3521: _3225 -> (SUB I16 _53 _53)", null, null, null, 0L, false, false, new int[]{96, 96}, null);
        CodeGenerator_x86simd.rulev[3523] = new Rule(3523, false, true, 3270, "3523: _3227 -> (SUB I16 _55 _55)", null, null, null, 0L, false, false, new int[]{98, 98}, null);
        CodeGenerator_x86simd.rulev[3525] = new Rule(3525, false, true, 3272, "3525: _3229 -> (SUB I16 _57 _57)", null, null, null, 0L, false, false, new int[]{100, 100}, null);
        CodeGenerator_x86simd.rulev[3527] = new Rule(3527, false, true, 3274, "3527: _3231 -> (SUB I16 _59 _59)", null, null, null, 0L, false, false, new int[]{102, 102}, null);
        CodeGenerator_x86simd.rulev[3529] = new Rule(3529, false, true, 3276, "3529: _3233 -> (SUB I16 _61 _61)", null, null, null, 0L, false, false, new int[]{104, 104}, null);
        CodeGenerator_x86simd.rulev[3531] = new Rule(3531, false, true, 3278, "3531: _3235 -> (SUB I16 _63 _63)", null, null, null, 0L, false, false, new int[]{106, 106}, null);
        CodeGenerator_x86simd.rulev[4014] = new Rule(4014, false, false, 6, "4014: regw -> (SUB I16 regw mrcw)", ImList.list(ImList.list("subw", "$2", "$0")), null, null, 2L, false, false, new int[]{6, 42}, new String[]{"*reg-I16*", "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[35] = new Rule(35, false, false, 21, "35: asmcon -> (SUB I32 asmcon con)", null, ImList.list(ImList.list("-", "$1", "$2")), null, 0L, false, false, new int[]{21, 19}, new String[]{null, null, null});
        CodeGenerator_x86simd.rulev[41] = new Rule(41, false, false, 23, "41: base -> (SUB I32 regl con)", null, ImList.list(ImList.list("base", ImList.list("minus", "$2"), "$1")), null, 0L, false, false, new int[]{4, 19}, new String[]{null, "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[3371] = new Rule(3371, false, true, 3128, "3371: _3085 -> (SUB I32 _125 _125)", null, null, null, 0L, false, false, new int[]{168, 168}, null);
        CodeGenerator_x86simd.rulev[3373] = new Rule(3373, false, true, 3130, "3373: _3087 -> (SUB I32 _127 _127)", null, null, null, 0L, false, false, new int[]{170, 170}, null);
        CodeGenerator_x86simd.rulev[3603] = new Rule(3603, false, true, 3344, "3603: _3301 -> (SUB I32 _65 _65)", null, null, null, 0L, false, false, new int[]{108, 108}, null);
        CodeGenerator_x86simd.rulev[3605] = new Rule(3605, false, true, 3346, "3605: _3303 -> (SUB I32 _67 _67)", null, null, null, 0L, false, false, new int[]{110, 110}, null);
        CodeGenerator_x86simd.rulev[3607] = new Rule(3607, false, true, 3348, "3607: _3305 -> (SUB I32 _69 _69)", null, null, null, 0L, false, false, new int[]{112, 112}, null);
        CodeGenerator_x86simd.rulev[3609] = new Rule(3609, false, true, 3350, "3609: _3307 -> (SUB I32 _71 _71)", null, null, null, 0L, false, false, new int[]{114, 114}, null);
        CodeGenerator_x86simd.rulev[3952] = new Rule(3952, false, true, 3629, "3952: _3586 -> (SUB I32 _3585 regl)", null, null, null, 0L, false, false, new int[]{3628, 4}, null);
        CodeGenerator_x86simd.rulev[3954] = new Rule(3954, false, true, 3630, "3954: _3587 -> (SUB I32 _3585 _3)", null, null, null, 0L, false, false, new int[]{3628, 27}, null);
        CodeGenerator_x86simd.rulev[3959] = new Rule(3959, false, true, 3634, "3959: _3591 -> (SUB I32 _3585 _2)", null, null, null, 0L, false, false, new int[]{3628, 26}, null);
        CodeGenerator_x86simd.rulev[4004] = new Rule(4004, false, false, 4, "4004: regl -> (SUB I32 regl mrcl)", ImList.list(ImList.list("subl", "$2", "$0")), null, null, 2L, false, false, new int[]{4, 40}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[3885] = new Rule(3885, false, true, 3588, "3885: _3545 -> (SUB F32 _3460 _3460)", null, null, null, 0L, false, false, new int[]{3503, 3503}, null);
        CodeGenerator_x86simd.rulev[3887] = new Rule(3887, false, true, 3590, "3887: _3547 -> (SUB F32 _3462 _3462)", null, null, null, 0L, false, false, new int[]{3505, 3505}, null);
        CodeGenerator_x86simd.rulev[3889] = new Rule(3889, false, true, 3592, "3889: _3549 -> (SUB F32 _3464 _3464)", null, null, null, 0L, false, false, new int[]{3507, 3507}, null);
        CodeGenerator_x86simd.rulev[3891] = new Rule(3891, false, true, 3594, "3891: _3551 -> (SUB F32 _3466 _3466)", null, null, null, 0L, false, false, new int[]{3509, 3509}, null);
        CodeGenerator_x86simd.rulev[4100] = new Rule(4100, false, false, 8, "4100: regf -> (SUB F32 regf regmemf)", ImList.list(ImList.list("subss", "$2", "$1")), null, null, 2L, false, false, new int[]{8, 3646}, new String[]{"*reg-tmp-F32*", "*reg-tmp-F32*", null});
        CodeGenerator_x86simd.rulev[3975] = new Rule(3975, false, false, 3, "3975: regq -> (SUB I64 regq mrcq)", ImList.list(ImList.list("subl", ImList.list("qlow", "$2"), ImList.list("qlow", "$0")), ImList.list("sbbl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{3, 47}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86simd.rulev[3917] = new Rule(3917, false, true, 3616, "3917: _3573 -> (SUB F64 _3468 _3468)", null, null, null, 0L, false, false, new int[]{3511, 3511}, null);
        CodeGenerator_x86simd.rulev[3919] = new Rule(3919, false, true, 3618, "3919: _3575 -> (SUB F64 _3470 _3470)", null, null, null, 0L, false, false, new int[]{3513, 3513}, null);
        CodeGenerator_x86simd.rulev[4095] = new Rule(4095, false, false, 9, "4095: regd -> (SUB F64 regd regmemd)", ImList.list(ImList.list("subsd", "$2", "$1")), null, null, 2L, false, false, new int[]{9, 3645}, new String[]{"*reg-tmp-F64*", "*reg-tmp-F64*", null});
        CodeGenerator_x86simd.rulev[3334] = new Rule(3334, false, true, 3096, "3334: _3053 -> (MUL I16 _117 _117)", null, null, null, 0L, false, false, new int[]{160, 160}, null);
        CodeGenerator_x86simd.rulev[3336] = new Rule(3336, false, true, 3098, "3336: _3055 -> (MUL I16 _119 _119)", null, null, null, 0L, false, false, new int[]{162, 162}, null);
        CodeGenerator_x86simd.rulev[3338] = new Rule(3338, false, true, 3100, "3338: _3057 -> (MUL I16 _121 _121)", null, null, null, 0L, false, false, new int[]{164, 164}, null);
        CodeGenerator_x86simd.rulev[3340] = new Rule(3340, false, true, 3102, "3340: _3059 -> (MUL I16 _123 _123)", null, null, null, 0L, false, false, new int[]{166, 166}, null);
        CodeGenerator_x86simd.rulev[3534] = new Rule(3534, false, true, 3280, "3534: _3237 -> (MUL I16 _49 _49)", null, null, null, 0L, false, false, new int[]{92, 92}, null);
        CodeGenerator_x86simd.rulev[3536] = new Rule(3536, false, true, 3282, "3536: _3239 -> (MUL I16 _51 _51)", null, null, null, 0L, false, false, new int[]{94, 94}, null);
        CodeGenerator_x86simd.rulev[3538] = new Rule(3538, false, true, 3284, "3538: _3241 -> (MUL I16 _53 _53)", null, null, null, 0L, false, false, new int[]{96, 96}, null);
        CodeGenerator_x86simd.rulev[3540] = new Rule(3540, false, true, 3286, "3540: _3243 -> (MUL I16 _55 _55)", null, null, null, 0L, false, false, new int[]{98, 98}, null);
        CodeGenerator_x86simd.rulev[3542] = new Rule(3542, false, true, 3288, "3542: _3245 -> (MUL I16 _57 _57)", null, null, null, 0L, false, false, new int[]{100, 100}, null);
        CodeGenerator_x86simd.rulev[3544] = new Rule(3544, false, true, 3290, "3544: _3247 -> (MUL I16 _59 _59)", null, null, null, 0L, false, false, new int[]{102, 102}, null);
        CodeGenerator_x86simd.rulev[3546] = new Rule(3546, false, true, 3292, "3546: _3249 -> (MUL I16 _61 _61)", null, null, null, 0L, false, false, new int[]{104, 104}, null);
        CodeGenerator_x86simd.rulev[3548] = new Rule(3548, false, true, 3294, "3548: _3251 -> (MUL I16 _63 _63)", null, null, null, 0L, false, false, new int[]{106, 106}, null);
    }

    private static void rrinit500() {
        CodeGenerator_x86simd.rulev[44] = new Rule(44, false, false, 24, "44: index -> (MUL I32 regl _1)", null, ImList.list(ImList.list("index", "$1", "2")), null, 0L, false, false, new int[]{4, 25}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[46] = new Rule(46, false, false, 24, "46: index -> (MUL I32 regl _2)", null, ImList.list(ImList.list("index", "$1", "4")), null, 0L, false, false, new int[]{4, 26}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[48] = new Rule(48, false, false, 24, "48: index -> (MUL I32 regl _3)", null, ImList.list(ImList.list("index", "$1", "8")), null, 0L, false, false, new int[]{4, 27}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[4054] = new Rule(4054, false, false, 4, "4054: regl -> (MUL I32 regl mrcl)", ImList.list(ImList.list("imull", "$2", "$0")), null, null, 2L, false, false, new int[]{4, 40}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4055] = new Rule(4055, false, false, 4, "4055: regl -> (MUL I32 mrcl regl)", ImList.list(ImList.list("imull", "$1", "$0")), null, null, 4L, false, false, new int[]{40, 4}, new String[]{"*reg-I32*", null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[3894] = new Rule(3894, false, true, 3596, "3894: _3553 -> (MUL F32 _3460 _3460)", null, null, null, 0L, false, false, new int[]{3503, 3503}, null);
        CodeGenerator_x86simd.rulev[3896] = new Rule(3896, false, true, 3598, "3896: _3555 -> (MUL F32 _3462 _3462)", null, null, null, 0L, false, false, new int[]{3505, 3505}, null);
        CodeGenerator_x86simd.rulev[3898] = new Rule(3898, false, true, 3600, "3898: _3557 -> (MUL F32 _3464 _3464)", null, null, null, 0L, false, false, new int[]{3507, 3507}, null);
        CodeGenerator_x86simd.rulev[3900] = new Rule(3900, false, true, 3602, "3900: _3559 -> (MUL F32 _3466 _3466)", null, null, null, 0L, false, false, new int[]{3509, 3509}, null);
        CodeGenerator_x86simd.rulev[4101] = new Rule(4101, false, false, 8, "4101: regf -> (MUL F32 regf regmemf)", ImList.list(ImList.list("mulss", "$2", "$1")), null, null, 2L, false, false, new int[]{8, 3646}, new String[]{"*reg-tmp-F32*", "*reg-tmp-F32*", null});
        CodeGenerator_x86simd.rulev[3998] = new Rule(3998, false, false, 3, "3998: regq -> (MUL I64 regq regq)", new ImList(ImList.list("movl", ImList.list("qhigh", "$2"), "%ebx"), ImList.list(ImList.list("imull", "%eax", "%ebx"), ImList.list("imull", ImList.list("qlow", "$2"), "%edx"), ImList.list("addl", "%edx", "%ebx"), ImList.list("mull", ImList.list("qlow", "$2")), ImList.list("addl", "%ebx", "%edx"))), null, ImList.list(ImList.list("REG", "I32", "%ebx")), 0L, false, false, new int[]{3, 3}, new String[]{"*reg-edxeax-I64*", "*reg-edxeax-I64*", "*reg-I64*"});
        CodeGenerator_x86simd.rulev[3922] = new Rule(3922, false, true, 3620, "3922: _3577 -> (MUL F64 _3468 _3468)", null, null, null, 0L, false, false, new int[]{3511, 3511}, null);
        CodeGenerator_x86simd.rulev[3924] = new Rule(3924, false, true, 3622, "3924: _3579 -> (MUL F64 _3470 _3470)", null, null, null, 0L, false, false, new int[]{3513, 3513}, null);
        CodeGenerator_x86simd.rulev[4096] = new Rule(4096, false, false, 9, "4096: regd -> (MUL F64 regd regmemd)", ImList.list(ImList.list("mulsd", "$2", "$1")), null, null, 2L, false, false, new int[]{9, 3645}, new String[]{"*reg-tmp-F64*", "*reg-tmp-F64*", null});
        CodeGenerator_x86simd.rulev[4056] = new Rule(4056, false, false, 4, "4056: regl -> (DIVS I32 regl regl)", ImList.list(ImList.list("cdq"), ImList.list("idivl", "$2")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 2L, false, false, new int[]{4, 4}, new String[]{"*reg-eax-I32*", "*reg-I32*", "*reg-mod$2-I32*"});
        CodeGenerator_x86simd.rulev[3867] = new Rule(3867, false, true, 3572, "3867: _3529 -> (DIVS F32 _3528 _3460)", null, null, null, 0L, false, false, new int[]{3571, 3503}, null);
        CodeGenerator_x86simd.rulev[3869] = new Rule(3869, false, true, 3574, "3869: _3531 -> (DIVS F32 _3528 _3462)", null, null, null, 0L, false, false, new int[]{3571, 3505}, null);
        CodeGenerator_x86simd.rulev[3871] = new Rule(3871, false, true, 3576, "3871: _3533 -> (DIVS F32 _3528 _3464)", null, null, null, 0L, false, false, new int[]{3571, 3507}, null);
        CodeGenerator_x86simd.rulev[3873] = new Rule(3873, false, true, 3578, "3873: _3535 -> (DIVS F32 _3528 _3466)", null, null, null, 0L, false, false, new int[]{3571, 3509}, null);
        CodeGenerator_x86simd.rulev[3903] = new Rule(3903, false, true, 3604, "3903: _3561 -> (DIVS F32 _3460 _3460)", null, null, null, 0L, false, false, new int[]{3503, 3503}, null);
        CodeGenerator_x86simd.rulev[3905] = new Rule(3905, false, true, 3606, "3905: _3563 -> (DIVS F32 _3462 _3462)", null, null, null, 0L, false, false, new int[]{3505, 3505}, null);
        CodeGenerator_x86simd.rulev[3907] = new Rule(3907, false, true, 3608, "3907: _3565 -> (DIVS F32 _3464 _3464)", null, null, null, 0L, false, false, new int[]{3507, 3507}, null);
        CodeGenerator_x86simd.rulev[3909] = new Rule(3909, false, true, 3610, "3909: _3567 -> (DIVS F32 _3466 _3466)", null, null, null, 0L, false, false, new int[]{3509, 3509}, null);
        CodeGenerator_x86simd.rulev[4102] = new Rule(4102, false, false, 8, "4102: regf -> (DIVS F32 regf regmemf)", ImList.list(ImList.list("divss", "$2", "$1")), null, null, 2L, false, false, new int[]{8, 3646}, new String[]{"*reg-tmp-F32*", "*reg-tmp-F32*", null});
        CodeGenerator_x86simd.rulev[3999] = new Rule(3999, false, false, 3, "3999: regq -> (DIVS I64 mrcq mrcq)", new ImList(ImList.list("pushl", ImList.list("qhigh", "$2")), ImList.list(ImList.list("pushl", ImList.list("qlow", "$2")), ImList.list("pushl", ImList.list("qhigh", "$1")), ImList.list("pushl", ImList.list("qlow", "$1")), ImList.list("call", ImList.list("symbol", "__divdi3")), ImList.list("addl", ImList.list("imm", "16"), "%esp"))), null, null, 0L, false, false, new int[]{47, 47}, new String[]{"*reg-edxeax-I64*", null, null});
        CodeGenerator_x86simd.rulev[3927] = new Rule(3927, false, true, 3624, "3927: _3581 -> (DIVS F64 _3468 _3468)", null, null, null, 0L, false, false, new int[]{3511, 3511}, null);
        CodeGenerator_x86simd.rulev[3929] = new Rule(3929, false, true, 3626, "3929: _3583 -> (DIVS F64 _3470 _3470)", null, null, null, 0L, false, false, new int[]{3513, 3513}, null);
        CodeGenerator_x86simd.rulev[4097] = new Rule(4097, false, false, 9, "4097: regd -> (DIVS F64 regd regmemd)", ImList.list(ImList.list("divsd", "$2", "$1")), null, null, 2L, false, false, new int[]{9, 3645}, new String[]{"*reg-tmp-F64*", "*reg-tmp-F64*", null});
        CodeGenerator_x86simd.rulev[4057] = new Rule(4057, false, false, 4, "4057: regl -> (DIVU I32 regl regl)", ImList.list(ImList.list("xorl", "%edx", "%edx"), ImList.list("divl", "$2")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 2L, false, false, new int[]{4, 4}, new String[]{"*reg-eax-I32*", "*reg-I32*", "*reg-mod$2-I32*"});
        CodeGenerator_x86simd.rulev[4000] = new Rule(4000, false, false, 3, "4000: regq -> (DIVU I64 mrcq mrcq)", new ImList(ImList.list("pushl", ImList.list("qhigh", "$2")), ImList.list(ImList.list("pushl", ImList.list("qlow", "$2")), ImList.list("pushl", ImList.list("qhigh", "$1")), ImList.list("pushl", ImList.list("qlow", "$1")), ImList.list("call", ImList.list("symbol", "__udivdi3")), ImList.list("addl", ImList.list("imm", "16"), "%esp"))), null, null, 0L, false, false, new int[]{47, 47}, new String[]{"*reg-edxeax-I64*", null, null});
        CodeGenerator_x86simd.rulev[4058] = new Rule(4058, false, false, 4, "4058: regl -> (MODS I32 regl regl)", ImList.list(ImList.list("cdq"), ImList.list("idivl", "$2")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{4, 4}, new String[]{"*reg-edx-I32*", "*reg-eax-I32*", "*reg-mod$2-I32*"});
        CodeGenerator_x86simd.rulev[4001] = new Rule(4001, false, false, 3, "4001: regq -> (MODS I64 mrcq mrcq)", new ImList(ImList.list("pushl", ImList.list("qhigh", "$2")), ImList.list(ImList.list("pushl", ImList.list("qlow", "$2")), ImList.list("pushl", ImList.list("qhigh", "$1")), ImList.list("pushl", ImList.list("qlow", "$1")), ImList.list("call", ImList.list("symbol", "__moddi3")), ImList.list("addl", ImList.list("imm", "16"), "%esp"))), null, null, 0L, false, false, new int[]{47, 47}, new String[]{"*reg-edxeax-I64*", null, null});
        CodeGenerator_x86simd.rulev[4059] = new Rule(4059, false, false, 4, "4059: regl -> (MODU I32 regl regl)", ImList.list(ImList.list("xorl", "%edx", "%edx"), ImList.list("divl", "$2")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{4, 4}, new String[]{"*reg-edx-I32*", "*reg-eax-I32*", "*reg-mod$2-I32*"});
        CodeGenerator_x86simd.rulev[4002] = new Rule(4002, false, false, 3, "4002: regq -> (MODU I64 mrcq mrcq)", new ImList(ImList.list("pushl", ImList.list("qhigh", "$2")), ImList.list(ImList.list("pushl", ImList.list("qlow", "$2")), ImList.list("pushl", ImList.list("qhigh", "$1")), ImList.list("pushl", ImList.list("qlow", "$1")), ImList.list("call", ImList.list("symbol", "__umoddi3")), ImList.list("addl", ImList.list("imm", "16"), "%esp"))), null, null, 0L, false, false, new int[]{47, 47}, new String[]{"*reg-edxeax-I64*", null, null});
        CodeGenerator_x86simd.rulev[4110] = new Rule(4110, false, false, 6, "4110: regw -> (CONVSX I16 mregb)", ImList.list(ImList.list("movsbw", "$1", "$0")), null, null, 0L, false, false, new int[]{45}, new String[]{"*reg-I16*", null});
        CodeGenerator_x86simd.rulev[4108] = new Rule(4108, false, false, 4, "4108: regl -> (CONVSX I32 mregw)", ImList.list(ImList.list("movswl", "$1", "$0")), null, null, 0L, false, false, new int[]{43}, new String[]{"*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4109] = new Rule(4109, false, false, 4, "4109: regl -> (CONVSX I32 mregb)", ImList.list(ImList.list("movsbl", "$1", "$0")), null, null, 0L, false, false, new int[]{45}, new String[]{"*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4183] = new Rule(4183, false, true, 3671, "4183: _3625 -> (CONVSX I32 regw)", null, null, null, 0L, false, false, new int[]{6}, null);
        CodeGenerator_x86simd.rulev[4184] = new Rule(4184, false, true, 3672, "4184: _3626 -> (CONVSX I32 mrcw)", null, null, null, 0L, false, false, new int[]{42}, null);
        CodeGenerator_x86simd.rulev[4205] = new Rule(4205, false, true, 3683, "4205: _3637 -> (CONVSX I32 regb)", null, null, null, 0L, false, false, new int[]{7}, null);
        CodeGenerator_x86simd.rulev[4206] = new Rule(4206, false, true, 3684, "4206: _3638 -> (CONVSX I32 mrcb)", null, null, null, 0L, false, false, new int[]{44}, null);
        CodeGenerator_x86simd.rulev[4105] = new Rule(4105, false, false, 3, "4105: regq -> (CONVSX I64 regl)", ImList.list(ImList.list("cdq")), null, null, 0L, false, false, new int[]{4}, new String[]{"*reg-edxeax-I64*", "*reg-eax-I32*"});
        CodeGenerator_x86simd.rulev[4106] = new Rule(4106, false, false, 3, "4106: regq -> (CONVSX I64 regw)", ImList.list(ImList.list("cwde"), ImList.list("cdq")), null, null, 0L, false, false, new int[]{6}, new String[]{"*reg-edxeax-I64*", "*reg-ax-I16*"});
        CodeGenerator_x86simd.rulev[4107] = new Rule(4107, false, false, 3, "4107: regq -> (CONVSX I64 regb)", ImList.list(ImList.list("movsbl", "%al", "%eax"), ImList.list("cdq")), null, null, 0L, false, false, new int[]{7}, new String[]{"*reg-edxeax-I64*", "*reg-al-I8*"});
        CodeGenerator_x86simd.rulev[4117] = new Rule(4117, false, false, 6, "4117: regw -> (CONVZX I16 mregb)", ImList.list(ImList.list("movzbw", "$1", "$0")), null, null, 0L, false, false, new int[]{45}, new String[]{"*reg-I16*", null});
        CodeGenerator_x86simd.rulev[4115] = new Rule(4115, false, false, 4, "4115: regl -> (CONVZX I32 mregw)", ImList.list(ImList.list("movzwl", "$1", "$0")), null, null, 0L, false, false, new int[]{43}, new String[]{"*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4116] = new Rule(4116, false, false, 4, "4116: regl -> (CONVZX I32 mregb)", ImList.list(ImList.list("movzbl", "$1", "$0")), null, null, 0L, false, false, new int[]{45}, new String[]{"*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4111] = new Rule(4111, false, false, 3, "4111: regq -> (CONVZX I64 mregl)", ImList.list(ImList.list("movl", "$1", ImList.list("qlow", "$0")), ImList.list("xorl", ImList.list("qhigh", "$0"), ImList.list("qhigh", "$0"))), null, null, 0L, false, false, new int[]{41}, new String[]{"*reg-I64*", null});
        CodeGenerator_x86simd.rulev[4112] = new Rule(4112, false, false, 3, "4112: regq -> (CONVZX I64 mregw)", ImList.list(ImList.list("movzwl", "$1", ImList.list("qlow", "$0")), ImList.list("xorl", ImList.list("qhigh", "$0"), ImList.list("qhigh", "$0"))), null, null, 0L, false, false, new int[]{43}, new String[]{"*reg-I64*", null});
        CodeGenerator_x86simd.rulev[4113] = new Rule(4113, false, false, 3, "4113: regq -> (CONVZX I64 mregb)", ImList.list(ImList.list("movzwl", "$1", ImList.list("qlow", "$0")), ImList.list("xorl", ImList.list("qhigh", "$0"), ImList.list("qhigh", "$0"))), null, null, 0L, false, false, new int[]{45}, new String[]{"*reg-I64*", null});
        CodeGenerator_x86simd.rulev[4114] = new Rule(4114, false, false, 3, "4114: regq -> (CONVZX I64 mregb)", ImList.list(ImList.list("movl", "$1", ImList.list("qlow", "$0")), ImList.list("xorl", ImList.list("qhigh", "$0"), ImList.list("qhigh", "$0"))), null, null, 0L, false, false, new int[]{45}, new String[]{"*reg-I64*", null});
        CodeGenerator_x86simd.rulev[4120] = new Rule(4120, false, false, 7, "4120: regb -> (CONVIT I8 regq)", ImList.list(ImList.list("movb", ImList.list("regblow", ImList.list("qlow", "$1")), "$0")), null, null, 0L, false, false, new int[]{3}, new String[]{"*reg-I8*", "*reg-bytable-I64*"});
        CodeGenerator_x86simd.rulev[4122] = new Rule(4122, false, false, 7, "4122: regb -> (CONVIT I8 regl)", ImList.list(ImList.list("movb", ImList.list("regblow", "$1"), "$0")), null, null, 0L, false, false, new int[]{4}, new String[]{"*reg-I8*", "*reg-bytable-I32*"});
        CodeGenerator_x86simd.rulev[4123] = new Rule(4123, false, false, 7, "4123: regb -> (CONVIT I8 regw)", ImList.list(ImList.list("movb", ImList.list("regblow", "$1"), "$0")), null, null, 0L, false, false, new int[]{6}, new String[]{"*reg-I8*", "*reg-bytable-I16*"});
        CodeGenerator_x86simd.rulev[4119] = new Rule(4119, false, false, 6, "4119: regw -> (CONVIT I16 regq)", ImList.list(ImList.list("movw", ImList.list("regwlow", ImList.list("qlow", "$1")), "$0")), null, null, 0L, false, false, new int[]{3}, new String[]{"*reg-I16*", "*reg-I64*"});
        CodeGenerator_x86simd.rulev[4121] = new Rule(4121, false, false, 6, "4121: regw -> (CONVIT I16 regl)", ImList.list(ImList.list("movw", ImList.list("regwlow", "$1"), "$0")), null, null, 0L, false, false, new int[]{4}, new String[]{"*reg-I16*", "*reg-I32*"});
        CodeGenerator_x86simd.rulev[4118] = new Rule(4118, false, false, 4, "4118: regl -> (CONVIT I32 regq)", ImList.list(ImList.list("movl", ImList.list("qlow", "$1"), "$0")), null, null, 0L, false, false, new int[]{3}, new String[]{"*reg-I32*", "*reg-I64*"});
        CodeGenerator_x86simd.rulev[3861] = new Rule(3861, false, true, 3567, "3861: _3524 -> (CONVFX F64 _3460)", null, null, null, 0L, false, false, new int[]{3503}, null);
        CodeGenerator_x86simd.rulev[3863] = new Rule(3863, false, true, 3569, "3863: _3526 -> (CONVFX F64 _3462)", null, null, null, 0L, false, false, new int[]{3505}, null);
        CodeGenerator_x86simd.rulev[4126] = new Rule(4126, false, false, 9, "4126: regd -> (CONVFX F64 regmemf)", ImList.list(ImList.list("cvtss2sd", "$1", "$0")), null, null, 0L, false, false, new int[]{3646}, new String[]{"*reg-tmp-F64*", null});
        CodeGenerator_x86simd.rulev[3856] = new Rule(3856, false, true, 3563, "3856: _3520 -> (CONVFT F32 _3468)", null, null, null, 0L, false, false, new int[]{3511}, null);
        CodeGenerator_x86simd.rulev[3858] = new Rule(3858, false, true, 3565, "3858: _3522 -> (CONVFT F32 _3470)", null, null, null, 0L, false, false, new int[]{3513}, null);
        CodeGenerator_x86simd.rulev[4127] = new Rule(4127, false, false, 8, "4127: regf -> (CONVFT F32 regmemd)", ImList.list(ImList.list("cvtsd2ss", "$1", "$0")), null, null, 0L, false, false, new int[]{3645}, new String[]{"*reg-tmp-F32*", null});
        CodeGenerator_x86simd.rulev[4130] = new Rule(4130, false, false, 7, "4130: regb -> (CONVFI I8 regmemd)", ImList.list(ImList.list("cvtsd2si", "$1", "%eax"), ImList.list("movb", "%al", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{3645}, new String[]{"*reg-I8*", null});
        CodeGenerator_x86simd.rulev[4137] = new Rule(4137, false, false, 7, "4137: regb -> (CONVFI I8 regmemf)", ImList.list(ImList.list("cvtss2si", "$1", "%eax"), ImList.list("movb", "%al", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{3646}, new String[]{"*reg-I8*", null});
        CodeGenerator_x86simd.rulev[4129] = new Rule(4129, false, false, 6, "4129: regw -> (CONVFI I16 regmemd)", ImList.list(ImList.list("cvtsd2si", "$1", "%eax"), ImList.list("movw", "%ax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{3645}, new String[]{"*reg-I16*", null});
        CodeGenerator_x86simd.rulev[4133] = new Rule(4133, false, true, 3648, "4133: _3602 -> (CONVFI I16 regd)", null, null, null, 0L, false, false, new int[]{9}, null);
        CodeGenerator_x86simd.rulev[4136] = new Rule(4136, false, false, 6, "4136: regw -> (CONVFI I16 regmemf)", ImList.list(ImList.list("cvtss2si", "$1", "%eax"), ImList.list("movw", "%ax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{3646}, new String[]{"*reg-I16*", null});
        CodeGenerator_x86simd.rulev[4140] = new Rule(4140, false, true, 3650, "4140: _3604 -> (CONVFI I16 regf)", null, null, null, 0L, false, false, new int[]{8}, null);
        CodeGenerator_x86simd.rulev[3812] = new Rule(3812, false, true, 3527, "3812: _3484 -> (CONVFI I32 _3460)", null, null, null, 0L, false, false, new int[]{3503}, null);
        CodeGenerator_x86simd.rulev[3814] = new Rule(3814, false, true, 3529, "3814: _3486 -> (CONVFI I32 _3462)", null, null, null, 0L, false, false, new int[]{3505}, null);
        CodeGenerator_x86simd.rulev[3817] = new Rule(3817, false, true, 3531, "3817: _3488 -> (CONVFI I32 _3468)", null, null, null, 0L, false, false, new int[]{3511}, null);
        CodeGenerator_x86simd.rulev[3819] = new Rule(3819, false, true, 3533, "3819: _3490 -> (CONVFI I32 _3470)", null, null, null, 0L, false, false, new int[]{3513}, null);
        CodeGenerator_x86simd.rulev[3824] = new Rule(3824, false, true, 3537, "3824: _3494 -> (CONVFI I32 _3464)", null, null, null, 0L, false, false, new int[]{3507}, null);
        CodeGenerator_x86simd.rulev[3826] = new Rule(3826, false, true, 3539, "3826: _3496 -> (CONVFI I32 _3466)", null, null, null, 0L, false, false, new int[]{3509}, null);
        CodeGenerator_x86simd.rulev[4128] = new Rule(4128, false, false, 4, "4128: regl -> (CONVFI I32 regmemd)", ImList.list(ImList.list("cvtsd2si", "$1", "$0")), null, null, 0L, false, false, new int[]{3645}, new String[]{"*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4131] = new Rule(4131, false, true, 3647, "4131: _3601 -> (CONVFI I32 regd)", null, null, null, 0L, false, false, new int[]{9}, null);
        CodeGenerator_x86simd.rulev[4135] = new Rule(4135, false, false, 4, "4135: regl -> (CONVFI I32 regmemf)", ImList.list(ImList.list("cvtss2si", "$1", "$0")), null, null, 0L, false, false, new int[]{3646}, new String[]{"*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4138] = new Rule(4138, false, true, 3649, "4138: _3603 -> (CONVFI I32 regf)", null, null, null, 0L, false, false, new int[]{8}, null);
        CodeGenerator_x86simd.rulev[3832] = new Rule(3832, false, true, 3543, "3832: _3500 -> (CONVSF F32 _125)", null, null, null, 0L, false, false, new int[]{168}, null);
        CodeGenerator_x86simd.rulev[3834] = new Rule(3834, false, true, 3545, "3834: _3502 -> (CONVSF F32 _127)", null, null, null, 0L, false, false, new int[]{170}, null);
        CodeGenerator_x86simd.rulev[3842] = new Rule(3842, false, true, 3551, "3842: _3508 -> (CONVSF F32 _65)", null, null, null, 0L, false, false, new int[]{108}, null);
        CodeGenerator_x86simd.rulev[3844] = new Rule(3844, false, true, 3553, "3844: _3510 -> (CONVSF F32 _67)", null, null, null, 0L, false, false, new int[]{110}, null);
        CodeGenerator_x86simd.rulev[3846] = new Rule(3846, false, true, 3555, "3846: _3512 -> (CONVSF F32 _69)", null, null, null, 0L, false, false, new int[]{112}, null);
        CodeGenerator_x86simd.rulev[3848] = new Rule(3848, false, true, 3557, "3848: _3514 -> (CONVSF F32 _71)", null, null, null, 0L, false, false, new int[]{114}, null);
        CodeGenerator_x86simd.rulev[4125] = new Rule(4125, false, false, 8, "4125: regf -> (CONVSF F32 mregl)", ImList.list(ImList.list("cvtsi2ss", "$1", "$0")), null, null, 0L, false, false, new int[]{41}, new String[]{"*reg-tmp-F32*", null});
        CodeGenerator_x86simd.rulev[3837] = new Rule(3837, false, true, 3547, "3837: _3504 -> (CONVSF F64 _125)", null, null, null, 0L, false, false, new int[]{168}, null);
        CodeGenerator_x86simd.rulev[3839] = new Rule(3839, false, true, 3549, "3839: _3506 -> (CONVSF F64 _127)", null, null, null, 0L, false, false, new int[]{170}, null);
        CodeGenerator_x86simd.rulev[3851] = new Rule(3851, false, true, 3559, "3851: _3516 -> (CONVSF F64 _65)", null, null, null, 0L, false, false, new int[]{108}, null);
        CodeGenerator_x86simd.rulev[3853] = new Rule(3853, false, true, 3561, "3853: _3518 -> (CONVSF F64 _67)", null, null, null, 0L, false, false, new int[]{110}, null);
        CodeGenerator_x86simd.rulev[4124] = new Rule(4124, false, false, 9, "4124: regd -> (CONVSF F64 mregl)", ImList.list(ImList.list("cvtsi2sd", "$1", "$0")), null, null, 0L, false, false, new int[]{41}, new String[]{"*reg-tmp-F64*", null});
        CodeGenerator_x86simd.rulev[461] = new Rule(461, false, true, 314, "461: _271 -> (BAND I8 _269 _270)", null, null, null, 0L, false, false, new int[]{312, 313}, null);
        CodeGenerator_x86simd.rulev[463] = new Rule(463, false, true, 316, "463: _273 -> (BAND I8 _269 _272)", null, null, null, 0L, false, false, new int[]{312, 315}, null);
        CodeGenerator_x86simd.rulev[467] = new Rule(467, false, true, 320, "467: _277 -> (BAND I8 _275 _276)", null, null, null, 0L, false, false, new int[]{318, 319}, null);
        CodeGenerator_x86simd.rulev[469] = new Rule(469, false, true, 322, "469: _279 -> (BAND I8 _275 _278)", null, null, null, 0L, false, false, new int[]{318, 321}, null);
        CodeGenerator_x86simd.rulev[474] = new Rule(474, false, true, 327, "474: _284 -> (BAND I8 _282 _283)", null, null, null, 0L, false, false, new int[]{325, 326}, null);
        CodeGenerator_x86simd.rulev[476] = new Rule(476, false, true, 329, "476: _286 -> (BAND I8 _282 _285)", null, null, null, 0L, false, false, new int[]{325, 328}, null);
        CodeGenerator_x86simd.rulev[481] = new Rule(481, false, true, 334, "481: _291 -> (BAND I8 _289 _290)", null, null, null, 0L, false, false, new int[]{332, 333}, null);
        CodeGenerator_x86simd.rulev[483] = new Rule(483, false, true, 336, "483: _293 -> (BAND I8 _289 _292)", null, null, null, 0L, false, false, new int[]{332, 335}, null);
        CodeGenerator_x86simd.rulev[488] = new Rule(488, false, true, 341, "488: _298 -> (BAND I8 _296 _297)", null, null, null, 0L, false, false, new int[]{339, 340}, null);
    }

    private static void rrinit600() {
        CodeGenerator_x86simd.rulev[490] = new Rule(490, false, true, 343, "490: _300 -> (BAND I8 _296 _299)", null, null, null, 0L, false, false, new int[]{339, 342}, null);
        CodeGenerator_x86simd.rulev[495] = new Rule(495, false, true, 348, "495: _305 -> (BAND I8 _303 _304)", null, null, null, 0L, false, false, new int[]{346, 347}, null);
        CodeGenerator_x86simd.rulev[497] = new Rule(497, false, true, 350, "497: _307 -> (BAND I8 _303 _306)", null, null, null, 0L, false, false, new int[]{346, 349}, null);
        CodeGenerator_x86simd.rulev[502] = new Rule(502, false, true, 355, "502: _312 -> (BAND I8 _310 _311)", null, null, null, 0L, false, false, new int[]{353, 354}, null);
        CodeGenerator_x86simd.rulev[504] = new Rule(504, false, true, 357, "504: _314 -> (BAND I8 _310 _313)", null, null, null, 0L, false, false, new int[]{353, 356}, null);
        CodeGenerator_x86simd.rulev[509] = new Rule(509, false, true, 362, "509: _319 -> (BAND I8 _317 _318)", null, null, null, 0L, false, false, new int[]{360, 361}, null);
        CodeGenerator_x86simd.rulev[511] = new Rule(511, false, true, 364, "511: _321 -> (BAND I8 _317 _320)", null, null, null, 0L, false, false, new int[]{360, 363}, null);
        CodeGenerator_x86simd.rulev[517] = new Rule(517, false, true, 369, "517: _326 -> (BAND I8 _324 _325)", null, null, null, 0L, false, false, new int[]{367, 368}, null);
        CodeGenerator_x86simd.rulev[519] = new Rule(519, false, true, 371, "519: _328 -> (BAND I8 _324 _327)", null, null, null, 0L, false, false, new int[]{367, 370}, null);
        CodeGenerator_x86simd.rulev[523] = new Rule(523, false, true, 375, "523: _332 -> (BAND I8 _330 _331)", null, null, null, 0L, false, false, new int[]{373, 374}, null);
        CodeGenerator_x86simd.rulev[525] = new Rule(525, false, true, 377, "525: _334 -> (BAND I8 _330 _333)", null, null, null, 0L, false, false, new int[]{373, 376}, null);
        CodeGenerator_x86simd.rulev[530] = new Rule(530, false, true, 382, "530: _339 -> (BAND I8 _337 _338)", null, null, null, 0L, false, false, new int[]{380, 381}, null);
        CodeGenerator_x86simd.rulev[532] = new Rule(532, false, true, 384, "532: _341 -> (BAND I8 _337 _340)", null, null, null, 0L, false, false, new int[]{380, 383}, null);
        CodeGenerator_x86simd.rulev[537] = new Rule(537, false, true, 389, "537: _346 -> (BAND I8 _344 _345)", null, null, null, 0L, false, false, new int[]{387, 388}, null);
        CodeGenerator_x86simd.rulev[539] = new Rule(539, false, true, 391, "539: _348 -> (BAND I8 _344 _347)", null, null, null, 0L, false, false, new int[]{387, 390}, null);
        CodeGenerator_x86simd.rulev[544] = new Rule(544, false, true, 396, "544: _353 -> (BAND I8 _351 _352)", null, null, null, 0L, false, false, new int[]{394, 395}, null);
        CodeGenerator_x86simd.rulev[546] = new Rule(546, false, true, 398, "546: _355 -> (BAND I8 _351 _354)", null, null, null, 0L, false, false, new int[]{394, 397}, null);
        CodeGenerator_x86simd.rulev[551] = new Rule(551, false, true, 403, "551: _360 -> (BAND I8 _358 _359)", null, null, null, 0L, false, false, new int[]{401, 402}, null);
        CodeGenerator_x86simd.rulev[553] = new Rule(553, false, true, 405, "553: _362 -> (BAND I8 _358 _361)", null, null, null, 0L, false, false, new int[]{401, 404}, null);
        CodeGenerator_x86simd.rulev[558] = new Rule(558, false, true, 410, "558: _367 -> (BAND I8 _365 _366)", null, null, null, 0L, false, false, new int[]{408, 409}, null);
        CodeGenerator_x86simd.rulev[560] = new Rule(560, false, true, 412, "560: _369 -> (BAND I8 _365 _368)", null, null, null, 0L, false, false, new int[]{408, 411}, null);
        CodeGenerator_x86simd.rulev[565] = new Rule(565, false, true, 417, "565: _374 -> (BAND I8 _372 _373)", null, null, null, 0L, false, false, new int[]{415, 416}, null);
        CodeGenerator_x86simd.rulev[567] = new Rule(567, false, true, 419, "567: _376 -> (BAND I8 _372 _375)", null, null, null, 0L, false, false, new int[]{415, 418}, null);
        CodeGenerator_x86simd.rulev[573] = new Rule(573, false, true, 425, "573: _382 -> (BAND I8 _380 _381)", null, null, null, 0L, false, false, new int[]{423, 424}, null);
        CodeGenerator_x86simd.rulev[575] = new Rule(575, false, true, 427, "575: _384 -> (BAND I8 _380 _383)", null, null, null, 0L, false, false, new int[]{423, 426}, null);
        CodeGenerator_x86simd.rulev[579] = new Rule(579, false, true, 431, "579: _388 -> (BAND I8 _386 _387)", null, null, null, 0L, false, false, new int[]{429, 430}, null);
        CodeGenerator_x86simd.rulev[581] = new Rule(581, false, true, 433, "581: _390 -> (BAND I8 _386 _389)", null, null, null, 0L, false, false, new int[]{429, 432}, null);
        CodeGenerator_x86simd.rulev[586] = new Rule(586, false, true, 438, "586: _395 -> (BAND I8 _393 _394)", null, null, null, 0L, false, false, new int[]{436, 437}, null);
        CodeGenerator_x86simd.rulev[588] = new Rule(588, false, true, 440, "588: _397 -> (BAND I8 _393 _396)", null, null, null, 0L, false, false, new int[]{436, 439}, null);
        CodeGenerator_x86simd.rulev[593] = new Rule(593, false, true, 445, "593: _402 -> (BAND I8 _400 _401)", null, null, null, 0L, false, false, new int[]{443, 444}, null);
        CodeGenerator_x86simd.rulev[595] = new Rule(595, false, true, 447, "595: _404 -> (BAND I8 _400 _403)", null, null, null, 0L, false, false, new int[]{443, 446}, null);
        CodeGenerator_x86simd.rulev[600] = new Rule(600, false, true, 452, "600: _409 -> (BAND I8 _407 _408)", null, null, null, 0L, false, false, new int[]{450, 451}, null);
        CodeGenerator_x86simd.rulev[602] = new Rule(602, false, true, 454, "602: _411 -> (BAND I8 _407 _410)", null, null, null, 0L, false, false, new int[]{450, 453}, null);
        CodeGenerator_x86simd.rulev[607] = new Rule(607, false, true, 459, "607: _416 -> (BAND I8 _414 _415)", null, null, null, 0L, false, false, new int[]{457, 458}, null);
        CodeGenerator_x86simd.rulev[609] = new Rule(609, false, true, 461, "609: _418 -> (BAND I8 _414 _417)", null, null, null, 0L, false, false, new int[]{457, 460}, null);
        CodeGenerator_x86simd.rulev[614] = new Rule(614, false, true, 466, "614: _423 -> (BAND I8 _421 _422)", null, null, null, 0L, false, false, new int[]{464, 465}, null);
        CodeGenerator_x86simd.rulev[616] = new Rule(616, false, true, 468, "616: _425 -> (BAND I8 _421 _424)", null, null, null, 0L, false, false, new int[]{464, 467}, null);
        CodeGenerator_x86simd.rulev[621] = new Rule(621, false, true, 473, "621: _430 -> (BAND I8 _428 _429)", null, null, null, 0L, false, false, new int[]{471, 472}, null);
        CodeGenerator_x86simd.rulev[623] = new Rule(623, false, true, 475, "623: _432 -> (BAND I8 _428 _431)", null, null, null, 0L, false, false, new int[]{471, 474}, null);
        CodeGenerator_x86simd.rulev[665] = new Rule(665, false, true, 515, "665: _472 -> (BAND I8 _471 _437)", null, null, null, 0L, false, false, new int[]{514, 480}, null);
        CodeGenerator_x86simd.rulev[671] = new Rule(671, false, true, 521, "671: _478 -> (BAND I8 _477 _437)", null, null, null, 0L, false, false, new int[]{520, 480}, null);
        CodeGenerator_x86simd.rulev[677] = new Rule(677, false, true, 527, "677: _484 -> (BAND I8 _483 _437)", null, null, null, 0L, false, false, new int[]{526, 480}, null);
        CodeGenerator_x86simd.rulev[683] = new Rule(683, false, true, 533, "683: _490 -> (BAND I8 _489 _437)", null, null, null, 0L, false, false, new int[]{532, 480}, null);
        CodeGenerator_x86simd.rulev[689] = new Rule(689, false, true, 539, "689: _496 -> (BAND I8 _495 _437)", null, null, null, 0L, false, false, new int[]{538, 480}, null);
        CodeGenerator_x86simd.rulev[695] = new Rule(695, false, true, 545, "695: _502 -> (BAND I8 _501 _437)", null, null, null, 0L, false, false, new int[]{544, 480}, null);
        CodeGenerator_x86simd.rulev[701] = new Rule(701, false, true, 551, "701: _508 -> (BAND I8 _507 _437)", null, null, null, 0L, false, false, new int[]{550, 480}, null);
        CodeGenerator_x86simd.rulev[707] = new Rule(707, false, true, 557, "707: _514 -> (BAND I8 _513 _437)", null, null, null, 0L, false, false, new int[]{556, 480}, null);
        CodeGenerator_x86simd.rulev[779] = new Rule(779, false, true, 627, "779: _584 -> (BAND I8 _583 _437)", null, null, null, 0L, false, false, new int[]{626, 480}, null);
        CodeGenerator_x86simd.rulev[785] = new Rule(785, false, true, 633, "785: _590 -> (BAND I8 _589 _437)", null, null, null, 0L, false, false, new int[]{632, 480}, null);
        CodeGenerator_x86simd.rulev[791] = new Rule(791, false, true, 639, "791: _596 -> (BAND I8 _595 _437)", null, null, null, 0L, false, false, new int[]{638, 480}, null);
        CodeGenerator_x86simd.rulev[797] = new Rule(797, false, true, 645, "797: _602 -> (BAND I8 _601 _437)", null, null, null, 0L, false, false, new int[]{644, 480}, null);
        CodeGenerator_x86simd.rulev[803] = new Rule(803, false, true, 651, "803: _608 -> (BAND I8 _607 _437)", null, null, null, 0L, false, false, new int[]{650, 480}, null);
        CodeGenerator_x86simd.rulev[809] = new Rule(809, false, true, 657, "809: _614 -> (BAND I8 _613 _437)", null, null, null, 0L, false, false, new int[]{656, 480}, null);
        CodeGenerator_x86simd.rulev[815] = new Rule(815, false, true, 663, "815: _620 -> (BAND I8 _619 _437)", null, null, null, 0L, false, false, new int[]{662, 480}, null);
        CodeGenerator_x86simd.rulev[821] = new Rule(821, false, true, 669, "821: _626 -> (BAND I8 _625 _437)", null, null, null, 0L, false, false, new int[]{668, 480}, null);
        CodeGenerator_x86simd.rulev[827] = new Rule(827, false, true, 675, "827: _632 -> (BAND I8 _631 _437)", null, null, null, 0L, false, false, new int[]{674, 480}, null);
        CodeGenerator_x86simd.rulev[833] = new Rule(833, false, true, 681, "833: _638 -> (BAND I8 _637 _437)", null, null, null, 0L, false, false, new int[]{680, 480}, null);
        CodeGenerator_x86simd.rulev[839] = new Rule(839, false, true, 687, "839: _644 -> (BAND I8 _643 _437)", null, null, null, 0L, false, false, new int[]{686, 480}, null);
        CodeGenerator_x86simd.rulev[845] = new Rule(845, false, true, 693, "845: _650 -> (BAND I8 _649 _437)", null, null, null, 0L, false, false, new int[]{692, 480}, null);
        CodeGenerator_x86simd.rulev[851] = new Rule(851, false, true, 699, "851: _656 -> (BAND I8 _655 _437)", null, null, null, 0L, false, false, new int[]{698, 480}, null);
        CodeGenerator_x86simd.rulev[857] = new Rule(857, false, true, 705, "857: _662 -> (BAND I8 _661 _437)", null, null, null, 0L, false, false, new int[]{704, 480}, null);
        CodeGenerator_x86simd.rulev[863] = new Rule(863, false, true, 711, "863: _668 -> (BAND I8 _667 _437)", null, null, null, 0L, false, false, new int[]{710, 480}, null);
        CodeGenerator_x86simd.rulev[869] = new Rule(869, false, true, 717, "869: _674 -> (BAND I8 _673 _437)", null, null, null, 0L, false, false, new int[]{716, 480}, null);
        CodeGenerator_x86simd.rulev[999] = new Rule(999, false, true, 842, "999: _799 -> (BAND I8 _101 _798)", null, null, null, 0L, false, false, new int[]{144, 841}, null);
        CodeGenerator_x86simd.rulev[1001] = new Rule(1001, false, true, 844, "1001: _801 -> (BAND I8 _101 _800)", null, null, null, 0L, false, false, new int[]{144, 843}, null);
        CodeGenerator_x86simd.rulev[1005] = new Rule(1005, false, true, 848, "1005: _805 -> (BAND I8 _103 _804)", null, null, null, 0L, false, false, new int[]{146, 847}, null);
        CodeGenerator_x86simd.rulev[1007] = new Rule(1007, false, true, 850, "1007: _807 -> (BAND I8 _103 _806)", null, null, null, 0L, false, false, new int[]{146, 849}, null);
        CodeGenerator_x86simd.rulev[1011] = new Rule(1011, false, true, 854, "1011: _811 -> (BAND I8 _105 _810)", null, null, null, 0L, false, false, new int[]{148, 853}, null);
        CodeGenerator_x86simd.rulev[1013] = new Rule(1013, false, true, 856, "1013: _813 -> (BAND I8 _105 _812)", null, null, null, 0L, false, false, new int[]{148, 855}, null);
        CodeGenerator_x86simd.rulev[1017] = new Rule(1017, false, true, 860, "1017: _817 -> (BAND I8 _107 _816)", null, null, null, 0L, false, false, new int[]{150, 859}, null);
        CodeGenerator_x86simd.rulev[1019] = new Rule(1019, false, true, 862, "1019: _819 -> (BAND I8 _107 _818)", null, null, null, 0L, false, false, new int[]{150, 861}, null);
        CodeGenerator_x86simd.rulev[1023] = new Rule(1023, false, true, 866, "1023: _823 -> (BAND I8 _109 _822)", null, null, null, 0L, false, false, new int[]{152, 865}, null);
        CodeGenerator_x86simd.rulev[1025] = new Rule(1025, false, true, 868, "1025: _825 -> (BAND I8 _109 _824)", null, null, null, 0L, false, false, new int[]{152, 867}, null);
        CodeGenerator_x86simd.rulev[1029] = new Rule(1029, false, true, 872, "1029: _829 -> (BAND I8 _111 _828)", null, null, null, 0L, false, false, new int[]{154, 871}, null);
        CodeGenerator_x86simd.rulev[1031] = new Rule(1031, false, true, 874, "1031: _831 -> (BAND I8 _111 _830)", null, null, null, 0L, false, false, new int[]{154, 873}, null);
        CodeGenerator_x86simd.rulev[1035] = new Rule(1035, false, true, 878, "1035: _835 -> (BAND I8 _113 _834)", null, null, null, 0L, false, false, new int[]{156, 877}, null);
        CodeGenerator_x86simd.rulev[1037] = new Rule(1037, false, true, 880, "1037: _837 -> (BAND I8 _113 _836)", null, null, null, 0L, false, false, new int[]{156, 879}, null);
        CodeGenerator_x86simd.rulev[1041] = new Rule(1041, false, true, 884, "1041: _841 -> (BAND I8 _115 _840)", null, null, null, 0L, false, false, new int[]{158, 883}, null);
        CodeGenerator_x86simd.rulev[1043] = new Rule(1043, false, true, 886, "1043: _843 -> (BAND I8 _115 _842)", null, null, null, 0L, false, false, new int[]{158, 885}, null);
        CodeGenerator_x86simd.rulev[1048] = new Rule(1048, false, true, 890, "1048: _847 -> (BAND I8 _101 _846)", null, null, null, 0L, false, false, new int[]{144, 889}, null);
        CodeGenerator_x86simd.rulev[1050] = new Rule(1050, false, true, 892, "1050: _849 -> (BAND I8 _101 _848)", null, null, null, 0L, false, false, new int[]{144, 891}, null);
        CodeGenerator_x86simd.rulev[1054] = new Rule(1054, false, true, 896, "1054: _853 -> (BAND I8 _103 _852)", null, null, null, 0L, false, false, new int[]{146, 895}, null);
        CodeGenerator_x86simd.rulev[1056] = new Rule(1056, false, true, 898, "1056: _855 -> (BAND I8 _103 _854)", null, null, null, 0L, false, false, new int[]{146, 897}, null);
        CodeGenerator_x86simd.rulev[1060] = new Rule(1060, false, true, 902, "1060: _859 -> (BAND I8 _105 _858)", null, null, null, 0L, false, false, new int[]{148, 901}, null);
        CodeGenerator_x86simd.rulev[1062] = new Rule(1062, false, true, 904, "1062: _861 -> (BAND I8 _105 _860)", null, null, null, 0L, false, false, new int[]{148, 903}, null);
        CodeGenerator_x86simd.rulev[1066] = new Rule(1066, false, true, 908, "1066: _865 -> (BAND I8 _107 _864)", null, null, null, 0L, false, false, new int[]{150, 907}, null);
        CodeGenerator_x86simd.rulev[1068] = new Rule(1068, false, true, 910, "1068: _867 -> (BAND I8 _107 _866)", null, null, null, 0L, false, false, new int[]{150, 909}, null);
        CodeGenerator_x86simd.rulev[1072] = new Rule(1072, false, true, 914, "1072: _871 -> (BAND I8 _109 _870)", null, null, null, 0L, false, false, new int[]{152, 913}, null);
        CodeGenerator_x86simd.rulev[1074] = new Rule(1074, false, true, 916, "1074: _873 -> (BAND I8 _109 _872)", null, null, null, 0L, false, false, new int[]{152, 915}, null);
        CodeGenerator_x86simd.rulev[1078] = new Rule(1078, false, true, 920, "1078: _877 -> (BAND I8 _111 _876)", null, null, null, 0L, false, false, new int[]{154, 919}, null);
        CodeGenerator_x86simd.rulev[1080] = new Rule(1080, false, true, 922, "1080: _879 -> (BAND I8 _111 _878)", null, null, null, 0L, false, false, new int[]{154, 921}, null);
        CodeGenerator_x86simd.rulev[1084] = new Rule(1084, false, true, 926, "1084: _883 -> (BAND I8 _113 _882)", null, null, null, 0L, false, false, new int[]{156, 925}, null);
        CodeGenerator_x86simd.rulev[1086] = new Rule(1086, false, true, 928, "1086: _885 -> (BAND I8 _113 _884)", null, null, null, 0L, false, false, new int[]{156, 927}, null);
        CodeGenerator_x86simd.rulev[1090] = new Rule(1090, false, true, 932, "1090: _889 -> (BAND I8 _115 _888)", null, null, null, 0L, false, false, new int[]{158, 931}, null);
        CodeGenerator_x86simd.rulev[1092] = new Rule(1092, false, true, 934, "1092: _891 -> (BAND I8 _115 _890)", null, null, null, 0L, false, false, new int[]{158, 933}, null);
        CodeGenerator_x86simd.rulev[1097] = new Rule(1097, false, true, 938, "1097: _895 -> (BAND I8 _7 _894)", null, null, null, 0L, false, false, new int[]{50, 937}, null);
        CodeGenerator_x86simd.rulev[1099] = new Rule(1099, false, true, 940, "1099: _897 -> (BAND I8 _7 _896)", null, null, null, 0L, false, false, new int[]{50, 939}, null);
        CodeGenerator_x86simd.rulev[1103] = new Rule(1103, false, true, 944, "1103: _901 -> (BAND I8 _9 _900)", null, null, null, 0L, false, false, new int[]{52, 943}, null);
        CodeGenerator_x86simd.rulev[1105] = new Rule(1105, false, true, 946, "1105: _903 -> (BAND I8 _9 _902)", null, null, null, 0L, false, false, new int[]{52, 945}, null);
        CodeGenerator_x86simd.rulev[1109] = new Rule(1109, false, true, 950, "1109: _907 -> (BAND I8 _11 _906)", null, null, null, 0L, false, false, new int[]{54, 949}, null);
    }

    private static void rrinit700() {
        CodeGenerator_x86simd.rulev[1111] = new Rule(1111, false, true, 952, "1111: _909 -> (BAND I8 _11 _908)", null, null, null, 0L, false, false, new int[]{54, 951}, null);
        CodeGenerator_x86simd.rulev[1115] = new Rule(1115, false, true, 956, "1115: _913 -> (BAND I8 _13 _912)", null, null, null, 0L, false, false, new int[]{56, 955}, null);
        CodeGenerator_x86simd.rulev[1117] = new Rule(1117, false, true, 958, "1117: _915 -> (BAND I8 _13 _914)", null, null, null, 0L, false, false, new int[]{56, 957}, null);
        CodeGenerator_x86simd.rulev[1121] = new Rule(1121, false, true, 962, "1121: _919 -> (BAND I8 _15 _918)", null, null, null, 0L, false, false, new int[]{58, 961}, null);
        CodeGenerator_x86simd.rulev[1123] = new Rule(1123, false, true, 964, "1123: _921 -> (BAND I8 _15 _920)", null, null, null, 0L, false, false, new int[]{58, 963}, null);
        CodeGenerator_x86simd.rulev[1127] = new Rule(1127, false, true, 968, "1127: _925 -> (BAND I8 _18 _924)", null, null, null, 0L, false, false, new int[]{61, 967}, null);
        CodeGenerator_x86simd.rulev[1129] = new Rule(1129, false, true, 970, "1129: _927 -> (BAND I8 _18 _926)", null, null, null, 0L, false, false, new int[]{61, 969}, null);
        CodeGenerator_x86simd.rulev[1133] = new Rule(1133, false, true, 974, "1133: _931 -> (BAND I8 _21 _930)", null, null, null, 0L, false, false, new int[]{64, 973}, null);
        CodeGenerator_x86simd.rulev[1135] = new Rule(1135, false, true, 976, "1135: _933 -> (BAND I8 _21 _932)", null, null, null, 0L, false, false, new int[]{64, 975}, null);
        CodeGenerator_x86simd.rulev[1139] = new Rule(1139, false, true, 980, "1139: _937 -> (BAND I8 _24 _936)", null, null, null, 0L, false, false, new int[]{67, 979}, null);
        CodeGenerator_x86simd.rulev[1141] = new Rule(1141, false, true, 982, "1141: _939 -> (BAND I8 _24 _938)", null, null, null, 0L, false, false, new int[]{67, 981}, null);
        CodeGenerator_x86simd.rulev[1145] = new Rule(1145, false, true, 986, "1145: _943 -> (BAND I8 _26 _942)", null, null, null, 0L, false, false, new int[]{69, 985}, null);
        CodeGenerator_x86simd.rulev[1147] = new Rule(1147, false, true, 988, "1147: _945 -> (BAND I8 _26 _944)", null, null, null, 0L, false, false, new int[]{69, 987}, null);
        CodeGenerator_x86simd.rulev[1151] = new Rule(1151, false, true, 992, "1151: _949 -> (BAND I8 _29 _948)", null, null, null, 0L, false, false, new int[]{72, 991}, null);
        CodeGenerator_x86simd.rulev[1153] = new Rule(1153, false, true, 994, "1153: _951 -> (BAND I8 _29 _950)", null, null, null, 0L, false, false, new int[]{72, 993}, null);
        CodeGenerator_x86simd.rulev[1157] = new Rule(1157, false, true, 998, "1157: _955 -> (BAND I8 _32 _954)", null, null, null, 0L, false, false, new int[]{75, 997}, null);
        CodeGenerator_x86simd.rulev[1159] = new Rule(1159, false, true, 1000, "1159: _957 -> (BAND I8 _32 _956)", null, null, null, 0L, false, false, new int[]{75, 999}, null);
        CodeGenerator_x86simd.rulev[1163] = new Rule(1163, false, true, 1004, "1163: _961 -> (BAND I8 _35 _960)", null, null, null, 0L, false, false, new int[]{78, 1003}, null);
        CodeGenerator_x86simd.rulev[1165] = new Rule(1165, false, true, 1006, "1165: _963 -> (BAND I8 _35 _962)", null, null, null, 0L, false, false, new int[]{78, 1005}, null);
        CodeGenerator_x86simd.rulev[1169] = new Rule(1169, false, true, 1010, "1169: _967 -> (BAND I8 _38 _966)", null, null, null, 0L, false, false, new int[]{81, 1009}, null);
        CodeGenerator_x86simd.rulev[1171] = new Rule(1171, false, true, 1012, "1171: _969 -> (BAND I8 _38 _968)", null, null, null, 0L, false, false, new int[]{81, 1011}, null);
        CodeGenerator_x86simd.rulev[1175] = new Rule(1175, false, true, 1016, "1175: _973 -> (BAND I8 _41 _972)", null, null, null, 0L, false, false, new int[]{84, 1015}, null);
        CodeGenerator_x86simd.rulev[1177] = new Rule(1177, false, true, 1018, "1177: _975 -> (BAND I8 _41 _974)", null, null, null, 0L, false, false, new int[]{84, 1017}, null);
        CodeGenerator_x86simd.rulev[1181] = new Rule(1181, false, true, 1022, "1181: _979 -> (BAND I8 _44 _978)", null, null, null, 0L, false, false, new int[]{87, 1021}, null);
        CodeGenerator_x86simd.rulev[1183] = new Rule(1183, false, true, 1024, "1183: _981 -> (BAND I8 _44 _980)", null, null, null, 0L, false, false, new int[]{87, 1023}, null);
        CodeGenerator_x86simd.rulev[1187] = new Rule(1187, false, true, 1028, "1187: _985 -> (BAND I8 _47 _984)", null, null, null, 0L, false, false, new int[]{90, 1027}, null);
        CodeGenerator_x86simd.rulev[1189] = new Rule(1189, false, true, 1030, "1189: _987 -> (BAND I8 _47 _986)", null, null, null, 0L, false, false, new int[]{90, 1029}, null);
        CodeGenerator_x86simd.rulev[1194] = new Rule(1194, false, true, 1034, "1194: _991 -> (BAND I8 _7 _990)", null, null, null, 0L, false, false, new int[]{50, 1033}, null);
        CodeGenerator_x86simd.rulev[1196] = new Rule(1196, false, true, 1036, "1196: _993 -> (BAND I8 _7 _992)", null, null, null, 0L, false, false, new int[]{50, 1035}, null);
        CodeGenerator_x86simd.rulev[1200] = new Rule(1200, false, true, 1040, "1200: _997 -> (BAND I8 _9 _996)", null, null, null, 0L, false, false, new int[]{52, 1039}, null);
        CodeGenerator_x86simd.rulev[1202] = new Rule(1202, false, true, 1042, "1202: _999 -> (BAND I8 _9 _998)", null, null, null, 0L, false, false, new int[]{52, 1041}, null);
        CodeGenerator_x86simd.rulev[1206] = new Rule(1206, false, true, 1046, "1206: _1003 -> (BAND I8 _11 _1002)", null, null, null, 0L, false, false, new int[]{54, 1045}, null);
        CodeGenerator_x86simd.rulev[1208] = new Rule(1208, false, true, 1048, "1208: _1005 -> (BAND I8 _11 _1004)", null, null, null, 0L, false, false, new int[]{54, 1047}, null);
        CodeGenerator_x86simd.rulev[1212] = new Rule(1212, false, true, 1052, "1212: _1009 -> (BAND I8 _13 _1008)", null, null, null, 0L, false, false, new int[]{56, 1051}, null);
        CodeGenerator_x86simd.rulev[1214] = new Rule(1214, false, true, 1054, "1214: _1011 -> (BAND I8 _13 _1010)", null, null, null, 0L, false, false, new int[]{56, 1053}, null);
        CodeGenerator_x86simd.rulev[1218] = new Rule(1218, false, true, 1058, "1218: _1015 -> (BAND I8 _15 _1014)", null, null, null, 0L, false, false, new int[]{58, 1057}, null);
        CodeGenerator_x86simd.rulev[1220] = new Rule(1220, false, true, 1060, "1220: _1017 -> (BAND I8 _15 _1016)", null, null, null, 0L, false, false, new int[]{58, 1059}, null);
        CodeGenerator_x86simd.rulev[1224] = new Rule(1224, false, true, 1064, "1224: _1021 -> (BAND I8 _18 _1020)", null, null, null, 0L, false, false, new int[]{61, 1063}, null);
        CodeGenerator_x86simd.rulev[1226] = new Rule(1226, false, true, 1066, "1226: _1023 -> (BAND I8 _18 _1022)", null, null, null, 0L, false, false, new int[]{61, 1065}, null);
        CodeGenerator_x86simd.rulev[1230] = new Rule(1230, false, true, 1070, "1230: _1027 -> (BAND I8 _21 _1026)", null, null, null, 0L, false, false, new int[]{64, 1069}, null);
        CodeGenerator_x86simd.rulev[1232] = new Rule(1232, false, true, 1072, "1232: _1029 -> (BAND I8 _21 _1028)", null, null, null, 0L, false, false, new int[]{64, 1071}, null);
        CodeGenerator_x86simd.rulev[1236] = new Rule(1236, false, true, 1076, "1236: _1033 -> (BAND I8 _24 _1032)", null, null, null, 0L, false, false, new int[]{67, 1075}, null);
        CodeGenerator_x86simd.rulev[1238] = new Rule(1238, false, true, 1078, "1238: _1035 -> (BAND I8 _24 _1034)", null, null, null, 0L, false, false, new int[]{67, 1077}, null);
        CodeGenerator_x86simd.rulev[1242] = new Rule(1242, false, true, 1082, "1242: _1039 -> (BAND I8 _26 _1038)", null, null, null, 0L, false, false, new int[]{69, 1081}, null);
        CodeGenerator_x86simd.rulev[1244] = new Rule(1244, false, true, 1084, "1244: _1041 -> (BAND I8 _26 _1040)", null, null, null, 0L, false, false, new int[]{69, 1083}, null);
        CodeGenerator_x86simd.rulev[1248] = new Rule(1248, false, true, 1088, "1248: _1045 -> (BAND I8 _29 _1044)", null, null, null, 0L, false, false, new int[]{72, 1087}, null);
        CodeGenerator_x86simd.rulev[1250] = new Rule(1250, false, true, 1090, "1250: _1047 -> (BAND I8 _29 _1046)", null, null, null, 0L, false, false, new int[]{72, 1089}, null);
        CodeGenerator_x86simd.rulev[1254] = new Rule(1254, false, true, 1094, "1254: _1051 -> (BAND I8 _32 _1050)", null, null, null, 0L, false, false, new int[]{75, 1093}, null);
        CodeGenerator_x86simd.rulev[1256] = new Rule(1256, false, true, 1096, "1256: _1053 -> (BAND I8 _32 _1052)", null, null, null, 0L, false, false, new int[]{75, 1095}, null);
        CodeGenerator_x86simd.rulev[1260] = new Rule(1260, false, true, 1100, "1260: _1057 -> (BAND I8 _35 _1056)", null, null, null, 0L, false, false, new int[]{78, 1099}, null);
        CodeGenerator_x86simd.rulev[1262] = new Rule(1262, false, true, 1102, "1262: _1059 -> (BAND I8 _35 _1058)", null, null, null, 0L, false, false, new int[]{78, 1101}, null);
        CodeGenerator_x86simd.rulev[1266] = new Rule(1266, false, true, 1106, "1266: _1063 -> (BAND I8 _38 _1062)", null, null, null, 0L, false, false, new int[]{81, 1105}, null);
        CodeGenerator_x86simd.rulev[1268] = new Rule(1268, false, true, 1108, "1268: _1065 -> (BAND I8 _38 _1064)", null, null, null, 0L, false, false, new int[]{81, 1107}, null);
        CodeGenerator_x86simd.rulev[1272] = new Rule(1272, false, true, 1112, "1272: _1069 -> (BAND I8 _41 _1068)", null, null, null, 0L, false, false, new int[]{84, 1111}, null);
        CodeGenerator_x86simd.rulev[1274] = new Rule(1274, false, true, 1114, "1274: _1071 -> (BAND I8 _41 _1070)", null, null, null, 0L, false, false, new int[]{84, 1113}, null);
        CodeGenerator_x86simd.rulev[1278] = new Rule(1278, false, true, 1118, "1278: _1075 -> (BAND I8 _44 _1074)", null, null, null, 0L, false, false, new int[]{87, 1117}, null);
        CodeGenerator_x86simd.rulev[1280] = new Rule(1280, false, true, 1120, "1280: _1077 -> (BAND I8 _44 _1076)", null, null, null, 0L, false, false, new int[]{87, 1119}, null);
        CodeGenerator_x86simd.rulev[1284] = new Rule(1284, false, true, 1124, "1284: _1081 -> (BAND I8 _47 _1080)", null, null, null, 0L, false, false, new int[]{90, 1123}, null);
        CodeGenerator_x86simd.rulev[1286] = new Rule(1286, false, true, 1126, "1286: _1083 -> (BAND I8 _47 _1082)", null, null, null, 0L, false, false, new int[]{90, 1125}, null);
        CodeGenerator_x86simd.rulev[1439] = new Rule(1439, false, true, 1274, "1439: _1231 -> (BAND I8 con _1230)", null, null, null, 0L, false, false, new int[]{19, 1273}, null);
        CodeGenerator_x86simd.rulev[1441] = new Rule(1441, false, true, 1276, "1441: _1233 -> (BAND I8 con _1232)", null, null, null, 0L, false, false, new int[]{19, 1275}, null);
        CodeGenerator_x86simd.rulev[1445] = new Rule(1445, false, true, 1280, "1445: _1237 -> (BAND I8 con _1236)", null, null, null, 0L, false, false, new int[]{19, 1279}, null);
        CodeGenerator_x86simd.rulev[1447] = new Rule(1447, false, true, 1282, "1447: _1239 -> (BAND I8 con _1238)", null, null, null, 0L, false, false, new int[]{19, 1281}, null);
        CodeGenerator_x86simd.rulev[1451] = new Rule(1451, false, true, 1286, "1451: _1243 -> (BAND I8 con _1242)", null, null, null, 0L, false, false, new int[]{19, 1285}, null);
        CodeGenerator_x86simd.rulev[1453] = new Rule(1453, false, true, 1288, "1453: _1245 -> (BAND I8 con _1244)", null, null, null, 0L, false, false, new int[]{19, 1287}, null);
        CodeGenerator_x86simd.rulev[1457] = new Rule(1457, false, true, 1292, "1457: _1249 -> (BAND I8 con _1248)", null, null, null, 0L, false, false, new int[]{19, 1291}, null);
        CodeGenerator_x86simd.rulev[1459] = new Rule(1459, false, true, 1294, "1459: _1251 -> (BAND I8 con _1250)", null, null, null, 0L, false, false, new int[]{19, 1293}, null);
        CodeGenerator_x86simd.rulev[1463] = new Rule(1463, false, true, 1298, "1463: _1255 -> (BAND I8 con _1254)", null, null, null, 0L, false, false, new int[]{19, 1297}, null);
        CodeGenerator_x86simd.rulev[1465] = new Rule(1465, false, true, 1300, "1465: _1257 -> (BAND I8 con _1256)", null, null, null, 0L, false, false, new int[]{19, 1299}, null);
        CodeGenerator_x86simd.rulev[1469] = new Rule(1469, false, true, 1304, "1469: _1261 -> (BAND I8 con _1260)", null, null, null, 0L, false, false, new int[]{19, 1303}, null);
        CodeGenerator_x86simd.rulev[1471] = new Rule(1471, false, true, 1306, "1471: _1263 -> (BAND I8 con _1262)", null, null, null, 0L, false, false, new int[]{19, 1305}, null);
        CodeGenerator_x86simd.rulev[1475] = new Rule(1475, false, true, 1310, "1475: _1267 -> (BAND I8 con _1266)", null, null, null, 0L, false, false, new int[]{19, 1309}, null);
        CodeGenerator_x86simd.rulev[1477] = new Rule(1477, false, true, 1312, "1477: _1269 -> (BAND I8 con _1268)", null, null, null, 0L, false, false, new int[]{19, 1311}, null);
        CodeGenerator_x86simd.rulev[1481] = new Rule(1481, false, true, 1316, "1481: _1273 -> (BAND I8 con _1272)", null, null, null, 0L, false, false, new int[]{19, 1315}, null);
        CodeGenerator_x86simd.rulev[1483] = new Rule(1483, false, true, 1318, "1483: _1275 -> (BAND I8 con _1274)", null, null, null, 0L, false, false, new int[]{19, 1317}, null);
        CodeGenerator_x86simd.rulev[1488] = new Rule(1488, false, true, 1322, "1488: _1279 -> (BAND I8 con _1278)", null, null, null, 0L, false, false, new int[]{19, 1321}, null);
        CodeGenerator_x86simd.rulev[1490] = new Rule(1490, false, true, 1324, "1490: _1281 -> (BAND I8 con _1280)", null, null, null, 0L, false, false, new int[]{19, 1323}, null);
        CodeGenerator_x86simd.rulev[1494] = new Rule(1494, false, true, 1328, "1494: _1285 -> (BAND I8 con _1284)", null, null, null, 0L, false, false, new int[]{19, 1327}, null);
        CodeGenerator_x86simd.rulev[1496] = new Rule(1496, false, true, 1330, "1496: _1287 -> (BAND I8 con _1286)", null, null, null, 0L, false, false, new int[]{19, 1329}, null);
        CodeGenerator_x86simd.rulev[1500] = new Rule(1500, false, true, 1334, "1500: _1291 -> (BAND I8 con _1290)", null, null, null, 0L, false, false, new int[]{19, 1333}, null);
        CodeGenerator_x86simd.rulev[1502] = new Rule(1502, false, true, 1336, "1502: _1293 -> (BAND I8 con _1292)", null, null, null, 0L, false, false, new int[]{19, 1335}, null);
        CodeGenerator_x86simd.rulev[1506] = new Rule(1506, false, true, 1340, "1506: _1297 -> (BAND I8 con _1296)", null, null, null, 0L, false, false, new int[]{19, 1339}, null);
        CodeGenerator_x86simd.rulev[1508] = new Rule(1508, false, true, 1342, "1508: _1299 -> (BAND I8 con _1298)", null, null, null, 0L, false, false, new int[]{19, 1341}, null);
        CodeGenerator_x86simd.rulev[1512] = new Rule(1512, false, true, 1346, "1512: _1303 -> (BAND I8 con _1302)", null, null, null, 0L, false, false, new int[]{19, 1345}, null);
        CodeGenerator_x86simd.rulev[1514] = new Rule(1514, false, true, 1348, "1514: _1305 -> (BAND I8 con _1304)", null, null, null, 0L, false, false, new int[]{19, 1347}, null);
        CodeGenerator_x86simd.rulev[1518] = new Rule(1518, false, true, 1352, "1518: _1309 -> (BAND I8 con _1308)", null, null, null, 0L, false, false, new int[]{19, 1351}, null);
        CodeGenerator_x86simd.rulev[1520] = new Rule(1520, false, true, 1354, "1520: _1311 -> (BAND I8 con _1310)", null, null, null, 0L, false, false, new int[]{19, 1353}, null);
        CodeGenerator_x86simd.rulev[1524] = new Rule(1524, false, true, 1358, "1524: _1315 -> (BAND I8 con _1314)", null, null, null, 0L, false, false, new int[]{19, 1357}, null);
        CodeGenerator_x86simd.rulev[1526] = new Rule(1526, false, true, 1360, "1526: _1317 -> (BAND I8 con _1316)", null, null, null, 0L, false, false, new int[]{19, 1359}, null);
        CodeGenerator_x86simd.rulev[1530] = new Rule(1530, false, true, 1364, "1530: _1321 -> (BAND I8 con _1320)", null, null, null, 0L, false, false, new int[]{19, 1363}, null);
        CodeGenerator_x86simd.rulev[1532] = new Rule(1532, false, true, 1366, "1532: _1323 -> (BAND I8 con _1322)", null, null, null, 0L, false, false, new int[]{19, 1365}, null);
        CodeGenerator_x86simd.rulev[1613] = new Rule(1613, false, true, 1442, "1613: _1399 -> (BAND I8 con _1398)", null, null, null, 0L, false, false, new int[]{19, 1441}, null);
        CodeGenerator_x86simd.rulev[1615] = new Rule(1615, false, true, 1444, "1615: _1401 -> (BAND I8 con _1400)", null, null, null, 0L, false, false, new int[]{19, 1443}, null);
        CodeGenerator_x86simd.rulev[1619] = new Rule(1619, false, true, 1448, "1619: _1405 -> (BAND I8 con _1404)", null, null, null, 0L, false, false, new int[]{19, 1447}, null);
        CodeGenerator_x86simd.rulev[1621] = new Rule(1621, false, true, 1450, "1621: _1407 -> (BAND I8 con _1406)", null, null, null, 0L, false, false, new int[]{19, 1449}, null);
        CodeGenerator_x86simd.rulev[1625] = new Rule(1625, false, true, 1454, "1625: _1411 -> (BAND I8 con _1410)", null, null, null, 0L, false, false, new int[]{19, 1453}, null);
        CodeGenerator_x86simd.rulev[1627] = new Rule(1627, false, true, 1456, "1627: _1413 -> (BAND I8 con _1412)", null, null, null, 0L, false, false, new int[]{19, 1455}, null);
        CodeGenerator_x86simd.rulev[1631] = new Rule(1631, false, true, 1460, "1631: _1417 -> (BAND I8 con _1416)", null, null, null, 0L, false, false, new int[]{19, 1459}, null);
        CodeGenerator_x86simd.rulev[1633] = new Rule(1633, false, true, 1462, "1633: _1419 -> (BAND I8 con _1418)", null, null, null, 0L, false, false, new int[]{19, 1461}, null);
        CodeGenerator_x86simd.rulev[1637] = new Rule(1637, false, true, 1466, "1637: _1423 -> (BAND I8 con _1422)", null, null, null, 0L, false, false, new int[]{19, 1465}, null);
    }

    private static void rrinit800() {
        CodeGenerator_x86simd.rulev[1639] = new Rule(1639, false, true, 1468, "1639: _1425 -> (BAND I8 con _1424)", null, null, null, 0L, false, false, new int[]{19, 1467}, null);
        CodeGenerator_x86simd.rulev[1643] = new Rule(1643, false, true, 1472, "1643: _1429 -> (BAND I8 con _1428)", null, null, null, 0L, false, false, new int[]{19, 1471}, null);
        CodeGenerator_x86simd.rulev[1645] = new Rule(1645, false, true, 1474, "1645: _1431 -> (BAND I8 con _1430)", null, null, null, 0L, false, false, new int[]{19, 1473}, null);
        CodeGenerator_x86simd.rulev[1649] = new Rule(1649, false, true, 1478, "1649: _1435 -> (BAND I8 con _1434)", null, null, null, 0L, false, false, new int[]{19, 1477}, null);
        CodeGenerator_x86simd.rulev[1651] = new Rule(1651, false, true, 1480, "1651: _1437 -> (BAND I8 con _1436)", null, null, null, 0L, false, false, new int[]{19, 1479}, null);
        CodeGenerator_x86simd.rulev[1655] = new Rule(1655, false, true, 1484, "1655: _1441 -> (BAND I8 con _1440)", null, null, null, 0L, false, false, new int[]{19, 1483}, null);
        CodeGenerator_x86simd.rulev[1657] = new Rule(1657, false, true, 1486, "1657: _1443 -> (BAND I8 con _1442)", null, null, null, 0L, false, false, new int[]{19, 1485}, null);
        CodeGenerator_x86simd.rulev[1661] = new Rule(1661, false, true, 1490, "1661: _1447 -> (BAND I8 con _1446)", null, null, null, 0L, false, false, new int[]{19, 1489}, null);
        CodeGenerator_x86simd.rulev[1663] = new Rule(1663, false, true, 1492, "1663: _1449 -> (BAND I8 con _1448)", null, null, null, 0L, false, false, new int[]{19, 1491}, null);
        CodeGenerator_x86simd.rulev[1667] = new Rule(1667, false, true, 1496, "1667: _1453 -> (BAND I8 con _1452)", null, null, null, 0L, false, false, new int[]{19, 1495}, null);
        CodeGenerator_x86simd.rulev[1669] = new Rule(1669, false, true, 1498, "1669: _1455 -> (BAND I8 con _1454)", null, null, null, 0L, false, false, new int[]{19, 1497}, null);
        CodeGenerator_x86simd.rulev[1673] = new Rule(1673, false, true, 1502, "1673: _1459 -> (BAND I8 con _1458)", null, null, null, 0L, false, false, new int[]{19, 1501}, null);
        CodeGenerator_x86simd.rulev[1675] = new Rule(1675, false, true, 1504, "1675: _1461 -> (BAND I8 con _1460)", null, null, null, 0L, false, false, new int[]{19, 1503}, null);
        CodeGenerator_x86simd.rulev[1679] = new Rule(1679, false, true, 1508, "1679: _1465 -> (BAND I8 con _1464)", null, null, null, 0L, false, false, new int[]{19, 1507}, null);
        CodeGenerator_x86simd.rulev[1681] = new Rule(1681, false, true, 1510, "1681: _1467 -> (BAND I8 con _1466)", null, null, null, 0L, false, false, new int[]{19, 1509}, null);
        CodeGenerator_x86simd.rulev[1685] = new Rule(1685, false, true, 1514, "1685: _1471 -> (BAND I8 con _1470)", null, null, null, 0L, false, false, new int[]{19, 1513}, null);
        CodeGenerator_x86simd.rulev[1687] = new Rule(1687, false, true, 1516, "1687: _1473 -> (BAND I8 con _1472)", null, null, null, 0L, false, false, new int[]{19, 1515}, null);
        CodeGenerator_x86simd.rulev[1691] = new Rule(1691, false, true, 1520, "1691: _1477 -> (BAND I8 con _1476)", null, null, null, 0L, false, false, new int[]{19, 1519}, null);
        CodeGenerator_x86simd.rulev[1693] = new Rule(1693, false, true, 1522, "1693: _1479 -> (BAND I8 con _1478)", null, null, null, 0L, false, false, new int[]{19, 1521}, null);
        CodeGenerator_x86simd.rulev[1697] = new Rule(1697, false, true, 1526, "1697: _1483 -> (BAND I8 con _1482)", null, null, null, 0L, false, false, new int[]{19, 1525}, null);
        CodeGenerator_x86simd.rulev[1699] = new Rule(1699, false, true, 1528, "1699: _1485 -> (BAND I8 con _1484)", null, null, null, 0L, false, false, new int[]{19, 1527}, null);
        CodeGenerator_x86simd.rulev[1703] = new Rule(1703, false, true, 1532, "1703: _1489 -> (BAND I8 con _1488)", null, null, null, 0L, false, false, new int[]{19, 1531}, null);
        CodeGenerator_x86simd.rulev[1705] = new Rule(1705, false, true, 1534, "1705: _1491 -> (BAND I8 con _1490)", null, null, null, 0L, false, false, new int[]{19, 1533}, null);
        CodeGenerator_x86simd.rulev[1710] = new Rule(1710, false, true, 1538, "1710: _1495 -> (BAND I8 con _1494)", null, null, null, 0L, false, false, new int[]{19, 1537}, null);
        CodeGenerator_x86simd.rulev[1712] = new Rule(1712, false, true, 1540, "1712: _1497 -> (BAND I8 con _1496)", null, null, null, 0L, false, false, new int[]{19, 1539}, null);
        CodeGenerator_x86simd.rulev[1716] = new Rule(1716, false, true, 1544, "1716: _1501 -> (BAND I8 con _1500)", null, null, null, 0L, false, false, new int[]{19, 1543}, null);
        CodeGenerator_x86simd.rulev[1718] = new Rule(1718, false, true, 1546, "1718: _1503 -> (BAND I8 con _1502)", null, null, null, 0L, false, false, new int[]{19, 1545}, null);
        CodeGenerator_x86simd.rulev[1722] = new Rule(1722, false, true, 1550, "1722: _1507 -> (BAND I8 con _1506)", null, null, null, 0L, false, false, new int[]{19, 1549}, null);
        CodeGenerator_x86simd.rulev[1724] = new Rule(1724, false, true, 1552, "1724: _1509 -> (BAND I8 con _1508)", null, null, null, 0L, false, false, new int[]{19, 1551}, null);
        CodeGenerator_x86simd.rulev[1728] = new Rule(1728, false, true, 1556, "1728: _1513 -> (BAND I8 con _1512)", null, null, null, 0L, false, false, new int[]{19, 1555}, null);
        CodeGenerator_x86simd.rulev[1730] = new Rule(1730, false, true, 1558, "1730: _1515 -> (BAND I8 con _1514)", null, null, null, 0L, false, false, new int[]{19, 1557}, null);
        CodeGenerator_x86simd.rulev[1734] = new Rule(1734, false, true, 1562, "1734: _1519 -> (BAND I8 con _1518)", null, null, null, 0L, false, false, new int[]{19, 1561}, null);
        CodeGenerator_x86simd.rulev[1736] = new Rule(1736, false, true, 1564, "1736: _1521 -> (BAND I8 con _1520)", null, null, null, 0L, false, false, new int[]{19, 1563}, null);
        CodeGenerator_x86simd.rulev[1740] = new Rule(1740, false, true, 1568, "1740: _1525 -> (BAND I8 con _1524)", null, null, null, 0L, false, false, new int[]{19, 1567}, null);
        CodeGenerator_x86simd.rulev[1742] = new Rule(1742, false, true, 1570, "1742: _1527 -> (BAND I8 con _1526)", null, null, null, 0L, false, false, new int[]{19, 1569}, null);
        CodeGenerator_x86simd.rulev[1746] = new Rule(1746, false, true, 1574, "1746: _1531 -> (BAND I8 con _1530)", null, null, null, 0L, false, false, new int[]{19, 1573}, null);
        CodeGenerator_x86simd.rulev[1748] = new Rule(1748, false, true, 1576, "1748: _1533 -> (BAND I8 con _1532)", null, null, null, 0L, false, false, new int[]{19, 1575}, null);
        CodeGenerator_x86simd.rulev[1752] = new Rule(1752, false, true, 1580, "1752: _1537 -> (BAND I8 con _1536)", null, null, null, 0L, false, false, new int[]{19, 1579}, null);
        CodeGenerator_x86simd.rulev[1754] = new Rule(1754, false, true, 1582, "1754: _1539 -> (BAND I8 con _1538)", null, null, null, 0L, false, false, new int[]{19, 1581}, null);
        CodeGenerator_x86simd.rulev[1758] = new Rule(1758, false, true, 1586, "1758: _1543 -> (BAND I8 con _1542)", null, null, null, 0L, false, false, new int[]{19, 1585}, null);
        CodeGenerator_x86simd.rulev[1760] = new Rule(1760, false, true, 1588, "1760: _1545 -> (BAND I8 con _1544)", null, null, null, 0L, false, false, new int[]{19, 1587}, null);
        CodeGenerator_x86simd.rulev[1764] = new Rule(1764, false, true, 1592, "1764: _1549 -> (BAND I8 con _1548)", null, null, null, 0L, false, false, new int[]{19, 1591}, null);
        CodeGenerator_x86simd.rulev[1766] = new Rule(1766, false, true, 1594, "1766: _1551 -> (BAND I8 con _1550)", null, null, null, 0L, false, false, new int[]{19, 1593}, null);
        CodeGenerator_x86simd.rulev[1770] = new Rule(1770, false, true, 1598, "1770: _1555 -> (BAND I8 con _1554)", null, null, null, 0L, false, false, new int[]{19, 1597}, null);
        CodeGenerator_x86simd.rulev[1772] = new Rule(1772, false, true, 1600, "1772: _1557 -> (BAND I8 con _1556)", null, null, null, 0L, false, false, new int[]{19, 1599}, null);
        CodeGenerator_x86simd.rulev[1776] = new Rule(1776, false, true, 1604, "1776: _1561 -> (BAND I8 con _1560)", null, null, null, 0L, false, false, new int[]{19, 1603}, null);
        CodeGenerator_x86simd.rulev[1778] = new Rule(1778, false, true, 1606, "1778: _1563 -> (BAND I8 con _1562)", null, null, null, 0L, false, false, new int[]{19, 1605}, null);
        CodeGenerator_x86simd.rulev[1782] = new Rule(1782, false, true, 1610, "1782: _1567 -> (BAND I8 con _1566)", null, null, null, 0L, false, false, new int[]{19, 1609}, null);
        CodeGenerator_x86simd.rulev[1784] = new Rule(1784, false, true, 1612, "1784: _1569 -> (BAND I8 con _1568)", null, null, null, 0L, false, false, new int[]{19, 1611}, null);
        CodeGenerator_x86simd.rulev[1788] = new Rule(1788, false, true, 1616, "1788: _1573 -> (BAND I8 con _1572)", null, null, null, 0L, false, false, new int[]{19, 1615}, null);
        CodeGenerator_x86simd.rulev[1790] = new Rule(1790, false, true, 1618, "1790: _1575 -> (BAND I8 con _1574)", null, null, null, 0L, false, false, new int[]{19, 1617}, null);
        CodeGenerator_x86simd.rulev[1794] = new Rule(1794, false, true, 1622, "1794: _1579 -> (BAND I8 con _1578)", null, null, null, 0L, false, false, new int[]{19, 1621}, null);
        CodeGenerator_x86simd.rulev[1796] = new Rule(1796, false, true, 1624, "1796: _1581 -> (BAND I8 con _1580)", null, null, null, 0L, false, false, new int[]{19, 1623}, null);
        CodeGenerator_x86simd.rulev[1800] = new Rule(1800, false, true, 1628, "1800: _1585 -> (BAND I8 con _1584)", null, null, null, 0L, false, false, new int[]{19, 1627}, null);
        CodeGenerator_x86simd.rulev[1802] = new Rule(1802, false, true, 1630, "1802: _1587 -> (BAND I8 con _1586)", null, null, null, 0L, false, false, new int[]{19, 1629}, null);
        CodeGenerator_x86simd.rulev[1955] = new Rule(1955, false, true, 1778, "1955: _1735 -> (BAND I8 con _1734)", null, null, null, 0L, false, false, new int[]{19, 1777}, null);
        CodeGenerator_x86simd.rulev[1957] = new Rule(1957, false, true, 1780, "1957: _1737 -> (BAND I8 con _1736)", null, null, null, 0L, false, false, new int[]{19, 1779}, null);
        CodeGenerator_x86simd.rulev[1961] = new Rule(1961, false, true, 1784, "1961: _1741 -> (BAND I8 con _1740)", null, null, null, 0L, false, false, new int[]{19, 1783}, null);
        CodeGenerator_x86simd.rulev[1963] = new Rule(1963, false, true, 1786, "1963: _1743 -> (BAND I8 con _1742)", null, null, null, 0L, false, false, new int[]{19, 1785}, null);
        CodeGenerator_x86simd.rulev[1967] = new Rule(1967, false, true, 1790, "1967: _1747 -> (BAND I8 con _1746)", null, null, null, 0L, false, false, new int[]{19, 1789}, null);
        CodeGenerator_x86simd.rulev[1969] = new Rule(1969, false, true, 1792, "1969: _1749 -> (BAND I8 con _1748)", null, null, null, 0L, false, false, new int[]{19, 1791}, null);
        CodeGenerator_x86simd.rulev[1973] = new Rule(1973, false, true, 1796, "1973: _1753 -> (BAND I8 con _1752)", null, null, null, 0L, false, false, new int[]{19, 1795}, null);
        CodeGenerator_x86simd.rulev[1975] = new Rule(1975, false, true, 1798, "1975: _1755 -> (BAND I8 con _1754)", null, null, null, 0L, false, false, new int[]{19, 1797}, null);
        CodeGenerator_x86simd.rulev[1979] = new Rule(1979, false, true, 1802, "1979: _1759 -> (BAND I8 con _1758)", null, null, null, 0L, false, false, new int[]{19, 1801}, null);
        CodeGenerator_x86simd.rulev[1981] = new Rule(1981, false, true, 1804, "1981: _1761 -> (BAND I8 con _1760)", null, null, null, 0L, false, false, new int[]{19, 1803}, null);
        CodeGenerator_x86simd.rulev[1985] = new Rule(1985, false, true, 1808, "1985: _1765 -> (BAND I8 con _1764)", null, null, null, 0L, false, false, new int[]{19, 1807}, null);
        CodeGenerator_x86simd.rulev[1987] = new Rule(1987, false, true, 1810, "1987: _1767 -> (BAND I8 con _1766)", null, null, null, 0L, false, false, new int[]{19, 1809}, null);
        CodeGenerator_x86simd.rulev[1991] = new Rule(1991, false, true, 1814, "1991: _1771 -> (BAND I8 con _1770)", null, null, null, 0L, false, false, new int[]{19, 1813}, null);
        CodeGenerator_x86simd.rulev[1993] = new Rule(1993, false, true, 1816, "1993: _1773 -> (BAND I8 con _1772)", null, null, null, 0L, false, false, new int[]{19, 1815}, null);
        CodeGenerator_x86simd.rulev[1997] = new Rule(1997, false, true, 1820, "1997: _1777 -> (BAND I8 con _1776)", null, null, null, 0L, false, false, new int[]{19, 1819}, null);
        CodeGenerator_x86simd.rulev[1999] = new Rule(1999, false, true, 1822, "1999: _1779 -> (BAND I8 con _1778)", null, null, null, 0L, false, false, new int[]{19, 1821}, null);
        CodeGenerator_x86simd.rulev[2003] = new Rule(2003, false, true, 1825, "2003: _1782 -> (BAND I8 con _270)", null, null, null, 0L, false, false, new int[]{19, 313}, null);
        CodeGenerator_x86simd.rulev[2004] = new Rule(2004, false, true, 1826, "2004: _1783 -> (BAND I8 con _272)", null, null, null, 0L, false, false, new int[]{19, 315}, null);
        CodeGenerator_x86simd.rulev[2007] = new Rule(2007, false, true, 1829, "2007: _1786 -> (BAND I8 con _276)", null, null, null, 0L, false, false, new int[]{19, 319}, null);
        CodeGenerator_x86simd.rulev[2008] = new Rule(2008, false, true, 1830, "2008: _1787 -> (BAND I8 con _278)", null, null, null, 0L, false, false, new int[]{19, 321}, null);
        CodeGenerator_x86simd.rulev[2011] = new Rule(2011, false, true, 1833, "2011: _1790 -> (BAND I8 con _283)", null, null, null, 0L, false, false, new int[]{19, 326}, null);
        CodeGenerator_x86simd.rulev[2012] = new Rule(2012, false, true, 1834, "2012: _1791 -> (BAND I8 con _285)", null, null, null, 0L, false, false, new int[]{19, 328}, null);
        CodeGenerator_x86simd.rulev[2015] = new Rule(2015, false, true, 1837, "2015: _1794 -> (BAND I8 con _290)", null, null, null, 0L, false, false, new int[]{19, 333}, null);
        CodeGenerator_x86simd.rulev[2016] = new Rule(2016, false, true, 1838, "2016: _1795 -> (BAND I8 con _292)", null, null, null, 0L, false, false, new int[]{19, 335}, null);
        CodeGenerator_x86simd.rulev[2019] = new Rule(2019, false, true, 1841, "2019: _1798 -> (BAND I8 con _297)", null, null, null, 0L, false, false, new int[]{19, 340}, null);
        CodeGenerator_x86simd.rulev[2020] = new Rule(2020, false, true, 1842, "2020: _1799 -> (BAND I8 con _299)", null, null, null, 0L, false, false, new int[]{19, 342}, null);
        CodeGenerator_x86simd.rulev[2023] = new Rule(2023, false, true, 1845, "2023: _1802 -> (BAND I8 con _304)", null, null, null, 0L, false, false, new int[]{19, 347}, null);
        CodeGenerator_x86simd.rulev[2024] = new Rule(2024, false, true, 1846, "2024: _1803 -> (BAND I8 con _306)", null, null, null, 0L, false, false, new int[]{19, 349}, null);
        CodeGenerator_x86simd.rulev[2027] = new Rule(2027, false, true, 1849, "2027: _1806 -> (BAND I8 con _311)", null, null, null, 0L, false, false, new int[]{19, 354}, null);
        CodeGenerator_x86simd.rulev[2028] = new Rule(2028, false, true, 1850, "2028: _1807 -> (BAND I8 con _313)", null, null, null, 0L, false, false, new int[]{19, 356}, null);
        CodeGenerator_x86simd.rulev[2031] = new Rule(2031, false, true, 1853, "2031: _1810 -> (BAND I8 con _318)", null, null, null, 0L, false, false, new int[]{19, 361}, null);
        CodeGenerator_x86simd.rulev[2032] = new Rule(2032, false, true, 1854, "2032: _1811 -> (BAND I8 con _320)", null, null, null, 0L, false, false, new int[]{19, 363}, null);
        CodeGenerator_x86simd.rulev[2113] = new Rule(2113, false, true, 1930, "2113: _1887 -> (BAND I8 con _1886)", null, null, null, 0L, false, false, new int[]{19, 1929}, null);
        CodeGenerator_x86simd.rulev[2115] = new Rule(2115, false, true, 1932, "2115: _1889 -> (BAND I8 con _1888)", null, null, null, 0L, false, false, new int[]{19, 1931}, null);
        CodeGenerator_x86simd.rulev[2119] = new Rule(2119, false, true, 1936, "2119: _1893 -> (BAND I8 con _1892)", null, null, null, 0L, false, false, new int[]{19, 1935}, null);
        CodeGenerator_x86simd.rulev[2121] = new Rule(2121, false, true, 1938, "2121: _1895 -> (BAND I8 con _1894)", null, null, null, 0L, false, false, new int[]{19, 1937}, null);
        CodeGenerator_x86simd.rulev[2125] = new Rule(2125, false, true, 1942, "2125: _1899 -> (BAND I8 con _1898)", null, null, null, 0L, false, false, new int[]{19, 1941}, null);
        CodeGenerator_x86simd.rulev[2127] = new Rule(2127, false, true, 1944, "2127: _1901 -> (BAND I8 con _1900)", null, null, null, 0L, false, false, new int[]{19, 1943}, null);
        CodeGenerator_x86simd.rulev[2131] = new Rule(2131, false, true, 1948, "2131: _1905 -> (BAND I8 con _1904)", null, null, null, 0L, false, false, new int[]{19, 1947}, null);
        CodeGenerator_x86simd.rulev[2133] = new Rule(2133, false, true, 1950, "2133: _1907 -> (BAND I8 con _1906)", null, null, null, 0L, false, false, new int[]{19, 1949}, null);
        CodeGenerator_x86simd.rulev[2137] = new Rule(2137, false, true, 1954, "2137: _1911 -> (BAND I8 con _1910)", null, null, null, 0L, false, false, new int[]{19, 1953}, null);
        CodeGenerator_x86simd.rulev[2139] = new Rule(2139, false, true, 1956, "2139: _1913 -> (BAND I8 con _1912)", null, null, null, 0L, false, false, new int[]{19, 1955}, null);
        CodeGenerator_x86simd.rulev[2143] = new Rule(2143, false, true, 1960, "2143: _1917 -> (BAND I8 con _1916)", null, null, null, 0L, false, false, new int[]{19, 1959}, null);
        CodeGenerator_x86simd.rulev[2145] = new Rule(2145, false, true, 1962, "2145: _1919 -> (BAND I8 con _1918)", null, null, null, 0L, false, false, new int[]{19, 1961}, null);
        CodeGenerator_x86simd.rulev[2149] = new Rule(2149, false, true, 1966, "2149: _1923 -> (BAND I8 con _1922)", null, null, null, 0L, false, false, new int[]{19, 1965}, null);
    }

    private static void rrinit900() {
        CodeGenerator_x86simd.rulev[2151] = new Rule(2151, false, true, 1968, "2151: _1925 -> (BAND I8 con _1924)", null, null, null, 0L, false, false, new int[]{19, 1967}, null);
        CodeGenerator_x86simd.rulev[2155] = new Rule(2155, false, true, 1972, "2155: _1929 -> (BAND I8 con _1928)", null, null, null, 0L, false, false, new int[]{19, 1971}, null);
        CodeGenerator_x86simd.rulev[2157] = new Rule(2157, false, true, 1974, "2157: _1931 -> (BAND I8 con _1930)", null, null, null, 0L, false, false, new int[]{19, 1973}, null);
        CodeGenerator_x86simd.rulev[2161] = new Rule(2161, false, true, 1978, "2161: _1935 -> (BAND I8 con _1934)", null, null, null, 0L, false, false, new int[]{19, 1977}, null);
        CodeGenerator_x86simd.rulev[2163] = new Rule(2163, false, true, 1980, "2163: _1937 -> (BAND I8 con _1936)", null, null, null, 0L, false, false, new int[]{19, 1979}, null);
        CodeGenerator_x86simd.rulev[2167] = new Rule(2167, false, true, 1984, "2167: _1941 -> (BAND I8 con _1940)", null, null, null, 0L, false, false, new int[]{19, 1983}, null);
        CodeGenerator_x86simd.rulev[2169] = new Rule(2169, false, true, 1986, "2169: _1943 -> (BAND I8 con _1942)", null, null, null, 0L, false, false, new int[]{19, 1985}, null);
        CodeGenerator_x86simd.rulev[2173] = new Rule(2173, false, true, 1990, "2173: _1947 -> (BAND I8 con _1946)", null, null, null, 0L, false, false, new int[]{19, 1989}, null);
        CodeGenerator_x86simd.rulev[2175] = new Rule(2175, false, true, 1992, "2175: _1949 -> (BAND I8 con _1948)", null, null, null, 0L, false, false, new int[]{19, 1991}, null);
        CodeGenerator_x86simd.rulev[2179] = new Rule(2179, false, true, 1996, "2179: _1953 -> (BAND I8 con _1952)", null, null, null, 0L, false, false, new int[]{19, 1995}, null);
        CodeGenerator_x86simd.rulev[2181] = new Rule(2181, false, true, 1998, "2181: _1955 -> (BAND I8 con _1954)", null, null, null, 0L, false, false, new int[]{19, 1997}, null);
        CodeGenerator_x86simd.rulev[2185] = new Rule(2185, false, true, 2002, "2185: _1959 -> (BAND I8 con _1958)", null, null, null, 0L, false, false, new int[]{19, 2001}, null);
        CodeGenerator_x86simd.rulev[2187] = new Rule(2187, false, true, 2004, "2187: _1961 -> (BAND I8 con _1960)", null, null, null, 0L, false, false, new int[]{19, 2003}, null);
        CodeGenerator_x86simd.rulev[2191] = new Rule(2191, false, true, 2008, "2191: _1965 -> (BAND I8 con _1964)", null, null, null, 0L, false, false, new int[]{19, 2007}, null);
        CodeGenerator_x86simd.rulev[2193] = new Rule(2193, false, true, 2010, "2193: _1967 -> (BAND I8 con _1966)", null, null, null, 0L, false, false, new int[]{19, 2009}, null);
        CodeGenerator_x86simd.rulev[2197] = new Rule(2197, false, true, 2014, "2197: _1971 -> (BAND I8 con _1970)", null, null, null, 0L, false, false, new int[]{19, 2013}, null);
        CodeGenerator_x86simd.rulev[2199] = new Rule(2199, false, true, 2016, "2199: _1973 -> (BAND I8 con _1972)", null, null, null, 0L, false, false, new int[]{19, 2015}, null);
        CodeGenerator_x86simd.rulev[2203] = new Rule(2203, false, true, 2020, "2203: _1977 -> (BAND I8 con _1976)", null, null, null, 0L, false, false, new int[]{19, 2019}, null);
        CodeGenerator_x86simd.rulev[2205] = new Rule(2205, false, true, 2022, "2205: _1979 -> (BAND I8 con _1978)", null, null, null, 0L, false, false, new int[]{19, 2021}, null);
        CodeGenerator_x86simd.rulev[2209] = new Rule(2209, false, true, 2025, "2209: _1982 -> (BAND I8 con _325)", null, null, null, 0L, false, false, new int[]{19, 368}, null);
        CodeGenerator_x86simd.rulev[2210] = new Rule(2210, false, true, 2026, "2210: _1983 -> (BAND I8 con _327)", null, null, null, 0L, false, false, new int[]{19, 370}, null);
        CodeGenerator_x86simd.rulev[2213] = new Rule(2213, false, true, 2029, "2213: _1986 -> (BAND I8 con _331)", null, null, null, 0L, false, false, new int[]{19, 374}, null);
        CodeGenerator_x86simd.rulev[2214] = new Rule(2214, false, true, 2030, "2214: _1987 -> (BAND I8 con _333)", null, null, null, 0L, false, false, new int[]{19, 376}, null);
        CodeGenerator_x86simd.rulev[2217] = new Rule(2217, false, true, 2033, "2217: _1990 -> (BAND I8 con _338)", null, null, null, 0L, false, false, new int[]{19, 381}, null);
        CodeGenerator_x86simd.rulev[2218] = new Rule(2218, false, true, 2034, "2218: _1991 -> (BAND I8 con _340)", null, null, null, 0L, false, false, new int[]{19, 383}, null);
        CodeGenerator_x86simd.rulev[2221] = new Rule(2221, false, true, 2037, "2221: _1994 -> (BAND I8 con _345)", null, null, null, 0L, false, false, new int[]{19, 388}, null);
        CodeGenerator_x86simd.rulev[2222] = new Rule(2222, false, true, 2038, "2222: _1995 -> (BAND I8 con _347)", null, null, null, 0L, false, false, new int[]{19, 390}, null);
        CodeGenerator_x86simd.rulev[2225] = new Rule(2225, false, true, 2041, "2225: _1998 -> (BAND I8 con _352)", null, null, null, 0L, false, false, new int[]{19, 395}, null);
        CodeGenerator_x86simd.rulev[2226] = new Rule(2226, false, true, 2042, "2226: _1999 -> (BAND I8 con _354)", null, null, null, 0L, false, false, new int[]{19, 397}, null);
        CodeGenerator_x86simd.rulev[2229] = new Rule(2229, false, true, 2045, "2229: _2002 -> (BAND I8 con _359)", null, null, null, 0L, false, false, new int[]{19, 402}, null);
        CodeGenerator_x86simd.rulev[2230] = new Rule(2230, false, true, 2046, "2230: _2003 -> (BAND I8 con _361)", null, null, null, 0L, false, false, new int[]{19, 404}, null);
        CodeGenerator_x86simd.rulev[2233] = new Rule(2233, false, true, 2049, "2233: _2006 -> (BAND I8 con _366)", null, null, null, 0L, false, false, new int[]{19, 409}, null);
        CodeGenerator_x86simd.rulev[2234] = new Rule(2234, false, true, 2050, "2234: _2007 -> (BAND I8 con _368)", null, null, null, 0L, false, false, new int[]{19, 411}, null);
        CodeGenerator_x86simd.rulev[2237] = new Rule(2237, false, true, 2053, "2237: _2010 -> (BAND I8 con _373)", null, null, null, 0L, false, false, new int[]{19, 416}, null);
        CodeGenerator_x86simd.rulev[2238] = new Rule(2238, false, true, 2054, "2238: _2011 -> (BAND I8 con _375)", null, null, null, 0L, false, false, new int[]{19, 418}, null);
        CodeGenerator_x86simd.rulev[2241] = new Rule(2241, false, true, 2057, "2241: _2014 -> (BAND I8 con _381)", null, null, null, 0L, false, false, new int[]{19, 424}, null);
        CodeGenerator_x86simd.rulev[2242] = new Rule(2242, false, true, 2058, "2242: _2015 -> (BAND I8 con _383)", null, null, null, 0L, false, false, new int[]{19, 426}, null);
        CodeGenerator_x86simd.rulev[2245] = new Rule(2245, false, true, 2061, "2245: _2018 -> (BAND I8 con _387)", null, null, null, 0L, false, false, new int[]{19, 430}, null);
        CodeGenerator_x86simd.rulev[2246] = new Rule(2246, false, true, 2062, "2246: _2019 -> (BAND I8 con _389)", null, null, null, 0L, false, false, new int[]{19, 432}, null);
        CodeGenerator_x86simd.rulev[2249] = new Rule(2249, false, true, 2065, "2249: _2022 -> (BAND I8 con _394)", null, null, null, 0L, false, false, new int[]{19, 437}, null);
        CodeGenerator_x86simd.rulev[2250] = new Rule(2250, false, true, 2066, "2250: _2023 -> (BAND I8 con _396)", null, null, null, 0L, false, false, new int[]{19, 439}, null);
        CodeGenerator_x86simd.rulev[2253] = new Rule(2253, false, true, 2069, "2253: _2026 -> (BAND I8 con _401)", null, null, null, 0L, false, false, new int[]{19, 444}, null);
        CodeGenerator_x86simd.rulev[2254] = new Rule(2254, false, true, 2070, "2254: _2027 -> (BAND I8 con _403)", null, null, null, 0L, false, false, new int[]{19, 446}, null);
        CodeGenerator_x86simd.rulev[2257] = new Rule(2257, false, true, 2073, "2257: _2030 -> (BAND I8 con _408)", null, null, null, 0L, false, false, new int[]{19, 451}, null);
        CodeGenerator_x86simd.rulev[2258] = new Rule(2258, false, true, 2074, "2258: _2031 -> (BAND I8 con _410)", null, null, null, 0L, false, false, new int[]{19, 453}, null);
        CodeGenerator_x86simd.rulev[2261] = new Rule(2261, false, true, 2077, "2261: _2034 -> (BAND I8 con _415)", null, null, null, 0L, false, false, new int[]{19, 458}, null);
        CodeGenerator_x86simd.rulev[2262] = new Rule(2262, false, true, 2078, "2262: _2035 -> (BAND I8 con _417)", null, null, null, 0L, false, false, new int[]{19, 460}, null);
        CodeGenerator_x86simd.rulev[2265] = new Rule(2265, false, true, 2081, "2265: _2038 -> (BAND I8 con _422)", null, null, null, 0L, false, false, new int[]{19, 465}, null);
        CodeGenerator_x86simd.rulev[2266] = new Rule(2266, false, true, 2082, "2266: _2039 -> (BAND I8 con _424)", null, null, null, 0L, false, false, new int[]{19, 467}, null);
        CodeGenerator_x86simd.rulev[2269] = new Rule(2269, false, true, 2085, "2269: _2042 -> (BAND I8 con _429)", null, null, null, 0L, false, false, new int[]{19, 472}, null);
        CodeGenerator_x86simd.rulev[2270] = new Rule(2270, false, true, 2086, "2270: _2043 -> (BAND I8 con _431)", null, null, null, 0L, false, false, new int[]{19, 474}, null);
        CodeGenerator_x86simd.rulev[2423] = new Rule(2423, false, true, 2234, "2423: _2191 -> (BAND I8 con _2190)", null, null, null, 0L, false, false, new int[]{19, 2233}, null);
        CodeGenerator_x86simd.rulev[2425] = new Rule(2425, false, true, 2236, "2425: _2193 -> (BAND I8 con _2192)", null, null, null, 0L, false, false, new int[]{19, 2235}, null);
        CodeGenerator_x86simd.rulev[2429] = new Rule(2429, false, true, 2240, "2429: _2197 -> (BAND I8 con _2196)", null, null, null, 0L, false, false, new int[]{19, 2239}, null);
        CodeGenerator_x86simd.rulev[2431] = new Rule(2431, false, true, 2242, "2431: _2199 -> (BAND I8 con _2198)", null, null, null, 0L, false, false, new int[]{19, 2241}, null);
        CodeGenerator_x86simd.rulev[2435] = new Rule(2435, false, true, 2246, "2435: _2203 -> (BAND I8 con _2202)", null, null, null, 0L, false, false, new int[]{19, 2245}, null);
        CodeGenerator_x86simd.rulev[2437] = new Rule(2437, false, true, 2248, "2437: _2205 -> (BAND I8 con _2204)", null, null, null, 0L, false, false, new int[]{19, 2247}, null);
        CodeGenerator_x86simd.rulev[2441] = new Rule(2441, false, true, 2252, "2441: _2209 -> (BAND I8 con _2208)", null, null, null, 0L, false, false, new int[]{19, 2251}, null);
        CodeGenerator_x86simd.rulev[2443] = new Rule(2443, false, true, 2254, "2443: _2211 -> (BAND I8 con _2210)", null, null, null, 0L, false, false, new int[]{19, 2253}, null);
        CodeGenerator_x86simd.rulev[2447] = new Rule(2447, false, true, 2258, "2447: _2215 -> (BAND I8 con _2214)", null, null, null, 0L, false, false, new int[]{19, 2257}, null);
        CodeGenerator_x86simd.rulev[2449] = new Rule(2449, false, true, 2260, "2449: _2217 -> (BAND I8 con _2216)", null, null, null, 0L, false, false, new int[]{19, 2259}, null);
        CodeGenerator_x86simd.rulev[2453] = new Rule(2453, false, true, 2264, "2453: _2221 -> (BAND I8 con _2220)", null, null, null, 0L, false, false, new int[]{19, 2263}, null);
        CodeGenerator_x86simd.rulev[2455] = new Rule(2455, false, true, 2266, "2455: _2223 -> (BAND I8 con _2222)", null, null, null, 0L, false, false, new int[]{19, 2265}, null);
        CodeGenerator_x86simd.rulev[2459] = new Rule(2459, false, true, 2270, "2459: _2227 -> (BAND I8 con _2226)", null, null, null, 0L, false, false, new int[]{19, 2269}, null);
        CodeGenerator_x86simd.rulev[2461] = new Rule(2461, false, true, 2272, "2461: _2229 -> (BAND I8 con _2228)", null, null, null, 0L, false, false, new int[]{19, 2271}, null);
        CodeGenerator_x86simd.rulev[2465] = new Rule(2465, false, true, 2276, "2465: _2233 -> (BAND I8 con _2232)", null, null, null, 0L, false, false, new int[]{19, 2275}, null);
        CodeGenerator_x86simd.rulev[2467] = new Rule(2467, false, true, 2278, "2467: _2235 -> (BAND I8 con _2234)", null, null, null, 0L, false, false, new int[]{19, 2277}, null);
        CodeGenerator_x86simd.rulev[2502] = new Rule(2502, false, true, 2310, "2502: _2267 -> (BAND I8 con _2266)", null, null, null, 0L, false, false, new int[]{19, 2309}, null);
        CodeGenerator_x86simd.rulev[2504] = new Rule(2504, false, true, 2312, "2504: _2269 -> (BAND I8 con _2268)", null, null, null, 0L, false, false, new int[]{19, 2311}, null);
        CodeGenerator_x86simd.rulev[2508] = new Rule(2508, false, true, 2316, "2508: _2273 -> (BAND I8 con _2272)", null, null, null, 0L, false, false, new int[]{19, 2315}, null);
        CodeGenerator_x86simd.rulev[2510] = new Rule(2510, false, true, 2318, "2510: _2275 -> (BAND I8 con _2274)", null, null, null, 0L, false, false, new int[]{19, 2317}, null);
        CodeGenerator_x86simd.rulev[2514] = new Rule(2514, false, true, 2322, "2514: _2279 -> (BAND I8 con _2278)", null, null, null, 0L, false, false, new int[]{19, 2321}, null);
        CodeGenerator_x86simd.rulev[2516] = new Rule(2516, false, true, 2324, "2516: _2281 -> (BAND I8 con _2280)", null, null, null, 0L, false, false, new int[]{19, 2323}, null);
        CodeGenerator_x86simd.rulev[2520] = new Rule(2520, false, true, 2328, "2520: _2285 -> (BAND I8 con _2284)", null, null, null, 0L, false, false, new int[]{19, 2327}, null);
        CodeGenerator_x86simd.rulev[2522] = new Rule(2522, false, true, 2330, "2522: _2287 -> (BAND I8 con _2286)", null, null, null, 0L, false, false, new int[]{19, 2329}, null);
        CodeGenerator_x86simd.rulev[2526] = new Rule(2526, false, true, 2334, "2526: _2291 -> (BAND I8 con _2290)", null, null, null, 0L, false, false, new int[]{19, 2333}, null);
        CodeGenerator_x86simd.rulev[2528] = new Rule(2528, false, true, 2336, "2528: _2293 -> (BAND I8 con _2292)", null, null, null, 0L, false, false, new int[]{19, 2335}, null);
        CodeGenerator_x86simd.rulev[2532] = new Rule(2532, false, true, 2340, "2532: _2297 -> (BAND I8 con _2296)", null, null, null, 0L, false, false, new int[]{19, 2339}, null);
        CodeGenerator_x86simd.rulev[2534] = new Rule(2534, false, true, 2342, "2534: _2299 -> (BAND I8 con _2298)", null, null, null, 0L, false, false, new int[]{19, 2341}, null);
        CodeGenerator_x86simd.rulev[2538] = new Rule(2538, false, true, 2346, "2538: _2303 -> (BAND I8 con _2302)", null, null, null, 0L, false, false, new int[]{19, 2345}, null);
        CodeGenerator_x86simd.rulev[2540] = new Rule(2540, false, true, 2348, "2540: _2305 -> (BAND I8 con _2304)", null, null, null, 0L, false, false, new int[]{19, 2347}, null);
        CodeGenerator_x86simd.rulev[2544] = new Rule(2544, false, true, 2352, "2544: _2309 -> (BAND I8 con _2308)", null, null, null, 0L, false, false, new int[]{19, 2351}, null);
        CodeGenerator_x86simd.rulev[2546] = new Rule(2546, false, true, 2354, "2546: _2311 -> (BAND I8 con _2310)", null, null, null, 0L, false, false, new int[]{19, 2353}, null);
        CodeGenerator_x86simd.rulev[2550] = new Rule(2550, false, true, 2358, "2550: _2315 -> (BAND I8 con _2314)", null, null, null, 0L, false, false, new int[]{19, 2357}, null);
        CodeGenerator_x86simd.rulev[2552] = new Rule(2552, false, true, 2360, "2552: _2317 -> (BAND I8 con _2316)", null, null, null, 0L, false, false, new int[]{19, 2359}, null);
        CodeGenerator_x86simd.rulev[2556] = new Rule(2556, false, true, 2364, "2556: _2321 -> (BAND I8 con _2320)", null, null, null, 0L, false, false, new int[]{19, 2363}, null);
        CodeGenerator_x86simd.rulev[2558] = new Rule(2558, false, true, 2366, "2558: _2323 -> (BAND I8 con _2322)", null, null, null, 0L, false, false, new int[]{19, 2365}, null);
        CodeGenerator_x86simd.rulev[2562] = new Rule(2562, false, true, 2370, "2562: _2327 -> (BAND I8 con _2326)", null, null, null, 0L, false, false, new int[]{19, 2369}, null);
        CodeGenerator_x86simd.rulev[2564] = new Rule(2564, false, true, 2372, "2564: _2329 -> (BAND I8 con _2328)", null, null, null, 0L, false, false, new int[]{19, 2371}, null);
        CodeGenerator_x86simd.rulev[2568] = new Rule(2568, false, true, 2376, "2568: _2333 -> (BAND I8 con _2332)", null, null, null, 0L, false, false, new int[]{19, 2375}, null);
        CodeGenerator_x86simd.rulev[2570] = new Rule(2570, false, true, 2378, "2570: _2335 -> (BAND I8 con _2334)", null, null, null, 0L, false, false, new int[]{19, 2377}, null);
        CodeGenerator_x86simd.rulev[2574] = new Rule(2574, false, true, 2382, "2574: _2339 -> (BAND I8 con _2338)", null, null, null, 0L, false, false, new int[]{19, 2381}, null);
        CodeGenerator_x86simd.rulev[2576] = new Rule(2576, false, true, 2384, "2576: _2341 -> (BAND I8 con _2340)", null, null, null, 0L, false, false, new int[]{19, 2383}, null);
        CodeGenerator_x86simd.rulev[2580] = new Rule(2580, false, true, 2388, "2580: _2345 -> (BAND I8 con _2344)", null, null, null, 0L, false, false, new int[]{19, 2387}, null);
        CodeGenerator_x86simd.rulev[2582] = new Rule(2582, false, true, 2390, "2582: _2347 -> (BAND I8 con _2346)", null, null, null, 0L, false, false, new int[]{19, 2389}, null);
        CodeGenerator_x86simd.rulev[2586] = new Rule(2586, false, true, 2394, "2586: _2351 -> (BAND I8 con _2350)", null, null, null, 0L, false, false, new int[]{19, 2393}, null);
        CodeGenerator_x86simd.rulev[2588] = new Rule(2588, false, true, 2396, "2588: _2353 -> (BAND I8 con _2352)", null, null, null, 0L, false, false, new int[]{19, 2395}, null);
        CodeGenerator_x86simd.rulev[2592] = new Rule(2592, false, true, 2400, "2592: _2357 -> (BAND I8 con _2356)", null, null, null, 0L, false, false, new int[]{19, 2399}, null);
        CodeGenerator_x86simd.rulev[2594] = new Rule(2594, false, true, 2402, "2594: _2359 -> (BAND I8 con _2358)", null, null, null, 0L, false, false, new int[]{19, 2401}, null);
        CodeGenerator_x86simd.rulev[2657] = new Rule(2657, false, true, 2462, "2657: _2419 -> (BAND I8 con _2418)", null, null, null, 0L, false, false, new int[]{19, 2461}, null);
    }

    private static void rrinit1000() {
        CodeGenerator_x86simd.rulev[2659] = new Rule(2659, false, true, 2464, "2659: _2421 -> (BAND I8 con _2420)", null, null, null, 0L, false, false, new int[]{19, 2463}, null);
        CodeGenerator_x86simd.rulev[2663] = new Rule(2663, false, true, 2468, "2663: _2425 -> (BAND I8 con _2424)", null, null, null, 0L, false, false, new int[]{19, 2467}, null);
        CodeGenerator_x86simd.rulev[2665] = new Rule(2665, false, true, 2470, "2665: _2427 -> (BAND I8 con _2426)", null, null, null, 0L, false, false, new int[]{19, 2469}, null);
        CodeGenerator_x86simd.rulev[2669] = new Rule(2669, false, true, 2474, "2669: _2431 -> (BAND I8 con _2430)", null, null, null, 0L, false, false, new int[]{19, 2473}, null);
        CodeGenerator_x86simd.rulev[2671] = new Rule(2671, false, true, 2476, "2671: _2433 -> (BAND I8 con _2432)", null, null, null, 0L, false, false, new int[]{19, 2475}, null);
        CodeGenerator_x86simd.rulev[2675] = new Rule(2675, false, true, 2480, "2675: _2437 -> (BAND I8 con _2436)", null, null, null, 0L, false, false, new int[]{19, 2479}, null);
        CodeGenerator_x86simd.rulev[2677] = new Rule(2677, false, true, 2482, "2677: _2439 -> (BAND I8 con _2438)", null, null, null, 0L, false, false, new int[]{19, 2481}, null);
        CodeGenerator_x86simd.rulev[2681] = new Rule(2681, false, true, 2486, "2681: _2443 -> (BAND I8 con _2442)", null, null, null, 0L, false, false, new int[]{19, 2485}, null);
        CodeGenerator_x86simd.rulev[2683] = new Rule(2683, false, true, 2488, "2683: _2445 -> (BAND I8 con _2444)", null, null, null, 0L, false, false, new int[]{19, 2487}, null);
        CodeGenerator_x86simd.rulev[2687] = new Rule(2687, false, true, 2492, "2687: _2449 -> (BAND I8 con _2448)", null, null, null, 0L, false, false, new int[]{19, 2491}, null);
        CodeGenerator_x86simd.rulev[2689] = new Rule(2689, false, true, 2494, "2689: _2451 -> (BAND I8 con _2450)", null, null, null, 0L, false, false, new int[]{19, 2493}, null);
        CodeGenerator_x86simd.rulev[2693] = new Rule(2693, false, true, 2498, "2693: _2455 -> (BAND I8 con _2454)", null, null, null, 0L, false, false, new int[]{19, 2497}, null);
        CodeGenerator_x86simd.rulev[2695] = new Rule(2695, false, true, 2500, "2695: _2457 -> (BAND I8 con _2456)", null, null, null, 0L, false, false, new int[]{19, 2499}, null);
        CodeGenerator_x86simd.rulev[2699] = new Rule(2699, false, true, 2504, "2699: _2461 -> (BAND I8 con _2460)", null, null, null, 0L, false, false, new int[]{19, 2503}, null);
        CodeGenerator_x86simd.rulev[2701] = new Rule(2701, false, true, 2506, "2701: _2463 -> (BAND I8 con _2462)", null, null, null, 0L, false, false, new int[]{19, 2505}, null);
        CodeGenerator_x86simd.rulev[2736] = new Rule(2736, false, true, 2538, "2736: _2495 -> (BAND I8 con _2494)", null, null, null, 0L, false, false, new int[]{19, 2537}, null);
        CodeGenerator_x86simd.rulev[2738] = new Rule(2738, false, true, 2540, "2738: _2497 -> (BAND I8 con _2496)", null, null, null, 0L, false, false, new int[]{19, 2539}, null);
        CodeGenerator_x86simd.rulev[2742] = new Rule(2742, false, true, 2544, "2742: _2501 -> (BAND I8 con _2500)", null, null, null, 0L, false, false, new int[]{19, 2543}, null);
        CodeGenerator_x86simd.rulev[2744] = new Rule(2744, false, true, 2546, "2744: _2503 -> (BAND I8 con _2502)", null, null, null, 0L, false, false, new int[]{19, 2545}, null);
        CodeGenerator_x86simd.rulev[2748] = new Rule(2748, false, true, 2550, "2748: _2507 -> (BAND I8 con _2506)", null, null, null, 0L, false, false, new int[]{19, 2549}, null);
        CodeGenerator_x86simd.rulev[2750] = new Rule(2750, false, true, 2552, "2750: _2509 -> (BAND I8 con _2508)", null, null, null, 0L, false, false, new int[]{19, 2551}, null);
        CodeGenerator_x86simd.rulev[2754] = new Rule(2754, false, true, 2556, "2754: _2513 -> (BAND I8 con _2512)", null, null, null, 0L, false, false, new int[]{19, 2555}, null);
        CodeGenerator_x86simd.rulev[2756] = new Rule(2756, false, true, 2558, "2756: _2515 -> (BAND I8 con _2514)", null, null, null, 0L, false, false, new int[]{19, 2557}, null);
        CodeGenerator_x86simd.rulev[2760] = new Rule(2760, false, true, 2562, "2760: _2519 -> (BAND I8 con _2518)", null, null, null, 0L, false, false, new int[]{19, 2561}, null);
        CodeGenerator_x86simd.rulev[2762] = new Rule(2762, false, true, 2564, "2762: _2521 -> (BAND I8 con _2520)", null, null, null, 0L, false, false, new int[]{19, 2563}, null);
        CodeGenerator_x86simd.rulev[2766] = new Rule(2766, false, true, 2568, "2766: _2525 -> (BAND I8 con _2524)", null, null, null, 0L, false, false, new int[]{19, 2567}, null);
        CodeGenerator_x86simd.rulev[2768] = new Rule(2768, false, true, 2570, "2768: _2527 -> (BAND I8 con _2526)", null, null, null, 0L, false, false, new int[]{19, 2569}, null);
        CodeGenerator_x86simd.rulev[2772] = new Rule(2772, false, true, 2574, "2772: _2531 -> (BAND I8 con _2530)", null, null, null, 0L, false, false, new int[]{19, 2573}, null);
        CodeGenerator_x86simd.rulev[2774] = new Rule(2774, false, true, 2576, "2774: _2533 -> (BAND I8 con _2532)", null, null, null, 0L, false, false, new int[]{19, 2575}, null);
        CodeGenerator_x86simd.rulev[2778] = new Rule(2778, false, true, 2580, "2778: _2537 -> (BAND I8 con _2536)", null, null, null, 0L, false, false, new int[]{19, 2579}, null);
        CodeGenerator_x86simd.rulev[2780] = new Rule(2780, false, true, 2582, "2780: _2539 -> (BAND I8 con _2538)", null, null, null, 0L, false, false, new int[]{19, 2581}, null);
        CodeGenerator_x86simd.rulev[2784] = new Rule(2784, false, true, 2586, "2784: _2543 -> (BAND I8 con _2542)", null, null, null, 0L, false, false, new int[]{19, 2585}, null);
        CodeGenerator_x86simd.rulev[2786] = new Rule(2786, false, true, 2588, "2786: _2545 -> (BAND I8 con _2544)", null, null, null, 0L, false, false, new int[]{19, 2587}, null);
        CodeGenerator_x86simd.rulev[2790] = new Rule(2790, false, true, 2592, "2790: _2549 -> (BAND I8 con _2548)", null, null, null, 0L, false, false, new int[]{19, 2591}, null);
        CodeGenerator_x86simd.rulev[2792] = new Rule(2792, false, true, 2594, "2792: _2551 -> (BAND I8 con _2550)", null, null, null, 0L, false, false, new int[]{19, 2593}, null);
        CodeGenerator_x86simd.rulev[2796] = new Rule(2796, false, true, 2598, "2796: _2555 -> (BAND I8 con _2554)", null, null, null, 0L, false, false, new int[]{19, 2597}, null);
        CodeGenerator_x86simd.rulev[2798] = new Rule(2798, false, true, 2600, "2798: _2557 -> (BAND I8 con _2556)", null, null, null, 0L, false, false, new int[]{19, 2599}, null);
        CodeGenerator_x86simd.rulev[2802] = new Rule(2802, false, true, 2604, "2802: _2561 -> (BAND I8 con _2560)", null, null, null, 0L, false, false, new int[]{19, 2603}, null);
        CodeGenerator_x86simd.rulev[2804] = new Rule(2804, false, true, 2606, "2804: _2563 -> (BAND I8 con _2562)", null, null, null, 0L, false, false, new int[]{19, 2605}, null);
        CodeGenerator_x86simd.rulev[2808] = new Rule(2808, false, true, 2610, "2808: _2567 -> (BAND I8 con _2566)", null, null, null, 0L, false, false, new int[]{19, 2609}, null);
        CodeGenerator_x86simd.rulev[2810] = new Rule(2810, false, true, 2612, "2810: _2569 -> (BAND I8 con _2568)", null, null, null, 0L, false, false, new int[]{19, 2611}, null);
        CodeGenerator_x86simd.rulev[2814] = new Rule(2814, false, true, 2616, "2814: _2573 -> (BAND I8 con _2572)", null, null, null, 0L, false, false, new int[]{19, 2615}, null);
        CodeGenerator_x86simd.rulev[2816] = new Rule(2816, false, true, 2618, "2816: _2575 -> (BAND I8 con _2574)", null, null, null, 0L, false, false, new int[]{19, 2617}, null);
        CodeGenerator_x86simd.rulev[2820] = new Rule(2820, false, true, 2622, "2820: _2579 -> (BAND I8 con _2578)", null, null, null, 0L, false, false, new int[]{19, 2621}, null);
        CodeGenerator_x86simd.rulev[2822] = new Rule(2822, false, true, 2624, "2822: _2581 -> (BAND I8 con _2580)", null, null, null, 0L, false, false, new int[]{19, 2623}, null);
        CodeGenerator_x86simd.rulev[2826] = new Rule(2826, false, true, 2628, "2826: _2585 -> (BAND I8 con _2584)", null, null, null, 0L, false, false, new int[]{19, 2627}, null);
        CodeGenerator_x86simd.rulev[2828] = new Rule(2828, false, true, 2630, "2828: _2587 -> (BAND I8 con _2586)", null, null, null, 0L, false, false, new int[]{19, 2629}, null);
        CodeGenerator_x86simd.rulev[3131] = new Rule(3131, false, true, 2906, "3131: _2863 -> (BAND I8 _2862 _101)", null, null, null, 0L, false, false, new int[]{2905, 144}, null);
        CodeGenerator_x86simd.rulev[3134] = new Rule(3134, false, true, 2909, "3134: _2866 -> (BAND I8 _2865 _103)", null, null, null, 0L, false, false, new int[]{2908, 146}, null);
        CodeGenerator_x86simd.rulev[3137] = new Rule(3137, false, true, 2912, "3137: _2869 -> (BAND I8 _2868 _105)", null, null, null, 0L, false, false, new int[]{2911, 148}, null);
        CodeGenerator_x86simd.rulev[3140] = new Rule(3140, false, true, 2915, "3140: _2872 -> (BAND I8 _2871 _107)", null, null, null, 0L, false, false, new int[]{2914, 150}, null);
        CodeGenerator_x86simd.rulev[3143] = new Rule(3143, false, true, 2918, "3143: _2875 -> (BAND I8 _2874 _111)", null, null, null, 0L, false, false, new int[]{2917, 154}, null);
        CodeGenerator_x86simd.rulev[3146] = new Rule(3146, false, true, 2921, "3146: _2878 -> (BAND I8 _2877 _113)", null, null, null, 0L, false, false, new int[]{2920, 156}, null);
        CodeGenerator_x86simd.rulev[3149] = new Rule(3149, false, true, 2924, "3149: _2881 -> (BAND I8 _2880 _115)", null, null, null, 0L, false, false, new int[]{2923, 158}, null);
        CodeGenerator_x86simd.rulev[3173] = new Rule(3173, false, true, 2945, "3173: _2902 -> (BAND I8 _2901 _7)", null, null, null, 0L, false, false, new int[]{2944, 50}, null);
        CodeGenerator_x86simd.rulev[3176] = new Rule(3176, false, true, 2948, "3176: _2905 -> (BAND I8 _2904 _9)", null, null, null, 0L, false, false, new int[]{2947, 52}, null);
        CodeGenerator_x86simd.rulev[3179] = new Rule(3179, false, true, 2951, "3179: _2908 -> (BAND I8 _2907 _11)", null, null, null, 0L, false, false, new int[]{2950, 54}, null);
        CodeGenerator_x86simd.rulev[3182] = new Rule(3182, false, true, 2954, "3182: _2911 -> (BAND I8 _2910 _13)", null, null, null, 0L, false, false, new int[]{2953, 56}, null);
        CodeGenerator_x86simd.rulev[3185] = new Rule(3185, false, true, 2957, "3185: _2914 -> (BAND I8 _2913 _15)", null, null, null, 0L, false, false, new int[]{2956, 58}, null);
        CodeGenerator_x86simd.rulev[3188] = new Rule(3188, false, true, 2960, "3188: _2917 -> (BAND I8 _2916 _18)", null, null, null, 0L, false, false, new int[]{2959, 61}, null);
        CodeGenerator_x86simd.rulev[3191] = new Rule(3191, false, true, 2963, "3191: _2920 -> (BAND I8 _2919 _21)", null, null, null, 0L, false, false, new int[]{2962, 64}, null);
        CodeGenerator_x86simd.rulev[3194] = new Rule(3194, false, true, 2966, "3194: _2923 -> (BAND I8 _2922 _24)", null, null, null, 0L, false, false, new int[]{2965, 67}, null);
        CodeGenerator_x86simd.rulev[3197] = new Rule(3197, false, true, 2969, "3197: _2926 -> (BAND I8 _2925 _26)", null, null, null, 0L, false, false, new int[]{2968, 69}, null);
        CodeGenerator_x86simd.rulev[3200] = new Rule(3200, false, true, 2972, "3200: _2929 -> (BAND I8 _2928 _29)", null, null, null, 0L, false, false, new int[]{2971, 72}, null);
        CodeGenerator_x86simd.rulev[3203] = new Rule(3203, false, true, 2975, "3203: _2932 -> (BAND I8 _2931 _32)", null, null, null, 0L, false, false, new int[]{2974, 75}, null);
        CodeGenerator_x86simd.rulev[3206] = new Rule(3206, false, true, 2978, "3206: _2935 -> (BAND I8 _2934 _35)", null, null, null, 0L, false, false, new int[]{2977, 78}, null);
        CodeGenerator_x86simd.rulev[3209] = new Rule(3209, false, true, 2981, "3209: _2938 -> (BAND I8 _2937 _38)", null, null, null, 0L, false, false, new int[]{2980, 81}, null);
        CodeGenerator_x86simd.rulev[3212] = new Rule(3212, false, true, 2984, "3212: _2941 -> (BAND I8 _2940 _41)", null, null, null, 0L, false, false, new int[]{2983, 84}, null);
        CodeGenerator_x86simd.rulev[3215] = new Rule(3215, false, true, 2987, "3215: _2944 -> (BAND I8 _2943 _44)", null, null, null, 0L, false, false, new int[]{2986, 87}, null);
        CodeGenerator_x86simd.rulev[3218] = new Rule(3218, false, true, 2990, "3218: _2947 -> (BAND I8 _2946 _47)", null, null, null, 0L, false, false, new int[]{2989, 90}, null);
        CodeGenerator_x86simd.rulev[3277] = new Rule(3277, false, true, 3044, "3277: _3001 -> (BAND I8 _101 _101)", null, null, null, 0L, false, false, new int[]{144, 144}, null);
        CodeGenerator_x86simd.rulev[3279] = new Rule(3279, false, true, 3046, "3279: _3003 -> (BAND I8 _103 _103)", null, null, null, 0L, false, false, new int[]{146, 146}, null);
        CodeGenerator_x86simd.rulev[3281] = new Rule(3281, false, true, 3048, "3281: _3005 -> (BAND I8 _105 _105)", null, null, null, 0L, false, false, new int[]{148, 148}, null);
        CodeGenerator_x86simd.rulev[3283] = new Rule(3283, false, true, 3050, "3283: _3007 -> (BAND I8 _107 _107)", null, null, null, 0L, false, false, new int[]{150, 150}, null);
        CodeGenerator_x86simd.rulev[3285] = new Rule(3285, false, true, 3052, "3285: _3009 -> (BAND I8 _109 _109)", null, null, null, 0L, false, false, new int[]{152, 152}, null);
        CodeGenerator_x86simd.rulev[3287] = new Rule(3287, false, true, 3054, "3287: _3011 -> (BAND I8 _111 _111)", null, null, null, 0L, false, false, new int[]{154, 154}, null);
        CodeGenerator_x86simd.rulev[3289] = new Rule(3289, false, true, 3056, "3289: _3013 -> (BAND I8 _113 _113)", null, null, null, 0L, false, false, new int[]{156, 156}, null);
        CodeGenerator_x86simd.rulev[3291] = new Rule(3291, false, true, 3058, "3291: _3015 -> (BAND I8 _115 _115)", null, null, null, 0L, false, false, new int[]{158, 158}, null);
        CodeGenerator_x86simd.rulev[3425] = new Rule(3425, false, true, 3176, "3425: _3133 -> (BAND I8 _7 _7)", null, null, null, 0L, false, false, new int[]{50, 50}, null);
        CodeGenerator_x86simd.rulev[3427] = new Rule(3427, false, true, 3178, "3427: _3135 -> (BAND I8 _9 _9)", null, null, null, 0L, false, false, new int[]{52, 52}, null);
        CodeGenerator_x86simd.rulev[3429] = new Rule(3429, false, true, 3180, "3429: _3137 -> (BAND I8 _11 _11)", null, null, null, 0L, false, false, new int[]{54, 54}, null);
        CodeGenerator_x86simd.rulev[3431] = new Rule(3431, false, true, 3182, "3431: _3139 -> (BAND I8 _13 _13)", null, null, null, 0L, false, false, new int[]{56, 56}, null);
        CodeGenerator_x86simd.rulev[3433] = new Rule(3433, false, true, 3184, "3433: _3141 -> (BAND I8 _15 _15)", null, null, null, 0L, false, false, new int[]{58, 58}, null);
        CodeGenerator_x86simd.rulev[3435] = new Rule(3435, false, true, 3186, "3435: _3143 -> (BAND I8 _18 _18)", null, null, null, 0L, false, false, new int[]{61, 61}, null);
        CodeGenerator_x86simd.rulev[3437] = new Rule(3437, false, true, 3188, "3437: _3145 -> (BAND I8 _21 _21)", null, null, null, 0L, false, false, new int[]{64, 64}, null);
        CodeGenerator_x86simd.rulev[3439] = new Rule(3439, false, true, 3190, "3439: _3147 -> (BAND I8 _24 _24)", null, null, null, 0L, false, false, new int[]{67, 67}, null);
        CodeGenerator_x86simd.rulev[3441] = new Rule(3441, false, true, 3192, "3441: _3149 -> (BAND I8 _26 _26)", null, null, null, 0L, false, false, new int[]{69, 69}, null);
        CodeGenerator_x86simd.rulev[3443] = new Rule(3443, false, true, 3194, "3443: _3151 -> (BAND I8 _29 _29)", null, null, null, 0L, false, false, new int[]{72, 72}, null);
        CodeGenerator_x86simd.rulev[3445] = new Rule(3445, false, true, 3196, "3445: _3153 -> (BAND I8 _32 _32)", null, null, null, 0L, false, false, new int[]{75, 75}, null);
        CodeGenerator_x86simd.rulev[3447] = new Rule(3447, false, true, 3198, "3447: _3155 -> (BAND I8 _35 _35)", null, null, null, 0L, false, false, new int[]{78, 78}, null);
        CodeGenerator_x86simd.rulev[3449] = new Rule(3449, false, true, 3200, "3449: _3157 -> (BAND I8 _38 _38)", null, null, null, 0L, false, false, new int[]{81, 81}, null);
        CodeGenerator_x86simd.rulev[3451] = new Rule(3451, false, true, 3202, "3451: _3159 -> (BAND I8 _41 _41)", null, null, null, 0L, false, false, new int[]{84, 84}, null);
        CodeGenerator_x86simd.rulev[3453] = new Rule(3453, false, true, 3204, "3453: _3161 -> (BAND I8 _44 _44)", null, null, null, 0L, false, false, new int[]{87, 87}, null);
        CodeGenerator_x86simd.rulev[3455] = new Rule(3455, false, true, 3206, "3455: _3163 -> (BAND I8 _47 _47)", null, null, null, 0L, false, false, new int[]{90, 90}, null);
        CodeGenerator_x86simd.rulev[4010] = new Rule(4010, false, false, 7, "4010: regb -> (BAND I8 regb mrcb)", ImList.list(ImList.list("andb", "$2", "$0")), null, null, 2L, false, false, new int[]{7, 44}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[4027] = new Rule(4027, false, false, 7, "4027: regb -> (BAND I8 mrcb regb)", ImList.list(ImList.list("andb", "$1", "$0")), null, null, 4L, false, false, new int[]{44, 7}, new String[]{"*reg-I8*", null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[894] = new Rule(894, false, true, 740, "894: _697 -> (BAND I16 _696 _678)", null, null, null, 0L, false, false, new int[]{739, 721}, null);
        CodeGenerator_x86simd.rulev[900] = new Rule(900, false, true, 746, "900: _703 -> (BAND I16 _702 _678)", null, null, null, 0L, false, false, new int[]{745, 721}, null);
        CodeGenerator_x86simd.rulev[906] = new Rule(906, false, true, 752, "906: _709 -> (BAND I16 _708 _678)", null, null, null, 0L, false, false, new int[]{751, 721}, null);
        CodeGenerator_x86simd.rulev[912] = new Rule(912, false, true, 758, "912: _715 -> (BAND I16 _714 _678)", null, null, null, 0L, false, false, new int[]{757, 721}, null);
    }

    private static void rrinit1100() {
        CodeGenerator_x86simd.rulev[952] = new Rule(952, false, true, 796, "952: _753 -> (BAND I16 _752 _678)", null, null, null, 0L, false, false, new int[]{795, 721}, null);
        CodeGenerator_x86simd.rulev[958] = new Rule(958, false, true, 802, "958: _759 -> (BAND I16 _758 _678)", null, null, null, 0L, false, false, new int[]{801, 721}, null);
        CodeGenerator_x86simd.rulev[964] = new Rule(964, false, true, 808, "964: _765 -> (BAND I16 _764 _678)", null, null, null, 0L, false, false, new int[]{807, 721}, null);
        CodeGenerator_x86simd.rulev[970] = new Rule(970, false, true, 814, "970: _771 -> (BAND I16 _770 _678)", null, null, null, 0L, false, false, new int[]{813, 721}, null);
        CodeGenerator_x86simd.rulev[976] = new Rule(976, false, true, 820, "976: _777 -> (BAND I16 _776 _678)", null, null, null, 0L, false, false, new int[]{819, 721}, null);
        CodeGenerator_x86simd.rulev[982] = new Rule(982, false, true, 826, "982: _783 -> (BAND I16 _782 _678)", null, null, null, 0L, false, false, new int[]{825, 721}, null);
        CodeGenerator_x86simd.rulev[988] = new Rule(988, false, true, 832, "988: _789 -> (BAND I16 _788 _678)", null, null, null, 0L, false, false, new int[]{831, 721}, null);
        CodeGenerator_x86simd.rulev[994] = new Rule(994, false, true, 838, "994: _795 -> (BAND I16 _794 _678)", null, null, null, 0L, false, false, new int[]{837, 721}, null);
        CodeGenerator_x86simd.rulev[1291] = new Rule(1291, false, true, 1130, "1291: _1087 -> (BAND I16 _117 _1086)", null, null, null, 0L, false, false, new int[]{160, 1129}, null);
        CodeGenerator_x86simd.rulev[1293] = new Rule(1293, false, true, 1132, "1293: _1089 -> (BAND I16 _117 _1088)", null, null, null, 0L, false, false, new int[]{160, 1131}, null);
        CodeGenerator_x86simd.rulev[1297] = new Rule(1297, false, true, 1136, "1297: _1093 -> (BAND I16 _119 _1092)", null, null, null, 0L, false, false, new int[]{162, 1135}, null);
        CodeGenerator_x86simd.rulev[1299] = new Rule(1299, false, true, 1138, "1299: _1095 -> (BAND I16 _119 _1094)", null, null, null, 0L, false, false, new int[]{162, 1137}, null);
        CodeGenerator_x86simd.rulev[1303] = new Rule(1303, false, true, 1142, "1303: _1099 -> (BAND I16 _121 _1098)", null, null, null, 0L, false, false, new int[]{164, 1141}, null);
        CodeGenerator_x86simd.rulev[1305] = new Rule(1305, false, true, 1144, "1305: _1101 -> (BAND I16 _121 _1100)", null, null, null, 0L, false, false, new int[]{164, 1143}, null);
        CodeGenerator_x86simd.rulev[1309] = new Rule(1309, false, true, 1148, "1309: _1105 -> (BAND I16 _123 _1104)", null, null, null, 0L, false, false, new int[]{166, 1147}, null);
        CodeGenerator_x86simd.rulev[1311] = new Rule(1311, false, true, 1150, "1311: _1107 -> (BAND I16 _123 _1106)", null, null, null, 0L, false, false, new int[]{166, 1149}, null);
        CodeGenerator_x86simd.rulev[1316] = new Rule(1316, false, true, 1154, "1316: _1111 -> (BAND I16 _117 _1110)", null, null, null, 0L, false, false, new int[]{160, 1153}, null);
        CodeGenerator_x86simd.rulev[1318] = new Rule(1318, false, true, 1156, "1318: _1113 -> (BAND I16 _117 _1112)", null, null, null, 0L, false, false, new int[]{160, 1155}, null);
        CodeGenerator_x86simd.rulev[1322] = new Rule(1322, false, true, 1160, "1322: _1117 -> (BAND I16 _119 _1116)", null, null, null, 0L, false, false, new int[]{162, 1159}, null);
        CodeGenerator_x86simd.rulev[1324] = new Rule(1324, false, true, 1162, "1324: _1119 -> (BAND I16 _119 _1118)", null, null, null, 0L, false, false, new int[]{162, 1161}, null);
        CodeGenerator_x86simd.rulev[1328] = new Rule(1328, false, true, 1166, "1328: _1123 -> (BAND I16 _121 _1122)", null, null, null, 0L, false, false, new int[]{164, 1165}, null);
        CodeGenerator_x86simd.rulev[1330] = new Rule(1330, false, true, 1168, "1330: _1125 -> (BAND I16 _121 _1124)", null, null, null, 0L, false, false, new int[]{164, 1167}, null);
        CodeGenerator_x86simd.rulev[1334] = new Rule(1334, false, true, 1172, "1334: _1129 -> (BAND I16 _123 _1128)", null, null, null, 0L, false, false, new int[]{166, 1171}, null);
        CodeGenerator_x86simd.rulev[1336] = new Rule(1336, false, true, 1174, "1336: _1131 -> (BAND I16 _123 _1130)", null, null, null, 0L, false, false, new int[]{166, 1173}, null);
        CodeGenerator_x86simd.rulev[1341] = new Rule(1341, false, true, 1178, "1341: _1135 -> (BAND I16 _49 _1134)", null, null, null, 0L, false, false, new int[]{92, 1177}, null);
        CodeGenerator_x86simd.rulev[1343] = new Rule(1343, false, true, 1180, "1343: _1137 -> (BAND I16 _49 _1136)", null, null, null, 0L, false, false, new int[]{92, 1179}, null);
        CodeGenerator_x86simd.rulev[1347] = new Rule(1347, false, true, 1184, "1347: _1141 -> (BAND I16 _51 _1140)", null, null, null, 0L, false, false, new int[]{94, 1183}, null);
        CodeGenerator_x86simd.rulev[1349] = new Rule(1349, false, true, 1186, "1349: _1143 -> (BAND I16 _51 _1142)", null, null, null, 0L, false, false, new int[]{94, 1185}, null);
        CodeGenerator_x86simd.rulev[1353] = new Rule(1353, false, true, 1190, "1353: _1147 -> (BAND I16 _53 _1146)", null, null, null, 0L, false, false, new int[]{96, 1189}, null);
        CodeGenerator_x86simd.rulev[1355] = new Rule(1355, false, true, 1192, "1355: _1149 -> (BAND I16 _53 _1148)", null, null, null, 0L, false, false, new int[]{96, 1191}, null);
        CodeGenerator_x86simd.rulev[1359] = new Rule(1359, false, true, 1196, "1359: _1153 -> (BAND I16 _55 _1152)", null, null, null, 0L, false, false, new int[]{98, 1195}, null);
        CodeGenerator_x86simd.rulev[1361] = new Rule(1361, false, true, 1198, "1361: _1155 -> (BAND I16 _55 _1154)", null, null, null, 0L, false, false, new int[]{98, 1197}, null);
        CodeGenerator_x86simd.rulev[1365] = new Rule(1365, false, true, 1202, "1365: _1159 -> (BAND I16 _57 _1158)", null, null, null, 0L, false, false, new int[]{100, 1201}, null);
        CodeGenerator_x86simd.rulev[1367] = new Rule(1367, false, true, 1204, "1367: _1161 -> (BAND I16 _57 _1160)", null, null, null, 0L, false, false, new int[]{100, 1203}, null);
        CodeGenerator_x86simd.rulev[1371] = new Rule(1371, false, true, 1208, "1371: _1165 -> (BAND I16 _59 _1164)", null, null, null, 0L, false, false, new int[]{102, 1207}, null);
        CodeGenerator_x86simd.rulev[1373] = new Rule(1373, false, true, 1210, "1373: _1167 -> (BAND I16 _59 _1166)", null, null, null, 0L, false, false, new int[]{102, 1209}, null);
        CodeGenerator_x86simd.rulev[1377] = new Rule(1377, false, true, 1214, "1377: _1171 -> (BAND I16 _61 _1170)", null, null, null, 0L, false, false, new int[]{104, 1213}, null);
        CodeGenerator_x86simd.rulev[1379] = new Rule(1379, false, true, 1216, "1379: _1173 -> (BAND I16 _61 _1172)", null, null, null, 0L, false, false, new int[]{104, 1215}, null);
        CodeGenerator_x86simd.rulev[1383] = new Rule(1383, false, true, 1220, "1383: _1177 -> (BAND I16 _63 _1176)", null, null, null, 0L, false, false, new int[]{106, 1219}, null);
        CodeGenerator_x86simd.rulev[1385] = new Rule(1385, false, true, 1222, "1385: _1179 -> (BAND I16 _63 _1178)", null, null, null, 0L, false, false, new int[]{106, 1221}, null);
        CodeGenerator_x86simd.rulev[1390] = new Rule(1390, false, true, 1226, "1390: _1183 -> (BAND I16 _49 _1182)", null, null, null, 0L, false, false, new int[]{92, 1225}, null);
        CodeGenerator_x86simd.rulev[1392] = new Rule(1392, false, true, 1228, "1392: _1185 -> (BAND I16 _49 _1184)", null, null, null, 0L, false, false, new int[]{92, 1227}, null);
        CodeGenerator_x86simd.rulev[1396] = new Rule(1396, false, true, 1232, "1396: _1189 -> (BAND I16 _51 _1188)", null, null, null, 0L, false, false, new int[]{94, 1231}, null);
        CodeGenerator_x86simd.rulev[1398] = new Rule(1398, false, true, 1234, "1398: _1191 -> (BAND I16 _51 _1190)", null, null, null, 0L, false, false, new int[]{94, 1233}, null);
        CodeGenerator_x86simd.rulev[1402] = new Rule(1402, false, true, 1238, "1402: _1195 -> (BAND I16 _53 _1194)", null, null, null, 0L, false, false, new int[]{96, 1237}, null);
        CodeGenerator_x86simd.rulev[1404] = new Rule(1404, false, true, 1240, "1404: _1197 -> (BAND I16 _53 _1196)", null, null, null, 0L, false, false, new int[]{96, 1239}, null);
        CodeGenerator_x86simd.rulev[1408] = new Rule(1408, false, true, 1244, "1408: _1201 -> (BAND I16 _55 _1200)", null, null, null, 0L, false, false, new int[]{98, 1243}, null);
        CodeGenerator_x86simd.rulev[1410] = new Rule(1410, false, true, 1246, "1410: _1203 -> (BAND I16 _55 _1202)", null, null, null, 0L, false, false, new int[]{98, 1245}, null);
        CodeGenerator_x86simd.rulev[1414] = new Rule(1414, false, true, 1250, "1414: _1207 -> (BAND I16 _57 _1206)", null, null, null, 0L, false, false, new int[]{100, 1249}, null);
        CodeGenerator_x86simd.rulev[1416] = new Rule(1416, false, true, 1252, "1416: _1209 -> (BAND I16 _57 _1208)", null, null, null, 0L, false, false, new int[]{100, 1251}, null);
        CodeGenerator_x86simd.rulev[1420] = new Rule(1420, false, true, 1256, "1420: _1213 -> (BAND I16 _59 _1212)", null, null, null, 0L, false, false, new int[]{102, 1255}, null);
        CodeGenerator_x86simd.rulev[1422] = new Rule(1422, false, true, 1258, "1422: _1215 -> (BAND I16 _59 _1214)", null, null, null, 0L, false, false, new int[]{102, 1257}, null);
        CodeGenerator_x86simd.rulev[1426] = new Rule(1426, false, true, 1262, "1426: _1219 -> (BAND I16 _61 _1218)", null, null, null, 0L, false, false, new int[]{104, 1261}, null);
        CodeGenerator_x86simd.rulev[1428] = new Rule(1428, false, true, 1264, "1428: _1221 -> (BAND I16 _61 _1220)", null, null, null, 0L, false, false, new int[]{104, 1263}, null);
        CodeGenerator_x86simd.rulev[1432] = new Rule(1432, false, true, 1268, "1432: _1225 -> (BAND I16 _63 _1224)", null, null, null, 0L, false, false, new int[]{106, 1267}, null);
        CodeGenerator_x86simd.rulev[1434] = new Rule(1434, false, true, 1270, "1434: _1227 -> (BAND I16 _63 _1226)", null, null, null, 0L, false, false, new int[]{106, 1269}, null);
        CodeGenerator_x86simd.rulev[1537] = new Rule(1537, false, true, 1370, "1537: _1327 -> (BAND I16 con _1326)", null, null, null, 0L, false, false, new int[]{19, 1369}, null);
        CodeGenerator_x86simd.rulev[1539] = new Rule(1539, false, true, 1372, "1539: _1329 -> (BAND I16 con _1328)", null, null, null, 0L, false, false, new int[]{19, 1371}, null);
        CodeGenerator_x86simd.rulev[1543] = new Rule(1543, false, true, 1376, "1543: _1333 -> (BAND I16 con _1332)", null, null, null, 0L, false, false, new int[]{19, 1375}, null);
        CodeGenerator_x86simd.rulev[1545] = new Rule(1545, false, true, 1378, "1545: _1335 -> (BAND I16 con _1334)", null, null, null, 0L, false, false, new int[]{19, 1377}, null);
        CodeGenerator_x86simd.rulev[1549] = new Rule(1549, false, true, 1382, "1549: _1339 -> (BAND I16 con _1338)", null, null, null, 0L, false, false, new int[]{19, 1381}, null);
        CodeGenerator_x86simd.rulev[1551] = new Rule(1551, false, true, 1384, "1551: _1341 -> (BAND I16 con _1340)", null, null, null, 0L, false, false, new int[]{19, 1383}, null);
        CodeGenerator_x86simd.rulev[1555] = new Rule(1555, false, true, 1388, "1555: _1345 -> (BAND I16 con _1344)", null, null, null, 0L, false, false, new int[]{19, 1387}, null);
        CodeGenerator_x86simd.rulev[1557] = new Rule(1557, false, true, 1390, "1557: _1347 -> (BAND I16 con _1346)", null, null, null, 0L, false, false, new int[]{19, 1389}, null);
        CodeGenerator_x86simd.rulev[1562] = new Rule(1562, false, true, 1394, "1562: _1351 -> (BAND I16 con _1350)", null, null, null, 0L, false, false, new int[]{19, 1393}, null);
        CodeGenerator_x86simd.rulev[1564] = new Rule(1564, false, true, 1396, "1564: _1353 -> (BAND I16 con _1352)", null, null, null, 0L, false, false, new int[]{19, 1395}, null);
        CodeGenerator_x86simd.rulev[1568] = new Rule(1568, false, true, 1400, "1568: _1357 -> (BAND I16 con _1356)", null, null, null, 0L, false, false, new int[]{19, 1399}, null);
        CodeGenerator_x86simd.rulev[1570] = new Rule(1570, false, true, 1402, "1570: _1359 -> (BAND I16 con _1358)", null, null, null, 0L, false, false, new int[]{19, 1401}, null);
        CodeGenerator_x86simd.rulev[1574] = new Rule(1574, false, true, 1406, "1574: _1363 -> (BAND I16 con _1362)", null, null, null, 0L, false, false, new int[]{19, 1405}, null);
        CodeGenerator_x86simd.rulev[1576] = new Rule(1576, false, true, 1408, "1576: _1365 -> (BAND I16 con _1364)", null, null, null, 0L, false, false, new int[]{19, 1407}, null);
        CodeGenerator_x86simd.rulev[1580] = new Rule(1580, false, true, 1412, "1580: _1369 -> (BAND I16 con _1368)", null, null, null, 0L, false, false, new int[]{19, 1411}, null);
        CodeGenerator_x86simd.rulev[1582] = new Rule(1582, false, true, 1414, "1582: _1371 -> (BAND I16 con _1370)", null, null, null, 0L, false, false, new int[]{19, 1413}, null);
        CodeGenerator_x86simd.rulev[1807] = new Rule(1807, false, true, 1634, "1807: _1591 -> (BAND I16 con _1590)", null, null, null, 0L, false, false, new int[]{19, 1633}, null);
        CodeGenerator_x86simd.rulev[1809] = new Rule(1809, false, true, 1636, "1809: _1593 -> (BAND I16 con _1592)", null, null, null, 0L, false, false, new int[]{19, 1635}, null);
        CodeGenerator_x86simd.rulev[1813] = new Rule(1813, false, true, 1640, "1813: _1597 -> (BAND I16 con _1596)", null, null, null, 0L, false, false, new int[]{19, 1639}, null);
        CodeGenerator_x86simd.rulev[1815] = new Rule(1815, false, true, 1642, "1815: _1599 -> (BAND I16 con _1598)", null, null, null, 0L, false, false, new int[]{19, 1641}, null);
        CodeGenerator_x86simd.rulev[1819] = new Rule(1819, false, true, 1646, "1819: _1603 -> (BAND I16 con _1602)", null, null, null, 0L, false, false, new int[]{19, 1645}, null);
        CodeGenerator_x86simd.rulev[1821] = new Rule(1821, false, true, 1648, "1821: _1605 -> (BAND I16 con _1604)", null, null, null, 0L, false, false, new int[]{19, 1647}, null);
        CodeGenerator_x86simd.rulev[1825] = new Rule(1825, false, true, 1652, "1825: _1609 -> (BAND I16 con _1608)", null, null, null, 0L, false, false, new int[]{19, 1651}, null);
        CodeGenerator_x86simd.rulev[1827] = new Rule(1827, false, true, 1654, "1827: _1611 -> (BAND I16 con _1610)", null, null, null, 0L, false, false, new int[]{19, 1653}, null);
        CodeGenerator_x86simd.rulev[1831] = new Rule(1831, false, true, 1658, "1831: _1615 -> (BAND I16 con _1614)", null, null, null, 0L, false, false, new int[]{19, 1657}, null);
        CodeGenerator_x86simd.rulev[1833] = new Rule(1833, false, true, 1660, "1833: _1617 -> (BAND I16 con _1616)", null, null, null, 0L, false, false, new int[]{19, 1659}, null);
        CodeGenerator_x86simd.rulev[1837] = new Rule(1837, false, true, 1664, "1837: _1621 -> (BAND I16 con _1620)", null, null, null, 0L, false, false, new int[]{19, 1663}, null);
        CodeGenerator_x86simd.rulev[1839] = new Rule(1839, false, true, 1666, "1839: _1623 -> (BAND I16 con _1622)", null, null, null, 0L, false, false, new int[]{19, 1665}, null);
        CodeGenerator_x86simd.rulev[1843] = new Rule(1843, false, true, 1670, "1843: _1627 -> (BAND I16 con _1626)", null, null, null, 0L, false, false, new int[]{19, 1669}, null);
        CodeGenerator_x86simd.rulev[1845] = new Rule(1845, false, true, 1672, "1845: _1629 -> (BAND I16 con _1628)", null, null, null, 0L, false, false, new int[]{19, 1671}, null);
        CodeGenerator_x86simd.rulev[1849] = new Rule(1849, false, true, 1676, "1849: _1633 -> (BAND I16 con _1632)", null, null, null, 0L, false, false, new int[]{19, 1675}, null);
        CodeGenerator_x86simd.rulev[1851] = new Rule(1851, false, true, 1678, "1851: _1635 -> (BAND I16 con _1634)", null, null, null, 0L, false, false, new int[]{19, 1677}, null);
        CodeGenerator_x86simd.rulev[1856] = new Rule(1856, false, true, 1682, "1856: _1639 -> (BAND I16 con _1638)", null, null, null, 0L, false, false, new int[]{19, 1681}, null);
        CodeGenerator_x86simd.rulev[1858] = new Rule(1858, false, true, 1684, "1858: _1641 -> (BAND I16 con _1640)", null, null, null, 0L, false, false, new int[]{19, 1683}, null);
        CodeGenerator_x86simd.rulev[1862] = new Rule(1862, false, true, 1688, "1862: _1645 -> (BAND I16 con _1644)", null, null, null, 0L, false, false, new int[]{19, 1687}, null);
        CodeGenerator_x86simd.rulev[1864] = new Rule(1864, false, true, 1690, "1864: _1647 -> (BAND I16 con _1646)", null, null, null, 0L, false, false, new int[]{19, 1689}, null);
        CodeGenerator_x86simd.rulev[1868] = new Rule(1868, false, true, 1694, "1868: _1651 -> (BAND I16 con _1650)", null, null, null, 0L, false, false, new int[]{19, 1693}, null);
        CodeGenerator_x86simd.rulev[1870] = new Rule(1870, false, true, 1696, "1870: _1653 -> (BAND I16 con _1652)", null, null, null, 0L, false, false, new int[]{19, 1695}, null);
        CodeGenerator_x86simd.rulev[1874] = new Rule(1874, false, true, 1700, "1874: _1657 -> (BAND I16 con _1656)", null, null, null, 0L, false, false, new int[]{19, 1699}, null);
        CodeGenerator_x86simd.rulev[1876] = new Rule(1876, false, true, 1702, "1876: _1659 -> (BAND I16 con _1658)", null, null, null, 0L, false, false, new int[]{19, 1701}, null);
        CodeGenerator_x86simd.rulev[1880] = new Rule(1880, false, true, 1706, "1880: _1663 -> (BAND I16 con _1662)", null, null, null, 0L, false, false, new int[]{19, 1705}, null);
        CodeGenerator_x86simd.rulev[1882] = new Rule(1882, false, true, 1708, "1882: _1665 -> (BAND I16 con _1664)", null, null, null, 0L, false, false, new int[]{19, 1707}, null);
        CodeGenerator_x86simd.rulev[1886] = new Rule(1886, false, true, 1712, "1886: _1669 -> (BAND I16 con _1668)", null, null, null, 0L, false, false, new int[]{19, 1711}, null);
        CodeGenerator_x86simd.rulev[1888] = new Rule(1888, false, true, 1714, "1888: _1671 -> (BAND I16 con _1670)", null, null, null, 0L, false, false, new int[]{19, 1713}, null);
    }

    private static void rrinit1200() {
        CodeGenerator_x86simd.rulev[1892] = new Rule(1892, false, true, 1718, "1892: _1675 -> (BAND I16 con _1674)", null, null, null, 0L, false, false, new int[]{19, 1717}, null);
        CodeGenerator_x86simd.rulev[1894] = new Rule(1894, false, true, 1720, "1894: _1677 -> (BAND I16 con _1676)", null, null, null, 0L, false, false, new int[]{19, 1719}, null);
        CodeGenerator_x86simd.rulev[1898] = new Rule(1898, false, true, 1724, "1898: _1681 -> (BAND I16 con _1680)", null, null, null, 0L, false, false, new int[]{19, 1723}, null);
        CodeGenerator_x86simd.rulev[1900] = new Rule(1900, false, true, 1726, "1900: _1683 -> (BAND I16 con _1682)", null, null, null, 0L, false, false, new int[]{19, 1725}, null);
        CodeGenerator_x86simd.rulev[2037] = new Rule(2037, false, true, 1858, "2037: _1815 -> (BAND I16 con _1814)", null, null, null, 0L, false, false, new int[]{19, 1857}, null);
        CodeGenerator_x86simd.rulev[2039] = new Rule(2039, false, true, 1860, "2039: _1817 -> (BAND I16 con _1816)", null, null, null, 0L, false, false, new int[]{19, 1859}, null);
        CodeGenerator_x86simd.rulev[2043] = new Rule(2043, false, true, 1864, "2043: _1821 -> (BAND I16 con _1820)", null, null, null, 0L, false, false, new int[]{19, 1863}, null);
        CodeGenerator_x86simd.rulev[2045] = new Rule(2045, false, true, 1866, "2045: _1823 -> (BAND I16 con _1822)", null, null, null, 0L, false, false, new int[]{19, 1865}, null);
        CodeGenerator_x86simd.rulev[2049] = new Rule(2049, false, true, 1870, "2049: _1827 -> (BAND I16 con _1826)", null, null, null, 0L, false, false, new int[]{19, 1869}, null);
        CodeGenerator_x86simd.rulev[2051] = new Rule(2051, false, true, 1872, "2051: _1829 -> (BAND I16 con _1828)", null, null, null, 0L, false, false, new int[]{19, 1871}, null);
        CodeGenerator_x86simd.rulev[2055] = new Rule(2055, false, true, 1876, "2055: _1833 -> (BAND I16 con _1832)", null, null, null, 0L, false, false, new int[]{19, 1875}, null);
        CodeGenerator_x86simd.rulev[2057] = new Rule(2057, false, true, 1878, "2057: _1835 -> (BAND I16 con _1834)", null, null, null, 0L, false, false, new int[]{19, 1877}, null);
        CodeGenerator_x86simd.rulev[2062] = new Rule(2062, false, true, 1882, "2062: _1839 -> (BAND I16 con _1838)", null, null, null, 0L, false, false, new int[]{19, 1881}, null);
        CodeGenerator_x86simd.rulev[2064] = new Rule(2064, false, true, 1884, "2064: _1841 -> (BAND I16 con _1840)", null, null, null, 0L, false, false, new int[]{19, 1883}, null);
        CodeGenerator_x86simd.rulev[2068] = new Rule(2068, false, true, 1888, "2068: _1845 -> (BAND I16 con _1844)", null, null, null, 0L, false, false, new int[]{19, 1887}, null);
        CodeGenerator_x86simd.rulev[2070] = new Rule(2070, false, true, 1890, "2070: _1847 -> (BAND I16 con _1846)", null, null, null, 0L, false, false, new int[]{19, 1889}, null);
        CodeGenerator_x86simd.rulev[2074] = new Rule(2074, false, true, 1894, "2074: _1851 -> (BAND I16 con _1850)", null, null, null, 0L, false, false, new int[]{19, 1893}, null);
        CodeGenerator_x86simd.rulev[2076] = new Rule(2076, false, true, 1896, "2076: _1853 -> (BAND I16 con _1852)", null, null, null, 0L, false, false, new int[]{19, 1895}, null);
        CodeGenerator_x86simd.rulev[2080] = new Rule(2080, false, true, 1900, "2080: _1857 -> (BAND I16 con _1856)", null, null, null, 0L, false, false, new int[]{19, 1899}, null);
        CodeGenerator_x86simd.rulev[2082] = new Rule(2082, false, true, 1902, "2082: _1859 -> (BAND I16 con _1858)", null, null, null, 0L, false, false, new int[]{19, 1901}, null);
        CodeGenerator_x86simd.rulev[2275] = new Rule(2275, false, true, 2090, "2275: _2047 -> (BAND I16 con _2046)", null, null, null, 0L, false, false, new int[]{19, 2089}, null);
        CodeGenerator_x86simd.rulev[2277] = new Rule(2277, false, true, 2092, "2277: _2049 -> (BAND I16 con _2048)", null, null, null, 0L, false, false, new int[]{19, 2091}, null);
        CodeGenerator_x86simd.rulev[2281] = new Rule(2281, false, true, 2096, "2281: _2053 -> (BAND I16 con _2052)", null, null, null, 0L, false, false, new int[]{19, 2095}, null);
        CodeGenerator_x86simd.rulev[2283] = new Rule(2283, false, true, 2098, "2283: _2055 -> (BAND I16 con _2054)", null, null, null, 0L, false, false, new int[]{19, 2097}, null);
        CodeGenerator_x86simd.rulev[2287] = new Rule(2287, false, true, 2102, "2287: _2059 -> (BAND I16 con _2058)", null, null, null, 0L, false, false, new int[]{19, 2101}, null);
        CodeGenerator_x86simd.rulev[2289] = new Rule(2289, false, true, 2104, "2289: _2061 -> (BAND I16 con _2060)", null, null, null, 0L, false, false, new int[]{19, 2103}, null);
        CodeGenerator_x86simd.rulev[2293] = new Rule(2293, false, true, 2108, "2293: _2065 -> (BAND I16 con _2064)", null, null, null, 0L, false, false, new int[]{19, 2107}, null);
        CodeGenerator_x86simd.rulev[2295] = new Rule(2295, false, true, 2110, "2295: _2067 -> (BAND I16 con _2066)", null, null, null, 0L, false, false, new int[]{19, 2109}, null);
        CodeGenerator_x86simd.rulev[2299] = new Rule(2299, false, true, 2114, "2299: _2071 -> (BAND I16 con _2070)", null, null, null, 0L, false, false, new int[]{19, 2113}, null);
        CodeGenerator_x86simd.rulev[2301] = new Rule(2301, false, true, 2116, "2301: _2073 -> (BAND I16 con _2072)", null, null, null, 0L, false, false, new int[]{19, 2115}, null);
        CodeGenerator_x86simd.rulev[2305] = new Rule(2305, false, true, 2120, "2305: _2077 -> (BAND I16 con _2076)", null, null, null, 0L, false, false, new int[]{19, 2119}, null);
        CodeGenerator_x86simd.rulev[2307] = new Rule(2307, false, true, 2122, "2307: _2079 -> (BAND I16 con _2078)", null, null, null, 0L, false, false, new int[]{19, 2121}, null);
        CodeGenerator_x86simd.rulev[2311] = new Rule(2311, false, true, 2126, "2311: _2083 -> (BAND I16 con _2082)", null, null, null, 0L, false, false, new int[]{19, 2125}, null);
        CodeGenerator_x86simd.rulev[2313] = new Rule(2313, false, true, 2128, "2313: _2085 -> (BAND I16 con _2084)", null, null, null, 0L, false, false, new int[]{19, 2127}, null);
        CodeGenerator_x86simd.rulev[2317] = new Rule(2317, false, true, 2132, "2317: _2089 -> (BAND I16 con _2088)", null, null, null, 0L, false, false, new int[]{19, 2131}, null);
        CodeGenerator_x86simd.rulev[2319] = new Rule(2319, false, true, 2134, "2319: _2091 -> (BAND I16 con _2090)", null, null, null, 0L, false, false, new int[]{19, 2133}, null);
        CodeGenerator_x86simd.rulev[2324] = new Rule(2324, false, true, 2138, "2324: _2095 -> (BAND I16 con _2094)", null, null, null, 0L, false, false, new int[]{19, 2137}, null);
        CodeGenerator_x86simd.rulev[2326] = new Rule(2326, false, true, 2140, "2326: _2097 -> (BAND I16 con _2096)", null, null, null, 0L, false, false, new int[]{19, 2139}, null);
        CodeGenerator_x86simd.rulev[2330] = new Rule(2330, false, true, 2144, "2330: _2101 -> (BAND I16 con _2100)", null, null, null, 0L, false, false, new int[]{19, 2143}, null);
        CodeGenerator_x86simd.rulev[2332] = new Rule(2332, false, true, 2146, "2332: _2103 -> (BAND I16 con _2102)", null, null, null, 0L, false, false, new int[]{19, 2145}, null);
        CodeGenerator_x86simd.rulev[2336] = new Rule(2336, false, true, 2150, "2336: _2107 -> (BAND I16 con _2106)", null, null, null, 0L, false, false, new int[]{19, 2149}, null);
        CodeGenerator_x86simd.rulev[2338] = new Rule(2338, false, true, 2152, "2338: _2109 -> (BAND I16 con _2108)", null, null, null, 0L, false, false, new int[]{19, 2151}, null);
        CodeGenerator_x86simd.rulev[2342] = new Rule(2342, false, true, 2156, "2342: _2113 -> (BAND I16 con _2112)", null, null, null, 0L, false, false, new int[]{19, 2155}, null);
        CodeGenerator_x86simd.rulev[2344] = new Rule(2344, false, true, 2158, "2344: _2115 -> (BAND I16 con _2114)", null, null, null, 0L, false, false, new int[]{19, 2157}, null);
        CodeGenerator_x86simd.rulev[2348] = new Rule(2348, false, true, 2162, "2348: _2119 -> (BAND I16 con _2118)", null, null, null, 0L, false, false, new int[]{19, 2161}, null);
        CodeGenerator_x86simd.rulev[2350] = new Rule(2350, false, true, 2164, "2350: _2121 -> (BAND I16 con _2120)", null, null, null, 0L, false, false, new int[]{19, 2163}, null);
        CodeGenerator_x86simd.rulev[2354] = new Rule(2354, false, true, 2168, "2354: _2125 -> (BAND I16 con _2124)", null, null, null, 0L, false, false, new int[]{19, 2167}, null);
        CodeGenerator_x86simd.rulev[2356] = new Rule(2356, false, true, 2170, "2356: _2127 -> (BAND I16 con _2126)", null, null, null, 0L, false, false, new int[]{19, 2169}, null);
        CodeGenerator_x86simd.rulev[2360] = new Rule(2360, false, true, 2174, "2360: _2131 -> (BAND I16 con _2130)", null, null, null, 0L, false, false, new int[]{19, 2173}, null);
        CodeGenerator_x86simd.rulev[2362] = new Rule(2362, false, true, 2176, "2362: _2133 -> (BAND I16 con _2132)", null, null, null, 0L, false, false, new int[]{19, 2175}, null);
        CodeGenerator_x86simd.rulev[2366] = new Rule(2366, false, true, 2180, "2366: _2137 -> (BAND I16 con _2136)", null, null, null, 0L, false, false, new int[]{19, 2179}, null);
        CodeGenerator_x86simd.rulev[2368] = new Rule(2368, false, true, 2182, "2368: _2139 -> (BAND I16 con _2138)", null, null, null, 0L, false, false, new int[]{19, 2181}, null);
        CodeGenerator_x86simd.rulev[2471] = new Rule(2471, false, true, 2281, "2471: _2238 -> (BAND I16 con _1086)", null, null, null, 0L, false, false, new int[]{19, 1129}, null);
        CodeGenerator_x86simd.rulev[2472] = new Rule(2472, false, true, 2282, "2472: _2239 -> (BAND I16 con _1088)", null, null, null, 0L, false, false, new int[]{19, 1131}, null);
        CodeGenerator_x86simd.rulev[2475] = new Rule(2475, false, true, 2285, "2475: _2242 -> (BAND I16 con _1092)", null, null, null, 0L, false, false, new int[]{19, 1135}, null);
        CodeGenerator_x86simd.rulev[2476] = new Rule(2476, false, true, 2286, "2476: _2243 -> (BAND I16 con _1094)", null, null, null, 0L, false, false, new int[]{19, 1137}, null);
        CodeGenerator_x86simd.rulev[2479] = new Rule(2479, false, true, 2289, "2479: _2246 -> (BAND I16 con _1098)", null, null, null, 0L, false, false, new int[]{19, 1141}, null);
        CodeGenerator_x86simd.rulev[2480] = new Rule(2480, false, true, 2290, "2480: _2247 -> (BAND I16 con _1100)", null, null, null, 0L, false, false, new int[]{19, 1143}, null);
        CodeGenerator_x86simd.rulev[2483] = new Rule(2483, false, true, 2293, "2483: _2250 -> (BAND I16 con _1104)", null, null, null, 0L, false, false, new int[]{19, 1147}, null);
        CodeGenerator_x86simd.rulev[2484] = new Rule(2484, false, true, 2294, "2484: _2251 -> (BAND I16 con _1106)", null, null, null, 0L, false, false, new int[]{19, 1149}, null);
        CodeGenerator_x86simd.rulev[2598] = new Rule(2598, false, true, 2405, "2598: _2362 -> (BAND I16 con _1134)", null, null, null, 0L, false, false, new int[]{19, 1177}, null);
        CodeGenerator_x86simd.rulev[2599] = new Rule(2599, false, true, 2406, "2599: _2363 -> (BAND I16 con _1136)", null, null, null, 0L, false, false, new int[]{19, 1179}, null);
        CodeGenerator_x86simd.rulev[2602] = new Rule(2602, false, true, 2409, "2602: _2366 -> (BAND I16 con _1140)", null, null, null, 0L, false, false, new int[]{19, 1183}, null);
        CodeGenerator_x86simd.rulev[2603] = new Rule(2603, false, true, 2410, "2603: _2367 -> (BAND I16 con _1142)", null, null, null, 0L, false, false, new int[]{19, 1185}, null);
        CodeGenerator_x86simd.rulev[2606] = new Rule(2606, false, true, 2413, "2606: _2370 -> (BAND I16 con _1146)", null, null, null, 0L, false, false, new int[]{19, 1189}, null);
        CodeGenerator_x86simd.rulev[2607] = new Rule(2607, false, true, 2414, "2607: _2371 -> (BAND I16 con _1148)", null, null, null, 0L, false, false, new int[]{19, 1191}, null);
        CodeGenerator_x86simd.rulev[2610] = new Rule(2610, false, true, 2417, "2610: _2374 -> (BAND I16 con _1152)", null, null, null, 0L, false, false, new int[]{19, 1195}, null);
        CodeGenerator_x86simd.rulev[2611] = new Rule(2611, false, true, 2418, "2611: _2375 -> (BAND I16 con _1154)", null, null, null, 0L, false, false, new int[]{19, 1197}, null);
        CodeGenerator_x86simd.rulev[2614] = new Rule(2614, false, true, 2421, "2614: _2378 -> (BAND I16 con _1158)", null, null, null, 0L, false, false, new int[]{19, 1201}, null);
        CodeGenerator_x86simd.rulev[2615] = new Rule(2615, false, true, 2422, "2615: _2379 -> (BAND I16 con _1160)", null, null, null, 0L, false, false, new int[]{19, 1203}, null);
        CodeGenerator_x86simd.rulev[2618] = new Rule(2618, false, true, 2425, "2618: _2382 -> (BAND I16 con _1164)", null, null, null, 0L, false, false, new int[]{19, 1207}, null);
        CodeGenerator_x86simd.rulev[2619] = new Rule(2619, false, true, 2426, "2619: _2383 -> (BAND I16 con _1166)", null, null, null, 0L, false, false, new int[]{19, 1209}, null);
        CodeGenerator_x86simd.rulev[2622] = new Rule(2622, false, true, 2429, "2622: _2386 -> (BAND I16 con _1170)", null, null, null, 0L, false, false, new int[]{19, 1213}, null);
        CodeGenerator_x86simd.rulev[2623] = new Rule(2623, false, true, 2430, "2623: _2387 -> (BAND I16 con _1172)", null, null, null, 0L, false, false, new int[]{19, 1215}, null);
        CodeGenerator_x86simd.rulev[2626] = new Rule(2626, false, true, 2433, "2626: _2390 -> (BAND I16 con _1176)", null, null, null, 0L, false, false, new int[]{19, 1219}, null);
        CodeGenerator_x86simd.rulev[2627] = new Rule(2627, false, true, 2434, "2627: _2391 -> (BAND I16 con _1178)", null, null, null, 0L, false, false, new int[]{19, 1221}, null);
        CodeGenerator_x86simd.rulev[2705] = new Rule(2705, false, true, 2509, "2705: _2466 -> (BAND I16 con _1110)", null, null, null, 0L, false, false, new int[]{19, 1153}, null);
        CodeGenerator_x86simd.rulev[2706] = new Rule(2706, false, true, 2510, "2706: _2467 -> (BAND I16 con _1112)", null, null, null, 0L, false, false, new int[]{19, 1155}, null);
        CodeGenerator_x86simd.rulev[2709] = new Rule(2709, false, true, 2513, "2709: _2470 -> (BAND I16 con _1116)", null, null, null, 0L, false, false, new int[]{19, 1159}, null);
        CodeGenerator_x86simd.rulev[2710] = new Rule(2710, false, true, 2514, "2710: _2471 -> (BAND I16 con _1118)", null, null, null, 0L, false, false, new int[]{19, 1161}, null);
        CodeGenerator_x86simd.rulev[2713] = new Rule(2713, false, true, 2517, "2713: _2474 -> (BAND I16 con _1122)", null, null, null, 0L, false, false, new int[]{19, 1165}, null);
        CodeGenerator_x86simd.rulev[2714] = new Rule(2714, false, true, 2518, "2714: _2475 -> (BAND I16 con _1124)", null, null, null, 0L, false, false, new int[]{19, 1167}, null);
        CodeGenerator_x86simd.rulev[2717] = new Rule(2717, false, true, 2521, "2717: _2478 -> (BAND I16 con _1128)", null, null, null, 0L, false, false, new int[]{19, 1171}, null);
        CodeGenerator_x86simd.rulev[2718] = new Rule(2718, false, true, 2522, "2718: _2479 -> (BAND I16 con _1130)", null, null, null, 0L, false, false, new int[]{19, 1173}, null);
        CodeGenerator_x86simd.rulev[2832] = new Rule(2832, false, true, 2633, "2832: _2590 -> (BAND I16 con _1182)", null, null, null, 0L, false, false, new int[]{19, 1225}, null);
        CodeGenerator_x86simd.rulev[2833] = new Rule(2833, false, true, 2634, "2833: _2591 -> (BAND I16 con _1184)", null, null, null, 0L, false, false, new int[]{19, 1227}, null);
        CodeGenerator_x86simd.rulev[2836] = new Rule(2836, false, true, 2637, "2836: _2594 -> (BAND I16 con _1188)", null, null, null, 0L, false, false, new int[]{19, 1231}, null);
        CodeGenerator_x86simd.rulev[2837] = new Rule(2837, false, true, 2638, "2837: _2595 -> (BAND I16 con _1190)", null, null, null, 0L, false, false, new int[]{19, 1233}, null);
        CodeGenerator_x86simd.rulev[2840] = new Rule(2840, false, true, 2641, "2840: _2598 -> (BAND I16 con _1194)", null, null, null, 0L, false, false, new int[]{19, 1237}, null);
        CodeGenerator_x86simd.rulev[2841] = new Rule(2841, false, true, 2642, "2841: _2599 -> (BAND I16 con _1196)", null, null, null, 0L, false, false, new int[]{19, 1239}, null);
        CodeGenerator_x86simd.rulev[2844] = new Rule(2844, false, true, 2645, "2844: _2602 -> (BAND I16 con _1200)", null, null, null, 0L, false, false, new int[]{19, 1243}, null);
        CodeGenerator_x86simd.rulev[2845] = new Rule(2845, false, true, 2646, "2845: _2603 -> (BAND I16 con _1202)", null, null, null, 0L, false, false, new int[]{19, 1245}, null);
        CodeGenerator_x86simd.rulev[2848] = new Rule(2848, false, true, 2649, "2848: _2606 -> (BAND I16 con _1206)", null, null, null, 0L, false, false, new int[]{19, 1249}, null);
        CodeGenerator_x86simd.rulev[2849] = new Rule(2849, false, true, 2650, "2849: _2607 -> (BAND I16 con _1208)", null, null, null, 0L, false, false, new int[]{19, 1251}, null);
        CodeGenerator_x86simd.rulev[2852] = new Rule(2852, false, true, 2653, "2852: _2610 -> (BAND I16 con _1212)", null, null, null, 0L, false, false, new int[]{19, 1255}, null);
        CodeGenerator_x86simd.rulev[2853] = new Rule(2853, false, true, 2654, "2853: _2611 -> (BAND I16 con _1214)", null, null, null, 0L, false, false, new int[]{19, 1257}, null);
        CodeGenerator_x86simd.rulev[2856] = new Rule(2856, false, true, 2657, "2856: _2614 -> (BAND I16 con _1218)", null, null, null, 0L, false, false, new int[]{19, 1261}, null);
        CodeGenerator_x86simd.rulev[2857] = new Rule(2857, false, true, 2658, "2857: _2615 -> (BAND I16 con _1220)", null, null, null, 0L, false, false, new int[]{19, 1263}, null);
        CodeGenerator_x86simd.rulev[2860] = new Rule(2860, false, true, 2661, "2860: _2618 -> (BAND I16 con _1224)", null, null, null, 0L, false, false, new int[]{19, 1267}, null);
        CodeGenerator_x86simd.rulev[2861] = new Rule(2861, false, true, 2662, "2861: _2619 -> (BAND I16 con _1226)", null, null, null, 0L, false, false, new int[]{19, 1269}, null);
    }

    private static void rrinit1300() {
        CodeGenerator_x86simd.rulev[3153] = new Rule(3153, false, true, 2927, "3153: _2884 -> (BAND I16 _2883 _117)", null, null, null, 0L, false, false, new int[]{2926, 160}, null);
        CodeGenerator_x86simd.rulev[3156] = new Rule(3156, false, true, 2930, "3156: _2887 -> (BAND I16 _2886 _119)", null, null, null, 0L, false, false, new int[]{2929, 162}, null);
        CodeGenerator_x86simd.rulev[3159] = new Rule(3159, false, true, 2933, "3159: _2890 -> (BAND I16 _2889 _121)", null, null, null, 0L, false, false, new int[]{2932, 164}, null);
        CodeGenerator_x86simd.rulev[3162] = new Rule(3162, false, true, 2936, "3162: _2893 -> (BAND I16 _2892 _123)", null, null, null, 0L, false, false, new int[]{2935, 166}, null);
        CodeGenerator_x86simd.rulev[3222] = new Rule(3222, false, true, 2993, "3222: _2950 -> (BAND I16 _2949 _49)", null, null, null, 0L, false, false, new int[]{2992, 92}, null);
        CodeGenerator_x86simd.rulev[3225] = new Rule(3225, false, true, 2996, "3225: _2953 -> (BAND I16 _2952 _51)", null, null, null, 0L, false, false, new int[]{2995, 94}, null);
        CodeGenerator_x86simd.rulev[3228] = new Rule(3228, false, true, 2999, "3228: _2956 -> (BAND I16 _2955 _53)", null, null, null, 0L, false, false, new int[]{2998, 96}, null);
        CodeGenerator_x86simd.rulev[3231] = new Rule(3231, false, true, 3002, "3231: _2959 -> (BAND I16 _2958 _55)", null, null, null, 0L, false, false, new int[]{3001, 98}, null);
        CodeGenerator_x86simd.rulev[3234] = new Rule(3234, false, true, 3005, "3234: _2962 -> (BAND I16 _2961 _57)", null, null, null, 0L, false, false, new int[]{3004, 100}, null);
        CodeGenerator_x86simd.rulev[3237] = new Rule(3237, false, true, 3008, "3237: _2965 -> (BAND I16 _2964 _59)", null, null, null, 0L, false, false, new int[]{3007, 102}, null);
        CodeGenerator_x86simd.rulev[3240] = new Rule(3240, false, true, 3011, "3240: _2968 -> (BAND I16 _2967 _61)", null, null, null, 0L, false, false, new int[]{3010, 104}, null);
        CodeGenerator_x86simd.rulev[3243] = new Rule(3243, false, true, 3014, "3243: _2971 -> (BAND I16 _2970 _63)", null, null, null, 0L, false, false, new int[]{3013, 106}, null);
        CodeGenerator_x86simd.rulev[3343] = new Rule(3343, false, true, 3104, "3343: _3061 -> (BAND I16 _117 _117)", null, null, null, 0L, false, false, new int[]{160, 160}, null);
        CodeGenerator_x86simd.rulev[3345] = new Rule(3345, false, true, 3106, "3345: _3063 -> (BAND I16 _119 _119)", null, null, null, 0L, false, false, new int[]{162, 162}, null);
        CodeGenerator_x86simd.rulev[3347] = new Rule(3347, false, true, 3108, "3347: _3065 -> (BAND I16 _121 _121)", null, null, null, 0L, false, false, new int[]{164, 164}, null);
        CodeGenerator_x86simd.rulev[3349] = new Rule(3349, false, true, 3110, "3349: _3067 -> (BAND I16 _123 _123)", null, null, null, 0L, false, false, new int[]{166, 166}, null);
        CodeGenerator_x86simd.rulev[3551] = new Rule(3551, false, true, 3296, "3551: _3253 -> (BAND I16 _49 _49)", null, null, null, 0L, false, false, new int[]{92, 92}, null);
        CodeGenerator_x86simd.rulev[3553] = new Rule(3553, false, true, 3298, "3553: _3255 -> (BAND I16 _51 _51)", null, null, null, 0L, false, false, new int[]{94, 94}, null);
        CodeGenerator_x86simd.rulev[3555] = new Rule(3555, false, true, 3300, "3555: _3257 -> (BAND I16 _53 _53)", null, null, null, 0L, false, false, new int[]{96, 96}, null);
        CodeGenerator_x86simd.rulev[3557] = new Rule(3557, false, true, 3302, "3557: _3259 -> (BAND I16 _55 _55)", null, null, null, 0L, false, false, new int[]{98, 98}, null);
        CodeGenerator_x86simd.rulev[3559] = new Rule(3559, false, true, 3304, "3559: _3261 -> (BAND I16 _57 _57)", null, null, null, 0L, false, false, new int[]{100, 100}, null);
        CodeGenerator_x86simd.rulev[3561] = new Rule(3561, false, true, 3306, "3561: _3263 -> (BAND I16 _59 _59)", null, null, null, 0L, false, false, new int[]{102, 102}, null);
        CodeGenerator_x86simd.rulev[3563] = new Rule(3563, false, true, 3308, "3563: _3265 -> (BAND I16 _61 _61)", null, null, null, 0L, false, false, new int[]{104, 104}, null);
        CodeGenerator_x86simd.rulev[3565] = new Rule(3565, false, true, 3310, "3565: _3267 -> (BAND I16 _63 _63)", null, null, null, 0L, false, false, new int[]{106, 106}, null);
        CodeGenerator_x86simd.rulev[4015] = new Rule(4015, false, false, 6, "4015: regw -> (BAND I16 regw mrcw)", ImList.list(ImList.list("andw", "$2", "$0")), null, null, 2L, false, false, new int[]{6, 42}, new String[]{"*reg-I16*", "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[4023] = new Rule(4023, false, false, 6, "4023: regw -> (BAND I16 mrcw regw)", ImList.list(ImList.list("andw", "$1", "$0")), null, null, 4L, false, false, new int[]{42, 6}, new String[]{"*reg-I16*", null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[1587] = new Rule(1587, false, true, 1418, "1587: _1375 -> (BAND I32 con _1374)", null, null, null, 0L, false, false, new int[]{19, 1417}, null);
        CodeGenerator_x86simd.rulev[1589] = new Rule(1589, false, true, 1420, "1589: _1377 -> (BAND I32 con _1376)", null, null, null, 0L, false, false, new int[]{19, 1419}, null);
        CodeGenerator_x86simd.rulev[1593] = new Rule(1593, false, true, 1424, "1593: _1381 -> (BAND I32 con _1380)", null, null, null, 0L, false, false, new int[]{19, 1423}, null);
        CodeGenerator_x86simd.rulev[1595] = new Rule(1595, false, true, 1426, "1595: _1383 -> (BAND I32 con _1382)", null, null, null, 0L, false, false, new int[]{19, 1425}, null);
        CodeGenerator_x86simd.rulev[1600] = new Rule(1600, false, true, 1430, "1600: _1387 -> (BAND I32 con _1386)", null, null, null, 0L, false, false, new int[]{19, 1429}, null);
        CodeGenerator_x86simd.rulev[1602] = new Rule(1602, false, true, 1432, "1602: _1389 -> (BAND I32 con _1388)", null, null, null, 0L, false, false, new int[]{19, 1431}, null);
        CodeGenerator_x86simd.rulev[1606] = new Rule(1606, false, true, 1436, "1606: _1393 -> (BAND I32 con _1392)", null, null, null, 0L, false, false, new int[]{19, 1435}, null);
        CodeGenerator_x86simd.rulev[1608] = new Rule(1608, false, true, 1438, "1608: _1395 -> (BAND I32 con _1394)", null, null, null, 0L, false, false, new int[]{19, 1437}, null);
        CodeGenerator_x86simd.rulev[1905] = new Rule(1905, false, true, 1730, "1905: _1687 -> (BAND I32 con _1686)", null, null, null, 0L, false, false, new int[]{19, 1729}, null);
        CodeGenerator_x86simd.rulev[1907] = new Rule(1907, false, true, 1732, "1907: _1689 -> (BAND I32 con _1688)", null, null, null, 0L, false, false, new int[]{19, 1731}, null);
        CodeGenerator_x86simd.rulev[1911] = new Rule(1911, false, true, 1736, "1911: _1693 -> (BAND I32 con _1692)", null, null, null, 0L, false, false, new int[]{19, 1735}, null);
        CodeGenerator_x86simd.rulev[1913] = new Rule(1913, false, true, 1738, "1913: _1695 -> (BAND I32 con _1694)", null, null, null, 0L, false, false, new int[]{19, 1737}, null);
        CodeGenerator_x86simd.rulev[1917] = new Rule(1917, false, true, 1742, "1917: _1699 -> (BAND I32 con _1698)", null, null, null, 0L, false, false, new int[]{19, 1741}, null);
        CodeGenerator_x86simd.rulev[1919] = new Rule(1919, false, true, 1744, "1919: _1701 -> (BAND I32 con _1700)", null, null, null, 0L, false, false, new int[]{19, 1743}, null);
        CodeGenerator_x86simd.rulev[1923] = new Rule(1923, false, true, 1748, "1923: _1705 -> (BAND I32 con _1704)", null, null, null, 0L, false, false, new int[]{19, 1747}, null);
        CodeGenerator_x86simd.rulev[1925] = new Rule(1925, false, true, 1750, "1925: _1707 -> (BAND I32 con _1706)", null, null, null, 0L, false, false, new int[]{19, 1749}, null);
        CodeGenerator_x86simd.rulev[1930] = new Rule(1930, false, true, 1754, "1930: _1711 -> (BAND I32 con _1710)", null, null, null, 0L, false, false, new int[]{19, 1753}, null);
        CodeGenerator_x86simd.rulev[1932] = new Rule(1932, false, true, 1756, "1932: _1713 -> (BAND I32 con _1712)", null, null, null, 0L, false, false, new int[]{19, 1755}, null);
        CodeGenerator_x86simd.rulev[1936] = new Rule(1936, false, true, 1760, "1936: _1717 -> (BAND I32 con _1716)", null, null, null, 0L, false, false, new int[]{19, 1759}, null);
        CodeGenerator_x86simd.rulev[1938] = new Rule(1938, false, true, 1762, "1938: _1719 -> (BAND I32 con _1718)", null, null, null, 0L, false, false, new int[]{19, 1761}, null);
        CodeGenerator_x86simd.rulev[1942] = new Rule(1942, false, true, 1766, "1942: _1723 -> (BAND I32 con _1722)", null, null, null, 0L, false, false, new int[]{19, 1765}, null);
        CodeGenerator_x86simd.rulev[1944] = new Rule(1944, false, true, 1768, "1944: _1725 -> (BAND I32 con _1724)", null, null, null, 0L, false, false, new int[]{19, 1767}, null);
        CodeGenerator_x86simd.rulev[1948] = new Rule(1948, false, true, 1772, "1948: _1729 -> (BAND I32 con _1728)", null, null, null, 0L, false, false, new int[]{19, 1771}, null);
        CodeGenerator_x86simd.rulev[1950] = new Rule(1950, false, true, 1774, "1950: _1731 -> (BAND I32 con _1730)", null, null, null, 0L, false, false, new int[]{19, 1773}, null);
        CodeGenerator_x86simd.rulev[2087] = new Rule(2087, false, true, 1906, "2087: _1863 -> (BAND I32 con _1862)", null, null, null, 0L, false, false, new int[]{19, 1905}, null);
        CodeGenerator_x86simd.rulev[2089] = new Rule(2089, false, true, 1908, "2089: _1865 -> (BAND I32 con _1864)", null, null, null, 0L, false, false, new int[]{19, 1907}, null);
        CodeGenerator_x86simd.rulev[2093] = new Rule(2093, false, true, 1912, "2093: _1869 -> (BAND I32 con _1868)", null, null, null, 0L, false, false, new int[]{19, 1911}, null);
        CodeGenerator_x86simd.rulev[2095] = new Rule(2095, false, true, 1914, "2095: _1871 -> (BAND I32 con _1870)", null, null, null, 0L, false, false, new int[]{19, 1913}, null);
        CodeGenerator_x86simd.rulev[2100] = new Rule(2100, false, true, 1918, "2100: _1875 -> (BAND I32 con _1874)", null, null, null, 0L, false, false, new int[]{19, 1917}, null);
        CodeGenerator_x86simd.rulev[2102] = new Rule(2102, false, true, 1920, "2102: _1877 -> (BAND I32 con _1876)", null, null, null, 0L, false, false, new int[]{19, 1919}, null);
        CodeGenerator_x86simd.rulev[2106] = new Rule(2106, false, true, 1924, "2106: _1881 -> (BAND I32 con _1880)", null, null, null, 0L, false, false, new int[]{19, 1923}, null);
        CodeGenerator_x86simd.rulev[2108] = new Rule(2108, false, true, 1926, "2108: _1883 -> (BAND I32 con _1882)", null, null, null, 0L, false, false, new int[]{19, 1925}, null);
        CodeGenerator_x86simd.rulev[2373] = new Rule(2373, false, true, 2186, "2373: _2143 -> (BAND I32 con _2142)", null, null, null, 0L, false, false, new int[]{19, 2185}, null);
        CodeGenerator_x86simd.rulev[2375] = new Rule(2375, false, true, 2188, "2375: _2145 -> (BAND I32 con _2144)", null, null, null, 0L, false, false, new int[]{19, 2187}, null);
        CodeGenerator_x86simd.rulev[2379] = new Rule(2379, false, true, 2192, "2379: _2149 -> (BAND I32 con _2148)", null, null, null, 0L, false, false, new int[]{19, 2191}, null);
        CodeGenerator_x86simd.rulev[2381] = new Rule(2381, false, true, 2194, "2381: _2151 -> (BAND I32 con _2150)", null, null, null, 0L, false, false, new int[]{19, 2193}, null);
        CodeGenerator_x86simd.rulev[2385] = new Rule(2385, false, true, 2198, "2385: _2155 -> (BAND I32 con _2154)", null, null, null, 0L, false, false, new int[]{19, 2197}, null);
        CodeGenerator_x86simd.rulev[2387] = new Rule(2387, false, true, 2200, "2387: _2157 -> (BAND I32 con _2156)", null, null, null, 0L, false, false, new int[]{19, 2199}, null);
        CodeGenerator_x86simd.rulev[2391] = new Rule(2391, false, true, 2204, "2391: _2161 -> (BAND I32 con _2160)", null, null, null, 0L, false, false, new int[]{19, 2203}, null);
        CodeGenerator_x86simd.rulev[2393] = new Rule(2393, false, true, 2206, "2393: _2163 -> (BAND I32 con _2162)", null, null, null, 0L, false, false, new int[]{19, 2205}, null);
        CodeGenerator_x86simd.rulev[2398] = new Rule(2398, false, true, 2210, "2398: _2167 -> (BAND I32 con _2166)", null, null, null, 0L, false, false, new int[]{19, 2209}, null);
        CodeGenerator_x86simd.rulev[2400] = new Rule(2400, false, true, 2212, "2400: _2169 -> (BAND I32 con _2168)", null, null, null, 0L, false, false, new int[]{19, 2211}, null);
        CodeGenerator_x86simd.rulev[2404] = new Rule(2404, false, true, 2216, "2404: _2173 -> (BAND I32 con _2172)", null, null, null, 0L, false, false, new int[]{19, 2215}, null);
        CodeGenerator_x86simd.rulev[2406] = new Rule(2406, false, true, 2218, "2406: _2175 -> (BAND I32 con _2174)", null, null, null, 0L, false, false, new int[]{19, 2217}, null);
        CodeGenerator_x86simd.rulev[2410] = new Rule(2410, false, true, 2222, "2410: _2179 -> (BAND I32 con _2178)", null, null, null, 0L, false, false, new int[]{19, 2221}, null);
        CodeGenerator_x86simd.rulev[2412] = new Rule(2412, false, true, 2224, "2412: _2181 -> (BAND I32 con _2180)", null, null, null, 0L, false, false, new int[]{19, 2223}, null);
        CodeGenerator_x86simd.rulev[2416] = new Rule(2416, false, true, 2228, "2416: _2185 -> (BAND I32 con _2184)", null, null, null, 0L, false, false, new int[]{19, 2227}, null);
        CodeGenerator_x86simd.rulev[2418] = new Rule(2418, false, true, 2230, "2418: _2187 -> (BAND I32 con _2186)", null, null, null, 0L, false, false, new int[]{19, 2229}, null);
        CodeGenerator_x86simd.rulev[2489] = new Rule(2489, false, true, 2298, "2489: _2255 -> (BAND I32 con _2254)", null, null, null, 0L, false, false, new int[]{19, 2297}, null);
        CodeGenerator_x86simd.rulev[2491] = new Rule(2491, false, true, 2300, "2491: _2257 -> (BAND I32 con _2256)", null, null, null, 0L, false, false, new int[]{19, 2299}, null);
        CodeGenerator_x86simd.rulev[2495] = new Rule(2495, false, true, 2304, "2495: _2261 -> (BAND I32 con _2260)", null, null, null, 0L, false, false, new int[]{19, 2303}, null);
        CodeGenerator_x86simd.rulev[2497] = new Rule(2497, false, true, 2306, "2497: _2263 -> (BAND I32 con _2262)", null, null, null, 0L, false, false, new int[]{19, 2305}, null);
        CodeGenerator_x86simd.rulev[2632] = new Rule(2632, false, true, 2438, "2632: _2395 -> (BAND I32 con _2394)", null, null, null, 0L, false, false, new int[]{19, 2437}, null);
        CodeGenerator_x86simd.rulev[2634] = new Rule(2634, false, true, 2440, "2634: _2397 -> (BAND I32 con _2396)", null, null, null, 0L, false, false, new int[]{19, 2439}, null);
        CodeGenerator_x86simd.rulev[2638] = new Rule(2638, false, true, 2444, "2638: _2401 -> (BAND I32 con _2400)", null, null, null, 0L, false, false, new int[]{19, 2443}, null);
        CodeGenerator_x86simd.rulev[2640] = new Rule(2640, false, true, 2446, "2640: _2403 -> (BAND I32 con _2402)", null, null, null, 0L, false, false, new int[]{19, 2445}, null);
        CodeGenerator_x86simd.rulev[2644] = new Rule(2644, false, true, 2450, "2644: _2407 -> (BAND I32 con _2406)", null, null, null, 0L, false, false, new int[]{19, 2449}, null);
        CodeGenerator_x86simd.rulev[2646] = new Rule(2646, false, true, 2452, "2646: _2409 -> (BAND I32 con _2408)", null, null, null, 0L, false, false, new int[]{19, 2451}, null);
        CodeGenerator_x86simd.rulev[2650] = new Rule(2650, false, true, 2456, "2650: _2413 -> (BAND I32 con _2412)", null, null, null, 0L, false, false, new int[]{19, 2455}, null);
        CodeGenerator_x86simd.rulev[2652] = new Rule(2652, false, true, 2458, "2652: _2415 -> (BAND I32 con _2414)", null, null, null, 0L, false, false, new int[]{19, 2457}, null);
        CodeGenerator_x86simd.rulev[2723] = new Rule(2723, false, true, 2526, "2723: _2483 -> (BAND I32 con _2482)", null, null, null, 0L, false, false, new int[]{19, 2525}, null);
        CodeGenerator_x86simd.rulev[2725] = new Rule(2725, false, true, 2528, "2725: _2485 -> (BAND I32 con _2484)", null, null, null, 0L, false, false, new int[]{19, 2527}, null);
        CodeGenerator_x86simd.rulev[2729] = new Rule(2729, false, true, 2532, "2729: _2489 -> (BAND I32 con _2488)", null, null, null, 0L, false, false, new int[]{19, 2531}, null);
        CodeGenerator_x86simd.rulev[2731] = new Rule(2731, false, true, 2534, "2731: _2491 -> (BAND I32 con _2490)", null, null, null, 0L, false, false, new int[]{19, 2533}, null);
        CodeGenerator_x86simd.rulev[2866] = new Rule(2866, false, true, 2666, "2866: _2623 -> (BAND I32 con _2622)", null, null, null, 0L, false, false, new int[]{19, 2665}, null);
        CodeGenerator_x86simd.rulev[2868] = new Rule(2868, false, true, 2668, "2868: _2625 -> (BAND I32 con _2624)", null, null, null, 0L, false, false, new int[]{19, 2667}, null);
        CodeGenerator_x86simd.rulev[2872] = new Rule(2872, false, true, 2672, "2872: _2629 -> (BAND I32 con _2628)", null, null, null, 0L, false, false, new int[]{19, 2671}, null);
        CodeGenerator_x86simd.rulev[2874] = new Rule(2874, false, true, 2674, "2874: _2631 -> (BAND I32 con _2630)", null, null, null, 0L, false, false, new int[]{19, 2673}, null);
        CodeGenerator_x86simd.rulev[2878] = new Rule(2878, false, true, 2678, "2878: _2635 -> (BAND I32 con _2634)", null, null, null, 0L, false, false, new int[]{19, 2677}, null);
        CodeGenerator_x86simd.rulev[2880] = new Rule(2880, false, true, 2680, "2880: _2637 -> (BAND I32 con _2636)", null, null, null, 0L, false, false, new int[]{19, 2679}, null);
        CodeGenerator_x86simd.rulev[2884] = new Rule(2884, false, true, 2684, "2884: _2641 -> (BAND I32 con _2640)", null, null, null, 0L, false, false, new int[]{19, 2683}, null);
        CodeGenerator_x86simd.rulev[2886] = new Rule(2886, false, true, 2686, "2886: _2643 -> (BAND I32 con _2642)", null, null, null, 0L, false, false, new int[]{19, 2685}, null);
        CodeGenerator_x86simd.rulev[3166] = new Rule(3166, false, true, 2939, "3166: _2896 -> (BAND I32 _2895 _125)", null, null, null, 0L, false, false, new int[]{2938, 168}, null);
        CodeGenerator_x86simd.rulev[3169] = new Rule(3169, false, true, 2942, "3169: _2899 -> (BAND I32 _2898 _127)", null, null, null, 0L, false, false, new int[]{2941, 170}, null);
    }

    private static void rrinit1400() {
        CodeGenerator_x86simd.rulev[3247] = new Rule(3247, false, true, 3017, "3247: _2974 -> (BAND I32 _2973 _65)", null, null, null, 0L, false, false, new int[]{3016, 108}, null);
        CodeGenerator_x86simd.rulev[3250] = new Rule(3250, false, true, 3020, "3250: _2977 -> (BAND I32 _2976 _67)", null, null, null, 0L, false, false, new int[]{3019, 110}, null);
        CodeGenerator_x86simd.rulev[3253] = new Rule(3253, false, true, 3023, "3253: _2980 -> (BAND I32 _2979 _69)", null, null, null, 0L, false, false, new int[]{3022, 112}, null);
        CodeGenerator_x86simd.rulev[3256] = new Rule(3256, false, true, 3026, "3256: _2983 -> (BAND I32 _2982 _71)", null, null, null, 0L, false, false, new int[]{3025, 114}, null);
        CodeGenerator_x86simd.rulev[3376] = new Rule(3376, false, true, 3132, "3376: _3089 -> (BAND I32 _125 _125)", null, null, null, 0L, false, false, new int[]{168, 168}, null);
        CodeGenerator_x86simd.rulev[3378] = new Rule(3378, false, true, 3134, "3378: _3091 -> (BAND I32 _127 _127)", null, null, null, 0L, false, false, new int[]{170, 170}, null);
        CodeGenerator_x86simd.rulev[3612] = new Rule(3612, false, true, 3352, "3612: _3309 -> (BAND I32 _65 _65)", null, null, null, 0L, false, false, new int[]{108, 108}, null);
        CodeGenerator_x86simd.rulev[3614] = new Rule(3614, false, true, 3354, "3614: _3311 -> (BAND I32 _67 _67)", null, null, null, 0L, false, false, new int[]{110, 110}, null);
        CodeGenerator_x86simd.rulev[3616] = new Rule(3616, false, true, 3356, "3616: _3313 -> (BAND I32 _69 _69)", null, null, null, 0L, false, false, new int[]{112, 112}, null);
        CodeGenerator_x86simd.rulev[3618] = new Rule(3618, false, true, 3358, "3618: _3315 -> (BAND I32 _71 _71)", null, null, null, 0L, false, false, new int[]{114, 114}, null);
        CodeGenerator_x86simd.rulev[4005] = new Rule(4005, false, false, 4, "4005: regl -> (BAND I32 regl mrcl)", ImList.list(ImList.list("andl", "$2", "$0")), null, null, 2L, false, false, new int[]{4, 40}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4019] = new Rule(4019, false, false, 4, "4019: regl -> (BAND I32 mrcl regl)", ImList.list(ImList.list("andl", "$1", "$0")), null, null, 4L, false, false, new int[]{40, 4}, new String[]{"*reg-I32*", null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[3976] = new Rule(3976, false, false, 3, "3976: regq -> (BAND I64 regq mrcq)", ImList.list(ImList.list("andl", ImList.list("qlow", "$2"), ImList.list("qlow", "$0")), ImList.list("andl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{3, 47}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86simd.rulev[464] = new Rule(464, false, true, 317, "464: _274 -> (BOR I8 _271 _273)", null, null, null, 0L, false, false, new int[]{314, 316}, null);
        CodeGenerator_x86simd.rulev[470] = new Rule(470, false, true, 323, "470: _280 -> (BOR I8 _277 _279)", null, null, null, 0L, false, false, new int[]{320, 322}, null);
        CodeGenerator_x86simd.rulev[477] = new Rule(477, false, true, 330, "477: _287 -> (BOR I8 _284 _286)", null, null, null, 0L, false, false, new int[]{327, 329}, null);
        CodeGenerator_x86simd.rulev[484] = new Rule(484, false, true, 337, "484: _294 -> (BOR I8 _291 _293)", null, null, null, 0L, false, false, new int[]{334, 336}, null);
        CodeGenerator_x86simd.rulev[491] = new Rule(491, false, true, 344, "491: _301 -> (BOR I8 _298 _300)", null, null, null, 0L, false, false, new int[]{341, 343}, null);
        CodeGenerator_x86simd.rulev[498] = new Rule(498, false, true, 351, "498: _308 -> (BOR I8 _305 _307)", null, null, null, 0L, false, false, new int[]{348, 350}, null);
        CodeGenerator_x86simd.rulev[505] = new Rule(505, false, true, 358, "505: _315 -> (BOR I8 _312 _314)", null, null, null, 0L, false, false, new int[]{355, 357}, null);
        CodeGenerator_x86simd.rulev[512] = new Rule(512, false, true, 365, "512: _322 -> (BOR I8 _319 _321)", null, null, null, 0L, false, false, new int[]{362, 364}, null);
        CodeGenerator_x86simd.rulev[520] = new Rule(520, false, true, 372, "520: _329 -> (BOR I8 _326 _328)", null, null, null, 0L, false, false, new int[]{369, 371}, null);
        CodeGenerator_x86simd.rulev[526] = new Rule(526, false, true, 378, "526: _335 -> (BOR I8 _332 _334)", null, null, null, 0L, false, false, new int[]{375, 377}, null);
        CodeGenerator_x86simd.rulev[533] = new Rule(533, false, true, 385, "533: _342 -> (BOR I8 _339 _341)", null, null, null, 0L, false, false, new int[]{382, 384}, null);
        CodeGenerator_x86simd.rulev[540] = new Rule(540, false, true, 392, "540: _349 -> (BOR I8 _346 _348)", null, null, null, 0L, false, false, new int[]{389, 391}, null);
        CodeGenerator_x86simd.rulev[547] = new Rule(547, false, true, 399, "547: _356 -> (BOR I8 _353 _355)", null, null, null, 0L, false, false, new int[]{396, 398}, null);
        CodeGenerator_x86simd.rulev[554] = new Rule(554, false, true, 406, "554: _363 -> (BOR I8 _360 _362)", null, null, null, 0L, false, false, new int[]{403, 405}, null);
        CodeGenerator_x86simd.rulev[561] = new Rule(561, false, true, 413, "561: _370 -> (BOR I8 _367 _369)", null, null, null, 0L, false, false, new int[]{410, 412}, null);
        CodeGenerator_x86simd.rulev[568] = new Rule(568, false, true, 420, "568: _377 -> (BOR I8 _374 _376)", null, null, null, 0L, false, false, new int[]{417, 419}, null);
        CodeGenerator_x86simd.rulev[576] = new Rule(576, false, true, 428, "576: _385 -> (BOR I8 _382 _384)", null, null, null, 0L, false, false, new int[]{425, 427}, null);
        CodeGenerator_x86simd.rulev[582] = new Rule(582, false, true, 434, "582: _391 -> (BOR I8 _388 _390)", null, null, null, 0L, false, false, new int[]{431, 433}, null);
        CodeGenerator_x86simd.rulev[589] = new Rule(589, false, true, 441, "589: _398 -> (BOR I8 _395 _397)", null, null, null, 0L, false, false, new int[]{438, 440}, null);
        CodeGenerator_x86simd.rulev[596] = new Rule(596, false, true, 448, "596: _405 -> (BOR I8 _402 _404)", null, null, null, 0L, false, false, new int[]{445, 447}, null);
        CodeGenerator_x86simd.rulev[603] = new Rule(603, false, true, 455, "603: _412 -> (BOR I8 _409 _411)", null, null, null, 0L, false, false, new int[]{452, 454}, null);
        CodeGenerator_x86simd.rulev[610] = new Rule(610, false, true, 462, "610: _419 -> (BOR I8 _416 _418)", null, null, null, 0L, false, false, new int[]{459, 461}, null);
        CodeGenerator_x86simd.rulev[617] = new Rule(617, false, true, 469, "617: _426 -> (BOR I8 _423 _425)", null, null, null, 0L, false, false, new int[]{466, 468}, null);
        CodeGenerator_x86simd.rulev[624] = new Rule(624, false, true, 476, "624: _433 -> (BOR I8 _430 _432)", null, null, null, 0L, false, false, new int[]{473, 475}, null);
        CodeGenerator_x86simd.rulev[664] = new Rule(664, false, true, 514, "664: _471 -> (BOR I8 _101 _101)", null, null, null, 0L, false, false, new int[]{144, 144}, null);
        CodeGenerator_x86simd.rulev[670] = new Rule(670, false, true, 520, "670: _477 -> (BOR I8 _103 _103)", null, null, null, 0L, false, false, new int[]{146, 146}, null);
        CodeGenerator_x86simd.rulev[676] = new Rule(676, false, true, 526, "676: _483 -> (BOR I8 _105 _105)", null, null, null, 0L, false, false, new int[]{148, 148}, null);
        CodeGenerator_x86simd.rulev[682] = new Rule(682, false, true, 532, "682: _489 -> (BOR I8 _107 _107)", null, null, null, 0L, false, false, new int[]{150, 150}, null);
        CodeGenerator_x86simd.rulev[688] = new Rule(688, false, true, 538, "688: _495 -> (BOR I8 _109 _109)", null, null, null, 0L, false, false, new int[]{152, 152}, null);
        CodeGenerator_x86simd.rulev[694] = new Rule(694, false, true, 544, "694: _501 -> (BOR I8 _111 _111)", null, null, null, 0L, false, false, new int[]{154, 154}, null);
        CodeGenerator_x86simd.rulev[700] = new Rule(700, false, true, 550, "700: _507 -> (BOR I8 _113 _113)", null, null, null, 0L, false, false, new int[]{156, 156}, null);
        CodeGenerator_x86simd.rulev[706] = new Rule(706, false, true, 556, "706: _513 -> (BOR I8 _115 _115)", null, null, null, 0L, false, false, new int[]{158, 158}, null);
        CodeGenerator_x86simd.rulev[778] = new Rule(778, false, true, 626, "778: _583 -> (BOR I8 _7 _7)", null, null, null, 0L, false, false, new int[]{50, 50}, null);
        CodeGenerator_x86simd.rulev[784] = new Rule(784, false, true, 632, "784: _589 -> (BOR I8 _9 _9)", null, null, null, 0L, false, false, new int[]{52, 52}, null);
        CodeGenerator_x86simd.rulev[790] = new Rule(790, false, true, 638, "790: _595 -> (BOR I8 _11 _11)", null, null, null, 0L, false, false, new int[]{54, 54}, null);
        CodeGenerator_x86simd.rulev[796] = new Rule(796, false, true, 644, "796: _601 -> (BOR I8 _13 _13)", null, null, null, 0L, false, false, new int[]{56, 56}, null);
        CodeGenerator_x86simd.rulev[802] = new Rule(802, false, true, 650, "802: _607 -> (BOR I8 _15 _15)", null, null, null, 0L, false, false, new int[]{58, 58}, null);
        CodeGenerator_x86simd.rulev[808] = new Rule(808, false, true, 656, "808: _613 -> (BOR I8 _18 _18)", null, null, null, 0L, false, false, new int[]{61, 61}, null);
        CodeGenerator_x86simd.rulev[814] = new Rule(814, false, true, 662, "814: _619 -> (BOR I8 _21 _21)", null, null, null, 0L, false, false, new int[]{64, 64}, null);
        CodeGenerator_x86simd.rulev[820] = new Rule(820, false, true, 668, "820: _625 -> (BOR I8 _24 _24)", null, null, null, 0L, false, false, new int[]{67, 67}, null);
        CodeGenerator_x86simd.rulev[826] = new Rule(826, false, true, 674, "826: _631 -> (BOR I8 _26 _26)", null, null, null, 0L, false, false, new int[]{69, 69}, null);
        CodeGenerator_x86simd.rulev[832] = new Rule(832, false, true, 680, "832: _637 -> (BOR I8 _29 _29)", null, null, null, 0L, false, false, new int[]{72, 72}, null);
        CodeGenerator_x86simd.rulev[838] = new Rule(838, false, true, 686, "838: _643 -> (BOR I8 _32 _32)", null, null, null, 0L, false, false, new int[]{75, 75}, null);
        CodeGenerator_x86simd.rulev[844] = new Rule(844, false, true, 692, "844: _649 -> (BOR I8 _35 _35)", null, null, null, 0L, false, false, new int[]{78, 78}, null);
        CodeGenerator_x86simd.rulev[850] = new Rule(850, false, true, 698, "850: _655 -> (BOR I8 _38 _38)", null, null, null, 0L, false, false, new int[]{81, 81}, null);
        CodeGenerator_x86simd.rulev[856] = new Rule(856, false, true, 704, "856: _661 -> (BOR I8 _41 _41)", null, null, null, 0L, false, false, new int[]{84, 84}, null);
        CodeGenerator_x86simd.rulev[862] = new Rule(862, false, true, 710, "862: _667 -> (BOR I8 _44 _44)", null, null, null, 0L, false, false, new int[]{87, 87}, null);
        CodeGenerator_x86simd.rulev[868] = new Rule(868, false, true, 716, "868: _673 -> (BOR I8 _47 _47)", null, null, null, 0L, false, false, new int[]{90, 90}, null);
        CodeGenerator_x86simd.rulev[1002] = new Rule(1002, false, true, 845, "1002: _802 -> (BOR I8 _799 _801)", null, null, null, 0L, false, false, new int[]{842, 844}, null);
        CodeGenerator_x86simd.rulev[1008] = new Rule(1008, false, true, 851, "1008: _808 -> (BOR I8 _805 _807)", null, null, null, 0L, false, false, new int[]{848, 850}, null);
        CodeGenerator_x86simd.rulev[1014] = new Rule(1014, false, true, 857, "1014: _814 -> (BOR I8 _811 _813)", null, null, null, 0L, false, false, new int[]{854, 856}, null);
        CodeGenerator_x86simd.rulev[1020] = new Rule(1020, false, true, 863, "1020: _820 -> (BOR I8 _817 _819)", null, null, null, 0L, false, false, new int[]{860, 862}, null);
        CodeGenerator_x86simd.rulev[1026] = new Rule(1026, false, true, 869, "1026: _826 -> (BOR I8 _823 _825)", null, null, null, 0L, false, false, new int[]{866, 868}, null);
        CodeGenerator_x86simd.rulev[1032] = new Rule(1032, false, true, 875, "1032: _832 -> (BOR I8 _829 _831)", null, null, null, 0L, false, false, new int[]{872, 874}, null);
        CodeGenerator_x86simd.rulev[1038] = new Rule(1038, false, true, 881, "1038: _838 -> (BOR I8 _835 _837)", null, null, null, 0L, false, false, new int[]{878, 880}, null);
        CodeGenerator_x86simd.rulev[1044] = new Rule(1044, false, true, 887, "1044: _844 -> (BOR I8 _841 _843)", null, null, null, 0L, false, false, new int[]{884, 886}, null);
        CodeGenerator_x86simd.rulev[1051] = new Rule(1051, false, true, 893, "1051: _850 -> (BOR I8 _847 _849)", null, null, null, 0L, false, false, new int[]{890, 892}, null);
        CodeGenerator_x86simd.rulev[1057] = new Rule(1057, false, true, 899, "1057: _856 -> (BOR I8 _853 _855)", null, null, null, 0L, false, false, new int[]{896, 898}, null);
        CodeGenerator_x86simd.rulev[1063] = new Rule(1063, false, true, 905, "1063: _862 -> (BOR I8 _859 _861)", null, null, null, 0L, false, false, new int[]{902, 904}, null);
        CodeGenerator_x86simd.rulev[1069] = new Rule(1069, false, true, 911, "1069: _868 -> (BOR I8 _865 _867)", null, null, null, 0L, false, false, new int[]{908, 910}, null);
        CodeGenerator_x86simd.rulev[1075] = new Rule(1075, false, true, 917, "1075: _874 -> (BOR I8 _871 _873)", null, null, null, 0L, false, false, new int[]{914, 916}, null);
        CodeGenerator_x86simd.rulev[1081] = new Rule(1081, false, true, 923, "1081: _880 -> (BOR I8 _877 _879)", null, null, null, 0L, false, false, new int[]{920, 922}, null);
        CodeGenerator_x86simd.rulev[1087] = new Rule(1087, false, true, 929, "1087: _886 -> (BOR I8 _883 _885)", null, null, null, 0L, false, false, new int[]{926, 928}, null);
        CodeGenerator_x86simd.rulev[1093] = new Rule(1093, false, true, 935, "1093: _892 -> (BOR I8 _889 _891)", null, null, null, 0L, false, false, new int[]{932, 934}, null);
        CodeGenerator_x86simd.rulev[1100] = new Rule(1100, false, true, 941, "1100: _898 -> (BOR I8 _895 _897)", null, null, null, 0L, false, false, new int[]{938, 940}, null);
        CodeGenerator_x86simd.rulev[1106] = new Rule(1106, false, true, 947, "1106: _904 -> (BOR I8 _901 _903)", null, null, null, 0L, false, false, new int[]{944, 946}, null);
        CodeGenerator_x86simd.rulev[1112] = new Rule(1112, false, true, 953, "1112: _910 -> (BOR I8 _907 _909)", null, null, null, 0L, false, false, new int[]{950, 952}, null);
        CodeGenerator_x86simd.rulev[1118] = new Rule(1118, false, true, 959, "1118: _916 -> (BOR I8 _913 _915)", null, null, null, 0L, false, false, new int[]{956, 958}, null);
        CodeGenerator_x86simd.rulev[1124] = new Rule(1124, false, true, 965, "1124: _922 -> (BOR I8 _919 _921)", null, null, null, 0L, false, false, new int[]{962, 964}, null);
        CodeGenerator_x86simd.rulev[1130] = new Rule(1130, false, true, 971, "1130: _928 -> (BOR I8 _925 _927)", null, null, null, 0L, false, false, new int[]{968, 970}, null);
        CodeGenerator_x86simd.rulev[1136] = new Rule(1136, false, true, 977, "1136: _934 -> (BOR I8 _931 _933)", null, null, null, 0L, false, false, new int[]{974, 976}, null);
        CodeGenerator_x86simd.rulev[1142] = new Rule(1142, false, true, 983, "1142: _940 -> (BOR I8 _937 _939)", null, null, null, 0L, false, false, new int[]{980, 982}, null);
        CodeGenerator_x86simd.rulev[1148] = new Rule(1148, false, true, 989, "1148: _946 -> (BOR I8 _943 _945)", null, null, null, 0L, false, false, new int[]{986, 988}, null);
        CodeGenerator_x86simd.rulev[1154] = new Rule(1154, false, true, 995, "1154: _952 -> (BOR I8 _949 _951)", null, null, null, 0L, false, false, new int[]{992, 994}, null);
        CodeGenerator_x86simd.rulev[1160] = new Rule(1160, false, true, 1001, "1160: _958 -> (BOR I8 _955 _957)", null, null, null, 0L, false, false, new int[]{998, 1000}, null);
        CodeGenerator_x86simd.rulev[1166] = new Rule(1166, false, true, 1007, "1166: _964 -> (BOR I8 _961 _963)", null, null, null, 0L, false, false, new int[]{1004, 1006}, null);
        CodeGenerator_x86simd.rulev[1172] = new Rule(1172, false, true, 1013, "1172: _970 -> (BOR I8 _967 _969)", null, null, null, 0L, false, false, new int[]{1010, 1012}, null);
        CodeGenerator_x86simd.rulev[1178] = new Rule(1178, false, true, 1019, "1178: _976 -> (BOR I8 _973 _975)", null, null, null, 0L, false, false, new int[]{1016, 1018}, null);
        CodeGenerator_x86simd.rulev[1184] = new Rule(1184, false, true, 1025, "1184: _982 -> (BOR I8 _979 _981)", null, null, null, 0L, false, false, new int[]{1022, 1024}, null);
        CodeGenerator_x86simd.rulev[1190] = new Rule(1190, false, true, 1031, "1190: _988 -> (BOR I8 _985 _987)", null, null, null, 0L, false, false, new int[]{1028, 1030}, null);
        CodeGenerator_x86simd.rulev[1197] = new Rule(1197, false, true, 1037, "1197: _994 -> (BOR I8 _991 _993)", null, null, null, 0L, false, false, new int[]{1034, 1036}, null);
        CodeGenerator_x86simd.rulev[1203] = new Rule(1203, false, true, 1043, "1203: _1000 -> (BOR I8 _997 _999)", null, null, null, 0L, false, false, new int[]{1040, 1042}, null);
        CodeGenerator_x86simd.rulev[1209] = new Rule(1209, false, true, 1049, "1209: _1006 -> (BOR I8 _1003 _1005)", null, null, null, 0L, false, false, new int[]{1046, 1048}, null);
        CodeGenerator_x86simd.rulev[1215] = new Rule(1215, false, true, 1055, "1215: _1012 -> (BOR I8 _1009 _1011)", null, null, null, 0L, false, false, new int[]{1052, 1054}, null);
        CodeGenerator_x86simd.rulev[1221] = new Rule(1221, false, true, 1061, "1221: _1018 -> (BOR I8 _1015 _1017)", null, null, null, 0L, false, false, new int[]{1058, 1060}, null);
        CodeGenerator_x86simd.rulev[1227] = new Rule(1227, false, true, 1067, "1227: _1024 -> (BOR I8 _1021 _1023)", null, null, null, 0L, false, false, new int[]{1064, 1066}, null);
        CodeGenerator_x86simd.rulev[1233] = new Rule(1233, false, true, 1073, "1233: _1030 -> (BOR I8 _1027 _1029)", null, null, null, 0L, false, false, new int[]{1070, 1072}, null);
    }

    private static void rrinit1500() {
        CodeGenerator_x86simd.rulev[1239] = new Rule(1239, false, true, 1079, "1239: _1036 -> (BOR I8 _1033 _1035)", null, null, null, 0L, false, false, new int[]{1076, 1078}, null);
        CodeGenerator_x86simd.rulev[1245] = new Rule(1245, false, true, 1085, "1245: _1042 -> (BOR I8 _1039 _1041)", null, null, null, 0L, false, false, new int[]{1082, 1084}, null);
        CodeGenerator_x86simd.rulev[1251] = new Rule(1251, false, true, 1091, "1251: _1048 -> (BOR I8 _1045 _1047)", null, null, null, 0L, false, false, new int[]{1088, 1090}, null);
        CodeGenerator_x86simd.rulev[1257] = new Rule(1257, false, true, 1097, "1257: _1054 -> (BOR I8 _1051 _1053)", null, null, null, 0L, false, false, new int[]{1094, 1096}, null);
        CodeGenerator_x86simd.rulev[1263] = new Rule(1263, false, true, 1103, "1263: _1060 -> (BOR I8 _1057 _1059)", null, null, null, 0L, false, false, new int[]{1100, 1102}, null);
        CodeGenerator_x86simd.rulev[1269] = new Rule(1269, false, true, 1109, "1269: _1066 -> (BOR I8 _1063 _1065)", null, null, null, 0L, false, false, new int[]{1106, 1108}, null);
        CodeGenerator_x86simd.rulev[1275] = new Rule(1275, false, true, 1115, "1275: _1072 -> (BOR I8 _1069 _1071)", null, null, null, 0L, false, false, new int[]{1112, 1114}, null);
        CodeGenerator_x86simd.rulev[1281] = new Rule(1281, false, true, 1121, "1281: _1078 -> (BOR I8 _1075 _1077)", null, null, null, 0L, false, false, new int[]{1118, 1120}, null);
        CodeGenerator_x86simd.rulev[1287] = new Rule(1287, false, true, 1127, "1287: _1084 -> (BOR I8 _1081 _1083)", null, null, null, 0L, false, false, new int[]{1124, 1126}, null);
        CodeGenerator_x86simd.rulev[1442] = new Rule(1442, false, true, 1277, "1442: _1234 -> (BOR I8 _1231 _1233)", null, null, null, 0L, false, false, new int[]{1274, 1276}, null);
        CodeGenerator_x86simd.rulev[1448] = new Rule(1448, false, true, 1283, "1448: _1240 -> (BOR I8 _1237 _1239)", null, null, null, 0L, false, false, new int[]{1280, 1282}, null);
        CodeGenerator_x86simd.rulev[1454] = new Rule(1454, false, true, 1289, "1454: _1246 -> (BOR I8 _1243 _1245)", null, null, null, 0L, false, false, new int[]{1286, 1288}, null);
        CodeGenerator_x86simd.rulev[1460] = new Rule(1460, false, true, 1295, "1460: _1252 -> (BOR I8 _1249 _1251)", null, null, null, 0L, false, false, new int[]{1292, 1294}, null);
        CodeGenerator_x86simd.rulev[1466] = new Rule(1466, false, true, 1301, "1466: _1258 -> (BOR I8 _1255 _1257)", null, null, null, 0L, false, false, new int[]{1298, 1300}, null);
        CodeGenerator_x86simd.rulev[1472] = new Rule(1472, false, true, 1307, "1472: _1264 -> (BOR I8 _1261 _1263)", null, null, null, 0L, false, false, new int[]{1304, 1306}, null);
        CodeGenerator_x86simd.rulev[1478] = new Rule(1478, false, true, 1313, "1478: _1270 -> (BOR I8 _1267 _1269)", null, null, null, 0L, false, false, new int[]{1310, 1312}, null);
        CodeGenerator_x86simd.rulev[1484] = new Rule(1484, false, true, 1319, "1484: _1276 -> (BOR I8 _1273 _1275)", null, null, null, 0L, false, false, new int[]{1316, 1318}, null);
        CodeGenerator_x86simd.rulev[1491] = new Rule(1491, false, true, 1325, "1491: _1282 -> (BOR I8 _1279 _1281)", null, null, null, 0L, false, false, new int[]{1322, 1324}, null);
        CodeGenerator_x86simd.rulev[1497] = new Rule(1497, false, true, 1331, "1497: _1288 -> (BOR I8 _1285 _1287)", null, null, null, 0L, false, false, new int[]{1328, 1330}, null);
        CodeGenerator_x86simd.rulev[1503] = new Rule(1503, false, true, 1337, "1503: _1294 -> (BOR I8 _1291 _1293)", null, null, null, 0L, false, false, new int[]{1334, 1336}, null);
        CodeGenerator_x86simd.rulev[1509] = new Rule(1509, false, true, 1343, "1509: _1300 -> (BOR I8 _1297 _1299)", null, null, null, 0L, false, false, new int[]{1340, 1342}, null);
        CodeGenerator_x86simd.rulev[1515] = new Rule(1515, false, true, 1349, "1515: _1306 -> (BOR I8 _1303 _1305)", null, null, null, 0L, false, false, new int[]{1346, 1348}, null);
        CodeGenerator_x86simd.rulev[1521] = new Rule(1521, false, true, 1355, "1521: _1312 -> (BOR I8 _1309 _1311)", null, null, null, 0L, false, false, new int[]{1352, 1354}, null);
        CodeGenerator_x86simd.rulev[1527] = new Rule(1527, false, true, 1361, "1527: _1318 -> (BOR I8 _1315 _1317)", null, null, null, 0L, false, false, new int[]{1358, 1360}, null);
        CodeGenerator_x86simd.rulev[1533] = new Rule(1533, false, true, 1367, "1533: _1324 -> (BOR I8 _1321 _1323)", null, null, null, 0L, false, false, new int[]{1364, 1366}, null);
        CodeGenerator_x86simd.rulev[1616] = new Rule(1616, false, true, 1445, "1616: _1402 -> (BOR I8 _1399 _1401)", null, null, null, 0L, false, false, new int[]{1442, 1444}, null);
        CodeGenerator_x86simd.rulev[1622] = new Rule(1622, false, true, 1451, "1622: _1408 -> (BOR I8 _1405 _1407)", null, null, null, 0L, false, false, new int[]{1448, 1450}, null);
        CodeGenerator_x86simd.rulev[1628] = new Rule(1628, false, true, 1457, "1628: _1414 -> (BOR I8 _1411 _1413)", null, null, null, 0L, false, false, new int[]{1454, 1456}, null);
        CodeGenerator_x86simd.rulev[1634] = new Rule(1634, false, true, 1463, "1634: _1420 -> (BOR I8 _1417 _1419)", null, null, null, 0L, false, false, new int[]{1460, 1462}, null);
        CodeGenerator_x86simd.rulev[1640] = new Rule(1640, false, true, 1469, "1640: _1426 -> (BOR I8 _1423 _1425)", null, null, null, 0L, false, false, new int[]{1466, 1468}, null);
        CodeGenerator_x86simd.rulev[1646] = new Rule(1646, false, true, 1475, "1646: _1432 -> (BOR I8 _1429 _1431)", null, null, null, 0L, false, false, new int[]{1472, 1474}, null);
        CodeGenerator_x86simd.rulev[1652] = new Rule(1652, false, true, 1481, "1652: _1438 -> (BOR I8 _1435 _1437)", null, null, null, 0L, false, false, new int[]{1478, 1480}, null);
        CodeGenerator_x86simd.rulev[1658] = new Rule(1658, false, true, 1487, "1658: _1444 -> (BOR I8 _1441 _1443)", null, null, null, 0L, false, false, new int[]{1484, 1486}, null);
        CodeGenerator_x86simd.rulev[1664] = new Rule(1664, false, true, 1493, "1664: _1450 -> (BOR I8 _1447 _1449)", null, null, null, 0L, false, false, new int[]{1490, 1492}, null);
        CodeGenerator_x86simd.rulev[1670] = new Rule(1670, false, true, 1499, "1670: _1456 -> (BOR I8 _1453 _1455)", null, null, null, 0L, false, false, new int[]{1496, 1498}, null);
        CodeGenerator_x86simd.rulev[1676] = new Rule(1676, false, true, 1505, "1676: _1462 -> (BOR I8 _1459 _1461)", null, null, null, 0L, false, false, new int[]{1502, 1504}, null);
        CodeGenerator_x86simd.rulev[1682] = new Rule(1682, false, true, 1511, "1682: _1468 -> (BOR I8 _1465 _1467)", null, null, null, 0L, false, false, new int[]{1508, 1510}, null);
        CodeGenerator_x86simd.rulev[1688] = new Rule(1688, false, true, 1517, "1688: _1474 -> (BOR I8 _1471 _1473)", null, null, null, 0L, false, false, new int[]{1514, 1516}, null);
        CodeGenerator_x86simd.rulev[1694] = new Rule(1694, false, true, 1523, "1694: _1480 -> (BOR I8 _1477 _1479)", null, null, null, 0L, false, false, new int[]{1520, 1522}, null);
        CodeGenerator_x86simd.rulev[1700] = new Rule(1700, false, true, 1529, "1700: _1486 -> (BOR I8 _1483 _1485)", null, null, null, 0L, false, false, new int[]{1526, 1528}, null);
        CodeGenerator_x86simd.rulev[1706] = new Rule(1706, false, true, 1535, "1706: _1492 -> (BOR I8 _1489 _1491)", null, null, null, 0L, false, false, new int[]{1532, 1534}, null);
        CodeGenerator_x86simd.rulev[1713] = new Rule(1713, false, true, 1541, "1713: _1498 -> (BOR I8 _1495 _1497)", null, null, null, 0L, false, false, new int[]{1538, 1540}, null);
        CodeGenerator_x86simd.rulev[1719] = new Rule(1719, false, true, 1547, "1719: _1504 -> (BOR I8 _1501 _1503)", null, null, null, 0L, false, false, new int[]{1544, 1546}, null);
        CodeGenerator_x86simd.rulev[1725] = new Rule(1725, false, true, 1553, "1725: _1510 -> (BOR I8 _1507 _1509)", null, null, null, 0L, false, false, new int[]{1550, 1552}, null);
        CodeGenerator_x86simd.rulev[1731] = new Rule(1731, false, true, 1559, "1731: _1516 -> (BOR I8 _1513 _1515)", null, null, null, 0L, false, false, new int[]{1556, 1558}, null);
        CodeGenerator_x86simd.rulev[1737] = new Rule(1737, false, true, 1565, "1737: _1522 -> (BOR I8 _1519 _1521)", null, null, null, 0L, false, false, new int[]{1562, 1564}, null);
        CodeGenerator_x86simd.rulev[1743] = new Rule(1743, false, true, 1571, "1743: _1528 -> (BOR I8 _1525 _1527)", null, null, null, 0L, false, false, new int[]{1568, 1570}, null);
        CodeGenerator_x86simd.rulev[1749] = new Rule(1749, false, true, 1577, "1749: _1534 -> (BOR I8 _1531 _1533)", null, null, null, 0L, false, false, new int[]{1574, 1576}, null);
        CodeGenerator_x86simd.rulev[1755] = new Rule(1755, false, true, 1583, "1755: _1540 -> (BOR I8 _1537 _1539)", null, null, null, 0L, false, false, new int[]{1580, 1582}, null);
        CodeGenerator_x86simd.rulev[1761] = new Rule(1761, false, true, 1589, "1761: _1546 -> (BOR I8 _1543 _1545)", null, null, null, 0L, false, false, new int[]{1586, 1588}, null);
        CodeGenerator_x86simd.rulev[1767] = new Rule(1767, false, true, 1595, "1767: _1552 -> (BOR I8 _1549 _1551)", null, null, null, 0L, false, false, new int[]{1592, 1594}, null);
        CodeGenerator_x86simd.rulev[1773] = new Rule(1773, false, true, 1601, "1773: _1558 -> (BOR I8 _1555 _1557)", null, null, null, 0L, false, false, new int[]{1598, 1600}, null);
        CodeGenerator_x86simd.rulev[1779] = new Rule(1779, false, true, 1607, "1779: _1564 -> (BOR I8 _1561 _1563)", null, null, null, 0L, false, false, new int[]{1604, 1606}, null);
        CodeGenerator_x86simd.rulev[1785] = new Rule(1785, false, true, 1613, "1785: _1570 -> (BOR I8 _1567 _1569)", null, null, null, 0L, false, false, new int[]{1610, 1612}, null);
        CodeGenerator_x86simd.rulev[1791] = new Rule(1791, false, true, 1619, "1791: _1576 -> (BOR I8 _1573 _1575)", null, null, null, 0L, false, false, new int[]{1616, 1618}, null);
        CodeGenerator_x86simd.rulev[1797] = new Rule(1797, false, true, 1625, "1797: _1582 -> (BOR I8 _1579 _1581)", null, null, null, 0L, false, false, new int[]{1622, 1624}, null);
        CodeGenerator_x86simd.rulev[1803] = new Rule(1803, false, true, 1631, "1803: _1588 -> (BOR I8 _1585 _1587)", null, null, null, 0L, false, false, new int[]{1628, 1630}, null);
        CodeGenerator_x86simd.rulev[1958] = new Rule(1958, false, true, 1781, "1958: _1738 -> (BOR I8 _1735 _1737)", null, null, null, 0L, false, false, new int[]{1778, 1780}, null);
        CodeGenerator_x86simd.rulev[1964] = new Rule(1964, false, true, 1787, "1964: _1744 -> (BOR I8 _1741 _1743)", null, null, null, 0L, false, false, new int[]{1784, 1786}, null);
        CodeGenerator_x86simd.rulev[1970] = new Rule(1970, false, true, 1793, "1970: _1750 -> (BOR I8 _1747 _1749)", null, null, null, 0L, false, false, new int[]{1790, 1792}, null);
        CodeGenerator_x86simd.rulev[1976] = new Rule(1976, false, true, 1799, "1976: _1756 -> (BOR I8 _1753 _1755)", null, null, null, 0L, false, false, new int[]{1796, 1798}, null);
        CodeGenerator_x86simd.rulev[1982] = new Rule(1982, false, true, 1805, "1982: _1762 -> (BOR I8 _1759 _1761)", null, null, null, 0L, false, false, new int[]{1802, 1804}, null);
        CodeGenerator_x86simd.rulev[1988] = new Rule(1988, false, true, 1811, "1988: _1768 -> (BOR I8 _1765 _1767)", null, null, null, 0L, false, false, new int[]{1808, 1810}, null);
        CodeGenerator_x86simd.rulev[1994] = new Rule(1994, false, true, 1817, "1994: _1774 -> (BOR I8 _1771 _1773)", null, null, null, 0L, false, false, new int[]{1814, 1816}, null);
        CodeGenerator_x86simd.rulev[2000] = new Rule(2000, false, true, 1823, "2000: _1780 -> (BOR I8 _1777 _1779)", null, null, null, 0L, false, false, new int[]{1820, 1822}, null);
        CodeGenerator_x86simd.rulev[2005] = new Rule(2005, false, true, 1827, "2005: _1784 -> (BOR I8 _1782 _1783)", null, null, null, 0L, false, false, new int[]{1825, 1826}, null);
        CodeGenerator_x86simd.rulev[2009] = new Rule(2009, false, true, 1831, "2009: _1788 -> (BOR I8 _1786 _1787)", null, null, null, 0L, false, false, new int[]{1829, 1830}, null);
        CodeGenerator_x86simd.rulev[2013] = new Rule(2013, false, true, 1835, "2013: _1792 -> (BOR I8 _1790 _1791)", null, null, null, 0L, false, false, new int[]{1833, 1834}, null);
        CodeGenerator_x86simd.rulev[2017] = new Rule(2017, false, true, 1839, "2017: _1796 -> (BOR I8 _1794 _1795)", null, null, null, 0L, false, false, new int[]{1837, 1838}, null);
        CodeGenerator_x86simd.rulev[2021] = new Rule(2021, false, true, 1843, "2021: _1800 -> (BOR I8 _1798 _1799)", null, null, null, 0L, false, false, new int[]{1841, 1842}, null);
        CodeGenerator_x86simd.rulev[2025] = new Rule(2025, false, true, 1847, "2025: _1804 -> (BOR I8 _1802 _1803)", null, null, null, 0L, false, false, new int[]{1845, 1846}, null);
        CodeGenerator_x86simd.rulev[2029] = new Rule(2029, false, true, 1851, "2029: _1808 -> (BOR I8 _1806 _1807)", null, null, null, 0L, false, false, new int[]{1849, 1850}, null);
        CodeGenerator_x86simd.rulev[2033] = new Rule(2033, false, true, 1855, "2033: _1812 -> (BOR I8 _1810 _1811)", null, null, null, 0L, false, false, new int[]{1853, 1854}, null);
        CodeGenerator_x86simd.rulev[2116] = new Rule(2116, false, true, 1933, "2116: _1890 -> (BOR I8 _1887 _1889)", null, null, null, 0L, false, false, new int[]{1930, 1932}, null);
        CodeGenerator_x86simd.rulev[2122] = new Rule(2122, false, true, 1939, "2122: _1896 -> (BOR I8 _1893 _1895)", null, null, null, 0L, false, false, new int[]{1936, 1938}, null);
        CodeGenerator_x86simd.rulev[2128] = new Rule(2128, false, true, 1945, "2128: _1902 -> (BOR I8 _1899 _1901)", null, null, null, 0L, false, false, new int[]{1942, 1944}, null);
        CodeGenerator_x86simd.rulev[2134] = new Rule(2134, false, true, 1951, "2134: _1908 -> (BOR I8 _1905 _1907)", null, null, null, 0L, false, false, new int[]{1948, 1950}, null);
        CodeGenerator_x86simd.rulev[2140] = new Rule(2140, false, true, 1957, "2140: _1914 -> (BOR I8 _1911 _1913)", null, null, null, 0L, false, false, new int[]{1954, 1956}, null);
        CodeGenerator_x86simd.rulev[2146] = new Rule(2146, false, true, 1963, "2146: _1920 -> (BOR I8 _1917 _1919)", null, null, null, 0L, false, false, new int[]{1960, 1962}, null);
        CodeGenerator_x86simd.rulev[2152] = new Rule(2152, false, true, 1969, "2152: _1926 -> (BOR I8 _1923 _1925)", null, null, null, 0L, false, false, new int[]{1966, 1968}, null);
        CodeGenerator_x86simd.rulev[2158] = new Rule(2158, false, true, 1975, "2158: _1932 -> (BOR I8 _1929 _1931)", null, null, null, 0L, false, false, new int[]{1972, 1974}, null);
        CodeGenerator_x86simd.rulev[2164] = new Rule(2164, false, true, 1981, "2164: _1938 -> (BOR I8 _1935 _1937)", null, null, null, 0L, false, false, new int[]{1978, 1980}, null);
        CodeGenerator_x86simd.rulev[2170] = new Rule(2170, false, true, 1987, "2170: _1944 -> (BOR I8 _1941 _1943)", null, null, null, 0L, false, false, new int[]{1984, 1986}, null);
        CodeGenerator_x86simd.rulev[2176] = new Rule(2176, false, true, 1993, "2176: _1950 -> (BOR I8 _1947 _1949)", null, null, null, 0L, false, false, new int[]{1990, 1992}, null);
        CodeGenerator_x86simd.rulev[2182] = new Rule(2182, false, true, 1999, "2182: _1956 -> (BOR I8 _1953 _1955)", null, null, null, 0L, false, false, new int[]{1996, 1998}, null);
        CodeGenerator_x86simd.rulev[2188] = new Rule(2188, false, true, 2005, "2188: _1962 -> (BOR I8 _1959 _1961)", null, null, null, 0L, false, false, new int[]{2002, 2004}, null);
        CodeGenerator_x86simd.rulev[2194] = new Rule(2194, false, true, 2011, "2194: _1968 -> (BOR I8 _1965 _1967)", null, null, null, 0L, false, false, new int[]{2008, 2010}, null);
        CodeGenerator_x86simd.rulev[2200] = new Rule(2200, false, true, 2017, "2200: _1974 -> (BOR I8 _1971 _1973)", null, null, null, 0L, false, false, new int[]{2014, 2016}, null);
        CodeGenerator_x86simd.rulev[2206] = new Rule(2206, false, true, 2023, "2206: _1980 -> (BOR I8 _1977 _1979)", null, null, null, 0L, false, false, new int[]{2020, 2022}, null);
        CodeGenerator_x86simd.rulev[2211] = new Rule(2211, false, true, 2027, "2211: _1984 -> (BOR I8 _1982 _1983)", null, null, null, 0L, false, false, new int[]{2025, 2026}, null);
        CodeGenerator_x86simd.rulev[2215] = new Rule(2215, false, true, 2031, "2215: _1988 -> (BOR I8 _1986 _1987)", null, null, null, 0L, false, false, new int[]{2029, 2030}, null);
        CodeGenerator_x86simd.rulev[2219] = new Rule(2219, false, true, 2035, "2219: _1992 -> (BOR I8 _1990 _1991)", null, null, null, 0L, false, false, new int[]{2033, 2034}, null);
        CodeGenerator_x86simd.rulev[2223] = new Rule(2223, false, true, 2039, "2223: _1996 -> (BOR I8 _1994 _1995)", null, null, null, 0L, false, false, new int[]{2037, 2038}, null);
        CodeGenerator_x86simd.rulev[2227] = new Rule(2227, false, true, 2043, "2227: _2000 -> (BOR I8 _1998 _1999)", null, null, null, 0L, false, false, new int[]{2041, 2042}, null);
        CodeGenerator_x86simd.rulev[2231] = new Rule(2231, false, true, 2047, "2231: _2004 -> (BOR I8 _2002 _2003)", null, null, null, 0L, false, false, new int[]{2045, 2046}, null);
        CodeGenerator_x86simd.rulev[2235] = new Rule(2235, false, true, 2051, "2235: _2008 -> (BOR I8 _2006 _2007)", null, null, null, 0L, false, false, new int[]{2049, 2050}, null);
        CodeGenerator_x86simd.rulev[2239] = new Rule(2239, false, true, 2055, "2239: _2012 -> (BOR I8 _2010 _2011)", null, null, null, 0L, false, false, new int[]{2053, 2054}, null);
        CodeGenerator_x86simd.rulev[2243] = new Rule(2243, false, true, 2059, "2243: _2016 -> (BOR I8 _2014 _2015)", null, null, null, 0L, false, false, new int[]{2057, 2058}, null);
        CodeGenerator_x86simd.rulev[2247] = new Rule(2247, false, true, 2063, "2247: _2020 -> (BOR I8 _2018 _2019)", null, null, null, 0L, false, false, new int[]{2061, 2062}, null);
        CodeGenerator_x86simd.rulev[2251] = new Rule(2251, false, true, 2067, "2251: _2024 -> (BOR I8 _2022 _2023)", null, null, null, 0L, false, false, new int[]{2065, 2066}, null);
    }

    private static void rrinit1600() {
        CodeGenerator_x86simd.rulev[2255] = new Rule(2255, false, true, 2071, "2255: _2028 -> (BOR I8 _2026 _2027)", null, null, null, 0L, false, false, new int[]{2069, 2070}, null);
        CodeGenerator_x86simd.rulev[2259] = new Rule(2259, false, true, 2075, "2259: _2032 -> (BOR I8 _2030 _2031)", null, null, null, 0L, false, false, new int[]{2073, 2074}, null);
        CodeGenerator_x86simd.rulev[2263] = new Rule(2263, false, true, 2079, "2263: _2036 -> (BOR I8 _2034 _2035)", null, null, null, 0L, false, false, new int[]{2077, 2078}, null);
        CodeGenerator_x86simd.rulev[2267] = new Rule(2267, false, true, 2083, "2267: _2040 -> (BOR I8 _2038 _2039)", null, null, null, 0L, false, false, new int[]{2081, 2082}, null);
        CodeGenerator_x86simd.rulev[2271] = new Rule(2271, false, true, 2087, "2271: _2044 -> (BOR I8 _2042 _2043)", null, null, null, 0L, false, false, new int[]{2085, 2086}, null);
        CodeGenerator_x86simd.rulev[2426] = new Rule(2426, false, true, 2237, "2426: _2194 -> (BOR I8 _2191 _2193)", null, null, null, 0L, false, false, new int[]{2234, 2236}, null);
        CodeGenerator_x86simd.rulev[2432] = new Rule(2432, false, true, 2243, "2432: _2200 -> (BOR I8 _2197 _2199)", null, null, null, 0L, false, false, new int[]{2240, 2242}, null);
        CodeGenerator_x86simd.rulev[2438] = new Rule(2438, false, true, 2249, "2438: _2206 -> (BOR I8 _2203 _2205)", null, null, null, 0L, false, false, new int[]{2246, 2248}, null);
        CodeGenerator_x86simd.rulev[2444] = new Rule(2444, false, true, 2255, "2444: _2212 -> (BOR I8 _2209 _2211)", null, null, null, 0L, false, false, new int[]{2252, 2254}, null);
        CodeGenerator_x86simd.rulev[2450] = new Rule(2450, false, true, 2261, "2450: _2218 -> (BOR I8 _2215 _2217)", null, null, null, 0L, false, false, new int[]{2258, 2260}, null);
        CodeGenerator_x86simd.rulev[2456] = new Rule(2456, false, true, 2267, "2456: _2224 -> (BOR I8 _2221 _2223)", null, null, null, 0L, false, false, new int[]{2264, 2266}, null);
        CodeGenerator_x86simd.rulev[2462] = new Rule(2462, false, true, 2273, "2462: _2230 -> (BOR I8 _2227 _2229)", null, null, null, 0L, false, false, new int[]{2270, 2272}, null);
        CodeGenerator_x86simd.rulev[2468] = new Rule(2468, false, true, 2279, "2468: _2236 -> (BOR I8 _2233 _2235)", null, null, null, 0L, false, false, new int[]{2276, 2278}, null);
        CodeGenerator_x86simd.rulev[2505] = new Rule(2505, false, true, 2313, "2505: _2270 -> (BOR I8 _2267 _2269)", null, null, null, 0L, false, false, new int[]{2310, 2312}, null);
        CodeGenerator_x86simd.rulev[2511] = new Rule(2511, false, true, 2319, "2511: _2276 -> (BOR I8 _2273 _2275)", null, null, null, 0L, false, false, new int[]{2316, 2318}, null);
        CodeGenerator_x86simd.rulev[2517] = new Rule(2517, false, true, 2325, "2517: _2282 -> (BOR I8 _2279 _2281)", null, null, null, 0L, false, false, new int[]{2322, 2324}, null);
        CodeGenerator_x86simd.rulev[2523] = new Rule(2523, false, true, 2331, "2523: _2288 -> (BOR I8 _2285 _2287)", null, null, null, 0L, false, false, new int[]{2328, 2330}, null);
        CodeGenerator_x86simd.rulev[2529] = new Rule(2529, false, true, 2337, "2529: _2294 -> (BOR I8 _2291 _2293)", null, null, null, 0L, false, false, new int[]{2334, 2336}, null);
        CodeGenerator_x86simd.rulev[2535] = new Rule(2535, false, true, 2343, "2535: _2300 -> (BOR I8 _2297 _2299)", null, null, null, 0L, false, false, new int[]{2340, 2342}, null);
        CodeGenerator_x86simd.rulev[2541] = new Rule(2541, false, true, 2349, "2541: _2306 -> (BOR I8 _2303 _2305)", null, null, null, 0L, false, false, new int[]{2346, 2348}, null);
        CodeGenerator_x86simd.rulev[2547] = new Rule(2547, false, true, 2355, "2547: _2312 -> (BOR I8 _2309 _2311)", null, null, null, 0L, false, false, new int[]{2352, 2354}, null);
        CodeGenerator_x86simd.rulev[2553] = new Rule(2553, false, true, 2361, "2553: _2318 -> (BOR I8 _2315 _2317)", null, null, null, 0L, false, false, new int[]{2358, 2360}, null);
        CodeGenerator_x86simd.rulev[2559] = new Rule(2559, false, true, 2367, "2559: _2324 -> (BOR I8 _2321 _2323)", null, null, null, 0L, false, false, new int[]{2364, 2366}, null);
        CodeGenerator_x86simd.rulev[2565] = new Rule(2565, false, true, 2373, "2565: _2330 -> (BOR I8 _2327 _2329)", null, null, null, 0L, false, false, new int[]{2370, 2372}, null);
        CodeGenerator_x86simd.rulev[2571] = new Rule(2571, false, true, 2379, "2571: _2336 -> (BOR I8 _2333 _2335)", null, null, null, 0L, false, false, new int[]{2376, 2378}, null);
        CodeGenerator_x86simd.rulev[2577] = new Rule(2577, false, true, 2385, "2577: _2342 -> (BOR I8 _2339 _2341)", null, null, null, 0L, false, false, new int[]{2382, 2384}, null);
        CodeGenerator_x86simd.rulev[2583] = new Rule(2583, false, true, 2391, "2583: _2348 -> (BOR I8 _2345 _2347)", null, null, null, 0L, false, false, new int[]{2388, 2390}, null);
        CodeGenerator_x86simd.rulev[2589] = new Rule(2589, false, true, 2397, "2589: _2354 -> (BOR I8 _2351 _2353)", null, null, null, 0L, false, false, new int[]{2394, 2396}, null);
        CodeGenerator_x86simd.rulev[2595] = new Rule(2595, false, true, 2403, "2595: _2360 -> (BOR I8 _2357 _2359)", null, null, null, 0L, false, false, new int[]{2400, 2402}, null);
        CodeGenerator_x86simd.rulev[2660] = new Rule(2660, false, true, 2465, "2660: _2422 -> (BOR I8 _2419 _2421)", null, null, null, 0L, false, false, new int[]{2462, 2464}, null);
        CodeGenerator_x86simd.rulev[2666] = new Rule(2666, false, true, 2471, "2666: _2428 -> (BOR I8 _2425 _2427)", null, null, null, 0L, false, false, new int[]{2468, 2470}, null);
        CodeGenerator_x86simd.rulev[2672] = new Rule(2672, false, true, 2477, "2672: _2434 -> (BOR I8 _2431 _2433)", null, null, null, 0L, false, false, new int[]{2474, 2476}, null);
        CodeGenerator_x86simd.rulev[2678] = new Rule(2678, false, true, 2483, "2678: _2440 -> (BOR I8 _2437 _2439)", null, null, null, 0L, false, false, new int[]{2480, 2482}, null);
        CodeGenerator_x86simd.rulev[2684] = new Rule(2684, false, true, 2489, "2684: _2446 -> (BOR I8 _2443 _2445)", null, null, null, 0L, false, false, new int[]{2486, 2488}, null);
        CodeGenerator_x86simd.rulev[2690] = new Rule(2690, false, true, 2495, "2690: _2452 -> (BOR I8 _2449 _2451)", null, null, null, 0L, false, false, new int[]{2492, 2494}, null);
        CodeGenerator_x86simd.rulev[2696] = new Rule(2696, false, true, 2501, "2696: _2458 -> (BOR I8 _2455 _2457)", null, null, null, 0L, false, false, new int[]{2498, 2500}, null);
        CodeGenerator_x86simd.rulev[2702] = new Rule(2702, false, true, 2507, "2702: _2464 -> (BOR I8 _2461 _2463)", null, null, null, 0L, false, false, new int[]{2504, 2506}, null);
        CodeGenerator_x86simd.rulev[2739] = new Rule(2739, false, true, 2541, "2739: _2498 -> (BOR I8 _2495 _2497)", null, null, null, 0L, false, false, new int[]{2538, 2540}, null);
        CodeGenerator_x86simd.rulev[2745] = new Rule(2745, false, true, 2547, "2745: _2504 -> (BOR I8 _2501 _2503)", null, null, null, 0L, false, false, new int[]{2544, 2546}, null);
        CodeGenerator_x86simd.rulev[2751] = new Rule(2751, false, true, 2553, "2751: _2510 -> (BOR I8 _2507 _2509)", null, null, null, 0L, false, false, new int[]{2550, 2552}, null);
        CodeGenerator_x86simd.rulev[2757] = new Rule(2757, false, true, 2559, "2757: _2516 -> (BOR I8 _2513 _2515)", null, null, null, 0L, false, false, new int[]{2556, 2558}, null);
        CodeGenerator_x86simd.rulev[2763] = new Rule(2763, false, true, 2565, "2763: _2522 -> (BOR I8 _2519 _2521)", null, null, null, 0L, false, false, new int[]{2562, 2564}, null);
        CodeGenerator_x86simd.rulev[2769] = new Rule(2769, false, true, 2571, "2769: _2528 -> (BOR I8 _2525 _2527)", null, null, null, 0L, false, false, new int[]{2568, 2570}, null);
        CodeGenerator_x86simd.rulev[2775] = new Rule(2775, false, true, 2577, "2775: _2534 -> (BOR I8 _2531 _2533)", null, null, null, 0L, false, false, new int[]{2574, 2576}, null);
        CodeGenerator_x86simd.rulev[2781] = new Rule(2781, false, true, 2583, "2781: _2540 -> (BOR I8 _2537 _2539)", null, null, null, 0L, false, false, new int[]{2580, 2582}, null);
        CodeGenerator_x86simd.rulev[2787] = new Rule(2787, false, true, 2589, "2787: _2546 -> (BOR I8 _2543 _2545)", null, null, null, 0L, false, false, new int[]{2586, 2588}, null);
        CodeGenerator_x86simd.rulev[2793] = new Rule(2793, false, true, 2595, "2793: _2552 -> (BOR I8 _2549 _2551)", null, null, null, 0L, false, false, new int[]{2592, 2594}, null);
        CodeGenerator_x86simd.rulev[2799] = new Rule(2799, false, true, 2601, "2799: _2558 -> (BOR I8 _2555 _2557)", null, null, null, 0L, false, false, new int[]{2598, 2600}, null);
        CodeGenerator_x86simd.rulev[2805] = new Rule(2805, false, true, 2607, "2805: _2564 -> (BOR I8 _2561 _2563)", null, null, null, 0L, false, false, new int[]{2604, 2606}, null);
        CodeGenerator_x86simd.rulev[2811] = new Rule(2811, false, true, 2613, "2811: _2570 -> (BOR I8 _2567 _2569)", null, null, null, 0L, false, false, new int[]{2610, 2612}, null);
        CodeGenerator_x86simd.rulev[2817] = new Rule(2817, false, true, 2619, "2817: _2576 -> (BOR I8 _2573 _2575)", null, null, null, 0L, false, false, new int[]{2616, 2618}, null);
        CodeGenerator_x86simd.rulev[2823] = new Rule(2823, false, true, 2625, "2823: _2582 -> (BOR I8 _2579 _2581)", null, null, null, 0L, false, false, new int[]{2622, 2624}, null);
        CodeGenerator_x86simd.rulev[2829] = new Rule(2829, false, true, 2631, "2829: _2588 -> (BOR I8 _2585 _2587)", null, null, null, 0L, false, false, new int[]{2628, 2630}, null);
        CodeGenerator_x86simd.rulev[4011] = new Rule(4011, false, false, 7, "4011: regb -> (BOR I8 regb mrcb)", ImList.list(ImList.list("orb", "$2", "$0")), null, null, 2L, false, false, new int[]{7, 44}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[4028] = new Rule(4028, false, false, 7, "4028: regb -> (BOR I8 mrcb regb)", ImList.list(ImList.list("orb", "$1", "$0")), null, null, 4L, false, false, new int[]{44, 7}, new String[]{"*reg-I8*", null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[893] = new Rule(893, false, true, 739, "893: _696 -> (BOR I16 _117 _117)", null, null, null, 0L, false, false, new int[]{160, 160}, null);
        CodeGenerator_x86simd.rulev[899] = new Rule(899, false, true, 745, "899: _702 -> (BOR I16 _119 _119)", null, null, null, 0L, false, false, new int[]{162, 162}, null);
        CodeGenerator_x86simd.rulev[905] = new Rule(905, false, true, 751, "905: _708 -> (BOR I16 _121 _121)", null, null, null, 0L, false, false, new int[]{164, 164}, null);
        CodeGenerator_x86simd.rulev[911] = new Rule(911, false, true, 757, "911: _714 -> (BOR I16 _123 _123)", null, null, null, 0L, false, false, new int[]{166, 166}, null);
        CodeGenerator_x86simd.rulev[951] = new Rule(951, false, true, 795, "951: _752 -> (BOR I16 _49 _49)", null, null, null, 0L, false, false, new int[]{92, 92}, null);
        CodeGenerator_x86simd.rulev[957] = new Rule(957, false, true, 801, "957: _758 -> (BOR I16 _51 _51)", null, null, null, 0L, false, false, new int[]{94, 94}, null);
        CodeGenerator_x86simd.rulev[963] = new Rule(963, false, true, 807, "963: _764 -> (BOR I16 _53 _53)", null, null, null, 0L, false, false, new int[]{96, 96}, null);
        CodeGenerator_x86simd.rulev[969] = new Rule(969, false, true, 813, "969: _770 -> (BOR I16 _55 _55)", null, null, null, 0L, false, false, new int[]{98, 98}, null);
        CodeGenerator_x86simd.rulev[975] = new Rule(975, false, true, 819, "975: _776 -> (BOR I16 _57 _57)", null, null, null, 0L, false, false, new int[]{100, 100}, null);
        CodeGenerator_x86simd.rulev[981] = new Rule(981, false, true, 825, "981: _782 -> (BOR I16 _59 _59)", null, null, null, 0L, false, false, new int[]{102, 102}, null);
        CodeGenerator_x86simd.rulev[987] = new Rule(987, false, true, 831, "987: _788 -> (BOR I16 _61 _61)", null, null, null, 0L, false, false, new int[]{104, 104}, null);
        CodeGenerator_x86simd.rulev[993] = new Rule(993, false, true, 837, "993: _794 -> (BOR I16 _63 _63)", null, null, null, 0L, false, false, new int[]{106, 106}, null);
        CodeGenerator_x86simd.rulev[1294] = new Rule(1294, false, true, 1133, "1294: _1090 -> (BOR I16 _1087 _1089)", null, null, null, 0L, false, false, new int[]{1130, 1132}, null);
        CodeGenerator_x86simd.rulev[1300] = new Rule(1300, false, true, 1139, "1300: _1096 -> (BOR I16 _1093 _1095)", null, null, null, 0L, false, false, new int[]{1136, 1138}, null);
        CodeGenerator_x86simd.rulev[1306] = new Rule(1306, false, true, 1145, "1306: _1102 -> (BOR I16 _1099 _1101)", null, null, null, 0L, false, false, new int[]{1142, 1144}, null);
        CodeGenerator_x86simd.rulev[1312] = new Rule(1312, false, true, 1151, "1312: _1108 -> (BOR I16 _1105 _1107)", null, null, null, 0L, false, false, new int[]{1148, 1150}, null);
        CodeGenerator_x86simd.rulev[1319] = new Rule(1319, false, true, 1157, "1319: _1114 -> (BOR I16 _1111 _1113)", null, null, null, 0L, false, false, new int[]{1154, 1156}, null);
        CodeGenerator_x86simd.rulev[1325] = new Rule(1325, false, true, 1163, "1325: _1120 -> (BOR I16 _1117 _1119)", null, null, null, 0L, false, false, new int[]{1160, 1162}, null);
        CodeGenerator_x86simd.rulev[1331] = new Rule(1331, false, true, 1169, "1331: _1126 -> (BOR I16 _1123 _1125)", null, null, null, 0L, false, false, new int[]{1166, 1168}, null);
        CodeGenerator_x86simd.rulev[1337] = new Rule(1337, false, true, 1175, "1337: _1132 -> (BOR I16 _1129 _1131)", null, null, null, 0L, false, false, new int[]{1172, 1174}, null);
        CodeGenerator_x86simd.rulev[1344] = new Rule(1344, false, true, 1181, "1344: _1138 -> (BOR I16 _1135 _1137)", null, null, null, 0L, false, false, new int[]{1178, 1180}, null);
        CodeGenerator_x86simd.rulev[1350] = new Rule(1350, false, true, 1187, "1350: _1144 -> (BOR I16 _1141 _1143)", null, null, null, 0L, false, false, new int[]{1184, 1186}, null);
        CodeGenerator_x86simd.rulev[1356] = new Rule(1356, false, true, 1193, "1356: _1150 -> (BOR I16 _1147 _1149)", null, null, null, 0L, false, false, new int[]{1190, 1192}, null);
        CodeGenerator_x86simd.rulev[1362] = new Rule(1362, false, true, 1199, "1362: _1156 -> (BOR I16 _1153 _1155)", null, null, null, 0L, false, false, new int[]{1196, 1198}, null);
        CodeGenerator_x86simd.rulev[1368] = new Rule(1368, false, true, 1205, "1368: _1162 -> (BOR I16 _1159 _1161)", null, null, null, 0L, false, false, new int[]{1202, 1204}, null);
        CodeGenerator_x86simd.rulev[1374] = new Rule(1374, false, true, 1211, "1374: _1168 -> (BOR I16 _1165 _1167)", null, null, null, 0L, false, false, new int[]{1208, 1210}, null);
        CodeGenerator_x86simd.rulev[1380] = new Rule(1380, false, true, 1217, "1380: _1174 -> (BOR I16 _1171 _1173)", null, null, null, 0L, false, false, new int[]{1214, 1216}, null);
        CodeGenerator_x86simd.rulev[1386] = new Rule(1386, false, true, 1223, "1386: _1180 -> (BOR I16 _1177 _1179)", null, null, null, 0L, false, false, new int[]{1220, 1222}, null);
        CodeGenerator_x86simd.rulev[1393] = new Rule(1393, false, true, 1229, "1393: _1186 -> (BOR I16 _1183 _1185)", null, null, null, 0L, false, false, new int[]{1226, 1228}, null);
        CodeGenerator_x86simd.rulev[1399] = new Rule(1399, false, true, 1235, "1399: _1192 -> (BOR I16 _1189 _1191)", null, null, null, 0L, false, false, new int[]{1232, 1234}, null);
        CodeGenerator_x86simd.rulev[1405] = new Rule(1405, false, true, 1241, "1405: _1198 -> (BOR I16 _1195 _1197)", null, null, null, 0L, false, false, new int[]{1238, 1240}, null);
        CodeGenerator_x86simd.rulev[1411] = new Rule(1411, false, true, 1247, "1411: _1204 -> (BOR I16 _1201 _1203)", null, null, null, 0L, false, false, new int[]{1244, 1246}, null);
        CodeGenerator_x86simd.rulev[1417] = new Rule(1417, false, true, 1253, "1417: _1210 -> (BOR I16 _1207 _1209)", null, null, null, 0L, false, false, new int[]{1250, 1252}, null);
        CodeGenerator_x86simd.rulev[1423] = new Rule(1423, false, true, 1259, "1423: _1216 -> (BOR I16 _1213 _1215)", null, null, null, 0L, false, false, new int[]{1256, 1258}, null);
        CodeGenerator_x86simd.rulev[1429] = new Rule(1429, false, true, 1265, "1429: _1222 -> (BOR I16 _1219 _1221)", null, null, null, 0L, false, false, new int[]{1262, 1264}, null);
        CodeGenerator_x86simd.rulev[1435] = new Rule(1435, false, true, 1271, "1435: _1228 -> (BOR I16 _1225 _1227)", null, null, null, 0L, false, false, new int[]{1268, 1270}, null);
        CodeGenerator_x86simd.rulev[1540] = new Rule(1540, false, true, 1373, "1540: _1330 -> (BOR I16 _1327 _1329)", null, null, null, 0L, false, false, new int[]{1370, 1372}, null);
        CodeGenerator_x86simd.rulev[1546] = new Rule(1546, false, true, 1379, "1546: _1336 -> (BOR I16 _1333 _1335)", null, null, null, 0L, false, false, new int[]{1376, 1378}, null);
        CodeGenerator_x86simd.rulev[1552] = new Rule(1552, false, true, 1385, "1552: _1342 -> (BOR I16 _1339 _1341)", null, null, null, 0L, false, false, new int[]{1382, 1384}, null);
        CodeGenerator_x86simd.rulev[1558] = new Rule(1558, false, true, 1391, "1558: _1348 -> (BOR I16 _1345 _1347)", null, null, null, 0L, false, false, new int[]{1388, 1390}, null);
        CodeGenerator_x86simd.rulev[1565] = new Rule(1565, false, true, 1397, "1565: _1354 -> (BOR I16 _1351 _1353)", null, null, null, 0L, false, false, new int[]{1394, 1396}, null);
        CodeGenerator_x86simd.rulev[1571] = new Rule(1571, false, true, 1403, "1571: _1360 -> (BOR I16 _1357 _1359)", null, null, null, 0L, false, false, new int[]{1400, 1402}, null);
        CodeGenerator_x86simd.rulev[1577] = new Rule(1577, false, true, 1409, "1577: _1366 -> (BOR I16 _1363 _1365)", null, null, null, 0L, false, false, new int[]{1406, 1408}, null);
        CodeGenerator_x86simd.rulev[1583] = new Rule(1583, false, true, 1415, "1583: _1372 -> (BOR I16 _1369 _1371)", null, null, null, 0L, false, false, new int[]{1412, 1414}, null);
        CodeGenerator_x86simd.rulev[1810] = new Rule(1810, false, true, 1637, "1810: _1594 -> (BOR I16 _1591 _1593)", null, null, null, 0L, false, false, new int[]{1634, 1636}, null);
    }

    private static void rrinit1700() {
        CodeGenerator_x86simd.rulev[1816] = new Rule(1816, false, true, 1643, "1816: _1600 -> (BOR I16 _1597 _1599)", null, null, null, 0L, false, false, new int[]{1640, 1642}, null);
        CodeGenerator_x86simd.rulev[1822] = new Rule(1822, false, true, 1649, "1822: _1606 -> (BOR I16 _1603 _1605)", null, null, null, 0L, false, false, new int[]{1646, 1648}, null);
        CodeGenerator_x86simd.rulev[1828] = new Rule(1828, false, true, 1655, "1828: _1612 -> (BOR I16 _1609 _1611)", null, null, null, 0L, false, false, new int[]{1652, 1654}, null);
        CodeGenerator_x86simd.rulev[1834] = new Rule(1834, false, true, 1661, "1834: _1618 -> (BOR I16 _1615 _1617)", null, null, null, 0L, false, false, new int[]{1658, 1660}, null);
        CodeGenerator_x86simd.rulev[1840] = new Rule(1840, false, true, 1667, "1840: _1624 -> (BOR I16 _1621 _1623)", null, null, null, 0L, false, false, new int[]{1664, 1666}, null);
        CodeGenerator_x86simd.rulev[1846] = new Rule(1846, false, true, 1673, "1846: _1630 -> (BOR I16 _1627 _1629)", null, null, null, 0L, false, false, new int[]{1670, 1672}, null);
        CodeGenerator_x86simd.rulev[1852] = new Rule(1852, false, true, 1679, "1852: _1636 -> (BOR I16 _1633 _1635)", null, null, null, 0L, false, false, new int[]{1676, 1678}, null);
        CodeGenerator_x86simd.rulev[1859] = new Rule(1859, false, true, 1685, "1859: _1642 -> (BOR I16 _1639 _1641)", null, null, null, 0L, false, false, new int[]{1682, 1684}, null);
        CodeGenerator_x86simd.rulev[1865] = new Rule(1865, false, true, 1691, "1865: _1648 -> (BOR I16 _1645 _1647)", null, null, null, 0L, false, false, new int[]{1688, 1690}, null);
        CodeGenerator_x86simd.rulev[1871] = new Rule(1871, false, true, 1697, "1871: _1654 -> (BOR I16 _1651 _1653)", null, null, null, 0L, false, false, new int[]{1694, 1696}, null);
        CodeGenerator_x86simd.rulev[1877] = new Rule(1877, false, true, 1703, "1877: _1660 -> (BOR I16 _1657 _1659)", null, null, null, 0L, false, false, new int[]{1700, 1702}, null);
        CodeGenerator_x86simd.rulev[1883] = new Rule(1883, false, true, 1709, "1883: _1666 -> (BOR I16 _1663 _1665)", null, null, null, 0L, false, false, new int[]{1706, 1708}, null);
        CodeGenerator_x86simd.rulev[1889] = new Rule(1889, false, true, 1715, "1889: _1672 -> (BOR I16 _1669 _1671)", null, null, null, 0L, false, false, new int[]{1712, 1714}, null);
        CodeGenerator_x86simd.rulev[1895] = new Rule(1895, false, true, 1721, "1895: _1678 -> (BOR I16 _1675 _1677)", null, null, null, 0L, false, false, new int[]{1718, 1720}, null);
        CodeGenerator_x86simd.rulev[1901] = new Rule(1901, false, true, 1727, "1901: _1684 -> (BOR I16 _1681 _1683)", null, null, null, 0L, false, false, new int[]{1724, 1726}, null);
        CodeGenerator_x86simd.rulev[2040] = new Rule(2040, false, true, 1861, "2040: _1818 -> (BOR I16 _1815 _1817)", null, null, null, 0L, false, false, new int[]{1858, 1860}, null);
        CodeGenerator_x86simd.rulev[2046] = new Rule(2046, false, true, 1867, "2046: _1824 -> (BOR I16 _1821 _1823)", null, null, null, 0L, false, false, new int[]{1864, 1866}, null);
        CodeGenerator_x86simd.rulev[2052] = new Rule(2052, false, true, 1873, "2052: _1830 -> (BOR I16 _1827 _1829)", null, null, null, 0L, false, false, new int[]{1870, 1872}, null);
        CodeGenerator_x86simd.rulev[2058] = new Rule(2058, false, true, 1879, "2058: _1836 -> (BOR I16 _1833 _1835)", null, null, null, 0L, false, false, new int[]{1876, 1878}, null);
        CodeGenerator_x86simd.rulev[2065] = new Rule(2065, false, true, 1885, "2065: _1842 -> (BOR I16 _1839 _1841)", null, null, null, 0L, false, false, new int[]{1882, 1884}, null);
        CodeGenerator_x86simd.rulev[2071] = new Rule(2071, false, true, 1891, "2071: _1848 -> (BOR I16 _1845 _1847)", null, null, null, 0L, false, false, new int[]{1888, 1890}, null);
        CodeGenerator_x86simd.rulev[2077] = new Rule(2077, false, true, 1897, "2077: _1854 -> (BOR I16 _1851 _1853)", null, null, null, 0L, false, false, new int[]{1894, 1896}, null);
        CodeGenerator_x86simd.rulev[2083] = new Rule(2083, false, true, 1903, "2083: _1860 -> (BOR I16 _1857 _1859)", null, null, null, 0L, false, false, new int[]{1900, 1902}, null);
        CodeGenerator_x86simd.rulev[2278] = new Rule(2278, false, true, 2093, "2278: _2050 -> (BOR I16 _2047 _2049)", null, null, null, 0L, false, false, new int[]{2090, 2092}, null);
        CodeGenerator_x86simd.rulev[2284] = new Rule(2284, false, true, 2099, "2284: _2056 -> (BOR I16 _2053 _2055)", null, null, null, 0L, false, false, new int[]{2096, 2098}, null);
        CodeGenerator_x86simd.rulev[2290] = new Rule(2290, false, true, 2105, "2290: _2062 -> (BOR I16 _2059 _2061)", null, null, null, 0L, false, false, new int[]{2102, 2104}, null);
        CodeGenerator_x86simd.rulev[2296] = new Rule(2296, false, true, 2111, "2296: _2068 -> (BOR I16 _2065 _2067)", null, null, null, 0L, false, false, new int[]{2108, 2110}, null);
        CodeGenerator_x86simd.rulev[2302] = new Rule(2302, false, true, 2117, "2302: _2074 -> (BOR I16 _2071 _2073)", null, null, null, 0L, false, false, new int[]{2114, 2116}, null);
        CodeGenerator_x86simd.rulev[2308] = new Rule(2308, false, true, 2123, "2308: _2080 -> (BOR I16 _2077 _2079)", null, null, null, 0L, false, false, new int[]{2120, 2122}, null);
        CodeGenerator_x86simd.rulev[2314] = new Rule(2314, false, true, 2129, "2314: _2086 -> (BOR I16 _2083 _2085)", null, null, null, 0L, false, false, new int[]{2126, 2128}, null);
        CodeGenerator_x86simd.rulev[2320] = new Rule(2320, false, true, 2135, "2320: _2092 -> (BOR I16 _2089 _2091)", null, null, null, 0L, false, false, new int[]{2132, 2134}, null);
        CodeGenerator_x86simd.rulev[2327] = new Rule(2327, false, true, 2141, "2327: _2098 -> (BOR I16 _2095 _2097)", null, null, null, 0L, false, false, new int[]{2138, 2140}, null);
        CodeGenerator_x86simd.rulev[2333] = new Rule(2333, false, true, 2147, "2333: _2104 -> (BOR I16 _2101 _2103)", null, null, null, 0L, false, false, new int[]{2144, 2146}, null);
        CodeGenerator_x86simd.rulev[2339] = new Rule(2339, false, true, 2153, "2339: _2110 -> (BOR I16 _2107 _2109)", null, null, null, 0L, false, false, new int[]{2150, 2152}, null);
        CodeGenerator_x86simd.rulev[2345] = new Rule(2345, false, true, 2159, "2345: _2116 -> (BOR I16 _2113 _2115)", null, null, null, 0L, false, false, new int[]{2156, 2158}, null);
        CodeGenerator_x86simd.rulev[2351] = new Rule(2351, false, true, 2165, "2351: _2122 -> (BOR I16 _2119 _2121)", null, null, null, 0L, false, false, new int[]{2162, 2164}, null);
        CodeGenerator_x86simd.rulev[2357] = new Rule(2357, false, true, 2171, "2357: _2128 -> (BOR I16 _2125 _2127)", null, null, null, 0L, false, false, new int[]{2168, 2170}, null);
        CodeGenerator_x86simd.rulev[2363] = new Rule(2363, false, true, 2177, "2363: _2134 -> (BOR I16 _2131 _2133)", null, null, null, 0L, false, false, new int[]{2174, 2176}, null);
        CodeGenerator_x86simd.rulev[2369] = new Rule(2369, false, true, 2183, "2369: _2140 -> (BOR I16 _2137 _2139)", null, null, null, 0L, false, false, new int[]{2180, 2182}, null);
        CodeGenerator_x86simd.rulev[2473] = new Rule(2473, false, true, 2283, "2473: _2240 -> (BOR I16 _2238 _2239)", null, null, null, 0L, false, false, new int[]{2281, 2282}, null);
        CodeGenerator_x86simd.rulev[2477] = new Rule(2477, false, true, 2287, "2477: _2244 -> (BOR I16 _2242 _2243)", null, null, null, 0L, false, false, new int[]{2285, 2286}, null);
        CodeGenerator_x86simd.rulev[2481] = new Rule(2481, false, true, 2291, "2481: _2248 -> (BOR I16 _2246 _2247)", null, null, null, 0L, false, false, new int[]{2289, 2290}, null);
        CodeGenerator_x86simd.rulev[2485] = new Rule(2485, false, true, 2295, "2485: _2252 -> (BOR I16 _2250 _2251)", null, null, null, 0L, false, false, new int[]{2293, 2294}, null);
        CodeGenerator_x86simd.rulev[2600] = new Rule(2600, false, true, 2407, "2600: _2364 -> (BOR I16 _2362 _2363)", null, null, null, 0L, false, false, new int[]{2405, 2406}, null);
        CodeGenerator_x86simd.rulev[2604] = new Rule(2604, false, true, 2411, "2604: _2368 -> (BOR I16 _2366 _2367)", null, null, null, 0L, false, false, new int[]{2409, 2410}, null);
        CodeGenerator_x86simd.rulev[2608] = new Rule(2608, false, true, 2415, "2608: _2372 -> (BOR I16 _2370 _2371)", null, null, null, 0L, false, false, new int[]{2413, 2414}, null);
        CodeGenerator_x86simd.rulev[2612] = new Rule(2612, false, true, 2419, "2612: _2376 -> (BOR I16 _2374 _2375)", null, null, null, 0L, false, false, new int[]{2417, 2418}, null);
        CodeGenerator_x86simd.rulev[2616] = new Rule(2616, false, true, 2423, "2616: _2380 -> (BOR I16 _2378 _2379)", null, null, null, 0L, false, false, new int[]{2421, 2422}, null);
        CodeGenerator_x86simd.rulev[2620] = new Rule(2620, false, true, 2427, "2620: _2384 -> (BOR I16 _2382 _2383)", null, null, null, 0L, false, false, new int[]{2425, 2426}, null);
        CodeGenerator_x86simd.rulev[2624] = new Rule(2624, false, true, 2431, "2624: _2388 -> (BOR I16 _2386 _2387)", null, null, null, 0L, false, false, new int[]{2429, 2430}, null);
        CodeGenerator_x86simd.rulev[2628] = new Rule(2628, false, true, 2435, "2628: _2392 -> (BOR I16 _2390 _2391)", null, null, null, 0L, false, false, new int[]{2433, 2434}, null);
        CodeGenerator_x86simd.rulev[2707] = new Rule(2707, false, true, 2511, "2707: _2468 -> (BOR I16 _2466 _2467)", null, null, null, 0L, false, false, new int[]{2509, 2510}, null);
        CodeGenerator_x86simd.rulev[2711] = new Rule(2711, false, true, 2515, "2711: _2472 -> (BOR I16 _2470 _2471)", null, null, null, 0L, false, false, new int[]{2513, 2514}, null);
        CodeGenerator_x86simd.rulev[2715] = new Rule(2715, false, true, 2519, "2715: _2476 -> (BOR I16 _2474 _2475)", null, null, null, 0L, false, false, new int[]{2517, 2518}, null);
        CodeGenerator_x86simd.rulev[2719] = new Rule(2719, false, true, 2523, "2719: _2480 -> (BOR I16 _2478 _2479)", null, null, null, 0L, false, false, new int[]{2521, 2522}, null);
        CodeGenerator_x86simd.rulev[2834] = new Rule(2834, false, true, 2635, "2834: _2592 -> (BOR I16 _2590 _2591)", null, null, null, 0L, false, false, new int[]{2633, 2634}, null);
        CodeGenerator_x86simd.rulev[2838] = new Rule(2838, false, true, 2639, "2838: _2596 -> (BOR I16 _2594 _2595)", null, null, null, 0L, false, false, new int[]{2637, 2638}, null);
        CodeGenerator_x86simd.rulev[2842] = new Rule(2842, false, true, 2643, "2842: _2600 -> (BOR I16 _2598 _2599)", null, null, null, 0L, false, false, new int[]{2641, 2642}, null);
        CodeGenerator_x86simd.rulev[2846] = new Rule(2846, false, true, 2647, "2846: _2604 -> (BOR I16 _2602 _2603)", null, null, null, 0L, false, false, new int[]{2645, 2646}, null);
        CodeGenerator_x86simd.rulev[2850] = new Rule(2850, false, true, 2651, "2850: _2608 -> (BOR I16 _2606 _2607)", null, null, null, 0L, false, false, new int[]{2649, 2650}, null);
        CodeGenerator_x86simd.rulev[2854] = new Rule(2854, false, true, 2655, "2854: _2612 -> (BOR I16 _2610 _2611)", null, null, null, 0L, false, false, new int[]{2653, 2654}, null);
        CodeGenerator_x86simd.rulev[2858] = new Rule(2858, false, true, 2659, "2858: _2616 -> (BOR I16 _2614 _2615)", null, null, null, 0L, false, false, new int[]{2657, 2658}, null);
        CodeGenerator_x86simd.rulev[2862] = new Rule(2862, false, true, 2663, "2862: _2620 -> (BOR I16 _2618 _2619)", null, null, null, 0L, false, false, new int[]{2661, 2662}, null);
        CodeGenerator_x86simd.rulev[4016] = new Rule(4016, false, false, 6, "4016: regw -> (BOR I16 regw mrcw)", ImList.list(ImList.list("orw", "$2", "$0")), null, null, 2L, false, false, new int[]{6, 42}, new String[]{"*reg-I16*", "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[4024] = new Rule(4024, false, false, 6, "4024: regw -> (BOR I16 mrcw regw)", ImList.list(ImList.list("orw", "$1", "$0")), null, null, 4L, false, false, new int[]{42, 6}, new String[]{"*reg-I16*", null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[1590] = new Rule(1590, false, true, 1421, "1590: _1378 -> (BOR I32 _1375 _1377)", null, null, null, 0L, false, false, new int[]{1418, 1420}, null);
        CodeGenerator_x86simd.rulev[1596] = new Rule(1596, false, true, 1427, "1596: _1384 -> (BOR I32 _1381 _1383)", null, null, null, 0L, false, false, new int[]{1424, 1426}, null);
        CodeGenerator_x86simd.rulev[1603] = new Rule(1603, false, true, 1433, "1603: _1390 -> (BOR I32 _1387 _1389)", null, null, null, 0L, false, false, new int[]{1430, 1432}, null);
        CodeGenerator_x86simd.rulev[1609] = new Rule(1609, false, true, 1439, "1609: _1396 -> (BOR I32 _1393 _1395)", null, null, null, 0L, false, false, new int[]{1436, 1438}, null);
        CodeGenerator_x86simd.rulev[1908] = new Rule(1908, false, true, 1733, "1908: _1690 -> (BOR I32 _1687 _1689)", null, null, null, 0L, false, false, new int[]{1730, 1732}, null);
        CodeGenerator_x86simd.rulev[1914] = new Rule(1914, false, true, 1739, "1914: _1696 -> (BOR I32 _1693 _1695)", null, null, null, 0L, false, false, new int[]{1736, 1738}, null);
        CodeGenerator_x86simd.rulev[1920] = new Rule(1920, false, true, 1745, "1920: _1702 -> (BOR I32 _1699 _1701)", null, null, null, 0L, false, false, new int[]{1742, 1744}, null);
        CodeGenerator_x86simd.rulev[1926] = new Rule(1926, false, true, 1751, "1926: _1708 -> (BOR I32 _1705 _1707)", null, null, null, 0L, false, false, new int[]{1748, 1750}, null);
        CodeGenerator_x86simd.rulev[1933] = new Rule(1933, false, true, 1757, "1933: _1714 -> (BOR I32 _1711 _1713)", null, null, null, 0L, false, false, new int[]{1754, 1756}, null);
        CodeGenerator_x86simd.rulev[1939] = new Rule(1939, false, true, 1763, "1939: _1720 -> (BOR I32 _1717 _1719)", null, null, null, 0L, false, false, new int[]{1760, 1762}, null);
        CodeGenerator_x86simd.rulev[1945] = new Rule(1945, false, true, 1769, "1945: _1726 -> (BOR I32 _1723 _1725)", null, null, null, 0L, false, false, new int[]{1766, 1768}, null);
        CodeGenerator_x86simd.rulev[1951] = new Rule(1951, false, true, 1775, "1951: _1732 -> (BOR I32 _1729 _1731)", null, null, null, 0L, false, false, new int[]{1772, 1774}, null);
        CodeGenerator_x86simd.rulev[2090] = new Rule(2090, false, true, 1909, "2090: _1866 -> (BOR I32 _1863 _1865)", null, null, null, 0L, false, false, new int[]{1906, 1908}, null);
        CodeGenerator_x86simd.rulev[2096] = new Rule(2096, false, true, 1915, "2096: _1872 -> (BOR I32 _1869 _1871)", null, null, null, 0L, false, false, new int[]{1912, 1914}, null);
        CodeGenerator_x86simd.rulev[2103] = new Rule(2103, false, true, 1921, "2103: _1878 -> (BOR I32 _1875 _1877)", null, null, null, 0L, false, false, new int[]{1918, 1920}, null);
        CodeGenerator_x86simd.rulev[2109] = new Rule(2109, false, true, 1927, "2109: _1884 -> (BOR I32 _1881 _1883)", null, null, null, 0L, false, false, new int[]{1924, 1926}, null);
        CodeGenerator_x86simd.rulev[2376] = new Rule(2376, false, true, 2189, "2376: _2146 -> (BOR I32 _2143 _2145)", null, null, null, 0L, false, false, new int[]{2186, 2188}, null);
        CodeGenerator_x86simd.rulev[2382] = new Rule(2382, false, true, 2195, "2382: _2152 -> (BOR I32 _2149 _2151)", null, null, null, 0L, false, false, new int[]{2192, 2194}, null);
        CodeGenerator_x86simd.rulev[2388] = new Rule(2388, false, true, 2201, "2388: _2158 -> (BOR I32 _2155 _2157)", null, null, null, 0L, false, false, new int[]{2198, 2200}, null);
        CodeGenerator_x86simd.rulev[2394] = new Rule(2394, false, true, 2207, "2394: _2164 -> (BOR I32 _2161 _2163)", null, null, null, 0L, false, false, new int[]{2204, 2206}, null);
        CodeGenerator_x86simd.rulev[2401] = new Rule(2401, false, true, 2213, "2401: _2170 -> (BOR I32 _2167 _2169)", null, null, null, 0L, false, false, new int[]{2210, 2212}, null);
        CodeGenerator_x86simd.rulev[2407] = new Rule(2407, false, true, 2219, "2407: _2176 -> (BOR I32 _2173 _2175)", null, null, null, 0L, false, false, new int[]{2216, 2218}, null);
        CodeGenerator_x86simd.rulev[2413] = new Rule(2413, false, true, 2225, "2413: _2182 -> (BOR I32 _2179 _2181)", null, null, null, 0L, false, false, new int[]{2222, 2224}, null);
        CodeGenerator_x86simd.rulev[2419] = new Rule(2419, false, true, 2231, "2419: _2188 -> (BOR I32 _2185 _2187)", null, null, null, 0L, false, false, new int[]{2228, 2230}, null);
        CodeGenerator_x86simd.rulev[2492] = new Rule(2492, false, true, 2301, "2492: _2258 -> (BOR I32 _2255 _2257)", null, null, null, 0L, false, false, new int[]{2298, 2300}, null);
        CodeGenerator_x86simd.rulev[2498] = new Rule(2498, false, true, 2307, "2498: _2264 -> (BOR I32 _2261 _2263)", null, null, null, 0L, false, false, new int[]{2304, 2306}, null);
        CodeGenerator_x86simd.rulev[2635] = new Rule(2635, false, true, 2441, "2635: _2398 -> (BOR I32 _2395 _2397)", null, null, null, 0L, false, false, new int[]{2438, 2440}, null);
        CodeGenerator_x86simd.rulev[2641] = new Rule(2641, false, true, 2447, "2641: _2404 -> (BOR I32 _2401 _2403)", null, null, null, 0L, false, false, new int[]{2444, 2446}, null);
        CodeGenerator_x86simd.rulev[2647] = new Rule(2647, false, true, 2453, "2647: _2410 -> (BOR I32 _2407 _2409)", null, null, null, 0L, false, false, new int[]{2450, 2452}, null);
        CodeGenerator_x86simd.rulev[2653] = new Rule(2653, false, true, 2459, "2653: _2416 -> (BOR I32 _2413 _2415)", null, null, null, 0L, false, false, new int[]{2456, 2458}, null);
        CodeGenerator_x86simd.rulev[2726] = new Rule(2726, false, true, 2529, "2726: _2486 -> (BOR I32 _2483 _2485)", null, null, null, 0L, false, false, new int[]{2526, 2528}, null);
        CodeGenerator_x86simd.rulev[2732] = new Rule(2732, false, true, 2535, "2732: _2492 -> (BOR I32 _2489 _2491)", null, null, null, 0L, false, false, new int[]{2532, 2534}, null);
        CodeGenerator_x86simd.rulev[2869] = new Rule(2869, false, true, 2669, "2869: _2626 -> (BOR I32 _2623 _2625)", null, null, null, 0L, false, false, new int[]{2666, 2668}, null);
        CodeGenerator_x86simd.rulev[2875] = new Rule(2875, false, true, 2675, "2875: _2632 -> (BOR I32 _2629 _2631)", null, null, null, 0L, false, false, new int[]{2672, 2674}, null);
        CodeGenerator_x86simd.rulev[2881] = new Rule(2881, false, true, 2681, "2881: _2638 -> (BOR I32 _2635 _2637)", null, null, null, 0L, false, false, new int[]{2678, 2680}, null);
    }

    private static void rrinit1800() {
        CodeGenerator_x86simd.rulev[2887] = new Rule(2887, false, true, 2687, "2887: _2644 -> (BOR I32 _2641 _2643)", null, null, null, 0L, false, false, new int[]{2684, 2686}, null);
        CodeGenerator_x86simd.rulev[3381] = new Rule(3381, false, true, 3136, "3381: _3093 -> (BOR I32 _125 _125)", null, null, null, 0L, false, false, new int[]{168, 168}, null);
        CodeGenerator_x86simd.rulev[3383] = new Rule(3383, false, true, 3138, "3383: _3095 -> (BOR I32 _127 _127)", null, null, null, 0L, false, false, new int[]{170, 170}, null);
        CodeGenerator_x86simd.rulev[3621] = new Rule(3621, false, true, 3360, "3621: _3317 -> (BOR I32 _65 _65)", null, null, null, 0L, false, false, new int[]{108, 108}, null);
        CodeGenerator_x86simd.rulev[3623] = new Rule(3623, false, true, 3362, "3623: _3319 -> (BOR I32 _67 _67)", null, null, null, 0L, false, false, new int[]{110, 110}, null);
        CodeGenerator_x86simd.rulev[3625] = new Rule(3625, false, true, 3364, "3625: _3321 -> (BOR I32 _69 _69)", null, null, null, 0L, false, false, new int[]{112, 112}, null);
        CodeGenerator_x86simd.rulev[3627] = new Rule(3627, false, true, 3366, "3627: _3323 -> (BOR I32 _71 _71)", null, null, null, 0L, false, false, new int[]{114, 114}, null);
        CodeGenerator_x86simd.rulev[4006] = new Rule(4006, false, false, 4, "4006: regl -> (BOR I32 regl mrcl)", ImList.list(ImList.list("orl", "$2", "$0")), null, null, 2L, false, false, new int[]{4, 40}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4020] = new Rule(4020, false, false, 4, "4020: regl -> (BOR I32 mrcl regl)", ImList.list(ImList.list("orl", "$1", "$0")), null, null, 4L, false, false, new int[]{40, 4}, new String[]{"*reg-I32*", null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[3977] = new Rule(3977, false, false, 3, "3977: regq -> (BOR I64 regq mrcq)", ImList.list(ImList.list("orl", ImList.list("qlow", "$2"), ImList.list("qlow", "$0")), ImList.list("orl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{3, 47}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86simd.rulev[3303] = new Rule(3303, false, true, 3068, "3303: _3025 -> (BXOR I8 _101 _101)", null, null, null, 0L, false, false, new int[]{144, 144}, null);
        CodeGenerator_x86simd.rulev[3305] = new Rule(3305, false, true, 3070, "3305: _3027 -> (BXOR I8 _103 _103)", null, null, null, 0L, false, false, new int[]{146, 146}, null);
        CodeGenerator_x86simd.rulev[3307] = new Rule(3307, false, true, 3072, "3307: _3029 -> (BXOR I8 _105 _105)", null, null, null, 0L, false, false, new int[]{148, 148}, null);
        CodeGenerator_x86simd.rulev[3309] = new Rule(3309, false, true, 3074, "3309: _3031 -> (BXOR I8 _107 _107)", null, null, null, 0L, false, false, new int[]{150, 150}, null);
        CodeGenerator_x86simd.rulev[3311] = new Rule(3311, false, true, 3076, "3311: _3033 -> (BXOR I8 _109 _109)", null, null, null, 0L, false, false, new int[]{152, 152}, null);
        CodeGenerator_x86simd.rulev[3313] = new Rule(3313, false, true, 3078, "3313: _3035 -> (BXOR I8 _111 _111)", null, null, null, 0L, false, false, new int[]{154, 154}, null);
        CodeGenerator_x86simd.rulev[3315] = new Rule(3315, false, true, 3080, "3315: _3037 -> (BXOR I8 _113 _113)", null, null, null, 0L, false, false, new int[]{156, 156}, null);
        CodeGenerator_x86simd.rulev[3317] = new Rule(3317, false, true, 3082, "3317: _3039 -> (BXOR I8 _115 _115)", null, null, null, 0L, false, false, new int[]{158, 158}, null);
        CodeGenerator_x86simd.rulev[3475] = new Rule(3475, false, true, 3224, "3475: _3181 -> (BXOR I8 _7 _7)", null, null, null, 0L, false, false, new int[]{50, 50}, null);
        CodeGenerator_x86simd.rulev[3477] = new Rule(3477, false, true, 3226, "3477: _3183 -> (BXOR I8 _9 _9)", null, null, null, 0L, false, false, new int[]{52, 52}, null);
        CodeGenerator_x86simd.rulev[3479] = new Rule(3479, false, true, 3228, "3479: _3185 -> (BXOR I8 _11 _11)", null, null, null, 0L, false, false, new int[]{54, 54}, null);
        CodeGenerator_x86simd.rulev[3481] = new Rule(3481, false, true, 3230, "3481: _3187 -> (BXOR I8 _13 _13)", null, null, null, 0L, false, false, new int[]{56, 56}, null);
        CodeGenerator_x86simd.rulev[3483] = new Rule(3483, false, true, 3232, "3483: _3189 -> (BXOR I8 _15 _15)", null, null, null, 0L, false, false, new int[]{58, 58}, null);
        CodeGenerator_x86simd.rulev[3485] = new Rule(3485, false, true, 3234, "3485: _3191 -> (BXOR I8 _18 _18)", null, null, null, 0L, false, false, new int[]{61, 61}, null);
        CodeGenerator_x86simd.rulev[3487] = new Rule(3487, false, true, 3236, "3487: _3193 -> (BXOR I8 _21 _21)", null, null, null, 0L, false, false, new int[]{64, 64}, null);
        CodeGenerator_x86simd.rulev[3489] = new Rule(3489, false, true, 3238, "3489: _3195 -> (BXOR I8 _24 _24)", null, null, null, 0L, false, false, new int[]{67, 67}, null);
        CodeGenerator_x86simd.rulev[3491] = new Rule(3491, false, true, 3240, "3491: _3197 -> (BXOR I8 _26 _26)", null, null, null, 0L, false, false, new int[]{69, 69}, null);
        CodeGenerator_x86simd.rulev[3493] = new Rule(3493, false, true, 3242, "3493: _3199 -> (BXOR I8 _29 _29)", null, null, null, 0L, false, false, new int[]{72, 72}, null);
        CodeGenerator_x86simd.rulev[3495] = new Rule(3495, false, true, 3244, "3495: _3201 -> (BXOR I8 _32 _32)", null, null, null, 0L, false, false, new int[]{75, 75}, null);
        CodeGenerator_x86simd.rulev[3497] = new Rule(3497, false, true, 3246, "3497: _3203 -> (BXOR I8 _35 _35)", null, null, null, 0L, false, false, new int[]{78, 78}, null);
        CodeGenerator_x86simd.rulev[3499] = new Rule(3499, false, true, 3248, "3499: _3205 -> (BXOR I8 _38 _38)", null, null, null, 0L, false, false, new int[]{81, 81}, null);
        CodeGenerator_x86simd.rulev[3501] = new Rule(3501, false, true, 3250, "3501: _3207 -> (BXOR I8 _41 _41)", null, null, null, 0L, false, false, new int[]{84, 84}, null);
        CodeGenerator_x86simd.rulev[3503] = new Rule(3503, false, true, 3252, "3503: _3209 -> (BXOR I8 _44 _44)", null, null, null, 0L, false, false, new int[]{87, 87}, null);
        CodeGenerator_x86simd.rulev[3505] = new Rule(3505, false, true, 3254, "3505: _3211 -> (BXOR I8 _47 _47)", null, null, null, 0L, false, false, new int[]{90, 90}, null);
        CodeGenerator_x86simd.rulev[4012] = new Rule(4012, false, false, 7, "4012: regb -> (BXOR I8 regb mrcb)", ImList.list(ImList.list("xorb", "$2", "$0")), null, null, 2L, false, false, new int[]{7, 44}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[4029] = new Rule(4029, false, false, 7, "4029: regb -> (BXOR I8 mrcb regb)", ImList.list(ImList.list("xorb", "$1", "$0")), null, null, 4L, false, false, new int[]{44, 7}, new String[]{"*reg-I8*", null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[3357] = new Rule(3357, false, true, 3116, "3357: _3073 -> (BXOR I16 _117 _117)", null, null, null, 0L, false, false, new int[]{160, 160}, null);
        CodeGenerator_x86simd.rulev[3359] = new Rule(3359, false, true, 3118, "3359: _3075 -> (BXOR I16 _119 _119)", null, null, null, 0L, false, false, new int[]{162, 162}, null);
        CodeGenerator_x86simd.rulev[3361] = new Rule(3361, false, true, 3120, "3361: _3077 -> (BXOR I16 _121 _121)", null, null, null, 0L, false, false, new int[]{164, 164}, null);
        CodeGenerator_x86simd.rulev[3363] = new Rule(3363, false, true, 3122, "3363: _3079 -> (BXOR I16 _123 _123)", null, null, null, 0L, false, false, new int[]{166, 166}, null);
        CodeGenerator_x86simd.rulev[3577] = new Rule(3577, false, true, 3320, "3577: _3277 -> (BXOR I16 _49 _49)", null, null, null, 0L, false, false, new int[]{92, 92}, null);
        CodeGenerator_x86simd.rulev[3579] = new Rule(3579, false, true, 3322, "3579: _3279 -> (BXOR I16 _51 _51)", null, null, null, 0L, false, false, new int[]{94, 94}, null);
        CodeGenerator_x86simd.rulev[3581] = new Rule(3581, false, true, 3324, "3581: _3281 -> (BXOR I16 _53 _53)", null, null, null, 0L, false, false, new int[]{96, 96}, null);
        CodeGenerator_x86simd.rulev[3583] = new Rule(3583, false, true, 3326, "3583: _3283 -> (BXOR I16 _55 _55)", null, null, null, 0L, false, false, new int[]{98, 98}, null);
        CodeGenerator_x86simd.rulev[3585] = new Rule(3585, false, true, 3328, "3585: _3285 -> (BXOR I16 _57 _57)", null, null, null, 0L, false, false, new int[]{100, 100}, null);
        CodeGenerator_x86simd.rulev[3587] = new Rule(3587, false, true, 3330, "3587: _3287 -> (BXOR I16 _59 _59)", null, null, null, 0L, false, false, new int[]{102, 102}, null);
        CodeGenerator_x86simd.rulev[3589] = new Rule(3589, false, true, 3332, "3589: _3289 -> (BXOR I16 _61 _61)", null, null, null, 0L, false, false, new int[]{104, 104}, null);
        CodeGenerator_x86simd.rulev[3591] = new Rule(3591, false, true, 3334, "3591: _3291 -> (BXOR I16 _63 _63)", null, null, null, 0L, false, false, new int[]{106, 106}, null);
        CodeGenerator_x86simd.rulev[4017] = new Rule(4017, false, false, 6, "4017: regw -> (BXOR I16 regw mrcw)", ImList.list(ImList.list("xorw", "$2", "$0")), null, null, 2L, false, false, new int[]{6, 42}, new String[]{"*reg-I16*", "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[4025] = new Rule(4025, false, false, 6, "4025: regw -> (BXOR I16 mrcw regw)", ImList.list(ImList.list("xorw", "$1", "$0")), null, null, 4L, false, false, new int[]{42, 6}, new String[]{"*reg-I16*", null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[3386] = new Rule(3386, false, true, 3140, "3386: _3097 -> (BXOR I32 _125 _125)", null, null, null, 0L, false, false, new int[]{168, 168}, null);
        CodeGenerator_x86simd.rulev[3388] = new Rule(3388, false, true, 3142, "3388: _3099 -> (BXOR I32 _127 _127)", null, null, null, 0L, false, false, new int[]{170, 170}, null);
        CodeGenerator_x86simd.rulev[3630] = new Rule(3630, false, true, 3368, "3630: _3325 -> (BXOR I32 _65 _65)", null, null, null, 0L, false, false, new int[]{108, 108}, null);
        CodeGenerator_x86simd.rulev[3632] = new Rule(3632, false, true, 3370, "3632: _3327 -> (BXOR I32 _67 _67)", null, null, null, 0L, false, false, new int[]{110, 110}, null);
        CodeGenerator_x86simd.rulev[3634] = new Rule(3634, false, true, 3372, "3634: _3329 -> (BXOR I32 _69 _69)", null, null, null, 0L, false, false, new int[]{112, 112}, null);
        CodeGenerator_x86simd.rulev[3636] = new Rule(3636, false, true, 3374, "3636: _3331 -> (BXOR I32 _71 _71)", null, null, null, 0L, false, false, new int[]{114, 114}, null);
        CodeGenerator_x86simd.rulev[4007] = new Rule(4007, false, false, 4, "4007: regl -> (BXOR I32 regl mrcl)", ImList.list(ImList.list("xorl", "$2", "$0")), null, null, 2L, false, false, new int[]{4, 40}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4021] = new Rule(4021, false, false, 4, "4021: regl -> (BXOR I32 mrcl regl)", ImList.list(ImList.list("xorl", "$1", "$0")), null, null, 4L, false, false, new int[]{40, 4}, new String[]{"*reg-I32*", null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[3978] = new Rule(3978, false, false, 3, "3978: regq -> (BXOR I64 regq mrcq)", ImList.list(ImList.list("xorl", ImList.list("qlow", "$2"), ImList.list("qlow", "$0")), ImList.list("xorl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{3, 47}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86simd.rulev[462] = new Rule(462, false, true, 315, "462: _272 -> (BNOT I8 _270)", null, null, null, 0L, false, false, new int[]{313}, null);
        CodeGenerator_x86simd.rulev[468] = new Rule(468, false, true, 321, "468: _278 -> (BNOT I8 _276)", null, null, null, 0L, false, false, new int[]{319}, null);
        CodeGenerator_x86simd.rulev[475] = new Rule(475, false, true, 328, "475: _285 -> (BNOT I8 _283)", null, null, null, 0L, false, false, new int[]{326}, null);
        CodeGenerator_x86simd.rulev[482] = new Rule(482, false, true, 335, "482: _292 -> (BNOT I8 _290)", null, null, null, 0L, false, false, new int[]{333}, null);
        CodeGenerator_x86simd.rulev[489] = new Rule(489, false, true, 342, "489: _299 -> (BNOT I8 _297)", null, null, null, 0L, false, false, new int[]{340}, null);
        CodeGenerator_x86simd.rulev[496] = new Rule(496, false, true, 349, "496: _306 -> (BNOT I8 _304)", null, null, null, 0L, false, false, new int[]{347}, null);
        CodeGenerator_x86simd.rulev[503] = new Rule(503, false, true, 356, "503: _313 -> (BNOT I8 _311)", null, null, null, 0L, false, false, new int[]{354}, null);
        CodeGenerator_x86simd.rulev[510] = new Rule(510, false, true, 363, "510: _320 -> (BNOT I8 _318)", null, null, null, 0L, false, false, new int[]{361}, null);
        CodeGenerator_x86simd.rulev[518] = new Rule(518, false, true, 370, "518: _327 -> (BNOT I8 _325)", null, null, null, 0L, false, false, new int[]{368}, null);
        CodeGenerator_x86simd.rulev[524] = new Rule(524, false, true, 376, "524: _333 -> (BNOT I8 _331)", null, null, null, 0L, false, false, new int[]{374}, null);
        CodeGenerator_x86simd.rulev[531] = new Rule(531, false, true, 383, "531: _340 -> (BNOT I8 _338)", null, null, null, 0L, false, false, new int[]{381}, null);
        CodeGenerator_x86simd.rulev[538] = new Rule(538, false, true, 390, "538: _347 -> (BNOT I8 _345)", null, null, null, 0L, false, false, new int[]{388}, null);
        CodeGenerator_x86simd.rulev[545] = new Rule(545, false, true, 397, "545: _354 -> (BNOT I8 _352)", null, null, null, 0L, false, false, new int[]{395}, null);
        CodeGenerator_x86simd.rulev[552] = new Rule(552, false, true, 404, "552: _361 -> (BNOT I8 _359)", null, null, null, 0L, false, false, new int[]{402}, null);
        CodeGenerator_x86simd.rulev[559] = new Rule(559, false, true, 411, "559: _368 -> (BNOT I8 _366)", null, null, null, 0L, false, false, new int[]{409}, null);
        CodeGenerator_x86simd.rulev[566] = new Rule(566, false, true, 418, "566: _375 -> (BNOT I8 _373)", null, null, null, 0L, false, false, new int[]{416}, null);
        CodeGenerator_x86simd.rulev[574] = new Rule(574, false, true, 426, "574: _383 -> (BNOT I8 _381)", null, null, null, 0L, false, false, new int[]{424}, null);
        CodeGenerator_x86simd.rulev[580] = new Rule(580, false, true, 432, "580: _389 -> (BNOT I8 _387)", null, null, null, 0L, false, false, new int[]{430}, null);
        CodeGenerator_x86simd.rulev[587] = new Rule(587, false, true, 439, "587: _396 -> (BNOT I8 _394)", null, null, null, 0L, false, false, new int[]{437}, null);
        CodeGenerator_x86simd.rulev[594] = new Rule(594, false, true, 446, "594: _403 -> (BNOT I8 _401)", null, null, null, 0L, false, false, new int[]{444}, null);
        CodeGenerator_x86simd.rulev[601] = new Rule(601, false, true, 453, "601: _410 -> (BNOT I8 _408)", null, null, null, 0L, false, false, new int[]{451}, null);
        CodeGenerator_x86simd.rulev[608] = new Rule(608, false, true, 460, "608: _417 -> (BNOT I8 _415)", null, null, null, 0L, false, false, new int[]{458}, null);
        CodeGenerator_x86simd.rulev[615] = new Rule(615, false, true, 467, "615: _424 -> (BNOT I8 _422)", null, null, null, 0L, false, false, new int[]{465}, null);
        CodeGenerator_x86simd.rulev[622] = new Rule(622, false, true, 474, "622: _431 -> (BNOT I8 _429)", null, null, null, 0L, false, false, new int[]{472}, null);
        CodeGenerator_x86simd.rulev[1000] = new Rule(1000, false, true, 843, "1000: _800 -> (BNOT I8 _798)", null, null, null, 0L, false, false, new int[]{841}, null);
        CodeGenerator_x86simd.rulev[1006] = new Rule(1006, false, true, 849, "1006: _806 -> (BNOT I8 _804)", null, null, null, 0L, false, false, new int[]{847}, null);
        CodeGenerator_x86simd.rulev[1012] = new Rule(1012, false, true, 855, "1012: _812 -> (BNOT I8 _810)", null, null, null, 0L, false, false, new int[]{853}, null);
        CodeGenerator_x86simd.rulev[1018] = new Rule(1018, false, true, 861, "1018: _818 -> (BNOT I8 _816)", null, null, null, 0L, false, false, new int[]{859}, null);
        CodeGenerator_x86simd.rulev[1024] = new Rule(1024, false, true, 867, "1024: _824 -> (BNOT I8 _822)", null, null, null, 0L, false, false, new int[]{865}, null);
        CodeGenerator_x86simd.rulev[1030] = new Rule(1030, false, true, 873, "1030: _830 -> (BNOT I8 _828)", null, null, null, 0L, false, false, new int[]{871}, null);
        CodeGenerator_x86simd.rulev[1036] = new Rule(1036, false, true, 879, "1036: _836 -> (BNOT I8 _834)", null, null, null, 0L, false, false, new int[]{877}, null);
        CodeGenerator_x86simd.rulev[1042] = new Rule(1042, false, true, 885, "1042: _842 -> (BNOT I8 _840)", null, null, null, 0L, false, false, new int[]{883}, null);
        CodeGenerator_x86simd.rulev[1049] = new Rule(1049, false, true, 891, "1049: _848 -> (BNOT I8 _846)", null, null, null, 0L, false, false, new int[]{889}, null);
        CodeGenerator_x86simd.rulev[1055] = new Rule(1055, false, true, 897, "1055: _854 -> (BNOT I8 _852)", null, null, null, 0L, false, false, new int[]{895}, null);
        CodeGenerator_x86simd.rulev[1061] = new Rule(1061, false, true, 903, "1061: _860 -> (BNOT I8 _858)", null, null, null, 0L, false, false, new int[]{901}, null);
        CodeGenerator_x86simd.rulev[1067] = new Rule(1067, false, true, 909, "1067: _866 -> (BNOT I8 _864)", null, null, null, 0L, false, false, new int[]{907}, null);
        CodeGenerator_x86simd.rulev[1073] = new Rule(1073, false, true, 915, "1073: _872 -> (BNOT I8 _870)", null, null, null, 0L, false, false, new int[]{913}, null);
        CodeGenerator_x86simd.rulev[1079] = new Rule(1079, false, true, 921, "1079: _878 -> (BNOT I8 _876)", null, null, null, 0L, false, false, new int[]{919}, null);
        CodeGenerator_x86simd.rulev[1085] = new Rule(1085, false, true, 927, "1085: _884 -> (BNOT I8 _882)", null, null, null, 0L, false, false, new int[]{925}, null);
        CodeGenerator_x86simd.rulev[1091] = new Rule(1091, false, true, 933, "1091: _890 -> (BNOT I8 _888)", null, null, null, 0L, false, false, new int[]{931}, null);
        CodeGenerator_x86simd.rulev[1098] = new Rule(1098, false, true, 939, "1098: _896 -> (BNOT I8 _894)", null, null, null, 0L, false, false, new int[]{937}, null);
    }

    private static void rrinit1900() {
        CodeGenerator_x86simd.rulev[1104] = new Rule(1104, false, true, 945, "1104: _902 -> (BNOT I8 _900)", null, null, null, 0L, false, false, new int[]{943}, null);
        CodeGenerator_x86simd.rulev[1110] = new Rule(1110, false, true, 951, "1110: _908 -> (BNOT I8 _906)", null, null, null, 0L, false, false, new int[]{949}, null);
        CodeGenerator_x86simd.rulev[1116] = new Rule(1116, false, true, 957, "1116: _914 -> (BNOT I8 _912)", null, null, null, 0L, false, false, new int[]{955}, null);
        CodeGenerator_x86simd.rulev[1122] = new Rule(1122, false, true, 963, "1122: _920 -> (BNOT I8 _918)", null, null, null, 0L, false, false, new int[]{961}, null);
        CodeGenerator_x86simd.rulev[1128] = new Rule(1128, false, true, 969, "1128: _926 -> (BNOT I8 _924)", null, null, null, 0L, false, false, new int[]{967}, null);
        CodeGenerator_x86simd.rulev[1134] = new Rule(1134, false, true, 975, "1134: _932 -> (BNOT I8 _930)", null, null, null, 0L, false, false, new int[]{973}, null);
        CodeGenerator_x86simd.rulev[1140] = new Rule(1140, false, true, 981, "1140: _938 -> (BNOT I8 _936)", null, null, null, 0L, false, false, new int[]{979}, null);
        CodeGenerator_x86simd.rulev[1146] = new Rule(1146, false, true, 987, "1146: _944 -> (BNOT I8 _942)", null, null, null, 0L, false, false, new int[]{985}, null);
        CodeGenerator_x86simd.rulev[1152] = new Rule(1152, false, true, 993, "1152: _950 -> (BNOT I8 _948)", null, null, null, 0L, false, false, new int[]{991}, null);
        CodeGenerator_x86simd.rulev[1158] = new Rule(1158, false, true, 999, "1158: _956 -> (BNOT I8 _954)", null, null, null, 0L, false, false, new int[]{997}, null);
        CodeGenerator_x86simd.rulev[1164] = new Rule(1164, false, true, 1005, "1164: _962 -> (BNOT I8 _960)", null, null, null, 0L, false, false, new int[]{1003}, null);
        CodeGenerator_x86simd.rulev[1170] = new Rule(1170, false, true, 1011, "1170: _968 -> (BNOT I8 _966)", null, null, null, 0L, false, false, new int[]{1009}, null);
        CodeGenerator_x86simd.rulev[1176] = new Rule(1176, false, true, 1017, "1176: _974 -> (BNOT I8 _972)", null, null, null, 0L, false, false, new int[]{1015}, null);
        CodeGenerator_x86simd.rulev[1182] = new Rule(1182, false, true, 1023, "1182: _980 -> (BNOT I8 _978)", null, null, null, 0L, false, false, new int[]{1021}, null);
        CodeGenerator_x86simd.rulev[1188] = new Rule(1188, false, true, 1029, "1188: _986 -> (BNOT I8 _984)", null, null, null, 0L, false, false, new int[]{1027}, null);
        CodeGenerator_x86simd.rulev[1195] = new Rule(1195, false, true, 1035, "1195: _992 -> (BNOT I8 _990)", null, null, null, 0L, false, false, new int[]{1033}, null);
        CodeGenerator_x86simd.rulev[1201] = new Rule(1201, false, true, 1041, "1201: _998 -> (BNOT I8 _996)", null, null, null, 0L, false, false, new int[]{1039}, null);
        CodeGenerator_x86simd.rulev[1207] = new Rule(1207, false, true, 1047, "1207: _1004 -> (BNOT I8 _1002)", null, null, null, 0L, false, false, new int[]{1045}, null);
        CodeGenerator_x86simd.rulev[1213] = new Rule(1213, false, true, 1053, "1213: _1010 -> (BNOT I8 _1008)", null, null, null, 0L, false, false, new int[]{1051}, null);
        CodeGenerator_x86simd.rulev[1219] = new Rule(1219, false, true, 1059, "1219: _1016 -> (BNOT I8 _1014)", null, null, null, 0L, false, false, new int[]{1057}, null);
        CodeGenerator_x86simd.rulev[1225] = new Rule(1225, false, true, 1065, "1225: _1022 -> (BNOT I8 _1020)", null, null, null, 0L, false, false, new int[]{1063}, null);
        CodeGenerator_x86simd.rulev[1231] = new Rule(1231, false, true, 1071, "1231: _1028 -> (BNOT I8 _1026)", null, null, null, 0L, false, false, new int[]{1069}, null);
        CodeGenerator_x86simd.rulev[1237] = new Rule(1237, false, true, 1077, "1237: _1034 -> (BNOT I8 _1032)", null, null, null, 0L, false, false, new int[]{1075}, null);
        CodeGenerator_x86simd.rulev[1243] = new Rule(1243, false, true, 1083, "1243: _1040 -> (BNOT I8 _1038)", null, null, null, 0L, false, false, new int[]{1081}, null);
        CodeGenerator_x86simd.rulev[1249] = new Rule(1249, false, true, 1089, "1249: _1046 -> (BNOT I8 _1044)", null, null, null, 0L, false, false, new int[]{1087}, null);
        CodeGenerator_x86simd.rulev[1255] = new Rule(1255, false, true, 1095, "1255: _1052 -> (BNOT I8 _1050)", null, null, null, 0L, false, false, new int[]{1093}, null);
        CodeGenerator_x86simd.rulev[1261] = new Rule(1261, false, true, 1101, "1261: _1058 -> (BNOT I8 _1056)", null, null, null, 0L, false, false, new int[]{1099}, null);
        CodeGenerator_x86simd.rulev[1267] = new Rule(1267, false, true, 1107, "1267: _1064 -> (BNOT I8 _1062)", null, null, null, 0L, false, false, new int[]{1105}, null);
        CodeGenerator_x86simd.rulev[1273] = new Rule(1273, false, true, 1113, "1273: _1070 -> (BNOT I8 _1068)", null, null, null, 0L, false, false, new int[]{1111}, null);
        CodeGenerator_x86simd.rulev[1279] = new Rule(1279, false, true, 1119, "1279: _1076 -> (BNOT I8 _1074)", null, null, null, 0L, false, false, new int[]{1117}, null);
        CodeGenerator_x86simd.rulev[1285] = new Rule(1285, false, true, 1125, "1285: _1082 -> (BNOT I8 _1080)", null, null, null, 0L, false, false, new int[]{1123}, null);
        CodeGenerator_x86simd.rulev[1440] = new Rule(1440, false, true, 1275, "1440: _1232 -> (BNOT I8 _1230)", null, null, null, 0L, false, false, new int[]{1273}, null);
        CodeGenerator_x86simd.rulev[1446] = new Rule(1446, false, true, 1281, "1446: _1238 -> (BNOT I8 _1236)", null, null, null, 0L, false, false, new int[]{1279}, null);
        CodeGenerator_x86simd.rulev[1452] = new Rule(1452, false, true, 1287, "1452: _1244 -> (BNOT I8 _1242)", null, null, null, 0L, false, false, new int[]{1285}, null);
        CodeGenerator_x86simd.rulev[1458] = new Rule(1458, false, true, 1293, "1458: _1250 -> (BNOT I8 _1248)", null, null, null, 0L, false, false, new int[]{1291}, null);
        CodeGenerator_x86simd.rulev[1464] = new Rule(1464, false, true, 1299, "1464: _1256 -> (BNOT I8 _1254)", null, null, null, 0L, false, false, new int[]{1297}, null);
        CodeGenerator_x86simd.rulev[1470] = new Rule(1470, false, true, 1305, "1470: _1262 -> (BNOT I8 _1260)", null, null, null, 0L, false, false, new int[]{1303}, null);
        CodeGenerator_x86simd.rulev[1476] = new Rule(1476, false, true, 1311, "1476: _1268 -> (BNOT I8 _1266)", null, null, null, 0L, false, false, new int[]{1309}, null);
        CodeGenerator_x86simd.rulev[1482] = new Rule(1482, false, true, 1317, "1482: _1274 -> (BNOT I8 _1272)", null, null, null, 0L, false, false, new int[]{1315}, null);
        CodeGenerator_x86simd.rulev[1489] = new Rule(1489, false, true, 1323, "1489: _1280 -> (BNOT I8 _1278)", null, null, null, 0L, false, false, new int[]{1321}, null);
        CodeGenerator_x86simd.rulev[1495] = new Rule(1495, false, true, 1329, "1495: _1286 -> (BNOT I8 _1284)", null, null, null, 0L, false, false, new int[]{1327}, null);
        CodeGenerator_x86simd.rulev[1501] = new Rule(1501, false, true, 1335, "1501: _1292 -> (BNOT I8 _1290)", null, null, null, 0L, false, false, new int[]{1333}, null);
        CodeGenerator_x86simd.rulev[1507] = new Rule(1507, false, true, 1341, "1507: _1298 -> (BNOT I8 _1296)", null, null, null, 0L, false, false, new int[]{1339}, null);
        CodeGenerator_x86simd.rulev[1513] = new Rule(1513, false, true, 1347, "1513: _1304 -> (BNOT I8 _1302)", null, null, null, 0L, false, false, new int[]{1345}, null);
        CodeGenerator_x86simd.rulev[1519] = new Rule(1519, false, true, 1353, "1519: _1310 -> (BNOT I8 _1308)", null, null, null, 0L, false, false, new int[]{1351}, null);
        CodeGenerator_x86simd.rulev[1525] = new Rule(1525, false, true, 1359, "1525: _1316 -> (BNOT I8 _1314)", null, null, null, 0L, false, false, new int[]{1357}, null);
        CodeGenerator_x86simd.rulev[1531] = new Rule(1531, false, true, 1365, "1531: _1322 -> (BNOT I8 _1320)", null, null, null, 0L, false, false, new int[]{1363}, null);
        CodeGenerator_x86simd.rulev[1614] = new Rule(1614, false, true, 1443, "1614: _1400 -> (BNOT I8 _1398)", null, null, null, 0L, false, false, new int[]{1441}, null);
        CodeGenerator_x86simd.rulev[1620] = new Rule(1620, false, true, 1449, "1620: _1406 -> (BNOT I8 _1404)", null, null, null, 0L, false, false, new int[]{1447}, null);
        CodeGenerator_x86simd.rulev[1626] = new Rule(1626, false, true, 1455, "1626: _1412 -> (BNOT I8 _1410)", null, null, null, 0L, false, false, new int[]{1453}, null);
        CodeGenerator_x86simd.rulev[1632] = new Rule(1632, false, true, 1461, "1632: _1418 -> (BNOT I8 _1416)", null, null, null, 0L, false, false, new int[]{1459}, null);
        CodeGenerator_x86simd.rulev[1638] = new Rule(1638, false, true, 1467, "1638: _1424 -> (BNOT I8 _1422)", null, null, null, 0L, false, false, new int[]{1465}, null);
        CodeGenerator_x86simd.rulev[1644] = new Rule(1644, false, true, 1473, "1644: _1430 -> (BNOT I8 _1428)", null, null, null, 0L, false, false, new int[]{1471}, null);
        CodeGenerator_x86simd.rulev[1650] = new Rule(1650, false, true, 1479, "1650: _1436 -> (BNOT I8 _1434)", null, null, null, 0L, false, false, new int[]{1477}, null);
        CodeGenerator_x86simd.rulev[1656] = new Rule(1656, false, true, 1485, "1656: _1442 -> (BNOT I8 _1440)", null, null, null, 0L, false, false, new int[]{1483}, null);
        CodeGenerator_x86simd.rulev[1662] = new Rule(1662, false, true, 1491, "1662: _1448 -> (BNOT I8 _1446)", null, null, null, 0L, false, false, new int[]{1489}, null);
        CodeGenerator_x86simd.rulev[1668] = new Rule(1668, false, true, 1497, "1668: _1454 -> (BNOT I8 _1452)", null, null, null, 0L, false, false, new int[]{1495}, null);
        CodeGenerator_x86simd.rulev[1674] = new Rule(1674, false, true, 1503, "1674: _1460 -> (BNOT I8 _1458)", null, null, null, 0L, false, false, new int[]{1501}, null);
        CodeGenerator_x86simd.rulev[1680] = new Rule(1680, false, true, 1509, "1680: _1466 -> (BNOT I8 _1464)", null, null, null, 0L, false, false, new int[]{1507}, null);
        CodeGenerator_x86simd.rulev[1686] = new Rule(1686, false, true, 1515, "1686: _1472 -> (BNOT I8 _1470)", null, null, null, 0L, false, false, new int[]{1513}, null);
        CodeGenerator_x86simd.rulev[1692] = new Rule(1692, false, true, 1521, "1692: _1478 -> (BNOT I8 _1476)", null, null, null, 0L, false, false, new int[]{1519}, null);
        CodeGenerator_x86simd.rulev[1698] = new Rule(1698, false, true, 1527, "1698: _1484 -> (BNOT I8 _1482)", null, null, null, 0L, false, false, new int[]{1525}, null);
        CodeGenerator_x86simd.rulev[1704] = new Rule(1704, false, true, 1533, "1704: _1490 -> (BNOT I8 _1488)", null, null, null, 0L, false, false, new int[]{1531}, null);
        CodeGenerator_x86simd.rulev[1711] = new Rule(1711, false, true, 1539, "1711: _1496 -> (BNOT I8 _1494)", null, null, null, 0L, false, false, new int[]{1537}, null);
        CodeGenerator_x86simd.rulev[1717] = new Rule(1717, false, true, 1545, "1717: _1502 -> (BNOT I8 _1500)", null, null, null, 0L, false, false, new int[]{1543}, null);
        CodeGenerator_x86simd.rulev[1723] = new Rule(1723, false, true, 1551, "1723: _1508 -> (BNOT I8 _1506)", null, null, null, 0L, false, false, new int[]{1549}, null);
        CodeGenerator_x86simd.rulev[1729] = new Rule(1729, false, true, 1557, "1729: _1514 -> (BNOT I8 _1512)", null, null, null, 0L, false, false, new int[]{1555}, null);
        CodeGenerator_x86simd.rulev[1735] = new Rule(1735, false, true, 1563, "1735: _1520 -> (BNOT I8 _1518)", null, null, null, 0L, false, false, new int[]{1561}, null);
        CodeGenerator_x86simd.rulev[1741] = new Rule(1741, false, true, 1569, "1741: _1526 -> (BNOT I8 _1524)", null, null, null, 0L, false, false, new int[]{1567}, null);
        CodeGenerator_x86simd.rulev[1747] = new Rule(1747, false, true, 1575, "1747: _1532 -> (BNOT I8 _1530)", null, null, null, 0L, false, false, new int[]{1573}, null);
        CodeGenerator_x86simd.rulev[1753] = new Rule(1753, false, true, 1581, "1753: _1538 -> (BNOT I8 _1536)", null, null, null, 0L, false, false, new int[]{1579}, null);
        CodeGenerator_x86simd.rulev[1759] = new Rule(1759, false, true, 1587, "1759: _1544 -> (BNOT I8 _1542)", null, null, null, 0L, false, false, new int[]{1585}, null);
        CodeGenerator_x86simd.rulev[1765] = new Rule(1765, false, true, 1593, "1765: _1550 -> (BNOT I8 _1548)", null, null, null, 0L, false, false, new int[]{1591}, null);
        CodeGenerator_x86simd.rulev[1771] = new Rule(1771, false, true, 1599, "1771: _1556 -> (BNOT I8 _1554)", null, null, null, 0L, false, false, new int[]{1597}, null);
        CodeGenerator_x86simd.rulev[1777] = new Rule(1777, false, true, 1605, "1777: _1562 -> (BNOT I8 _1560)", null, null, null, 0L, false, false, new int[]{1603}, null);
        CodeGenerator_x86simd.rulev[1783] = new Rule(1783, false, true, 1611, "1783: _1568 -> (BNOT I8 _1566)", null, null, null, 0L, false, false, new int[]{1609}, null);
        CodeGenerator_x86simd.rulev[1789] = new Rule(1789, false, true, 1617, "1789: _1574 -> (BNOT I8 _1572)", null, null, null, 0L, false, false, new int[]{1615}, null);
        CodeGenerator_x86simd.rulev[1795] = new Rule(1795, false, true, 1623, "1795: _1580 -> (BNOT I8 _1578)", null, null, null, 0L, false, false, new int[]{1621}, null);
        CodeGenerator_x86simd.rulev[1801] = new Rule(1801, false, true, 1629, "1801: _1586 -> (BNOT I8 _1584)", null, null, null, 0L, false, false, new int[]{1627}, null);
        CodeGenerator_x86simd.rulev[1956] = new Rule(1956, false, true, 1779, "1956: _1736 -> (BNOT I8 _1734)", null, null, null, 0L, false, false, new int[]{1777}, null);
        CodeGenerator_x86simd.rulev[1962] = new Rule(1962, false, true, 1785, "1962: _1742 -> (BNOT I8 _1740)", null, null, null, 0L, false, false, new int[]{1783}, null);
        CodeGenerator_x86simd.rulev[1968] = new Rule(1968, false, true, 1791, "1968: _1748 -> (BNOT I8 _1746)", null, null, null, 0L, false, false, new int[]{1789}, null);
        CodeGenerator_x86simd.rulev[1974] = new Rule(1974, false, true, 1797, "1974: _1754 -> (BNOT I8 _1752)", null, null, null, 0L, false, false, new int[]{1795}, null);
        CodeGenerator_x86simd.rulev[1980] = new Rule(1980, false, true, 1803, "1980: _1760 -> (BNOT I8 _1758)", null, null, null, 0L, false, false, new int[]{1801}, null);
        CodeGenerator_x86simd.rulev[1986] = new Rule(1986, false, true, 1809, "1986: _1766 -> (BNOT I8 _1764)", null, null, null, 0L, false, false, new int[]{1807}, null);
        CodeGenerator_x86simd.rulev[1992] = new Rule(1992, false, true, 1815, "1992: _1772 -> (BNOT I8 _1770)", null, null, null, 0L, false, false, new int[]{1813}, null);
        CodeGenerator_x86simd.rulev[1998] = new Rule(1998, false, true, 1821, "1998: _1778 -> (BNOT I8 _1776)", null, null, null, 0L, false, false, new int[]{1819}, null);
        CodeGenerator_x86simd.rulev[2114] = new Rule(2114, false, true, 1931, "2114: _1888 -> (BNOT I8 _1886)", null, null, null, 0L, false, false, new int[]{1929}, null);
        CodeGenerator_x86simd.rulev[2120] = new Rule(2120, false, true, 1937, "2120: _1894 -> (BNOT I8 _1892)", null, null, null, 0L, false, false, new int[]{1935}, null);
        CodeGenerator_x86simd.rulev[2126] = new Rule(2126, false, true, 1943, "2126: _1900 -> (BNOT I8 _1898)", null, null, null, 0L, false, false, new int[]{1941}, null);
        CodeGenerator_x86simd.rulev[2132] = new Rule(2132, false, true, 1949, "2132: _1906 -> (BNOT I8 _1904)", null, null, null, 0L, false, false, new int[]{1947}, null);
        CodeGenerator_x86simd.rulev[2138] = new Rule(2138, false, true, 1955, "2138: _1912 -> (BNOT I8 _1910)", null, null, null, 0L, false, false, new int[]{1953}, null);
        CodeGenerator_x86simd.rulev[2144] = new Rule(2144, false, true, 1961, "2144: _1918 -> (BNOT I8 _1916)", null, null, null, 0L, false, false, new int[]{1959}, null);
        CodeGenerator_x86simd.rulev[2150] = new Rule(2150, false, true, 1967, "2150: _1924 -> (BNOT I8 _1922)", null, null, null, 0L, false, false, new int[]{1965}, null);
        CodeGenerator_x86simd.rulev[2156] = new Rule(2156, false, true, 1973, "2156: _1930 -> (BNOT I8 _1928)", null, null, null, 0L, false, false, new int[]{1971}, null);
        CodeGenerator_x86simd.rulev[2162] = new Rule(2162, false, true, 1979, "2162: _1936 -> (BNOT I8 _1934)", null, null, null, 0L, false, false, new int[]{1977}, null);
        CodeGenerator_x86simd.rulev[2168] = new Rule(2168, false, true, 1985, "2168: _1942 -> (BNOT I8 _1940)", null, null, null, 0L, false, false, new int[]{1983}, null);
        CodeGenerator_x86simd.rulev[2174] = new Rule(2174, false, true, 1991, "2174: _1948 -> (BNOT I8 _1946)", null, null, null, 0L, false, false, new int[]{1989}, null);
        CodeGenerator_x86simd.rulev[2180] = new Rule(2180, false, true, 1997, "2180: _1954 -> (BNOT I8 _1952)", null, null, null, 0L, false, false, new int[]{1995}, null);
        CodeGenerator_x86simd.rulev[2186] = new Rule(2186, false, true, 2003, "2186: _1960 -> (BNOT I8 _1958)", null, null, null, 0L, false, false, new int[]{2001}, null);
    }

    private static void rrinit2000() {
        CodeGenerator_x86simd.rulev[2192] = new Rule(2192, false, true, 2009, "2192: _1966 -> (BNOT I8 _1964)", null, null, null, 0L, false, false, new int[]{2007}, null);
        CodeGenerator_x86simd.rulev[2198] = new Rule(2198, false, true, 2015, "2198: _1972 -> (BNOT I8 _1970)", null, null, null, 0L, false, false, new int[]{2013}, null);
        CodeGenerator_x86simd.rulev[2204] = new Rule(2204, false, true, 2021, "2204: _1978 -> (BNOT I8 _1976)", null, null, null, 0L, false, false, new int[]{2019}, null);
        CodeGenerator_x86simd.rulev[2424] = new Rule(2424, false, true, 2235, "2424: _2192 -> (BNOT I8 _2190)", null, null, null, 0L, false, false, new int[]{2233}, null);
        CodeGenerator_x86simd.rulev[2430] = new Rule(2430, false, true, 2241, "2430: _2198 -> (BNOT I8 _2196)", null, null, null, 0L, false, false, new int[]{2239}, null);
        CodeGenerator_x86simd.rulev[2436] = new Rule(2436, false, true, 2247, "2436: _2204 -> (BNOT I8 _2202)", null, null, null, 0L, false, false, new int[]{2245}, null);
        CodeGenerator_x86simd.rulev[2442] = new Rule(2442, false, true, 2253, "2442: _2210 -> (BNOT I8 _2208)", null, null, null, 0L, false, false, new int[]{2251}, null);
        CodeGenerator_x86simd.rulev[2448] = new Rule(2448, false, true, 2259, "2448: _2216 -> (BNOT I8 _2214)", null, null, null, 0L, false, false, new int[]{2257}, null);
        CodeGenerator_x86simd.rulev[2454] = new Rule(2454, false, true, 2265, "2454: _2222 -> (BNOT I8 _2220)", null, null, null, 0L, false, false, new int[]{2263}, null);
        CodeGenerator_x86simd.rulev[2460] = new Rule(2460, false, true, 2271, "2460: _2228 -> (BNOT I8 _2226)", null, null, null, 0L, false, false, new int[]{2269}, null);
        CodeGenerator_x86simd.rulev[2466] = new Rule(2466, false, true, 2277, "2466: _2234 -> (BNOT I8 _2232)", null, null, null, 0L, false, false, new int[]{2275}, null);
        CodeGenerator_x86simd.rulev[2503] = new Rule(2503, false, true, 2311, "2503: _2268 -> (BNOT I8 _2266)", null, null, null, 0L, false, false, new int[]{2309}, null);
        CodeGenerator_x86simd.rulev[2509] = new Rule(2509, false, true, 2317, "2509: _2274 -> (BNOT I8 _2272)", null, null, null, 0L, false, false, new int[]{2315}, null);
        CodeGenerator_x86simd.rulev[2515] = new Rule(2515, false, true, 2323, "2515: _2280 -> (BNOT I8 _2278)", null, null, null, 0L, false, false, new int[]{2321}, null);
        CodeGenerator_x86simd.rulev[2521] = new Rule(2521, false, true, 2329, "2521: _2286 -> (BNOT I8 _2284)", null, null, null, 0L, false, false, new int[]{2327}, null);
        CodeGenerator_x86simd.rulev[2527] = new Rule(2527, false, true, 2335, "2527: _2292 -> (BNOT I8 _2290)", null, null, null, 0L, false, false, new int[]{2333}, null);
        CodeGenerator_x86simd.rulev[2533] = new Rule(2533, false, true, 2341, "2533: _2298 -> (BNOT I8 _2296)", null, null, null, 0L, false, false, new int[]{2339}, null);
        CodeGenerator_x86simd.rulev[2539] = new Rule(2539, false, true, 2347, "2539: _2304 -> (BNOT I8 _2302)", null, null, null, 0L, false, false, new int[]{2345}, null);
        CodeGenerator_x86simd.rulev[2545] = new Rule(2545, false, true, 2353, "2545: _2310 -> (BNOT I8 _2308)", null, null, null, 0L, false, false, new int[]{2351}, null);
        CodeGenerator_x86simd.rulev[2551] = new Rule(2551, false, true, 2359, "2551: _2316 -> (BNOT I8 _2314)", null, null, null, 0L, false, false, new int[]{2357}, null);
        CodeGenerator_x86simd.rulev[2557] = new Rule(2557, false, true, 2365, "2557: _2322 -> (BNOT I8 _2320)", null, null, null, 0L, false, false, new int[]{2363}, null);
        CodeGenerator_x86simd.rulev[2563] = new Rule(2563, false, true, 2371, "2563: _2328 -> (BNOT I8 _2326)", null, null, null, 0L, false, false, new int[]{2369}, null);
        CodeGenerator_x86simd.rulev[2569] = new Rule(2569, false, true, 2377, "2569: _2334 -> (BNOT I8 _2332)", null, null, null, 0L, false, false, new int[]{2375}, null);
        CodeGenerator_x86simd.rulev[2575] = new Rule(2575, false, true, 2383, "2575: _2340 -> (BNOT I8 _2338)", null, null, null, 0L, false, false, new int[]{2381}, null);
        CodeGenerator_x86simd.rulev[2581] = new Rule(2581, false, true, 2389, "2581: _2346 -> (BNOT I8 _2344)", null, null, null, 0L, false, false, new int[]{2387}, null);
        CodeGenerator_x86simd.rulev[2587] = new Rule(2587, false, true, 2395, "2587: _2352 -> (BNOT I8 _2350)", null, null, null, 0L, false, false, new int[]{2393}, null);
        CodeGenerator_x86simd.rulev[2593] = new Rule(2593, false, true, 2401, "2593: _2358 -> (BNOT I8 _2356)", null, null, null, 0L, false, false, new int[]{2399}, null);
        CodeGenerator_x86simd.rulev[2658] = new Rule(2658, false, true, 2463, "2658: _2420 -> (BNOT I8 _2418)", null, null, null, 0L, false, false, new int[]{2461}, null);
        CodeGenerator_x86simd.rulev[2664] = new Rule(2664, false, true, 2469, "2664: _2426 -> (BNOT I8 _2424)", null, null, null, 0L, false, false, new int[]{2467}, null);
        CodeGenerator_x86simd.rulev[2670] = new Rule(2670, false, true, 2475, "2670: _2432 -> (BNOT I8 _2430)", null, null, null, 0L, false, false, new int[]{2473}, null);
        CodeGenerator_x86simd.rulev[2676] = new Rule(2676, false, true, 2481, "2676: _2438 -> (BNOT I8 _2436)", null, null, null, 0L, false, false, new int[]{2479}, null);
        CodeGenerator_x86simd.rulev[2682] = new Rule(2682, false, true, 2487, "2682: _2444 -> (BNOT I8 _2442)", null, null, null, 0L, false, false, new int[]{2485}, null);
        CodeGenerator_x86simd.rulev[2688] = new Rule(2688, false, true, 2493, "2688: _2450 -> (BNOT I8 _2448)", null, null, null, 0L, false, false, new int[]{2491}, null);
        CodeGenerator_x86simd.rulev[2694] = new Rule(2694, false, true, 2499, "2694: _2456 -> (BNOT I8 _2454)", null, null, null, 0L, false, false, new int[]{2497}, null);
        CodeGenerator_x86simd.rulev[2700] = new Rule(2700, false, true, 2505, "2700: _2462 -> (BNOT I8 _2460)", null, null, null, 0L, false, false, new int[]{2503}, null);
        CodeGenerator_x86simd.rulev[2737] = new Rule(2737, false, true, 2539, "2737: _2496 -> (BNOT I8 _2494)", null, null, null, 0L, false, false, new int[]{2537}, null);
        CodeGenerator_x86simd.rulev[2743] = new Rule(2743, false, true, 2545, "2743: _2502 -> (BNOT I8 _2500)", null, null, null, 0L, false, false, new int[]{2543}, null);
        CodeGenerator_x86simd.rulev[2749] = new Rule(2749, false, true, 2551, "2749: _2508 -> (BNOT I8 _2506)", null, null, null, 0L, false, false, new int[]{2549}, null);
        CodeGenerator_x86simd.rulev[2755] = new Rule(2755, false, true, 2557, "2755: _2514 -> (BNOT I8 _2512)", null, null, null, 0L, false, false, new int[]{2555}, null);
        CodeGenerator_x86simd.rulev[2761] = new Rule(2761, false, true, 2563, "2761: _2520 -> (BNOT I8 _2518)", null, null, null, 0L, false, false, new int[]{2561}, null);
        CodeGenerator_x86simd.rulev[2767] = new Rule(2767, false, true, 2569, "2767: _2526 -> (BNOT I8 _2524)", null, null, null, 0L, false, false, new int[]{2567}, null);
        CodeGenerator_x86simd.rulev[2773] = new Rule(2773, false, true, 2575, "2773: _2532 -> (BNOT I8 _2530)", null, null, null, 0L, false, false, new int[]{2573}, null);
        CodeGenerator_x86simd.rulev[2779] = new Rule(2779, false, true, 2581, "2779: _2538 -> (BNOT I8 _2536)", null, null, null, 0L, false, false, new int[]{2579}, null);
        CodeGenerator_x86simd.rulev[2785] = new Rule(2785, false, true, 2587, "2785: _2544 -> (BNOT I8 _2542)", null, null, null, 0L, false, false, new int[]{2585}, null);
        CodeGenerator_x86simd.rulev[2791] = new Rule(2791, false, true, 2593, "2791: _2550 -> (BNOT I8 _2548)", null, null, null, 0L, false, false, new int[]{2591}, null);
        CodeGenerator_x86simd.rulev[2797] = new Rule(2797, false, true, 2599, "2797: _2556 -> (BNOT I8 _2554)", null, null, null, 0L, false, false, new int[]{2597}, null);
        CodeGenerator_x86simd.rulev[2803] = new Rule(2803, false, true, 2605, "2803: _2562 -> (BNOT I8 _2560)", null, null, null, 0L, false, false, new int[]{2603}, null);
        CodeGenerator_x86simd.rulev[2809] = new Rule(2809, false, true, 2611, "2809: _2568 -> (BNOT I8 _2566)", null, null, null, 0L, false, false, new int[]{2609}, null);
        CodeGenerator_x86simd.rulev[2815] = new Rule(2815, false, true, 2617, "2815: _2574 -> (BNOT I8 _2572)", null, null, null, 0L, false, false, new int[]{2615}, null);
        CodeGenerator_x86simd.rulev[2821] = new Rule(2821, false, true, 2623, "2821: _2580 -> (BNOT I8 _2578)", null, null, null, 0L, false, false, new int[]{2621}, null);
        CodeGenerator_x86simd.rulev[2827] = new Rule(2827, false, true, 2629, "2827: _2586 -> (BNOT I8 _2584)", null, null, null, 0L, false, false, new int[]{2627}, null);
        CodeGenerator_x86simd.rulev[3130] = new Rule(3130, false, true, 2905, "3130: _2862 -> (BNOT I8 _101)", null, null, null, 0L, false, false, new int[]{144}, null);
        CodeGenerator_x86simd.rulev[3133] = new Rule(3133, false, true, 2908, "3133: _2865 -> (BNOT I8 _103)", null, null, null, 0L, false, false, new int[]{146}, null);
        CodeGenerator_x86simd.rulev[3136] = new Rule(3136, false, true, 2911, "3136: _2868 -> (BNOT I8 _105)", null, null, null, 0L, false, false, new int[]{148}, null);
        CodeGenerator_x86simd.rulev[3139] = new Rule(3139, false, true, 2914, "3139: _2871 -> (BNOT I8 _107)", null, null, null, 0L, false, false, new int[]{150}, null);
        CodeGenerator_x86simd.rulev[3142] = new Rule(3142, false, true, 2917, "3142: _2874 -> (BNOT I8 _111)", null, null, null, 0L, false, false, new int[]{154}, null);
        CodeGenerator_x86simd.rulev[3145] = new Rule(3145, false, true, 2920, "3145: _2877 -> (BNOT I8 _113)", null, null, null, 0L, false, false, new int[]{156}, null);
        CodeGenerator_x86simd.rulev[3148] = new Rule(3148, false, true, 2923, "3148: _2880 -> (BNOT I8 _115)", null, null, null, 0L, false, false, new int[]{158}, null);
        CodeGenerator_x86simd.rulev[3172] = new Rule(3172, false, true, 2944, "3172: _2901 -> (BNOT I8 _7)", null, null, null, 0L, false, false, new int[]{50}, null);
        CodeGenerator_x86simd.rulev[3175] = new Rule(3175, false, true, 2947, "3175: _2904 -> (BNOT I8 _9)", null, null, null, 0L, false, false, new int[]{52}, null);
        CodeGenerator_x86simd.rulev[3178] = new Rule(3178, false, true, 2950, "3178: _2907 -> (BNOT I8 _11)", null, null, null, 0L, false, false, new int[]{54}, null);
        CodeGenerator_x86simd.rulev[3181] = new Rule(3181, false, true, 2953, "3181: _2910 -> (BNOT I8 _13)", null, null, null, 0L, false, false, new int[]{56}, null);
        CodeGenerator_x86simd.rulev[3184] = new Rule(3184, false, true, 2956, "3184: _2913 -> (BNOT I8 _15)", null, null, null, 0L, false, false, new int[]{58}, null);
        CodeGenerator_x86simd.rulev[3187] = new Rule(3187, false, true, 2959, "3187: _2916 -> (BNOT I8 _18)", null, null, null, 0L, false, false, new int[]{61}, null);
        CodeGenerator_x86simd.rulev[3190] = new Rule(3190, false, true, 2962, "3190: _2919 -> (BNOT I8 _21)", null, null, null, 0L, false, false, new int[]{64}, null);
        CodeGenerator_x86simd.rulev[3193] = new Rule(3193, false, true, 2965, "3193: _2922 -> (BNOT I8 _24)", null, null, null, 0L, false, false, new int[]{67}, null);
        CodeGenerator_x86simd.rulev[3196] = new Rule(3196, false, true, 2968, "3196: _2925 -> (BNOT I8 _26)", null, null, null, 0L, false, false, new int[]{69}, null);
        CodeGenerator_x86simd.rulev[3199] = new Rule(3199, false, true, 2971, "3199: _2928 -> (BNOT I8 _29)", null, null, null, 0L, false, false, new int[]{72}, null);
        CodeGenerator_x86simd.rulev[3202] = new Rule(3202, false, true, 2974, "3202: _2931 -> (BNOT I8 _32)", null, null, null, 0L, false, false, new int[]{75}, null);
        CodeGenerator_x86simd.rulev[3205] = new Rule(3205, false, true, 2977, "3205: _2934 -> (BNOT I8 _35)", null, null, null, 0L, false, false, new int[]{78}, null);
        CodeGenerator_x86simd.rulev[3208] = new Rule(3208, false, true, 2980, "3208: _2937 -> (BNOT I8 _38)", null, null, null, 0L, false, false, new int[]{81}, null);
        CodeGenerator_x86simd.rulev[3211] = new Rule(3211, false, true, 2983, "3211: _2940 -> (BNOT I8 _41)", null, null, null, 0L, false, false, new int[]{84}, null);
        CodeGenerator_x86simd.rulev[3214] = new Rule(3214, false, true, 2986, "3214: _2943 -> (BNOT I8 _44)", null, null, null, 0L, false, false, new int[]{87}, null);
        CodeGenerator_x86simd.rulev[3217] = new Rule(3217, false, true, 2989, "3217: _2946 -> (BNOT I8 _47)", null, null, null, 0L, false, false, new int[]{90}, null);
        CodeGenerator_x86simd.rulev[3733] = new Rule(3733, false, true, 3464, "3733: _3421 -> (BNOT I8 _109)", null, null, null, 0L, false, false, new int[]{152}, null);
        CodeGenerator_x86simd.rulev[4031] = new Rule(4031, false, false, 7, "4031: regb -> (BNOT I8 regb)", ImList.list(ImList.list("notb", "$0")), null, null, 2L, false, false, new int[]{7}, new String[]{"*reg-I8*", "*reg-I8*"});
        CodeGenerator_x86simd.rulev[1292] = new Rule(1292, false, true, 1131, "1292: _1088 -> (BNOT I16 _1086)", null, null, null, 0L, false, false, new int[]{1129}, null);
        CodeGenerator_x86simd.rulev[1298] = new Rule(1298, false, true, 1137, "1298: _1094 -> (BNOT I16 _1092)", null, null, null, 0L, false, false, new int[]{1135}, null);
        CodeGenerator_x86simd.rulev[1304] = new Rule(1304, false, true, 1143, "1304: _1100 -> (BNOT I16 _1098)", null, null, null, 0L, false, false, new int[]{1141}, null);
        CodeGenerator_x86simd.rulev[1310] = new Rule(1310, false, true, 1149, "1310: _1106 -> (BNOT I16 _1104)", null, null, null, 0L, false, false, new int[]{1147}, null);
        CodeGenerator_x86simd.rulev[1317] = new Rule(1317, false, true, 1155, "1317: _1112 -> (BNOT I16 _1110)", null, null, null, 0L, false, false, new int[]{1153}, null);
        CodeGenerator_x86simd.rulev[1323] = new Rule(1323, false, true, 1161, "1323: _1118 -> (BNOT I16 _1116)", null, null, null, 0L, false, false, new int[]{1159}, null);
        CodeGenerator_x86simd.rulev[1329] = new Rule(1329, false, true, 1167, "1329: _1124 -> (BNOT I16 _1122)", null, null, null, 0L, false, false, new int[]{1165}, null);
        CodeGenerator_x86simd.rulev[1335] = new Rule(1335, false, true, 1173, "1335: _1130 -> (BNOT I16 _1128)", null, null, null, 0L, false, false, new int[]{1171}, null);
        CodeGenerator_x86simd.rulev[1342] = new Rule(1342, false, true, 1179, "1342: _1136 -> (BNOT I16 _1134)", null, null, null, 0L, false, false, new int[]{1177}, null);
        CodeGenerator_x86simd.rulev[1348] = new Rule(1348, false, true, 1185, "1348: _1142 -> (BNOT I16 _1140)", null, null, null, 0L, false, false, new int[]{1183}, null);
        CodeGenerator_x86simd.rulev[1354] = new Rule(1354, false, true, 1191, "1354: _1148 -> (BNOT I16 _1146)", null, null, null, 0L, false, false, new int[]{1189}, null);
        CodeGenerator_x86simd.rulev[1360] = new Rule(1360, false, true, 1197, "1360: _1154 -> (BNOT I16 _1152)", null, null, null, 0L, false, false, new int[]{1195}, null);
        CodeGenerator_x86simd.rulev[1366] = new Rule(1366, false, true, 1203, "1366: _1160 -> (BNOT I16 _1158)", null, null, null, 0L, false, false, new int[]{1201}, null);
        CodeGenerator_x86simd.rulev[1372] = new Rule(1372, false, true, 1209, "1372: _1166 -> (BNOT I16 _1164)", null, null, null, 0L, false, false, new int[]{1207}, null);
        CodeGenerator_x86simd.rulev[1378] = new Rule(1378, false, true, 1215, "1378: _1172 -> (BNOT I16 _1170)", null, null, null, 0L, false, false, new int[]{1213}, null);
        CodeGenerator_x86simd.rulev[1384] = new Rule(1384, false, true, 1221, "1384: _1178 -> (BNOT I16 _1176)", null, null, null, 0L, false, false, new int[]{1219}, null);
        CodeGenerator_x86simd.rulev[1391] = new Rule(1391, false, true, 1227, "1391: _1184 -> (BNOT I16 _1182)", null, null, null, 0L, false, false, new int[]{1225}, null);
        CodeGenerator_x86simd.rulev[1397] = new Rule(1397, false, true, 1233, "1397: _1190 -> (BNOT I16 _1188)", null, null, null, 0L, false, false, new int[]{1231}, null);
        CodeGenerator_x86simd.rulev[1403] = new Rule(1403, false, true, 1239, "1403: _1196 -> (BNOT I16 _1194)", null, null, null, 0L, false, false, new int[]{1237}, null);
        CodeGenerator_x86simd.rulev[1409] = new Rule(1409, false, true, 1245, "1409: _1202 -> (BNOT I16 _1200)", null, null, null, 0L, false, false, new int[]{1243}, null);
        CodeGenerator_x86simd.rulev[1415] = new Rule(1415, false, true, 1251, "1415: _1208 -> (BNOT I16 _1206)", null, null, null, 0L, false, false, new int[]{1249}, null);
        CodeGenerator_x86simd.rulev[1421] = new Rule(1421, false, true, 1257, "1421: _1214 -> (BNOT I16 _1212)", null, null, null, 0L, false, false, new int[]{1255}, null);
        CodeGenerator_x86simd.rulev[1427] = new Rule(1427, false, true, 1263, "1427: _1220 -> (BNOT I16 _1218)", null, null, null, 0L, false, false, new int[]{1261}, null);
        CodeGenerator_x86simd.rulev[1433] = new Rule(1433, false, true, 1269, "1433: _1226 -> (BNOT I16 _1224)", null, null, null, 0L, false, false, new int[]{1267}, null);
    }

    private static void rrinit2100() {
        CodeGenerator_x86simd.rulev[1538] = new Rule(1538, false, true, 1371, "1538: _1328 -> (BNOT I16 _1326)", null, null, null, 0L, false, false, new int[]{1369}, null);
        CodeGenerator_x86simd.rulev[1544] = new Rule(1544, false, true, 1377, "1544: _1334 -> (BNOT I16 _1332)", null, null, null, 0L, false, false, new int[]{1375}, null);
        CodeGenerator_x86simd.rulev[1550] = new Rule(1550, false, true, 1383, "1550: _1340 -> (BNOT I16 _1338)", null, null, null, 0L, false, false, new int[]{1381}, null);
        CodeGenerator_x86simd.rulev[1556] = new Rule(1556, false, true, 1389, "1556: _1346 -> (BNOT I16 _1344)", null, null, null, 0L, false, false, new int[]{1387}, null);
        CodeGenerator_x86simd.rulev[1563] = new Rule(1563, false, true, 1395, "1563: _1352 -> (BNOT I16 _1350)", null, null, null, 0L, false, false, new int[]{1393}, null);
        CodeGenerator_x86simd.rulev[1569] = new Rule(1569, false, true, 1401, "1569: _1358 -> (BNOT I16 _1356)", null, null, null, 0L, false, false, new int[]{1399}, null);
        CodeGenerator_x86simd.rulev[1575] = new Rule(1575, false, true, 1407, "1575: _1364 -> (BNOT I16 _1362)", null, null, null, 0L, false, false, new int[]{1405}, null);
        CodeGenerator_x86simd.rulev[1581] = new Rule(1581, false, true, 1413, "1581: _1370 -> (BNOT I16 _1368)", null, null, null, 0L, false, false, new int[]{1411}, null);
        CodeGenerator_x86simd.rulev[1808] = new Rule(1808, false, true, 1635, "1808: _1592 -> (BNOT I16 _1590)", null, null, null, 0L, false, false, new int[]{1633}, null);
        CodeGenerator_x86simd.rulev[1814] = new Rule(1814, false, true, 1641, "1814: _1598 -> (BNOT I16 _1596)", null, null, null, 0L, false, false, new int[]{1639}, null);
        CodeGenerator_x86simd.rulev[1820] = new Rule(1820, false, true, 1647, "1820: _1604 -> (BNOT I16 _1602)", null, null, null, 0L, false, false, new int[]{1645}, null);
        CodeGenerator_x86simd.rulev[1826] = new Rule(1826, false, true, 1653, "1826: _1610 -> (BNOT I16 _1608)", null, null, null, 0L, false, false, new int[]{1651}, null);
        CodeGenerator_x86simd.rulev[1832] = new Rule(1832, false, true, 1659, "1832: _1616 -> (BNOT I16 _1614)", null, null, null, 0L, false, false, new int[]{1657}, null);
        CodeGenerator_x86simd.rulev[1838] = new Rule(1838, false, true, 1665, "1838: _1622 -> (BNOT I16 _1620)", null, null, null, 0L, false, false, new int[]{1663}, null);
        CodeGenerator_x86simd.rulev[1844] = new Rule(1844, false, true, 1671, "1844: _1628 -> (BNOT I16 _1626)", null, null, null, 0L, false, false, new int[]{1669}, null);
        CodeGenerator_x86simd.rulev[1850] = new Rule(1850, false, true, 1677, "1850: _1634 -> (BNOT I16 _1632)", null, null, null, 0L, false, false, new int[]{1675}, null);
        CodeGenerator_x86simd.rulev[1857] = new Rule(1857, false, true, 1683, "1857: _1640 -> (BNOT I16 _1638)", null, null, null, 0L, false, false, new int[]{1681}, null);
        CodeGenerator_x86simd.rulev[1863] = new Rule(1863, false, true, 1689, "1863: _1646 -> (BNOT I16 _1644)", null, null, null, 0L, false, false, new int[]{1687}, null);
        CodeGenerator_x86simd.rulev[1869] = new Rule(1869, false, true, 1695, "1869: _1652 -> (BNOT I16 _1650)", null, null, null, 0L, false, false, new int[]{1693}, null);
        CodeGenerator_x86simd.rulev[1875] = new Rule(1875, false, true, 1701, "1875: _1658 -> (BNOT I16 _1656)", null, null, null, 0L, false, false, new int[]{1699}, null);
        CodeGenerator_x86simd.rulev[1881] = new Rule(1881, false, true, 1707, "1881: _1664 -> (BNOT I16 _1662)", null, null, null, 0L, false, false, new int[]{1705}, null);
        CodeGenerator_x86simd.rulev[1887] = new Rule(1887, false, true, 1713, "1887: _1670 -> (BNOT I16 _1668)", null, null, null, 0L, false, false, new int[]{1711}, null);
        CodeGenerator_x86simd.rulev[1893] = new Rule(1893, false, true, 1719, "1893: _1676 -> (BNOT I16 _1674)", null, null, null, 0L, false, false, new int[]{1717}, null);
        CodeGenerator_x86simd.rulev[1899] = new Rule(1899, false, true, 1725, "1899: _1682 -> (BNOT I16 _1680)", null, null, null, 0L, false, false, new int[]{1723}, null);
        CodeGenerator_x86simd.rulev[2038] = new Rule(2038, false, true, 1859, "2038: _1816 -> (BNOT I16 _1814)", null, null, null, 0L, false, false, new int[]{1857}, null);
        CodeGenerator_x86simd.rulev[2044] = new Rule(2044, false, true, 1865, "2044: _1822 -> (BNOT I16 _1820)", null, null, null, 0L, false, false, new int[]{1863}, null);
        CodeGenerator_x86simd.rulev[2050] = new Rule(2050, false, true, 1871, "2050: _1828 -> (BNOT I16 _1826)", null, null, null, 0L, false, false, new int[]{1869}, null);
        CodeGenerator_x86simd.rulev[2056] = new Rule(2056, false, true, 1877, "2056: _1834 -> (BNOT I16 _1832)", null, null, null, 0L, false, false, new int[]{1875}, null);
        CodeGenerator_x86simd.rulev[2063] = new Rule(2063, false, true, 1883, "2063: _1840 -> (BNOT I16 _1838)", null, null, null, 0L, false, false, new int[]{1881}, null);
        CodeGenerator_x86simd.rulev[2069] = new Rule(2069, false, true, 1889, "2069: _1846 -> (BNOT I16 _1844)", null, null, null, 0L, false, false, new int[]{1887}, null);
        CodeGenerator_x86simd.rulev[2075] = new Rule(2075, false, true, 1895, "2075: _1852 -> (BNOT I16 _1850)", null, null, null, 0L, false, false, new int[]{1893}, null);
        CodeGenerator_x86simd.rulev[2081] = new Rule(2081, false, true, 1901, "2081: _1858 -> (BNOT I16 _1856)", null, null, null, 0L, false, false, new int[]{1899}, null);
        CodeGenerator_x86simd.rulev[2276] = new Rule(2276, false, true, 2091, "2276: _2048 -> (BNOT I16 _2046)", null, null, null, 0L, false, false, new int[]{2089}, null);
        CodeGenerator_x86simd.rulev[2282] = new Rule(2282, false, true, 2097, "2282: _2054 -> (BNOT I16 _2052)", null, null, null, 0L, false, false, new int[]{2095}, null);
        CodeGenerator_x86simd.rulev[2288] = new Rule(2288, false, true, 2103, "2288: _2060 -> (BNOT I16 _2058)", null, null, null, 0L, false, false, new int[]{2101}, null);
        CodeGenerator_x86simd.rulev[2294] = new Rule(2294, false, true, 2109, "2294: _2066 -> (BNOT I16 _2064)", null, null, null, 0L, false, false, new int[]{2107}, null);
        CodeGenerator_x86simd.rulev[2300] = new Rule(2300, false, true, 2115, "2300: _2072 -> (BNOT I16 _2070)", null, null, null, 0L, false, false, new int[]{2113}, null);
        CodeGenerator_x86simd.rulev[2306] = new Rule(2306, false, true, 2121, "2306: _2078 -> (BNOT I16 _2076)", null, null, null, 0L, false, false, new int[]{2119}, null);
        CodeGenerator_x86simd.rulev[2312] = new Rule(2312, false, true, 2127, "2312: _2084 -> (BNOT I16 _2082)", null, null, null, 0L, false, false, new int[]{2125}, null);
        CodeGenerator_x86simd.rulev[2318] = new Rule(2318, false, true, 2133, "2318: _2090 -> (BNOT I16 _2088)", null, null, null, 0L, false, false, new int[]{2131}, null);
        CodeGenerator_x86simd.rulev[2325] = new Rule(2325, false, true, 2139, "2325: _2096 -> (BNOT I16 _2094)", null, null, null, 0L, false, false, new int[]{2137}, null);
        CodeGenerator_x86simd.rulev[2331] = new Rule(2331, false, true, 2145, "2331: _2102 -> (BNOT I16 _2100)", null, null, null, 0L, false, false, new int[]{2143}, null);
        CodeGenerator_x86simd.rulev[2337] = new Rule(2337, false, true, 2151, "2337: _2108 -> (BNOT I16 _2106)", null, null, null, 0L, false, false, new int[]{2149}, null);
        CodeGenerator_x86simd.rulev[2343] = new Rule(2343, false, true, 2157, "2343: _2114 -> (BNOT I16 _2112)", null, null, null, 0L, false, false, new int[]{2155}, null);
        CodeGenerator_x86simd.rulev[2349] = new Rule(2349, false, true, 2163, "2349: _2120 -> (BNOT I16 _2118)", null, null, null, 0L, false, false, new int[]{2161}, null);
        CodeGenerator_x86simd.rulev[2355] = new Rule(2355, false, true, 2169, "2355: _2126 -> (BNOT I16 _2124)", null, null, null, 0L, false, false, new int[]{2167}, null);
        CodeGenerator_x86simd.rulev[2361] = new Rule(2361, false, true, 2175, "2361: _2132 -> (BNOT I16 _2130)", null, null, null, 0L, false, false, new int[]{2173}, null);
        CodeGenerator_x86simd.rulev[2367] = new Rule(2367, false, true, 2181, "2367: _2138 -> (BNOT I16 _2136)", null, null, null, 0L, false, false, new int[]{2179}, null);
        CodeGenerator_x86simd.rulev[3152] = new Rule(3152, false, true, 2926, "3152: _2883 -> (BNOT I16 _117)", null, null, null, 0L, false, false, new int[]{160}, null);
        CodeGenerator_x86simd.rulev[3155] = new Rule(3155, false, true, 2929, "3155: _2886 -> (BNOT I16 _119)", null, null, null, 0L, false, false, new int[]{162}, null);
        CodeGenerator_x86simd.rulev[3158] = new Rule(3158, false, true, 2932, "3158: _2889 -> (BNOT I16 _121)", null, null, null, 0L, false, false, new int[]{164}, null);
        CodeGenerator_x86simd.rulev[3161] = new Rule(3161, false, true, 2935, "3161: _2892 -> (BNOT I16 _123)", null, null, null, 0L, false, false, new int[]{166}, null);
        CodeGenerator_x86simd.rulev[3221] = new Rule(3221, false, true, 2992, "3221: _2949 -> (BNOT I16 _49)", null, null, null, 0L, false, false, new int[]{92}, null);
        CodeGenerator_x86simd.rulev[3224] = new Rule(3224, false, true, 2995, "3224: _2952 -> (BNOT I16 _51)", null, null, null, 0L, false, false, new int[]{94}, null);
        CodeGenerator_x86simd.rulev[3227] = new Rule(3227, false, true, 2998, "3227: _2955 -> (BNOT I16 _53)", null, null, null, 0L, false, false, new int[]{96}, null);
        CodeGenerator_x86simd.rulev[3230] = new Rule(3230, false, true, 3001, "3230: _2958 -> (BNOT I16 _55)", null, null, null, 0L, false, false, new int[]{98}, null);
        CodeGenerator_x86simd.rulev[3233] = new Rule(3233, false, true, 3004, "3233: _2961 -> (BNOT I16 _57)", null, null, null, 0L, false, false, new int[]{100}, null);
        CodeGenerator_x86simd.rulev[3236] = new Rule(3236, false, true, 3007, "3236: _2964 -> (BNOT I16 _59)", null, null, null, 0L, false, false, new int[]{102}, null);
        CodeGenerator_x86simd.rulev[3239] = new Rule(3239, false, true, 3010, "3239: _2967 -> (BNOT I16 _61)", null, null, null, 0L, false, false, new int[]{104}, null);
        CodeGenerator_x86simd.rulev[3242] = new Rule(3242, false, true, 3013, "3242: _2970 -> (BNOT I16 _63)", null, null, null, 0L, false, false, new int[]{106}, null);
        CodeGenerator_x86simd.rulev[4033] = new Rule(4033, false, false, 6, "4033: regw -> (BNOT I16 regw)", ImList.list(ImList.list("notw", "$0")), null, null, 2L, false, false, new int[]{6}, new String[]{"*reg-I16*", "*reg-I16*"});
        CodeGenerator_x86simd.rulev[1588] = new Rule(1588, false, true, 1419, "1588: _1376 -> (BNOT I32 _1374)", null, null, null, 0L, false, false, new int[]{1417}, null);
        CodeGenerator_x86simd.rulev[1594] = new Rule(1594, false, true, 1425, "1594: _1382 -> (BNOT I32 _1380)", null, null, null, 0L, false, false, new int[]{1423}, null);
        CodeGenerator_x86simd.rulev[1601] = new Rule(1601, false, true, 1431, "1601: _1388 -> (BNOT I32 _1386)", null, null, null, 0L, false, false, new int[]{1429}, null);
        CodeGenerator_x86simd.rulev[1607] = new Rule(1607, false, true, 1437, "1607: _1394 -> (BNOT I32 _1392)", null, null, null, 0L, false, false, new int[]{1435}, null);
        CodeGenerator_x86simd.rulev[1906] = new Rule(1906, false, true, 1731, "1906: _1688 -> (BNOT I32 _1686)", null, null, null, 0L, false, false, new int[]{1729}, null);
        CodeGenerator_x86simd.rulev[1912] = new Rule(1912, false, true, 1737, "1912: _1694 -> (BNOT I32 _1692)", null, null, null, 0L, false, false, new int[]{1735}, null);
        CodeGenerator_x86simd.rulev[1918] = new Rule(1918, false, true, 1743, "1918: _1700 -> (BNOT I32 _1698)", null, null, null, 0L, false, false, new int[]{1741}, null);
        CodeGenerator_x86simd.rulev[1924] = new Rule(1924, false, true, 1749, "1924: _1706 -> (BNOT I32 _1704)", null, null, null, 0L, false, false, new int[]{1747}, null);
        CodeGenerator_x86simd.rulev[1931] = new Rule(1931, false, true, 1755, "1931: _1712 -> (BNOT I32 _1710)", null, null, null, 0L, false, false, new int[]{1753}, null);
        CodeGenerator_x86simd.rulev[1937] = new Rule(1937, false, true, 1761, "1937: _1718 -> (BNOT I32 _1716)", null, null, null, 0L, false, false, new int[]{1759}, null);
        CodeGenerator_x86simd.rulev[1943] = new Rule(1943, false, true, 1767, "1943: _1724 -> (BNOT I32 _1722)", null, null, null, 0L, false, false, new int[]{1765}, null);
        CodeGenerator_x86simd.rulev[1949] = new Rule(1949, false, true, 1773, "1949: _1730 -> (BNOT I32 _1728)", null, null, null, 0L, false, false, new int[]{1771}, null);
        CodeGenerator_x86simd.rulev[2088] = new Rule(2088, false, true, 1907, "2088: _1864 -> (BNOT I32 _1862)", null, null, null, 0L, false, false, new int[]{1905}, null);
        CodeGenerator_x86simd.rulev[2094] = new Rule(2094, false, true, 1913, "2094: _1870 -> (BNOT I32 _1868)", null, null, null, 0L, false, false, new int[]{1911}, null);
        CodeGenerator_x86simd.rulev[2101] = new Rule(2101, false, true, 1919, "2101: _1876 -> (BNOT I32 _1874)", null, null, null, 0L, false, false, new int[]{1917}, null);
        CodeGenerator_x86simd.rulev[2107] = new Rule(2107, false, true, 1925, "2107: _1882 -> (BNOT I32 _1880)", null, null, null, 0L, false, false, new int[]{1923}, null);
        CodeGenerator_x86simd.rulev[2374] = new Rule(2374, false, true, 2187, "2374: _2144 -> (BNOT I32 _2142)", null, null, null, 0L, false, false, new int[]{2185}, null);
        CodeGenerator_x86simd.rulev[2380] = new Rule(2380, false, true, 2193, "2380: _2150 -> (BNOT I32 _2148)", null, null, null, 0L, false, false, new int[]{2191}, null);
        CodeGenerator_x86simd.rulev[2386] = new Rule(2386, false, true, 2199, "2386: _2156 -> (BNOT I32 _2154)", null, null, null, 0L, false, false, new int[]{2197}, null);
        CodeGenerator_x86simd.rulev[2392] = new Rule(2392, false, true, 2205, "2392: _2162 -> (BNOT I32 _2160)", null, null, null, 0L, false, false, new int[]{2203}, null);
        CodeGenerator_x86simd.rulev[2399] = new Rule(2399, false, true, 2211, "2399: _2168 -> (BNOT I32 _2166)", null, null, null, 0L, false, false, new int[]{2209}, null);
        CodeGenerator_x86simd.rulev[2405] = new Rule(2405, false, true, 2217, "2405: _2174 -> (BNOT I32 _2172)", null, null, null, 0L, false, false, new int[]{2215}, null);
        CodeGenerator_x86simd.rulev[2411] = new Rule(2411, false, true, 2223, "2411: _2180 -> (BNOT I32 _2178)", null, null, null, 0L, false, false, new int[]{2221}, null);
        CodeGenerator_x86simd.rulev[2417] = new Rule(2417, false, true, 2229, "2417: _2186 -> (BNOT I32 _2184)", null, null, null, 0L, false, false, new int[]{2227}, null);
        CodeGenerator_x86simd.rulev[2490] = new Rule(2490, false, true, 2299, "2490: _2256 -> (BNOT I32 _2254)", null, null, null, 0L, false, false, new int[]{2297}, null);
        CodeGenerator_x86simd.rulev[2496] = new Rule(2496, false, true, 2305, "2496: _2262 -> (BNOT I32 _2260)", null, null, null, 0L, false, false, new int[]{2303}, null);
        CodeGenerator_x86simd.rulev[2633] = new Rule(2633, false, true, 2439, "2633: _2396 -> (BNOT I32 _2394)", null, null, null, 0L, false, false, new int[]{2437}, null);
        CodeGenerator_x86simd.rulev[2639] = new Rule(2639, false, true, 2445, "2639: _2402 -> (BNOT I32 _2400)", null, null, null, 0L, false, false, new int[]{2443}, null);
        CodeGenerator_x86simd.rulev[2645] = new Rule(2645, false, true, 2451, "2645: _2408 -> (BNOT I32 _2406)", null, null, null, 0L, false, false, new int[]{2449}, null);
        CodeGenerator_x86simd.rulev[2651] = new Rule(2651, false, true, 2457, "2651: _2414 -> (BNOT I32 _2412)", null, null, null, 0L, false, false, new int[]{2455}, null);
        CodeGenerator_x86simd.rulev[2724] = new Rule(2724, false, true, 2527, "2724: _2484 -> (BNOT I32 _2482)", null, null, null, 0L, false, false, new int[]{2525}, null);
        CodeGenerator_x86simd.rulev[2730] = new Rule(2730, false, true, 2533, "2730: _2490 -> (BNOT I32 _2488)", null, null, null, 0L, false, false, new int[]{2531}, null);
        CodeGenerator_x86simd.rulev[2867] = new Rule(2867, false, true, 2667, "2867: _2624 -> (BNOT I32 _2622)", null, null, null, 0L, false, false, new int[]{2665}, null);
        CodeGenerator_x86simd.rulev[2873] = new Rule(2873, false, true, 2673, "2873: _2630 -> (BNOT I32 _2628)", null, null, null, 0L, false, false, new int[]{2671}, null);
        CodeGenerator_x86simd.rulev[2879] = new Rule(2879, false, true, 2679, "2879: _2636 -> (BNOT I32 _2634)", null, null, null, 0L, false, false, new int[]{2677}, null);
        CodeGenerator_x86simd.rulev[2885] = new Rule(2885, false, true, 2685, "2885: _2642 -> (BNOT I32 _2640)", null, null, null, 0L, false, false, new int[]{2683}, null);
        CodeGenerator_x86simd.rulev[3165] = new Rule(3165, false, true, 2938, "3165: _2895 -> (BNOT I32 _125)", null, null, null, 0L, false, false, new int[]{168}, null);
        CodeGenerator_x86simd.rulev[3168] = new Rule(3168, false, true, 2941, "3168: _2898 -> (BNOT I32 _127)", null, null, null, 0L, false, false, new int[]{170}, null);
        CodeGenerator_x86simd.rulev[3246] = new Rule(3246, false, true, 3016, "3246: _2973 -> (BNOT I32 _65)", null, null, null, 0L, false, false, new int[]{108}, null);
    }

    private static void rrinit2200() {
        CodeGenerator_x86simd.rulev[3249] = new Rule(3249, false, true, 3019, "3249: _2976 -> (BNOT I32 _67)", null, null, null, 0L, false, false, new int[]{110}, null);
        CodeGenerator_x86simd.rulev[3252] = new Rule(3252, false, true, 3022, "3252: _2979 -> (BNOT I32 _69)", null, null, null, 0L, false, false, new int[]{112}, null);
        CodeGenerator_x86simd.rulev[3255] = new Rule(3255, false, true, 3025, "3255: _2982 -> (BNOT I32 _71)", null, null, null, 0L, false, false, new int[]{114}, null);
        CodeGenerator_x86simd.rulev[4035] = new Rule(4035, false, false, 4, "4035: regl -> (BNOT I32 regl)", ImList.list(ImList.list("notl", "$0")), null, null, 2L, false, false, new int[]{4}, new String[]{"*reg-I32*", "*reg-I32*"});
        CodeGenerator_x86simd.rulev[3980] = new Rule(3980, false, false, 3, "3980: regq -> (BNOT I64 regq)", ImList.list(ImList.list("notl", ImList.list("qlow", "$0")), ImList.list("notl", ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{3}, new String[]{"*reg-I64*", "*reg-I64*"});
        CodeGenerator_x86simd.rulev[4036] = new Rule(4036, false, false, 7, "4036: regb -> (LSHS I8 regb con)", ImList.list(ImList.list("salb", ImList.list("imm", "$2"), "$0")), null, null, 2L, false, false, new int[]{7, 19}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[4045] = new Rule(4045, false, false, 7, "4045: regb -> (LSHS I8 regb shfct)", ImList.list(ImList.list("salb", "%cl", "$0")), null, null, 2L, false, false, new int[]{7, 3644}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[3050] = new Rule(3050, false, true, 2833, "3050: _2790 -> (LSHS I16 _117 regw)", null, null, null, 0L, false, false, new int[]{160, 6}, null);
        CodeGenerator_x86simd.rulev[3052] = new Rule(3052, false, true, 2835, "3052: _2792 -> (LSHS I16 _119 regw)", null, null, null, 0L, false, false, new int[]{162, 6}, null);
        CodeGenerator_x86simd.rulev[3054] = new Rule(3054, false, true, 2837, "3054: _2794 -> (LSHS I16 _121 regw)", null, null, null, 0L, false, false, new int[]{164, 6}, null);
        CodeGenerator_x86simd.rulev[3056] = new Rule(3056, false, true, 2839, "3056: _2796 -> (LSHS I16 _123 regw)", null, null, null, 0L, false, false, new int[]{166, 6}, null);
        CodeGenerator_x86simd.rulev[3059] = new Rule(3059, false, true, 2841, "3059: _2798 -> (LSHS I16 _49 regw)", null, null, null, 0L, false, false, new int[]{92, 6}, null);
        CodeGenerator_x86simd.rulev[3061] = new Rule(3061, false, true, 2843, "3061: _2800 -> (LSHS I16 _51 regw)", null, null, null, 0L, false, false, new int[]{94, 6}, null);
        CodeGenerator_x86simd.rulev[3063] = new Rule(3063, false, true, 2845, "3063: _2802 -> (LSHS I16 _53 regw)", null, null, null, 0L, false, false, new int[]{96, 6}, null);
        CodeGenerator_x86simd.rulev[3065] = new Rule(3065, false, true, 2847, "3065: _2804 -> (LSHS I16 _55 regw)", null, null, null, 0L, false, false, new int[]{98, 6}, null);
        CodeGenerator_x86simd.rulev[3067] = new Rule(3067, false, true, 2849, "3067: _2806 -> (LSHS I16 _57 regw)", null, null, null, 0L, false, false, new int[]{100, 6}, null);
        CodeGenerator_x86simd.rulev[3069] = new Rule(3069, false, true, 2851, "3069: _2808 -> (LSHS I16 _59 regw)", null, null, null, 0L, false, false, new int[]{102, 6}, null);
        CodeGenerator_x86simd.rulev[3071] = new Rule(3071, false, true, 2853, "3071: _2810 -> (LSHS I16 _61 regw)", null, null, null, 0L, false, false, new int[]{104, 6}, null);
        CodeGenerator_x86simd.rulev[3073] = new Rule(3073, false, true, 2855, "3073: _2812 -> (LSHS I16 _63 regw)", null, null, null, 0L, false, false, new int[]{106, 6}, null);
        CodeGenerator_x86simd.rulev[3090] = new Rule(3090, false, true, 2869, "3090: _2826 -> (LSHS I16 _117 con)", null, null, null, 0L, false, false, new int[]{160, 19}, null);
        CodeGenerator_x86simd.rulev[3092] = new Rule(3092, false, true, 2871, "3092: _2828 -> (LSHS I16 _119 con)", null, null, null, 0L, false, false, new int[]{162, 19}, null);
        CodeGenerator_x86simd.rulev[3094] = new Rule(3094, false, true, 2873, "3094: _2830 -> (LSHS I16 _121 con)", null, null, null, 0L, false, false, new int[]{164, 19}, null);
        CodeGenerator_x86simd.rulev[3096] = new Rule(3096, false, true, 2875, "3096: _2832 -> (LSHS I16 _123 con)", null, null, null, 0L, false, false, new int[]{166, 19}, null);
        CodeGenerator_x86simd.rulev[3099] = new Rule(3099, false, true, 2877, "3099: _2834 -> (LSHS I16 _49 con)", null, null, null, 0L, false, false, new int[]{92, 19}, null);
        CodeGenerator_x86simd.rulev[3101] = new Rule(3101, false, true, 2879, "3101: _2836 -> (LSHS I16 _51 con)", null, null, null, 0L, false, false, new int[]{94, 19}, null);
        CodeGenerator_x86simd.rulev[3103] = new Rule(3103, false, true, 2881, "3103: _2838 -> (LSHS I16 _53 con)", null, null, null, 0L, false, false, new int[]{96, 19}, null);
        CodeGenerator_x86simd.rulev[3105] = new Rule(3105, false, true, 2883, "3105: _2840 -> (LSHS I16 _55 con)", null, null, null, 0L, false, false, new int[]{98, 19}, null);
        CodeGenerator_x86simd.rulev[3107] = new Rule(3107, false, true, 2885, "3107: _2842 -> (LSHS I16 _57 con)", null, null, null, 0L, false, false, new int[]{100, 19}, null);
        CodeGenerator_x86simd.rulev[3109] = new Rule(3109, false, true, 2887, "3109: _2844 -> (LSHS I16 _59 con)", null, null, null, 0L, false, false, new int[]{102, 19}, null);
        CodeGenerator_x86simd.rulev[3111] = new Rule(3111, false, true, 2889, "3111: _2846 -> (LSHS I16 _61 con)", null, null, null, 0L, false, false, new int[]{104, 19}, null);
        CodeGenerator_x86simd.rulev[3113] = new Rule(3113, false, true, 2891, "3113: _2848 -> (LSHS I16 _63 con)", null, null, null, 0L, false, false, new int[]{106, 19}, null);
        CodeGenerator_x86simd.rulev[4039] = new Rule(4039, false, false, 6, "4039: regw -> (LSHS I16 regw con)", ImList.list(ImList.list("salw", ImList.list("imm", "$2"), "$0")), null, null, 2L, false, false, new int[]{6, 19}, new String[]{"*reg-I16*", "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[4048] = new Rule(4048, false, false, 6, "4048: regw -> (LSHS I16 regw shfct)", ImList.list(ImList.list("salw", "%cl", "$0")), null, null, 2L, false, false, new int[]{6, 3644}, new String[]{"*reg-I16*", "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[50] = new Rule(50, false, false, 24, "50: index -> (LSHS I32 regl _4)", null, ImList.list(ImList.list("index", "$1", "2")), null, 0L, false, false, new int[]{4, 28}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[51] = new Rule(51, false, false, 24, "51: index -> (LSHS I32 regl _1)", null, ImList.list(ImList.list("index", "$1", "4")), null, 0L, false, false, new int[]{4, 25}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[53] = new Rule(53, false, false, 24, "53: index -> (LSHS I32 regl _5)", null, ImList.list(ImList.list("index", "$1", "8")), null, 0L, false, false, new int[]{4, 29}, new String[]{null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[3076] = new Rule(3076, false, true, 2857, "3076: _2814 -> (LSHS I32 _125 regl)", null, null, null, 0L, false, false, new int[]{168, 4}, null);
        CodeGenerator_x86simd.rulev[3078] = new Rule(3078, false, true, 2859, "3078: _2816 -> (LSHS I32 _127 regl)", null, null, null, 0L, false, false, new int[]{170, 4}, null);
        CodeGenerator_x86simd.rulev[3081] = new Rule(3081, false, true, 2861, "3081: _2818 -> (LSHS I32 _65 regl)", null, null, null, 0L, false, false, new int[]{108, 4}, null);
        CodeGenerator_x86simd.rulev[3083] = new Rule(3083, false, true, 2863, "3083: _2820 -> (LSHS I32 _67 regl)", null, null, null, 0L, false, false, new int[]{110, 4}, null);
        CodeGenerator_x86simd.rulev[3085] = new Rule(3085, false, true, 2865, "3085: _2822 -> (LSHS I32 _69 regl)", null, null, null, 0L, false, false, new int[]{112, 4}, null);
        CodeGenerator_x86simd.rulev[3087] = new Rule(3087, false, true, 2867, "3087: _2824 -> (LSHS I32 _71 regl)", null, null, null, 0L, false, false, new int[]{114, 4}, null);
        CodeGenerator_x86simd.rulev[3116] = new Rule(3116, false, true, 2893, "3116: _2850 -> (LSHS I32 _125 con)", null, null, null, 0L, false, false, new int[]{168, 19}, null);
        CodeGenerator_x86simd.rulev[3118] = new Rule(3118, false, true, 2895, "3118: _2852 -> (LSHS I32 _127 con)", null, null, null, 0L, false, false, new int[]{170, 19}, null);
        CodeGenerator_x86simd.rulev[3121] = new Rule(3121, false, true, 2897, "3121: _2854 -> (LSHS I32 _65 con)", null, null, null, 0L, false, false, new int[]{108, 19}, null);
        CodeGenerator_x86simd.rulev[3123] = new Rule(3123, false, true, 2899, "3123: _2856 -> (LSHS I32 _67 con)", null, null, null, 0L, false, false, new int[]{110, 19}, null);
        CodeGenerator_x86simd.rulev[3125] = new Rule(3125, false, true, 2901, "3125: _2858 -> (LSHS I32 _69 con)", null, null, null, 0L, false, false, new int[]{112, 19}, null);
        CodeGenerator_x86simd.rulev[3127] = new Rule(3127, false, true, 2903, "3127: _2860 -> (LSHS I32 _71 con)", null, null, null, 0L, false, false, new int[]{114, 19}, null);
        CodeGenerator_x86simd.rulev[4042] = new Rule(4042, false, false, 4, "4042: regl -> (LSHS I32 regl con)", ImList.list(ImList.list("sall", ImList.list("imm", "$2"), "$0")), null, null, 2L, false, false, new int[]{4, 19}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4051] = new Rule(4051, false, false, 4, "4051: regl -> (LSHS I32 regl shfct)", ImList.list(ImList.list("sall", "%cl", "$0")), null, null, 2L, false, false, new int[]{4, 3644}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[3981] = new Rule(3981, false, false, 3, "3981: regq -> (LSHS I64 regq con)", ImList.list(ImList.list("shldl", ImList.list("imm", "$2"), ImList.list("qlow", "$0"), ImList.list("qhigh", "$0")), ImList.list("shll", ImList.list("imm", "$2"), ImList.list("qlow", "$0"))), null, null, 2L, false, false, new int[]{3, 19}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86simd.rulev[3982] = new Rule(3982, false, false, 3, "3982: regq -> (LSHS I64 regq con)", ImList.list(ImList.list("movl", ImList.list("qlow", "$0"), ImList.list("qhigh", "$0")), ImList.list("xorl", ImList.list("qlow", "$0"), ImList.list("qlow", "$0"))), null, null, 2L, false, false, new int[]{3, 19}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86simd.rulev[3983] = new Rule(3983, false, false, 3, "3983: regq -> (LSHS I64 regq con)", ImList.list(ImList.list("movl", ImList.list("qlow", "$0"), ImList.list("qhigh", "$0")), ImList.list("xorl", ImList.list("qlow", "$0"), ImList.list("qlow", "$0")), ImList.list("shll", ImList.list("imm", ImList.list("-32", "$2")), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{3, 19}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86simd.rulev[3984] = new Rule(3984, false, false, 3, "3984: regq -> (LSHS I64 regq shfct)", new ImList(ImList.list("shldl", ImList.list("qlow", "$0"), ImList.list("qhigh", "$0")), new ImList(ImList.list("shll", "%cl", ImList.list("qlow", "$0")), ImList.list(ImList.list("testb", ImList.list("imm", "32"), "%cl"), ImList.list("je", "$L1"), ImList.list("movl", ImList.list("qlow", "$0"), ImList.list("qhigh", "$0")), ImList.list("xorl", ImList.list("qlow", "$0"), ImList.list("qlow", "$0")), ImList.list("deflabel", "$L1")))), null, null, 2L, false, false, new int[]{3, 3644}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86simd.rulev[631] = new Rule(631, false, true, 482, "631: _439 -> (RSHS I8 _438 _437)", null, null, null, 0L, false, false, new int[]{481, 480}, null);
        CodeGenerator_x86simd.rulev[635] = new Rule(635, false, true, 486, "635: _443 -> (RSHS I8 _442 _437)", null, null, null, 0L, false, false, new int[]{485, 480}, null);
        CodeGenerator_x86simd.rulev[639] = new Rule(639, false, true, 490, "639: _447 -> (RSHS I8 _446 _437)", null, null, null, 0L, false, false, new int[]{489, 480}, null);
        CodeGenerator_x86simd.rulev[643] = new Rule(643, false, true, 494, "643: _451 -> (RSHS I8 _450 _437)", null, null, null, 0L, false, false, new int[]{493, 480}, null);
        CodeGenerator_x86simd.rulev[647] = new Rule(647, false, true, 498, "647: _455 -> (RSHS I8 _454 _437)", null, null, null, 0L, false, false, new int[]{497, 480}, null);
        CodeGenerator_x86simd.rulev[651] = new Rule(651, false, true, 502, "651: _459 -> (RSHS I8 _458 _437)", null, null, null, 0L, false, false, new int[]{501, 480}, null);
        CodeGenerator_x86simd.rulev[655] = new Rule(655, false, true, 506, "655: _463 -> (RSHS I8 _462 _437)", null, null, null, 0L, false, false, new int[]{505, 480}, null);
        CodeGenerator_x86simd.rulev[659] = new Rule(659, false, true, 510, "659: _467 -> (RSHS I8 _466 _437)", null, null, null, 0L, false, false, new int[]{509, 480}, null);
        CodeGenerator_x86simd.rulev[662] = new Rule(662, false, true, 512, "662: _469 -> (RSHS I8 _101 _437)", null, null, null, 0L, false, false, new int[]{144, 480}, null);
        CodeGenerator_x86simd.rulev[668] = new Rule(668, false, true, 518, "668: _475 -> (RSHS I8 _103 _437)", null, null, null, 0L, false, false, new int[]{146, 480}, null);
        CodeGenerator_x86simd.rulev[674] = new Rule(674, false, true, 524, "674: _481 -> (RSHS I8 _105 _437)", null, null, null, 0L, false, false, new int[]{148, 480}, null);
        CodeGenerator_x86simd.rulev[680] = new Rule(680, false, true, 530, "680: _487 -> (RSHS I8 _107 _437)", null, null, null, 0L, false, false, new int[]{150, 480}, null);
        CodeGenerator_x86simd.rulev[686] = new Rule(686, false, true, 536, "686: _493 -> (RSHS I8 _109 _437)", null, null, null, 0L, false, false, new int[]{152, 480}, null);
        CodeGenerator_x86simd.rulev[692] = new Rule(692, false, true, 542, "692: _499 -> (RSHS I8 _111 _437)", null, null, null, 0L, false, false, new int[]{154, 480}, null);
        CodeGenerator_x86simd.rulev[698] = new Rule(698, false, true, 548, "698: _505 -> (RSHS I8 _113 _437)", null, null, null, 0L, false, false, new int[]{156, 480}, null);
        CodeGenerator_x86simd.rulev[704] = new Rule(704, false, true, 554, "704: _511 -> (RSHS I8 _115 _437)", null, null, null, 0L, false, false, new int[]{158, 480}, null);
        CodeGenerator_x86simd.rulev[713] = new Rule(713, false, true, 562, "713: _519 -> (RSHS I8 _518 _437)", null, null, null, 0L, false, false, new int[]{561, 480}, null);
        CodeGenerator_x86simd.rulev[717] = new Rule(717, false, true, 566, "717: _523 -> (RSHS I8 _522 _437)", null, null, null, 0L, false, false, new int[]{565, 480}, null);
        CodeGenerator_x86simd.rulev[721] = new Rule(721, false, true, 570, "721: _527 -> (RSHS I8 _526 _437)", null, null, null, 0L, false, false, new int[]{569, 480}, null);
        CodeGenerator_x86simd.rulev[725] = new Rule(725, false, true, 574, "725: _531 -> (RSHS I8 _530 _437)", null, null, null, 0L, false, false, new int[]{573, 480}, null);
        CodeGenerator_x86simd.rulev[729] = new Rule(729, false, true, 578, "729: _535 -> (RSHS I8 _534 _437)", null, null, null, 0L, false, false, new int[]{577, 480}, null);
        CodeGenerator_x86simd.rulev[733] = new Rule(733, false, true, 582, "733: _539 -> (RSHS I8 _538 _437)", null, null, null, 0L, false, false, new int[]{581, 480}, null);
        CodeGenerator_x86simd.rulev[737] = new Rule(737, false, true, 586, "737: _543 -> (RSHS I8 _542 _437)", null, null, null, 0L, false, false, new int[]{585, 480}, null);
        CodeGenerator_x86simd.rulev[741] = new Rule(741, false, true, 590, "741: _547 -> (RSHS I8 _546 _437)", null, null, null, 0L, false, false, new int[]{589, 480}, null);
        CodeGenerator_x86simd.rulev[745] = new Rule(745, false, true, 594, "745: _551 -> (RSHS I8 _550 _437)", null, null, null, 0L, false, false, new int[]{593, 480}, null);
        CodeGenerator_x86simd.rulev[749] = new Rule(749, false, true, 598, "749: _555 -> (RSHS I8 _554 _437)", null, null, null, 0L, false, false, new int[]{597, 480}, null);
        CodeGenerator_x86simd.rulev[753] = new Rule(753, false, true, 602, "753: _559 -> (RSHS I8 _558 _437)", null, null, null, 0L, false, false, new int[]{601, 480}, null);
        CodeGenerator_x86simd.rulev[757] = new Rule(757, false, true, 606, "757: _563 -> (RSHS I8 _562 _437)", null, null, null, 0L, false, false, new int[]{605, 480}, null);
        CodeGenerator_x86simd.rulev[761] = new Rule(761, false, true, 610, "761: _567 -> (RSHS I8 _566 _437)", null, null, null, 0L, false, false, new int[]{609, 480}, null);
        CodeGenerator_x86simd.rulev[765] = new Rule(765, false, true, 614, "765: _571 -> (RSHS I8 _570 _437)", null, null, null, 0L, false, false, new int[]{613, 480}, null);
        CodeGenerator_x86simd.rulev[769] = new Rule(769, false, true, 618, "769: _575 -> (RSHS I8 _574 _437)", null, null, null, 0L, false, false, new int[]{617, 480}, null);
        CodeGenerator_x86simd.rulev[773] = new Rule(773, false, true, 622, "773: _579 -> (RSHS I8 _578 _437)", null, null, null, 0L, false, false, new int[]{621, 480}, null);
        CodeGenerator_x86simd.rulev[776] = new Rule(776, false, true, 624, "776: _581 -> (RSHS I8 _7 _437)", null, null, null, 0L, false, false, new int[]{50, 480}, null);
        CodeGenerator_x86simd.rulev[782] = new Rule(782, false, true, 630, "782: _587 -> (RSHS I8 _9 _437)", null, null, null, 0L, false, false, new int[]{52, 480}, null);
        CodeGenerator_x86simd.rulev[788] = new Rule(788, false, true, 636, "788: _593 -> (RSHS I8 _11 _437)", null, null, null, 0L, false, false, new int[]{54, 480}, null);
        CodeGenerator_x86simd.rulev[794] = new Rule(794, false, true, 642, "794: _599 -> (RSHS I8 _13 _437)", null, null, null, 0L, false, false, new int[]{56, 480}, null);
        CodeGenerator_x86simd.rulev[800] = new Rule(800, false, true, 648, "800: _605 -> (RSHS I8 _15 _437)", null, null, null, 0L, false, false, new int[]{58, 480}, null);
        CodeGenerator_x86simd.rulev[806] = new Rule(806, false, true, 654, "806: _611 -> (RSHS I8 _18 _437)", null, null, null, 0L, false, false, new int[]{61, 480}, null);
        CodeGenerator_x86simd.rulev[812] = new Rule(812, false, true, 660, "812: _617 -> (RSHS I8 _21 _437)", null, null, null, 0L, false, false, new int[]{64, 480}, null);
        CodeGenerator_x86simd.rulev[818] = new Rule(818, false, true, 666, "818: _623 -> (RSHS I8 _24 _437)", null, null, null, 0L, false, false, new int[]{67, 480}, null);
        CodeGenerator_x86simd.rulev[824] = new Rule(824, false, true, 672, "824: _629 -> (RSHS I8 _26 _437)", null, null, null, 0L, false, false, new int[]{69, 480}, null);
        CodeGenerator_x86simd.rulev[830] = new Rule(830, false, true, 678, "830: _635 -> (RSHS I8 _29 _437)", null, null, null, 0L, false, false, new int[]{72, 480}, null);
        CodeGenerator_x86simd.rulev[836] = new Rule(836, false, true, 684, "836: _641 -> (RSHS I8 _32 _437)", null, null, null, 0L, false, false, new int[]{75, 480}, null);
        CodeGenerator_x86simd.rulev[842] = new Rule(842, false, true, 690, "842: _647 -> (RSHS I8 _35 _437)", null, null, null, 0L, false, false, new int[]{78, 480}, null);
        CodeGenerator_x86simd.rulev[848] = new Rule(848, false, true, 696, "848: _653 -> (RSHS I8 _38 _437)", null, null, null, 0L, false, false, new int[]{81, 480}, null);
        CodeGenerator_x86simd.rulev[854] = new Rule(854, false, true, 702, "854: _659 -> (RSHS I8 _41 _437)", null, null, null, 0L, false, false, new int[]{84, 480}, null);
    }

    private static void rrinit2300() {
        CodeGenerator_x86simd.rulev[860] = new Rule(860, false, true, 708, "860: _665 -> (RSHS I8 _44 _437)", null, null, null, 0L, false, false, new int[]{87, 480}, null);
        CodeGenerator_x86simd.rulev[866] = new Rule(866, false, true, 714, "866: _671 -> (RSHS I8 _47 _437)", null, null, null, 0L, false, false, new int[]{90, 480}, null);
        CodeGenerator_x86simd.rulev[4037] = new Rule(4037, false, false, 7, "4037: regb -> (RSHS I8 regb con)", ImList.list(ImList.list("sarb", ImList.list("imm", "$2"), "$0")), null, null, 2L, false, false, new int[]{7, 19}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[4046] = new Rule(4046, false, false, 7, "4046: regb -> (RSHS I8 regb shfct)", ImList.list(ImList.list("sarb", "%cl", "$0")), null, null, 2L, false, false, new int[]{7, 3644}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[876] = new Rule(876, false, true, 723, "876: _680 -> (RSHS I16 _679 _678)", null, null, null, 0L, false, false, new int[]{722, 721}, null);
        CodeGenerator_x86simd.rulev[880] = new Rule(880, false, true, 727, "880: _684 -> (RSHS I16 _683 _678)", null, null, null, 0L, false, false, new int[]{726, 721}, null);
        CodeGenerator_x86simd.rulev[884] = new Rule(884, false, true, 731, "884: _688 -> (RSHS I16 _687 _678)", null, null, null, 0L, false, false, new int[]{730, 721}, null);
        CodeGenerator_x86simd.rulev[888] = new Rule(888, false, true, 735, "888: _692 -> (RSHS I16 _691 _678)", null, null, null, 0L, false, false, new int[]{734, 721}, null);
        CodeGenerator_x86simd.rulev[891] = new Rule(891, false, true, 737, "891: _694 -> (RSHS I16 _117 _678)", null, null, null, 0L, false, false, new int[]{160, 721}, null);
        CodeGenerator_x86simd.rulev[897] = new Rule(897, false, true, 743, "897: _700 -> (RSHS I16 _119 _678)", null, null, null, 0L, false, false, new int[]{162, 721}, null);
        CodeGenerator_x86simd.rulev[903] = new Rule(903, false, true, 749, "903: _706 -> (RSHS I16 _121 _678)", null, null, null, 0L, false, false, new int[]{164, 721}, null);
        CodeGenerator_x86simd.rulev[909] = new Rule(909, false, true, 755, "909: _712 -> (RSHS I16 _123 _678)", null, null, null, 0L, false, false, new int[]{166, 721}, null);
        CodeGenerator_x86simd.rulev[918] = new Rule(918, false, true, 763, "918: _720 -> (RSHS I16 _719 _678)", null, null, null, 0L, false, false, new int[]{762, 721}, null);
        CodeGenerator_x86simd.rulev[922] = new Rule(922, false, true, 767, "922: _724 -> (RSHS I16 _723 _678)", null, null, null, 0L, false, false, new int[]{766, 721}, null);
        CodeGenerator_x86simd.rulev[926] = new Rule(926, false, true, 771, "926: _728 -> (RSHS I16 _727 _678)", null, null, null, 0L, false, false, new int[]{770, 721}, null);
        CodeGenerator_x86simd.rulev[930] = new Rule(930, false, true, 775, "930: _732 -> (RSHS I16 _731 _678)", null, null, null, 0L, false, false, new int[]{774, 721}, null);
        CodeGenerator_x86simd.rulev[934] = new Rule(934, false, true, 779, "934: _736 -> (RSHS I16 _735 _678)", null, null, null, 0L, false, false, new int[]{778, 721}, null);
        CodeGenerator_x86simd.rulev[938] = new Rule(938, false, true, 783, "938: _740 -> (RSHS I16 _739 _678)", null, null, null, 0L, false, false, new int[]{782, 721}, null);
        CodeGenerator_x86simd.rulev[942] = new Rule(942, false, true, 787, "942: _744 -> (RSHS I16 _743 _678)", null, null, null, 0L, false, false, new int[]{786, 721}, null);
        CodeGenerator_x86simd.rulev[946] = new Rule(946, false, true, 791, "946: _748 -> (RSHS I16 _747 _678)", null, null, null, 0L, false, false, new int[]{790, 721}, null);
        CodeGenerator_x86simd.rulev[949] = new Rule(949, false, true, 793, "949: _750 -> (RSHS I16 _49 _678)", null, null, null, 0L, false, false, new int[]{92, 721}, null);
        CodeGenerator_x86simd.rulev[955] = new Rule(955, false, true, 799, "955: _756 -> (RSHS I16 _51 _678)", null, null, null, 0L, false, false, new int[]{94, 721}, null);
        CodeGenerator_x86simd.rulev[961] = new Rule(961, false, true, 805, "961: _762 -> (RSHS I16 _53 _678)", null, null, null, 0L, false, false, new int[]{96, 721}, null);
        CodeGenerator_x86simd.rulev[967] = new Rule(967, false, true, 811, "967: _768 -> (RSHS I16 _55 _678)", null, null, null, 0L, false, false, new int[]{98, 721}, null);
        CodeGenerator_x86simd.rulev[973] = new Rule(973, false, true, 817, "973: _774 -> (RSHS I16 _57 _678)", null, null, null, 0L, false, false, new int[]{100, 721}, null);
        CodeGenerator_x86simd.rulev[979] = new Rule(979, false, true, 823, "979: _780 -> (RSHS I16 _59 _678)", null, null, null, 0L, false, false, new int[]{102, 721}, null);
        CodeGenerator_x86simd.rulev[985] = new Rule(985, false, true, 829, "985: _786 -> (RSHS I16 _61 _678)", null, null, null, 0L, false, false, new int[]{104, 721}, null);
        CodeGenerator_x86simd.rulev[991] = new Rule(991, false, true, 835, "991: _792 -> (RSHS I16 _63 _678)", null, null, null, 0L, false, false, new int[]{106, 721}, null);
        CodeGenerator_x86simd.rulev[2890] = new Rule(2890, false, true, 2689, "2890: _2646 -> (RSHS I16 _117 regw)", null, null, null, 0L, false, false, new int[]{160, 6}, null);
        CodeGenerator_x86simd.rulev[2892] = new Rule(2892, false, true, 2691, "2892: _2648 -> (RSHS I16 _119 regw)", null, null, null, 0L, false, false, new int[]{162, 6}, null);
        CodeGenerator_x86simd.rulev[2894] = new Rule(2894, false, true, 2693, "2894: _2650 -> (RSHS I16 _121 regw)", null, null, null, 0L, false, false, new int[]{164, 6}, null);
        CodeGenerator_x86simd.rulev[2896] = new Rule(2896, false, true, 2695, "2896: _2652 -> (RSHS I16 _123 regw)", null, null, null, 0L, false, false, new int[]{166, 6}, null);
        CodeGenerator_x86simd.rulev[2899] = new Rule(2899, false, true, 2697, "2899: _2654 -> (RSHS I16 _49 regw)", null, null, null, 0L, false, false, new int[]{92, 6}, null);
        CodeGenerator_x86simd.rulev[2901] = new Rule(2901, false, true, 2699, "2901: _2656 -> (RSHS I16 _51 regw)", null, null, null, 0L, false, false, new int[]{94, 6}, null);
        CodeGenerator_x86simd.rulev[2903] = new Rule(2903, false, true, 2701, "2903: _2658 -> (RSHS I16 _53 regw)", null, null, null, 0L, false, false, new int[]{96, 6}, null);
        CodeGenerator_x86simd.rulev[2905] = new Rule(2905, false, true, 2703, "2905: _2660 -> (RSHS I16 _55 regw)", null, null, null, 0L, false, false, new int[]{98, 6}, null);
        CodeGenerator_x86simd.rulev[2907] = new Rule(2907, false, true, 2705, "2907: _2662 -> (RSHS I16 _57 regw)", null, null, null, 0L, false, false, new int[]{100, 6}, null);
        CodeGenerator_x86simd.rulev[2909] = new Rule(2909, false, true, 2707, "2909: _2664 -> (RSHS I16 _59 regw)", null, null, null, 0L, false, false, new int[]{102, 6}, null);
        CodeGenerator_x86simd.rulev[2911] = new Rule(2911, false, true, 2709, "2911: _2666 -> (RSHS I16 _61 regw)", null, null, null, 0L, false, false, new int[]{104, 6}, null);
        CodeGenerator_x86simd.rulev[2913] = new Rule(2913, false, true, 2711, "2913: _2668 -> (RSHS I16 _63 regw)", null, null, null, 0L, false, false, new int[]{106, 6}, null);
        CodeGenerator_x86simd.rulev[2930] = new Rule(2930, false, true, 2725, "2930: _2682 -> (RSHS I16 _117 con)", null, null, null, 0L, false, false, new int[]{160, 19}, null);
        CodeGenerator_x86simd.rulev[2932] = new Rule(2932, false, true, 2727, "2932: _2684 -> (RSHS I16 _119 con)", null, null, null, 0L, false, false, new int[]{162, 19}, null);
        CodeGenerator_x86simd.rulev[2934] = new Rule(2934, false, true, 2729, "2934: _2686 -> (RSHS I16 _121 con)", null, null, null, 0L, false, false, new int[]{164, 19}, null);
        CodeGenerator_x86simd.rulev[2936] = new Rule(2936, false, true, 2731, "2936: _2688 -> (RSHS I16 _123 con)", null, null, null, 0L, false, false, new int[]{166, 19}, null);
        CodeGenerator_x86simd.rulev[2939] = new Rule(2939, false, true, 2733, "2939: _2690 -> (RSHS I16 _49 con)", null, null, null, 0L, false, false, new int[]{92, 19}, null);
        CodeGenerator_x86simd.rulev[2941] = new Rule(2941, false, true, 2735, "2941: _2692 -> (RSHS I16 _51 con)", null, null, null, 0L, false, false, new int[]{94, 19}, null);
        CodeGenerator_x86simd.rulev[2943] = new Rule(2943, false, true, 2737, "2943: _2694 -> (RSHS I16 _53 con)", null, null, null, 0L, false, false, new int[]{96, 19}, null);
        CodeGenerator_x86simd.rulev[2945] = new Rule(2945, false, true, 2739, "2945: _2696 -> (RSHS I16 _55 con)", null, null, null, 0L, false, false, new int[]{98, 19}, null);
        CodeGenerator_x86simd.rulev[2947] = new Rule(2947, false, true, 2741, "2947: _2698 -> (RSHS I16 _57 con)", null, null, null, 0L, false, false, new int[]{100, 19}, null);
        CodeGenerator_x86simd.rulev[2949] = new Rule(2949, false, true, 2743, "2949: _2700 -> (RSHS I16 _59 con)", null, null, null, 0L, false, false, new int[]{102, 19}, null);
        CodeGenerator_x86simd.rulev[2951] = new Rule(2951, false, true, 2745, "2951: _2702 -> (RSHS I16 _61 con)", null, null, null, 0L, false, false, new int[]{104, 19}, null);
        CodeGenerator_x86simd.rulev[2953] = new Rule(2953, false, true, 2747, "2953: _2704 -> (RSHS I16 _63 con)", null, null, null, 0L, false, false, new int[]{106, 19}, null);
        CodeGenerator_x86simd.rulev[4040] = new Rule(4040, false, false, 6, "4040: regw -> (RSHS I16 regw con)", ImList.list(ImList.list("sarw", ImList.list("imm", "$2"), "$0")), null, null, 2L, false, false, new int[]{6, 19}, new String[]{"*reg-I16*", "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[4049] = new Rule(4049, false, false, 6, "4049: regw -> (RSHS I16 regw shfct)", ImList.list(ImList.list("sarw", "%cl", "$0")), null, null, 2L, false, false, new int[]{6, 3644}, new String[]{"*reg-I16*", "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[2916] = new Rule(2916, false, true, 2713, "2916: _2670 -> (RSHS I32 _125 regl)", null, null, null, 0L, false, false, new int[]{168, 4}, null);
        CodeGenerator_x86simd.rulev[2918] = new Rule(2918, false, true, 2715, "2918: _2672 -> (RSHS I32 _127 regl)", null, null, null, 0L, false, false, new int[]{170, 4}, null);
        CodeGenerator_x86simd.rulev[2921] = new Rule(2921, false, true, 2717, "2921: _2674 -> (RSHS I32 _65 regl)", null, null, null, 0L, false, false, new int[]{108, 4}, null);
        CodeGenerator_x86simd.rulev[2923] = new Rule(2923, false, true, 2719, "2923: _2676 -> (RSHS I32 _67 regl)", null, null, null, 0L, false, false, new int[]{110, 4}, null);
        CodeGenerator_x86simd.rulev[2925] = new Rule(2925, false, true, 2721, "2925: _2678 -> (RSHS I32 _69 regl)", null, null, null, 0L, false, false, new int[]{112, 4}, null);
        CodeGenerator_x86simd.rulev[2927] = new Rule(2927, false, true, 2723, "2927: _2680 -> (RSHS I32 _71 regl)", null, null, null, 0L, false, false, new int[]{114, 4}, null);
        CodeGenerator_x86simd.rulev[2956] = new Rule(2956, false, true, 2749, "2956: _2706 -> (RSHS I32 _125 con)", null, null, null, 0L, false, false, new int[]{168, 19}, null);
        CodeGenerator_x86simd.rulev[2958] = new Rule(2958, false, true, 2751, "2958: _2708 -> (RSHS I32 _127 con)", null, null, null, 0L, false, false, new int[]{170, 19}, null);
        CodeGenerator_x86simd.rulev[2961] = new Rule(2961, false, true, 2753, "2961: _2710 -> (RSHS I32 _65 con)", null, null, null, 0L, false, false, new int[]{108, 19}, null);
        CodeGenerator_x86simd.rulev[2963] = new Rule(2963, false, true, 2755, "2963: _2712 -> (RSHS I32 _67 con)", null, null, null, 0L, false, false, new int[]{110, 19}, null);
        CodeGenerator_x86simd.rulev[2965] = new Rule(2965, false, true, 2757, "2965: _2714 -> (RSHS I32 _69 con)", null, null, null, 0L, false, false, new int[]{112, 19}, null);
        CodeGenerator_x86simd.rulev[2967] = new Rule(2967, false, true, 2759, "2967: _2716 -> (RSHS I32 _71 con)", null, null, null, 0L, false, false, new int[]{114, 19}, null);
        CodeGenerator_x86simd.rulev[4043] = new Rule(4043, false, false, 4, "4043: regl -> (RSHS I32 regl con)", ImList.list(ImList.list("sarl", ImList.list("imm", "$2"), "$0")), null, null, 2L, false, false, new int[]{4, 19}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4052] = new Rule(4052, false, false, 4, "4052: regl -> (RSHS I32 regl shfct)", ImList.list(ImList.list("sarl", "%cl", "$0")), null, null, 2L, false, false, new int[]{4, 3644}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[3985] = new Rule(3985, false, false, 3, "3985: regq -> (RSHS I64 regq con)", ImList.list(ImList.list("shrdl", ImList.list("imm", "$2"), ImList.list("qhigh", "$0"), ImList.list("qlow", "$0")), ImList.list("sarl", ImList.list("imm", "$2"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{3, 19}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86simd.rulev[3986] = new Rule(3986, false, false, 3, "3986: regq -> (RSHS I64 regq con)", ImList.list(ImList.list("movl", ImList.list("qhigh", "$0"), ImList.list("qlow", "$0")), ImList.list("sarl", ImList.list("imm", "31"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{3, 19}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86simd.rulev[3987] = new Rule(3987, false, false, 3, "3987: regq -> (RSHS I64 regq con)", ImList.list(ImList.list("sarl", ImList.list("imm", ImList.list("-32", "$2")), ImList.list("qhigh", "$0")), ImList.list("movl", ImList.list("qhigh", "$0"), ImList.list("qlow", "$0")), ImList.list("sarl", ImList.list("imm", "31"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{3, 19}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86simd.rulev[3988] = new Rule(3988, false, false, 3, "3988: regq -> (RSHS I64 regq shfct)", new ImList(ImList.list("shrdl", ImList.list("qhigh", "$0"), ImList.list("qlow", "$0")), new ImList(ImList.list("sarl", "%cl", ImList.list("qhigh", "$0")), ImList.list(ImList.list("testb", ImList.list("imm", "32"), "%cl"), ImList.list("je", "$L1"), ImList.list("movl", ImList.list("qhigh", "$0"), ImList.list("qlow", "$0")), ImList.list("sarl", ImList.list("imm", "31"), ImList.list("qhigh", "$0")), ImList.list("deflabel", "$L1")))), null, null, 2L, false, false, new int[]{3, 3644}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86simd.rulev[4038] = new Rule(4038, false, false, 7, "4038: regb -> (RSHU I8 regb con)", ImList.list(ImList.list("shrb", ImList.list("imm", "$2"), "$0")), null, null, 2L, false, false, new int[]{7, 19}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[4047] = new Rule(4047, false, false, 7, "4047: regb -> (RSHU I8 regb shfct)", ImList.list(ImList.list("shrb", "%cl", "$0")), null, null, 2L, false, false, new int[]{7, 3644}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[2970] = new Rule(2970, false, true, 2761, "2970: _2718 -> (RSHU I16 _117 regw)", null, null, null, 0L, false, false, new int[]{160, 6}, null);
        CodeGenerator_x86simd.rulev[2972] = new Rule(2972, false, true, 2763, "2972: _2720 -> (RSHU I16 _119 regw)", null, null, null, 0L, false, false, new int[]{162, 6}, null);
        CodeGenerator_x86simd.rulev[2974] = new Rule(2974, false, true, 2765, "2974: _2722 -> (RSHU I16 _121 regw)", null, null, null, 0L, false, false, new int[]{164, 6}, null);
        CodeGenerator_x86simd.rulev[2976] = new Rule(2976, false, true, 2767, "2976: _2724 -> (RSHU I16 _123 regw)", null, null, null, 0L, false, false, new int[]{166, 6}, null);
        CodeGenerator_x86simd.rulev[2979] = new Rule(2979, false, true, 2769, "2979: _2726 -> (RSHU I16 _49 regw)", null, null, null, 0L, false, false, new int[]{92, 6}, null);
        CodeGenerator_x86simd.rulev[2981] = new Rule(2981, false, true, 2771, "2981: _2728 -> (RSHU I16 _51 regw)", null, null, null, 0L, false, false, new int[]{94, 6}, null);
        CodeGenerator_x86simd.rulev[2983] = new Rule(2983, false, true, 2773, "2983: _2730 -> (RSHU I16 _53 regw)", null, null, null, 0L, false, false, new int[]{96, 6}, null);
        CodeGenerator_x86simd.rulev[2985] = new Rule(2985, false, true, 2775, "2985: _2732 -> (RSHU I16 _55 regw)", null, null, null, 0L, false, false, new int[]{98, 6}, null);
        CodeGenerator_x86simd.rulev[2987] = new Rule(2987, false, true, 2777, "2987: _2734 -> (RSHU I16 _57 regw)", null, null, null, 0L, false, false, new int[]{100, 6}, null);
        CodeGenerator_x86simd.rulev[2989] = new Rule(2989, false, true, 2779, "2989: _2736 -> (RSHU I16 _59 regw)", null, null, null, 0L, false, false, new int[]{102, 6}, null);
        CodeGenerator_x86simd.rulev[2991] = new Rule(2991, false, true, 2781, "2991: _2738 -> (RSHU I16 _61 regw)", null, null, null, 0L, false, false, new int[]{104, 6}, null);
        CodeGenerator_x86simd.rulev[2993] = new Rule(2993, false, true, 2783, "2993: _2740 -> (RSHU I16 _63 regw)", null, null, null, 0L, false, false, new int[]{106, 6}, null);
        CodeGenerator_x86simd.rulev[3010] = new Rule(3010, false, true, 2797, "3010: _2754 -> (RSHU I16 _117 con)", null, null, null, 0L, false, false, new int[]{160, 19}, null);
        CodeGenerator_x86simd.rulev[3012] = new Rule(3012, false, true, 2799, "3012: _2756 -> (RSHU I16 _119 con)", null, null, null, 0L, false, false, new int[]{162, 19}, null);
        CodeGenerator_x86simd.rulev[3014] = new Rule(3014, false, true, 2801, "3014: _2758 -> (RSHU I16 _121 con)", null, null, null, 0L, false, false, new int[]{164, 19}, null);
        CodeGenerator_x86simd.rulev[3016] = new Rule(3016, false, true, 2803, "3016: _2760 -> (RSHU I16 _123 con)", null, null, null, 0L, false, false, new int[]{166, 19}, null);
        CodeGenerator_x86simd.rulev[3019] = new Rule(3019, false, true, 2805, "3019: _2762 -> (RSHU I16 _49 con)", null, null, null, 0L, false, false, new int[]{92, 19}, null);
        CodeGenerator_x86simd.rulev[3021] = new Rule(3021, false, true, 2807, "3021: _2764 -> (RSHU I16 _51 con)", null, null, null, 0L, false, false, new int[]{94, 19}, null);
        CodeGenerator_x86simd.rulev[3023] = new Rule(3023, false, true, 2809, "3023: _2766 -> (RSHU I16 _53 con)", null, null, null, 0L, false, false, new int[]{96, 19}, null);
        CodeGenerator_x86simd.rulev[3025] = new Rule(3025, false, true, 2811, "3025: _2768 -> (RSHU I16 _55 con)", null, null, null, 0L, false, false, new int[]{98, 19}, null);
        CodeGenerator_x86simd.rulev[3027] = new Rule(3027, false, true, 2813, "3027: _2770 -> (RSHU I16 _57 con)", null, null, null, 0L, false, false, new int[]{100, 19}, null);
        CodeGenerator_x86simd.rulev[3029] = new Rule(3029, false, true, 2815, "3029: _2772 -> (RSHU I16 _59 con)", null, null, null, 0L, false, false, new int[]{102, 19}, null);
        CodeGenerator_x86simd.rulev[3031] = new Rule(3031, false, true, 2817, "3031: _2774 -> (RSHU I16 _61 con)", null, null, null, 0L, false, false, new int[]{104, 19}, null);
        CodeGenerator_x86simd.rulev[3033] = new Rule(3033, false, true, 2819, "3033: _2776 -> (RSHU I16 _63 con)", null, null, null, 0L, false, false, new int[]{106, 19}, null);
        CodeGenerator_x86simd.rulev[4041] = new Rule(4041, false, false, 6, "4041: regw -> (RSHU I16 regw con)", ImList.list(ImList.list("shrw", ImList.list("imm", "$2"), "$0")), null, null, 2L, false, false, new int[]{6, 19}, new String[]{"*reg-I16*", "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[4050] = new Rule(4050, false, false, 6, "4050: regw -> (RSHU I16 regw shfct)", ImList.list(ImList.list("shrw", "%cl", "$0")), null, null, 2L, false, false, new int[]{6, 3644}, new String[]{"*reg-I16*", "*reg-I16*", null});
    }

    private static void rrinit2400() {
        CodeGenerator_x86simd.rulev[2996] = new Rule(2996, false, true, 2785, "2996: _2742 -> (RSHU I32 _125 regl)", null, null, null, 0L, false, false, new int[]{168, 4}, null);
        CodeGenerator_x86simd.rulev[2998] = new Rule(2998, false, true, 2787, "2998: _2744 -> (RSHU I32 _127 regl)", null, null, null, 0L, false, false, new int[]{170, 4}, null);
        CodeGenerator_x86simd.rulev[3001] = new Rule(3001, false, true, 2789, "3001: _2746 -> (RSHU I32 _65 regl)", null, null, null, 0L, false, false, new int[]{108, 4}, null);
        CodeGenerator_x86simd.rulev[3003] = new Rule(3003, false, true, 2791, "3003: _2748 -> (RSHU I32 _67 regl)", null, null, null, 0L, false, false, new int[]{110, 4}, null);
        CodeGenerator_x86simd.rulev[3005] = new Rule(3005, false, true, 2793, "3005: _2750 -> (RSHU I32 _69 regl)", null, null, null, 0L, false, false, new int[]{112, 4}, null);
        CodeGenerator_x86simd.rulev[3007] = new Rule(3007, false, true, 2795, "3007: _2752 -> (RSHU I32 _71 regl)", null, null, null, 0L, false, false, new int[]{114, 4}, null);
        CodeGenerator_x86simd.rulev[3036] = new Rule(3036, false, true, 2821, "3036: _2778 -> (RSHU I32 _125 con)", null, null, null, 0L, false, false, new int[]{168, 19}, null);
        CodeGenerator_x86simd.rulev[3038] = new Rule(3038, false, true, 2823, "3038: _2780 -> (RSHU I32 _127 con)", null, null, null, 0L, false, false, new int[]{170, 19}, null);
        CodeGenerator_x86simd.rulev[3041] = new Rule(3041, false, true, 2825, "3041: _2782 -> (RSHU I32 _65 con)", null, null, null, 0L, false, false, new int[]{108, 19}, null);
        CodeGenerator_x86simd.rulev[3043] = new Rule(3043, false, true, 2827, "3043: _2784 -> (RSHU I32 _67 con)", null, null, null, 0L, false, false, new int[]{110, 19}, null);
        CodeGenerator_x86simd.rulev[3045] = new Rule(3045, false, true, 2829, "3045: _2786 -> (RSHU I32 _69 con)", null, null, null, 0L, false, false, new int[]{112, 19}, null);
        CodeGenerator_x86simd.rulev[3047] = new Rule(3047, false, true, 2831, "3047: _2788 -> (RSHU I32 _71 con)", null, null, null, 0L, false, false, new int[]{114, 19}, null);
        CodeGenerator_x86simd.rulev[4044] = new Rule(4044, false, false, 4, "4044: regl -> (RSHU I32 regl con)", ImList.list(ImList.list("shrl", ImList.list("imm", "$2"), "$0")), null, null, 2L, false, false, new int[]{4, 19}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4053] = new Rule(4053, false, false, 4, "4053: regl -> (RSHU I32 regl shfct)", ImList.list(ImList.list("shrl", "%cl", "$0")), null, null, 2L, false, false, new int[]{4, 3644}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[3989] = new Rule(3989, false, false, 3, "3989: regq -> (RSHU I64 regq con)", ImList.list(ImList.list("shrdl", ImList.list("imm", "$2"), ImList.list("qhigh", "$0"), ImList.list("qlow", "$0")), ImList.list("shrl", ImList.list("imm", "$2"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{3, 19}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86simd.rulev[3990] = new Rule(3990, false, false, 3, "3990: regq -> (RSHU I64 regq con)", ImList.list(ImList.list("movl", ImList.list("qhigh", "$0"), ImList.list("qlow", "$0")), ImList.list("xor", ImList.list("qhigh", "$0"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{3, 19}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86simd.rulev[3991] = new Rule(3991, false, false, 3, "3991: regq -> (RSHU I64 regq con)", ImList.list(ImList.list("shrl", ImList.list("imm", ImList.list("-32", "$2")), ImList.list("qhigh", "$0")), ImList.list("movl", ImList.list("qhigh", "$0"), ImList.list("qlow", "$0")), ImList.list("xor", ImList.list("qhigh", "$0"), ImList.list("qhigh", "$0"))), null, null, 2L, false, false, new int[]{3, 19}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86simd.rulev[3992] = new Rule(3992, false, false, 3, "3992: regq -> (RSHU I64 regq shfct)", new ImList(ImList.list("shrdl", ImList.list("qhigh", "$0"), ImList.list("qlow", "$0")), new ImList(ImList.list("shrl", "%cl", ImList.list("qhigh", "$0")), ImList.list(ImList.list("testb", ImList.list("imm", "32"), "%cl"), ImList.list("je", "$L1"), ImList.list("movl", ImList.list("qhigh", "$0"), ImList.list("qlow", "$0")), ImList.list("xorl", ImList.list("qhigh", "$0"), ImList.list("qhigh", "$0")), ImList.list("deflabel", "$L1")))), null, null, 2L, false, false, new int[]{3, 3644}, new String[]{"*reg-I64*", "*reg-I64*", null});
        CodeGenerator_x86simd.rulev[1438] = new Rule(1438, false, true, 1273, "1438: _1230 -> (TSTEQ I8 _101 _101)", null, null, null, 0L, false, false, new int[]{144, 144}, null);
        CodeGenerator_x86simd.rulev[1444] = new Rule(1444, false, true, 1279, "1444: _1236 -> (TSTEQ I8 _103 _103)", null, null, null, 0L, false, false, new int[]{146, 146}, null);
        CodeGenerator_x86simd.rulev[1450] = new Rule(1450, false, true, 1285, "1450: _1242 -> (TSTEQ I8 _105 _105)", null, null, null, 0L, false, false, new int[]{148, 148}, null);
        CodeGenerator_x86simd.rulev[1456] = new Rule(1456, false, true, 1291, "1456: _1248 -> (TSTEQ I8 _107 _107)", null, null, null, 0L, false, false, new int[]{150, 150}, null);
        CodeGenerator_x86simd.rulev[1462] = new Rule(1462, false, true, 1297, "1462: _1254 -> (TSTEQ I8 _109 _109)", null, null, null, 0L, false, false, new int[]{152, 152}, null);
        CodeGenerator_x86simd.rulev[1468] = new Rule(1468, false, true, 1303, "1468: _1260 -> (TSTEQ I8 _111 _111)", null, null, null, 0L, false, false, new int[]{154, 154}, null);
        CodeGenerator_x86simd.rulev[1474] = new Rule(1474, false, true, 1309, "1474: _1266 -> (TSTEQ I8 _113 _113)", null, null, null, 0L, false, false, new int[]{156, 156}, null);
        CodeGenerator_x86simd.rulev[1480] = new Rule(1480, false, true, 1315, "1480: _1272 -> (TSTEQ I8 _115 _115)", null, null, null, 0L, false, false, new int[]{158, 158}, null);
        CodeGenerator_x86simd.rulev[1612] = new Rule(1612, false, true, 1441, "1612: _1398 -> (TSTEQ I8 _7 _7)", null, null, null, 0L, false, false, new int[]{50, 50}, null);
        CodeGenerator_x86simd.rulev[1618] = new Rule(1618, false, true, 1447, "1618: _1404 -> (TSTEQ I8 _9 _9)", null, null, null, 0L, false, false, new int[]{52, 52}, null);
        CodeGenerator_x86simd.rulev[1624] = new Rule(1624, false, true, 1453, "1624: _1410 -> (TSTEQ I8 _11 _11)", null, null, null, 0L, false, false, new int[]{54, 54}, null);
        CodeGenerator_x86simd.rulev[1630] = new Rule(1630, false, true, 1459, "1630: _1416 -> (TSTEQ I8 _13 _13)", null, null, null, 0L, false, false, new int[]{56, 56}, null);
        CodeGenerator_x86simd.rulev[1636] = new Rule(1636, false, true, 1465, "1636: _1422 -> (TSTEQ I8 _15 _15)", null, null, null, 0L, false, false, new int[]{58, 58}, null);
        CodeGenerator_x86simd.rulev[1642] = new Rule(1642, false, true, 1471, "1642: _1428 -> (TSTEQ I8 _18 _18)", null, null, null, 0L, false, false, new int[]{61, 61}, null);
        CodeGenerator_x86simd.rulev[1648] = new Rule(1648, false, true, 1477, "1648: _1434 -> (TSTEQ I8 _21 _21)", null, null, null, 0L, false, false, new int[]{64, 64}, null);
        CodeGenerator_x86simd.rulev[1654] = new Rule(1654, false, true, 1483, "1654: _1440 -> (TSTEQ I8 _24 _24)", null, null, null, 0L, false, false, new int[]{67, 67}, null);
        CodeGenerator_x86simd.rulev[1660] = new Rule(1660, false, true, 1489, "1660: _1446 -> (TSTEQ I8 _26 _26)", null, null, null, 0L, false, false, new int[]{69, 69}, null);
        CodeGenerator_x86simd.rulev[1666] = new Rule(1666, false, true, 1495, "1666: _1452 -> (TSTEQ I8 _29 _29)", null, null, null, 0L, false, false, new int[]{72, 72}, null);
        CodeGenerator_x86simd.rulev[1672] = new Rule(1672, false, true, 1501, "1672: _1458 -> (TSTEQ I8 _32 _32)", null, null, null, 0L, false, false, new int[]{75, 75}, null);
        CodeGenerator_x86simd.rulev[1678] = new Rule(1678, false, true, 1507, "1678: _1464 -> (TSTEQ I8 _35 _35)", null, null, null, 0L, false, false, new int[]{78, 78}, null);
        CodeGenerator_x86simd.rulev[1684] = new Rule(1684, false, true, 1513, "1684: _1470 -> (TSTEQ I8 _38 _38)", null, null, null, 0L, false, false, new int[]{81, 81}, null);
        CodeGenerator_x86simd.rulev[1690] = new Rule(1690, false, true, 1519, "1690: _1476 -> (TSTEQ I8 _41 _41)", null, null, null, 0L, false, false, new int[]{84, 84}, null);
        CodeGenerator_x86simd.rulev[1696] = new Rule(1696, false, true, 1525, "1696: _1482 -> (TSTEQ I8 _44 _44)", null, null, null, 0L, false, false, new int[]{87, 87}, null);
        CodeGenerator_x86simd.rulev[1702] = new Rule(1702, false, true, 1531, "1702: _1488 -> (TSTEQ I8 _47 _47)", null, null, null, 0L, false, false, new int[]{90, 90}, null);
        CodeGenerator_x86simd.rulev[4080] = new Rule(4080, false, false, 7, "4080: regb -> (TSTEQ I8 regb mregb)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("movb", ImList.list("imm", "0"), "$0"), ImList.list("movb", ImList.list("imm", "255"), "%al"), ImList.list("seteb", "%al", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{7, 45}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[1536] = new Rule(1536, false, true, 1369, "1536: _1326 -> (TSTEQ I16 _117 _117)", null, null, null, 0L, false, false, new int[]{160, 160}, null);
        CodeGenerator_x86simd.rulev[1542] = new Rule(1542, false, true, 1375, "1542: _1332 -> (TSTEQ I16 _119 _119)", null, null, null, 0L, false, false, new int[]{162, 162}, null);
        CodeGenerator_x86simd.rulev[1548] = new Rule(1548, false, true, 1381, "1548: _1338 -> (TSTEQ I16 _121 _121)", null, null, null, 0L, false, false, new int[]{164, 164}, null);
        CodeGenerator_x86simd.rulev[1554] = new Rule(1554, false, true, 1387, "1554: _1344 -> (TSTEQ I16 _123 _123)", null, null, null, 0L, false, false, new int[]{166, 166}, null);
        CodeGenerator_x86simd.rulev[1806] = new Rule(1806, false, true, 1633, "1806: _1590 -> (TSTEQ I16 _49 _49)", null, null, null, 0L, false, false, new int[]{92, 92}, null);
        CodeGenerator_x86simd.rulev[1812] = new Rule(1812, false, true, 1639, "1812: _1596 -> (TSTEQ I16 _51 _51)", null, null, null, 0L, false, false, new int[]{94, 94}, null);
        CodeGenerator_x86simd.rulev[1818] = new Rule(1818, false, true, 1645, "1818: _1602 -> (TSTEQ I16 _53 _53)", null, null, null, 0L, false, false, new int[]{96, 96}, null);
        CodeGenerator_x86simd.rulev[1824] = new Rule(1824, false, true, 1651, "1824: _1608 -> (TSTEQ I16 _55 _55)", null, null, null, 0L, false, false, new int[]{98, 98}, null);
        CodeGenerator_x86simd.rulev[1830] = new Rule(1830, false, true, 1657, "1830: _1614 -> (TSTEQ I16 _57 _57)", null, null, null, 0L, false, false, new int[]{100, 100}, null);
        CodeGenerator_x86simd.rulev[1836] = new Rule(1836, false, true, 1663, "1836: _1620 -> (TSTEQ I16 _59 _59)", null, null, null, 0L, false, false, new int[]{102, 102}, null);
        CodeGenerator_x86simd.rulev[1842] = new Rule(1842, false, true, 1669, "1842: _1626 -> (TSTEQ I16 _61 _61)", null, null, null, 0L, false, false, new int[]{104, 104}, null);
        CodeGenerator_x86simd.rulev[1848] = new Rule(1848, false, true, 1675, "1848: _1632 -> (TSTEQ I16 _63 _63)", null, null, null, 0L, false, false, new int[]{106, 106}, null);
        CodeGenerator_x86simd.rulev[4070] = new Rule(4070, false, false, 6, "4070: regw -> (TSTEQ I16 regw mregw)", ImList.list(ImList.list("cmpw", "$2", "$1"), ImList.list("movw", ImList.list("imm", "0"), "$0"), ImList.list("movw", ImList.list("imm", "65535"), "%ax"), ImList.list("cmovew", "%ax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{6, 43}, new String[]{"*reg-I16*", "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[1586] = new Rule(1586, false, true, 1417, "1586: _1374 -> (TSTEQ I32 _125 _125)", null, null, null, 0L, false, false, new int[]{168, 168}, null);
        CodeGenerator_x86simd.rulev[1592] = new Rule(1592, false, true, 1423, "1592: _1380 -> (TSTEQ I32 _127 _127)", null, null, null, 0L, false, false, new int[]{170, 170}, null);
        CodeGenerator_x86simd.rulev[1904] = new Rule(1904, false, true, 1729, "1904: _1686 -> (TSTEQ I32 _65 _65)", null, null, null, 0L, false, false, new int[]{108, 108}, null);
        CodeGenerator_x86simd.rulev[1910] = new Rule(1910, false, true, 1735, "1910: _1692 -> (TSTEQ I32 _67 _67)", null, null, null, 0L, false, false, new int[]{110, 110}, null);
        CodeGenerator_x86simd.rulev[1916] = new Rule(1916, false, true, 1741, "1916: _1698 -> (TSTEQ I32 _69 _69)", null, null, null, 0L, false, false, new int[]{112, 112}, null);
        CodeGenerator_x86simd.rulev[1922] = new Rule(1922, false, true, 1747, "1922: _1704 -> (TSTEQ I32 _71 _71)", null, null, null, 0L, false, false, new int[]{114, 114}, null);
        CodeGenerator_x86simd.rulev[4060] = new Rule(4060, false, false, 4, "4060: regl -> (TSTEQ I32 regl mregl)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("movl", ImList.list("imm", "0"), "$0"), ImList.list("movl", ImList.list("imm", "4294967295"), "%eax"), ImList.list("cmovel", "%eax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{4, 41}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4143] = new Rule(4143, false, true, 3651, "4143: _3605 -> (TSTEQ I32 regq mrcq)", null, null, null, 0L, false, false, new int[]{3, 47}, null);
        CodeGenerator_x86simd.rulev[4163] = new Rule(4163, false, true, 3661, "4163: _3615 -> (TSTEQ I32 regl mrcl)", null, null, null, 0L, false, false, new int[]{4, 40}, null);
        CodeGenerator_x86simd.rulev[4185] = new Rule(4185, false, true, 3673, "4185: _3627 -> (TSTEQ I32 _3625 _3626)", null, null, null, 0L, false, false, new int[]{3671, 3672}, null);
        CodeGenerator_x86simd.rulev[4207] = new Rule(4207, false, true, 3685, "4207: _3639 -> (TSTEQ I32 _3637 _3638)", null, null, null, 0L, false, false, new int[]{3683, 3684}, null);
        CodeGenerator_x86simd.rulev[4227] = new Rule(4227, false, true, 3695, "4227: _3649 -> (TSTEQ I32 mrcl regl)", null, null, null, 0L, false, false, new int[]{40, 4}, null);
        CodeGenerator_x86simd.rulev[4247] = new Rule(4247, false, true, 3705, "4247: _3659 -> (TSTEQ I32 _3626 _3625)", null, null, null, 0L, false, false, new int[]{3672, 3671}, null);
        CodeGenerator_x86simd.rulev[4267] = new Rule(4267, false, true, 3715, "4267: _3669 -> (TSTEQ I32 _3638 _3637)", null, null, null, 0L, false, false, new int[]{3684, 3683}, null);
        CodeGenerator_x86simd.rulev[4287] = new Rule(4287, false, true, 3725, "4287: _3679 -> (TSTEQ I32 regd regmemd)", null, null, null, 0L, false, false, new int[]{9, 3645}, null);
        CodeGenerator_x86simd.rulev[4291] = new Rule(4291, false, true, 3727, "4291: _3681 -> (TSTEQ I32 regf regmemf)", null, null, null, 0L, false, false, new int[]{8, 3646}, null);
        CodeGenerator_x86simd.rulev[1954] = new Rule(1954, false, true, 1777, "1954: _1734 -> (TSTNE I8 _101 _101)", null, null, null, 0L, false, false, new int[]{144, 144}, null);
        CodeGenerator_x86simd.rulev[1960] = new Rule(1960, false, true, 1783, "1960: _1740 -> (TSTNE I8 _103 _103)", null, null, null, 0L, false, false, new int[]{146, 146}, null);
        CodeGenerator_x86simd.rulev[1966] = new Rule(1966, false, true, 1789, "1966: _1746 -> (TSTNE I8 _105 _105)", null, null, null, 0L, false, false, new int[]{148, 148}, null);
        CodeGenerator_x86simd.rulev[1972] = new Rule(1972, false, true, 1795, "1972: _1752 -> (TSTNE I8 _107 _107)", null, null, null, 0L, false, false, new int[]{150, 150}, null);
        CodeGenerator_x86simd.rulev[1978] = new Rule(1978, false, true, 1801, "1978: _1758 -> (TSTNE I8 _109 _109)", null, null, null, 0L, false, false, new int[]{152, 152}, null);
        CodeGenerator_x86simd.rulev[1984] = new Rule(1984, false, true, 1807, "1984: _1764 -> (TSTNE I8 _111 _111)", null, null, null, 0L, false, false, new int[]{154, 154}, null);
        CodeGenerator_x86simd.rulev[1990] = new Rule(1990, false, true, 1813, "1990: _1770 -> (TSTNE I8 _113 _113)", null, null, null, 0L, false, false, new int[]{156, 156}, null);
        CodeGenerator_x86simd.rulev[1996] = new Rule(1996, false, true, 1819, "1996: _1776 -> (TSTNE I8 _115 _115)", null, null, null, 0L, false, false, new int[]{158, 158}, null);
        CodeGenerator_x86simd.rulev[2112] = new Rule(2112, false, true, 1929, "2112: _1886 -> (TSTNE I8 _7 _7)", null, null, null, 0L, false, false, new int[]{50, 50}, null);
        CodeGenerator_x86simd.rulev[2118] = new Rule(2118, false, true, 1935, "2118: _1892 -> (TSTNE I8 _9 _9)", null, null, null, 0L, false, false, new int[]{52, 52}, null);
        CodeGenerator_x86simd.rulev[2124] = new Rule(2124, false, true, 1941, "2124: _1898 -> (TSTNE I8 _11 _11)", null, null, null, 0L, false, false, new int[]{54, 54}, null);
        CodeGenerator_x86simd.rulev[2130] = new Rule(2130, false, true, 1947, "2130: _1904 -> (TSTNE I8 _13 _13)", null, null, null, 0L, false, false, new int[]{56, 56}, null);
        CodeGenerator_x86simd.rulev[2136] = new Rule(2136, false, true, 1953, "2136: _1910 -> (TSTNE I8 _15 _15)", null, null, null, 0L, false, false, new int[]{58, 58}, null);
        CodeGenerator_x86simd.rulev[2142] = new Rule(2142, false, true, 1959, "2142: _1916 -> (TSTNE I8 _18 _18)", null, null, null, 0L, false, false, new int[]{61, 61}, null);
        CodeGenerator_x86simd.rulev[2148] = new Rule(2148, false, true, 1965, "2148: _1922 -> (TSTNE I8 _21 _21)", null, null, null, 0L, false, false, new int[]{64, 64}, null);
        CodeGenerator_x86simd.rulev[2154] = new Rule(2154, false, true, 1971, "2154: _1928 -> (TSTNE I8 _24 _24)", null, null, null, 0L, false, false, new int[]{67, 67}, null);
        CodeGenerator_x86simd.rulev[2160] = new Rule(2160, false, true, 1977, "2160: _1934 -> (TSTNE I8 _26 _26)", null, null, null, 0L, false, false, new int[]{69, 69}, null);
        CodeGenerator_x86simd.rulev[2166] = new Rule(2166, false, true, 1983, "2166: _1940 -> (TSTNE I8 _29 _29)", null, null, null, 0L, false, false, new int[]{72, 72}, null);
        CodeGenerator_x86simd.rulev[2172] = new Rule(2172, false, true, 1989, "2172: _1946 -> (TSTNE I8 _32 _32)", null, null, null, 0L, false, false, new int[]{75, 75}, null);
        CodeGenerator_x86simd.rulev[2178] = new Rule(2178, false, true, 1995, "2178: _1952 -> (TSTNE I8 _35 _35)", null, null, null, 0L, false, false, new int[]{78, 78}, null);
        CodeGenerator_x86simd.rulev[2184] = new Rule(2184, false, true, 2001, "2184: _1958 -> (TSTNE I8 _38 _38)", null, null, null, 0L, false, false, new int[]{81, 81}, null);
        CodeGenerator_x86simd.rulev[2190] = new Rule(2190, false, true, 2007, "2190: _1964 -> (TSTNE I8 _41 _41)", null, null, null, 0L, false, false, new int[]{84, 84}, null);
        CodeGenerator_x86simd.rulev[2196] = new Rule(2196, false, true, 2013, "2196: _1970 -> (TSTNE I8 _44 _44)", null, null, null, 0L, false, false, new int[]{87, 87}, null);
        CodeGenerator_x86simd.rulev[2202] = new Rule(2202, false, true, 2019, "2202: _1976 -> (TSTNE I8 _47 _47)", null, null, null, 0L, false, false, new int[]{90, 90}, null);
        CodeGenerator_x86simd.rulev[4081] = new Rule(4081, false, false, 7, "4081: regb -> (TSTNE I8 regb mregb)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("movb", ImList.list("imm", "0"), "$0"), ImList.list("movb", ImList.list("imm", "255"), "%al"), ImList.list("setneb", "%al", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{7, 45}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[2036] = new Rule(2036, false, true, 1857, "2036: _1814 -> (TSTNE I16 _117 _117)", null, null, null, 0L, false, false, new int[]{160, 160}, null);
        CodeGenerator_x86simd.rulev[2042] = new Rule(2042, false, true, 1863, "2042: _1820 -> (TSTNE I16 _119 _119)", null, null, null, 0L, false, false, new int[]{162, 162}, null);
        CodeGenerator_x86simd.rulev[2048] = new Rule(2048, false, true, 1869, "2048: _1826 -> (TSTNE I16 _121 _121)", null, null, null, 0L, false, false, new int[]{164, 164}, null);
    }

    private static void rrinit2500() {
        CodeGenerator_x86simd.rulev[2054] = new Rule(2054, false, true, 1875, "2054: _1832 -> (TSTNE I16 _123 _123)", null, null, null, 0L, false, false, new int[]{166, 166}, null);
        CodeGenerator_x86simd.rulev[2274] = new Rule(2274, false, true, 2089, "2274: _2046 -> (TSTNE I16 _49 _49)", null, null, null, 0L, false, false, new int[]{92, 92}, null);
        CodeGenerator_x86simd.rulev[2280] = new Rule(2280, false, true, 2095, "2280: _2052 -> (TSTNE I16 _51 _51)", null, null, null, 0L, false, false, new int[]{94, 94}, null);
        CodeGenerator_x86simd.rulev[2286] = new Rule(2286, false, true, 2101, "2286: _2058 -> (TSTNE I16 _53 _53)", null, null, null, 0L, false, false, new int[]{96, 96}, null);
        CodeGenerator_x86simd.rulev[2292] = new Rule(2292, false, true, 2107, "2292: _2064 -> (TSTNE I16 _55 _55)", null, null, null, 0L, false, false, new int[]{98, 98}, null);
        CodeGenerator_x86simd.rulev[2298] = new Rule(2298, false, true, 2113, "2298: _2070 -> (TSTNE I16 _57 _57)", null, null, null, 0L, false, false, new int[]{100, 100}, null);
        CodeGenerator_x86simd.rulev[2304] = new Rule(2304, false, true, 2119, "2304: _2076 -> (TSTNE I16 _59 _59)", null, null, null, 0L, false, false, new int[]{102, 102}, null);
        CodeGenerator_x86simd.rulev[2310] = new Rule(2310, false, true, 2125, "2310: _2082 -> (TSTNE I16 _61 _61)", null, null, null, 0L, false, false, new int[]{104, 104}, null);
        CodeGenerator_x86simd.rulev[2316] = new Rule(2316, false, true, 2131, "2316: _2088 -> (TSTNE I16 _63 _63)", null, null, null, 0L, false, false, new int[]{106, 106}, null);
        CodeGenerator_x86simd.rulev[4071] = new Rule(4071, false, false, 6, "4071: regw -> (TSTNE I16 regw mregw)", ImList.list(ImList.list("cmpw", "$2", "$1"), ImList.list("movw", ImList.list("imm", "0"), "$0"), ImList.list("movw", ImList.list("imm", "65535"), "%ax"), ImList.list("cmovnew", "%ax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{6, 43}, new String[]{"*reg-I16*", "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[2086] = new Rule(2086, false, true, 1905, "2086: _1862 -> (TSTNE I32 _125 _125)", null, null, null, 0L, false, false, new int[]{168, 168}, null);
        CodeGenerator_x86simd.rulev[2092] = new Rule(2092, false, true, 1911, "2092: _1868 -> (TSTNE I32 _127 _127)", null, null, null, 0L, false, false, new int[]{170, 170}, null);
        CodeGenerator_x86simd.rulev[2372] = new Rule(2372, false, true, 2185, "2372: _2142 -> (TSTNE I32 _65 _65)", null, null, null, 0L, false, false, new int[]{108, 108}, null);
        CodeGenerator_x86simd.rulev[2378] = new Rule(2378, false, true, 2191, "2378: _2148 -> (TSTNE I32 _67 _67)", null, null, null, 0L, false, false, new int[]{110, 110}, null);
        CodeGenerator_x86simd.rulev[2384] = new Rule(2384, false, true, 2197, "2384: _2154 -> (TSTNE I32 _69 _69)", null, null, null, 0L, false, false, new int[]{112, 112}, null);
        CodeGenerator_x86simd.rulev[2390] = new Rule(2390, false, true, 2203, "2390: _2160 -> (TSTNE I32 _71 _71)", null, null, null, 0L, false, false, new int[]{114, 114}, null);
        CodeGenerator_x86simd.rulev[4061] = new Rule(4061, false, false, 4, "4061: regl -> (TSTNE I32 regl mregl)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("movl", ImList.list("imm", "0"), "$0"), ImList.list("movl", ImList.list("imm", "4294967295"), "%eax"), ImList.list("cmovnel", "%eax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{4, 41}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4145] = new Rule(4145, false, true, 3652, "4145: _3606 -> (TSTNE I32 regq mrcq)", null, null, null, 0L, false, false, new int[]{3, 47}, null);
        CodeGenerator_x86simd.rulev[4165] = new Rule(4165, false, true, 3662, "4165: _3616 -> (TSTNE I32 regl mrcl)", null, null, null, 0L, false, false, new int[]{4, 40}, null);
        CodeGenerator_x86simd.rulev[4187] = new Rule(4187, false, true, 3674, "4187: _3628 -> (TSTNE I32 _3625 _3626)", null, null, null, 0L, false, false, new int[]{3671, 3672}, null);
        CodeGenerator_x86simd.rulev[4209] = new Rule(4209, false, true, 3686, "4209: _3640 -> (TSTNE I32 _3637 _3638)", null, null, null, 0L, false, false, new int[]{3683, 3684}, null);
        CodeGenerator_x86simd.rulev[4229] = new Rule(4229, false, true, 3696, "4229: _3650 -> (TSTNE I32 mrcl regl)", null, null, null, 0L, false, false, new int[]{40, 4}, null);
        CodeGenerator_x86simd.rulev[4249] = new Rule(4249, false, true, 3706, "4249: _3660 -> (TSTNE I32 _3626 _3625)", null, null, null, 0L, false, false, new int[]{3672, 3671}, null);
        CodeGenerator_x86simd.rulev[4269] = new Rule(4269, false, true, 3716, "4269: _3670 -> (TSTNE I32 _3638 _3637)", null, null, null, 0L, false, false, new int[]{3684, 3683}, null);
        CodeGenerator_x86simd.rulev[4289] = new Rule(4289, false, true, 3726, "4289: _3680 -> (TSTNE I32 regd regmemd)", null, null, null, 0L, false, false, new int[]{9, 3645}, null);
        CodeGenerator_x86simd.rulev[4293] = new Rule(4293, false, true, 3728, "4293: _3682 -> (TSTNE I32 regf regmemf)", null, null, null, 0L, false, false, new int[]{8, 3646}, null);
        CodeGenerator_x86simd.rulev[2656] = new Rule(2656, false, true, 2461, "2656: _2418 -> (TSTLTS I8 _101 _101)", null, null, null, 0L, false, false, new int[]{144, 144}, null);
        CodeGenerator_x86simd.rulev[2662] = new Rule(2662, false, true, 2467, "2662: _2424 -> (TSTLTS I8 _103 _103)", null, null, null, 0L, false, false, new int[]{146, 146}, null);
        CodeGenerator_x86simd.rulev[2668] = new Rule(2668, false, true, 2473, "2668: _2430 -> (TSTLTS I8 _105 _105)", null, null, null, 0L, false, false, new int[]{148, 148}, null);
        CodeGenerator_x86simd.rulev[2674] = new Rule(2674, false, true, 2479, "2674: _2436 -> (TSTLTS I8 _107 _107)", null, null, null, 0L, false, false, new int[]{150, 150}, null);
        CodeGenerator_x86simd.rulev[2680] = new Rule(2680, false, true, 2485, "2680: _2442 -> (TSTLTS I8 _109 _109)", null, null, null, 0L, false, false, new int[]{152, 152}, null);
        CodeGenerator_x86simd.rulev[2686] = new Rule(2686, false, true, 2491, "2686: _2448 -> (TSTLTS I8 _111 _111)", null, null, null, 0L, false, false, new int[]{154, 154}, null);
        CodeGenerator_x86simd.rulev[2692] = new Rule(2692, false, true, 2497, "2692: _2454 -> (TSTLTS I8 _113 _113)", null, null, null, 0L, false, false, new int[]{156, 156}, null);
        CodeGenerator_x86simd.rulev[2698] = new Rule(2698, false, true, 2503, "2698: _2460 -> (TSTLTS I8 _115 _115)", null, null, null, 0L, false, false, new int[]{158, 158}, null);
        CodeGenerator_x86simd.rulev[2735] = new Rule(2735, false, true, 2537, "2735: _2494 -> (TSTLTS I8 _7 _7)", null, null, null, 0L, false, false, new int[]{50, 50}, null);
        CodeGenerator_x86simd.rulev[2741] = new Rule(2741, false, true, 2543, "2741: _2500 -> (TSTLTS I8 _9 _9)", null, null, null, 0L, false, false, new int[]{52, 52}, null);
        CodeGenerator_x86simd.rulev[2747] = new Rule(2747, false, true, 2549, "2747: _2506 -> (TSTLTS I8 _11 _11)", null, null, null, 0L, false, false, new int[]{54, 54}, null);
        CodeGenerator_x86simd.rulev[2753] = new Rule(2753, false, true, 2555, "2753: _2512 -> (TSTLTS I8 _13 _13)", null, null, null, 0L, false, false, new int[]{56, 56}, null);
        CodeGenerator_x86simd.rulev[2759] = new Rule(2759, false, true, 2561, "2759: _2518 -> (TSTLTS I8 _15 _15)", null, null, null, 0L, false, false, new int[]{58, 58}, null);
        CodeGenerator_x86simd.rulev[2765] = new Rule(2765, false, true, 2567, "2765: _2524 -> (TSTLTS I8 _18 _18)", null, null, null, 0L, false, false, new int[]{61, 61}, null);
        CodeGenerator_x86simd.rulev[2771] = new Rule(2771, false, true, 2573, "2771: _2530 -> (TSTLTS I8 _21 _21)", null, null, null, 0L, false, false, new int[]{64, 64}, null);
        CodeGenerator_x86simd.rulev[2777] = new Rule(2777, false, true, 2579, "2777: _2536 -> (TSTLTS I8 _24 _24)", null, null, null, 0L, false, false, new int[]{67, 67}, null);
        CodeGenerator_x86simd.rulev[2783] = new Rule(2783, false, true, 2585, "2783: _2542 -> (TSTLTS I8 _26 _26)", null, null, null, 0L, false, false, new int[]{69, 69}, null);
        CodeGenerator_x86simd.rulev[2789] = new Rule(2789, false, true, 2591, "2789: _2548 -> (TSTLTS I8 _29 _29)", null, null, null, 0L, false, false, new int[]{72, 72}, null);
        CodeGenerator_x86simd.rulev[2795] = new Rule(2795, false, true, 2597, "2795: _2554 -> (TSTLTS I8 _32 _32)", null, null, null, 0L, false, false, new int[]{75, 75}, null);
        CodeGenerator_x86simd.rulev[2801] = new Rule(2801, false, true, 2603, "2801: _2560 -> (TSTLTS I8 _35 _35)", null, null, null, 0L, false, false, new int[]{78, 78}, null);
        CodeGenerator_x86simd.rulev[2807] = new Rule(2807, false, true, 2609, "2807: _2566 -> (TSTLTS I8 _38 _38)", null, null, null, 0L, false, false, new int[]{81, 81}, null);
        CodeGenerator_x86simd.rulev[2813] = new Rule(2813, false, true, 2615, "2813: _2572 -> (TSTLTS I8 _41 _41)", null, null, null, 0L, false, false, new int[]{84, 84}, null);
        CodeGenerator_x86simd.rulev[2819] = new Rule(2819, false, true, 2621, "2819: _2578 -> (TSTLTS I8 _44 _44)", null, null, null, 0L, false, false, new int[]{87, 87}, null);
        CodeGenerator_x86simd.rulev[2825] = new Rule(2825, false, true, 2627, "2825: _2584 -> (TSTLTS I8 _47 _47)", null, null, null, 0L, false, false, new int[]{90, 90}, null);
        CodeGenerator_x86simd.rulev[4082] = new Rule(4082, false, false, 7, "4082: regb -> (TSTLTS I8 regb mregb)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("movb", ImList.list("imm", "0"), "$0"), ImList.list("movb", ImList.list("imm", "255"), "%al"), ImList.list("setlb", "%al", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{7, 45}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[1315] = new Rule(1315, false, true, 1153, "1315: _1110 -> (TSTLTS I16 _117 _117)", null, null, null, 0L, false, false, new int[]{160, 160}, null);
        CodeGenerator_x86simd.rulev[1321] = new Rule(1321, false, true, 1159, "1321: _1116 -> (TSTLTS I16 _119 _119)", null, null, null, 0L, false, false, new int[]{162, 162}, null);
        CodeGenerator_x86simd.rulev[1327] = new Rule(1327, false, true, 1165, "1327: _1122 -> (TSTLTS I16 _121 _121)", null, null, null, 0L, false, false, new int[]{164, 164}, null);
        CodeGenerator_x86simd.rulev[1333] = new Rule(1333, false, true, 1171, "1333: _1128 -> (TSTLTS I16 _123 _123)", null, null, null, 0L, false, false, new int[]{166, 166}, null);
        CodeGenerator_x86simd.rulev[1389] = new Rule(1389, false, true, 1225, "1389: _1182 -> (TSTLTS I16 _49 _49)", null, null, null, 0L, false, false, new int[]{92, 92}, null);
        CodeGenerator_x86simd.rulev[1395] = new Rule(1395, false, true, 1231, "1395: _1188 -> (TSTLTS I16 _51 _51)", null, null, null, 0L, false, false, new int[]{94, 94}, null);
        CodeGenerator_x86simd.rulev[1401] = new Rule(1401, false, true, 1237, "1401: _1194 -> (TSTLTS I16 _53 _53)", null, null, null, 0L, false, false, new int[]{96, 96}, null);
        CodeGenerator_x86simd.rulev[1407] = new Rule(1407, false, true, 1243, "1407: _1200 -> (TSTLTS I16 _55 _55)", null, null, null, 0L, false, false, new int[]{98, 98}, null);
        CodeGenerator_x86simd.rulev[1413] = new Rule(1413, false, true, 1249, "1413: _1206 -> (TSTLTS I16 _57 _57)", null, null, null, 0L, false, false, new int[]{100, 100}, null);
        CodeGenerator_x86simd.rulev[1419] = new Rule(1419, false, true, 1255, "1419: _1212 -> (TSTLTS I16 _59 _59)", null, null, null, 0L, false, false, new int[]{102, 102}, null);
        CodeGenerator_x86simd.rulev[1425] = new Rule(1425, false, true, 1261, "1425: _1218 -> (TSTLTS I16 _61 _61)", null, null, null, 0L, false, false, new int[]{104, 104}, null);
        CodeGenerator_x86simd.rulev[1431] = new Rule(1431, false, true, 1267, "1431: _1224 -> (TSTLTS I16 _63 _63)", null, null, null, 0L, false, false, new int[]{106, 106}, null);
        CodeGenerator_x86simd.rulev[4072] = new Rule(4072, false, false, 6, "4072: regw -> (TSTLTS I16 regw mregw)", ImList.list(ImList.list("cmpw", "$2", "$1"), ImList.list("movw", ImList.list("imm", "0"), "$0"), ImList.list("movw", ImList.list("imm", "65535"), "%ax"), ImList.list("cmovlw", "%ax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{6, 43}, new String[]{"*reg-I16*", "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[2722] = new Rule(2722, false, true, 2525, "2722: _2482 -> (TSTLTS I32 _125 _125)", null, null, null, 0L, false, false, new int[]{168, 168}, null);
        CodeGenerator_x86simd.rulev[2728] = new Rule(2728, false, true, 2531, "2728: _2488 -> (TSTLTS I32 _127 _127)", null, null, null, 0L, false, false, new int[]{170, 170}, null);
        CodeGenerator_x86simd.rulev[2865] = new Rule(2865, false, true, 2665, "2865: _2622 -> (TSTLTS I32 _65 _65)", null, null, null, 0L, false, false, new int[]{108, 108}, null);
        CodeGenerator_x86simd.rulev[2871] = new Rule(2871, false, true, 2671, "2871: _2628 -> (TSTLTS I32 _67 _67)", null, null, null, 0L, false, false, new int[]{110, 110}, null);
        CodeGenerator_x86simd.rulev[2877] = new Rule(2877, false, true, 2677, "2877: _2634 -> (TSTLTS I32 _69 _69)", null, null, null, 0L, false, false, new int[]{112, 112}, null);
        CodeGenerator_x86simd.rulev[2883] = new Rule(2883, false, true, 2683, "2883: _2640 -> (TSTLTS I32 _71 _71)", null, null, null, 0L, false, false, new int[]{114, 114}, null);
        CodeGenerator_x86simd.rulev[4062] = new Rule(4062, false, false, 4, "4062: regl -> (TSTLTS I32 regl mregl)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("movl", ImList.list("imm", "0"), "$0"), ImList.list("movl", ImList.list("imm", "4294967295"), "%eax"), ImList.list("cmovll", "%eax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{4, 41}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4147] = new Rule(4147, false, true, 3653, "4147: _3607 -> (TSTLTS I32 regq mrcq)", null, null, null, 0L, false, false, new int[]{3, 47}, null);
        CodeGenerator_x86simd.rulev[4167] = new Rule(4167, false, true, 3663, "4167: _3617 -> (TSTLTS I32 regl mrcl)", null, null, null, 0L, false, false, new int[]{4, 40}, null);
        CodeGenerator_x86simd.rulev[4189] = new Rule(4189, false, true, 3675, "4189: _3629 -> (TSTLTS I32 _3625 _3626)", null, null, null, 0L, false, false, new int[]{3671, 3672}, null);
        CodeGenerator_x86simd.rulev[4211] = new Rule(4211, false, true, 3687, "4211: _3641 -> (TSTLTS I32 _3637 _3638)", null, null, null, 0L, false, false, new int[]{3683, 3684}, null);
        CodeGenerator_x86simd.rulev[4231] = new Rule(4231, false, true, 3697, "4231: _3651 -> (TSTLTS I32 mrcl regl)", null, null, null, 0L, false, false, new int[]{40, 4}, null);
        CodeGenerator_x86simd.rulev[4251] = new Rule(4251, false, true, 3707, "4251: _3661 -> (TSTLTS I32 _3626 _3625)", null, null, null, 0L, false, false, new int[]{3672, 3671}, null);
        CodeGenerator_x86simd.rulev[4271] = new Rule(4271, false, true, 3717, "4271: _3671 -> (TSTLTS I32 _3638 _3637)", null, null, null, 0L, false, false, new int[]{3684, 3683}, null);
        CodeGenerator_x86simd.rulev[4295] = new Rule(4295, false, true, 3729, "4295: _3683 -> (TSTLTS I32 regd regmemd)", null, null, null, 0L, false, false, new int[]{9, 3645}, null);
        CodeGenerator_x86simd.rulev[4299] = new Rule(4299, false, true, 3731, "4299: _3685 -> (TSTLTS I32 regf regmemf)", null, null, null, 0L, false, false, new int[]{8, 3646}, null);
        CodeGenerator_x86simd.rulev[460] = new Rule(460, false, true, 313, "460: _270 -> (TSTLES I8 _101 _101)", null, null, null, 0L, false, false, new int[]{144, 144}, null);
        CodeGenerator_x86simd.rulev[466] = new Rule(466, false, true, 319, "466: _276 -> (TSTLES I8 _103 _103)", null, null, null, 0L, false, false, new int[]{146, 146}, null);
        CodeGenerator_x86simd.rulev[473] = new Rule(473, false, true, 326, "473: _283 -> (TSTLES I8 _105 _105)", null, null, null, 0L, false, false, new int[]{148, 148}, null);
        CodeGenerator_x86simd.rulev[480] = new Rule(480, false, true, 333, "480: _290 -> (TSTLES I8 _107 _107)", null, null, null, 0L, false, false, new int[]{150, 150}, null);
        CodeGenerator_x86simd.rulev[487] = new Rule(487, false, true, 340, "487: _297 -> (TSTLES I8 _109 _109)", null, null, null, 0L, false, false, new int[]{152, 152}, null);
        CodeGenerator_x86simd.rulev[494] = new Rule(494, false, true, 347, "494: _304 -> (TSTLES I8 _111 _111)", null, null, null, 0L, false, false, new int[]{154, 154}, null);
        CodeGenerator_x86simd.rulev[501] = new Rule(501, false, true, 354, "501: _311 -> (TSTLES I8 _113 _113)", null, null, null, 0L, false, false, new int[]{156, 156}, null);
        CodeGenerator_x86simd.rulev[508] = new Rule(508, false, true, 361, "508: _318 -> (TSTLES I8 _115 _115)", null, null, null, 0L, false, false, new int[]{158, 158}, null);
        CodeGenerator_x86simd.rulev[516] = new Rule(516, false, true, 368, "516: _325 -> (TSTLES I8 _7 _7)", null, null, null, 0L, false, false, new int[]{50, 50}, null);
        CodeGenerator_x86simd.rulev[522] = new Rule(522, false, true, 374, "522: _331 -> (TSTLES I8 _9 _9)", null, null, null, 0L, false, false, new int[]{52, 52}, null);
        CodeGenerator_x86simd.rulev[529] = new Rule(529, false, true, 381, "529: _338 -> (TSTLES I8 _11 _11)", null, null, null, 0L, false, false, new int[]{54, 54}, null);
        CodeGenerator_x86simd.rulev[536] = new Rule(536, false, true, 388, "536: _345 -> (TSTLES I8 _13 _13)", null, null, null, 0L, false, false, new int[]{56, 56}, null);
        CodeGenerator_x86simd.rulev[543] = new Rule(543, false, true, 395, "543: _352 -> (TSTLES I8 _15 _15)", null, null, null, 0L, false, false, new int[]{58, 58}, null);
        CodeGenerator_x86simd.rulev[550] = new Rule(550, false, true, 402, "550: _359 -> (TSTLES I8 _18 _18)", null, null, null, 0L, false, false, new int[]{61, 61}, null);
        CodeGenerator_x86simd.rulev[557] = new Rule(557, false, true, 409, "557: _366 -> (TSTLES I8 _21 _21)", null, null, null, 0L, false, false, new int[]{64, 64}, null);
        CodeGenerator_x86simd.rulev[564] = new Rule(564, false, true, 416, "564: _373 -> (TSTLES I8 _24 _24)", null, null, null, 0L, false, false, new int[]{67, 67}, null);
        CodeGenerator_x86simd.rulev[572] = new Rule(572, false, true, 424, "572: _381 -> (TSTLES I8 _26 _26)", null, null, null, 0L, false, false, new int[]{69, 69}, null);
        CodeGenerator_x86simd.rulev[578] = new Rule(578, false, true, 430, "578: _387 -> (TSTLES I8 _29 _29)", null, null, null, 0L, false, false, new int[]{72, 72}, null);
        CodeGenerator_x86simd.rulev[585] = new Rule(585, false, true, 437, "585: _394 -> (TSTLES I8 _32 _32)", null, null, null, 0L, false, false, new int[]{75, 75}, null);
        CodeGenerator_x86simd.rulev[592] = new Rule(592, false, true, 444, "592: _401 -> (TSTLES I8 _35 _35)", null, null, null, 0L, false, false, new int[]{78, 78}, null);
    }

    private static void rrinit2600() {
        CodeGenerator_x86simd.rulev[599] = new Rule(599, false, true, 451, "599: _408 -> (TSTLES I8 _38 _38)", null, null, null, 0L, false, false, new int[]{81, 81}, null);
        CodeGenerator_x86simd.rulev[606] = new Rule(606, false, true, 458, "606: _415 -> (TSTLES I8 _41 _41)", null, null, null, 0L, false, false, new int[]{84, 84}, null);
        CodeGenerator_x86simd.rulev[613] = new Rule(613, false, true, 465, "613: _422 -> (TSTLES I8 _44 _44)", null, null, null, 0L, false, false, new int[]{87, 87}, null);
        CodeGenerator_x86simd.rulev[620] = new Rule(620, false, true, 472, "620: _429 -> (TSTLES I8 _47 _47)", null, null, null, 0L, false, false, new int[]{90, 90}, null);
        CodeGenerator_x86simd.rulev[4083] = new Rule(4083, false, false, 7, "4083: regb -> (TSTLES I8 regb mregb)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("movb", ImList.list("imm", "0"), "$0"), ImList.list("movb", ImList.list("imm", "255"), "%al"), ImList.list("setleb", "%al", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{7, 45}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[2061] = new Rule(2061, false, true, 1881, "2061: _1838 -> (TSTLES I16 _117 _117)", null, null, null, 0L, false, false, new int[]{160, 160}, null);
        CodeGenerator_x86simd.rulev[2067] = new Rule(2067, false, true, 1887, "2067: _1844 -> (TSTLES I16 _119 _119)", null, null, null, 0L, false, false, new int[]{162, 162}, null);
        CodeGenerator_x86simd.rulev[2073] = new Rule(2073, false, true, 1893, "2073: _1850 -> (TSTLES I16 _121 _121)", null, null, null, 0L, false, false, new int[]{164, 164}, null);
        CodeGenerator_x86simd.rulev[2079] = new Rule(2079, false, true, 1899, "2079: _1856 -> (TSTLES I16 _123 _123)", null, null, null, 0L, false, false, new int[]{166, 166}, null);
        CodeGenerator_x86simd.rulev[2323] = new Rule(2323, false, true, 2137, "2323: _2094 -> (TSTLES I16 _49 _49)", null, null, null, 0L, false, false, new int[]{92, 92}, null);
        CodeGenerator_x86simd.rulev[2329] = new Rule(2329, false, true, 2143, "2329: _2100 -> (TSTLES I16 _51 _51)", null, null, null, 0L, false, false, new int[]{94, 94}, null);
        CodeGenerator_x86simd.rulev[2335] = new Rule(2335, false, true, 2149, "2335: _2106 -> (TSTLES I16 _53 _53)", null, null, null, 0L, false, false, new int[]{96, 96}, null);
        CodeGenerator_x86simd.rulev[2341] = new Rule(2341, false, true, 2155, "2341: _2112 -> (TSTLES I16 _55 _55)", null, null, null, 0L, false, false, new int[]{98, 98}, null);
        CodeGenerator_x86simd.rulev[2347] = new Rule(2347, false, true, 2161, "2347: _2118 -> (TSTLES I16 _57 _57)", null, null, null, 0L, false, false, new int[]{100, 100}, null);
        CodeGenerator_x86simd.rulev[2353] = new Rule(2353, false, true, 2167, "2353: _2124 -> (TSTLES I16 _59 _59)", null, null, null, 0L, false, false, new int[]{102, 102}, null);
        CodeGenerator_x86simd.rulev[2359] = new Rule(2359, false, true, 2173, "2359: _2130 -> (TSTLES I16 _61 _61)", null, null, null, 0L, false, false, new int[]{104, 104}, null);
        CodeGenerator_x86simd.rulev[2365] = new Rule(2365, false, true, 2179, "2365: _2136 -> (TSTLES I16 _63 _63)", null, null, null, 0L, false, false, new int[]{106, 106}, null);
        CodeGenerator_x86simd.rulev[4073] = new Rule(4073, false, false, 6, "4073: regw -> (TSTLES I16 regw mregw)", ImList.list(ImList.list("cmpw", "$2", "$1"), ImList.list("movw", ImList.list("imm", "0"), "$0"), ImList.list("movw", ImList.list("imm", "65535"), "%ax"), ImList.list("cmovlew", "%ax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{6, 43}, new String[]{"*reg-I16*", "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[2099] = new Rule(2099, false, true, 1917, "2099: _1874 -> (TSTLES I32 _125 _125)", null, null, null, 0L, false, false, new int[]{168, 168}, null);
        CodeGenerator_x86simd.rulev[2105] = new Rule(2105, false, true, 1923, "2105: _1880 -> (TSTLES I32 _127 _127)", null, null, null, 0L, false, false, new int[]{170, 170}, null);
        CodeGenerator_x86simd.rulev[2397] = new Rule(2397, false, true, 2209, "2397: _2166 -> (TSTLES I32 _65 _65)", null, null, null, 0L, false, false, new int[]{108, 108}, null);
        CodeGenerator_x86simd.rulev[2403] = new Rule(2403, false, true, 2215, "2403: _2172 -> (TSTLES I32 _67 _67)", null, null, null, 0L, false, false, new int[]{110, 110}, null);
        CodeGenerator_x86simd.rulev[2409] = new Rule(2409, false, true, 2221, "2409: _2178 -> (TSTLES I32 _69 _69)", null, null, null, 0L, false, false, new int[]{112, 112}, null);
        CodeGenerator_x86simd.rulev[2415] = new Rule(2415, false, true, 2227, "2415: _2184 -> (TSTLES I32 _71 _71)", null, null, null, 0L, false, false, new int[]{114, 114}, null);
        CodeGenerator_x86simd.rulev[4063] = new Rule(4063, false, false, 4, "4063: regl -> (TSTLES I32 regl mregl)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("movl", ImList.list("imm", "0"), "$0"), ImList.list("movl", ImList.list("imm", "4294967295"), "%eax"), ImList.list("cmovlel", "%eax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{4, 41}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4149] = new Rule(4149, false, true, 3654, "4149: _3608 -> (TSTLES I32 regq mrcq)", null, null, null, 0L, false, false, new int[]{3, 47}, null);
        CodeGenerator_x86simd.rulev[4169] = new Rule(4169, false, true, 3664, "4169: _3618 -> (TSTLES I32 regl mrcl)", null, null, null, 0L, false, false, new int[]{4, 40}, null);
        CodeGenerator_x86simd.rulev[4191] = new Rule(4191, false, true, 3676, "4191: _3630 -> (TSTLES I32 _3625 _3626)", null, null, null, 0L, false, false, new int[]{3671, 3672}, null);
        CodeGenerator_x86simd.rulev[4213] = new Rule(4213, false, true, 3688, "4213: _3642 -> (TSTLES I32 _3637 _3638)", null, null, null, 0L, false, false, new int[]{3683, 3684}, null);
        CodeGenerator_x86simd.rulev[4233] = new Rule(4233, false, true, 3698, "4233: _3652 -> (TSTLES I32 mrcl regl)", null, null, null, 0L, false, false, new int[]{40, 4}, null);
        CodeGenerator_x86simd.rulev[4253] = new Rule(4253, false, true, 3708, "4253: _3662 -> (TSTLES I32 _3626 _3625)", null, null, null, 0L, false, false, new int[]{3672, 3671}, null);
        CodeGenerator_x86simd.rulev[4273] = new Rule(4273, false, true, 3718, "4273: _3672 -> (TSTLES I32 _3638 _3637)", null, null, null, 0L, false, false, new int[]{3684, 3683}, null);
        CodeGenerator_x86simd.rulev[4305] = new Rule(4305, false, true, 3734, "4305: _3688 -> (TSTLES I32 regd regmemd)", null, null, null, 0L, false, false, new int[]{9, 3645}, null);
        CodeGenerator_x86simd.rulev[4309] = new Rule(4309, false, true, 3736, "4309: _3690 -> (TSTLES I32 regf regmemf)", null, null, null, 0L, false, false, new int[]{8, 3646}, null);
        CodeGenerator_x86simd.rulev[1487] = new Rule(1487, false, true, 1321, "1487: _1278 -> (TSTGTS I8 _101 _101)", null, null, null, 0L, false, false, new int[]{144, 144}, null);
        CodeGenerator_x86simd.rulev[1493] = new Rule(1493, false, true, 1327, "1493: _1284 -> (TSTGTS I8 _103 _103)", null, null, null, 0L, false, false, new int[]{146, 146}, null);
        CodeGenerator_x86simd.rulev[1499] = new Rule(1499, false, true, 1333, "1499: _1290 -> (TSTGTS I8 _105 _105)", null, null, null, 0L, false, false, new int[]{148, 148}, null);
        CodeGenerator_x86simd.rulev[1505] = new Rule(1505, false, true, 1339, "1505: _1296 -> (TSTGTS I8 _107 _107)", null, null, null, 0L, false, false, new int[]{150, 150}, null);
        CodeGenerator_x86simd.rulev[1511] = new Rule(1511, false, true, 1345, "1511: _1302 -> (TSTGTS I8 _109 _109)", null, null, null, 0L, false, false, new int[]{152, 152}, null);
        CodeGenerator_x86simd.rulev[1517] = new Rule(1517, false, true, 1351, "1517: _1308 -> (TSTGTS I8 _111 _111)", null, null, null, 0L, false, false, new int[]{154, 154}, null);
        CodeGenerator_x86simd.rulev[1523] = new Rule(1523, false, true, 1357, "1523: _1314 -> (TSTGTS I8 _113 _113)", null, null, null, 0L, false, false, new int[]{156, 156}, null);
        CodeGenerator_x86simd.rulev[1529] = new Rule(1529, false, true, 1363, "1529: _1320 -> (TSTGTS I8 _115 _115)", null, null, null, 0L, false, false, new int[]{158, 158}, null);
        CodeGenerator_x86simd.rulev[1709] = new Rule(1709, false, true, 1537, "1709: _1494 -> (TSTGTS I8 _7 _7)", null, null, null, 0L, false, false, new int[]{50, 50}, null);
        CodeGenerator_x86simd.rulev[1715] = new Rule(1715, false, true, 1543, "1715: _1500 -> (TSTGTS I8 _9 _9)", null, null, null, 0L, false, false, new int[]{52, 52}, null);
        CodeGenerator_x86simd.rulev[1721] = new Rule(1721, false, true, 1549, "1721: _1506 -> (TSTGTS I8 _11 _11)", null, null, null, 0L, false, false, new int[]{54, 54}, null);
        CodeGenerator_x86simd.rulev[1727] = new Rule(1727, false, true, 1555, "1727: _1512 -> (TSTGTS I8 _13 _13)", null, null, null, 0L, false, false, new int[]{56, 56}, null);
        CodeGenerator_x86simd.rulev[1733] = new Rule(1733, false, true, 1561, "1733: _1518 -> (TSTGTS I8 _15 _15)", null, null, null, 0L, false, false, new int[]{58, 58}, null);
        CodeGenerator_x86simd.rulev[1739] = new Rule(1739, false, true, 1567, "1739: _1524 -> (TSTGTS I8 _18 _18)", null, null, null, 0L, false, false, new int[]{61, 61}, null);
        CodeGenerator_x86simd.rulev[1745] = new Rule(1745, false, true, 1573, "1745: _1530 -> (TSTGTS I8 _21 _21)", null, null, null, 0L, false, false, new int[]{64, 64}, null);
        CodeGenerator_x86simd.rulev[1751] = new Rule(1751, false, true, 1579, "1751: _1536 -> (TSTGTS I8 _24 _24)", null, null, null, 0L, false, false, new int[]{67, 67}, null);
        CodeGenerator_x86simd.rulev[1757] = new Rule(1757, false, true, 1585, "1757: _1542 -> (TSTGTS I8 _26 _26)", null, null, null, 0L, false, false, new int[]{69, 69}, null);
        CodeGenerator_x86simd.rulev[1763] = new Rule(1763, false, true, 1591, "1763: _1548 -> (TSTGTS I8 _29 _29)", null, null, null, 0L, false, false, new int[]{72, 72}, null);
        CodeGenerator_x86simd.rulev[1769] = new Rule(1769, false, true, 1597, "1769: _1554 -> (TSTGTS I8 _32 _32)", null, null, null, 0L, false, false, new int[]{75, 75}, null);
        CodeGenerator_x86simd.rulev[1775] = new Rule(1775, false, true, 1603, "1775: _1560 -> (TSTGTS I8 _35 _35)", null, null, null, 0L, false, false, new int[]{78, 78}, null);
        CodeGenerator_x86simd.rulev[1781] = new Rule(1781, false, true, 1609, "1781: _1566 -> (TSTGTS I8 _38 _38)", null, null, null, 0L, false, false, new int[]{81, 81}, null);
        CodeGenerator_x86simd.rulev[1787] = new Rule(1787, false, true, 1615, "1787: _1572 -> (TSTGTS I8 _41 _41)", null, null, null, 0L, false, false, new int[]{84, 84}, null);
        CodeGenerator_x86simd.rulev[1793] = new Rule(1793, false, true, 1621, "1793: _1578 -> (TSTGTS I8 _44 _44)", null, null, null, 0L, false, false, new int[]{87, 87}, null);
        CodeGenerator_x86simd.rulev[1799] = new Rule(1799, false, true, 1627, "1799: _1584 -> (TSTGTS I8 _47 _47)", null, null, null, 0L, false, false, new int[]{90, 90}, null);
        CodeGenerator_x86simd.rulev[4084] = new Rule(4084, false, false, 7, "4084: regb -> (TSTGTS I8 regb mregb)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("movb", ImList.list("imm", "0"), "$0"), ImList.list("movb", ImList.list("imm", "255"), "%al"), ImList.list("setgb", "%al", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{7, 45}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[1561] = new Rule(1561, false, true, 1393, "1561: _1350 -> (TSTGTS I16 _117 _117)", null, null, null, 0L, false, false, new int[]{160, 160}, null);
        CodeGenerator_x86simd.rulev[1567] = new Rule(1567, false, true, 1399, "1567: _1356 -> (TSTGTS I16 _119 _119)", null, null, null, 0L, false, false, new int[]{162, 162}, null);
        CodeGenerator_x86simd.rulev[1573] = new Rule(1573, false, true, 1405, "1573: _1362 -> (TSTGTS I16 _121 _121)", null, null, null, 0L, false, false, new int[]{164, 164}, null);
        CodeGenerator_x86simd.rulev[1579] = new Rule(1579, false, true, 1411, "1579: _1368 -> (TSTGTS I16 _123 _123)", null, null, null, 0L, false, false, new int[]{166, 166}, null);
        CodeGenerator_x86simd.rulev[1855] = new Rule(1855, false, true, 1681, "1855: _1638 -> (TSTGTS I16 _49 _49)", null, null, null, 0L, false, false, new int[]{92, 92}, null);
        CodeGenerator_x86simd.rulev[1861] = new Rule(1861, false, true, 1687, "1861: _1644 -> (TSTGTS I16 _51 _51)", null, null, null, 0L, false, false, new int[]{94, 94}, null);
        CodeGenerator_x86simd.rulev[1867] = new Rule(1867, false, true, 1693, "1867: _1650 -> (TSTGTS I16 _53 _53)", null, null, null, 0L, false, false, new int[]{96, 96}, null);
        CodeGenerator_x86simd.rulev[1873] = new Rule(1873, false, true, 1699, "1873: _1656 -> (TSTGTS I16 _55 _55)", null, null, null, 0L, false, false, new int[]{98, 98}, null);
        CodeGenerator_x86simd.rulev[1879] = new Rule(1879, false, true, 1705, "1879: _1662 -> (TSTGTS I16 _57 _57)", null, null, null, 0L, false, false, new int[]{100, 100}, null);
        CodeGenerator_x86simd.rulev[1885] = new Rule(1885, false, true, 1711, "1885: _1668 -> (TSTGTS I16 _59 _59)", null, null, null, 0L, false, false, new int[]{102, 102}, null);
        CodeGenerator_x86simd.rulev[1891] = new Rule(1891, false, true, 1717, "1891: _1674 -> (TSTGTS I16 _61 _61)", null, null, null, 0L, false, false, new int[]{104, 104}, null);
        CodeGenerator_x86simd.rulev[1897] = new Rule(1897, false, true, 1723, "1897: _1680 -> (TSTGTS I16 _63 _63)", null, null, null, 0L, false, false, new int[]{106, 106}, null);
        CodeGenerator_x86simd.rulev[4074] = new Rule(4074, false, false, 6, "4074: regw -> (TSTGTS I16 regw mregw)", ImList.list(ImList.list("cmpw", "$2", "$1"), ImList.list("movw", ImList.list("imm", "0"), "$0"), ImList.list("movw", ImList.list("imm", "65535"), "%ax"), ImList.list("cmovgw", "%ax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{6, 43}, new String[]{"*reg-I16*", "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[1599] = new Rule(1599, false, true, 1429, "1599: _1386 -> (TSTGTS I32 _125 _125)", null, null, null, 0L, false, false, new int[]{168, 168}, null);
        CodeGenerator_x86simd.rulev[1605] = new Rule(1605, false, true, 1435, "1605: _1392 -> (TSTGTS I32 _127 _127)", null, null, null, 0L, false, false, new int[]{170, 170}, null);
        CodeGenerator_x86simd.rulev[1929] = new Rule(1929, false, true, 1753, "1929: _1710 -> (TSTGTS I32 _65 _65)", null, null, null, 0L, false, false, new int[]{108, 108}, null);
        CodeGenerator_x86simd.rulev[1935] = new Rule(1935, false, true, 1759, "1935: _1716 -> (TSTGTS I32 _67 _67)", null, null, null, 0L, false, false, new int[]{110, 110}, null);
        CodeGenerator_x86simd.rulev[1941] = new Rule(1941, false, true, 1765, "1941: _1722 -> (TSTGTS I32 _69 _69)", null, null, null, 0L, false, false, new int[]{112, 112}, null);
        CodeGenerator_x86simd.rulev[1947] = new Rule(1947, false, true, 1771, "1947: _1728 -> (TSTGTS I32 _71 _71)", null, null, null, 0L, false, false, new int[]{114, 114}, null);
        CodeGenerator_x86simd.rulev[4064] = new Rule(4064, false, false, 4, "4064: regl -> (TSTGTS I32 regl mregl)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("movl", ImList.list("imm", "0"), "$0"), ImList.list("movl", ImList.list("imm", "4294967295"), "%eax"), ImList.list("cmovgl", "%eax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{4, 41}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4151] = new Rule(4151, false, true, 3655, "4151: _3609 -> (TSTGTS I32 regq mrcq)", null, null, null, 0L, false, false, new int[]{3, 47}, null);
        CodeGenerator_x86simd.rulev[4171] = new Rule(4171, false, true, 3665, "4171: _3619 -> (TSTGTS I32 regl mrcl)", null, null, null, 0L, false, false, new int[]{4, 40}, null);
        CodeGenerator_x86simd.rulev[4193] = new Rule(4193, false, true, 3677, "4193: _3631 -> (TSTGTS I32 _3625 _3626)", null, null, null, 0L, false, false, new int[]{3671, 3672}, null);
        CodeGenerator_x86simd.rulev[4215] = new Rule(4215, false, true, 3689, "4215: _3643 -> (TSTGTS I32 _3637 _3638)", null, null, null, 0L, false, false, new int[]{3683, 3684}, null);
        CodeGenerator_x86simd.rulev[4235] = new Rule(4235, false, true, 3699, "4235: _3653 -> (TSTGTS I32 mrcl regl)", null, null, null, 0L, false, false, new int[]{40, 4}, null);
        CodeGenerator_x86simd.rulev[4255] = new Rule(4255, false, true, 3709, "4255: _3663 -> (TSTGTS I32 _3626 _3625)", null, null, null, 0L, false, false, new int[]{3672, 3671}, null);
        CodeGenerator_x86simd.rulev[4275] = new Rule(4275, false, true, 3719, "4275: _3673 -> (TSTGTS I32 _3638 _3637)", null, null, null, 0L, false, false, new int[]{3684, 3683}, null);
        CodeGenerator_x86simd.rulev[4303] = new Rule(4303, false, true, 3733, "4303: _3687 -> (TSTGTS I32 regd regmemd)", null, null, null, 0L, false, false, new int[]{9, 3645}, null);
        CodeGenerator_x86simd.rulev[4307] = new Rule(4307, false, true, 3735, "4307: _3689 -> (TSTGTS I32 regf regmemf)", null, null, null, 0L, false, false, new int[]{8, 3646}, null);
        CodeGenerator_x86simd.rulev[2422] = new Rule(2422, false, true, 2233, "2422: _2190 -> (TSTGES I8 _101 _101)", null, null, null, 0L, false, false, new int[]{144, 144}, null);
        CodeGenerator_x86simd.rulev[2428] = new Rule(2428, false, true, 2239, "2428: _2196 -> (TSTGES I8 _103 _103)", null, null, null, 0L, false, false, new int[]{146, 146}, null);
        CodeGenerator_x86simd.rulev[2434] = new Rule(2434, false, true, 2245, "2434: _2202 -> (TSTGES I8 _105 _105)", null, null, null, 0L, false, false, new int[]{148, 148}, null);
        CodeGenerator_x86simd.rulev[2440] = new Rule(2440, false, true, 2251, "2440: _2208 -> (TSTGES I8 _107 _107)", null, null, null, 0L, false, false, new int[]{150, 150}, null);
        CodeGenerator_x86simd.rulev[2446] = new Rule(2446, false, true, 2257, "2446: _2214 -> (TSTGES I8 _109 _109)", null, null, null, 0L, false, false, new int[]{152, 152}, null);
        CodeGenerator_x86simd.rulev[2452] = new Rule(2452, false, true, 2263, "2452: _2220 -> (TSTGES I8 _111 _111)", null, null, null, 0L, false, false, new int[]{154, 154}, null);
        CodeGenerator_x86simd.rulev[2458] = new Rule(2458, false, true, 2269, "2458: _2226 -> (TSTGES I8 _113 _113)", null, null, null, 0L, false, false, new int[]{156, 156}, null);
        CodeGenerator_x86simd.rulev[2464] = new Rule(2464, false, true, 2275, "2464: _2232 -> (TSTGES I8 _115 _115)", null, null, null, 0L, false, false, new int[]{158, 158}, null);
        CodeGenerator_x86simd.rulev[2501] = new Rule(2501, false, true, 2309, "2501: _2266 -> (TSTGES I8 _7 _7)", null, null, null, 0L, false, false, new int[]{50, 50}, null);
        CodeGenerator_x86simd.rulev[2507] = new Rule(2507, false, true, 2315, "2507: _2272 -> (TSTGES I8 _9 _9)", null, null, null, 0L, false, false, new int[]{52, 52}, null);
        CodeGenerator_x86simd.rulev[2513] = new Rule(2513, false, true, 2321, "2513: _2278 -> (TSTGES I8 _11 _11)", null, null, null, 0L, false, false, new int[]{54, 54}, null);
        CodeGenerator_x86simd.rulev[2519] = new Rule(2519, false, true, 2327, "2519: _2284 -> (TSTGES I8 _13 _13)", null, null, null, 0L, false, false, new int[]{56, 56}, null);
    }

    private static void rrinit2700() {
        CodeGenerator_x86simd.rulev[2525] = new Rule(2525, false, true, 2333, "2525: _2290 -> (TSTGES I8 _15 _15)", null, null, null, 0L, false, false, new int[]{58, 58}, null);
        CodeGenerator_x86simd.rulev[2531] = new Rule(2531, false, true, 2339, "2531: _2296 -> (TSTGES I8 _18 _18)", null, null, null, 0L, false, false, new int[]{61, 61}, null);
        CodeGenerator_x86simd.rulev[2537] = new Rule(2537, false, true, 2345, "2537: _2302 -> (TSTGES I8 _21 _21)", null, null, null, 0L, false, false, new int[]{64, 64}, null);
        CodeGenerator_x86simd.rulev[2543] = new Rule(2543, false, true, 2351, "2543: _2308 -> (TSTGES I8 _24 _24)", null, null, null, 0L, false, false, new int[]{67, 67}, null);
        CodeGenerator_x86simd.rulev[2549] = new Rule(2549, false, true, 2357, "2549: _2314 -> (TSTGES I8 _26 _26)", null, null, null, 0L, false, false, new int[]{69, 69}, null);
        CodeGenerator_x86simd.rulev[2555] = new Rule(2555, false, true, 2363, "2555: _2320 -> (TSTGES I8 _29 _29)", null, null, null, 0L, false, false, new int[]{72, 72}, null);
        CodeGenerator_x86simd.rulev[2561] = new Rule(2561, false, true, 2369, "2561: _2326 -> (TSTGES I8 _32 _32)", null, null, null, 0L, false, false, new int[]{75, 75}, null);
        CodeGenerator_x86simd.rulev[2567] = new Rule(2567, false, true, 2375, "2567: _2332 -> (TSTGES I8 _35 _35)", null, null, null, 0L, false, false, new int[]{78, 78}, null);
        CodeGenerator_x86simd.rulev[2573] = new Rule(2573, false, true, 2381, "2573: _2338 -> (TSTGES I8 _38 _38)", null, null, null, 0L, false, false, new int[]{81, 81}, null);
        CodeGenerator_x86simd.rulev[2579] = new Rule(2579, false, true, 2387, "2579: _2344 -> (TSTGES I8 _41 _41)", null, null, null, 0L, false, false, new int[]{84, 84}, null);
        CodeGenerator_x86simd.rulev[2585] = new Rule(2585, false, true, 2393, "2585: _2350 -> (TSTGES I8 _44 _44)", null, null, null, 0L, false, false, new int[]{87, 87}, null);
        CodeGenerator_x86simd.rulev[2591] = new Rule(2591, false, true, 2399, "2591: _2356 -> (TSTGES I8 _47 _47)", null, null, null, 0L, false, false, new int[]{90, 90}, null);
        CodeGenerator_x86simd.rulev[4085] = new Rule(4085, false, false, 7, "4085: regb -> (TSTGES I8 regb mregb)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("movb", ImList.list("imm", "0"), "$0"), ImList.list("movb", ImList.list("imm", "255"), "%al"), ImList.list("setgeb", "%al", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{7, 45}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[1290] = new Rule(1290, false, true, 1129, "1290: _1086 -> (TSTGES I16 _117 _117)", null, null, null, 0L, false, false, new int[]{160, 160}, null);
        CodeGenerator_x86simd.rulev[1296] = new Rule(1296, false, true, 1135, "1296: _1092 -> (TSTGES I16 _119 _119)", null, null, null, 0L, false, false, new int[]{162, 162}, null);
        CodeGenerator_x86simd.rulev[1302] = new Rule(1302, false, true, 1141, "1302: _1098 -> (TSTGES I16 _121 _121)", null, null, null, 0L, false, false, new int[]{164, 164}, null);
        CodeGenerator_x86simd.rulev[1308] = new Rule(1308, false, true, 1147, "1308: _1104 -> (TSTGES I16 _123 _123)", null, null, null, 0L, false, false, new int[]{166, 166}, null);
        CodeGenerator_x86simd.rulev[1340] = new Rule(1340, false, true, 1177, "1340: _1134 -> (TSTGES I16 _49 _49)", null, null, null, 0L, false, false, new int[]{92, 92}, null);
        CodeGenerator_x86simd.rulev[1346] = new Rule(1346, false, true, 1183, "1346: _1140 -> (TSTGES I16 _51 _51)", null, null, null, 0L, false, false, new int[]{94, 94}, null);
        CodeGenerator_x86simd.rulev[1352] = new Rule(1352, false, true, 1189, "1352: _1146 -> (TSTGES I16 _53 _53)", null, null, null, 0L, false, false, new int[]{96, 96}, null);
        CodeGenerator_x86simd.rulev[1358] = new Rule(1358, false, true, 1195, "1358: _1152 -> (TSTGES I16 _55 _55)", null, null, null, 0L, false, false, new int[]{98, 98}, null);
        CodeGenerator_x86simd.rulev[1364] = new Rule(1364, false, true, 1201, "1364: _1158 -> (TSTGES I16 _57 _57)", null, null, null, 0L, false, false, new int[]{100, 100}, null);
        CodeGenerator_x86simd.rulev[1370] = new Rule(1370, false, true, 1207, "1370: _1164 -> (TSTGES I16 _59 _59)", null, null, null, 0L, false, false, new int[]{102, 102}, null);
        CodeGenerator_x86simd.rulev[1376] = new Rule(1376, false, true, 1213, "1376: _1170 -> (TSTGES I16 _61 _61)", null, null, null, 0L, false, false, new int[]{104, 104}, null);
        CodeGenerator_x86simd.rulev[1382] = new Rule(1382, false, true, 1219, "1382: _1176 -> (TSTGES I16 _63 _63)", null, null, null, 0L, false, false, new int[]{106, 106}, null);
        CodeGenerator_x86simd.rulev[4075] = new Rule(4075, false, false, 6, "4075: regw -> (TSTGES I16 regw mregw)", ImList.list(ImList.list("cmpw", "$2", "$1"), ImList.list("movw", ImList.list("imm", "0"), "$0"), ImList.list("movw", ImList.list("imm", "65535"), "%ax"), ImList.list("cmovgew", "%ax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{6, 43}, new String[]{"*reg-I16*", "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[2488] = new Rule(2488, false, true, 2297, "2488: _2254 -> (TSTGES I32 _125 _125)", null, null, null, 0L, false, false, new int[]{168, 168}, null);
        CodeGenerator_x86simd.rulev[2494] = new Rule(2494, false, true, 2303, "2494: _2260 -> (TSTGES I32 _127 _127)", null, null, null, 0L, false, false, new int[]{170, 170}, null);
        CodeGenerator_x86simd.rulev[2631] = new Rule(2631, false, true, 2437, "2631: _2394 -> (TSTGES I32 _65 _65)", null, null, null, 0L, false, false, new int[]{108, 108}, null);
        CodeGenerator_x86simd.rulev[2637] = new Rule(2637, false, true, 2443, "2637: _2400 -> (TSTGES I32 _67 _67)", null, null, null, 0L, false, false, new int[]{110, 110}, null);
        CodeGenerator_x86simd.rulev[2643] = new Rule(2643, false, true, 2449, "2643: _2406 -> (TSTGES I32 _69 _69)", null, null, null, 0L, false, false, new int[]{112, 112}, null);
        CodeGenerator_x86simd.rulev[2649] = new Rule(2649, false, true, 2455, "2649: _2412 -> (TSTGES I32 _71 _71)", null, null, null, 0L, false, false, new int[]{114, 114}, null);
        CodeGenerator_x86simd.rulev[4065] = new Rule(4065, false, false, 4, "4065: regl -> (TSTGES I32 regl mregl)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("movl", ImList.list("imm", "0"), "$0"), ImList.list("movl", ImList.list("imm", "4294967295"), "%eax"), ImList.list("cmovgel", "%eax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{4, 41}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4153] = new Rule(4153, false, true, 3656, "4153: _3610 -> (TSTGES I32 regq mrcq)", null, null, null, 0L, false, false, new int[]{3, 47}, null);
        CodeGenerator_x86simd.rulev[4173] = new Rule(4173, false, true, 3666, "4173: _3620 -> (TSTGES I32 regl mrcl)", null, null, null, 0L, false, false, new int[]{4, 40}, null);
        CodeGenerator_x86simd.rulev[4195] = new Rule(4195, false, true, 3678, "4195: _3632 -> (TSTGES I32 _3625 _3626)", null, null, null, 0L, false, false, new int[]{3671, 3672}, null);
        CodeGenerator_x86simd.rulev[4217] = new Rule(4217, false, true, 3690, "4217: _3644 -> (TSTGES I32 _3637 _3638)", null, null, null, 0L, false, false, new int[]{3683, 3684}, null);
        CodeGenerator_x86simd.rulev[4237] = new Rule(4237, false, true, 3700, "4237: _3654 -> (TSTGES I32 mrcl regl)", null, null, null, 0L, false, false, new int[]{40, 4}, null);
        CodeGenerator_x86simd.rulev[4257] = new Rule(4257, false, true, 3710, "4257: _3664 -> (TSTGES I32 _3626 _3625)", null, null, null, 0L, false, false, new int[]{3672, 3671}, null);
        CodeGenerator_x86simd.rulev[4277] = new Rule(4277, false, true, 3720, "4277: _3674 -> (TSTGES I32 _3638 _3637)", null, null, null, 0L, false, false, new int[]{3684, 3683}, null);
        CodeGenerator_x86simd.rulev[4297] = new Rule(4297, false, true, 3730, "4297: _3684 -> (TSTGES I32 regd regmemd)", null, null, null, 0L, false, false, new int[]{9, 3645}, null);
        CodeGenerator_x86simd.rulev[4301] = new Rule(4301, false, true, 3732, "4301: _3686 -> (TSTGES I32 regf regmemf)", null, null, null, 0L, false, false, new int[]{8, 3646}, null);
        CodeGenerator_x86simd.rulev[1047] = new Rule(1047, false, true, 889, "1047: _846 -> (TSTLTU I8 _101 _101)", null, null, null, 0L, false, false, new int[]{144, 144}, null);
        CodeGenerator_x86simd.rulev[1053] = new Rule(1053, false, true, 895, "1053: _852 -> (TSTLTU I8 _103 _103)", null, null, null, 0L, false, false, new int[]{146, 146}, null);
        CodeGenerator_x86simd.rulev[1059] = new Rule(1059, false, true, 901, "1059: _858 -> (TSTLTU I8 _105 _105)", null, null, null, 0L, false, false, new int[]{148, 148}, null);
        CodeGenerator_x86simd.rulev[1065] = new Rule(1065, false, true, 907, "1065: _864 -> (TSTLTU I8 _107 _107)", null, null, null, 0L, false, false, new int[]{150, 150}, null);
        CodeGenerator_x86simd.rulev[1071] = new Rule(1071, false, true, 913, "1071: _870 -> (TSTLTU I8 _109 _109)", null, null, null, 0L, false, false, new int[]{152, 152}, null);
        CodeGenerator_x86simd.rulev[1077] = new Rule(1077, false, true, 919, "1077: _876 -> (TSTLTU I8 _111 _111)", null, null, null, 0L, false, false, new int[]{154, 154}, null);
        CodeGenerator_x86simd.rulev[1083] = new Rule(1083, false, true, 925, "1083: _882 -> (TSTLTU I8 _113 _113)", null, null, null, 0L, false, false, new int[]{156, 156}, null);
        CodeGenerator_x86simd.rulev[1089] = new Rule(1089, false, true, 931, "1089: _888 -> (TSTLTU I8 _115 _115)", null, null, null, 0L, false, false, new int[]{158, 158}, null);
        CodeGenerator_x86simd.rulev[1193] = new Rule(1193, false, true, 1033, "1193: _990 -> (TSTLTU I8 _7 _7)", null, null, null, 0L, false, false, new int[]{50, 50}, null);
        CodeGenerator_x86simd.rulev[1199] = new Rule(1199, false, true, 1039, "1199: _996 -> (TSTLTU I8 _9 _9)", null, null, null, 0L, false, false, new int[]{52, 52}, null);
        CodeGenerator_x86simd.rulev[1205] = new Rule(1205, false, true, 1045, "1205: _1002 -> (TSTLTU I8 _11 _11)", null, null, null, 0L, false, false, new int[]{54, 54}, null);
        CodeGenerator_x86simd.rulev[1211] = new Rule(1211, false, true, 1051, "1211: _1008 -> (TSTLTU I8 _13 _13)", null, null, null, 0L, false, false, new int[]{56, 56}, null);
        CodeGenerator_x86simd.rulev[1217] = new Rule(1217, false, true, 1057, "1217: _1014 -> (TSTLTU I8 _15 _15)", null, null, null, 0L, false, false, new int[]{58, 58}, null);
        CodeGenerator_x86simd.rulev[1223] = new Rule(1223, false, true, 1063, "1223: _1020 -> (TSTLTU I8 _18 _18)", null, null, null, 0L, false, false, new int[]{61, 61}, null);
        CodeGenerator_x86simd.rulev[1229] = new Rule(1229, false, true, 1069, "1229: _1026 -> (TSTLTU I8 _21 _21)", null, null, null, 0L, false, false, new int[]{64, 64}, null);
        CodeGenerator_x86simd.rulev[1235] = new Rule(1235, false, true, 1075, "1235: _1032 -> (TSTLTU I8 _24 _24)", null, null, null, 0L, false, false, new int[]{67, 67}, null);
        CodeGenerator_x86simd.rulev[1241] = new Rule(1241, false, true, 1081, "1241: _1038 -> (TSTLTU I8 _26 _26)", null, null, null, 0L, false, false, new int[]{69, 69}, null);
        CodeGenerator_x86simd.rulev[1247] = new Rule(1247, false, true, 1087, "1247: _1044 -> (TSTLTU I8 _29 _29)", null, null, null, 0L, false, false, new int[]{72, 72}, null);
        CodeGenerator_x86simd.rulev[1253] = new Rule(1253, false, true, 1093, "1253: _1050 -> (TSTLTU I8 _32 _32)", null, null, null, 0L, false, false, new int[]{75, 75}, null);
        CodeGenerator_x86simd.rulev[1259] = new Rule(1259, false, true, 1099, "1259: _1056 -> (TSTLTU I8 _35 _35)", null, null, null, 0L, false, false, new int[]{78, 78}, null);
        CodeGenerator_x86simd.rulev[1265] = new Rule(1265, false, true, 1105, "1265: _1062 -> (TSTLTU I8 _38 _38)", null, null, null, 0L, false, false, new int[]{81, 81}, null);
        CodeGenerator_x86simd.rulev[1271] = new Rule(1271, false, true, 1111, "1271: _1068 -> (TSTLTU I8 _41 _41)", null, null, null, 0L, false, false, new int[]{84, 84}, null);
        CodeGenerator_x86simd.rulev[1277] = new Rule(1277, false, true, 1117, "1277: _1074 -> (TSTLTU I8 _44 _44)", null, null, null, 0L, false, false, new int[]{87, 87}, null);
        CodeGenerator_x86simd.rulev[1283] = new Rule(1283, false, true, 1123, "1283: _1080 -> (TSTLTU I8 _47 _47)", null, null, null, 0L, false, false, new int[]{90, 90}, null);
        CodeGenerator_x86simd.rulev[4086] = new Rule(4086, false, false, 7, "4086: regb -> (TSTLTU I8 regb mregb)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("movb", ImList.list("imm", "0"), "$0"), ImList.list("movb", ImList.list("imm", "255"), "%al"), ImList.list("setbb", "%al", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{7, 45}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[4076] = new Rule(4076, false, false, 6, "4076: regw -> (TSTLTU I16 regw mregw)", ImList.list(ImList.list("cmpw", "$2", "$1"), ImList.list("movw", ImList.list("imm", "0"), "$0"), ImList.list("movw", ImList.list("imm", "65535"), "%ax"), ImList.list("cmovbw", "%ax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{6, 43}, new String[]{"*reg-I16*", "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[4066] = new Rule(4066, false, false, 4, "4066: regl -> (TSTLTU I32 regl mregl)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("movl", ImList.list("imm", "0"), "$0"), ImList.list("movl", ImList.list("imm", "4294967295"), "%eax"), ImList.list("cmovbl", "%eax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{4, 41}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4155] = new Rule(4155, false, true, 3657, "4155: _3611 -> (TSTLTU I32 regq mrcq)", null, null, null, 0L, false, false, new int[]{3, 47}, null);
        CodeGenerator_x86simd.rulev[4175] = new Rule(4175, false, true, 3667, "4175: _3621 -> (TSTLTU I32 regl mrcl)", null, null, null, 0L, false, false, new int[]{4, 40}, null);
        CodeGenerator_x86simd.rulev[4197] = new Rule(4197, false, true, 3679, "4197: _3633 -> (TSTLTU I32 _3625 _3626)", null, null, null, 0L, false, false, new int[]{3671, 3672}, null);
        CodeGenerator_x86simd.rulev[4219] = new Rule(4219, false, true, 3691, "4219: _3645 -> (TSTLTU I32 _3637 _3638)", null, null, null, 0L, false, false, new int[]{3683, 3684}, null);
        CodeGenerator_x86simd.rulev[4239] = new Rule(4239, false, true, 3701, "4239: _3655 -> (TSTLTU I32 mrcl regl)", null, null, null, 0L, false, false, new int[]{40, 4}, null);
        CodeGenerator_x86simd.rulev[4259] = new Rule(4259, false, true, 3711, "4259: _3665 -> (TSTLTU I32 _3626 _3625)", null, null, null, 0L, false, false, new int[]{3672, 3671}, null);
        CodeGenerator_x86simd.rulev[4279] = new Rule(4279, false, true, 3721, "4279: _3675 -> (TSTLTU I32 _3638 _3637)", null, null, null, 0L, false, false, new int[]{3684, 3683}, null);
        CodeGenerator_x86simd.rulev[4087] = new Rule(4087, false, false, 7, "4087: regb -> (TSTLEU I8 regb mregb)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("movb", ImList.list("imm", "0"), "$0"), ImList.list("movb", ImList.list("imm", "255"), "%al"), ImList.list("setbeb", "%al", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{7, 45}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[4077] = new Rule(4077, false, false, 6, "4077: regw -> (TSTLEU I16 regw mregw)", ImList.list(ImList.list("cmpw", "$2", "$1"), ImList.list("movw", ImList.list("imm", "0"), "$0"), ImList.list("movw", ImList.list("imm", "65535"), "%ax"), ImList.list("cmovbew", "%ax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{6, 43}, new String[]{"*reg-I16*", "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[4067] = new Rule(4067, false, false, 4, "4067: regl -> (TSTLEU I32 regl mregl)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("movl", ImList.list("imm", "0"), "$0"), ImList.list("movl", ImList.list("imm", "4294967295"), "%eax"), ImList.list("cmovbel", "%eax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{4, 41}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4157] = new Rule(4157, false, true, 3658, "4157: _3612 -> (TSTLEU I32 regq mrcq)", null, null, null, 0L, false, false, new int[]{3, 47}, null);
        CodeGenerator_x86simd.rulev[4177] = new Rule(4177, false, true, 3668, "4177: _3622 -> (TSTLEU I32 regl mrcl)", null, null, null, 0L, false, false, new int[]{4, 40}, null);
        CodeGenerator_x86simd.rulev[4199] = new Rule(4199, false, true, 3680, "4199: _3634 -> (TSTLEU I32 _3625 _3626)", null, null, null, 0L, false, false, new int[]{3671, 3672}, null);
        CodeGenerator_x86simd.rulev[4221] = new Rule(4221, false, true, 3692, "4221: _3646 -> (TSTLEU I32 _3637 _3638)", null, null, null, 0L, false, false, new int[]{3683, 3684}, null);
        CodeGenerator_x86simd.rulev[4241] = new Rule(4241, false, true, 3702, "4241: _3656 -> (TSTLEU I32 mrcl regl)", null, null, null, 0L, false, false, new int[]{40, 4}, null);
        CodeGenerator_x86simd.rulev[4261] = new Rule(4261, false, true, 3712, "4261: _3666 -> (TSTLEU I32 _3626 _3625)", null, null, null, 0L, false, false, new int[]{3672, 3671}, null);
        CodeGenerator_x86simd.rulev[4281] = new Rule(4281, false, true, 3722, "4281: _3676 -> (TSTLEU I32 _3638 _3637)", null, null, null, 0L, false, false, new int[]{3684, 3683}, null);
        CodeGenerator_x86simd.rulev[4088] = new Rule(4088, false, false, 7, "4088: regb -> (TSTGTU I8 regb mregb)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("movb", ImList.list("imm", "0"), "$0"), ImList.list("movb", ImList.list("imm", "255"), "%al"), ImList.list("setab", "%al", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{7, 45}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[4078] = new Rule(4078, false, false, 6, "4078: regw -> (TSTGTU I16 regw mregw)", ImList.list(ImList.list("cmpw", "$2", "$1"), ImList.list("movw", ImList.list("imm", "0"), "$0"), ImList.list("movw", ImList.list("imm", "65535"), "%ax"), ImList.list("cmovaw", "%ax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{6, 43}, new String[]{"*reg-I16*", "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[4068] = new Rule(4068, false, false, 4, "4068: regl -> (TSTGTU I32 regl mregl)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("movl", ImList.list("imm", "0"), "$0"), ImList.list("movl", ImList.list("imm", "4294967295"), "%eax"), ImList.list("cmoval", "%eax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{4, 41}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4159] = new Rule(4159, false, true, 3659, "4159: _3613 -> (TSTGTU I32 regq mrcq)", null, null, null, 0L, false, false, new int[]{3, 47}, null);
        CodeGenerator_x86simd.rulev[4179] = new Rule(4179, false, true, 3669, "4179: _3623 -> (TSTGTU I32 regl mrcl)", null, null, null, 0L, false, false, new int[]{4, 40}, null);
        CodeGenerator_x86simd.rulev[4201] = new Rule(4201, false, true, 3681, "4201: _3635 -> (TSTGTU I32 _3625 _3626)", null, null, null, 0L, false, false, new int[]{3671, 3672}, null);
        CodeGenerator_x86simd.rulev[4223] = new Rule(4223, false, true, 3693, "4223: _3647 -> (TSTGTU I32 _3637 _3638)", null, null, null, 0L, false, false, new int[]{3683, 3684}, null);
        CodeGenerator_x86simd.rulev[4243] = new Rule(4243, false, true, 3703, "4243: _3657 -> (TSTGTU I32 mrcl regl)", null, null, null, 0L, false, false, new int[]{40, 4}, null);
        CodeGenerator_x86simd.rulev[4263] = new Rule(4263, false, true, 3713, "4263: _3667 -> (TSTGTU I32 _3626 _3625)", null, null, null, 0L, false, false, new int[]{3672, 3671}, null);
        CodeGenerator_x86simd.rulev[4283] = new Rule(4283, false, true, 3723, "4283: _3677 -> (TSTGTU I32 _3638 _3637)", null, null, null, 0L, false, false, new int[]{3684, 3683}, null);
        CodeGenerator_x86simd.rulev[998] = new Rule(998, false, true, 841, "998: _798 -> (TSTGEU I8 _101 _101)", null, null, null, 0L, false, false, new int[]{144, 144}, null);
        CodeGenerator_x86simd.rulev[1004] = new Rule(1004, false, true, 847, "1004: _804 -> (TSTGEU I8 _103 _103)", null, null, null, 0L, false, false, new int[]{146, 146}, null);
        CodeGenerator_x86simd.rulev[1010] = new Rule(1010, false, true, 853, "1010: _810 -> (TSTGEU I8 _105 _105)", null, null, null, 0L, false, false, new int[]{148, 148}, null);
        CodeGenerator_x86simd.rulev[1016] = new Rule(1016, false, true, 859, "1016: _816 -> (TSTGEU I8 _107 _107)", null, null, null, 0L, false, false, new int[]{150, 150}, null);
    }

    private static void rrinit2800() {
        CodeGenerator_x86simd.rulev[1022] = new Rule(1022, false, true, 865, "1022: _822 -> (TSTGEU I8 _109 _109)", null, null, null, 0L, false, false, new int[]{152, 152}, null);
        CodeGenerator_x86simd.rulev[1028] = new Rule(1028, false, true, 871, "1028: _828 -> (TSTGEU I8 _111 _111)", null, null, null, 0L, false, false, new int[]{154, 154}, null);
        CodeGenerator_x86simd.rulev[1034] = new Rule(1034, false, true, 877, "1034: _834 -> (TSTGEU I8 _113 _113)", null, null, null, 0L, false, false, new int[]{156, 156}, null);
        CodeGenerator_x86simd.rulev[1040] = new Rule(1040, false, true, 883, "1040: _840 -> (TSTGEU I8 _115 _115)", null, null, null, 0L, false, false, new int[]{158, 158}, null);
        CodeGenerator_x86simd.rulev[1096] = new Rule(1096, false, true, 937, "1096: _894 -> (TSTGEU I8 _7 _7)", null, null, null, 0L, false, false, new int[]{50, 50}, null);
        CodeGenerator_x86simd.rulev[1102] = new Rule(1102, false, true, 943, "1102: _900 -> (TSTGEU I8 _9 _9)", null, null, null, 0L, false, false, new int[]{52, 52}, null);
        CodeGenerator_x86simd.rulev[1108] = new Rule(1108, false, true, 949, "1108: _906 -> (TSTGEU I8 _11 _11)", null, null, null, 0L, false, false, new int[]{54, 54}, null);
        CodeGenerator_x86simd.rulev[1114] = new Rule(1114, false, true, 955, "1114: _912 -> (TSTGEU I8 _13 _13)", null, null, null, 0L, false, false, new int[]{56, 56}, null);
        CodeGenerator_x86simd.rulev[1120] = new Rule(1120, false, true, 961, "1120: _918 -> (TSTGEU I8 _15 _15)", null, null, null, 0L, false, false, new int[]{58, 58}, null);
        CodeGenerator_x86simd.rulev[1126] = new Rule(1126, false, true, 967, "1126: _924 -> (TSTGEU I8 _18 _18)", null, null, null, 0L, false, false, new int[]{61, 61}, null);
        CodeGenerator_x86simd.rulev[1132] = new Rule(1132, false, true, 973, "1132: _930 -> (TSTGEU I8 _21 _21)", null, null, null, 0L, false, false, new int[]{64, 64}, null);
        CodeGenerator_x86simd.rulev[1138] = new Rule(1138, false, true, 979, "1138: _936 -> (TSTGEU I8 _24 _24)", null, null, null, 0L, false, false, new int[]{67, 67}, null);
        CodeGenerator_x86simd.rulev[1144] = new Rule(1144, false, true, 985, "1144: _942 -> (TSTGEU I8 _26 _26)", null, null, null, 0L, false, false, new int[]{69, 69}, null);
        CodeGenerator_x86simd.rulev[1150] = new Rule(1150, false, true, 991, "1150: _948 -> (TSTGEU I8 _29 _29)", null, null, null, 0L, false, false, new int[]{72, 72}, null);
        CodeGenerator_x86simd.rulev[1156] = new Rule(1156, false, true, 997, "1156: _954 -> (TSTGEU I8 _32 _32)", null, null, null, 0L, false, false, new int[]{75, 75}, null);
        CodeGenerator_x86simd.rulev[1162] = new Rule(1162, false, true, 1003, "1162: _960 -> (TSTGEU I8 _35 _35)", null, null, null, 0L, false, false, new int[]{78, 78}, null);
        CodeGenerator_x86simd.rulev[1168] = new Rule(1168, false, true, 1009, "1168: _966 -> (TSTGEU I8 _38 _38)", null, null, null, 0L, false, false, new int[]{81, 81}, null);
        CodeGenerator_x86simd.rulev[1174] = new Rule(1174, false, true, 1015, "1174: _972 -> (TSTGEU I8 _41 _41)", null, null, null, 0L, false, false, new int[]{84, 84}, null);
        CodeGenerator_x86simd.rulev[1180] = new Rule(1180, false, true, 1021, "1180: _978 -> (TSTGEU I8 _44 _44)", null, null, null, 0L, false, false, new int[]{87, 87}, null);
        CodeGenerator_x86simd.rulev[1186] = new Rule(1186, false, true, 1027, "1186: _984 -> (TSTGEU I8 _47 _47)", null, null, null, 0L, false, false, new int[]{90, 90}, null);
        CodeGenerator_x86simd.rulev[4089] = new Rule(4089, false, false, 7, "4089: regb -> (TSTGEU I8 regb mregb)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("movb", ImList.list("imm", "0"), "$0"), ImList.list("movb", ImList.list("imm", "255"), "%al"), ImList.list("setaeb", "%al", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{7, 45}, new String[]{"*reg-I8*", "*reg-I8*", null});
        CodeGenerator_x86simd.rulev[4079] = new Rule(4079, false, false, 6, "4079: regw -> (TSTGEU I16 regw mregw)", ImList.list(ImList.list("cmpw", "$2", "$1"), ImList.list("movw", ImList.list("imm", "0"), "$0"), ImList.list("movw", ImList.list("imm", "65535"), "%ax"), ImList.list("cmovaew", "%ax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{6, 43}, new String[]{"*reg-I16*", "*reg-I16*", null});
        CodeGenerator_x86simd.rulev[4069] = new Rule(4069, false, false, 4, "4069: regl -> (TSTGEU I32 regl mregl)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("movl", ImList.list("imm", "0"), "$0"), ImList.list("movl", ImList.list("imm", "4294967295"), "%eax"), ImList.list("cmovael", "%eax", "$0")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{4, 41}, new String[]{"*reg-I32*", "*reg-I32*", null});
        CodeGenerator_x86simd.rulev[4161] = new Rule(4161, false, true, 3660, "4161: _3614 -> (TSTGEU I32 regq mrcq)", null, null, null, 0L, false, false, new int[]{3, 47}, null);
        CodeGenerator_x86simd.rulev[4181] = new Rule(4181, false, true, 3670, "4181: _3624 -> (TSTGEU I32 regl mrcl)", null, null, null, 0L, false, false, new int[]{4, 40}, null);
        CodeGenerator_x86simd.rulev[4203] = new Rule(4203, false, true, 3682, "4203: _3636 -> (TSTGEU I32 _3625 _3626)", null, null, null, 0L, false, false, new int[]{3671, 3672}, null);
        CodeGenerator_x86simd.rulev[4225] = new Rule(4225, false, true, 3694, "4225: _3648 -> (TSTGEU I32 _3637 _3638)", null, null, null, 0L, false, false, new int[]{3683, 3684}, null);
        CodeGenerator_x86simd.rulev[4245] = new Rule(4245, false, true, 3704, "4245: _3658 -> (TSTGEU I32 mrcl regl)", null, null, null, 0L, false, false, new int[]{40, 4}, null);
        CodeGenerator_x86simd.rulev[4265] = new Rule(4265, false, true, 3714, "4265: _3668 -> (TSTGEU I32 _3626 _3625)", null, null, null, 0L, false, false, new int[]{3672, 3671}, null);
        CodeGenerator_x86simd.rulev[4285] = new Rule(4285, false, true, 3724, "4285: _3678 -> (TSTGEU I32 _3638 _3637)", null, null, null, 0L, false, false, new int[]{3684, 3683}, null);
        CodeGenerator_x86simd.rulev[61] = new Rule(61, false, false, 34, "61: memb -> (MEM I8 addr)", null, ImList.list(ImList.list("mem", "byte", "$1")), null, 0L, false, false, new int[]{30}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[60] = new Rule(60, false, false, 33, "60: memw -> (MEM I16 addr)", null, ImList.list(ImList.list("mem", "word", "$1")), null, 0L, false, false, new int[]{30}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[59] = new Rule(59, false, false, 32, "59: meml -> (MEM I32 addr)", null, ImList.list(ImList.list("mem", "long", "$1")), null, 0L, false, false, new int[]{30}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[3960] = new Rule(3960, false, true, 3635, "3960: _3592 -> (MEM I32 _3591)", null, null, null, 0L, false, false, new int[]{3634}, null);
        CodeGenerator_x86simd.rulev[62] = new Rule(62, false, false, 35, "62: memf -> (MEM F32 addr)", null, ImList.list(ImList.list("mem", "float", "$1")), null, 0L, false, false, new int[]{30}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[3964] = new Rule(3964, false, true, 3638, "3964: _3595 -> (MEM F32 _3591)", null, null, null, 0L, false, false, new int[]{3634}, null);
        CodeGenerator_x86simd.rulev[58] = new Rule(58, false, false, 31, "58: memq -> (MEM I64 addr)", null, ImList.list(ImList.list("mem", "quad", "$1")), null, 0L, false, false, new int[]{30}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[3955] = new Rule(3955, false, true, 3631, "3955: _3588 -> (MEM I64 _3587)", null, null, null, 0L, false, false, new int[]{3630}, null);
        CodeGenerator_x86simd.rulev[63] = new Rule(63, false, false, 36, "63: memd -> (MEM F64 addr)", null, ImList.list(ImList.list("mem", "double", "$1")), null, 0L, false, false, new int[]{30}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[3967] = new Rule(3967, false, true, 3640, "3967: _3597 -> (MEM F64 _3587)", null, null, null, 0L, false, false, new int[]{3630}, null);
        CodeGenerator_x86simd.rulev[90] = new Rule(90, false, true, 51, "90: _8 -> (SET I8 _7 memb)", null, null, null, 0L, false, false, new int[]{50, 34}, null);
        CodeGenerator_x86simd.rulev[92] = new Rule(92, false, true, 53, "92: _10 -> (SET I8 _9 memb)", null, null, null, 0L, false, false, new int[]{52, 34}, null);
        CodeGenerator_x86simd.rulev[94] = new Rule(94, false, true, 55, "94: _12 -> (SET I8 _11 memb)", null, null, null, 0L, false, false, new int[]{54, 34}, null);
        CodeGenerator_x86simd.rulev[96] = new Rule(96, false, true, 57, "96: _14 -> (SET I8 _13 memb)", null, null, null, 0L, false, false, new int[]{56, 34}, null);
        CodeGenerator_x86simd.rulev[98] = new Rule(98, false, true, 59, "98: _16 -> (SET I8 _15 memb)", null, null, null, 0L, false, false, new int[]{58, 34}, null);
        CodeGenerator_x86simd.rulev[101] = new Rule(101, false, true, 62, "101: _19 -> (SET I8 _18 memb)", null, null, null, 0L, false, false, new int[]{61, 34}, null);
        CodeGenerator_x86simd.rulev[104] = new Rule(104, false, true, 65, "104: _22 -> (SET I8 _21 memb)", null, null, null, 0L, false, false, new int[]{64, 34}, null);
        CodeGenerator_x86simd.rulev[107] = new Rule(107, false, true, 68, "107: _25 -> (SET I8 _24 memb)", null, null, null, 0L, false, false, new int[]{67, 34}, null);
        CodeGenerator_x86simd.rulev[109] = new Rule(109, false, true, 70, "109: _27 -> (SET I8 _26 memb)", null, null, null, 0L, false, false, new int[]{69, 34}, null);
        CodeGenerator_x86simd.rulev[112] = new Rule(112, false, true, 73, "112: _30 -> (SET I8 _29 memb)", null, null, null, 0L, false, false, new int[]{72, 34}, null);
        CodeGenerator_x86simd.rulev[115] = new Rule(115, false, true, 76, "115: _33 -> (SET I8 _32 memb)", null, null, null, 0L, false, false, new int[]{75, 34}, null);
        CodeGenerator_x86simd.rulev[118] = new Rule(118, false, true, 79, "118: _36 -> (SET I8 _35 memb)", null, null, null, 0L, false, false, new int[]{78, 34}, null);
        CodeGenerator_x86simd.rulev[121] = new Rule(121, false, true, 82, "121: _39 -> (SET I8 _38 memb)", null, null, null, 0L, false, false, new int[]{81, 34}, null);
        CodeGenerator_x86simd.rulev[124] = new Rule(124, false, true, 85, "124: _42 -> (SET I8 _41 memb)", null, null, null, 0L, false, false, new int[]{84, 34}, null);
        CodeGenerator_x86simd.rulev[127] = new Rule(127, false, true, 88, "127: _45 -> (SET I8 _44 memb)", null, null, null, 0L, false, false, new int[]{87, 34}, null);
        CodeGenerator_x86simd.rulev[130] = new Rule(130, false, true, 91, "130: _48 -> (SET I8 _47 memb)", null, null, null, 0L, false, false, new int[]{90, 34}, null);
        CodeGenerator_x86simd.rulev[158] = new Rule(158, false, true, 116, "158: _73 -> (SET I8 memb _7)", null, null, null, 0L, false, false, new int[]{34, 50}, null);
        CodeGenerator_x86simd.rulev[159] = new Rule(159, false, true, 117, "159: _74 -> (SET I8 memb _9)", null, null, null, 0L, false, false, new int[]{34, 52}, null);
        CodeGenerator_x86simd.rulev[160] = new Rule(160, false, true, 118, "160: _75 -> (SET I8 memb _11)", null, null, null, 0L, false, false, new int[]{34, 54}, null);
        CodeGenerator_x86simd.rulev[161] = new Rule(161, false, true, 119, "161: _76 -> (SET I8 memb _13)", null, null, null, 0L, false, false, new int[]{34, 56}, null);
        CodeGenerator_x86simd.rulev[162] = new Rule(162, false, true, 120, "162: _77 -> (SET I8 memb _15)", null, null, null, 0L, false, false, new int[]{34, 58}, null);
        CodeGenerator_x86simd.rulev[163] = new Rule(163, false, true, 121, "163: _78 -> (SET I8 memb _18)", null, null, null, 0L, false, false, new int[]{34, 61}, null);
        CodeGenerator_x86simd.rulev[164] = new Rule(164, false, true, 122, "164: _79 -> (SET I8 memb _21)", null, null, null, 0L, false, false, new int[]{34, 64}, null);
        CodeGenerator_x86simd.rulev[165] = new Rule(165, false, true, 123, "165: _80 -> (SET I8 memb _24)", null, null, null, 0L, false, false, new int[]{34, 67}, null);
        CodeGenerator_x86simd.rulev[166] = new Rule(166, false, true, 124, "166: _81 -> (SET I8 memb _26)", null, null, null, 0L, false, false, new int[]{34, 69}, null);
        CodeGenerator_x86simd.rulev[167] = new Rule(167, false, true, 125, "167: _82 -> (SET I8 memb _29)", null, null, null, 0L, false, false, new int[]{34, 72}, null);
        CodeGenerator_x86simd.rulev[168] = new Rule(168, false, true, 126, "168: _83 -> (SET I8 memb _32)", null, null, null, 0L, false, false, new int[]{34, 75}, null);
        CodeGenerator_x86simd.rulev[169] = new Rule(169, false, true, 127, "169: _84 -> (SET I8 memb _35)", null, null, null, 0L, false, false, new int[]{34, 78}, null);
        CodeGenerator_x86simd.rulev[170] = new Rule(170, false, true, 128, "170: _85 -> (SET I8 memb _38)", null, null, null, 0L, false, false, new int[]{34, 81}, null);
        CodeGenerator_x86simd.rulev[171] = new Rule(171, false, true, 129, "171: _86 -> (SET I8 memb _41)", null, null, null, 0L, false, false, new int[]{34, 84}, null);
        CodeGenerator_x86simd.rulev[172] = new Rule(172, false, true, 130, "172: _87 -> (SET I8 memb _44)", null, null, null, 0L, false, false, new int[]{34, 87}, null);
        CodeGenerator_x86simd.rulev[173] = new Rule(173, false, true, 131, "173: _88 -> (SET I8 memb _47)", null, null, null, 0L, false, false, new int[]{34, 90}, null);
        CodeGenerator_x86simd.rulev[190] = new Rule(190, false, true, 145, "190: _102 -> (SET I8 _101 memb)", null, null, null, 0L, false, false, new int[]{144, 34}, null);
        CodeGenerator_x86simd.rulev[192] = new Rule(192, false, true, 147, "192: _104 -> (SET I8 _103 memb)", null, null, null, 0L, false, false, new int[]{146, 34}, null);
        CodeGenerator_x86simd.rulev[194] = new Rule(194, false, true, 149, "194: _106 -> (SET I8 _105 memb)", null, null, null, 0L, false, false, new int[]{148, 34}, null);
        CodeGenerator_x86simd.rulev[196] = new Rule(196, false, true, 151, "196: _108 -> (SET I8 _107 memb)", null, null, null, 0L, false, false, new int[]{150, 34}, null);
        CodeGenerator_x86simd.rulev[198] = new Rule(198, false, true, 153, "198: _110 -> (SET I8 _109 memb)", null, null, null, 0L, false, false, new int[]{152, 34}, null);
        CodeGenerator_x86simd.rulev[200] = new Rule(200, false, true, 155, "200: _112 -> (SET I8 _111 memb)", null, null, null, 0L, false, false, new int[]{154, 34}, null);
        CodeGenerator_x86simd.rulev[202] = new Rule(202, false, true, 157, "202: _114 -> (SET I8 _113 memb)", null, null, null, 0L, false, false, new int[]{156, 34}, null);
        CodeGenerator_x86simd.rulev[204] = new Rule(204, false, true, 159, "204: _116 -> (SET I8 _115 memb)", null, null, null, 0L, false, false, new int[]{158, 34}, null);
        CodeGenerator_x86simd.rulev[220] = new Rule(220, false, true, 172, "220: _129 -> (SET I8 memb _101)", null, null, null, 0L, false, false, new int[]{34, 144}, null);
        CodeGenerator_x86simd.rulev[221] = new Rule(221, false, true, 173, "221: _130 -> (SET I8 memb _103)", null, null, null, 0L, false, false, new int[]{34, 146}, null);
        CodeGenerator_x86simd.rulev[222] = new Rule(222, false, true, 174, "222: _131 -> (SET I8 memb _105)", null, null, null, 0L, false, false, new int[]{34, 148}, null);
        CodeGenerator_x86simd.rulev[223] = new Rule(223, false, true, 175, "223: _132 -> (SET I8 memb _107)", null, null, null, 0L, false, false, new int[]{34, 150}, null);
        CodeGenerator_x86simd.rulev[224] = new Rule(224, false, true, 176, "224: _133 -> (SET I8 memb _109)", null, null, null, 0L, false, false, new int[]{34, 152}, null);
        CodeGenerator_x86simd.rulev[225] = new Rule(225, false, true, 177, "225: _134 -> (SET I8 memb _111)", null, null, null, 0L, false, false, new int[]{34, 154}, null);
        CodeGenerator_x86simd.rulev[226] = new Rule(226, false, true, 178, "226: _135 -> (SET I8 memb _113)", null, null, null, 0L, false, false, new int[]{34, 156}, null);
        CodeGenerator_x86simd.rulev[227] = new Rule(227, false, true, 179, "227: _136 -> (SET I8 memb _115)", null, null, null, 0L, false, false, new int[]{34, 158}, null);
        CodeGenerator_x86simd.rulev[237] = new Rule(237, false, false, 10, "237: void -> (SET I8 mregb _7)", ImList.list(ImList.list("pextrw", ImList.list("imm", "0"), "$2", "%edx"), ImList.list("movb", "%dl", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 50}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[238] = new Rule(238, false, false, 10, "238: void -> (SET I8 mregb _11)", ImList.list(ImList.list("pextrw", ImList.list("imm", "1"), "$2", "%edx"), ImList.list("movb", "%dl", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 54}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[239] = new Rule(239, false, false, 10, "239: void -> (SET I8 mregb _15)", ImList.list(ImList.list("pextrw", ImList.list("imm", "2"), "$2", "%edx"), ImList.list("movb", "%dl", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 58}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[240] = new Rule(240, false, false, 10, "240: void -> (SET I8 mregb _21)", ImList.list(ImList.list("pextrw", ImList.list("imm", "3"), "$2", "%edx"), ImList.list("movb", "%dl", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 64}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[241] = new Rule(241, false, false, 10, "241: void -> (SET I8 mregb _26)", ImList.list(ImList.list("pextrw", ImList.list("imm", "4"), "$2", "%edx"), ImList.list("movb", "%dl", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 69}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[242] = new Rule(242, false, false, 10, "242: void -> (SET I8 mregb _32)", ImList.list(ImList.list("pextrw", ImList.list("imm", "5"), "$2", "%edx"), ImList.list("movb", "%dl", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 75}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[243] = new Rule(243, false, false, 10, "243: void -> (SET I8 mregb _38)", ImList.list(ImList.list("pextrw", ImList.list("imm", "6"), "$2", "%edx"), ImList.list("movb", "%dl", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 81}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[244] = new Rule(244, false, false, 10, "244: void -> (SET I8 mregb _44)", ImList.list(ImList.list("pextrw", ImList.list("imm", "7"), "$2", "%edx"), ImList.list("movb", "%dl", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 87}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[245] = new Rule(245, false, false, 10, "245: void -> (SET I8 mregb _9)", ImList.list(ImList.list("pextrw", ImList.list("imm", "0"), "$2", "%edx"), ImList.list("movb", "%dh", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 52}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[246] = new Rule(246, false, false, 10, "246: void -> (SET I8 mregb _13)", ImList.list(ImList.list("pextrw", ImList.list("imm", "1"), "$2", "%edx"), ImList.list("movb", "%dh", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 56}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[247] = new Rule(247, false, false, 10, "247: void -> (SET I8 mregb _18)", ImList.list(ImList.list("pextrw", ImList.list("imm", "2"), "$2", "%edx"), ImList.list("movb", "%dh", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 61}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[248] = new Rule(248, false, false, 10, "248: void -> (SET I8 mregb _24)", ImList.list(ImList.list("pextrw", ImList.list("imm", "3"), "$2", "%edx"), ImList.list("movb", "%dh", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 67}, new String[]{null, null, "*reg-simd-I128*"});
    }

    private static void rrinit2900() {
        CodeGenerator_x86simd.rulev[249] = new Rule(249, false, false, 10, "249: void -> (SET I8 mregb _29)", ImList.list(ImList.list("pextrw", ImList.list("imm", "4"), "$2", "%edx"), ImList.list("movb", "%dh", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 72}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[250] = new Rule(250, false, false, 10, "250: void -> (SET I8 mregb _35)", ImList.list(ImList.list("pextrw", ImList.list("imm", "5"), "$2", "%edx"), ImList.list("movb", "%dh", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 78}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[251] = new Rule(251, false, false, 10, "251: void -> (SET I8 mregb _41)", ImList.list(ImList.list("pextrw", ImList.list("imm", "6"), "$2", "%edx"), ImList.list("movb", "%dh", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 84}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[252] = new Rule(252, false, false, 10, "252: void -> (SET I8 mregb _47)", ImList.list(ImList.list("pextrw", ImList.list("imm", "7"), "$2", "%edx"), ImList.list("movb", "%dh", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 90}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[266] = new Rule(266, false, true, 187, "266: _144 -> (SET I8 _143 regb)", null, null, null, 0L, false, false, new int[]{186, 7}, null);
        CodeGenerator_x86simd.rulev[268] = new Rule(268, false, true, 189, "268: _146 -> (SET I8 _145 regb)", null, null, null, 0L, false, false, new int[]{188, 7}, null);
        CodeGenerator_x86simd.rulev[270] = new Rule(270, false, true, 191, "270: _148 -> (SET I8 _147 regb)", null, null, null, 0L, false, false, new int[]{190, 7}, null);
        CodeGenerator_x86simd.rulev[272] = new Rule(272, false, true, 193, "272: _150 -> (SET I8 _149 regb)", null, null, null, 0L, false, false, new int[]{192, 7}, null);
        CodeGenerator_x86simd.rulev[274] = new Rule(274, false, true, 195, "274: _152 -> (SET I8 _151 regb)", null, null, null, 0L, false, false, new int[]{194, 7}, null);
        CodeGenerator_x86simd.rulev[276] = new Rule(276, false, true, 197, "276: _154 -> (SET I8 _153 regb)", null, null, null, 0L, false, false, new int[]{196, 7}, null);
        CodeGenerator_x86simd.rulev[278] = new Rule(278, false, true, 199, "278: _156 -> (SET I8 _155 regb)", null, null, null, 0L, false, false, new int[]{198, 7}, null);
        CodeGenerator_x86simd.rulev[280] = new Rule(280, false, true, 201, "280: _158 -> (SET I8 _157 regb)", null, null, null, 0L, false, false, new int[]{200, 7}, null);
        CodeGenerator_x86simd.rulev[282] = new Rule(282, false, true, 203, "282: _160 -> (SET I8 _159 regb)", null, null, null, 0L, false, false, new int[]{202, 7}, null);
        CodeGenerator_x86simd.rulev[284] = new Rule(284, false, true, 205, "284: _162 -> (SET I8 _161 regb)", null, null, null, 0L, false, false, new int[]{204, 7}, null);
        CodeGenerator_x86simd.rulev[286] = new Rule(286, false, true, 207, "286: _164 -> (SET I8 _163 regb)", null, null, null, 0L, false, false, new int[]{206, 7}, null);
        CodeGenerator_x86simd.rulev[288] = new Rule(288, false, true, 209, "288: _166 -> (SET I8 _165 regb)", null, null, null, 0L, false, false, new int[]{208, 7}, null);
        CodeGenerator_x86simd.rulev[290] = new Rule(290, false, true, 211, "290: _168 -> (SET I8 _167 regb)", null, null, null, 0L, false, false, new int[]{210, 7}, null);
        CodeGenerator_x86simd.rulev[292] = new Rule(292, false, true, 213, "292: _170 -> (SET I8 _169 regb)", null, null, null, 0L, false, false, new int[]{212, 7}, null);
        CodeGenerator_x86simd.rulev[294] = new Rule(294, false, true, 215, "294: _172 -> (SET I8 _171 regb)", null, null, null, 0L, false, false, new int[]{214, 7}, null);
        CodeGenerator_x86simd.rulev[296] = new Rule(296, false, true, 217, "296: _174 -> (SET I8 _173 regb)", null, null, null, 0L, false, false, new int[]{216, 7}, null);
        CodeGenerator_x86simd.rulev[298] = new Rule(298, false, false, 10, "298: void -> (SET I8 _143 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "0"), "$1", "%edx"), ImList.list("movb", "$2", "%dl"), ImList.list("pinsrw", ImList.list("imm", "0"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{186, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[299] = new Rule(299, false, false, 10, "299: void -> (SET I8 _147 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "1"), "$1", "%edx"), ImList.list("movb", "$2", "%dl"), ImList.list("pinsrw", ImList.list("imm", "1"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{190, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[300] = new Rule(300, false, false, 10, "300: void -> (SET I8 _151 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "2"), "$1", "%edx"), ImList.list("movb", "$2", "%dl"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{194, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[301] = new Rule(301, false, false, 10, "301: void -> (SET I8 _155 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "3"), "$1", "%edx"), ImList.list("movb", "$2", "%dl"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{198, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[302] = new Rule(302, false, false, 10, "302: void -> (SET I8 _159 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "4"), "$1", "%edx"), ImList.list("movb", "$2", "%dl"), ImList.list("pinsrw", ImList.list("imm", "4"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{202, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[303] = new Rule(303, false, false, 10, "303: void -> (SET I8 _163 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "5"), "$1", "%edx"), ImList.list("movb", "$2", "%dl"), ImList.list("pinsrw", ImList.list("imm", "5"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{206, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[304] = new Rule(304, false, false, 10, "304: void -> (SET I8 _167 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "6"), "$1", "%edx"), ImList.list("movb", "$2", "%dl"), ImList.list("pinsrw", ImList.list("imm", "6"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{210, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[305] = new Rule(305, false, false, 10, "305: void -> (SET I8 _171 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "7"), "$1", "%edx"), ImList.list("movb", "$2", "%dl"), ImList.list("pinsrw", ImList.list("imm", "7"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{214, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[306] = new Rule(306, false, false, 10, "306: void -> (SET I8 _145 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "0"), "$1", "%edx"), ImList.list("movb", "$2", "%dh"), ImList.list("pinsrw", ImList.list("imm", "0"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{188, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[307] = new Rule(307, false, false, 10, "307: void -> (SET I8 _149 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "1"), "$1", "%edx"), ImList.list("movb", "$2", "%dh"), ImList.list("pinsrw", ImList.list("imm", "1"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{192, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[308] = new Rule(308, false, false, 10, "308: void -> (SET I8 _153 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "2"), "$1", "%edx"), ImList.list("movb", "$2", "%dh"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{196, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[309] = new Rule(309, false, false, 10, "309: void -> (SET I8 _157 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "3"), "$1", "%edx"), ImList.list("movb", "$2", "%dh"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{200, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[310] = new Rule(310, false, false, 10, "310: void -> (SET I8 _161 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "4"), "$1", "%edx"), ImList.list("movb", "$2", "%dh"), ImList.list("pinsrw", ImList.list("imm", "4"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{204, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[311] = new Rule(311, false, false, 10, "311: void -> (SET I8 _165 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "5"), "$1", "%edx"), ImList.list("movb", "$2", "%dh"), ImList.list("pinsrw", ImList.list("imm", "5"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{208, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[312] = new Rule(312, false, false, 10, "312: void -> (SET I8 _169 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "6"), "$1", "%edx"), ImList.list("movb", "$2", "%dh"), ImList.list("pinsrw", ImList.list("imm", "6"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{212, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[313] = new Rule(313, false, false, 10, "313: void -> (SET I8 _173 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "7"), "$1", "%edx"), ImList.list("movb", "$2", "%dh"), ImList.list("pinsrw", ImList.list("imm", "7"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{216, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[352] = new Rule(352, false, false, 10, "352: void -> (SET I8 mregb _101)", ImList.list(ImList.list("pextrw", ImList.list("imm", "0"), "$2", "%edx"), ImList.list("movb", "%dl", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 144}, new String[]{null, null, "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[353] = new Rule(353, false, false, 10, "353: void -> (SET I8 mregb _105)", ImList.list(ImList.list("pextrw", ImList.list("imm", "1"), "$2", "%edx"), ImList.list("movb", "%dl", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 148}, new String[]{null, null, "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[354] = new Rule(354, false, false, 10, "354: void -> (SET I8 mregb _109)", ImList.list(ImList.list("pextrw", ImList.list("imm", "2"), "$2", "%edx"), ImList.list("movb", "%dl", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 152}, new String[]{null, null, "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[355] = new Rule(355, false, false, 10, "355: void -> (SET I8 mregb _113)", ImList.list(ImList.list("pextrw", ImList.list("imm", "3"), "$2", "%edx"), ImList.list("movb", "%dl", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 156}, new String[]{null, null, "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[356] = new Rule(356, false, false, 10, "356: void -> (SET I8 mregb _103)", ImList.list(ImList.list("pextrw", ImList.list("imm", "0"), "$2", "%edx"), ImList.list("movb", "%dh", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 146}, new String[]{null, null, "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[357] = new Rule(357, false, false, 10, "357: void -> (SET I8 mregb _107)", ImList.list(ImList.list("pextrw", ImList.list("imm", "1"), "$2", "%edx"), ImList.list("movb", "%dh", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 150}, new String[]{null, null, "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[358] = new Rule(358, false, false, 10, "358: void -> (SET I8 mregb _111)", ImList.list(ImList.list("pextrw", ImList.list("imm", "2"), "$2", "%edx"), ImList.list("movb", "%dh", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 154}, new String[]{null, null, "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[359] = new Rule(359, false, false, 10, "359: void -> (SET I8 mregb _115)", ImList.list(ImList.list("pextrw", ImList.list("imm", "3"), "$2", "%edx"), ImList.list("movb", "%dh", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{45, 158}, new String[]{null, null, "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[367] = new Rule(367, false, true, 243, "367: _200 -> (SET I8 _199 regb)", null, null, null, 0L, false, false, new int[]{242, 7}, null);
        CodeGenerator_x86simd.rulev[369] = new Rule(369, false, true, 245, "369: _202 -> (SET I8 _201 regb)", null, null, null, 0L, false, false, new int[]{244, 7}, null);
        CodeGenerator_x86simd.rulev[371] = new Rule(371, false, true, 247, "371: _204 -> (SET I8 _203 regb)", null, null, null, 0L, false, false, new int[]{246, 7}, null);
        CodeGenerator_x86simd.rulev[373] = new Rule(373, false, true, 249, "373: _206 -> (SET I8 _205 regb)", null, null, null, 0L, false, false, new int[]{248, 7}, null);
        CodeGenerator_x86simd.rulev[375] = new Rule(375, false, true, 251, "375: _208 -> (SET I8 _207 regb)", null, null, null, 0L, false, false, new int[]{250, 7}, null);
        CodeGenerator_x86simd.rulev[377] = new Rule(377, false, true, 253, "377: _210 -> (SET I8 _209 regb)", null, null, null, 0L, false, false, new int[]{252, 7}, null);
        CodeGenerator_x86simd.rulev[379] = new Rule(379, false, true, 255, "379: _212 -> (SET I8 _211 regb)", null, null, null, 0L, false, false, new int[]{254, 7}, null);
        CodeGenerator_x86simd.rulev[381] = new Rule(381, false, true, 257, "381: _214 -> (SET I8 _213 regb)", null, null, null, 0L, false, false, new int[]{256, 7}, null);
        CodeGenerator_x86simd.rulev[383] = new Rule(383, false, false, 10, "383: void -> (SET I8 _199 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "0"), "$1", "%edx"), ImList.list("movb", "$2", "%dl"), ImList.list("pinsrw", ImList.list("imm", "0"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{242, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[384] = new Rule(384, false, false, 10, "384: void -> (SET I8 _203 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "1"), "$1", "%edx"), ImList.list("movb", "$2", "%dl"), ImList.list("pinsrw", ImList.list("imm", "1"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{246, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[385] = new Rule(385, false, false, 10, "385: void -> (SET I8 _207 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "2"), "$1", "%edx"), ImList.list("movb", "$2", "%dl"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{250, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[386] = new Rule(386, false, false, 10, "386: void -> (SET I8 _211 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "3"), "$1", "%edx"), ImList.list("movb", "$2", "%dl"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{254, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[387] = new Rule(387, false, false, 10, "387: void -> (SET I8 _201 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "0"), "$1", "%edx"), ImList.list("movb", "$2", "%dh"), ImList.list("pinsrw", ImList.list("imm", "0"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{244, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[388] = new Rule(388, false, false, 10, "388: void -> (SET I8 _205 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "1"), "$1", "%edx"), ImList.list("movb", "$2", "%dh"), ImList.list("pinsrw", ImList.list("imm", "1"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{248, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[389] = new Rule(389, false, false, 10, "389: void -> (SET I8 _209 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "2"), "$1", "%edx"), ImList.list("movb", "$2", "%dh"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{252, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[390] = new Rule(390, false, false, 10, "390: void -> (SET I8 _213 regb)", ImList.list(ImList.list("pextrw", ImList.list("imm", "3"), "$1", "%edx"), ImList.list("movb", "$2", "%dh"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{256, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[411] = new Rule(411, false, true, 270, "411: _227 -> (SET I8 _199 con)", null, null, null, 0L, false, false, new int[]{242, 19}, null);
        CodeGenerator_x86simd.rulev[412] = new Rule(412, false, true, 271, "412: _228 -> (SET I8 _201 con)", null, null, null, 0L, false, false, new int[]{244, 19}, null);
        CodeGenerator_x86simd.rulev[413] = new Rule(413, false, true, 272, "413: _229 -> (SET I8 _203 con)", null, null, null, 0L, false, false, new int[]{246, 19}, null);
        CodeGenerator_x86simd.rulev[414] = new Rule(414, false, true, 273, "414: _230 -> (SET I8 _205 con)", null, null, null, 0L, false, false, new int[]{248, 19}, null);
        CodeGenerator_x86simd.rulev[415] = new Rule(415, false, true, 274, "415: _231 -> (SET I8 _207 con)", null, null, null, 0L, false, false, new int[]{250, 19}, null);
        CodeGenerator_x86simd.rulev[416] = new Rule(416, false, true, 275, "416: _232 -> (SET I8 _209 con)", null, null, null, 0L, false, false, new int[]{252, 19}, null);
        CodeGenerator_x86simd.rulev[417] = new Rule(417, false, true, 276, "417: _233 -> (SET I8 _211 con)", null, null, null, 0L, false, false, new int[]{254, 19}, null);
        CodeGenerator_x86simd.rulev[418] = new Rule(418, false, true, 277, "418: _234 -> (SET I8 _213 con)", null, null, null, 0L, false, false, new int[]{256, 19}, null);
        CodeGenerator_x86simd.rulev[428] = new Rule(428, false, true, 284, "428: _241 -> (SET I8 _143 con)", null, null, null, 0L, false, false, new int[]{186, 19}, null);
        CodeGenerator_x86simd.rulev[429] = new Rule(429, false, true, 285, "429: _242 -> (SET I8 _145 con)", null, null, null, 0L, false, false, new int[]{188, 19}, null);
        CodeGenerator_x86simd.rulev[430] = new Rule(430, false, true, 286, "430: _243 -> (SET I8 _147 con)", null, null, null, 0L, false, false, new int[]{190, 19}, null);
        CodeGenerator_x86simd.rulev[431] = new Rule(431, false, true, 287, "431: _244 -> (SET I8 _149 con)", null, null, null, 0L, false, false, new int[]{192, 19}, null);
        CodeGenerator_x86simd.rulev[432] = new Rule(432, false, true, 288, "432: _245 -> (SET I8 _151 con)", null, null, null, 0L, false, false, new int[]{194, 19}, null);
        CodeGenerator_x86simd.rulev[433] = new Rule(433, false, true, 289, "433: _246 -> (SET I8 _153 con)", null, null, null, 0L, false, false, new int[]{196, 19}, null);
        CodeGenerator_x86simd.rulev[434] = new Rule(434, false, true, 290, "434: _247 -> (SET I8 _155 con)", null, null, null, 0L, false, false, new int[]{198, 19}, null);
        CodeGenerator_x86simd.rulev[435] = new Rule(435, false, true, 291, "435: _248 -> (SET I8 _157 con)", null, null, null, 0L, false, false, new int[]{200, 19}, null);
        CodeGenerator_x86simd.rulev[436] = new Rule(436, false, true, 292, "436: _249 -> (SET I8 _159 con)", null, null, null, 0L, false, false, new int[]{202, 19}, null);
        CodeGenerator_x86simd.rulev[437] = new Rule(437, false, true, 293, "437: _250 -> (SET I8 _161 con)", null, null, null, 0L, false, false, new int[]{204, 19}, null);
        CodeGenerator_x86simd.rulev[438] = new Rule(438, false, true, 294, "438: _251 -> (SET I8 _163 con)", null, null, null, 0L, false, false, new int[]{206, 19}, null);
        CodeGenerator_x86simd.rulev[439] = new Rule(439, false, true, 295, "439: _252 -> (SET I8 _165 con)", null, null, null, 0L, false, false, new int[]{208, 19}, null);
        CodeGenerator_x86simd.rulev[440] = new Rule(440, false, true, 296, "440: _253 -> (SET I8 _167 con)", null, null, null, 0L, false, false, new int[]{210, 19}, null);
        CodeGenerator_x86simd.rulev[441] = new Rule(441, false, true, 297, "441: _254 -> (SET I8 _169 con)", null, null, null, 0L, false, false, new int[]{212, 19}, null);
        CodeGenerator_x86simd.rulev[442] = new Rule(442, false, true, 298, "442: _255 -> (SET I8 _171 con)", null, null, null, 0L, false, false, new int[]{214, 19}, null);
        CodeGenerator_x86simd.rulev[443] = new Rule(443, false, true, 299, "443: _256 -> (SET I8 _173 con)", null, null, null, 0L, false, false, new int[]{216, 19}, null);
        CodeGenerator_x86simd.rulev[514] = new Rule(514, false, false, 10, "514: void -> (SET I8 _101 _323)", ImList.list(ImList.list("psadbw", "$3", "$2"), ImList.list("movd", "$2", "%eax")), null, null, 0L, false, false, new int[]{144, 366}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[570] = new Rule(570, false, true, 422, "570: _379 -> (SET I8 _7 _378)", null, null, null, 0L, false, false, new int[]{50, 421}, null);
        CodeGenerator_x86simd.rulev[626] = new Rule(626, false, true, 478, "626: _435 -> (SET I8 _26 _434)", null, null, null, 0L, false, false, new int[]{69, 477}, null);
        CodeGenerator_x86simd.rulev[632] = new Rule(632, false, true, 483, "632: _440 -> (SET I8 _101 _439)", null, null, null, 0L, false, false, new int[]{144, 482}, null);
        CodeGenerator_x86simd.rulev[636] = new Rule(636, false, true, 487, "636: _444 -> (SET I8 _103 _443)", null, null, null, 0L, false, false, new int[]{146, 486}, null);
        CodeGenerator_x86simd.rulev[640] = new Rule(640, false, true, 491, "640: _448 -> (SET I8 _105 _447)", null, null, null, 0L, false, false, new int[]{148, 490}, null);
        CodeGenerator_x86simd.rulev[644] = new Rule(644, false, true, 495, "644: _452 -> (SET I8 _107 _451)", null, null, null, 0L, false, false, new int[]{150, 494}, null);
        CodeGenerator_x86simd.rulev[648] = new Rule(648, false, true, 499, "648: _456 -> (SET I8 _109 _455)", null, null, null, 0L, false, false, new int[]{152, 498}, null);
        CodeGenerator_x86simd.rulev[652] = new Rule(652, false, true, 503, "652: _460 -> (SET I8 _111 _459)", null, null, null, 0L, false, false, new int[]{154, 502}, null);
        CodeGenerator_x86simd.rulev[656] = new Rule(656, false, true, 507, "656: _464 -> (SET I8 _113 _463)", null, null, null, 0L, false, false, new int[]{156, 506}, null);
        CodeGenerator_x86simd.rulev[660] = new Rule(660, false, true, 511, "660: _468 -> (SET I8 _115 _467)", null, null, null, 0L, false, false, new int[]{158, 510}, null);
        CodeGenerator_x86simd.rulev[667] = new Rule(667, false, true, 517, "667: _474 -> (SET I8 _101 _473)", null, null, null, 0L, false, false, new int[]{144, 516}, null);
        CodeGenerator_x86simd.rulev[673] = new Rule(673, false, true, 523, "673: _480 -> (SET I8 _103 _479)", null, null, null, 0L, false, false, new int[]{146, 522}, null);
        CodeGenerator_x86simd.rulev[679] = new Rule(679, false, true, 529, "679: _486 -> (SET I8 _105 _485)", null, null, null, 0L, false, false, new int[]{148, 528}, null);
        CodeGenerator_x86simd.rulev[685] = new Rule(685, false, true, 535, "685: _492 -> (SET I8 _107 _491)", null, null, null, 0L, false, false, new int[]{150, 534}, null);
        CodeGenerator_x86simd.rulev[691] = new Rule(691, false, true, 541, "691: _498 -> (SET I8 _109 _497)", null, null, null, 0L, false, false, new int[]{152, 540}, null);
    }

    private static void rrinit3000() {
        CodeGenerator_x86simd.rulev[697] = new Rule(697, false, true, 547, "697: _504 -> (SET I8 _111 _503)", null, null, null, 0L, false, false, new int[]{154, 546}, null);
        CodeGenerator_x86simd.rulev[703] = new Rule(703, false, true, 553, "703: _510 -> (SET I8 _113 _509)", null, null, null, 0L, false, false, new int[]{156, 552}, null);
        CodeGenerator_x86simd.rulev[709] = new Rule(709, false, true, 559, "709: _516 -> (SET I8 _115 _515)", null, null, null, 0L, false, false, new int[]{158, 558}, null);
        CodeGenerator_x86simd.rulev[714] = new Rule(714, false, true, 563, "714: _520 -> (SET I8 _7 _519)", null, null, null, 0L, false, false, new int[]{50, 562}, null);
        CodeGenerator_x86simd.rulev[718] = new Rule(718, false, true, 567, "718: _524 -> (SET I8 _9 _523)", null, null, null, 0L, false, false, new int[]{52, 566}, null);
        CodeGenerator_x86simd.rulev[722] = new Rule(722, false, true, 571, "722: _528 -> (SET I8 _11 _527)", null, null, null, 0L, false, false, new int[]{54, 570}, null);
        CodeGenerator_x86simd.rulev[726] = new Rule(726, false, true, 575, "726: _532 -> (SET I8 _13 _531)", null, null, null, 0L, false, false, new int[]{56, 574}, null);
        CodeGenerator_x86simd.rulev[730] = new Rule(730, false, true, 579, "730: _536 -> (SET I8 _15 _535)", null, null, null, 0L, false, false, new int[]{58, 578}, null);
        CodeGenerator_x86simd.rulev[734] = new Rule(734, false, true, 583, "734: _540 -> (SET I8 _18 _539)", null, null, null, 0L, false, false, new int[]{61, 582}, null);
        CodeGenerator_x86simd.rulev[738] = new Rule(738, false, true, 587, "738: _544 -> (SET I8 _21 _543)", null, null, null, 0L, false, false, new int[]{64, 586}, null);
        CodeGenerator_x86simd.rulev[742] = new Rule(742, false, true, 591, "742: _548 -> (SET I8 _24 _547)", null, null, null, 0L, false, false, new int[]{67, 590}, null);
        CodeGenerator_x86simd.rulev[746] = new Rule(746, false, true, 595, "746: _552 -> (SET I8 _26 _551)", null, null, null, 0L, false, false, new int[]{69, 594}, null);
        CodeGenerator_x86simd.rulev[750] = new Rule(750, false, true, 599, "750: _556 -> (SET I8 _29 _555)", null, null, null, 0L, false, false, new int[]{72, 598}, null);
        CodeGenerator_x86simd.rulev[754] = new Rule(754, false, true, 603, "754: _560 -> (SET I8 _32 _559)", null, null, null, 0L, false, false, new int[]{75, 602}, null);
        CodeGenerator_x86simd.rulev[758] = new Rule(758, false, true, 607, "758: _564 -> (SET I8 _35 _563)", null, null, null, 0L, false, false, new int[]{78, 606}, null);
        CodeGenerator_x86simd.rulev[762] = new Rule(762, false, true, 611, "762: _568 -> (SET I8 _38 _567)", null, null, null, 0L, false, false, new int[]{81, 610}, null);
        CodeGenerator_x86simd.rulev[766] = new Rule(766, false, true, 615, "766: _572 -> (SET I8 _41 _571)", null, null, null, 0L, false, false, new int[]{84, 614}, null);
        CodeGenerator_x86simd.rulev[770] = new Rule(770, false, true, 619, "770: _576 -> (SET I8 _44 _575)", null, null, null, 0L, false, false, new int[]{87, 618}, null);
        CodeGenerator_x86simd.rulev[774] = new Rule(774, false, true, 623, "774: _580 -> (SET I8 _47 _579)", null, null, null, 0L, false, false, new int[]{90, 622}, null);
        CodeGenerator_x86simd.rulev[781] = new Rule(781, false, true, 629, "781: _586 -> (SET I8 _7 _585)", null, null, null, 0L, false, false, new int[]{50, 628}, null);
        CodeGenerator_x86simd.rulev[787] = new Rule(787, false, true, 635, "787: _592 -> (SET I8 _9 _591)", null, null, null, 0L, false, false, new int[]{52, 634}, null);
        CodeGenerator_x86simd.rulev[793] = new Rule(793, false, true, 641, "793: _598 -> (SET I8 _11 _597)", null, null, null, 0L, false, false, new int[]{54, 640}, null);
        CodeGenerator_x86simd.rulev[799] = new Rule(799, false, true, 647, "799: _604 -> (SET I8 _13 _603)", null, null, null, 0L, false, false, new int[]{56, 646}, null);
        CodeGenerator_x86simd.rulev[805] = new Rule(805, false, true, 653, "805: _610 -> (SET I8 _15 _609)", null, null, null, 0L, false, false, new int[]{58, 652}, null);
        CodeGenerator_x86simd.rulev[811] = new Rule(811, false, true, 659, "811: _616 -> (SET I8 _18 _615)", null, null, null, 0L, false, false, new int[]{61, 658}, null);
        CodeGenerator_x86simd.rulev[817] = new Rule(817, false, true, 665, "817: _622 -> (SET I8 _21 _621)", null, null, null, 0L, false, false, new int[]{64, 664}, null);
        CodeGenerator_x86simd.rulev[823] = new Rule(823, false, true, 671, "823: _628 -> (SET I8 _24 _627)", null, null, null, 0L, false, false, new int[]{67, 670}, null);
        CodeGenerator_x86simd.rulev[829] = new Rule(829, false, true, 677, "829: _634 -> (SET I8 _26 _633)", null, null, null, 0L, false, false, new int[]{69, 676}, null);
        CodeGenerator_x86simd.rulev[835] = new Rule(835, false, true, 683, "835: _640 -> (SET I8 _29 _639)", null, null, null, 0L, false, false, new int[]{72, 682}, null);
        CodeGenerator_x86simd.rulev[841] = new Rule(841, false, true, 689, "841: _646 -> (SET I8 _32 _645)", null, null, null, 0L, false, false, new int[]{75, 688}, null);
        CodeGenerator_x86simd.rulev[847] = new Rule(847, false, true, 695, "847: _652 -> (SET I8 _35 _651)", null, null, null, 0L, false, false, new int[]{78, 694}, null);
        CodeGenerator_x86simd.rulev[853] = new Rule(853, false, true, 701, "853: _658 -> (SET I8 _38 _657)", null, null, null, 0L, false, false, new int[]{81, 700}, null);
        CodeGenerator_x86simd.rulev[859] = new Rule(859, false, true, 707, "859: _664 -> (SET I8 _41 _663)", null, null, null, 0L, false, false, new int[]{84, 706}, null);
        CodeGenerator_x86simd.rulev[865] = new Rule(865, false, true, 713, "865: _670 -> (SET I8 _44 _669)", null, null, null, 0L, false, false, new int[]{87, 712}, null);
        CodeGenerator_x86simd.rulev[871] = new Rule(871, false, true, 719, "871: _676 -> (SET I8 _47 _675)", null, null, null, 0L, false, false, new int[]{90, 718}, null);
        CodeGenerator_x86simd.rulev[1003] = new Rule(1003, false, true, 846, "1003: _803 -> (SET I8 _101 _802)", null, null, null, 0L, false, false, new int[]{144, 845}, null);
        CodeGenerator_x86simd.rulev[1009] = new Rule(1009, false, true, 852, "1009: _809 -> (SET I8 _103 _808)", null, null, null, 0L, false, false, new int[]{146, 851}, null);
        CodeGenerator_x86simd.rulev[1015] = new Rule(1015, false, true, 858, "1015: _815 -> (SET I8 _105 _814)", null, null, null, 0L, false, false, new int[]{148, 857}, null);
        CodeGenerator_x86simd.rulev[1021] = new Rule(1021, false, true, 864, "1021: _821 -> (SET I8 _107 _820)", null, null, null, 0L, false, false, new int[]{150, 863}, null);
        CodeGenerator_x86simd.rulev[1027] = new Rule(1027, false, true, 870, "1027: _827 -> (SET I8 _109 _826)", null, null, null, 0L, false, false, new int[]{152, 869}, null);
        CodeGenerator_x86simd.rulev[1033] = new Rule(1033, false, true, 876, "1033: _833 -> (SET I8 _111 _832)", null, null, null, 0L, false, false, new int[]{154, 875}, null);
        CodeGenerator_x86simd.rulev[1039] = new Rule(1039, false, true, 882, "1039: _839 -> (SET I8 _113 _838)", null, null, null, 0L, false, false, new int[]{156, 881}, null);
        CodeGenerator_x86simd.rulev[1045] = new Rule(1045, false, true, 888, "1045: _845 -> (SET I8 _115 _844)", null, null, null, 0L, false, false, new int[]{158, 887}, null);
        CodeGenerator_x86simd.rulev[1052] = new Rule(1052, false, true, 894, "1052: _851 -> (SET I8 _101 _850)", null, null, null, 0L, false, false, new int[]{144, 893}, null);
        CodeGenerator_x86simd.rulev[1058] = new Rule(1058, false, true, 900, "1058: _857 -> (SET I8 _103 _856)", null, null, null, 0L, false, false, new int[]{146, 899}, null);
        CodeGenerator_x86simd.rulev[1064] = new Rule(1064, false, true, 906, "1064: _863 -> (SET I8 _105 _862)", null, null, null, 0L, false, false, new int[]{148, 905}, null);
        CodeGenerator_x86simd.rulev[1070] = new Rule(1070, false, true, 912, "1070: _869 -> (SET I8 _107 _868)", null, null, null, 0L, false, false, new int[]{150, 911}, null);
        CodeGenerator_x86simd.rulev[1076] = new Rule(1076, false, true, 918, "1076: _875 -> (SET I8 _109 _874)", null, null, null, 0L, false, false, new int[]{152, 917}, null);
        CodeGenerator_x86simd.rulev[1082] = new Rule(1082, false, true, 924, "1082: _881 -> (SET I8 _111 _880)", null, null, null, 0L, false, false, new int[]{154, 923}, null);
        CodeGenerator_x86simd.rulev[1088] = new Rule(1088, false, true, 930, "1088: _887 -> (SET I8 _113 _886)", null, null, null, 0L, false, false, new int[]{156, 929}, null);
        CodeGenerator_x86simd.rulev[1094] = new Rule(1094, false, true, 936, "1094: _893 -> (SET I8 _115 _892)", null, null, null, 0L, false, false, new int[]{158, 935}, null);
        CodeGenerator_x86simd.rulev[1101] = new Rule(1101, false, true, 942, "1101: _899 -> (SET I8 _7 _898)", null, null, null, 0L, false, false, new int[]{50, 941}, null);
        CodeGenerator_x86simd.rulev[1107] = new Rule(1107, false, true, 948, "1107: _905 -> (SET I8 _9 _904)", null, null, null, 0L, false, false, new int[]{52, 947}, null);
        CodeGenerator_x86simd.rulev[1113] = new Rule(1113, false, true, 954, "1113: _911 -> (SET I8 _11 _910)", null, null, null, 0L, false, false, new int[]{54, 953}, null);
        CodeGenerator_x86simd.rulev[1119] = new Rule(1119, false, true, 960, "1119: _917 -> (SET I8 _13 _916)", null, null, null, 0L, false, false, new int[]{56, 959}, null);
        CodeGenerator_x86simd.rulev[1125] = new Rule(1125, false, true, 966, "1125: _923 -> (SET I8 _15 _922)", null, null, null, 0L, false, false, new int[]{58, 965}, null);
        CodeGenerator_x86simd.rulev[1131] = new Rule(1131, false, true, 972, "1131: _929 -> (SET I8 _18 _928)", null, null, null, 0L, false, false, new int[]{61, 971}, null);
        CodeGenerator_x86simd.rulev[1137] = new Rule(1137, false, true, 978, "1137: _935 -> (SET I8 _21 _934)", null, null, null, 0L, false, false, new int[]{64, 977}, null);
        CodeGenerator_x86simd.rulev[1143] = new Rule(1143, false, true, 984, "1143: _941 -> (SET I8 _24 _940)", null, null, null, 0L, false, false, new int[]{67, 983}, null);
        CodeGenerator_x86simd.rulev[1149] = new Rule(1149, false, true, 990, "1149: _947 -> (SET I8 _26 _946)", null, null, null, 0L, false, false, new int[]{69, 989}, null);
        CodeGenerator_x86simd.rulev[1155] = new Rule(1155, false, true, 996, "1155: _953 -> (SET I8 _29 _952)", null, null, null, 0L, false, false, new int[]{72, 995}, null);
        CodeGenerator_x86simd.rulev[1161] = new Rule(1161, false, true, 1002, "1161: _959 -> (SET I8 _32 _958)", null, null, null, 0L, false, false, new int[]{75, 1001}, null);
        CodeGenerator_x86simd.rulev[1167] = new Rule(1167, false, true, 1008, "1167: _965 -> (SET I8 _35 _964)", null, null, null, 0L, false, false, new int[]{78, 1007}, null);
        CodeGenerator_x86simd.rulev[1173] = new Rule(1173, false, true, 1014, "1173: _971 -> (SET I8 _38 _970)", null, null, null, 0L, false, false, new int[]{81, 1013}, null);
        CodeGenerator_x86simd.rulev[1179] = new Rule(1179, false, true, 1020, "1179: _977 -> (SET I8 _41 _976)", null, null, null, 0L, false, false, new int[]{84, 1019}, null);
        CodeGenerator_x86simd.rulev[1185] = new Rule(1185, false, true, 1026, "1185: _983 -> (SET I8 _44 _982)", null, null, null, 0L, false, false, new int[]{87, 1025}, null);
        CodeGenerator_x86simd.rulev[1191] = new Rule(1191, false, true, 1032, "1191: _989 -> (SET I8 _47 _988)", null, null, null, 0L, false, false, new int[]{90, 1031}, null);
        CodeGenerator_x86simd.rulev[1198] = new Rule(1198, false, true, 1038, "1198: _995 -> (SET I8 _7 _994)", null, null, null, 0L, false, false, new int[]{50, 1037}, null);
        CodeGenerator_x86simd.rulev[1204] = new Rule(1204, false, true, 1044, "1204: _1001 -> (SET I8 _9 _1000)", null, null, null, 0L, false, false, new int[]{52, 1043}, null);
        CodeGenerator_x86simd.rulev[1210] = new Rule(1210, false, true, 1050, "1210: _1007 -> (SET I8 _11 _1006)", null, null, null, 0L, false, false, new int[]{54, 1049}, null);
        CodeGenerator_x86simd.rulev[1216] = new Rule(1216, false, true, 1056, "1216: _1013 -> (SET I8 _13 _1012)", null, null, null, 0L, false, false, new int[]{56, 1055}, null);
        CodeGenerator_x86simd.rulev[1222] = new Rule(1222, false, true, 1062, "1222: _1019 -> (SET I8 _15 _1018)", null, null, null, 0L, false, false, new int[]{58, 1061}, null);
        CodeGenerator_x86simd.rulev[1228] = new Rule(1228, false, true, 1068, "1228: _1025 -> (SET I8 _18 _1024)", null, null, null, 0L, false, false, new int[]{61, 1067}, null);
        CodeGenerator_x86simd.rulev[1234] = new Rule(1234, false, true, 1074, "1234: _1031 -> (SET I8 _21 _1030)", null, null, null, 0L, false, false, new int[]{64, 1073}, null);
        CodeGenerator_x86simd.rulev[1240] = new Rule(1240, false, true, 1080, "1240: _1037 -> (SET I8 _24 _1036)", null, null, null, 0L, false, false, new int[]{67, 1079}, null);
        CodeGenerator_x86simd.rulev[1246] = new Rule(1246, false, true, 1086, "1246: _1043 -> (SET I8 _26 _1042)", null, null, null, 0L, false, false, new int[]{69, 1085}, null);
        CodeGenerator_x86simd.rulev[1252] = new Rule(1252, false, true, 1092, "1252: _1049 -> (SET I8 _29 _1048)", null, null, null, 0L, false, false, new int[]{72, 1091}, null);
        CodeGenerator_x86simd.rulev[1258] = new Rule(1258, false, true, 1098, "1258: _1055 -> (SET I8 _32 _1054)", null, null, null, 0L, false, false, new int[]{75, 1097}, null);
        CodeGenerator_x86simd.rulev[1264] = new Rule(1264, false, true, 1104, "1264: _1061 -> (SET I8 _35 _1060)", null, null, null, 0L, false, false, new int[]{78, 1103}, null);
        CodeGenerator_x86simd.rulev[1270] = new Rule(1270, false, true, 1110, "1270: _1067 -> (SET I8 _38 _1066)", null, null, null, 0L, false, false, new int[]{81, 1109}, null);
        CodeGenerator_x86simd.rulev[1276] = new Rule(1276, false, true, 1116, "1276: _1073 -> (SET I8 _41 _1072)", null, null, null, 0L, false, false, new int[]{84, 1115}, null);
        CodeGenerator_x86simd.rulev[1282] = new Rule(1282, false, true, 1122, "1282: _1079 -> (SET I8 _44 _1078)", null, null, null, 0L, false, false, new int[]{87, 1121}, null);
        CodeGenerator_x86simd.rulev[1288] = new Rule(1288, false, true, 1128, "1288: _1085 -> (SET I8 _47 _1084)", null, null, null, 0L, false, false, new int[]{90, 1127}, null);
        CodeGenerator_x86simd.rulev[1443] = new Rule(1443, false, true, 1278, "1443: _1235 -> (SET I8 _101 _1234)", null, null, null, 0L, false, false, new int[]{144, 1277}, null);
        CodeGenerator_x86simd.rulev[1449] = new Rule(1449, false, true, 1284, "1449: _1241 -> (SET I8 _103 _1240)", null, null, null, 0L, false, false, new int[]{146, 1283}, null);
        CodeGenerator_x86simd.rulev[1455] = new Rule(1455, false, true, 1290, "1455: _1247 -> (SET I8 _105 _1246)", null, null, null, 0L, false, false, new int[]{148, 1289}, null);
        CodeGenerator_x86simd.rulev[1461] = new Rule(1461, false, true, 1296, "1461: _1253 -> (SET I8 _107 _1252)", null, null, null, 0L, false, false, new int[]{150, 1295}, null);
        CodeGenerator_x86simd.rulev[1467] = new Rule(1467, false, true, 1302, "1467: _1259 -> (SET I8 _109 _1258)", null, null, null, 0L, false, false, new int[]{152, 1301}, null);
        CodeGenerator_x86simd.rulev[1473] = new Rule(1473, false, true, 1308, "1473: _1265 -> (SET I8 _111 _1264)", null, null, null, 0L, false, false, new int[]{154, 1307}, null);
        CodeGenerator_x86simd.rulev[1479] = new Rule(1479, false, true, 1314, "1479: _1271 -> (SET I8 _113 _1270)", null, null, null, 0L, false, false, new int[]{156, 1313}, null);
        CodeGenerator_x86simd.rulev[1485] = new Rule(1485, false, true, 1320, "1485: _1277 -> (SET I8 _115 _1276)", null, null, null, 0L, false, false, new int[]{158, 1319}, null);
        CodeGenerator_x86simd.rulev[1492] = new Rule(1492, false, true, 1326, "1492: _1283 -> (SET I8 _101 _1282)", null, null, null, 0L, false, false, new int[]{144, 1325}, null);
        CodeGenerator_x86simd.rulev[1498] = new Rule(1498, false, true, 1332, "1498: _1289 -> (SET I8 _103 _1288)", null, null, null, 0L, false, false, new int[]{146, 1331}, null);
        CodeGenerator_x86simd.rulev[1504] = new Rule(1504, false, true, 1338, "1504: _1295 -> (SET I8 _105 _1294)", null, null, null, 0L, false, false, new int[]{148, 1337}, null);
        CodeGenerator_x86simd.rulev[1510] = new Rule(1510, false, true, 1344, "1510: _1301 -> (SET I8 _107 _1300)", null, null, null, 0L, false, false, new int[]{150, 1343}, null);
        CodeGenerator_x86simd.rulev[1516] = new Rule(1516, false, true, 1350, "1516: _1307 -> (SET I8 _109 _1306)", null, null, null, 0L, false, false, new int[]{152, 1349}, null);
        CodeGenerator_x86simd.rulev[1522] = new Rule(1522, false, true, 1356, "1522: _1313 -> (SET I8 _111 _1312)", null, null, null, 0L, false, false, new int[]{154, 1355}, null);
        CodeGenerator_x86simd.rulev[1528] = new Rule(1528, false, true, 1362, "1528: _1319 -> (SET I8 _113 _1318)", null, null, null, 0L, false, false, new int[]{156, 1361}, null);
        CodeGenerator_x86simd.rulev[1534] = new Rule(1534, false, true, 1368, "1534: _1325 -> (SET I8 _115 _1324)", null, null, null, 0L, false, false, new int[]{158, 1367}, null);
        CodeGenerator_x86simd.rulev[1617] = new Rule(1617, false, true, 1446, "1617: _1403 -> (SET I8 _7 _1402)", null, null, null, 0L, false, false, new int[]{50, 1445}, null);
    }

    private static void rrinit3100() {
        CodeGenerator_x86simd.rulev[1623] = new Rule(1623, false, true, 1452, "1623: _1409 -> (SET I8 _9 _1408)", null, null, null, 0L, false, false, new int[]{52, 1451}, null);
        CodeGenerator_x86simd.rulev[1629] = new Rule(1629, false, true, 1458, "1629: _1415 -> (SET I8 _11 _1414)", null, null, null, 0L, false, false, new int[]{54, 1457}, null);
        CodeGenerator_x86simd.rulev[1635] = new Rule(1635, false, true, 1464, "1635: _1421 -> (SET I8 _13 _1420)", null, null, null, 0L, false, false, new int[]{56, 1463}, null);
        CodeGenerator_x86simd.rulev[1641] = new Rule(1641, false, true, 1470, "1641: _1427 -> (SET I8 _15 _1426)", null, null, null, 0L, false, false, new int[]{58, 1469}, null);
        CodeGenerator_x86simd.rulev[1647] = new Rule(1647, false, true, 1476, "1647: _1433 -> (SET I8 _18 _1432)", null, null, null, 0L, false, false, new int[]{61, 1475}, null);
        CodeGenerator_x86simd.rulev[1653] = new Rule(1653, false, true, 1482, "1653: _1439 -> (SET I8 _21 _1438)", null, null, null, 0L, false, false, new int[]{64, 1481}, null);
        CodeGenerator_x86simd.rulev[1659] = new Rule(1659, false, true, 1488, "1659: _1445 -> (SET I8 _24 _1444)", null, null, null, 0L, false, false, new int[]{67, 1487}, null);
        CodeGenerator_x86simd.rulev[1665] = new Rule(1665, false, true, 1494, "1665: _1451 -> (SET I8 _26 _1450)", null, null, null, 0L, false, false, new int[]{69, 1493}, null);
        CodeGenerator_x86simd.rulev[1671] = new Rule(1671, false, true, 1500, "1671: _1457 -> (SET I8 _29 _1456)", null, null, null, 0L, false, false, new int[]{72, 1499}, null);
        CodeGenerator_x86simd.rulev[1677] = new Rule(1677, false, true, 1506, "1677: _1463 -> (SET I8 _32 _1462)", null, null, null, 0L, false, false, new int[]{75, 1505}, null);
        CodeGenerator_x86simd.rulev[1683] = new Rule(1683, false, true, 1512, "1683: _1469 -> (SET I8 _35 _1468)", null, null, null, 0L, false, false, new int[]{78, 1511}, null);
        CodeGenerator_x86simd.rulev[1689] = new Rule(1689, false, true, 1518, "1689: _1475 -> (SET I8 _38 _1474)", null, null, null, 0L, false, false, new int[]{81, 1517}, null);
        CodeGenerator_x86simd.rulev[1695] = new Rule(1695, false, true, 1524, "1695: _1481 -> (SET I8 _41 _1480)", null, null, null, 0L, false, false, new int[]{84, 1523}, null);
        CodeGenerator_x86simd.rulev[1701] = new Rule(1701, false, true, 1530, "1701: _1487 -> (SET I8 _44 _1486)", null, null, null, 0L, false, false, new int[]{87, 1529}, null);
        CodeGenerator_x86simd.rulev[1707] = new Rule(1707, false, true, 1536, "1707: _1493 -> (SET I8 _47 _1492)", null, null, null, 0L, false, false, new int[]{90, 1535}, null);
        CodeGenerator_x86simd.rulev[1714] = new Rule(1714, false, true, 1542, "1714: _1499 -> (SET I8 _7 _1498)", null, null, null, 0L, false, false, new int[]{50, 1541}, null);
        CodeGenerator_x86simd.rulev[1720] = new Rule(1720, false, true, 1548, "1720: _1505 -> (SET I8 _9 _1504)", null, null, null, 0L, false, false, new int[]{52, 1547}, null);
        CodeGenerator_x86simd.rulev[1726] = new Rule(1726, false, true, 1554, "1726: _1511 -> (SET I8 _11 _1510)", null, null, null, 0L, false, false, new int[]{54, 1553}, null);
        CodeGenerator_x86simd.rulev[1732] = new Rule(1732, false, true, 1560, "1732: _1517 -> (SET I8 _13 _1516)", null, null, null, 0L, false, false, new int[]{56, 1559}, null);
        CodeGenerator_x86simd.rulev[1738] = new Rule(1738, false, true, 1566, "1738: _1523 -> (SET I8 _15 _1522)", null, null, null, 0L, false, false, new int[]{58, 1565}, null);
        CodeGenerator_x86simd.rulev[1744] = new Rule(1744, false, true, 1572, "1744: _1529 -> (SET I8 _18 _1528)", null, null, null, 0L, false, false, new int[]{61, 1571}, null);
        CodeGenerator_x86simd.rulev[1750] = new Rule(1750, false, true, 1578, "1750: _1535 -> (SET I8 _21 _1534)", null, null, null, 0L, false, false, new int[]{64, 1577}, null);
        CodeGenerator_x86simd.rulev[1756] = new Rule(1756, false, true, 1584, "1756: _1541 -> (SET I8 _24 _1540)", null, null, null, 0L, false, false, new int[]{67, 1583}, null);
        CodeGenerator_x86simd.rulev[1762] = new Rule(1762, false, true, 1590, "1762: _1547 -> (SET I8 _26 _1546)", null, null, null, 0L, false, false, new int[]{69, 1589}, null);
        CodeGenerator_x86simd.rulev[1768] = new Rule(1768, false, true, 1596, "1768: _1553 -> (SET I8 _29 _1552)", null, null, null, 0L, false, false, new int[]{72, 1595}, null);
        CodeGenerator_x86simd.rulev[1774] = new Rule(1774, false, true, 1602, "1774: _1559 -> (SET I8 _32 _1558)", null, null, null, 0L, false, false, new int[]{75, 1601}, null);
        CodeGenerator_x86simd.rulev[1780] = new Rule(1780, false, true, 1608, "1780: _1565 -> (SET I8 _35 _1564)", null, null, null, 0L, false, false, new int[]{78, 1607}, null);
        CodeGenerator_x86simd.rulev[1786] = new Rule(1786, false, true, 1614, "1786: _1571 -> (SET I8 _38 _1570)", null, null, null, 0L, false, false, new int[]{81, 1613}, null);
        CodeGenerator_x86simd.rulev[1792] = new Rule(1792, false, true, 1620, "1792: _1577 -> (SET I8 _41 _1576)", null, null, null, 0L, false, false, new int[]{84, 1619}, null);
        CodeGenerator_x86simd.rulev[1798] = new Rule(1798, false, true, 1626, "1798: _1583 -> (SET I8 _44 _1582)", null, null, null, 0L, false, false, new int[]{87, 1625}, null);
        CodeGenerator_x86simd.rulev[1804] = new Rule(1804, false, true, 1632, "1804: _1589 -> (SET I8 _47 _1588)", null, null, null, 0L, false, false, new int[]{90, 1631}, null);
        CodeGenerator_x86simd.rulev[1959] = new Rule(1959, false, true, 1782, "1959: _1739 -> (SET I8 _101 _1738)", null, null, null, 0L, false, false, new int[]{144, 1781}, null);
        CodeGenerator_x86simd.rulev[1965] = new Rule(1965, false, true, 1788, "1965: _1745 -> (SET I8 _103 _1744)", null, null, null, 0L, false, false, new int[]{146, 1787}, null);
        CodeGenerator_x86simd.rulev[1971] = new Rule(1971, false, true, 1794, "1971: _1751 -> (SET I8 _105 _1750)", null, null, null, 0L, false, false, new int[]{148, 1793}, null);
        CodeGenerator_x86simd.rulev[1977] = new Rule(1977, false, true, 1800, "1977: _1757 -> (SET I8 _107 _1756)", null, null, null, 0L, false, false, new int[]{150, 1799}, null);
        CodeGenerator_x86simd.rulev[1983] = new Rule(1983, false, true, 1806, "1983: _1763 -> (SET I8 _109 _1762)", null, null, null, 0L, false, false, new int[]{152, 1805}, null);
        CodeGenerator_x86simd.rulev[1989] = new Rule(1989, false, true, 1812, "1989: _1769 -> (SET I8 _111 _1768)", null, null, null, 0L, false, false, new int[]{154, 1811}, null);
        CodeGenerator_x86simd.rulev[1995] = new Rule(1995, false, true, 1818, "1995: _1775 -> (SET I8 _113 _1774)", null, null, null, 0L, false, false, new int[]{156, 1817}, null);
        CodeGenerator_x86simd.rulev[2001] = new Rule(2001, false, true, 1824, "2001: _1781 -> (SET I8 _115 _1780)", null, null, null, 0L, false, false, new int[]{158, 1823}, null);
        CodeGenerator_x86simd.rulev[2006] = new Rule(2006, false, true, 1828, "2006: _1785 -> (SET I8 _101 _1784)", null, null, null, 0L, false, false, new int[]{144, 1827}, null);
        CodeGenerator_x86simd.rulev[2010] = new Rule(2010, false, true, 1832, "2010: _1789 -> (SET I8 _103 _1788)", null, null, null, 0L, false, false, new int[]{146, 1831}, null);
        CodeGenerator_x86simd.rulev[2014] = new Rule(2014, false, true, 1836, "2014: _1793 -> (SET I8 _105 _1792)", null, null, null, 0L, false, false, new int[]{148, 1835}, null);
        CodeGenerator_x86simd.rulev[2018] = new Rule(2018, false, true, 1840, "2018: _1797 -> (SET I8 _107 _1796)", null, null, null, 0L, false, false, new int[]{150, 1839}, null);
        CodeGenerator_x86simd.rulev[2022] = new Rule(2022, false, true, 1844, "2022: _1801 -> (SET I8 _109 _1800)", null, null, null, 0L, false, false, new int[]{152, 1843}, null);
        CodeGenerator_x86simd.rulev[2026] = new Rule(2026, false, true, 1848, "2026: _1805 -> (SET I8 _111 _1804)", null, null, null, 0L, false, false, new int[]{154, 1847}, null);
        CodeGenerator_x86simd.rulev[2030] = new Rule(2030, false, true, 1852, "2030: _1809 -> (SET I8 _113 _1808)", null, null, null, 0L, false, false, new int[]{156, 1851}, null);
        CodeGenerator_x86simd.rulev[2034] = new Rule(2034, false, true, 1856, "2034: _1813 -> (SET I8 _115 _1812)", null, null, null, 0L, false, false, new int[]{158, 1855}, null);
        CodeGenerator_x86simd.rulev[2117] = new Rule(2117, false, true, 1934, "2117: _1891 -> (SET I8 _7 _1890)", null, null, null, 0L, false, false, new int[]{50, 1933}, null);
        CodeGenerator_x86simd.rulev[2123] = new Rule(2123, false, true, 1940, "2123: _1897 -> (SET I8 _9 _1896)", null, null, null, 0L, false, false, new int[]{52, 1939}, null);
        CodeGenerator_x86simd.rulev[2129] = new Rule(2129, false, true, 1946, "2129: _1903 -> (SET I8 _11 _1902)", null, null, null, 0L, false, false, new int[]{54, 1945}, null);
        CodeGenerator_x86simd.rulev[2135] = new Rule(2135, false, true, 1952, "2135: _1909 -> (SET I8 _13 _1908)", null, null, null, 0L, false, false, new int[]{56, 1951}, null);
        CodeGenerator_x86simd.rulev[2141] = new Rule(2141, false, true, 1958, "2141: _1915 -> (SET I8 _15 _1914)", null, null, null, 0L, false, false, new int[]{58, 1957}, null);
        CodeGenerator_x86simd.rulev[2147] = new Rule(2147, false, true, 1964, "2147: _1921 -> (SET I8 _18 _1920)", null, null, null, 0L, false, false, new int[]{61, 1963}, null);
        CodeGenerator_x86simd.rulev[2153] = new Rule(2153, false, true, 1970, "2153: _1927 -> (SET I8 _21 _1926)", null, null, null, 0L, false, false, new int[]{64, 1969}, null);
        CodeGenerator_x86simd.rulev[2159] = new Rule(2159, false, true, 1976, "2159: _1933 -> (SET I8 _24 _1932)", null, null, null, 0L, false, false, new int[]{67, 1975}, null);
        CodeGenerator_x86simd.rulev[2165] = new Rule(2165, false, true, 1982, "2165: _1939 -> (SET I8 _26 _1938)", null, null, null, 0L, false, false, new int[]{69, 1981}, null);
        CodeGenerator_x86simd.rulev[2171] = new Rule(2171, false, true, 1988, "2171: _1945 -> (SET I8 _29 _1944)", null, null, null, 0L, false, false, new int[]{72, 1987}, null);
        CodeGenerator_x86simd.rulev[2177] = new Rule(2177, false, true, 1994, "2177: _1951 -> (SET I8 _32 _1950)", null, null, null, 0L, false, false, new int[]{75, 1993}, null);
        CodeGenerator_x86simd.rulev[2183] = new Rule(2183, false, true, 2000, "2183: _1957 -> (SET I8 _35 _1956)", null, null, null, 0L, false, false, new int[]{78, 1999}, null);
        CodeGenerator_x86simd.rulev[2189] = new Rule(2189, false, true, 2006, "2189: _1963 -> (SET I8 _38 _1962)", null, null, null, 0L, false, false, new int[]{81, 2005}, null);
        CodeGenerator_x86simd.rulev[2195] = new Rule(2195, false, true, 2012, "2195: _1969 -> (SET I8 _41 _1968)", null, null, null, 0L, false, false, new int[]{84, 2011}, null);
        CodeGenerator_x86simd.rulev[2201] = new Rule(2201, false, true, 2018, "2201: _1975 -> (SET I8 _44 _1974)", null, null, null, 0L, false, false, new int[]{87, 2017}, null);
        CodeGenerator_x86simd.rulev[2207] = new Rule(2207, false, true, 2024, "2207: _1981 -> (SET I8 _47 _1980)", null, null, null, 0L, false, false, new int[]{90, 2023}, null);
        CodeGenerator_x86simd.rulev[2212] = new Rule(2212, false, true, 2028, "2212: _1985 -> (SET I8 _7 _1984)", null, null, null, 0L, false, false, new int[]{50, 2027}, null);
        CodeGenerator_x86simd.rulev[2216] = new Rule(2216, false, true, 2032, "2216: _1989 -> (SET I8 _9 _1988)", null, null, null, 0L, false, false, new int[]{52, 2031}, null);
        CodeGenerator_x86simd.rulev[2220] = new Rule(2220, false, true, 2036, "2220: _1993 -> (SET I8 _11 _1992)", null, null, null, 0L, false, false, new int[]{54, 2035}, null);
        CodeGenerator_x86simd.rulev[2224] = new Rule(2224, false, true, 2040, "2224: _1997 -> (SET I8 _13 _1996)", null, null, null, 0L, false, false, new int[]{56, 2039}, null);
        CodeGenerator_x86simd.rulev[2228] = new Rule(2228, false, true, 2044, "2228: _2001 -> (SET I8 _15 _2000)", null, null, null, 0L, false, false, new int[]{58, 2043}, null);
        CodeGenerator_x86simd.rulev[2232] = new Rule(2232, false, true, 2048, "2232: _2005 -> (SET I8 _18 _2004)", null, null, null, 0L, false, false, new int[]{61, 2047}, null);
        CodeGenerator_x86simd.rulev[2236] = new Rule(2236, false, true, 2052, "2236: _2009 -> (SET I8 _21 _2008)", null, null, null, 0L, false, false, new int[]{64, 2051}, null);
        CodeGenerator_x86simd.rulev[2240] = new Rule(2240, false, true, 2056, "2240: _2013 -> (SET I8 _24 _2012)", null, null, null, 0L, false, false, new int[]{67, 2055}, null);
        CodeGenerator_x86simd.rulev[2244] = new Rule(2244, false, true, 2060, "2244: _2017 -> (SET I8 _26 _2016)", null, null, null, 0L, false, false, new int[]{69, 2059}, null);
        CodeGenerator_x86simd.rulev[2248] = new Rule(2248, false, true, 2064, "2248: _2021 -> (SET I8 _29 _2020)", null, null, null, 0L, false, false, new int[]{72, 2063}, null);
        CodeGenerator_x86simd.rulev[2252] = new Rule(2252, false, true, 2068, "2252: _2025 -> (SET I8 _32 _2024)", null, null, null, 0L, false, false, new int[]{75, 2067}, null);
        CodeGenerator_x86simd.rulev[2256] = new Rule(2256, false, true, 2072, "2256: _2029 -> (SET I8 _35 _2028)", null, null, null, 0L, false, false, new int[]{78, 2071}, null);
        CodeGenerator_x86simd.rulev[2260] = new Rule(2260, false, true, 2076, "2260: _2033 -> (SET I8 _38 _2032)", null, null, null, 0L, false, false, new int[]{81, 2075}, null);
        CodeGenerator_x86simd.rulev[2264] = new Rule(2264, false, true, 2080, "2264: _2037 -> (SET I8 _41 _2036)", null, null, null, 0L, false, false, new int[]{84, 2079}, null);
        CodeGenerator_x86simd.rulev[2268] = new Rule(2268, false, true, 2084, "2268: _2041 -> (SET I8 _44 _2040)", null, null, null, 0L, false, false, new int[]{87, 2083}, null);
        CodeGenerator_x86simd.rulev[2272] = new Rule(2272, false, true, 2088, "2272: _2045 -> (SET I8 _47 _2044)", null, null, null, 0L, false, false, new int[]{90, 2087}, null);
        CodeGenerator_x86simd.rulev[2427] = new Rule(2427, false, true, 2238, "2427: _2195 -> (SET I8 _101 _2194)", null, null, null, 0L, false, false, new int[]{144, 2237}, null);
        CodeGenerator_x86simd.rulev[2433] = new Rule(2433, false, true, 2244, "2433: _2201 -> (SET I8 _103 _2200)", null, null, null, 0L, false, false, new int[]{146, 2243}, null);
        CodeGenerator_x86simd.rulev[2439] = new Rule(2439, false, true, 2250, "2439: _2207 -> (SET I8 _105 _2206)", null, null, null, 0L, false, false, new int[]{148, 2249}, null);
        CodeGenerator_x86simd.rulev[2445] = new Rule(2445, false, true, 2256, "2445: _2213 -> (SET I8 _107 _2212)", null, null, null, 0L, false, false, new int[]{150, 2255}, null);
        CodeGenerator_x86simd.rulev[2451] = new Rule(2451, false, true, 2262, "2451: _2219 -> (SET I8 _109 _2218)", null, null, null, 0L, false, false, new int[]{152, 2261}, null);
        CodeGenerator_x86simd.rulev[2457] = new Rule(2457, false, true, 2268, "2457: _2225 -> (SET I8 _111 _2224)", null, null, null, 0L, false, false, new int[]{154, 2267}, null);
        CodeGenerator_x86simd.rulev[2463] = new Rule(2463, false, true, 2274, "2463: _2231 -> (SET I8 _113 _2230)", null, null, null, 0L, false, false, new int[]{156, 2273}, null);
        CodeGenerator_x86simd.rulev[2469] = new Rule(2469, false, true, 2280, "2469: _2237 -> (SET I8 _115 _2236)", null, null, null, 0L, false, false, new int[]{158, 2279}, null);
        CodeGenerator_x86simd.rulev[2506] = new Rule(2506, false, true, 2314, "2506: _2271 -> (SET I8 _7 _2270)", null, null, null, 0L, false, false, new int[]{50, 2313}, null);
        CodeGenerator_x86simd.rulev[2512] = new Rule(2512, false, true, 2320, "2512: _2277 -> (SET I8 _9 _2276)", null, null, null, 0L, false, false, new int[]{52, 2319}, null);
        CodeGenerator_x86simd.rulev[2518] = new Rule(2518, false, true, 2326, "2518: _2283 -> (SET I8 _11 _2282)", null, null, null, 0L, false, false, new int[]{54, 2325}, null);
        CodeGenerator_x86simd.rulev[2524] = new Rule(2524, false, true, 2332, "2524: _2289 -> (SET I8 _13 _2288)", null, null, null, 0L, false, false, new int[]{56, 2331}, null);
        CodeGenerator_x86simd.rulev[2530] = new Rule(2530, false, true, 2338, "2530: _2295 -> (SET I8 _15 _2294)", null, null, null, 0L, false, false, new int[]{58, 2337}, null);
        CodeGenerator_x86simd.rulev[2536] = new Rule(2536, false, true, 2344, "2536: _2301 -> (SET I8 _18 _2300)", null, null, null, 0L, false, false, new int[]{61, 2343}, null);
        CodeGenerator_x86simd.rulev[2542] = new Rule(2542, false, true, 2350, "2542: _2307 -> (SET I8 _21 _2306)", null, null, null, 0L, false, false, new int[]{64, 2349}, null);
        CodeGenerator_x86simd.rulev[2548] = new Rule(2548, false, true, 2356, "2548: _2313 -> (SET I8 _24 _2312)", null, null, null, 0L, false, false, new int[]{67, 2355}, null);
        CodeGenerator_x86simd.rulev[2554] = new Rule(2554, false, true, 2362, "2554: _2319 -> (SET I8 _26 _2318)", null, null, null, 0L, false, false, new int[]{69, 2361}, null);
        CodeGenerator_x86simd.rulev[2560] = new Rule(2560, false, true, 2368, "2560: _2325 -> (SET I8 _29 _2324)", null, null, null, 0L, false, false, new int[]{72, 2367}, null);
        CodeGenerator_x86simd.rulev[2566] = new Rule(2566, false, true, 2374, "2566: _2331 -> (SET I8 _32 _2330)", null, null, null, 0L, false, false, new int[]{75, 2373}, null);
        CodeGenerator_x86simd.rulev[2572] = new Rule(2572, false, true, 2380, "2572: _2337 -> (SET I8 _35 _2336)", null, null, null, 0L, false, false, new int[]{78, 2379}, null);
        CodeGenerator_x86simd.rulev[2578] = new Rule(2578, false, true, 2386, "2578: _2343 -> (SET I8 _38 _2342)", null, null, null, 0L, false, false, new int[]{81, 2385}, null);
    }

    private static void rrinit3200() {
        CodeGenerator_x86simd.rulev[2584] = new Rule(2584, false, true, 2392, "2584: _2349 -> (SET I8 _41 _2348)", null, null, null, 0L, false, false, new int[]{84, 2391}, null);
        CodeGenerator_x86simd.rulev[2590] = new Rule(2590, false, true, 2398, "2590: _2355 -> (SET I8 _44 _2354)", null, null, null, 0L, false, false, new int[]{87, 2397}, null);
        CodeGenerator_x86simd.rulev[2596] = new Rule(2596, false, true, 2404, "2596: _2361 -> (SET I8 _47 _2360)", null, null, null, 0L, false, false, new int[]{90, 2403}, null);
        CodeGenerator_x86simd.rulev[2661] = new Rule(2661, false, true, 2466, "2661: _2423 -> (SET I8 _101 _2422)", null, null, null, 0L, false, false, new int[]{144, 2465}, null);
        CodeGenerator_x86simd.rulev[2667] = new Rule(2667, false, true, 2472, "2667: _2429 -> (SET I8 _103 _2428)", null, null, null, 0L, false, false, new int[]{146, 2471}, null);
        CodeGenerator_x86simd.rulev[2673] = new Rule(2673, false, true, 2478, "2673: _2435 -> (SET I8 _105 _2434)", null, null, null, 0L, false, false, new int[]{148, 2477}, null);
        CodeGenerator_x86simd.rulev[2679] = new Rule(2679, false, true, 2484, "2679: _2441 -> (SET I8 _107 _2440)", null, null, null, 0L, false, false, new int[]{150, 2483}, null);
        CodeGenerator_x86simd.rulev[2685] = new Rule(2685, false, true, 2490, "2685: _2447 -> (SET I8 _109 _2446)", null, null, null, 0L, false, false, new int[]{152, 2489}, null);
        CodeGenerator_x86simd.rulev[2691] = new Rule(2691, false, true, 2496, "2691: _2453 -> (SET I8 _111 _2452)", null, null, null, 0L, false, false, new int[]{154, 2495}, null);
        CodeGenerator_x86simd.rulev[2697] = new Rule(2697, false, true, 2502, "2697: _2459 -> (SET I8 _113 _2458)", null, null, null, 0L, false, false, new int[]{156, 2501}, null);
        CodeGenerator_x86simd.rulev[2703] = new Rule(2703, false, true, 2508, "2703: _2465 -> (SET I8 _115 _2464)", null, null, null, 0L, false, false, new int[]{158, 2507}, null);
        CodeGenerator_x86simd.rulev[2740] = new Rule(2740, false, true, 2542, "2740: _2499 -> (SET I8 _7 _2498)", null, null, null, 0L, false, false, new int[]{50, 2541}, null);
        CodeGenerator_x86simd.rulev[2746] = new Rule(2746, false, true, 2548, "2746: _2505 -> (SET I8 _9 _2504)", null, null, null, 0L, false, false, new int[]{52, 2547}, null);
        CodeGenerator_x86simd.rulev[2752] = new Rule(2752, false, true, 2554, "2752: _2511 -> (SET I8 _11 _2510)", null, null, null, 0L, false, false, new int[]{54, 2553}, null);
        CodeGenerator_x86simd.rulev[2758] = new Rule(2758, false, true, 2560, "2758: _2517 -> (SET I8 _13 _2516)", null, null, null, 0L, false, false, new int[]{56, 2559}, null);
        CodeGenerator_x86simd.rulev[2764] = new Rule(2764, false, true, 2566, "2764: _2523 -> (SET I8 _15 _2522)", null, null, null, 0L, false, false, new int[]{58, 2565}, null);
        CodeGenerator_x86simd.rulev[2770] = new Rule(2770, false, true, 2572, "2770: _2529 -> (SET I8 _18 _2528)", null, null, null, 0L, false, false, new int[]{61, 2571}, null);
        CodeGenerator_x86simd.rulev[2776] = new Rule(2776, false, true, 2578, "2776: _2535 -> (SET I8 _21 _2534)", null, null, null, 0L, false, false, new int[]{64, 2577}, null);
        CodeGenerator_x86simd.rulev[2782] = new Rule(2782, false, true, 2584, "2782: _2541 -> (SET I8 _24 _2540)", null, null, null, 0L, false, false, new int[]{67, 2583}, null);
        CodeGenerator_x86simd.rulev[2788] = new Rule(2788, false, true, 2590, "2788: _2547 -> (SET I8 _26 _2546)", null, null, null, 0L, false, false, new int[]{69, 2589}, null);
        CodeGenerator_x86simd.rulev[2794] = new Rule(2794, false, true, 2596, "2794: _2553 -> (SET I8 _29 _2552)", null, null, null, 0L, false, false, new int[]{72, 2595}, null);
        CodeGenerator_x86simd.rulev[2800] = new Rule(2800, false, true, 2602, "2800: _2559 -> (SET I8 _32 _2558)", null, null, null, 0L, false, false, new int[]{75, 2601}, null);
        CodeGenerator_x86simd.rulev[2806] = new Rule(2806, false, true, 2608, "2806: _2565 -> (SET I8 _35 _2564)", null, null, null, 0L, false, false, new int[]{78, 2607}, null);
        CodeGenerator_x86simd.rulev[2812] = new Rule(2812, false, true, 2614, "2812: _2571 -> (SET I8 _38 _2570)", null, null, null, 0L, false, false, new int[]{81, 2613}, null);
        CodeGenerator_x86simd.rulev[2818] = new Rule(2818, false, true, 2620, "2818: _2577 -> (SET I8 _41 _2576)", null, null, null, 0L, false, false, new int[]{84, 2619}, null);
        CodeGenerator_x86simd.rulev[2824] = new Rule(2824, false, true, 2626, "2824: _2583 -> (SET I8 _44 _2582)", null, null, null, 0L, false, false, new int[]{87, 2625}, null);
        CodeGenerator_x86simd.rulev[2830] = new Rule(2830, false, true, 2632, "2830: _2589 -> (SET I8 _47 _2588)", null, null, null, 0L, false, false, new int[]{90, 2631}, null);
        CodeGenerator_x86simd.rulev[3132] = new Rule(3132, false, true, 2907, "3132: _2864 -> (SET I8 _101 _2863)", null, null, null, 0L, false, false, new int[]{144, 2906}, null);
        CodeGenerator_x86simd.rulev[3135] = new Rule(3135, false, true, 2910, "3135: _2867 -> (SET I8 _103 _2866)", null, null, null, 0L, false, false, new int[]{146, 2909}, null);
        CodeGenerator_x86simd.rulev[3138] = new Rule(3138, false, true, 2913, "3138: _2870 -> (SET I8 _105 _2869)", null, null, null, 0L, false, false, new int[]{148, 2912}, null);
        CodeGenerator_x86simd.rulev[3141] = new Rule(3141, false, true, 2916, "3141: _2873 -> (SET I8 _107 _2872)", null, null, null, 0L, false, false, new int[]{150, 2915}, null);
        CodeGenerator_x86simd.rulev[3144] = new Rule(3144, false, true, 2919, "3144: _2876 -> (SET I8 _111 _2875)", null, null, null, 0L, false, false, new int[]{154, 2918}, null);
        CodeGenerator_x86simd.rulev[3147] = new Rule(3147, false, true, 2922, "3147: _2879 -> (SET I8 _113 _2878)", null, null, null, 0L, false, false, new int[]{156, 2921}, null);
        CodeGenerator_x86simd.rulev[3150] = new Rule(3150, false, true, 2925, "3150: _2882 -> (SET I8 _115 _2881)", null, null, null, 0L, false, false, new int[]{158, 2924}, null);
        CodeGenerator_x86simd.rulev[3174] = new Rule(3174, false, true, 2946, "3174: _2903 -> (SET I8 _7 _2902)", null, null, null, 0L, false, false, new int[]{50, 2945}, null);
        CodeGenerator_x86simd.rulev[3177] = new Rule(3177, false, true, 2949, "3177: _2906 -> (SET I8 _9 _2905)", null, null, null, 0L, false, false, new int[]{52, 2948}, null);
        CodeGenerator_x86simd.rulev[3180] = new Rule(3180, false, true, 2952, "3180: _2909 -> (SET I8 _11 _2908)", null, null, null, 0L, false, false, new int[]{54, 2951}, null);
        CodeGenerator_x86simd.rulev[3183] = new Rule(3183, false, true, 2955, "3183: _2912 -> (SET I8 _13 _2911)", null, null, null, 0L, false, false, new int[]{56, 2954}, null);
        CodeGenerator_x86simd.rulev[3186] = new Rule(3186, false, true, 2958, "3186: _2915 -> (SET I8 _15 _2914)", null, null, null, 0L, false, false, new int[]{58, 2957}, null);
        CodeGenerator_x86simd.rulev[3189] = new Rule(3189, false, true, 2961, "3189: _2918 -> (SET I8 _18 _2917)", null, null, null, 0L, false, false, new int[]{61, 2960}, null);
        CodeGenerator_x86simd.rulev[3192] = new Rule(3192, false, true, 2964, "3192: _2921 -> (SET I8 _21 _2920)", null, null, null, 0L, false, false, new int[]{64, 2963}, null);
        CodeGenerator_x86simd.rulev[3195] = new Rule(3195, false, true, 2967, "3195: _2924 -> (SET I8 _24 _2923)", null, null, null, 0L, false, false, new int[]{67, 2966}, null);
        CodeGenerator_x86simd.rulev[3198] = new Rule(3198, false, true, 2970, "3198: _2927 -> (SET I8 _26 _2926)", null, null, null, 0L, false, false, new int[]{69, 2969}, null);
        CodeGenerator_x86simd.rulev[3201] = new Rule(3201, false, true, 2973, "3201: _2930 -> (SET I8 _29 _2929)", null, null, null, 0L, false, false, new int[]{72, 2972}, null);
        CodeGenerator_x86simd.rulev[3204] = new Rule(3204, false, true, 2976, "3204: _2933 -> (SET I8 _32 _2932)", null, null, null, 0L, false, false, new int[]{75, 2975}, null);
        CodeGenerator_x86simd.rulev[3207] = new Rule(3207, false, true, 2979, "3207: _2936 -> (SET I8 _35 _2935)", null, null, null, 0L, false, false, new int[]{78, 2978}, null);
        CodeGenerator_x86simd.rulev[3210] = new Rule(3210, false, true, 2982, "3210: _2939 -> (SET I8 _38 _2938)", null, null, null, 0L, false, false, new int[]{81, 2981}, null);
        CodeGenerator_x86simd.rulev[3213] = new Rule(3213, false, true, 2985, "3213: _2942 -> (SET I8 _41 _2941)", null, null, null, 0L, false, false, new int[]{84, 2984}, null);
        CodeGenerator_x86simd.rulev[3216] = new Rule(3216, false, true, 2988, "3216: _2945 -> (SET I8 _44 _2944)", null, null, null, 0L, false, false, new int[]{87, 2987}, null);
        CodeGenerator_x86simd.rulev[3219] = new Rule(3219, false, true, 2991, "3219: _2948 -> (SET I8 _47 _2947)", null, null, null, 0L, false, false, new int[]{90, 2990}, null);
        CodeGenerator_x86simd.rulev[3259] = new Rule(3259, false, true, 3028, "3259: _2985 -> (SET I8 _101 _436)", null, null, null, 0L, false, false, new int[]{144, 479}, null);
        CodeGenerator_x86simd.rulev[3260] = new Rule(3260, false, true, 3029, "3260: _2986 -> (SET I8 _103 _441)", null, null, null, 0L, false, false, new int[]{146, 484}, null);
        CodeGenerator_x86simd.rulev[3261] = new Rule(3261, false, true, 3030, "3261: _2987 -> (SET I8 _105 _445)", null, null, null, 0L, false, false, new int[]{148, 488}, null);
        CodeGenerator_x86simd.rulev[3262] = new Rule(3262, false, true, 3031, "3262: _2988 -> (SET I8 _107 _449)", null, null, null, 0L, false, false, new int[]{150, 492}, null);
        CodeGenerator_x86simd.rulev[3263] = new Rule(3263, false, true, 3032, "3263: _2989 -> (SET I8 _109 _453)", null, null, null, 0L, false, false, new int[]{152, 496}, null);
        CodeGenerator_x86simd.rulev[3264] = new Rule(3264, false, true, 3033, "3264: _2990 -> (SET I8 _111 _457)", null, null, null, 0L, false, false, new int[]{154, 500}, null);
        CodeGenerator_x86simd.rulev[3265] = new Rule(3265, false, true, 3034, "3265: _2991 -> (SET I8 _113 _461)", null, null, null, 0L, false, false, new int[]{156, 504}, null);
        CodeGenerator_x86simd.rulev[3266] = new Rule(3266, false, true, 3035, "3266: _2992 -> (SET I8 _115 _465)", null, null, null, 0L, false, false, new int[]{158, 508}, null);
        CodeGenerator_x86simd.rulev[3268] = new Rule(3268, false, true, 3036, "3268: _2993 -> (SET I8 _101 _269)", null, null, null, 0L, false, false, new int[]{144, 312}, null);
        CodeGenerator_x86simd.rulev[3269] = new Rule(3269, false, true, 3037, "3269: _2994 -> (SET I8 _103 _275)", null, null, null, 0L, false, false, new int[]{146, 318}, null);
        CodeGenerator_x86simd.rulev[3270] = new Rule(3270, false, true, 3038, "3270: _2995 -> (SET I8 _105 _282)", null, null, null, 0L, false, false, new int[]{148, 325}, null);
        CodeGenerator_x86simd.rulev[3271] = new Rule(3271, false, true, 3039, "3271: _2996 -> (SET I8 _107 _289)", null, null, null, 0L, false, false, new int[]{150, 332}, null);
        CodeGenerator_x86simd.rulev[3272] = new Rule(3272, false, true, 3040, "3272: _2997 -> (SET I8 _109 _296)", null, null, null, 0L, false, false, new int[]{152, 339}, null);
        CodeGenerator_x86simd.rulev[3273] = new Rule(3273, false, true, 3041, "3273: _2998 -> (SET I8 _111 _303)", null, null, null, 0L, false, false, new int[]{154, 346}, null);
        CodeGenerator_x86simd.rulev[3274] = new Rule(3274, false, true, 3042, "3274: _2999 -> (SET I8 _113 _310)", null, null, null, 0L, false, false, new int[]{156, 353}, null);
        CodeGenerator_x86simd.rulev[3275] = new Rule(3275, false, true, 3043, "3275: _3000 -> (SET I8 _115 _317)", null, null, null, 0L, false, false, new int[]{158, 360}, null);
        CodeGenerator_x86simd.rulev[3278] = new Rule(3278, false, true, 3045, "3278: _3002 -> (SET I8 _101 _3001)", null, null, null, 0L, false, false, new int[]{144, 3044}, null);
        CodeGenerator_x86simd.rulev[3280] = new Rule(3280, false, true, 3047, "3280: _3004 -> (SET I8 _103 _3003)", null, null, null, 0L, false, false, new int[]{146, 3046}, null);
        CodeGenerator_x86simd.rulev[3282] = new Rule(3282, false, true, 3049, "3282: _3006 -> (SET I8 _105 _3005)", null, null, null, 0L, false, false, new int[]{148, 3048}, null);
        CodeGenerator_x86simd.rulev[3284] = new Rule(3284, false, true, 3051, "3284: _3008 -> (SET I8 _107 _3007)", null, null, null, 0L, false, false, new int[]{150, 3050}, null);
        CodeGenerator_x86simd.rulev[3286] = new Rule(3286, false, true, 3053, "3286: _3010 -> (SET I8 _109 _3009)", null, null, null, 0L, false, false, new int[]{152, 3052}, null);
        CodeGenerator_x86simd.rulev[3288] = new Rule(3288, false, true, 3055, "3288: _3012 -> (SET I8 _111 _3011)", null, null, null, 0L, false, false, new int[]{154, 3054}, null);
        CodeGenerator_x86simd.rulev[3290] = new Rule(3290, false, true, 3057, "3290: _3014 -> (SET I8 _113 _3013)", null, null, null, 0L, false, false, new int[]{156, 3056}, null);
        CodeGenerator_x86simd.rulev[3292] = new Rule(3292, false, true, 3059, "3292: _3016 -> (SET I8 _115 _3015)", null, null, null, 0L, false, false, new int[]{158, 3058}, null);
        CodeGenerator_x86simd.rulev[3294] = new Rule(3294, false, true, 3060, "3294: _3017 -> (SET I8 _101 _471)", null, null, null, 0L, false, false, new int[]{144, 514}, null);
        CodeGenerator_x86simd.rulev[3295] = new Rule(3295, false, true, 3061, "3295: _3018 -> (SET I8 _103 _477)", null, null, null, 0L, false, false, new int[]{146, 520}, null);
        CodeGenerator_x86simd.rulev[3296] = new Rule(3296, false, true, 3062, "3296: _3019 -> (SET I8 _105 _483)", null, null, null, 0L, false, false, new int[]{148, 526}, null);
        CodeGenerator_x86simd.rulev[3297] = new Rule(3297, false, true, 3063, "3297: _3020 -> (SET I8 _107 _489)", null, null, null, 0L, false, false, new int[]{150, 532}, null);
        CodeGenerator_x86simd.rulev[3298] = new Rule(3298, false, true, 3064, "3298: _3021 -> (SET I8 _109 _495)", null, null, null, 0L, false, false, new int[]{152, 538}, null);
        CodeGenerator_x86simd.rulev[3299] = new Rule(3299, false, true, 3065, "3299: _3022 -> (SET I8 _111 _501)", null, null, null, 0L, false, false, new int[]{154, 544}, null);
        CodeGenerator_x86simd.rulev[3300] = new Rule(3300, false, true, 3066, "3300: _3023 -> (SET I8 _113 _507)", null, null, null, 0L, false, false, new int[]{156, 550}, null);
        CodeGenerator_x86simd.rulev[3301] = new Rule(3301, false, true, 3067, "3301: _3024 -> (SET I8 _115 _513)", null, null, null, 0L, false, false, new int[]{158, 556}, null);
        CodeGenerator_x86simd.rulev[3304] = new Rule(3304, false, true, 3069, "3304: _3026 -> (SET I8 _101 _3025)", null, null, null, 0L, false, false, new int[]{144, 3068}, null);
        CodeGenerator_x86simd.rulev[3306] = new Rule(3306, false, true, 3071, "3306: _3028 -> (SET I8 _103 _3027)", null, null, null, 0L, false, false, new int[]{146, 3070}, null);
        CodeGenerator_x86simd.rulev[3308] = new Rule(3308, false, true, 3073, "3308: _3030 -> (SET I8 _105 _3029)", null, null, null, 0L, false, false, new int[]{148, 3072}, null);
        CodeGenerator_x86simd.rulev[3310] = new Rule(3310, false, true, 3075, "3310: _3032 -> (SET I8 _107 _3031)", null, null, null, 0L, false, false, new int[]{150, 3074}, null);
        CodeGenerator_x86simd.rulev[3312] = new Rule(3312, false, true, 3077, "3312: _3034 -> (SET I8 _109 _3033)", null, null, null, 0L, false, false, new int[]{152, 3076}, null);
        CodeGenerator_x86simd.rulev[3314] = new Rule(3314, false, true, 3079, "3314: _3036 -> (SET I8 _111 _3035)", null, null, null, 0L, false, false, new int[]{154, 3078}, null);
        CodeGenerator_x86simd.rulev[3316] = new Rule(3316, false, true, 3081, "3316: _3038 -> (SET I8 _113 _3037)", null, null, null, 0L, false, false, new int[]{156, 3080}, null);
        CodeGenerator_x86simd.rulev[3318] = new Rule(3318, false, true, 3083, "3318: _3040 -> (SET I8 _115 _3039)", null, null, null, 0L, false, false, new int[]{158, 3082}, null);
        CodeGenerator_x86simd.rulev[3391] = new Rule(3391, false, true, 3144, "3391: _3101 -> (SET I8 _7 _517)", null, null, null, 0L, false, false, new int[]{50, 560}, null);
        CodeGenerator_x86simd.rulev[3392] = new Rule(3392, false, true, 3145, "3392: _3102 -> (SET I8 _9 _521)", null, null, null, 0L, false, false, new int[]{52, 564}, null);
        CodeGenerator_x86simd.rulev[3393] = new Rule(3393, false, true, 3146, "3393: _3103 -> (SET I8 _11 _525)", null, null, null, 0L, false, false, new int[]{54, 568}, null);
        CodeGenerator_x86simd.rulev[3394] = new Rule(3394, false, true, 3147, "3394: _3104 -> (SET I8 _13 _529)", null, null, null, 0L, false, false, new int[]{56, 572}, null);
        CodeGenerator_x86simd.rulev[3395] = new Rule(3395, false, true, 3148, "3395: _3105 -> (SET I8 _15 _533)", null, null, null, 0L, false, false, new int[]{58, 576}, null);
        CodeGenerator_x86simd.rulev[3396] = new Rule(3396, false, true, 3149, "3396: _3106 -> (SET I8 _18 _537)", null, null, null, 0L, false, false, new int[]{61, 580}, null);
        CodeGenerator_x86simd.rulev[3397] = new Rule(3397, false, true, 3150, "3397: _3107 -> (SET I8 _21 _541)", null, null, null, 0L, false, false, new int[]{64, 584}, null);
        CodeGenerator_x86simd.rulev[3398] = new Rule(3398, false, true, 3151, "3398: _3108 -> (SET I8 _24 _545)", null, null, null, 0L, false, false, new int[]{67, 588}, null);
        CodeGenerator_x86simd.rulev[3399] = new Rule(3399, false, true, 3152, "3399: _3109 -> (SET I8 _26 _549)", null, null, null, 0L, false, false, new int[]{69, 592}, null);
        CodeGenerator_x86simd.rulev[3400] = new Rule(3400, false, true, 3153, "3400: _3110 -> (SET I8 _29 _553)", null, null, null, 0L, false, false, new int[]{72, 596}, null);
    }

    private static void rrinit3300() {
        CodeGenerator_x86simd.rulev[3401] = new Rule(3401, false, true, 3154, "3401: _3111 -> (SET I8 _32 _557)", null, null, null, 0L, false, false, new int[]{75, 600}, null);
        CodeGenerator_x86simd.rulev[3402] = new Rule(3402, false, true, 3155, "3402: _3112 -> (SET I8 _35 _561)", null, null, null, 0L, false, false, new int[]{78, 604}, null);
        CodeGenerator_x86simd.rulev[3403] = new Rule(3403, false, true, 3156, "3403: _3113 -> (SET I8 _38 _565)", null, null, null, 0L, false, false, new int[]{81, 608}, null);
        CodeGenerator_x86simd.rulev[3404] = new Rule(3404, false, true, 3157, "3404: _3114 -> (SET I8 _41 _569)", null, null, null, 0L, false, false, new int[]{84, 612}, null);
        CodeGenerator_x86simd.rulev[3405] = new Rule(3405, false, true, 3158, "3405: _3115 -> (SET I8 _44 _573)", null, null, null, 0L, false, false, new int[]{87, 616}, null);
        CodeGenerator_x86simd.rulev[3406] = new Rule(3406, false, true, 3159, "3406: _3116 -> (SET I8 _47 _577)", null, null, null, 0L, false, false, new int[]{90, 620}, null);
        CodeGenerator_x86simd.rulev[3408] = new Rule(3408, false, true, 3160, "3408: _3117 -> (SET I8 _7 _324)", null, null, null, 0L, false, false, new int[]{50, 367}, null);
        CodeGenerator_x86simd.rulev[3409] = new Rule(3409, false, true, 3161, "3409: _3118 -> (SET I8 _9 _330)", null, null, null, 0L, false, false, new int[]{52, 373}, null);
        CodeGenerator_x86simd.rulev[3410] = new Rule(3410, false, true, 3162, "3410: _3119 -> (SET I8 _11 _337)", null, null, null, 0L, false, false, new int[]{54, 380}, null);
        CodeGenerator_x86simd.rulev[3411] = new Rule(3411, false, true, 3163, "3411: _3120 -> (SET I8 _13 _344)", null, null, null, 0L, false, false, new int[]{56, 387}, null);
        CodeGenerator_x86simd.rulev[3412] = new Rule(3412, false, true, 3164, "3412: _3121 -> (SET I8 _15 _351)", null, null, null, 0L, false, false, new int[]{58, 394}, null);
        CodeGenerator_x86simd.rulev[3413] = new Rule(3413, false, true, 3165, "3413: _3122 -> (SET I8 _18 _358)", null, null, null, 0L, false, false, new int[]{61, 401}, null);
        CodeGenerator_x86simd.rulev[3414] = new Rule(3414, false, true, 3166, "3414: _3123 -> (SET I8 _21 _365)", null, null, null, 0L, false, false, new int[]{64, 408}, null);
        CodeGenerator_x86simd.rulev[3415] = new Rule(3415, false, true, 3167, "3415: _3124 -> (SET I8 _24 _372)", null, null, null, 0L, false, false, new int[]{67, 415}, null);
        CodeGenerator_x86simd.rulev[3416] = new Rule(3416, false, true, 3168, "3416: _3125 -> (SET I8 _26 _380)", null, null, null, 0L, false, false, new int[]{69, 423}, null);
        CodeGenerator_x86simd.rulev[3417] = new Rule(3417, false, true, 3169, "3417: _3126 -> (SET I8 _29 _386)", null, null, null, 0L, false, false, new int[]{72, 429}, null);
        CodeGenerator_x86simd.rulev[3418] = new Rule(3418, false, true, 3170, "3418: _3127 -> (SET I8 _32 _393)", null, null, null, 0L, false, false, new int[]{75, 436}, null);
        CodeGenerator_x86simd.rulev[3419] = new Rule(3419, false, true, 3171, "3419: _3128 -> (SET I8 _35 _400)", null, null, null, 0L, false, false, new int[]{78, 443}, null);
        CodeGenerator_x86simd.rulev[3420] = new Rule(3420, false, true, 3172, "3420: _3129 -> (SET I8 _38 _407)", null, null, null, 0L, false, false, new int[]{81, 450}, null);
        CodeGenerator_x86simd.rulev[3421] = new Rule(3421, false, true, 3173, "3421: _3130 -> (SET I8 _41 _414)", null, null, null, 0L, false, false, new int[]{84, 457}, null);
        CodeGenerator_x86simd.rulev[3422] = new Rule(3422, false, true, 3174, "3422: _3131 -> (SET I8 _44 _421)", null, null, null, 0L, false, false, new int[]{87, 464}, null);
        CodeGenerator_x86simd.rulev[3423] = new Rule(3423, false, true, 3175, "3423: _3132 -> (SET I8 _47 _428)", null, null, null, 0L, false, false, new int[]{90, 471}, null);
        CodeGenerator_x86simd.rulev[3426] = new Rule(3426, false, true, 3177, "3426: _3134 -> (SET I8 _7 _3133)", null, null, null, 0L, false, false, new int[]{50, 3176}, null);
        CodeGenerator_x86simd.rulev[3428] = new Rule(3428, false, true, 3179, "3428: _3136 -> (SET I8 _9 _3135)", null, null, null, 0L, false, false, new int[]{52, 3178}, null);
        CodeGenerator_x86simd.rulev[3430] = new Rule(3430, false, true, 3181, "3430: _3138 -> (SET I8 _11 _3137)", null, null, null, 0L, false, false, new int[]{54, 3180}, null);
        CodeGenerator_x86simd.rulev[3432] = new Rule(3432, false, true, 3183, "3432: _3140 -> (SET I8 _13 _3139)", null, null, null, 0L, false, false, new int[]{56, 3182}, null);
        CodeGenerator_x86simd.rulev[3434] = new Rule(3434, false, true, 3185, "3434: _3142 -> (SET I8 _15 _3141)", null, null, null, 0L, false, false, new int[]{58, 3184}, null);
        CodeGenerator_x86simd.rulev[3436] = new Rule(3436, false, true, 3187, "3436: _3144 -> (SET I8 _18 _3143)", null, null, null, 0L, false, false, new int[]{61, 3186}, null);
        CodeGenerator_x86simd.rulev[3438] = new Rule(3438, false, true, 3189, "3438: _3146 -> (SET I8 _21 _3145)", null, null, null, 0L, false, false, new int[]{64, 3188}, null);
        CodeGenerator_x86simd.rulev[3440] = new Rule(3440, false, true, 3191, "3440: _3148 -> (SET I8 _24 _3147)", null, null, null, 0L, false, false, new int[]{67, 3190}, null);
        CodeGenerator_x86simd.rulev[3442] = new Rule(3442, false, true, 3193, "3442: _3150 -> (SET I8 _26 _3149)", null, null, null, 0L, false, false, new int[]{69, 3192}, null);
        CodeGenerator_x86simd.rulev[3444] = new Rule(3444, false, true, 3195, "3444: _3152 -> (SET I8 _29 _3151)", null, null, null, 0L, false, false, new int[]{72, 3194}, null);
        CodeGenerator_x86simd.rulev[3446] = new Rule(3446, false, true, 3197, "3446: _3154 -> (SET I8 _32 _3153)", null, null, null, 0L, false, false, new int[]{75, 3196}, null);
        CodeGenerator_x86simd.rulev[3448] = new Rule(3448, false, true, 3199, "3448: _3156 -> (SET I8 _35 _3155)", null, null, null, 0L, false, false, new int[]{78, 3198}, null);
        CodeGenerator_x86simd.rulev[3450] = new Rule(3450, false, true, 3201, "3450: _3158 -> (SET I8 _38 _3157)", null, null, null, 0L, false, false, new int[]{81, 3200}, null);
        CodeGenerator_x86simd.rulev[3452] = new Rule(3452, false, true, 3203, "3452: _3160 -> (SET I8 _41 _3159)", null, null, null, 0L, false, false, new int[]{84, 3202}, null);
        CodeGenerator_x86simd.rulev[3454] = new Rule(3454, false, true, 3205, "3454: _3162 -> (SET I8 _44 _3161)", null, null, null, 0L, false, false, new int[]{87, 3204}, null);
        CodeGenerator_x86simd.rulev[3456] = new Rule(3456, false, true, 3207, "3456: _3164 -> (SET I8 _47 _3163)", null, null, null, 0L, false, false, new int[]{90, 3206}, null);
        CodeGenerator_x86simd.rulev[3458] = new Rule(3458, false, true, 3208, "3458: _3165 -> (SET I8 _7 _583)", null, null, null, 0L, false, false, new int[]{50, 626}, null);
        CodeGenerator_x86simd.rulev[3459] = new Rule(3459, false, true, 3209, "3459: _3166 -> (SET I8 _9 _589)", null, null, null, 0L, false, false, new int[]{52, 632}, null);
        CodeGenerator_x86simd.rulev[3460] = new Rule(3460, false, true, 3210, "3460: _3167 -> (SET I8 _11 _595)", null, null, null, 0L, false, false, new int[]{54, 638}, null);
        CodeGenerator_x86simd.rulev[3461] = new Rule(3461, false, true, 3211, "3461: _3168 -> (SET I8 _13 _601)", null, null, null, 0L, false, false, new int[]{56, 644}, null);
        CodeGenerator_x86simd.rulev[3462] = new Rule(3462, false, true, 3212, "3462: _3169 -> (SET I8 _15 _607)", null, null, null, 0L, false, false, new int[]{58, 650}, null);
        CodeGenerator_x86simd.rulev[3463] = new Rule(3463, false, true, 3213, "3463: _3170 -> (SET I8 _18 _613)", null, null, null, 0L, false, false, new int[]{61, 656}, null);
        CodeGenerator_x86simd.rulev[3464] = new Rule(3464, false, true, 3214, "3464: _3171 -> (SET I8 _21 _619)", null, null, null, 0L, false, false, new int[]{64, 662}, null);
        CodeGenerator_x86simd.rulev[3465] = new Rule(3465, false, true, 3215, "3465: _3172 -> (SET I8 _24 _625)", null, null, null, 0L, false, false, new int[]{67, 668}, null);
        CodeGenerator_x86simd.rulev[3466] = new Rule(3466, false, true, 3216, "3466: _3173 -> (SET I8 _26 _631)", null, null, null, 0L, false, false, new int[]{69, 674}, null);
        CodeGenerator_x86simd.rulev[3467] = new Rule(3467, false, true, 3217, "3467: _3174 -> (SET I8 _29 _637)", null, null, null, 0L, false, false, new int[]{72, 680}, null);
        CodeGenerator_x86simd.rulev[3468] = new Rule(3468, false, true, 3218, "3468: _3175 -> (SET I8 _32 _643)", null, null, null, 0L, false, false, new int[]{75, 686}, null);
        CodeGenerator_x86simd.rulev[3469] = new Rule(3469, false, true, 3219, "3469: _3176 -> (SET I8 _35 _649)", null, null, null, 0L, false, false, new int[]{78, 692}, null);
        CodeGenerator_x86simd.rulev[3470] = new Rule(3470, false, true, 3220, "3470: _3177 -> (SET I8 _38 _655)", null, null, null, 0L, false, false, new int[]{81, 698}, null);
        CodeGenerator_x86simd.rulev[3471] = new Rule(3471, false, true, 3221, "3471: _3178 -> (SET I8 _41 _661)", null, null, null, 0L, false, false, new int[]{84, 704}, null);
        CodeGenerator_x86simd.rulev[3472] = new Rule(3472, false, true, 3222, "3472: _3179 -> (SET I8 _44 _667)", null, null, null, 0L, false, false, new int[]{87, 710}, null);
        CodeGenerator_x86simd.rulev[3473] = new Rule(3473, false, true, 3223, "3473: _3180 -> (SET I8 _47 _673)", null, null, null, 0L, false, false, new int[]{90, 716}, null);
        CodeGenerator_x86simd.rulev[3476] = new Rule(3476, false, true, 3225, "3476: _3182 -> (SET I8 _7 _3181)", null, null, null, 0L, false, false, new int[]{50, 3224}, null);
        CodeGenerator_x86simd.rulev[3478] = new Rule(3478, false, true, 3227, "3478: _3184 -> (SET I8 _9 _3183)", null, null, null, 0L, false, false, new int[]{52, 3226}, null);
        CodeGenerator_x86simd.rulev[3480] = new Rule(3480, false, true, 3229, "3480: _3186 -> (SET I8 _11 _3185)", null, null, null, 0L, false, false, new int[]{54, 3228}, null);
        CodeGenerator_x86simd.rulev[3482] = new Rule(3482, false, true, 3231, "3482: _3188 -> (SET I8 _13 _3187)", null, null, null, 0L, false, false, new int[]{56, 3230}, null);
        CodeGenerator_x86simd.rulev[3484] = new Rule(3484, false, true, 3233, "3484: _3190 -> (SET I8 _15 _3189)", null, null, null, 0L, false, false, new int[]{58, 3232}, null);
        CodeGenerator_x86simd.rulev[3486] = new Rule(3486, false, true, 3235, "3486: _3192 -> (SET I8 _18 _3191)", null, null, null, 0L, false, false, new int[]{61, 3234}, null);
        CodeGenerator_x86simd.rulev[3488] = new Rule(3488, false, true, 3237, "3488: _3194 -> (SET I8 _21 _3193)", null, null, null, 0L, false, false, new int[]{64, 3236}, null);
        CodeGenerator_x86simd.rulev[3490] = new Rule(3490, false, true, 3239, "3490: _3196 -> (SET I8 _24 _3195)", null, null, null, 0L, false, false, new int[]{67, 3238}, null);
        CodeGenerator_x86simd.rulev[3492] = new Rule(3492, false, true, 3241, "3492: _3198 -> (SET I8 _26 _3197)", null, null, null, 0L, false, false, new int[]{69, 3240}, null);
        CodeGenerator_x86simd.rulev[3494] = new Rule(3494, false, true, 3243, "3494: _3200 -> (SET I8 _29 _3199)", null, null, null, 0L, false, false, new int[]{72, 3242}, null);
        CodeGenerator_x86simd.rulev[3496] = new Rule(3496, false, true, 3245, "3496: _3202 -> (SET I8 _32 _3201)", null, null, null, 0L, false, false, new int[]{75, 3244}, null);
        CodeGenerator_x86simd.rulev[3498] = new Rule(3498, false, true, 3247, "3498: _3204 -> (SET I8 _35 _3203)", null, null, null, 0L, false, false, new int[]{78, 3246}, null);
        CodeGenerator_x86simd.rulev[3500] = new Rule(3500, false, true, 3249, "3500: _3206 -> (SET I8 _38 _3205)", null, null, null, 0L, false, false, new int[]{81, 3248}, null);
        CodeGenerator_x86simd.rulev[3502] = new Rule(3502, false, true, 3251, "3502: _3208 -> (SET I8 _41 _3207)", null, null, null, 0L, false, false, new int[]{84, 3250}, null);
        CodeGenerator_x86simd.rulev[3504] = new Rule(3504, false, true, 3253, "3504: _3210 -> (SET I8 _44 _3209)", null, null, null, 0L, false, false, new int[]{87, 3252}, null);
        CodeGenerator_x86simd.rulev[3506] = new Rule(3506, false, true, 3255, "3506: _3212 -> (SET I8 _47 _3211)", null, null, null, 0L, false, false, new int[]{90, 3254}, null);
        CodeGenerator_x86simd.rulev[3640] = new Rule(3640, false, true, 3377, "3640: _3334 -> (SET I8 _101 _3333)", null, null, null, 0L, false, false, new int[]{144, 3376}, null);
        CodeGenerator_x86simd.rulev[3642] = new Rule(3642, false, true, 3379, "3642: _3336 -> (SET I8 _103 _3335)", null, null, null, 0L, false, false, new int[]{146, 3378}, null);
        CodeGenerator_x86simd.rulev[3644] = new Rule(3644, false, true, 3381, "3644: _3338 -> (SET I8 _105 _3337)", null, null, null, 0L, false, false, new int[]{148, 3380}, null);
        CodeGenerator_x86simd.rulev[3646] = new Rule(3646, false, true, 3383, "3646: _3340 -> (SET I8 _107 _3339)", null, null, null, 0L, false, false, new int[]{150, 3382}, null);
        CodeGenerator_x86simd.rulev[3648] = new Rule(3648, false, true, 3385, "3648: _3342 -> (SET I8 _109 _3341)", null, null, null, 0L, false, false, new int[]{152, 3384}, null);
        CodeGenerator_x86simd.rulev[3650] = new Rule(3650, false, true, 3387, "3650: _3344 -> (SET I8 _111 _3343)", null, null, null, 0L, false, false, new int[]{154, 3386}, null);
        CodeGenerator_x86simd.rulev[3652] = new Rule(3652, false, true, 3389, "3652: _3346 -> (SET I8 _113 _3345)", null, null, null, 0L, false, false, new int[]{156, 3388}, null);
        CodeGenerator_x86simd.rulev[3654] = new Rule(3654, false, true, 3391, "3654: _3348 -> (SET I8 _115 _3347)", null, null, null, 0L, false, false, new int[]{158, 3390}, null);
        CodeGenerator_x86simd.rulev[3657] = new Rule(3657, false, true, 3393, "3657: _3350 -> (SET I8 _7 _3349)", null, null, null, 0L, false, false, new int[]{50, 3392}, null);
        CodeGenerator_x86simd.rulev[3659] = new Rule(3659, false, true, 3395, "3659: _3352 -> (SET I8 _9 _3351)", null, null, null, 0L, false, false, new int[]{52, 3394}, null);
        CodeGenerator_x86simd.rulev[3661] = new Rule(3661, false, true, 3397, "3661: _3354 -> (SET I8 _11 _3353)", null, null, null, 0L, false, false, new int[]{54, 3396}, null);
        CodeGenerator_x86simd.rulev[3663] = new Rule(3663, false, true, 3399, "3663: _3356 -> (SET I8 _13 _3355)", null, null, null, 0L, false, false, new int[]{56, 3398}, null);
        CodeGenerator_x86simd.rulev[3665] = new Rule(3665, false, true, 3401, "3665: _3358 -> (SET I8 _15 _3357)", null, null, null, 0L, false, false, new int[]{58, 3400}, null);
        CodeGenerator_x86simd.rulev[3667] = new Rule(3667, false, true, 3403, "3667: _3360 -> (SET I8 _18 _3359)", null, null, null, 0L, false, false, new int[]{61, 3402}, null);
        CodeGenerator_x86simd.rulev[3669] = new Rule(3669, false, true, 3405, "3669: _3362 -> (SET I8 _21 _3361)", null, null, null, 0L, false, false, new int[]{64, 3404}, null);
        CodeGenerator_x86simd.rulev[3671] = new Rule(3671, false, true, 3407, "3671: _3364 -> (SET I8 _24 _3363)", null, null, null, 0L, false, false, new int[]{67, 3406}, null);
        CodeGenerator_x86simd.rulev[3673] = new Rule(3673, false, true, 3409, "3673: _3366 -> (SET I8 _26 _3365)", null, null, null, 0L, false, false, new int[]{69, 3408}, null);
        CodeGenerator_x86simd.rulev[3675] = new Rule(3675, false, true, 3411, "3675: _3368 -> (SET I8 _29 _3367)", null, null, null, 0L, false, false, new int[]{72, 3410}, null);
        CodeGenerator_x86simd.rulev[3677] = new Rule(3677, false, true, 3413, "3677: _3370 -> (SET I8 _32 _3369)", null, null, null, 0L, false, false, new int[]{75, 3412}, null);
        CodeGenerator_x86simd.rulev[3679] = new Rule(3679, false, true, 3415, "3679: _3372 -> (SET I8 _35 _3371)", null, null, null, 0L, false, false, new int[]{78, 3414}, null);
        CodeGenerator_x86simd.rulev[3681] = new Rule(3681, false, true, 3417, "3681: _3374 -> (SET I8 _38 _3373)", null, null, null, 0L, false, false, new int[]{81, 3416}, null);
        CodeGenerator_x86simd.rulev[3683] = new Rule(3683, false, true, 3419, "3683: _3376 -> (SET I8 _41 _3375)", null, null, null, 0L, false, false, new int[]{84, 3418}, null);
        CodeGenerator_x86simd.rulev[3685] = new Rule(3685, false, true, 3421, "3685: _3378 -> (SET I8 _44 _3377)", null, null, null, 0L, false, false, new int[]{87, 3420}, null);
        CodeGenerator_x86simd.rulev[3687] = new Rule(3687, false, true, 3423, "3687: _3380 -> (SET I8 _47 _3379)", null, null, null, 0L, false, false, new int[]{90, 3422}, null);
        CodeGenerator_x86simd.rulev[3729] = new Rule(3729, false, true, 3460, "3729: _3417 -> (SET I8 _101 _2862)", null, null, null, 0L, false, false, new int[]{144, 2905}, null);
        CodeGenerator_x86simd.rulev[3730] = new Rule(3730, false, true, 3461, "3730: _3418 -> (SET I8 _103 _2865)", null, null, null, 0L, false, false, new int[]{146, 2908}, null);
        CodeGenerator_x86simd.rulev[3731] = new Rule(3731, false, true, 3462, "3731: _3419 -> (SET I8 _105 _2868)", null, null, null, 0L, false, false, new int[]{148, 2911}, null);
        CodeGenerator_x86simd.rulev[3732] = new Rule(3732, false, true, 3463, "3732: _3420 -> (SET I8 _107 _2871)", null, null, null, 0L, false, false, new int[]{150, 2914}, null);
        CodeGenerator_x86simd.rulev[3734] = new Rule(3734, false, true, 3465, "3734: _3422 -> (SET I8 _109 _3421)", null, null, null, 0L, false, false, new int[]{152, 3464}, null);
        CodeGenerator_x86simd.rulev[3735] = new Rule(3735, false, true, 3466, "3735: _3423 -> (SET I8 _111 _2874)", null, null, null, 0L, false, false, new int[]{154, 2917}, null);
    }

    private static void rrinit3400() {
        CodeGenerator_x86simd.rulev[3736] = new Rule(3736, false, true, 3467, "3736: _3424 -> (SET I8 _113 _2877)", null, null, null, 0L, false, false, new int[]{156, 2920}, null);
        CodeGenerator_x86simd.rulev[3737] = new Rule(3737, false, true, 3468, "3737: _3425 -> (SET I8 _115 _2880)", null, null, null, 0L, false, false, new int[]{158, 2923}, null);
        CodeGenerator_x86simd.rulev[3739] = new Rule(3739, false, true, 3469, "3739: _3426 -> (SET I8 _7 _2901)", null, null, null, 0L, false, false, new int[]{50, 2944}, null);
        CodeGenerator_x86simd.rulev[3740] = new Rule(3740, false, true, 3470, "3740: _3427 -> (SET I8 _9 _2904)", null, null, null, 0L, false, false, new int[]{52, 2947}, null);
        CodeGenerator_x86simd.rulev[3741] = new Rule(3741, false, true, 3471, "3741: _3428 -> (SET I8 _11 _2907)", null, null, null, 0L, false, false, new int[]{54, 2950}, null);
        CodeGenerator_x86simd.rulev[3742] = new Rule(3742, false, true, 3472, "3742: _3429 -> (SET I8 _13 _2910)", null, null, null, 0L, false, false, new int[]{56, 2953}, null);
        CodeGenerator_x86simd.rulev[3743] = new Rule(3743, false, true, 3473, "3743: _3430 -> (SET I8 _15 _2913)", null, null, null, 0L, false, false, new int[]{58, 2956}, null);
        CodeGenerator_x86simd.rulev[3744] = new Rule(3744, false, true, 3474, "3744: _3431 -> (SET I8 _18 _2916)", null, null, null, 0L, false, false, new int[]{61, 2959}, null);
        CodeGenerator_x86simd.rulev[3745] = new Rule(3745, false, true, 3475, "3745: _3432 -> (SET I8 _21 _2919)", null, null, null, 0L, false, false, new int[]{64, 2962}, null);
        CodeGenerator_x86simd.rulev[3746] = new Rule(3746, false, true, 3476, "3746: _3433 -> (SET I8 _24 _2922)", null, null, null, 0L, false, false, new int[]{67, 2965}, null);
        CodeGenerator_x86simd.rulev[3747] = new Rule(3747, false, true, 3477, "3747: _3434 -> (SET I8 _26 _2925)", null, null, null, 0L, false, false, new int[]{69, 2968}, null);
        CodeGenerator_x86simd.rulev[3748] = new Rule(3748, false, true, 3478, "3748: _3435 -> (SET I8 _29 _2928)", null, null, null, 0L, false, false, new int[]{72, 2971}, null);
        CodeGenerator_x86simd.rulev[3749] = new Rule(3749, false, true, 3479, "3749: _3436 -> (SET I8 _32 _2931)", null, null, null, 0L, false, false, new int[]{75, 2974}, null);
        CodeGenerator_x86simd.rulev[3750] = new Rule(3750, false, true, 3480, "3750: _3437 -> (SET I8 _35 _2934)", null, null, null, 0L, false, false, new int[]{78, 2977}, null);
        CodeGenerator_x86simd.rulev[3751] = new Rule(3751, false, true, 3481, "3751: _3438 -> (SET I8 _38 _2937)", null, null, null, 0L, false, false, new int[]{81, 2980}, null);
        CodeGenerator_x86simd.rulev[3752] = new Rule(3752, false, true, 3482, "3752: _3439 -> (SET I8 _41 _2940)", null, null, null, 0L, false, false, new int[]{84, 2983}, null);
        CodeGenerator_x86simd.rulev[3753] = new Rule(3753, false, true, 3483, "3753: _3440 -> (SET I8 _44 _2943)", null, null, null, 0L, false, false, new int[]{87, 2986}, null);
        CodeGenerator_x86simd.rulev[3754] = new Rule(3754, false, true, 3484, "3754: _3441 -> (SET I8 _47 _2946)", null, null, null, 0L, false, false, new int[]{90, 2989}, null);
        CodeGenerator_x86simd.rulev[3942] = new Rule(3942, false, false, 10, "3942: void -> (SET I8 memb rcb)", ImList.list(ImList.list("movb", "$2", "$1")), null, null, 0L, false, false, new int[]{34, 39}, new String[]{null, null, null});
        CodeGenerator_x86simd.rulev[3946] = new Rule(3946, false, false, 10, "3946: void -> (SET I8 xregb regb)", ImList.list(ImList.list("movb", "$2", "$1")), null, null, 0L, false, false, new int[]{11, 7}, new String[]{null, null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[133] = new Rule(133, false, true, 93, "133: _50 -> (SET I16 _49 memw)", null, null, null, 0L, false, false, new int[]{92, 33}, null);
        CodeGenerator_x86simd.rulev[135] = new Rule(135, false, true, 95, "135: _52 -> (SET I16 _51 memw)", null, null, null, 0L, false, false, new int[]{94, 33}, null);
        CodeGenerator_x86simd.rulev[137] = new Rule(137, false, true, 97, "137: _54 -> (SET I16 _53 memw)", null, null, null, 0L, false, false, new int[]{96, 33}, null);
        CodeGenerator_x86simd.rulev[139] = new Rule(139, false, true, 99, "139: _56 -> (SET I16 _55 memw)", null, null, null, 0L, false, false, new int[]{98, 33}, null);
        CodeGenerator_x86simd.rulev[141] = new Rule(141, false, true, 101, "141: _58 -> (SET I16 _57 memw)", null, null, null, 0L, false, false, new int[]{100, 33}, null);
        CodeGenerator_x86simd.rulev[143] = new Rule(143, false, true, 103, "143: _60 -> (SET I16 _59 memw)", null, null, null, 0L, false, false, new int[]{102, 33}, null);
        CodeGenerator_x86simd.rulev[145] = new Rule(145, false, true, 105, "145: _62 -> (SET I16 _61 memw)", null, null, null, 0L, false, false, new int[]{104, 33}, null);
        CodeGenerator_x86simd.rulev[147] = new Rule(147, false, true, 107, "147: _64 -> (SET I16 _63 memw)", null, null, null, 0L, false, false, new int[]{106, 33}, null);
        CodeGenerator_x86simd.rulev[175] = new Rule(175, false, true, 132, "175: _89 -> (SET I16 memw _49)", null, null, null, 0L, false, false, new int[]{33, 92}, null);
        CodeGenerator_x86simd.rulev[176] = new Rule(176, false, true, 133, "176: _90 -> (SET I16 memw _51)", null, null, null, 0L, false, false, new int[]{33, 94}, null);
        CodeGenerator_x86simd.rulev[177] = new Rule(177, false, true, 134, "177: _91 -> (SET I16 memw _53)", null, null, null, 0L, false, false, new int[]{33, 96}, null);
        CodeGenerator_x86simd.rulev[178] = new Rule(178, false, true, 135, "178: _92 -> (SET I16 memw _55)", null, null, null, 0L, false, false, new int[]{33, 98}, null);
        CodeGenerator_x86simd.rulev[179] = new Rule(179, false, true, 136, "179: _93 -> (SET I16 memw _57)", null, null, null, 0L, false, false, new int[]{33, 100}, null);
        CodeGenerator_x86simd.rulev[180] = new Rule(180, false, true, 137, "180: _94 -> (SET I16 memw _59)", null, null, null, 0L, false, false, new int[]{33, 102}, null);
        CodeGenerator_x86simd.rulev[181] = new Rule(181, false, true, 138, "181: _95 -> (SET I16 memw _61)", null, null, null, 0L, false, false, new int[]{33, 104}, null);
        CodeGenerator_x86simd.rulev[182] = new Rule(182, false, true, 139, "182: _96 -> (SET I16 memw _63)", null, null, null, 0L, false, false, new int[]{33, 106}, null);
        CodeGenerator_x86simd.rulev[207] = new Rule(207, false, true, 161, "207: _118 -> (SET I16 _117 memw)", null, null, null, 0L, false, false, new int[]{160, 33}, null);
        CodeGenerator_x86simd.rulev[209] = new Rule(209, false, true, 163, "209: _120 -> (SET I16 _119 memw)", null, null, null, 0L, false, false, new int[]{162, 33}, null);
        CodeGenerator_x86simd.rulev[211] = new Rule(211, false, true, 165, "211: _122 -> (SET I16 _121 memw)", null, null, null, 0L, false, false, new int[]{164, 33}, null);
        CodeGenerator_x86simd.rulev[213] = new Rule(213, false, true, 167, "213: _124 -> (SET I16 _123 memw)", null, null, null, 0L, false, false, new int[]{166, 33}, null);
        CodeGenerator_x86simd.rulev[229] = new Rule(229, false, true, 180, "229: _137 -> (SET I16 memw _117)", null, null, null, 0L, false, false, new int[]{33, 160}, null);
        CodeGenerator_x86simd.rulev[230] = new Rule(230, false, true, 181, "230: _138 -> (SET I16 memw _119)", null, null, null, 0L, false, false, new int[]{33, 162}, null);
        CodeGenerator_x86simd.rulev[231] = new Rule(231, false, true, 182, "231: _139 -> (SET I16 memw _121)", null, null, null, 0L, false, false, new int[]{33, 164}, null);
        CodeGenerator_x86simd.rulev[232] = new Rule(232, false, true, 183, "232: _140 -> (SET I16 memw _123)", null, null, null, 0L, false, false, new int[]{33, 166}, null);
        CodeGenerator_x86simd.rulev[253] = new Rule(253, false, false, 10, "253: void -> (SET I16 mregw _49)", ImList.list(ImList.list("pextrw", ImList.list("imm", "0"), "$2", "%edx"), ImList.list("movw", "%dx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{43, 92}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[254] = new Rule(254, false, false, 10, "254: void -> (SET I16 mregw _51)", ImList.list(ImList.list("pextrw", ImList.list("imm", "1"), "$2", "%edx"), ImList.list("movw", "%dx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{43, 94}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[255] = new Rule(255, false, false, 10, "255: void -> (SET I16 mregw _53)", ImList.list(ImList.list("pextrw", ImList.list("imm", "2"), "$2", "%edx"), ImList.list("movw", "%dx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{43, 96}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[256] = new Rule(256, false, false, 10, "256: void -> (SET I16 mregw _55)", ImList.list(ImList.list("pextrw", ImList.list("imm", "3"), "$2", "%edx"), ImList.list("movw", "%dx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{43, 98}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[257] = new Rule(257, false, false, 10, "257: void -> (SET I16 mregw _57)", ImList.list(ImList.list("pextrw", ImList.list("imm", "4"), "$2", "%edx"), ImList.list("movw", "%dx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{43, 100}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[258] = new Rule(258, false, false, 10, "258: void -> (SET I16 mregw _59)", ImList.list(ImList.list("pextrw", ImList.list("imm", "5"), "$2", "%edx"), ImList.list("movw", "%dx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{43, 102}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[259] = new Rule(259, false, false, 10, "259: void -> (SET I16 mregw _61)", ImList.list(ImList.list("pextrw", ImList.list("imm", "6"), "$2", "%edx"), ImList.list("movw", "%dx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{43, 104}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[260] = new Rule(260, false, false, 10, "260: void -> (SET I16 mregw _63)", ImList.list(ImList.list("pextrw", ImList.list("imm", "7"), "$2", "%edx"), ImList.list("movw", "%dx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{43, 106}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[315] = new Rule(315, false, true, 219, "315: _176 -> (SET I16 _175 regw)", null, null, null, 0L, false, false, new int[]{218, 6}, null);
        CodeGenerator_x86simd.rulev[317] = new Rule(317, false, true, 221, "317: _178 -> (SET I16 _177 regw)", null, null, null, 0L, false, false, new int[]{220, 6}, null);
        CodeGenerator_x86simd.rulev[319] = new Rule(319, false, true, 223, "319: _180 -> (SET I16 _179 regw)", null, null, null, 0L, false, false, new int[]{222, 6}, null);
        CodeGenerator_x86simd.rulev[321] = new Rule(321, false, true, 225, "321: _182 -> (SET I16 _181 regw)", null, null, null, 0L, false, false, new int[]{224, 6}, null);
        CodeGenerator_x86simd.rulev[323] = new Rule(323, false, true, 227, "323: _184 -> (SET I16 _183 regw)", null, null, null, 0L, false, false, new int[]{226, 6}, null);
        CodeGenerator_x86simd.rulev[325] = new Rule(325, false, true, 229, "325: _186 -> (SET I16 _185 regw)", null, null, null, 0L, false, false, new int[]{228, 6}, null);
        CodeGenerator_x86simd.rulev[327] = new Rule(327, false, true, 231, "327: _188 -> (SET I16 _187 regw)", null, null, null, 0L, false, false, new int[]{230, 6}, null);
        CodeGenerator_x86simd.rulev[329] = new Rule(329, false, true, 233, "329: _190 -> (SET I16 _189 regw)", null, null, null, 0L, false, false, new int[]{232, 6}, null);
        CodeGenerator_x86simd.rulev[331] = new Rule(331, false, false, 10, "331: void -> (SET I16 _175 regw)", ImList.list(ImList.list("movw", "$2", "%dx"), ImList.list("pinsrw", ImList.list("imm", "0"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{218, 6}, new String[]{null, null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[332] = new Rule(332, false, false, 10, "332: void -> (SET I16 _177 regw)", ImList.list(ImList.list("movw", "$2", "%dx"), ImList.list("pinsrw", ImList.list("imm", "1"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{220, 6}, new String[]{null, null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[333] = new Rule(333, false, false, 10, "333: void -> (SET I16 _179 regw)", ImList.list(ImList.list("movw", "$2", "%dx"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{222, 6}, new String[]{null, null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[334] = new Rule(334, false, false, 10, "334: void -> (SET I16 _181 regw)", ImList.list(ImList.list("movw", "$2", "%dx"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{224, 6}, new String[]{null, null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[335] = new Rule(335, false, false, 10, "335: void -> (SET I16 _183 regw)", ImList.list(ImList.list("movw", "$2", "%dx"), ImList.list("pinsrw", ImList.list("imm", "4"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{226, 6}, new String[]{null, null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[336] = new Rule(336, false, false, 10, "336: void -> (SET I16 _185 regw)", ImList.list(ImList.list("movw", "$2", "%dx"), ImList.list("pinsrw", ImList.list("imm", "5"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{228, 6}, new String[]{null, null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[337] = new Rule(337, false, false, 10, "337: void -> (SET I16 _187 regw)", ImList.list(ImList.list("movw", "$2", "%dx"), ImList.list("pinsrw", ImList.list("imm", "6"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{230, 6}, new String[]{null, null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[338] = new Rule(338, false, false, 10, "338: void -> (SET I16 _189 regw)", ImList.list(ImList.list("movw", "$2", "%dx"), ImList.list("pinsrw", ImList.list("imm", "7"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{232, 6}, new String[]{null, null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[360] = new Rule(360, false, false, 10, "360: void -> (SET I16 mregw _117)", ImList.list(ImList.list("pextrw", ImList.list("imm", "0"), "$2", "%edx"), ImList.list("movw", "%dx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{43, 160}, new String[]{null, null, "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[361] = new Rule(361, false, false, 10, "361: void -> (SET I16 mregw _119)", ImList.list(ImList.list("pextrw", ImList.list("imm", "1"), "$2", "%edx"), ImList.list("movw", "%dx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{43, 162}, new String[]{null, null, "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[362] = new Rule(362, false, false, 10, "362: void -> (SET I16 mregw _121)", ImList.list(ImList.list("pextrw", ImList.list("imm", "2"), "$2", "%edx"), ImList.list("movw", "%dx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{43, 164}, new String[]{null, null, "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[363] = new Rule(363, false, false, 10, "363: void -> (SET I16 mregw _123)", ImList.list(ImList.list("pextrw", ImList.list("imm", "3"), "$2", "%edx"), ImList.list("movw", "%dx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{43, 166}, new String[]{null, null, "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[392] = new Rule(392, false, true, 259, "392: _216 -> (SET I16 _215 regw)", null, null, null, 0L, false, false, new int[]{258, 6}, null);
        CodeGenerator_x86simd.rulev[394] = new Rule(394, false, true, 261, "394: _218 -> (SET I16 _217 regw)", null, null, null, 0L, false, false, new int[]{260, 6}, null);
        CodeGenerator_x86simd.rulev[396] = new Rule(396, false, true, 263, "396: _220 -> (SET I16 _219 regw)", null, null, null, 0L, false, false, new int[]{262, 6}, null);
        CodeGenerator_x86simd.rulev[398] = new Rule(398, false, true, 265, "398: _222 -> (SET I16 _221 regw)", null, null, null, 0L, false, false, new int[]{264, 6}, null);
        CodeGenerator_x86simd.rulev[400] = new Rule(400, false, false, 10, "400: void -> (SET I16 _215 regw)", ImList.list(ImList.list("movw", "$2", "%dx"), ImList.list("pinsrw", ImList.list("imm", "0"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{258, 6}, new String[]{null, null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[401] = new Rule(401, false, false, 10, "401: void -> (SET I16 _217 regw)", ImList.list(ImList.list("movw", "$2", "%dx"), ImList.list("pinsrw", ImList.list("imm", "1"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{260, 6}, new String[]{null, null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[402] = new Rule(402, false, false, 10, "402: void -> (SET I16 _219 regw)", ImList.list(ImList.list("movw", "$2", "%dx"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{262, 6}, new String[]{null, null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[403] = new Rule(403, false, false, 10, "403: void -> (SET I16 _221 regw)", ImList.list(ImList.list("movw", "$2", "%dx"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{264, 6}, new String[]{null, null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[420] = new Rule(420, false, true, 278, "420: _235 -> (SET I16 _215 con)", null, null, null, 0L, false, false, new int[]{258, 19}, null);
        CodeGenerator_x86simd.rulev[421] = new Rule(421, false, true, 279, "421: _236 -> (SET I16 _217 con)", null, null, null, 0L, false, false, new int[]{260, 19}, null);
        CodeGenerator_x86simd.rulev[422] = new Rule(422, false, true, 280, "422: _237 -> (SET I16 _219 con)", null, null, null, 0L, false, false, new int[]{262, 19}, null);
        CodeGenerator_x86simd.rulev[423] = new Rule(423, false, true, 281, "423: _238 -> (SET I16 _221 con)", null, null, null, 0L, false, false, new int[]{264, 19}, null);
        CodeGenerator_x86simd.rulev[445] = new Rule(445, false, true, 300, "445: _257 -> (SET I16 _175 con)", null, null, null, 0L, false, false, new int[]{218, 19}, null);
        CodeGenerator_x86simd.rulev[446] = new Rule(446, false, true, 301, "446: _258 -> (SET I16 _177 con)", null, null, null, 0L, false, false, new int[]{220, 19}, null);
        CodeGenerator_x86simd.rulev[447] = new Rule(447, false, true, 302, "447: _259 -> (SET I16 _179 con)", null, null, null, 0L, false, false, new int[]{222, 19}, null);
        CodeGenerator_x86simd.rulev[448] = new Rule(448, false, true, 303, "448: _260 -> (SET I16 _181 con)", null, null, null, 0L, false, false, new int[]{224, 19}, null);
        CodeGenerator_x86simd.rulev[449] = new Rule(449, false, true, 304, "449: _261 -> (SET I16 _183 con)", null, null, null, 0L, false, false, new int[]{226, 19}, null);
        CodeGenerator_x86simd.rulev[450] = new Rule(450, false, true, 305, "450: _262 -> (SET I16 _185 con)", null, null, null, 0L, false, false, new int[]{228, 19}, null);
        CodeGenerator_x86simd.rulev[451] = new Rule(451, false, true, 306, "451: _263 -> (SET I16 _187 con)", null, null, null, 0L, false, false, new int[]{230, 19}, null);
        CodeGenerator_x86simd.rulev[452] = new Rule(452, false, true, 307, "452: _264 -> (SET I16 _189 con)", null, null, null, 0L, false, false, new int[]{232, 19}, null);
        CodeGenerator_x86simd.rulev[877] = new Rule(877, false, true, 724, "877: _681 -> (SET I16 _117 _680)", null, null, null, 0L, false, false, new int[]{160, 723}, null);
        CodeGenerator_x86simd.rulev[881] = new Rule(881, false, true, 728, "881: _685 -> (SET I16 _119 _684)", null, null, null, 0L, false, false, new int[]{162, 727}, null);
        CodeGenerator_x86simd.rulev[885] = new Rule(885, false, true, 732, "885: _689 -> (SET I16 _121 _688)", null, null, null, 0L, false, false, new int[]{164, 731}, null);
        CodeGenerator_x86simd.rulev[889] = new Rule(889, false, true, 736, "889: _693 -> (SET I16 _123 _692)", null, null, null, 0L, false, false, new int[]{166, 735}, null);
        CodeGenerator_x86simd.rulev[896] = new Rule(896, false, true, 742, "896: _699 -> (SET I16 _117 _698)", null, null, null, 0L, false, false, new int[]{160, 741}, null);
        CodeGenerator_x86simd.rulev[902] = new Rule(902, false, true, 748, "902: _705 -> (SET I16 _119 _704)", null, null, null, 0L, false, false, new int[]{162, 747}, null);
        CodeGenerator_x86simd.rulev[908] = new Rule(908, false, true, 754, "908: _711 -> (SET I16 _121 _710)", null, null, null, 0L, false, false, new int[]{164, 753}, null);
        CodeGenerator_x86simd.rulev[914] = new Rule(914, false, true, 760, "914: _717 -> (SET I16 _123 _716)", null, null, null, 0L, false, false, new int[]{166, 759}, null);
    }

    private static void rrinit3500() {
        CodeGenerator_x86simd.rulev[919] = new Rule(919, false, true, 764, "919: _721 -> (SET I16 _49 _720)", null, null, null, 0L, false, false, new int[]{92, 763}, null);
        CodeGenerator_x86simd.rulev[923] = new Rule(923, false, true, 768, "923: _725 -> (SET I16 _51 _724)", null, null, null, 0L, false, false, new int[]{94, 767}, null);
        CodeGenerator_x86simd.rulev[927] = new Rule(927, false, true, 772, "927: _729 -> (SET I16 _53 _728)", null, null, null, 0L, false, false, new int[]{96, 771}, null);
        CodeGenerator_x86simd.rulev[931] = new Rule(931, false, true, 776, "931: _733 -> (SET I16 _55 _732)", null, null, null, 0L, false, false, new int[]{98, 775}, null);
        CodeGenerator_x86simd.rulev[935] = new Rule(935, false, true, 780, "935: _737 -> (SET I16 _57 _736)", null, null, null, 0L, false, false, new int[]{100, 779}, null);
        CodeGenerator_x86simd.rulev[939] = new Rule(939, false, true, 784, "939: _741 -> (SET I16 _59 _740)", null, null, null, 0L, false, false, new int[]{102, 783}, null);
        CodeGenerator_x86simd.rulev[943] = new Rule(943, false, true, 788, "943: _745 -> (SET I16 _61 _744)", null, null, null, 0L, false, false, new int[]{104, 787}, null);
        CodeGenerator_x86simd.rulev[947] = new Rule(947, false, true, 792, "947: _749 -> (SET I16 _63 _748)", null, null, null, 0L, false, false, new int[]{106, 791}, null);
        CodeGenerator_x86simd.rulev[954] = new Rule(954, false, true, 798, "954: _755 -> (SET I16 _49 _754)", null, null, null, 0L, false, false, new int[]{92, 797}, null);
        CodeGenerator_x86simd.rulev[960] = new Rule(960, false, true, 804, "960: _761 -> (SET I16 _51 _760)", null, null, null, 0L, false, false, new int[]{94, 803}, null);
        CodeGenerator_x86simd.rulev[966] = new Rule(966, false, true, 810, "966: _767 -> (SET I16 _53 _766)", null, null, null, 0L, false, false, new int[]{96, 809}, null);
        CodeGenerator_x86simd.rulev[972] = new Rule(972, false, true, 816, "972: _773 -> (SET I16 _55 _772)", null, null, null, 0L, false, false, new int[]{98, 815}, null);
        CodeGenerator_x86simd.rulev[978] = new Rule(978, false, true, 822, "978: _779 -> (SET I16 _57 _778)", null, null, null, 0L, false, false, new int[]{100, 821}, null);
        CodeGenerator_x86simd.rulev[984] = new Rule(984, false, true, 828, "984: _785 -> (SET I16 _59 _784)", null, null, null, 0L, false, false, new int[]{102, 827}, null);
        CodeGenerator_x86simd.rulev[990] = new Rule(990, false, true, 834, "990: _791 -> (SET I16 _61 _790)", null, null, null, 0L, false, false, new int[]{104, 833}, null);
        CodeGenerator_x86simd.rulev[996] = new Rule(996, false, true, 840, "996: _797 -> (SET I16 _63 _796)", null, null, null, 0L, false, false, new int[]{106, 839}, null);
        CodeGenerator_x86simd.rulev[1295] = new Rule(1295, false, true, 1134, "1295: _1091 -> (SET I16 _117 _1090)", null, null, null, 0L, false, false, new int[]{160, 1133}, null);
        CodeGenerator_x86simd.rulev[1301] = new Rule(1301, false, true, 1140, "1301: _1097 -> (SET I16 _119 _1096)", null, null, null, 0L, false, false, new int[]{162, 1139}, null);
        CodeGenerator_x86simd.rulev[1307] = new Rule(1307, false, true, 1146, "1307: _1103 -> (SET I16 _121 _1102)", null, null, null, 0L, false, false, new int[]{164, 1145}, null);
        CodeGenerator_x86simd.rulev[1313] = new Rule(1313, false, true, 1152, "1313: _1109 -> (SET I16 _123 _1108)", null, null, null, 0L, false, false, new int[]{166, 1151}, null);
        CodeGenerator_x86simd.rulev[1320] = new Rule(1320, false, true, 1158, "1320: _1115 -> (SET I16 _117 _1114)", null, null, null, 0L, false, false, new int[]{160, 1157}, null);
        CodeGenerator_x86simd.rulev[1326] = new Rule(1326, false, true, 1164, "1326: _1121 -> (SET I16 _119 _1120)", null, null, null, 0L, false, false, new int[]{162, 1163}, null);
        CodeGenerator_x86simd.rulev[1332] = new Rule(1332, false, true, 1170, "1332: _1127 -> (SET I16 _121 _1126)", null, null, null, 0L, false, false, new int[]{164, 1169}, null);
        CodeGenerator_x86simd.rulev[1338] = new Rule(1338, false, true, 1176, "1338: _1133 -> (SET I16 _123 _1132)", null, null, null, 0L, false, false, new int[]{166, 1175}, null);
        CodeGenerator_x86simd.rulev[1345] = new Rule(1345, false, true, 1182, "1345: _1139 -> (SET I16 _49 _1138)", null, null, null, 0L, false, false, new int[]{92, 1181}, null);
        CodeGenerator_x86simd.rulev[1351] = new Rule(1351, false, true, 1188, "1351: _1145 -> (SET I16 _51 _1144)", null, null, null, 0L, false, false, new int[]{94, 1187}, null);
        CodeGenerator_x86simd.rulev[1357] = new Rule(1357, false, true, 1194, "1357: _1151 -> (SET I16 _53 _1150)", null, null, null, 0L, false, false, new int[]{96, 1193}, null);
        CodeGenerator_x86simd.rulev[1363] = new Rule(1363, false, true, 1200, "1363: _1157 -> (SET I16 _55 _1156)", null, null, null, 0L, false, false, new int[]{98, 1199}, null);
        CodeGenerator_x86simd.rulev[1369] = new Rule(1369, false, true, 1206, "1369: _1163 -> (SET I16 _57 _1162)", null, null, null, 0L, false, false, new int[]{100, 1205}, null);
        CodeGenerator_x86simd.rulev[1375] = new Rule(1375, false, true, 1212, "1375: _1169 -> (SET I16 _59 _1168)", null, null, null, 0L, false, false, new int[]{102, 1211}, null);
        CodeGenerator_x86simd.rulev[1381] = new Rule(1381, false, true, 1218, "1381: _1175 -> (SET I16 _61 _1174)", null, null, null, 0L, false, false, new int[]{104, 1217}, null);
        CodeGenerator_x86simd.rulev[1387] = new Rule(1387, false, true, 1224, "1387: _1181 -> (SET I16 _63 _1180)", null, null, null, 0L, false, false, new int[]{106, 1223}, null);
        CodeGenerator_x86simd.rulev[1394] = new Rule(1394, false, true, 1230, "1394: _1187 -> (SET I16 _49 _1186)", null, null, null, 0L, false, false, new int[]{92, 1229}, null);
        CodeGenerator_x86simd.rulev[1400] = new Rule(1400, false, true, 1236, "1400: _1193 -> (SET I16 _51 _1192)", null, null, null, 0L, false, false, new int[]{94, 1235}, null);
        CodeGenerator_x86simd.rulev[1406] = new Rule(1406, false, true, 1242, "1406: _1199 -> (SET I16 _53 _1198)", null, null, null, 0L, false, false, new int[]{96, 1241}, null);
        CodeGenerator_x86simd.rulev[1412] = new Rule(1412, false, true, 1248, "1412: _1205 -> (SET I16 _55 _1204)", null, null, null, 0L, false, false, new int[]{98, 1247}, null);
        CodeGenerator_x86simd.rulev[1418] = new Rule(1418, false, true, 1254, "1418: _1211 -> (SET I16 _57 _1210)", null, null, null, 0L, false, false, new int[]{100, 1253}, null);
        CodeGenerator_x86simd.rulev[1424] = new Rule(1424, false, true, 1260, "1424: _1217 -> (SET I16 _59 _1216)", null, null, null, 0L, false, false, new int[]{102, 1259}, null);
        CodeGenerator_x86simd.rulev[1430] = new Rule(1430, false, true, 1266, "1430: _1223 -> (SET I16 _61 _1222)", null, null, null, 0L, false, false, new int[]{104, 1265}, null);
        CodeGenerator_x86simd.rulev[1436] = new Rule(1436, false, true, 1272, "1436: _1229 -> (SET I16 _63 _1228)", null, null, null, 0L, false, false, new int[]{106, 1271}, null);
        CodeGenerator_x86simd.rulev[1541] = new Rule(1541, false, true, 1374, "1541: _1331 -> (SET I16 _117 _1330)", null, null, null, 0L, false, false, new int[]{160, 1373}, null);
        CodeGenerator_x86simd.rulev[1547] = new Rule(1547, false, true, 1380, "1547: _1337 -> (SET I16 _119 _1336)", null, null, null, 0L, false, false, new int[]{162, 1379}, null);
        CodeGenerator_x86simd.rulev[1553] = new Rule(1553, false, true, 1386, "1553: _1343 -> (SET I16 _121 _1342)", null, null, null, 0L, false, false, new int[]{164, 1385}, null);
        CodeGenerator_x86simd.rulev[1559] = new Rule(1559, false, true, 1392, "1559: _1349 -> (SET I16 _123 _1348)", null, null, null, 0L, false, false, new int[]{166, 1391}, null);
        CodeGenerator_x86simd.rulev[1566] = new Rule(1566, false, true, 1398, "1566: _1355 -> (SET I16 _117 _1354)", null, null, null, 0L, false, false, new int[]{160, 1397}, null);
        CodeGenerator_x86simd.rulev[1572] = new Rule(1572, false, true, 1404, "1572: _1361 -> (SET I16 _119 _1360)", null, null, null, 0L, false, false, new int[]{162, 1403}, null);
        CodeGenerator_x86simd.rulev[1578] = new Rule(1578, false, true, 1410, "1578: _1367 -> (SET I16 _121 _1366)", null, null, null, 0L, false, false, new int[]{164, 1409}, null);
        CodeGenerator_x86simd.rulev[1584] = new Rule(1584, false, true, 1416, "1584: _1373 -> (SET I16 _123 _1372)", null, null, null, 0L, false, false, new int[]{166, 1415}, null);
        CodeGenerator_x86simd.rulev[1811] = new Rule(1811, false, true, 1638, "1811: _1595 -> (SET I16 _49 _1594)", null, null, null, 0L, false, false, new int[]{92, 1637}, null);
        CodeGenerator_x86simd.rulev[1817] = new Rule(1817, false, true, 1644, "1817: _1601 -> (SET I16 _51 _1600)", null, null, null, 0L, false, false, new int[]{94, 1643}, null);
        CodeGenerator_x86simd.rulev[1823] = new Rule(1823, false, true, 1650, "1823: _1607 -> (SET I16 _53 _1606)", null, null, null, 0L, false, false, new int[]{96, 1649}, null);
        CodeGenerator_x86simd.rulev[1829] = new Rule(1829, false, true, 1656, "1829: _1613 -> (SET I16 _55 _1612)", null, null, null, 0L, false, false, new int[]{98, 1655}, null);
        CodeGenerator_x86simd.rulev[1835] = new Rule(1835, false, true, 1662, "1835: _1619 -> (SET I16 _57 _1618)", null, null, null, 0L, false, false, new int[]{100, 1661}, null);
        CodeGenerator_x86simd.rulev[1841] = new Rule(1841, false, true, 1668, "1841: _1625 -> (SET I16 _59 _1624)", null, null, null, 0L, false, false, new int[]{102, 1667}, null);
        CodeGenerator_x86simd.rulev[1847] = new Rule(1847, false, true, 1674, "1847: _1631 -> (SET I16 _61 _1630)", null, null, null, 0L, false, false, new int[]{104, 1673}, null);
        CodeGenerator_x86simd.rulev[1853] = new Rule(1853, false, true, 1680, "1853: _1637 -> (SET I16 _63 _1636)", null, null, null, 0L, false, false, new int[]{106, 1679}, null);
        CodeGenerator_x86simd.rulev[1860] = new Rule(1860, false, true, 1686, "1860: _1643 -> (SET I16 _49 _1642)", null, null, null, 0L, false, false, new int[]{92, 1685}, null);
        CodeGenerator_x86simd.rulev[1866] = new Rule(1866, false, true, 1692, "1866: _1649 -> (SET I16 _51 _1648)", null, null, null, 0L, false, false, new int[]{94, 1691}, null);
        CodeGenerator_x86simd.rulev[1872] = new Rule(1872, false, true, 1698, "1872: _1655 -> (SET I16 _53 _1654)", null, null, null, 0L, false, false, new int[]{96, 1697}, null);
        CodeGenerator_x86simd.rulev[1878] = new Rule(1878, false, true, 1704, "1878: _1661 -> (SET I16 _55 _1660)", null, null, null, 0L, false, false, new int[]{98, 1703}, null);
        CodeGenerator_x86simd.rulev[1884] = new Rule(1884, false, true, 1710, "1884: _1667 -> (SET I16 _57 _1666)", null, null, null, 0L, false, false, new int[]{100, 1709}, null);
        CodeGenerator_x86simd.rulev[1890] = new Rule(1890, false, true, 1716, "1890: _1673 -> (SET I16 _59 _1672)", null, null, null, 0L, false, false, new int[]{102, 1715}, null);
        CodeGenerator_x86simd.rulev[1896] = new Rule(1896, false, true, 1722, "1896: _1679 -> (SET I16 _61 _1678)", null, null, null, 0L, false, false, new int[]{104, 1721}, null);
        CodeGenerator_x86simd.rulev[1902] = new Rule(1902, false, true, 1728, "1902: _1685 -> (SET I16 _63 _1684)", null, null, null, 0L, false, false, new int[]{106, 1727}, null);
        CodeGenerator_x86simd.rulev[2041] = new Rule(2041, false, true, 1862, "2041: _1819 -> (SET I16 _117 _1818)", null, null, null, 0L, false, false, new int[]{160, 1861}, null);
        CodeGenerator_x86simd.rulev[2047] = new Rule(2047, false, true, 1868, "2047: _1825 -> (SET I16 _119 _1824)", null, null, null, 0L, false, false, new int[]{162, 1867}, null);
        CodeGenerator_x86simd.rulev[2053] = new Rule(2053, false, true, 1874, "2053: _1831 -> (SET I16 _121 _1830)", null, null, null, 0L, false, false, new int[]{164, 1873}, null);
        CodeGenerator_x86simd.rulev[2059] = new Rule(2059, false, true, 1880, "2059: _1837 -> (SET I16 _123 _1836)", null, null, null, 0L, false, false, new int[]{166, 1879}, null);
        CodeGenerator_x86simd.rulev[2066] = new Rule(2066, false, true, 1886, "2066: _1843 -> (SET I16 _117 _1842)", null, null, null, 0L, false, false, new int[]{160, 1885}, null);
        CodeGenerator_x86simd.rulev[2072] = new Rule(2072, false, true, 1892, "2072: _1849 -> (SET I16 _119 _1848)", null, null, null, 0L, false, false, new int[]{162, 1891}, null);
        CodeGenerator_x86simd.rulev[2078] = new Rule(2078, false, true, 1898, "2078: _1855 -> (SET I16 _121 _1854)", null, null, null, 0L, false, false, new int[]{164, 1897}, null);
        CodeGenerator_x86simd.rulev[2084] = new Rule(2084, false, true, 1904, "2084: _1861 -> (SET I16 _123 _1860)", null, null, null, 0L, false, false, new int[]{166, 1903}, null);
        CodeGenerator_x86simd.rulev[2279] = new Rule(2279, false, true, 2094, "2279: _2051 -> (SET I16 _49 _2050)", null, null, null, 0L, false, false, new int[]{92, 2093}, null);
        CodeGenerator_x86simd.rulev[2285] = new Rule(2285, false, true, 2100, "2285: _2057 -> (SET I16 _51 _2056)", null, null, null, 0L, false, false, new int[]{94, 2099}, null);
        CodeGenerator_x86simd.rulev[2291] = new Rule(2291, false, true, 2106, "2291: _2063 -> (SET I16 _53 _2062)", null, null, null, 0L, false, false, new int[]{96, 2105}, null);
        CodeGenerator_x86simd.rulev[2297] = new Rule(2297, false, true, 2112, "2297: _2069 -> (SET I16 _55 _2068)", null, null, null, 0L, false, false, new int[]{98, 2111}, null);
        CodeGenerator_x86simd.rulev[2303] = new Rule(2303, false, true, 2118, "2303: _2075 -> (SET I16 _57 _2074)", null, null, null, 0L, false, false, new int[]{100, 2117}, null);
        CodeGenerator_x86simd.rulev[2309] = new Rule(2309, false, true, 2124, "2309: _2081 -> (SET I16 _59 _2080)", null, null, null, 0L, false, false, new int[]{102, 2123}, null);
        CodeGenerator_x86simd.rulev[2315] = new Rule(2315, false, true, 2130, "2315: _2087 -> (SET I16 _61 _2086)", null, null, null, 0L, false, false, new int[]{104, 2129}, null);
        CodeGenerator_x86simd.rulev[2321] = new Rule(2321, false, true, 2136, "2321: _2093 -> (SET I16 _63 _2092)", null, null, null, 0L, false, false, new int[]{106, 2135}, null);
        CodeGenerator_x86simd.rulev[2328] = new Rule(2328, false, true, 2142, "2328: _2099 -> (SET I16 _49 _2098)", null, null, null, 0L, false, false, new int[]{92, 2141}, null);
        CodeGenerator_x86simd.rulev[2334] = new Rule(2334, false, true, 2148, "2334: _2105 -> (SET I16 _51 _2104)", null, null, null, 0L, false, false, new int[]{94, 2147}, null);
        CodeGenerator_x86simd.rulev[2340] = new Rule(2340, false, true, 2154, "2340: _2111 -> (SET I16 _53 _2110)", null, null, null, 0L, false, false, new int[]{96, 2153}, null);
        CodeGenerator_x86simd.rulev[2346] = new Rule(2346, false, true, 2160, "2346: _2117 -> (SET I16 _55 _2116)", null, null, null, 0L, false, false, new int[]{98, 2159}, null);
        CodeGenerator_x86simd.rulev[2352] = new Rule(2352, false, true, 2166, "2352: _2123 -> (SET I16 _57 _2122)", null, null, null, 0L, false, false, new int[]{100, 2165}, null);
        CodeGenerator_x86simd.rulev[2358] = new Rule(2358, false, true, 2172, "2358: _2129 -> (SET I16 _59 _2128)", null, null, null, 0L, false, false, new int[]{102, 2171}, null);
        CodeGenerator_x86simd.rulev[2364] = new Rule(2364, false, true, 2178, "2364: _2135 -> (SET I16 _61 _2134)", null, null, null, 0L, false, false, new int[]{104, 2177}, null);
        CodeGenerator_x86simd.rulev[2370] = new Rule(2370, false, true, 2184, "2370: _2141 -> (SET I16 _63 _2140)", null, null, null, 0L, false, false, new int[]{106, 2183}, null);
        CodeGenerator_x86simd.rulev[2474] = new Rule(2474, false, true, 2284, "2474: _2241 -> (SET I16 _117 _2240)", null, null, null, 0L, false, false, new int[]{160, 2283}, null);
        CodeGenerator_x86simd.rulev[2478] = new Rule(2478, false, true, 2288, "2478: _2245 -> (SET I16 _119 _2244)", null, null, null, 0L, false, false, new int[]{162, 2287}, null);
        CodeGenerator_x86simd.rulev[2482] = new Rule(2482, false, true, 2292, "2482: _2249 -> (SET I16 _121 _2248)", null, null, null, 0L, false, false, new int[]{164, 2291}, null);
        CodeGenerator_x86simd.rulev[2486] = new Rule(2486, false, true, 2296, "2486: _2253 -> (SET I16 _123 _2252)", null, null, null, 0L, false, false, new int[]{166, 2295}, null);
        CodeGenerator_x86simd.rulev[2601] = new Rule(2601, false, true, 2408, "2601: _2365 -> (SET I16 _49 _2364)", null, null, null, 0L, false, false, new int[]{92, 2407}, null);
        CodeGenerator_x86simd.rulev[2605] = new Rule(2605, false, true, 2412, "2605: _2369 -> (SET I16 _51 _2368)", null, null, null, 0L, false, false, new int[]{94, 2411}, null);
        CodeGenerator_x86simd.rulev[2609] = new Rule(2609, false, true, 2416, "2609: _2373 -> (SET I16 _53 _2372)", null, null, null, 0L, false, false, new int[]{96, 2415}, null);
        CodeGenerator_x86simd.rulev[2613] = new Rule(2613, false, true, 2420, "2613: _2377 -> (SET I16 _55 _2376)", null, null, null, 0L, false, false, new int[]{98, 2419}, null);
        CodeGenerator_x86simd.rulev[2617] = new Rule(2617, false, true, 2424, "2617: _2381 -> (SET I16 _57 _2380)", null, null, null, 0L, false, false, new int[]{100, 2423}, null);
        CodeGenerator_x86simd.rulev[2621] = new Rule(2621, false, true, 2428, "2621: _2385 -> (SET I16 _59 _2384)", null, null, null, 0L, false, false, new int[]{102, 2427}, null);
        CodeGenerator_x86simd.rulev[2625] = new Rule(2625, false, true, 2432, "2625: _2389 -> (SET I16 _61 _2388)", null, null, null, 0L, false, false, new int[]{104, 2431}, null);
        CodeGenerator_x86simd.rulev[2629] = new Rule(2629, false, true, 2436, "2629: _2393 -> (SET I16 _63 _2392)", null, null, null, 0L, false, false, new int[]{106, 2435}, null);
    }

    private static void rrinit3600() {
        CodeGenerator_x86simd.rulev[2708] = new Rule(2708, false, true, 2512, "2708: _2469 -> (SET I16 _117 _2468)", null, null, null, 0L, false, false, new int[]{160, 2511}, null);
        CodeGenerator_x86simd.rulev[2712] = new Rule(2712, false, true, 2516, "2712: _2473 -> (SET I16 _119 _2472)", null, null, null, 0L, false, false, new int[]{162, 2515}, null);
        CodeGenerator_x86simd.rulev[2716] = new Rule(2716, false, true, 2520, "2716: _2477 -> (SET I16 _121 _2476)", null, null, null, 0L, false, false, new int[]{164, 2519}, null);
        CodeGenerator_x86simd.rulev[2720] = new Rule(2720, false, true, 2524, "2720: _2481 -> (SET I16 _123 _2480)", null, null, null, 0L, false, false, new int[]{166, 2523}, null);
        CodeGenerator_x86simd.rulev[2835] = new Rule(2835, false, true, 2636, "2835: _2593 -> (SET I16 _49 _2592)", null, null, null, 0L, false, false, new int[]{92, 2635}, null);
        CodeGenerator_x86simd.rulev[2839] = new Rule(2839, false, true, 2640, "2839: _2597 -> (SET I16 _51 _2596)", null, null, null, 0L, false, false, new int[]{94, 2639}, null);
        CodeGenerator_x86simd.rulev[2843] = new Rule(2843, false, true, 2644, "2843: _2601 -> (SET I16 _53 _2600)", null, null, null, 0L, false, false, new int[]{96, 2643}, null);
        CodeGenerator_x86simd.rulev[2847] = new Rule(2847, false, true, 2648, "2847: _2605 -> (SET I16 _55 _2604)", null, null, null, 0L, false, false, new int[]{98, 2647}, null);
        CodeGenerator_x86simd.rulev[2851] = new Rule(2851, false, true, 2652, "2851: _2609 -> (SET I16 _57 _2608)", null, null, null, 0L, false, false, new int[]{100, 2651}, null);
        CodeGenerator_x86simd.rulev[2855] = new Rule(2855, false, true, 2656, "2855: _2613 -> (SET I16 _59 _2612)", null, null, null, 0L, false, false, new int[]{102, 2655}, null);
        CodeGenerator_x86simd.rulev[2859] = new Rule(2859, false, true, 2660, "2859: _2617 -> (SET I16 _61 _2616)", null, null, null, 0L, false, false, new int[]{104, 2659}, null);
        CodeGenerator_x86simd.rulev[2863] = new Rule(2863, false, true, 2664, "2863: _2621 -> (SET I16 _63 _2620)", null, null, null, 0L, false, false, new int[]{106, 2663}, null);
        CodeGenerator_x86simd.rulev[2891] = new Rule(2891, false, true, 2690, "2891: _2647 -> (SET I16 _117 _2646)", null, null, null, 0L, false, false, new int[]{160, 2689}, null);
        CodeGenerator_x86simd.rulev[2893] = new Rule(2893, false, true, 2692, "2893: _2649 -> (SET I16 _119 _2648)", null, null, null, 0L, false, false, new int[]{162, 2691}, null);
        CodeGenerator_x86simd.rulev[2895] = new Rule(2895, false, true, 2694, "2895: _2651 -> (SET I16 _121 _2650)", null, null, null, 0L, false, false, new int[]{164, 2693}, null);
        CodeGenerator_x86simd.rulev[2897] = new Rule(2897, false, true, 2696, "2897: _2653 -> (SET I16 _123 _2652)", null, null, null, 0L, false, false, new int[]{166, 2695}, null);
        CodeGenerator_x86simd.rulev[2900] = new Rule(2900, false, true, 2698, "2900: _2655 -> (SET I16 _49 _2654)", null, null, null, 0L, false, false, new int[]{92, 2697}, null);
        CodeGenerator_x86simd.rulev[2902] = new Rule(2902, false, true, 2700, "2902: _2657 -> (SET I16 _51 _2656)", null, null, null, 0L, false, false, new int[]{94, 2699}, null);
        CodeGenerator_x86simd.rulev[2904] = new Rule(2904, false, true, 2702, "2904: _2659 -> (SET I16 _53 _2658)", null, null, null, 0L, false, false, new int[]{96, 2701}, null);
        CodeGenerator_x86simd.rulev[2906] = new Rule(2906, false, true, 2704, "2906: _2661 -> (SET I16 _55 _2660)", null, null, null, 0L, false, false, new int[]{98, 2703}, null);
        CodeGenerator_x86simd.rulev[2908] = new Rule(2908, false, true, 2706, "2908: _2663 -> (SET I16 _57 _2662)", null, null, null, 0L, false, false, new int[]{100, 2705}, null);
        CodeGenerator_x86simd.rulev[2910] = new Rule(2910, false, true, 2708, "2910: _2665 -> (SET I16 _59 _2664)", null, null, null, 0L, false, false, new int[]{102, 2707}, null);
        CodeGenerator_x86simd.rulev[2912] = new Rule(2912, false, true, 2710, "2912: _2667 -> (SET I16 _61 _2666)", null, null, null, 0L, false, false, new int[]{104, 2709}, null);
        CodeGenerator_x86simd.rulev[2914] = new Rule(2914, false, true, 2712, "2914: _2669 -> (SET I16 _63 _2668)", null, null, null, 0L, false, false, new int[]{106, 2711}, null);
        CodeGenerator_x86simd.rulev[2931] = new Rule(2931, false, true, 2726, "2931: _2683 -> (SET I16 _117 _2682)", null, null, null, 0L, false, false, new int[]{160, 2725}, null);
        CodeGenerator_x86simd.rulev[2933] = new Rule(2933, false, true, 2728, "2933: _2685 -> (SET I16 _119 _2684)", null, null, null, 0L, false, false, new int[]{162, 2727}, null);
        CodeGenerator_x86simd.rulev[2935] = new Rule(2935, false, true, 2730, "2935: _2687 -> (SET I16 _121 _2686)", null, null, null, 0L, false, false, new int[]{164, 2729}, null);
        CodeGenerator_x86simd.rulev[2937] = new Rule(2937, false, true, 2732, "2937: _2689 -> (SET I16 _123 _2688)", null, null, null, 0L, false, false, new int[]{166, 2731}, null);
        CodeGenerator_x86simd.rulev[2940] = new Rule(2940, false, true, 2734, "2940: _2691 -> (SET I16 _49 _2690)", null, null, null, 0L, false, false, new int[]{92, 2733}, null);
        CodeGenerator_x86simd.rulev[2942] = new Rule(2942, false, true, 2736, "2942: _2693 -> (SET I16 _51 _2692)", null, null, null, 0L, false, false, new int[]{94, 2735}, null);
        CodeGenerator_x86simd.rulev[2944] = new Rule(2944, false, true, 2738, "2944: _2695 -> (SET I16 _53 _2694)", null, null, null, 0L, false, false, new int[]{96, 2737}, null);
        CodeGenerator_x86simd.rulev[2946] = new Rule(2946, false, true, 2740, "2946: _2697 -> (SET I16 _55 _2696)", null, null, null, 0L, false, false, new int[]{98, 2739}, null);
        CodeGenerator_x86simd.rulev[2948] = new Rule(2948, false, true, 2742, "2948: _2699 -> (SET I16 _57 _2698)", null, null, null, 0L, false, false, new int[]{100, 2741}, null);
        CodeGenerator_x86simd.rulev[2950] = new Rule(2950, false, true, 2744, "2950: _2701 -> (SET I16 _59 _2700)", null, null, null, 0L, false, false, new int[]{102, 2743}, null);
        CodeGenerator_x86simd.rulev[2952] = new Rule(2952, false, true, 2746, "2952: _2703 -> (SET I16 _61 _2702)", null, null, null, 0L, false, false, new int[]{104, 2745}, null);
        CodeGenerator_x86simd.rulev[2954] = new Rule(2954, false, true, 2748, "2954: _2705 -> (SET I16 _63 _2704)", null, null, null, 0L, false, false, new int[]{106, 2747}, null);
        CodeGenerator_x86simd.rulev[2971] = new Rule(2971, false, true, 2762, "2971: _2719 -> (SET I16 _117 _2718)", null, null, null, 0L, false, false, new int[]{160, 2761}, null);
        CodeGenerator_x86simd.rulev[2973] = new Rule(2973, false, true, 2764, "2973: _2721 -> (SET I16 _119 _2720)", null, null, null, 0L, false, false, new int[]{162, 2763}, null);
        CodeGenerator_x86simd.rulev[2975] = new Rule(2975, false, true, 2766, "2975: _2723 -> (SET I16 _121 _2722)", null, null, null, 0L, false, false, new int[]{164, 2765}, null);
        CodeGenerator_x86simd.rulev[2977] = new Rule(2977, false, true, 2768, "2977: _2725 -> (SET I16 _123 _2724)", null, null, null, 0L, false, false, new int[]{166, 2767}, null);
        CodeGenerator_x86simd.rulev[2980] = new Rule(2980, false, true, 2770, "2980: _2727 -> (SET I16 _49 _2726)", null, null, null, 0L, false, false, new int[]{92, 2769}, null);
        CodeGenerator_x86simd.rulev[2982] = new Rule(2982, false, true, 2772, "2982: _2729 -> (SET I16 _51 _2728)", null, null, null, 0L, false, false, new int[]{94, 2771}, null);
        CodeGenerator_x86simd.rulev[2984] = new Rule(2984, false, true, 2774, "2984: _2731 -> (SET I16 _53 _2730)", null, null, null, 0L, false, false, new int[]{96, 2773}, null);
        CodeGenerator_x86simd.rulev[2986] = new Rule(2986, false, true, 2776, "2986: _2733 -> (SET I16 _55 _2732)", null, null, null, 0L, false, false, new int[]{98, 2775}, null);
        CodeGenerator_x86simd.rulev[2988] = new Rule(2988, false, true, 2778, "2988: _2735 -> (SET I16 _57 _2734)", null, null, null, 0L, false, false, new int[]{100, 2777}, null);
        CodeGenerator_x86simd.rulev[2990] = new Rule(2990, false, true, 2780, "2990: _2737 -> (SET I16 _59 _2736)", null, null, null, 0L, false, false, new int[]{102, 2779}, null);
        CodeGenerator_x86simd.rulev[2992] = new Rule(2992, false, true, 2782, "2992: _2739 -> (SET I16 _61 _2738)", null, null, null, 0L, false, false, new int[]{104, 2781}, null);
        CodeGenerator_x86simd.rulev[2994] = new Rule(2994, false, true, 2784, "2994: _2741 -> (SET I16 _63 _2740)", null, null, null, 0L, false, false, new int[]{106, 2783}, null);
        CodeGenerator_x86simd.rulev[3011] = new Rule(3011, false, true, 2798, "3011: _2755 -> (SET I16 _117 _2754)", null, null, null, 0L, false, false, new int[]{160, 2797}, null);
        CodeGenerator_x86simd.rulev[3013] = new Rule(3013, false, true, 2800, "3013: _2757 -> (SET I16 _119 _2756)", null, null, null, 0L, false, false, new int[]{162, 2799}, null);
        CodeGenerator_x86simd.rulev[3015] = new Rule(3015, false, true, 2802, "3015: _2759 -> (SET I16 _121 _2758)", null, null, null, 0L, false, false, new int[]{164, 2801}, null);
        CodeGenerator_x86simd.rulev[3017] = new Rule(3017, false, true, 2804, "3017: _2761 -> (SET I16 _123 _2760)", null, null, null, 0L, false, false, new int[]{166, 2803}, null);
        CodeGenerator_x86simd.rulev[3020] = new Rule(3020, false, true, 2806, "3020: _2763 -> (SET I16 _49 _2762)", null, null, null, 0L, false, false, new int[]{92, 2805}, null);
        CodeGenerator_x86simd.rulev[3022] = new Rule(3022, false, true, 2808, "3022: _2765 -> (SET I16 _51 _2764)", null, null, null, 0L, false, false, new int[]{94, 2807}, null);
        CodeGenerator_x86simd.rulev[3024] = new Rule(3024, false, true, 2810, "3024: _2767 -> (SET I16 _53 _2766)", null, null, null, 0L, false, false, new int[]{96, 2809}, null);
        CodeGenerator_x86simd.rulev[3026] = new Rule(3026, false, true, 2812, "3026: _2769 -> (SET I16 _55 _2768)", null, null, null, 0L, false, false, new int[]{98, 2811}, null);
        CodeGenerator_x86simd.rulev[3028] = new Rule(3028, false, true, 2814, "3028: _2771 -> (SET I16 _57 _2770)", null, null, null, 0L, false, false, new int[]{100, 2813}, null);
        CodeGenerator_x86simd.rulev[3030] = new Rule(3030, false, true, 2816, "3030: _2773 -> (SET I16 _59 _2772)", null, null, null, 0L, false, false, new int[]{102, 2815}, null);
        CodeGenerator_x86simd.rulev[3032] = new Rule(3032, false, true, 2818, "3032: _2775 -> (SET I16 _61 _2774)", null, null, null, 0L, false, false, new int[]{104, 2817}, null);
        CodeGenerator_x86simd.rulev[3034] = new Rule(3034, false, true, 2820, "3034: _2777 -> (SET I16 _63 _2776)", null, null, null, 0L, false, false, new int[]{106, 2819}, null);
        CodeGenerator_x86simd.rulev[3051] = new Rule(3051, false, true, 2834, "3051: _2791 -> (SET I16 _117 _2790)", null, null, null, 0L, false, false, new int[]{160, 2833}, null);
        CodeGenerator_x86simd.rulev[3053] = new Rule(3053, false, true, 2836, "3053: _2793 -> (SET I16 _119 _2792)", null, null, null, 0L, false, false, new int[]{162, 2835}, null);
        CodeGenerator_x86simd.rulev[3055] = new Rule(3055, false, true, 2838, "3055: _2795 -> (SET I16 _121 _2794)", null, null, null, 0L, false, false, new int[]{164, 2837}, null);
        CodeGenerator_x86simd.rulev[3057] = new Rule(3057, false, true, 2840, "3057: _2797 -> (SET I16 _123 _2796)", null, null, null, 0L, false, false, new int[]{166, 2839}, null);
        CodeGenerator_x86simd.rulev[3060] = new Rule(3060, false, true, 2842, "3060: _2799 -> (SET I16 _49 _2798)", null, null, null, 0L, false, false, new int[]{92, 2841}, null);
        CodeGenerator_x86simd.rulev[3062] = new Rule(3062, false, true, 2844, "3062: _2801 -> (SET I16 _51 _2800)", null, null, null, 0L, false, false, new int[]{94, 2843}, null);
        CodeGenerator_x86simd.rulev[3064] = new Rule(3064, false, true, 2846, "3064: _2803 -> (SET I16 _53 _2802)", null, null, null, 0L, false, false, new int[]{96, 2845}, null);
        CodeGenerator_x86simd.rulev[3066] = new Rule(3066, false, true, 2848, "3066: _2805 -> (SET I16 _55 _2804)", null, null, null, 0L, false, false, new int[]{98, 2847}, null);
        CodeGenerator_x86simd.rulev[3068] = new Rule(3068, false, true, 2850, "3068: _2807 -> (SET I16 _57 _2806)", null, null, null, 0L, false, false, new int[]{100, 2849}, null);
        CodeGenerator_x86simd.rulev[3070] = new Rule(3070, false, true, 2852, "3070: _2809 -> (SET I16 _59 _2808)", null, null, null, 0L, false, false, new int[]{102, 2851}, null);
        CodeGenerator_x86simd.rulev[3072] = new Rule(3072, false, true, 2854, "3072: _2811 -> (SET I16 _61 _2810)", null, null, null, 0L, false, false, new int[]{104, 2853}, null);
        CodeGenerator_x86simd.rulev[3074] = new Rule(3074, false, true, 2856, "3074: _2813 -> (SET I16 _63 _2812)", null, null, null, 0L, false, false, new int[]{106, 2855}, null);
        CodeGenerator_x86simd.rulev[3091] = new Rule(3091, false, true, 2870, "3091: _2827 -> (SET I16 _117 _2826)", null, null, null, 0L, false, false, new int[]{160, 2869}, null);
        CodeGenerator_x86simd.rulev[3093] = new Rule(3093, false, true, 2872, "3093: _2829 -> (SET I16 _119 _2828)", null, null, null, 0L, false, false, new int[]{162, 2871}, null);
        CodeGenerator_x86simd.rulev[3095] = new Rule(3095, false, true, 2874, "3095: _2831 -> (SET I16 _121 _2830)", null, null, null, 0L, false, false, new int[]{164, 2873}, null);
        CodeGenerator_x86simd.rulev[3097] = new Rule(3097, false, true, 2876, "3097: _2833 -> (SET I16 _123 _2832)", null, null, null, 0L, false, false, new int[]{166, 2875}, null);
        CodeGenerator_x86simd.rulev[3100] = new Rule(3100, false, true, 2878, "3100: _2835 -> (SET I16 _49 _2834)", null, null, null, 0L, false, false, new int[]{92, 2877}, null);
        CodeGenerator_x86simd.rulev[3102] = new Rule(3102, false, true, 2880, "3102: _2837 -> (SET I16 _51 _2836)", null, null, null, 0L, false, false, new int[]{94, 2879}, null);
        CodeGenerator_x86simd.rulev[3104] = new Rule(3104, false, true, 2882, "3104: _2839 -> (SET I16 _53 _2838)", null, null, null, 0L, false, false, new int[]{96, 2881}, null);
        CodeGenerator_x86simd.rulev[3106] = new Rule(3106, false, true, 2884, "3106: _2841 -> (SET I16 _55 _2840)", null, null, null, 0L, false, false, new int[]{98, 2883}, null);
        CodeGenerator_x86simd.rulev[3108] = new Rule(3108, false, true, 2886, "3108: _2843 -> (SET I16 _57 _2842)", null, null, null, 0L, false, false, new int[]{100, 2885}, null);
        CodeGenerator_x86simd.rulev[3110] = new Rule(3110, false, true, 2888, "3110: _2845 -> (SET I16 _59 _2844)", null, null, null, 0L, false, false, new int[]{102, 2887}, null);
        CodeGenerator_x86simd.rulev[3112] = new Rule(3112, false, true, 2890, "3112: _2847 -> (SET I16 _61 _2846)", null, null, null, 0L, false, false, new int[]{104, 2889}, null);
        CodeGenerator_x86simd.rulev[3114] = new Rule(3114, false, true, 2892, "3114: _2849 -> (SET I16 _63 _2848)", null, null, null, 0L, false, false, new int[]{106, 2891}, null);
        CodeGenerator_x86simd.rulev[3154] = new Rule(3154, false, true, 2928, "3154: _2885 -> (SET I16 _117 _2884)", null, null, null, 0L, false, false, new int[]{160, 2927}, null);
        CodeGenerator_x86simd.rulev[3157] = new Rule(3157, false, true, 2931, "3157: _2888 -> (SET I16 _119 _2887)", null, null, null, 0L, false, false, new int[]{162, 2930}, null);
        CodeGenerator_x86simd.rulev[3160] = new Rule(3160, false, true, 2934, "3160: _2891 -> (SET I16 _121 _2890)", null, null, null, 0L, false, false, new int[]{164, 2933}, null);
        CodeGenerator_x86simd.rulev[3163] = new Rule(3163, false, true, 2937, "3163: _2894 -> (SET I16 _123 _2893)", null, null, null, 0L, false, false, new int[]{166, 2936}, null);
        CodeGenerator_x86simd.rulev[3223] = new Rule(3223, false, true, 2994, "3223: _2951 -> (SET I16 _49 _2950)", null, null, null, 0L, false, false, new int[]{92, 2993}, null);
        CodeGenerator_x86simd.rulev[3226] = new Rule(3226, false, true, 2997, "3226: _2954 -> (SET I16 _51 _2953)", null, null, null, 0L, false, false, new int[]{94, 2996}, null);
        CodeGenerator_x86simd.rulev[3229] = new Rule(3229, false, true, 3000, "3229: _2957 -> (SET I16 _53 _2956)", null, null, null, 0L, false, false, new int[]{96, 2999}, null);
        CodeGenerator_x86simd.rulev[3232] = new Rule(3232, false, true, 3003, "3232: _2960 -> (SET I16 _55 _2959)", null, null, null, 0L, false, false, new int[]{98, 3002}, null);
        CodeGenerator_x86simd.rulev[3235] = new Rule(3235, false, true, 3006, "3235: _2963 -> (SET I16 _57 _2962)", null, null, null, 0L, false, false, new int[]{100, 3005}, null);
        CodeGenerator_x86simd.rulev[3238] = new Rule(3238, false, true, 3009, "3238: _2966 -> (SET I16 _59 _2965)", null, null, null, 0L, false, false, new int[]{102, 3008}, null);
        CodeGenerator_x86simd.rulev[3241] = new Rule(3241, false, true, 3012, "3241: _2969 -> (SET I16 _61 _2968)", null, null, null, 0L, false, false, new int[]{104, 3011}, null);
        CodeGenerator_x86simd.rulev[3244] = new Rule(3244, false, true, 3015, "3244: _2972 -> (SET I16 _63 _2971)", null, null, null, 0L, false, false, new int[]{106, 3014}, null);
        CodeGenerator_x86simd.rulev[3320] = new Rule(3320, false, true, 3084, "3320: _3041 -> (SET I16 _117 _677)", null, null, null, 0L, false, false, new int[]{160, 720}, null);
        CodeGenerator_x86simd.rulev[3321] = new Rule(3321, false, true, 3085, "3321: _3042 -> (SET I16 _119 _682)", null, null, null, 0L, false, false, new int[]{162, 725}, null);
        CodeGenerator_x86simd.rulev[3322] = new Rule(3322, false, true, 3086, "3322: _3043 -> (SET I16 _121 _686)", null, null, null, 0L, false, false, new int[]{164, 729}, null);
        CodeGenerator_x86simd.rulev[3323] = new Rule(3323, false, true, 3087, "3323: _3044 -> (SET I16 _123 _690)", null, null, null, 0L, false, false, new int[]{166, 733}, null);
    }

    private static void rrinit3700() {
        CodeGenerator_x86simd.rulev[3326] = new Rule(3326, false, true, 3089, "3326: _3046 -> (SET I16 _117 _3045)", null, null, null, 0L, false, false, new int[]{160, 3088}, null);
        CodeGenerator_x86simd.rulev[3328] = new Rule(3328, false, true, 3091, "3328: _3048 -> (SET I16 _119 _3047)", null, null, null, 0L, false, false, new int[]{162, 3090}, null);
        CodeGenerator_x86simd.rulev[3330] = new Rule(3330, false, true, 3093, "3330: _3050 -> (SET I16 _121 _3049)", null, null, null, 0L, false, false, new int[]{164, 3092}, null);
        CodeGenerator_x86simd.rulev[3332] = new Rule(3332, false, true, 3095, "3332: _3052 -> (SET I16 _123 _3051)", null, null, null, 0L, false, false, new int[]{166, 3094}, null);
        CodeGenerator_x86simd.rulev[3335] = new Rule(3335, false, true, 3097, "3335: _3054 -> (SET I16 _117 _3053)", null, null, null, 0L, false, false, new int[]{160, 3096}, null);
        CodeGenerator_x86simd.rulev[3337] = new Rule(3337, false, true, 3099, "3337: _3056 -> (SET I16 _119 _3055)", null, null, null, 0L, false, false, new int[]{162, 3098}, null);
        CodeGenerator_x86simd.rulev[3339] = new Rule(3339, false, true, 3101, "3339: _3058 -> (SET I16 _121 _3057)", null, null, null, 0L, false, false, new int[]{164, 3100}, null);
        CodeGenerator_x86simd.rulev[3341] = new Rule(3341, false, true, 3103, "3341: _3060 -> (SET I16 _123 _3059)", null, null, null, 0L, false, false, new int[]{166, 3102}, null);
        CodeGenerator_x86simd.rulev[3344] = new Rule(3344, false, true, 3105, "3344: _3062 -> (SET I16 _117 _3061)", null, null, null, 0L, false, false, new int[]{160, 3104}, null);
        CodeGenerator_x86simd.rulev[3346] = new Rule(3346, false, true, 3107, "3346: _3064 -> (SET I16 _119 _3063)", null, null, null, 0L, false, false, new int[]{162, 3106}, null);
        CodeGenerator_x86simd.rulev[3348] = new Rule(3348, false, true, 3109, "3348: _3066 -> (SET I16 _121 _3065)", null, null, null, 0L, false, false, new int[]{164, 3108}, null);
        CodeGenerator_x86simd.rulev[3350] = new Rule(3350, false, true, 3111, "3350: _3068 -> (SET I16 _123 _3067)", null, null, null, 0L, false, false, new int[]{166, 3110}, null);
        CodeGenerator_x86simd.rulev[3352] = new Rule(3352, false, true, 3112, "3352: _3069 -> (SET I16 _117 _696)", null, null, null, 0L, false, false, new int[]{160, 739}, null);
        CodeGenerator_x86simd.rulev[3353] = new Rule(3353, false, true, 3113, "3353: _3070 -> (SET I16 _119 _702)", null, null, null, 0L, false, false, new int[]{162, 745}, null);
        CodeGenerator_x86simd.rulev[3354] = new Rule(3354, false, true, 3114, "3354: _3071 -> (SET I16 _121 _708)", null, null, null, 0L, false, false, new int[]{164, 751}, null);
        CodeGenerator_x86simd.rulev[3355] = new Rule(3355, false, true, 3115, "3355: _3072 -> (SET I16 _123 _714)", null, null, null, 0L, false, false, new int[]{166, 757}, null);
        CodeGenerator_x86simd.rulev[3358] = new Rule(3358, false, true, 3117, "3358: _3074 -> (SET I16 _117 _3073)", null, null, null, 0L, false, false, new int[]{160, 3116}, null);
        CodeGenerator_x86simd.rulev[3360] = new Rule(3360, false, true, 3119, "3360: _3076 -> (SET I16 _119 _3075)", null, null, null, 0L, false, false, new int[]{162, 3118}, null);
        CodeGenerator_x86simd.rulev[3362] = new Rule(3362, false, true, 3121, "3362: _3078 -> (SET I16 _121 _3077)", null, null, null, 0L, false, false, new int[]{164, 3120}, null);
        CodeGenerator_x86simd.rulev[3364] = new Rule(3364, false, true, 3123, "3364: _3080 -> (SET I16 _123 _3079)", null, null, null, 0L, false, false, new int[]{166, 3122}, null);
        CodeGenerator_x86simd.rulev[3508] = new Rule(3508, false, true, 3256, "3508: _3213 -> (SET I16 _49 _718)", null, null, null, 0L, false, false, new int[]{92, 761}, null);
        CodeGenerator_x86simd.rulev[3509] = new Rule(3509, false, true, 3257, "3509: _3214 -> (SET I16 _51 _722)", null, null, null, 0L, false, false, new int[]{94, 765}, null);
        CodeGenerator_x86simd.rulev[3510] = new Rule(3510, false, true, 3258, "3510: _3215 -> (SET I16 _53 _726)", null, null, null, 0L, false, false, new int[]{96, 769}, null);
        CodeGenerator_x86simd.rulev[3511] = new Rule(3511, false, true, 3259, "3511: _3216 -> (SET I16 _55 _730)", null, null, null, 0L, false, false, new int[]{98, 773}, null);
        CodeGenerator_x86simd.rulev[3512] = new Rule(3512, false, true, 3260, "3512: _3217 -> (SET I16 _57 _734)", null, null, null, 0L, false, false, new int[]{100, 777}, null);
        CodeGenerator_x86simd.rulev[3513] = new Rule(3513, false, true, 3261, "3513: _3218 -> (SET I16 _59 _738)", null, null, null, 0L, false, false, new int[]{102, 781}, null);
        CodeGenerator_x86simd.rulev[3514] = new Rule(3514, false, true, 3262, "3514: _3219 -> (SET I16 _61 _742)", null, null, null, 0L, false, false, new int[]{104, 785}, null);
        CodeGenerator_x86simd.rulev[3515] = new Rule(3515, false, true, 3263, "3515: _3220 -> (SET I16 _63 _746)", null, null, null, 0L, false, false, new int[]{106, 789}, null);
        CodeGenerator_x86simd.rulev[3518] = new Rule(3518, false, true, 3265, "3518: _3222 -> (SET I16 _49 _3221)", null, null, null, 0L, false, false, new int[]{92, 3264}, null);
        CodeGenerator_x86simd.rulev[3520] = new Rule(3520, false, true, 3267, "3520: _3224 -> (SET I16 _51 _3223)", null, null, null, 0L, false, false, new int[]{94, 3266}, null);
        CodeGenerator_x86simd.rulev[3522] = new Rule(3522, false, true, 3269, "3522: _3226 -> (SET I16 _53 _3225)", null, null, null, 0L, false, false, new int[]{96, 3268}, null);
        CodeGenerator_x86simd.rulev[3524] = new Rule(3524, false, true, 3271, "3524: _3228 -> (SET I16 _55 _3227)", null, null, null, 0L, false, false, new int[]{98, 3270}, null);
        CodeGenerator_x86simd.rulev[3526] = new Rule(3526, false, true, 3273, "3526: _3230 -> (SET I16 _57 _3229)", null, null, null, 0L, false, false, new int[]{100, 3272}, null);
        CodeGenerator_x86simd.rulev[3528] = new Rule(3528, false, true, 3275, "3528: _3232 -> (SET I16 _59 _3231)", null, null, null, 0L, false, false, new int[]{102, 3274}, null);
        CodeGenerator_x86simd.rulev[3530] = new Rule(3530, false, true, 3277, "3530: _3234 -> (SET I16 _61 _3233)", null, null, null, 0L, false, false, new int[]{104, 3276}, null);
        CodeGenerator_x86simd.rulev[3532] = new Rule(3532, false, true, 3279, "3532: _3236 -> (SET I16 _63 _3235)", null, null, null, 0L, false, false, new int[]{106, 3278}, null);
        CodeGenerator_x86simd.rulev[3535] = new Rule(3535, false, true, 3281, "3535: _3238 -> (SET I16 _49 _3237)", null, null, null, 0L, false, false, new int[]{92, 3280}, null);
        CodeGenerator_x86simd.rulev[3537] = new Rule(3537, false, true, 3283, "3537: _3240 -> (SET I16 _51 _3239)", null, null, null, 0L, false, false, new int[]{94, 3282}, null);
        CodeGenerator_x86simd.rulev[3539] = new Rule(3539, false, true, 3285, "3539: _3242 -> (SET I16 _53 _3241)", null, null, null, 0L, false, false, new int[]{96, 3284}, null);
        CodeGenerator_x86simd.rulev[3541] = new Rule(3541, false, true, 3287, "3541: _3244 -> (SET I16 _55 _3243)", null, null, null, 0L, false, false, new int[]{98, 3286}, null);
        CodeGenerator_x86simd.rulev[3543] = new Rule(3543, false, true, 3289, "3543: _3246 -> (SET I16 _57 _3245)", null, null, null, 0L, false, false, new int[]{100, 3288}, null);
        CodeGenerator_x86simd.rulev[3545] = new Rule(3545, false, true, 3291, "3545: _3248 -> (SET I16 _59 _3247)", null, null, null, 0L, false, false, new int[]{102, 3290}, null);
        CodeGenerator_x86simd.rulev[3547] = new Rule(3547, false, true, 3293, "3547: _3250 -> (SET I16 _61 _3249)", null, null, null, 0L, false, false, new int[]{104, 3292}, null);
        CodeGenerator_x86simd.rulev[3549] = new Rule(3549, false, true, 3295, "3549: _3252 -> (SET I16 _63 _3251)", null, null, null, 0L, false, false, new int[]{106, 3294}, null);
        CodeGenerator_x86simd.rulev[3552] = new Rule(3552, false, true, 3297, "3552: _3254 -> (SET I16 _49 _3253)", null, null, null, 0L, false, false, new int[]{92, 3296}, null);
        CodeGenerator_x86simd.rulev[3554] = new Rule(3554, false, true, 3299, "3554: _3256 -> (SET I16 _51 _3255)", null, null, null, 0L, false, false, new int[]{94, 3298}, null);
        CodeGenerator_x86simd.rulev[3556] = new Rule(3556, false, true, 3301, "3556: _3258 -> (SET I16 _53 _3257)", null, null, null, 0L, false, false, new int[]{96, 3300}, null);
        CodeGenerator_x86simd.rulev[3558] = new Rule(3558, false, true, 3303, "3558: _3260 -> (SET I16 _55 _3259)", null, null, null, 0L, false, false, new int[]{98, 3302}, null);
        CodeGenerator_x86simd.rulev[3560] = new Rule(3560, false, true, 3305, "3560: _3262 -> (SET I16 _57 _3261)", null, null, null, 0L, false, false, new int[]{100, 3304}, null);
        CodeGenerator_x86simd.rulev[3562] = new Rule(3562, false, true, 3307, "3562: _3264 -> (SET I16 _59 _3263)", null, null, null, 0L, false, false, new int[]{102, 3306}, null);
        CodeGenerator_x86simd.rulev[3564] = new Rule(3564, false, true, 3309, "3564: _3266 -> (SET I16 _61 _3265)", null, null, null, 0L, false, false, new int[]{104, 3308}, null);
        CodeGenerator_x86simd.rulev[3566] = new Rule(3566, false, true, 3311, "3566: _3268 -> (SET I16 _63 _3267)", null, null, null, 0L, false, false, new int[]{106, 3310}, null);
        CodeGenerator_x86simd.rulev[3568] = new Rule(3568, false, true, 3312, "3568: _3269 -> (SET I16 _49 _752)", null, null, null, 0L, false, false, new int[]{92, 795}, null);
        CodeGenerator_x86simd.rulev[3569] = new Rule(3569, false, true, 3313, "3569: _3270 -> (SET I16 _51 _758)", null, null, null, 0L, false, false, new int[]{94, 801}, null);
        CodeGenerator_x86simd.rulev[3570] = new Rule(3570, false, true, 3314, "3570: _3271 -> (SET I16 _53 _764)", null, null, null, 0L, false, false, new int[]{96, 807}, null);
        CodeGenerator_x86simd.rulev[3571] = new Rule(3571, false, true, 3315, "3571: _3272 -> (SET I16 _55 _770)", null, null, null, 0L, false, false, new int[]{98, 813}, null);
        CodeGenerator_x86simd.rulev[3572] = new Rule(3572, false, true, 3316, "3572: _3273 -> (SET I16 _57 _776)", null, null, null, 0L, false, false, new int[]{100, 819}, null);
        CodeGenerator_x86simd.rulev[3573] = new Rule(3573, false, true, 3317, "3573: _3274 -> (SET I16 _59 _782)", null, null, null, 0L, false, false, new int[]{102, 825}, null);
        CodeGenerator_x86simd.rulev[3574] = new Rule(3574, false, true, 3318, "3574: _3275 -> (SET I16 _61 _788)", null, null, null, 0L, false, false, new int[]{104, 831}, null);
        CodeGenerator_x86simd.rulev[3575] = new Rule(3575, false, true, 3319, "3575: _3276 -> (SET I16 _63 _794)", null, null, null, 0L, false, false, new int[]{106, 837}, null);
        CodeGenerator_x86simd.rulev[3578] = new Rule(3578, false, true, 3321, "3578: _3278 -> (SET I16 _49 _3277)", null, null, null, 0L, false, false, new int[]{92, 3320}, null);
        CodeGenerator_x86simd.rulev[3580] = new Rule(3580, false, true, 3323, "3580: _3280 -> (SET I16 _51 _3279)", null, null, null, 0L, false, false, new int[]{94, 3322}, null);
        CodeGenerator_x86simd.rulev[3582] = new Rule(3582, false, true, 3325, "3582: _3282 -> (SET I16 _53 _3281)", null, null, null, 0L, false, false, new int[]{96, 3324}, null);
        CodeGenerator_x86simd.rulev[3584] = new Rule(3584, false, true, 3327, "3584: _3284 -> (SET I16 _55 _3283)", null, null, null, 0L, false, false, new int[]{98, 3326}, null);
        CodeGenerator_x86simd.rulev[3586] = new Rule(3586, false, true, 3329, "3586: _3286 -> (SET I16 _57 _3285)", null, null, null, 0L, false, false, new int[]{100, 3328}, null);
        CodeGenerator_x86simd.rulev[3588] = new Rule(3588, false, true, 3331, "3588: _3288 -> (SET I16 _59 _3287)", null, null, null, 0L, false, false, new int[]{102, 3330}, null);
        CodeGenerator_x86simd.rulev[3590] = new Rule(3590, false, true, 3333, "3590: _3290 -> (SET I16 _61 _3289)", null, null, null, 0L, false, false, new int[]{104, 3332}, null);
        CodeGenerator_x86simd.rulev[3592] = new Rule(3592, false, true, 3335, "3592: _3292 -> (SET I16 _63 _3291)", null, null, null, 0L, false, false, new int[]{106, 3334}, null);
        CodeGenerator_x86simd.rulev[3690] = new Rule(3690, false, true, 3425, "3690: _3382 -> (SET I16 _117 _3381)", null, null, null, 0L, false, false, new int[]{160, 3424}, null);
        CodeGenerator_x86simd.rulev[3692] = new Rule(3692, false, true, 3427, "3692: _3384 -> (SET I16 _119 _3383)", null, null, null, 0L, false, false, new int[]{162, 3426}, null);
        CodeGenerator_x86simd.rulev[3694] = new Rule(3694, false, true, 3429, "3694: _3386 -> (SET I16 _121 _3385)", null, null, null, 0L, false, false, new int[]{164, 3428}, null);
        CodeGenerator_x86simd.rulev[3696] = new Rule(3696, false, true, 3431, "3696: _3388 -> (SET I16 _123 _3387)", null, null, null, 0L, false, false, new int[]{166, 3430}, null);
        CodeGenerator_x86simd.rulev[3699] = new Rule(3699, false, true, 3433, "3699: _3390 -> (SET I16 _49 _3389)", null, null, null, 0L, false, false, new int[]{92, 3432}, null);
        CodeGenerator_x86simd.rulev[3701] = new Rule(3701, false, true, 3435, "3701: _3392 -> (SET I16 _51 _3391)", null, null, null, 0L, false, false, new int[]{94, 3434}, null);
        CodeGenerator_x86simd.rulev[3703] = new Rule(3703, false, true, 3437, "3703: _3394 -> (SET I16 _53 _3393)", null, null, null, 0L, false, false, new int[]{96, 3436}, null);
        CodeGenerator_x86simd.rulev[3705] = new Rule(3705, false, true, 3439, "3705: _3396 -> (SET I16 _55 _3395)", null, null, null, 0L, false, false, new int[]{98, 3438}, null);
        CodeGenerator_x86simd.rulev[3707] = new Rule(3707, false, true, 3441, "3707: _3398 -> (SET I16 _57 _3397)", null, null, null, 0L, false, false, new int[]{100, 3440}, null);
        CodeGenerator_x86simd.rulev[3709] = new Rule(3709, false, true, 3443, "3709: _3400 -> (SET I16 _59 _3399)", null, null, null, 0L, false, false, new int[]{102, 3442}, null);
        CodeGenerator_x86simd.rulev[3711] = new Rule(3711, false, true, 3445, "3711: _3402 -> (SET I16 _61 _3401)", null, null, null, 0L, false, false, new int[]{104, 3444}, null);
        CodeGenerator_x86simd.rulev[3713] = new Rule(3713, false, true, 3447, "3713: _3404 -> (SET I16 _63 _3403)", null, null, null, 0L, false, false, new int[]{106, 3446}, null);
        CodeGenerator_x86simd.rulev[3756] = new Rule(3756, false, true, 3485, "3756: _3442 -> (SET I16 _117 _2883)", null, null, null, 0L, false, false, new int[]{160, 2926}, null);
        CodeGenerator_x86simd.rulev[3757] = new Rule(3757, false, true, 3486, "3757: _3443 -> (SET I16 _119 _2886)", null, null, null, 0L, false, false, new int[]{162, 2929}, null);
        CodeGenerator_x86simd.rulev[3758] = new Rule(3758, false, true, 3487, "3758: _3444 -> (SET I16 _121 _2889)", null, null, null, 0L, false, false, new int[]{164, 2932}, null);
        CodeGenerator_x86simd.rulev[3759] = new Rule(3759, false, true, 3488, "3759: _3445 -> (SET I16 _123 _2892)", null, null, null, 0L, false, false, new int[]{166, 2935}, null);
        CodeGenerator_x86simd.rulev[3761] = new Rule(3761, false, true, 3489, "3761: _3446 -> (SET I16 _49 _2949)", null, null, null, 0L, false, false, new int[]{92, 2992}, null);
        CodeGenerator_x86simd.rulev[3762] = new Rule(3762, false, true, 3490, "3762: _3447 -> (SET I16 _51 _2952)", null, null, null, 0L, false, false, new int[]{94, 2995}, null);
        CodeGenerator_x86simd.rulev[3763] = new Rule(3763, false, true, 3491, "3763: _3448 -> (SET I16 _53 _2955)", null, null, null, 0L, false, false, new int[]{96, 2998}, null);
        CodeGenerator_x86simd.rulev[3764] = new Rule(3764, false, true, 3492, "3764: _3449 -> (SET I16 _55 _2958)", null, null, null, 0L, false, false, new int[]{98, 3001}, null);
        CodeGenerator_x86simd.rulev[3765] = new Rule(3765, false, true, 3493, "3765: _3450 -> (SET I16 _57 _2961)", null, null, null, 0L, false, false, new int[]{100, 3004}, null);
        CodeGenerator_x86simd.rulev[3766] = new Rule(3766, false, true, 3494, "3766: _3451 -> (SET I16 _59 _2964)", null, null, null, 0L, false, false, new int[]{102, 3007}, null);
        CodeGenerator_x86simd.rulev[3767] = new Rule(3767, false, true, 3495, "3767: _3452 -> (SET I16 _61 _2967)", null, null, null, 0L, false, false, new int[]{104, 3010}, null);
        CodeGenerator_x86simd.rulev[3768] = new Rule(3768, false, true, 3496, "3768: _3453 -> (SET I16 _63 _2970)", null, null, null, 0L, false, false, new int[]{106, 3013}, null);
        CodeGenerator_x86simd.rulev[3941] = new Rule(3941, false, false, 10, "3941: void -> (SET I16 memw rcw)", ImList.list(ImList.list("movw", "$2", "$1")), null, null, 0L, false, false, new int[]{33, 38}, new String[]{null, null, null});
        CodeGenerator_x86simd.rulev[3945] = new Rule(3945, false, false, 10, "3945: void -> (SET I16 xregw regw)", ImList.list(ImList.list("movw", "$2", "$1")), null, null, 0L, false, false, new int[]{13, 6}, new String[]{null, null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[4134] = new Rule(4134, false, false, 10, "4134: void -> (SET I16 memw _3602)", ImList.list(ImList.list("cvtsd2si", "$2", "%eax"), ImList.list("movw", "%ax", "$1")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{33, 3648}, new String[]{null, null, "*reg-tmp-F64*"});
        CodeGenerator_x86simd.rulev[4141] = new Rule(4141, false, false, 10, "4141: void -> (SET I16 memw _3604)", ImList.list(ImList.list("cvtss2si", "$2", "%eax"), ImList.list("movw", "%ax", "$1")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{33, 3650}, new String[]{null, null, "*reg-tmp-F32*"});
        CodeGenerator_x86simd.rulev[150] = new Rule(150, false, true, 109, "150: _66 -> (SET I32 _65 meml)", null, null, null, 0L, false, false, new int[]{108, 32}, null);
        CodeGenerator_x86simd.rulev[152] = new Rule(152, false, true, 111, "152: _68 -> (SET I32 _67 meml)", null, null, null, 0L, false, false, new int[]{110, 32}, null);
        CodeGenerator_x86simd.rulev[154] = new Rule(154, false, true, 113, "154: _70 -> (SET I32 _69 meml)", null, null, null, 0L, false, false, new int[]{112, 32}, null);
        CodeGenerator_x86simd.rulev[156] = new Rule(156, false, true, 115, "156: _72 -> (SET I32 _71 meml)", null, null, null, 0L, false, false, new int[]{114, 32}, null);
    }

    private static void rrinit3800() {
        CodeGenerator_x86simd.rulev[184] = new Rule(184, false, true, 140, "184: _97 -> (SET I32 meml _65)", null, null, null, 0L, false, false, new int[]{32, 108}, null);
        CodeGenerator_x86simd.rulev[185] = new Rule(185, false, true, 141, "185: _98 -> (SET I32 meml _67)", null, null, null, 0L, false, false, new int[]{32, 110}, null);
        CodeGenerator_x86simd.rulev[186] = new Rule(186, false, true, 142, "186: _99 -> (SET I32 meml _69)", null, null, null, 0L, false, false, new int[]{32, 112}, null);
        CodeGenerator_x86simd.rulev[187] = new Rule(187, false, true, 143, "187: _100 -> (SET I32 meml _71)", null, null, null, 0L, false, false, new int[]{32, 114}, null);
        CodeGenerator_x86simd.rulev[216] = new Rule(216, false, true, 169, "216: _126 -> (SET I32 _125 meml)", null, null, null, 0L, false, false, new int[]{168, 32}, null);
        CodeGenerator_x86simd.rulev[218] = new Rule(218, false, true, 171, "218: _128 -> (SET I32 _127 meml)", null, null, null, 0L, false, false, new int[]{170, 32}, null);
        CodeGenerator_x86simd.rulev[234] = new Rule(234, false, true, 184, "234: _141 -> (SET I32 meml _125)", null, null, null, 0L, false, false, new int[]{32, 168}, null);
        CodeGenerator_x86simd.rulev[235] = new Rule(235, false, true, 185, "235: _142 -> (SET I32 meml _127)", null, null, null, 0L, false, false, new int[]{32, 170}, null);
        CodeGenerator_x86simd.rulev[261] = new Rule(261, false, false, 10, "261: void -> (SET I32 mregl _65)", ImList.list(ImList.list("movd", "$2", "$1")), null, null, 0L, false, false, new int[]{41, 108}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[262] = new Rule(262, false, false, 10, "262: void -> (SET I32 mregl _67)", ImList.list(ImList.list("pshufd", ImList.list("imm", "225"), "$2", "$2"), ImList.list("movd", "$2", "$1"), ImList.list("pshufd", ImList.list("imm", "225"), "$2", "$2")), null, null, 0L, false, false, new int[]{41, 110}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[263] = new Rule(263, false, false, 10, "263: void -> (SET I32 mregl _69)", ImList.list(ImList.list("pshufd", ImList.list("imm", "198"), "$2", "$2"), ImList.list("movd", "$2", "$1"), ImList.list("pshufd", ImList.list("imm", "198"), "$2", "$2")), null, null, 0L, false, false, new int[]{41, 112}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[264] = new Rule(264, false, false, 10, "264: void -> (SET I32 mregl _71)", ImList.list(ImList.list("pshufd", ImList.list("imm", "39"), "$2", "$2"), ImList.list("movd", "$2", "$1"), ImList.list("pshufd", ImList.list("imm", "39"), "$2", "$2")), null, null, 0L, false, false, new int[]{41, 114}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[340] = new Rule(340, false, true, 235, "340: _192 -> (SET I32 _191 regl)", null, null, null, 0L, false, false, new int[]{234, 4}, null);
        CodeGenerator_x86simd.rulev[342] = new Rule(342, false, true, 237, "342: _194 -> (SET I32 _193 regl)", null, null, null, 0L, false, false, new int[]{236, 4}, null);
        CodeGenerator_x86simd.rulev[344] = new Rule(344, false, true, 239, "344: _196 -> (SET I32 _195 regl)", null, null, null, 0L, false, false, new int[]{238, 4}, null);
        CodeGenerator_x86simd.rulev[346] = new Rule(346, false, true, 241, "346: _198 -> (SET I32 _197 regl)", null, null, null, 0L, false, false, new int[]{240, 4}, null);
        CodeGenerator_x86simd.rulev[348] = new Rule(348, false, false, 10, "348: void -> (SET I32 _191 regl)", ImList.list(ImList.list("pinsrw", ImList.list("imm", "0"), "$2", "$1"), ImList.list("rol", ImList.list("imm", "16"), "$2"), ImList.list("pinsrw", ImList.list("imm", "1"), "$2", "$1"), ImList.list("rol", ImList.list("imm", "16"), "$2")), null, null, 0L, false, false, new int[]{234, 4}, new String[]{null, null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[349] = new Rule(349, false, false, 10, "349: void -> (SET I32 _193 regl)", ImList.list(ImList.list("pinsrw", ImList.list("imm", "2"), "$2", "$1"), ImList.list("rol", ImList.list("imm", "16"), "$2"), ImList.list("pinsrw", ImList.list("imm", "3"), "$2", "$1"), ImList.list("rol", ImList.list("imm", "16"), "$2")), null, null, 0L, false, false, new int[]{236, 4}, new String[]{null, null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[350] = new Rule(350, false, false, 10, "350: void -> (SET I32 _195 regl)", ImList.list(ImList.list("pinsrw", ImList.list("imm", "4"), "$2", "$1"), ImList.list("rol", ImList.list("imm", "16"), "$2"), ImList.list("pinsrw", ImList.list("imm", "5"), "$2", "$1"), ImList.list("rol", ImList.list("imm", "16"), "$2")), null, null, 0L, false, false, new int[]{238, 4}, new String[]{null, null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[351] = new Rule(351, false, false, 10, "351: void -> (SET I32 _197 regl)", ImList.list(ImList.list("pinsrw", ImList.list("imm", "6"), "$2", "$1"), ImList.list("rol", ImList.list("imm", "16"), "$2"), ImList.list("pinsrw", ImList.list("imm", "7"), "$2", "$1"), ImList.list("rol", ImList.list("imm", "16"), "$2")), null, null, 0L, false, false, new int[]{240, 4}, new String[]{null, null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[364] = new Rule(364, false, false, 10, "364: void -> (SET I32 mregl _125)", ImList.list(ImList.list("movd", "$2", "$1")), null, null, 0L, false, false, new int[]{41, 168}, new String[]{null, null, "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[365] = new Rule(365, false, false, 10, "365: void -> (SET I32 mregl _127)", ImList.list(ImList.list("pshufw", ImList.list("imm", "78"), "$2", "$2"), ImList.list("movd", "$2", "$1"), ImList.list("pshufw", ImList.list("imm", "78"), "$2", "$2")), null, null, 0L, false, false, new int[]{41, 170}, new String[]{null, null, "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[405] = new Rule(405, false, true, 267, "405: _224 -> (SET I32 _223 regl)", null, null, null, 0L, false, false, new int[]{266, 4}, null);
        CodeGenerator_x86simd.rulev[407] = new Rule(407, false, true, 269, "407: _226 -> (SET I32 _225 regl)", null, null, null, 0L, false, false, new int[]{268, 4}, null);
        CodeGenerator_x86simd.rulev[409] = new Rule(409, false, false, 10, "409: void -> (SET I32 _223 regl)", ImList.list(ImList.list("pinsrw", ImList.list("imm", "0"), "$2", "$1"), ImList.list("rol", ImList.list("imm", "16"), "$2"), ImList.list("pinsrw", ImList.list("imm", "1"), "$2", "$1"), ImList.list("rol", ImList.list("imm", "16"), "$2")), null, null, 0L, false, false, new int[]{266, 4}, new String[]{null, null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[410] = new Rule(410, false, false, 10, "410: void -> (SET I32 _225 regl)", ImList.list(ImList.list("pinsrw", ImList.list("imm", "2"), "$2", "$1"), ImList.list("rol", ImList.list("imm", "16"), "$2"), ImList.list("pinsrw", ImList.list("imm", "3"), "$2", "$1"), ImList.list("rol", ImList.list("imm", "16"), "$2")), null, null, 0L, false, false, new int[]{268, 4}, new String[]{null, null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[425] = new Rule(425, false, true, 282, "425: _239 -> (SET I32 _223 con)", null, null, null, 0L, false, false, new int[]{266, 19}, null);
        CodeGenerator_x86simd.rulev[426] = new Rule(426, false, true, 283, "426: _240 -> (SET I32 _225 con)", null, null, null, 0L, false, false, new int[]{268, 19}, null);
        CodeGenerator_x86simd.rulev[454] = new Rule(454, false, true, 308, "454: _265 -> (SET I32 _191 con)", null, null, null, 0L, false, false, new int[]{234, 19}, null);
        CodeGenerator_x86simd.rulev[455] = new Rule(455, false, true, 309, "455: _266 -> (SET I32 _193 con)", null, null, null, 0L, false, false, new int[]{236, 19}, null);
        CodeGenerator_x86simd.rulev[456] = new Rule(456, false, true, 310, "456: _267 -> (SET I32 _195 con)", null, null, null, 0L, false, false, new int[]{238, 19}, null);
        CodeGenerator_x86simd.rulev[457] = new Rule(457, false, true, 311, "457: _268 -> (SET I32 _197 con)", null, null, null, 0L, false, false, new int[]{240, 19}, null);
        CodeGenerator_x86simd.rulev[1591] = new Rule(1591, false, true, 1422, "1591: _1379 -> (SET I32 _125 _1378)", null, null, null, 0L, false, false, new int[]{168, 1421}, null);
        CodeGenerator_x86simd.rulev[1597] = new Rule(1597, false, true, 1428, "1597: _1385 -> (SET I32 _127 _1384)", null, null, null, 0L, false, false, new int[]{170, 1427}, null);
        CodeGenerator_x86simd.rulev[1604] = new Rule(1604, false, true, 1434, "1604: _1391 -> (SET I32 _125 _1390)", null, null, null, 0L, false, false, new int[]{168, 1433}, null);
        CodeGenerator_x86simd.rulev[1610] = new Rule(1610, false, true, 1440, "1610: _1397 -> (SET I32 _127 _1396)", null, null, null, 0L, false, false, new int[]{170, 1439}, null);
        CodeGenerator_x86simd.rulev[1909] = new Rule(1909, false, true, 1734, "1909: _1691 -> (SET I32 _65 _1690)", null, null, null, 0L, false, false, new int[]{108, 1733}, null);
        CodeGenerator_x86simd.rulev[1915] = new Rule(1915, false, true, 1740, "1915: _1697 -> (SET I32 _67 _1696)", null, null, null, 0L, false, false, new int[]{110, 1739}, null);
        CodeGenerator_x86simd.rulev[1921] = new Rule(1921, false, true, 1746, "1921: _1703 -> (SET I32 _69 _1702)", null, null, null, 0L, false, false, new int[]{112, 1745}, null);
        CodeGenerator_x86simd.rulev[1927] = new Rule(1927, false, true, 1752, "1927: _1709 -> (SET I32 _71 _1708)", null, null, null, 0L, false, false, new int[]{114, 1751}, null);
        CodeGenerator_x86simd.rulev[1934] = new Rule(1934, false, true, 1758, "1934: _1715 -> (SET I32 _65 _1714)", null, null, null, 0L, false, false, new int[]{108, 1757}, null);
        CodeGenerator_x86simd.rulev[1940] = new Rule(1940, false, true, 1764, "1940: _1721 -> (SET I32 _67 _1720)", null, null, null, 0L, false, false, new int[]{110, 1763}, null);
        CodeGenerator_x86simd.rulev[1946] = new Rule(1946, false, true, 1770, "1946: _1727 -> (SET I32 _69 _1726)", null, null, null, 0L, false, false, new int[]{112, 1769}, null);
        CodeGenerator_x86simd.rulev[1952] = new Rule(1952, false, true, 1776, "1952: _1733 -> (SET I32 _71 _1732)", null, null, null, 0L, false, false, new int[]{114, 1775}, null);
        CodeGenerator_x86simd.rulev[2091] = new Rule(2091, false, true, 1910, "2091: _1867 -> (SET I32 _125 _1866)", null, null, null, 0L, false, false, new int[]{168, 1909}, null);
        CodeGenerator_x86simd.rulev[2097] = new Rule(2097, false, true, 1916, "2097: _1873 -> (SET I32 _127 _1872)", null, null, null, 0L, false, false, new int[]{170, 1915}, null);
        CodeGenerator_x86simd.rulev[2104] = new Rule(2104, false, true, 1922, "2104: _1879 -> (SET I32 _125 _1878)", null, null, null, 0L, false, false, new int[]{168, 1921}, null);
        CodeGenerator_x86simd.rulev[2110] = new Rule(2110, false, true, 1928, "2110: _1885 -> (SET I32 _127 _1884)", null, null, null, 0L, false, false, new int[]{170, 1927}, null);
        CodeGenerator_x86simd.rulev[2377] = new Rule(2377, false, true, 2190, "2377: _2147 -> (SET I32 _65 _2146)", null, null, null, 0L, false, false, new int[]{108, 2189}, null);
        CodeGenerator_x86simd.rulev[2383] = new Rule(2383, false, true, 2196, "2383: _2153 -> (SET I32 _67 _2152)", null, null, null, 0L, false, false, new int[]{110, 2195}, null);
        CodeGenerator_x86simd.rulev[2389] = new Rule(2389, false, true, 2202, "2389: _2159 -> (SET I32 _69 _2158)", null, null, null, 0L, false, false, new int[]{112, 2201}, null);
        CodeGenerator_x86simd.rulev[2395] = new Rule(2395, false, true, 2208, "2395: _2165 -> (SET I32 _71 _2164)", null, null, null, 0L, false, false, new int[]{114, 2207}, null);
        CodeGenerator_x86simd.rulev[2402] = new Rule(2402, false, true, 2214, "2402: _2171 -> (SET I32 _65 _2170)", null, null, null, 0L, false, false, new int[]{108, 2213}, null);
        CodeGenerator_x86simd.rulev[2408] = new Rule(2408, false, true, 2220, "2408: _2177 -> (SET I32 _67 _2176)", null, null, null, 0L, false, false, new int[]{110, 2219}, null);
        CodeGenerator_x86simd.rulev[2414] = new Rule(2414, false, true, 2226, "2414: _2183 -> (SET I32 _69 _2182)", null, null, null, 0L, false, false, new int[]{112, 2225}, null);
        CodeGenerator_x86simd.rulev[2420] = new Rule(2420, false, true, 2232, "2420: _2189 -> (SET I32 _71 _2188)", null, null, null, 0L, false, false, new int[]{114, 2231}, null);
        CodeGenerator_x86simd.rulev[2493] = new Rule(2493, false, true, 2302, "2493: _2259 -> (SET I32 _125 _2258)", null, null, null, 0L, false, false, new int[]{168, 2301}, null);
        CodeGenerator_x86simd.rulev[2499] = new Rule(2499, false, true, 2308, "2499: _2265 -> (SET I32 _127 _2264)", null, null, null, 0L, false, false, new int[]{170, 2307}, null);
        CodeGenerator_x86simd.rulev[2636] = new Rule(2636, false, true, 2442, "2636: _2399 -> (SET I32 _65 _2398)", null, null, null, 0L, false, false, new int[]{108, 2441}, null);
        CodeGenerator_x86simd.rulev[2642] = new Rule(2642, false, true, 2448, "2642: _2405 -> (SET I32 _67 _2404)", null, null, null, 0L, false, false, new int[]{110, 2447}, null);
        CodeGenerator_x86simd.rulev[2648] = new Rule(2648, false, true, 2454, "2648: _2411 -> (SET I32 _69 _2410)", null, null, null, 0L, false, false, new int[]{112, 2453}, null);
        CodeGenerator_x86simd.rulev[2654] = new Rule(2654, false, true, 2460, "2654: _2417 -> (SET I32 _71 _2416)", null, null, null, 0L, false, false, new int[]{114, 2459}, null);
        CodeGenerator_x86simd.rulev[2727] = new Rule(2727, false, true, 2530, "2727: _2487 -> (SET I32 _125 _2486)", null, null, null, 0L, false, false, new int[]{168, 2529}, null);
        CodeGenerator_x86simd.rulev[2733] = new Rule(2733, false, true, 2536, "2733: _2493 -> (SET I32 _127 _2492)", null, null, null, 0L, false, false, new int[]{170, 2535}, null);
        CodeGenerator_x86simd.rulev[2870] = new Rule(2870, false, true, 2670, "2870: _2627 -> (SET I32 _65 _2626)", null, null, null, 0L, false, false, new int[]{108, 2669}, null);
        CodeGenerator_x86simd.rulev[2876] = new Rule(2876, false, true, 2676, "2876: _2633 -> (SET I32 _67 _2632)", null, null, null, 0L, false, false, new int[]{110, 2675}, null);
        CodeGenerator_x86simd.rulev[2882] = new Rule(2882, false, true, 2682, "2882: _2639 -> (SET I32 _69 _2638)", null, null, null, 0L, false, false, new int[]{112, 2681}, null);
        CodeGenerator_x86simd.rulev[2888] = new Rule(2888, false, true, 2688, "2888: _2645 -> (SET I32 _71 _2644)", null, null, null, 0L, false, false, new int[]{114, 2687}, null);
        CodeGenerator_x86simd.rulev[2917] = new Rule(2917, false, true, 2714, "2917: _2671 -> (SET I32 _125 _2670)", null, null, null, 0L, false, false, new int[]{168, 2713}, null);
        CodeGenerator_x86simd.rulev[2919] = new Rule(2919, false, true, 2716, "2919: _2673 -> (SET I32 _127 _2672)", null, null, null, 0L, false, false, new int[]{170, 2715}, null);
        CodeGenerator_x86simd.rulev[2922] = new Rule(2922, false, true, 2718, "2922: _2675 -> (SET I32 _65 _2674)", null, null, null, 0L, false, false, new int[]{108, 2717}, null);
        CodeGenerator_x86simd.rulev[2924] = new Rule(2924, false, true, 2720, "2924: _2677 -> (SET I32 _67 _2676)", null, null, null, 0L, false, false, new int[]{110, 2719}, null);
        CodeGenerator_x86simd.rulev[2926] = new Rule(2926, false, true, 2722, "2926: _2679 -> (SET I32 _69 _2678)", null, null, null, 0L, false, false, new int[]{112, 2721}, null);
        CodeGenerator_x86simd.rulev[2928] = new Rule(2928, false, true, 2724, "2928: _2681 -> (SET I32 _71 _2680)", null, null, null, 0L, false, false, new int[]{114, 2723}, null);
        CodeGenerator_x86simd.rulev[2957] = new Rule(2957, false, true, 2750, "2957: _2707 -> (SET I32 _125 _2706)", null, null, null, 0L, false, false, new int[]{168, 2749}, null);
        CodeGenerator_x86simd.rulev[2959] = new Rule(2959, false, true, 2752, "2959: _2709 -> (SET I32 _127 _2708)", null, null, null, 0L, false, false, new int[]{170, 2751}, null);
        CodeGenerator_x86simd.rulev[2962] = new Rule(2962, false, true, 2754, "2962: _2711 -> (SET I32 _65 _2710)", null, null, null, 0L, false, false, new int[]{108, 2753}, null);
        CodeGenerator_x86simd.rulev[2964] = new Rule(2964, false, true, 2756, "2964: _2713 -> (SET I32 _67 _2712)", null, null, null, 0L, false, false, new int[]{110, 2755}, null);
        CodeGenerator_x86simd.rulev[2966] = new Rule(2966, false, true, 2758, "2966: _2715 -> (SET I32 _69 _2714)", null, null, null, 0L, false, false, new int[]{112, 2757}, null);
        CodeGenerator_x86simd.rulev[2968] = new Rule(2968, false, true, 2760, "2968: _2717 -> (SET I32 _71 _2716)", null, null, null, 0L, false, false, new int[]{114, 2759}, null);
        CodeGenerator_x86simd.rulev[2997] = new Rule(2997, false, true, 2786, "2997: _2743 -> (SET I32 _125 _2742)", null, null, null, 0L, false, false, new int[]{168, 2785}, null);
        CodeGenerator_x86simd.rulev[2999] = new Rule(2999, false, true, 2788, "2999: _2745 -> (SET I32 _127 _2744)", null, null, null, 0L, false, false, new int[]{170, 2787}, null);
        CodeGenerator_x86simd.rulev[3002] = new Rule(3002, false, true, 2790, "3002: _2747 -> (SET I32 _65 _2746)", null, null, null, 0L, false, false, new int[]{108, 2789}, null);
        CodeGenerator_x86simd.rulev[3004] = new Rule(3004, false, true, 2792, "3004: _2749 -> (SET I32 _67 _2748)", null, null, null, 0L, false, false, new int[]{110, 2791}, null);
        CodeGenerator_x86simd.rulev[3006] = new Rule(3006, false, true, 2794, "3006: _2751 -> (SET I32 _69 _2750)", null, null, null, 0L, false, false, new int[]{112, 2793}, null);
        CodeGenerator_x86simd.rulev[3008] = new Rule(3008, false, true, 2796, "3008: _2753 -> (SET I32 _71 _2752)", null, null, null, 0L, false, false, new int[]{114, 2795}, null);
        CodeGenerator_x86simd.rulev[3037] = new Rule(3037, false, true, 2822, "3037: _2779 -> (SET I32 _125 _2778)", null, null, null, 0L, false, false, new int[]{168, 2821}, null);
        CodeGenerator_x86simd.rulev[3039] = new Rule(3039, false, true, 2824, "3039: _2781 -> (SET I32 _127 _2780)", null, null, null, 0L, false, false, new int[]{170, 2823}, null);
        CodeGenerator_x86simd.rulev[3042] = new Rule(3042, false, true, 2826, "3042: _2783 -> (SET I32 _65 _2782)", null, null, null, 0L, false, false, new int[]{108, 2825}, null);
        CodeGenerator_x86simd.rulev[3044] = new Rule(3044, false, true, 2828, "3044: _2785 -> (SET I32 _67 _2784)", null, null, null, 0L, false, false, new int[]{110, 2827}, null);
        CodeGenerator_x86simd.rulev[3046] = new Rule(3046, false, true, 2830, "3046: _2787 -> (SET I32 _69 _2786)", null, null, null, 0L, false, false, new int[]{112, 2829}, null);
        CodeGenerator_x86simd.rulev[3048] = new Rule(3048, false, true, 2832, "3048: _2789 -> (SET I32 _71 _2788)", null, null, null, 0L, false, false, new int[]{114, 2831}, null);
        CodeGenerator_x86simd.rulev[3077] = new Rule(3077, false, true, 2858, "3077: _2815 -> (SET I32 _125 _2814)", null, null, null, 0L, false, false, new int[]{168, 2857}, null);
        CodeGenerator_x86simd.rulev[3079] = new Rule(3079, false, true, 2860, "3079: _2817 -> (SET I32 _127 _2816)", null, null, null, 0L, false, false, new int[]{170, 2859}, null);
        CodeGenerator_x86simd.rulev[3082] = new Rule(3082, false, true, 2862, "3082: _2819 -> (SET I32 _65 _2818)", null, null, null, 0L, false, false, new int[]{108, 2861}, null);
        CodeGenerator_x86simd.rulev[3084] = new Rule(3084, false, true, 2864, "3084: _2821 -> (SET I32 _67 _2820)", null, null, null, 0L, false, false, new int[]{110, 2863}, null);
        CodeGenerator_x86simd.rulev[3086] = new Rule(3086, false, true, 2866, "3086: _2823 -> (SET I32 _69 _2822)", null, null, null, 0L, false, false, new int[]{112, 2865}, null);
        CodeGenerator_x86simd.rulev[3088] = new Rule(3088, false, true, 2868, "3088: _2825 -> (SET I32 _71 _2824)", null, null, null, 0L, false, false, new int[]{114, 2867}, null);
        CodeGenerator_x86simd.rulev[3117] = new Rule(3117, false, true, 2894, "3117: _2851 -> (SET I32 _125 _2850)", null, null, null, 0L, false, false, new int[]{168, 2893}, null);
        CodeGenerator_x86simd.rulev[3119] = new Rule(3119, false, true, 2896, "3119: _2853 -> (SET I32 _127 _2852)", null, null, null, 0L, false, false, new int[]{170, 2895}, null);
    }

    private static void rrinit3900() {
        CodeGenerator_x86simd.rulev[3122] = new Rule(3122, false, true, 2898, "3122: _2855 -> (SET I32 _65 _2854)", null, null, null, 0L, false, false, new int[]{108, 2897}, null);
        CodeGenerator_x86simd.rulev[3124] = new Rule(3124, false, true, 2900, "3124: _2857 -> (SET I32 _67 _2856)", null, null, null, 0L, false, false, new int[]{110, 2899}, null);
        CodeGenerator_x86simd.rulev[3126] = new Rule(3126, false, true, 2902, "3126: _2859 -> (SET I32 _69 _2858)", null, null, null, 0L, false, false, new int[]{112, 2901}, null);
        CodeGenerator_x86simd.rulev[3128] = new Rule(3128, false, true, 2904, "3128: _2861 -> (SET I32 _71 _2860)", null, null, null, 0L, false, false, new int[]{114, 2903}, null);
        CodeGenerator_x86simd.rulev[3167] = new Rule(3167, false, true, 2940, "3167: _2897 -> (SET I32 _125 _2896)", null, null, null, 0L, false, false, new int[]{168, 2939}, null);
        CodeGenerator_x86simd.rulev[3170] = new Rule(3170, false, true, 2943, "3170: _2900 -> (SET I32 _127 _2899)", null, null, null, 0L, false, false, new int[]{170, 2942}, null);
        CodeGenerator_x86simd.rulev[3248] = new Rule(3248, false, true, 3018, "3248: _2975 -> (SET I32 _65 _2974)", null, null, null, 0L, false, false, new int[]{108, 3017}, null);
        CodeGenerator_x86simd.rulev[3251] = new Rule(3251, false, true, 3021, "3251: _2978 -> (SET I32 _67 _2977)", null, null, null, 0L, false, false, new int[]{110, 3020}, null);
        CodeGenerator_x86simd.rulev[3254] = new Rule(3254, false, true, 3024, "3254: _2981 -> (SET I32 _69 _2980)", null, null, null, 0L, false, false, new int[]{112, 3023}, null);
        CodeGenerator_x86simd.rulev[3257] = new Rule(3257, false, true, 3027, "3257: _2984 -> (SET I32 _71 _2983)", null, null, null, 0L, false, false, new int[]{114, 3026}, null);
        CodeGenerator_x86simd.rulev[3367] = new Rule(3367, false, true, 3125, "3367: _3082 -> (SET I32 _125 _3081)", null, null, null, 0L, false, false, new int[]{168, 3124}, null);
        CodeGenerator_x86simd.rulev[3369] = new Rule(3369, false, true, 3127, "3369: _3084 -> (SET I32 _127 _3083)", null, null, null, 0L, false, false, new int[]{170, 3126}, null);
        CodeGenerator_x86simd.rulev[3372] = new Rule(3372, false, true, 3129, "3372: _3086 -> (SET I32 _125 _3085)", null, null, null, 0L, false, false, new int[]{168, 3128}, null);
        CodeGenerator_x86simd.rulev[3374] = new Rule(3374, false, true, 3131, "3374: _3088 -> (SET I32 _127 _3087)", null, null, null, 0L, false, false, new int[]{170, 3130}, null);
        CodeGenerator_x86simd.rulev[3377] = new Rule(3377, false, true, 3133, "3377: _3090 -> (SET I32 _125 _3089)", null, null, null, 0L, false, false, new int[]{168, 3132}, null);
        CodeGenerator_x86simd.rulev[3379] = new Rule(3379, false, true, 3135, "3379: _3092 -> (SET I32 _127 _3091)", null, null, null, 0L, false, false, new int[]{170, 3134}, null);
        CodeGenerator_x86simd.rulev[3382] = new Rule(3382, false, true, 3137, "3382: _3094 -> (SET I32 _125 _3093)", null, null, null, 0L, false, false, new int[]{168, 3136}, null);
        CodeGenerator_x86simd.rulev[3384] = new Rule(3384, false, true, 3139, "3384: _3096 -> (SET I32 _127 _3095)", null, null, null, 0L, false, false, new int[]{170, 3138}, null);
        CodeGenerator_x86simd.rulev[3387] = new Rule(3387, false, true, 3141, "3387: _3098 -> (SET I32 _125 _3097)", null, null, null, 0L, false, false, new int[]{168, 3140}, null);
        CodeGenerator_x86simd.rulev[3389] = new Rule(3389, false, true, 3143, "3389: _3100 -> (SET I32 _127 _3099)", null, null, null, 0L, false, false, new int[]{170, 3142}, null);
        CodeGenerator_x86simd.rulev[3595] = new Rule(3595, false, true, 3337, "3595: _3294 -> (SET I32 _65 _3293)", null, null, null, 0L, false, false, new int[]{108, 3336}, null);
        CodeGenerator_x86simd.rulev[3597] = new Rule(3597, false, true, 3339, "3597: _3296 -> (SET I32 _67 _3295)", null, null, null, 0L, false, false, new int[]{110, 3338}, null);
        CodeGenerator_x86simd.rulev[3599] = new Rule(3599, false, true, 3341, "3599: _3298 -> (SET I32 _69 _3297)", null, null, null, 0L, false, false, new int[]{112, 3340}, null);
        CodeGenerator_x86simd.rulev[3601] = new Rule(3601, false, true, 3343, "3601: _3300 -> (SET I32 _71 _3299)", null, null, null, 0L, false, false, new int[]{114, 3342}, null);
        CodeGenerator_x86simd.rulev[3604] = new Rule(3604, false, true, 3345, "3604: _3302 -> (SET I32 _65 _3301)", null, null, null, 0L, false, false, new int[]{108, 3344}, null);
        CodeGenerator_x86simd.rulev[3606] = new Rule(3606, false, true, 3347, "3606: _3304 -> (SET I32 _67 _3303)", null, null, null, 0L, false, false, new int[]{110, 3346}, null);
        CodeGenerator_x86simd.rulev[3608] = new Rule(3608, false, true, 3349, "3608: _3306 -> (SET I32 _69 _3305)", null, null, null, 0L, false, false, new int[]{112, 3348}, null);
        CodeGenerator_x86simd.rulev[3610] = new Rule(3610, false, true, 3351, "3610: _3308 -> (SET I32 _71 _3307)", null, null, null, 0L, false, false, new int[]{114, 3350}, null);
        CodeGenerator_x86simd.rulev[3613] = new Rule(3613, false, true, 3353, "3613: _3310 -> (SET I32 _65 _3309)", null, null, null, 0L, false, false, new int[]{108, 3352}, null);
        CodeGenerator_x86simd.rulev[3615] = new Rule(3615, false, true, 3355, "3615: _3312 -> (SET I32 _67 _3311)", null, null, null, 0L, false, false, new int[]{110, 3354}, null);
        CodeGenerator_x86simd.rulev[3617] = new Rule(3617, false, true, 3357, "3617: _3314 -> (SET I32 _69 _3313)", null, null, null, 0L, false, false, new int[]{112, 3356}, null);
        CodeGenerator_x86simd.rulev[3619] = new Rule(3619, false, true, 3359, "3619: _3316 -> (SET I32 _71 _3315)", null, null, null, 0L, false, false, new int[]{114, 3358}, null);
        CodeGenerator_x86simd.rulev[3622] = new Rule(3622, false, true, 3361, "3622: _3318 -> (SET I32 _65 _3317)", null, null, null, 0L, false, false, new int[]{108, 3360}, null);
        CodeGenerator_x86simd.rulev[3624] = new Rule(3624, false, true, 3363, "3624: _3320 -> (SET I32 _67 _3319)", null, null, null, 0L, false, false, new int[]{110, 3362}, null);
        CodeGenerator_x86simd.rulev[3626] = new Rule(3626, false, true, 3365, "3626: _3322 -> (SET I32 _69 _3321)", null, null, null, 0L, false, false, new int[]{112, 3364}, null);
        CodeGenerator_x86simd.rulev[3628] = new Rule(3628, false, true, 3367, "3628: _3324 -> (SET I32 _71 _3323)", null, null, null, 0L, false, false, new int[]{114, 3366}, null);
        CodeGenerator_x86simd.rulev[3631] = new Rule(3631, false, true, 3369, "3631: _3326 -> (SET I32 _65 _3325)", null, null, null, 0L, false, false, new int[]{108, 3368}, null);
        CodeGenerator_x86simd.rulev[3633] = new Rule(3633, false, true, 3371, "3633: _3328 -> (SET I32 _67 _3327)", null, null, null, 0L, false, false, new int[]{110, 3370}, null);
        CodeGenerator_x86simd.rulev[3635] = new Rule(3635, false, true, 3373, "3635: _3330 -> (SET I32 _69 _3329)", null, null, null, 0L, false, false, new int[]{112, 3372}, null);
        CodeGenerator_x86simd.rulev[3637] = new Rule(3637, false, true, 3375, "3637: _3332 -> (SET I32 _71 _3331)", null, null, null, 0L, false, false, new int[]{114, 3374}, null);
        CodeGenerator_x86simd.rulev[3716] = new Rule(3716, false, true, 3449, "3716: _3406 -> (SET I32 _125 _3405)", null, null, null, 0L, false, false, new int[]{168, 3448}, null);
        CodeGenerator_x86simd.rulev[3718] = new Rule(3718, false, true, 3451, "3718: _3408 -> (SET I32 _127 _3407)", null, null, null, 0L, false, false, new int[]{170, 3450}, null);
        CodeGenerator_x86simd.rulev[3721] = new Rule(3721, false, true, 3453, "3721: _3410 -> (SET I32 _65 _3409)", null, null, null, 0L, false, false, new int[]{108, 3452}, null);
        CodeGenerator_x86simd.rulev[3723] = new Rule(3723, false, true, 3455, "3723: _3412 -> (SET I32 _67 _3411)", null, null, null, 0L, false, false, new int[]{110, 3454}, null);
        CodeGenerator_x86simd.rulev[3725] = new Rule(3725, false, true, 3457, "3725: _3414 -> (SET I32 _69 _3413)", null, null, null, 0L, false, false, new int[]{112, 3456}, null);
        CodeGenerator_x86simd.rulev[3727] = new Rule(3727, false, true, 3459, "3727: _3416 -> (SET I32 _71 _3415)", null, null, null, 0L, false, false, new int[]{114, 3458}, null);
        CodeGenerator_x86simd.rulev[3770] = new Rule(3770, false, true, 3497, "3770: _3454 -> (SET I32 _125 _2895)", null, null, null, 0L, false, false, new int[]{168, 2938}, null);
        CodeGenerator_x86simd.rulev[3771] = new Rule(3771, false, true, 3498, "3771: _3455 -> (SET I32 _127 _2898)", null, null, null, 0L, false, false, new int[]{170, 2941}, null);
        CodeGenerator_x86simd.rulev[3773] = new Rule(3773, false, true, 3499, "3773: _3456 -> (SET I32 _65 _2973)", null, null, null, 0L, false, false, new int[]{108, 3016}, null);
        CodeGenerator_x86simd.rulev[3774] = new Rule(3774, false, true, 3500, "3774: _3457 -> (SET I32 _67 _2976)", null, null, null, 0L, false, false, new int[]{110, 3019}, null);
        CodeGenerator_x86simd.rulev[3775] = new Rule(3775, false, true, 3501, "3775: _3458 -> (SET I32 _69 _2979)", null, null, null, 0L, false, false, new int[]{112, 3022}, null);
        CodeGenerator_x86simd.rulev[3776] = new Rule(3776, false, true, 3502, "3776: _3459 -> (SET I32 _71 _2982)", null, null, null, 0L, false, false, new int[]{114, 3025}, null);
        CodeGenerator_x86simd.rulev[3813] = new Rule(3813, false, true, 3528, "3813: _3485 -> (SET I32 _125 _3484)", null, null, null, 0L, false, false, new int[]{168, 3527}, null);
        CodeGenerator_x86simd.rulev[3815] = new Rule(3815, false, true, 3530, "3815: _3487 -> (SET I32 _127 _3486)", null, null, null, 0L, false, false, new int[]{170, 3529}, null);
        CodeGenerator_x86simd.rulev[3818] = new Rule(3818, false, true, 3532, "3818: _3489 -> (SET I32 _125 _3488)", null, null, null, 0L, false, false, new int[]{168, 3531}, null);
        CodeGenerator_x86simd.rulev[3820] = new Rule(3820, false, true, 3534, "3820: _3491 -> (SET I32 _127 _3490)", null, null, null, 0L, false, false, new int[]{170, 3533}, null);
        CodeGenerator_x86simd.rulev[3822] = new Rule(3822, false, true, 3535, "3822: _3492 -> (SET I32 _65 _3484)", null, null, null, 0L, false, false, new int[]{108, 3527}, null);
        CodeGenerator_x86simd.rulev[3823] = new Rule(3823, false, true, 3536, "3823: _3493 -> (SET I32 _67 _3486)", null, null, null, 0L, false, false, new int[]{110, 3529}, null);
        CodeGenerator_x86simd.rulev[3825] = new Rule(3825, false, true, 3538, "3825: _3495 -> (SET I32 _69 _3494)", null, null, null, 0L, false, false, new int[]{112, 3537}, null);
        CodeGenerator_x86simd.rulev[3827] = new Rule(3827, false, true, 3540, "3827: _3497 -> (SET I32 _71 _3496)", null, null, null, 0L, false, false, new int[]{114, 3539}, null);
        CodeGenerator_x86simd.rulev[3829] = new Rule(3829, false, true, 3541, "3829: _3498 -> (SET I32 _65 _3488)", null, null, null, 0L, false, false, new int[]{108, 3531}, null);
        CodeGenerator_x86simd.rulev[3830] = new Rule(3830, false, true, 3542, "3830: _3499 -> (SET I32 _67 _3490)", null, null, null, 0L, false, false, new int[]{110, 3533}, null);
        CodeGenerator_x86simd.rulev[3940] = new Rule(3940, false, false, 10, "3940: void -> (SET I32 meml rcl)", ImList.list(ImList.list("movl", "$2", "$1")), null, null, 0L, false, false, new int[]{32, 37}, new String[]{null, null, null});
        CodeGenerator_x86simd.rulev[3944] = new Rule(3944, false, false, 10, "3944: void -> (SET I32 xregl regl)", ImList.list(ImList.list("movl", "$2", "$1")), null, null, 0L, false, false, new int[]{12, 4}, new String[]{null, null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[3953] = new Rule(3953, false, false, 10, "3953: void -> (SET I32 _3585 _3586)", ImList.list(ImList.list("call", ImList.list("symbol", "_alloca"))), null, null, 0L, false, false, new int[]{3628, 3629}, new String[]{null, "*reg-eax-I32*"});
        CodeGenerator_x86simd.rulev[3957] = new Rule(3957, false, true, 3633, "3957: _3590 -> (SET I32 _3585 _3587)", null, null, null, 0L, false, false, new int[]{3628, 3630}, null);
        CodeGenerator_x86simd.rulev[3961] = new Rule(3961, false, true, 3636, "3961: _3593 -> (SET I32 _3592 mrcl)", null, null, null, 0L, false, false, new int[]{3635, 40}, null);
        CodeGenerator_x86simd.rulev[3962] = new Rule(3962, false, true, 3637, "3962: _3594 -> (SET I32 _3585 _3591)", null, null, null, 0L, false, false, new int[]{3628, 3634}, null);
        CodeGenerator_x86simd.rulev[4132] = new Rule(4132, false, false, 10, "4132: void -> (SET I32 meml _3601)", ImList.list(ImList.list("cvtsd2si", "$2", "%eax"), ImList.list("movl", "%eax", "$1")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{32, 3647}, new String[]{null, null, "*reg-tmp-F64*"});
        CodeGenerator_x86simd.rulev[4139] = new Rule(4139, false, false, 10, "4139: void -> (SET I32 meml _3603)", ImList.list(ImList.list("cvtss2si", "$2", "%eax"), ImList.list("movl", "%eax", "$1")), null, ImList.list(ImList.list("REG", "I32", "%eax")), 0L, false, false, new int[]{32, 3649}, new String[]{null, null, "*reg-tmp-F32*"});
        CodeGenerator_x86simd.rulev[3779] = new Rule(3779, false, true, 3504, "3779: _3461 -> (SET F32 _3460 memf)", null, null, null, 0L, false, false, new int[]{3503, 35}, null);
        CodeGenerator_x86simd.rulev[3781] = new Rule(3781, false, true, 3506, "3781: _3463 -> (SET F32 _3462 memf)", null, null, null, 0L, false, false, new int[]{3505, 35}, null);
        CodeGenerator_x86simd.rulev[3783] = new Rule(3783, false, true, 3508, "3783: _3465 -> (SET F32 _3464 memf)", null, null, null, 0L, false, false, new int[]{3507, 35}, null);
        CodeGenerator_x86simd.rulev[3785] = new Rule(3785, false, true, 3510, "3785: _3467 -> (SET F32 _3466 memf)", null, null, null, 0L, false, false, new int[]{3509, 35}, null);
        CodeGenerator_x86simd.rulev[3794] = new Rule(3794, false, true, 3515, "3794: _3472 -> (SET F32 memf _3460)", null, null, null, 0L, false, false, new int[]{35, 3503}, null);
        CodeGenerator_x86simd.rulev[3795] = new Rule(3795, false, true, 3516, "3795: _3473 -> (SET F32 memf _3462)", null, null, null, 0L, false, false, new int[]{35, 3505}, null);
        CodeGenerator_x86simd.rulev[3796] = new Rule(3796, false, true, 3517, "3796: _3474 -> (SET F32 memf _3464)", null, null, null, 0L, false, false, new int[]{35, 3507}, null);
        CodeGenerator_x86simd.rulev[3797] = new Rule(3797, false, true, 3518, "3797: _3475 -> (SET F32 memf _3466)", null, null, null, 0L, false, false, new int[]{35, 3509}, null);
        CodeGenerator_x86simd.rulev[3804] = new Rule(3804, false, true, 3521, "3804: _3478 -> (SET F32 _3460 _3460)", null, null, null, 0L, false, false, new int[]{3503, 3503}, null);
        CodeGenerator_x86simd.rulev[3805] = new Rule(3805, false, true, 3522, "3805: _3479 -> (SET F32 _3462 _3462)", null, null, null, 0L, false, false, new int[]{3505, 3505}, null);
        CodeGenerator_x86simd.rulev[3806] = new Rule(3806, false, true, 3523, "3806: _3480 -> (SET F32 _3464 _3464)", null, null, null, 0L, false, false, new int[]{3507, 3507}, null);
        CodeGenerator_x86simd.rulev[3807] = new Rule(3807, false, true, 3524, "3807: _3481 -> (SET F32 _3466 _3466)", null, null, null, 0L, false, false, new int[]{3509, 3509}, null);
        CodeGenerator_x86simd.rulev[3833] = new Rule(3833, false, true, 3544, "3833: _3501 -> (SET F32 _3460 _3500)", null, null, null, 0L, false, false, new int[]{3503, 3543}, null);
        CodeGenerator_x86simd.rulev[3835] = new Rule(3835, false, true, 3546, "3835: _3503 -> (SET F32 _3462 _3502)", null, null, null, 0L, false, false, new int[]{3505, 3545}, null);
        CodeGenerator_x86simd.rulev[3843] = new Rule(3843, false, true, 3552, "3843: _3509 -> (SET F32 _3460 _3508)", null, null, null, 0L, false, false, new int[]{3503, 3551}, null);
        CodeGenerator_x86simd.rulev[3845] = new Rule(3845, false, true, 3554, "3845: _3511 -> (SET F32 _3462 _3510)", null, null, null, 0L, false, false, new int[]{3505, 3553}, null);
        CodeGenerator_x86simd.rulev[3847] = new Rule(3847, false, true, 3556, "3847: _3513 -> (SET F32 _3464 _3512)", null, null, null, 0L, false, false, new int[]{3507, 3555}, null);
        CodeGenerator_x86simd.rulev[3849] = new Rule(3849, false, true, 3558, "3849: _3515 -> (SET F32 _3466 _3514)", null, null, null, 0L, false, false, new int[]{3509, 3557}, null);
        CodeGenerator_x86simd.rulev[3857] = new Rule(3857, false, true, 3564, "3857: _3521 -> (SET F32 _3460 _3520)", null, null, null, 0L, false, false, new int[]{3503, 3563}, null);
        CodeGenerator_x86simd.rulev[3859] = new Rule(3859, false, true, 3566, "3859: _3523 -> (SET F32 _3462 _3522)", null, null, null, 0L, false, false, new int[]{3505, 3565}, null);
        CodeGenerator_x86simd.rulev[3868] = new Rule(3868, false, true, 3573, "3868: _3530 -> (SET F32 _3460 _3529)", null, null, null, 0L, false, false, new int[]{3503, 3572}, null);
        CodeGenerator_x86simd.rulev[3870] = new Rule(3870, false, true, 3575, "3870: _3532 -> (SET F32 _3462 _3531)", null, null, null, 0L, false, false, new int[]{3505, 3574}, null);
        CodeGenerator_x86simd.rulev[3872] = new Rule(3872, false, true, 3577, "3872: _3534 -> (SET F32 _3464 _3533)", null, null, null, 0L, false, false, new int[]{3507, 3576}, null);
        CodeGenerator_x86simd.rulev[3874] = new Rule(3874, false, true, 3579, "3874: _3536 -> (SET F32 _3466 _3535)", null, null, null, 0L, false, false, new int[]{3509, 3578}, null);
        CodeGenerator_x86simd.rulev[3877] = new Rule(3877, false, true, 3581, "3877: _3538 -> (SET F32 _3460 _3537)", null, null, null, 0L, false, false, new int[]{3503, 3580}, null);
        CodeGenerator_x86simd.rulev[3879] = new Rule(3879, false, true, 3583, "3879: _3540 -> (SET F32 _3462 _3539)", null, null, null, 0L, false, false, new int[]{3505, 3582}, null);
        CodeGenerator_x86simd.rulev[3881] = new Rule(3881, false, true, 3585, "3881: _3542 -> (SET F32 _3464 _3541)", null, null, null, 0L, false, false, new int[]{3507, 3584}, null);
        CodeGenerator_x86simd.rulev[3883] = new Rule(3883, false, true, 3587, "3883: _3544 -> (SET F32 _3466 _3543)", null, null, null, 0L, false, false, new int[]{3509, 3586}, null);
        CodeGenerator_x86simd.rulev[3886] = new Rule(3886, false, true, 3589, "3886: _3546 -> (SET F32 _3460 _3545)", null, null, null, 0L, false, false, new int[]{3503, 3588}, null);
        CodeGenerator_x86simd.rulev[3888] = new Rule(3888, false, true, 3591, "3888: _3548 -> (SET F32 _3462 _3547)", null, null, null, 0L, false, false, new int[]{3505, 3590}, null);
    }

    private static void rrinit4000() {
        CodeGenerator_x86simd.rulev[3890] = new Rule(3890, false, true, 3593, "3890: _3550 -> (SET F32 _3464 _3549)", null, null, null, 0L, false, false, new int[]{3507, 3592}, null);
        CodeGenerator_x86simd.rulev[3892] = new Rule(3892, false, true, 3595, "3892: _3552 -> (SET F32 _3466 _3551)", null, null, null, 0L, false, false, new int[]{3509, 3594}, null);
        CodeGenerator_x86simd.rulev[3895] = new Rule(3895, false, true, 3597, "3895: _3554 -> (SET F32 _3460 _3553)", null, null, null, 0L, false, false, new int[]{3503, 3596}, null);
        CodeGenerator_x86simd.rulev[3897] = new Rule(3897, false, true, 3599, "3897: _3556 -> (SET F32 _3462 _3555)", null, null, null, 0L, false, false, new int[]{3505, 3598}, null);
        CodeGenerator_x86simd.rulev[3899] = new Rule(3899, false, true, 3601, "3899: _3558 -> (SET F32 _3464 _3557)", null, null, null, 0L, false, false, new int[]{3507, 3600}, null);
        CodeGenerator_x86simd.rulev[3901] = new Rule(3901, false, true, 3603, "3901: _3560 -> (SET F32 _3466 _3559)", null, null, null, 0L, false, false, new int[]{3509, 3602}, null);
        CodeGenerator_x86simd.rulev[3904] = new Rule(3904, false, true, 3605, "3904: _3562 -> (SET F32 _3460 _3561)", null, null, null, 0L, false, false, new int[]{3503, 3604}, null);
        CodeGenerator_x86simd.rulev[3906] = new Rule(3906, false, true, 3607, "3906: _3564 -> (SET F32 _3462 _3563)", null, null, null, 0L, false, false, new int[]{3505, 3606}, null);
        CodeGenerator_x86simd.rulev[3908] = new Rule(3908, false, true, 3609, "3908: _3566 -> (SET F32 _3464 _3565)", null, null, null, 0L, false, false, new int[]{3507, 3608}, null);
        CodeGenerator_x86simd.rulev[3910] = new Rule(3910, false, true, 3611, "3910: _3568 -> (SET F32 _3466 _3567)", null, null, null, 0L, false, false, new int[]{3509, 3610}, null);
        CodeGenerator_x86simd.rulev[3947] = new Rule(3947, false, false, 10, "3947: void -> (SET F32 xregf regf)", ImList.list(ImList.list("movss", "$2", "$1")), null, null, 0L, false, false, new int[]{15, 8}, new String[]{null, null, "*reg-tmp-F32*"});
        CodeGenerator_x86simd.rulev[3950] = new Rule(3950, false, false, 10, "3950: void -> (SET F32 memf regf)", ImList.list(ImList.list("movss", "$2", "$1")), null, null, 0L, false, false, new int[]{35, 8}, new String[]{null, null, "*reg-tmp-F32*"});
        CodeGenerator_x86simd.rulev[3965] = new Rule(3965, false, true, 3639, "3965: _3596 -> (SET F32 _3595 memf)", null, null, null, 0L, false, false, new int[]{3638, 35}, null);
        CodeGenerator_x86simd.rulev[3970] = new Rule(3970, false, true, 3642, "3970: _3599 -> (SET F32 _3595 regf)", null, null, null, 0L, false, false, new int[]{3638, 8}, null);
        CodeGenerator_x86simd.rulev[3939] = new Rule(3939, false, false, 10, "3939: void -> (SET I64 memq regq)", ImList.list(ImList.list("movl", ImList.list("qlow", "$2"), "$1"), ImList.list("movl", ImList.list("qhigh", "$2"), ImList.list("after", "$1", "4"))), null, null, 0L, false, false, new int[]{31, 3}, new String[]{null, null, "*reg-I64*"});
        CodeGenerator_x86simd.rulev[3943] = new Rule(3943, false, false, 10, "3943: void -> (SET I64 xregq regq)", ImList.list(ImList.list("movl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("movl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1"))), null, null, 0L, false, false, new int[]{14, 3}, new String[]{null, null, "*reg-I64*"});
        CodeGenerator_x86simd.rulev[3956] = new Rule(3956, false, true, 3632, "3956: _3589 -> (SET I64 _3588 mrcq)", null, null, null, 0L, false, false, new int[]{3631, 47}, null);
        CodeGenerator_x86simd.rulev[3789] = new Rule(3789, false, true, 3512, "3789: _3469 -> (SET F64 _3468 memd)", null, null, null, 0L, false, false, new int[]{3511, 36}, null);
        CodeGenerator_x86simd.rulev[3791] = new Rule(3791, false, true, 3514, "3791: _3471 -> (SET F64 _3470 memd)", null, null, null, 0L, false, false, new int[]{3513, 36}, null);
        CodeGenerator_x86simd.rulev[3800] = new Rule(3800, false, true, 3519, "3800: _3476 -> (SET F64 memd _3468)", null, null, null, 0L, false, false, new int[]{36, 3511}, null);
        CodeGenerator_x86simd.rulev[3801] = new Rule(3801, false, true, 3520, "3801: _3477 -> (SET F64 memd _3470)", null, null, null, 0L, false, false, new int[]{36, 3513}, null);
        CodeGenerator_x86simd.rulev[3809] = new Rule(3809, false, true, 3525, "3809: _3482 -> (SET F64 _3468 _3468)", null, null, null, 0L, false, false, new int[]{3511, 3511}, null);
        CodeGenerator_x86simd.rulev[3810] = new Rule(3810, false, true, 3526, "3810: _3483 -> (SET F64 _3470 _3470)", null, null, null, 0L, false, false, new int[]{3513, 3513}, null);
        CodeGenerator_x86simd.rulev[3838] = new Rule(3838, false, true, 3548, "3838: _3505 -> (SET F64 _3468 _3504)", null, null, null, 0L, false, false, new int[]{3511, 3547}, null);
        CodeGenerator_x86simd.rulev[3840] = new Rule(3840, false, true, 3550, "3840: _3507 -> (SET F64 _3470 _3506)", null, null, null, 0L, false, false, new int[]{3513, 3549}, null);
        CodeGenerator_x86simd.rulev[3852] = new Rule(3852, false, true, 3560, "3852: _3517 -> (SET F64 _3468 _3516)", null, null, null, 0L, false, false, new int[]{3511, 3559}, null);
        CodeGenerator_x86simd.rulev[3854] = new Rule(3854, false, true, 3562, "3854: _3519 -> (SET F64 _3470 _3518)", null, null, null, 0L, false, false, new int[]{3513, 3561}, null);
        CodeGenerator_x86simd.rulev[3862] = new Rule(3862, false, true, 3568, "3862: _3525 -> (SET F64 _3468 _3524)", null, null, null, 0L, false, false, new int[]{3511, 3567}, null);
        CodeGenerator_x86simd.rulev[3864] = new Rule(3864, false, true, 3570, "3864: _3527 -> (SET F64 _3470 _3526)", null, null, null, 0L, false, false, new int[]{3513, 3569}, null);
        CodeGenerator_x86simd.rulev[3913] = new Rule(3913, false, true, 3613, "3913: _3570 -> (SET F64 _3468 _3569)", null, null, null, 0L, false, false, new int[]{3511, 3612}, null);
        CodeGenerator_x86simd.rulev[3915] = new Rule(3915, false, true, 3615, "3915: _3572 -> (SET F64 _3470 _3571)", null, null, null, 0L, false, false, new int[]{3513, 3614}, null);
        CodeGenerator_x86simd.rulev[3918] = new Rule(3918, false, true, 3617, "3918: _3574 -> (SET F64 _3468 _3573)", null, null, null, 0L, false, false, new int[]{3511, 3616}, null);
        CodeGenerator_x86simd.rulev[3920] = new Rule(3920, false, true, 3619, "3920: _3576 -> (SET F64 _3470 _3575)", null, null, null, 0L, false, false, new int[]{3513, 3618}, null);
        CodeGenerator_x86simd.rulev[3923] = new Rule(3923, false, true, 3621, "3923: _3578 -> (SET F64 _3468 _3577)", null, null, null, 0L, false, false, new int[]{3511, 3620}, null);
        CodeGenerator_x86simd.rulev[3925] = new Rule(3925, false, true, 3623, "3925: _3580 -> (SET F64 _3470 _3579)", null, null, null, 0L, false, false, new int[]{3513, 3622}, null);
        CodeGenerator_x86simd.rulev[3928] = new Rule(3928, false, true, 3625, "3928: _3582 -> (SET F64 _3468 _3581)", null, null, null, 0L, false, false, new int[]{3511, 3624}, null);
        CodeGenerator_x86simd.rulev[3930] = new Rule(3930, false, true, 3627, "3930: _3584 -> (SET F64 _3470 _3583)", null, null, null, 0L, false, false, new int[]{3513, 3626}, null);
        CodeGenerator_x86simd.rulev[3948] = new Rule(3948, false, false, 10, "3948: void -> (SET F64 xregd regd)", ImList.list(ImList.list("movsd", "$2", "$1")), null, null, 0L, false, false, new int[]{16, 9}, new String[]{null, null, "*reg-tmp-F64*"});
        CodeGenerator_x86simd.rulev[3949] = new Rule(3949, false, false, 10, "3949: void -> (SET F64 memd regd)", ImList.list(ImList.list("movsd", "$2", "$1")), null, null, 0L, false, false, new int[]{36, 9}, new String[]{null, null, "*reg-tmp-F64*"});
        CodeGenerator_x86simd.rulev[3968] = new Rule(3968, false, true, 3641, "3968: _3598 -> (SET F64 _3597 memd)", null, null, null, 0L, false, false, new int[]{3640, 36}, null);
        CodeGenerator_x86simd.rulev[3972] = new Rule(3972, false, true, 3643, "3972: _3600 -> (SET F64 _3597 regd)", null, null, null, 0L, false, false, new int[]{3640, 9}, null);
        CodeGenerator_x86simd.rulev[4142] = new Rule(4142, false, false, 10, "4142: void -> (JUMP _ lab)", ImList.list(ImList.list("jmp", "$1")), null, null, 0L, false, false, new int[]{22}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[4144] = new Rule(4144, false, false, 10, "4144: void -> (JUMPC _ _3605 lab lab)", ImList.list(ImList.list("cmpl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1")), ImList.list("jne", "$4"), ImList.list("cmpl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("je", "$3")), null, null, 0L, false, false, new int[]{3651, 22, 22}, new String[]{null, "*reg-I64*", null, null, null});
        CodeGenerator_x86simd.rulev[4146] = new Rule(4146, false, false, 10, "4146: void -> (JUMPC _ _3606 lab lab)", ImList.list(ImList.list("cmpl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1")), ImList.list("jne", "$3"), ImList.list("cmpl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("jne", "$3")), null, null, 0L, false, false, new int[]{3652, 22, 22}, new String[]{null, "*reg-I64*", null, null, null});
        CodeGenerator_x86simd.rulev[4148] = new Rule(4148, false, false, 10, "4148: void -> (JUMPC _ _3607 lab lab)", ImList.list(ImList.list("cmpl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1")), ImList.list("jl", "$3"), ImList.list("jg", "$4"), ImList.list("cmpl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("jb", "$3")), null, null, 0L, false, false, new int[]{3653, 22, 22}, new String[]{null, "*reg-I64*", null, null, null});
        CodeGenerator_x86simd.rulev[4150] = new Rule(4150, false, false, 10, "4150: void -> (JUMPC _ _3608 lab lab)", ImList.list(ImList.list("cmpl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1")), ImList.list("jl", "$3"), ImList.list("jg", "$4"), ImList.list("cmpl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("jbe", "$3")), null, null, 0L, false, false, new int[]{3654, 22, 22}, new String[]{null, "*reg-I64*", null, null, null});
        CodeGenerator_x86simd.rulev[4152] = new Rule(4152, false, false, 10, "4152: void -> (JUMPC _ _3609 lab lab)", ImList.list(ImList.list("cmpl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1")), ImList.list("jg", "$3"), ImList.list("jl", "$4"), ImList.list("cmpl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("ja", "$3")), null, null, 0L, false, false, new int[]{3655, 22, 22}, new String[]{null, "*reg-I64*", null, null, null});
        CodeGenerator_x86simd.rulev[4154] = new Rule(4154, false, false, 10, "4154: void -> (JUMPC _ _3610 lab lab)", ImList.list(ImList.list("cmpl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1")), ImList.list("jg", "$3"), ImList.list("jl", "$4"), ImList.list("cmpl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("jae", "$3")), null, null, 0L, false, false, new int[]{3656, 22, 22}, new String[]{null, "*reg-I64*", null, null, null});
        CodeGenerator_x86simd.rulev[4156] = new Rule(4156, false, false, 10, "4156: void -> (JUMPC _ _3611 lab lab)", ImList.list(ImList.list("cmpl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1")), ImList.list("jb", "$3"), ImList.list("ja", "$4"), ImList.list("cmpl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("jb", "$3")), null, null, 0L, false, false, new int[]{3657, 22, 22}, new String[]{null, "*reg-I64*", null, null, null});
        CodeGenerator_x86simd.rulev[4158] = new Rule(4158, false, false, 10, "4158: void -> (JUMPC _ _3612 lab lab)", ImList.list(ImList.list("cmpl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1")), ImList.list("jb", "$3"), ImList.list("ja", "$4"), ImList.list("cmpl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("jbe", "$3")), null, null, 0L, false, false, new int[]{3658, 22, 22}, new String[]{null, "*reg-I64*", null, null, null});
        CodeGenerator_x86simd.rulev[4160] = new Rule(4160, false, false, 10, "4160: void -> (JUMPC _ _3613 lab lab)", ImList.list(ImList.list("cmpl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1")), ImList.list("ja", "$3"), ImList.list("jb", "$4"), ImList.list("cmpl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("ja", "$3")), null, null, 0L, false, false, new int[]{3659, 22, 22}, new String[]{null, "*reg-I64*", null, null, null});
        CodeGenerator_x86simd.rulev[4162] = new Rule(4162, false, false, 10, "4162: void -> (JUMPC _ _3614 lab lab)", ImList.list(ImList.list("cmpl", ImList.list("qhigh", "$2"), ImList.list("qhigh", "$1")), ImList.list("ja", "$3"), ImList.list("jb", "$4"), ImList.list("cmpl", ImList.list("qlow", "$2"), ImList.list("qlow", "$1")), ImList.list("jae", "$3")), null, null, 0L, false, false, new int[]{3660, 22, 22}, new String[]{null, "*reg-I64*", null, null, null});
        CodeGenerator_x86simd.rulev[4164] = new Rule(4164, false, false, 10, "4164: void -> (JUMPC _ _3615 lab lab)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("je", "$3")), null, null, 0L, false, false, new int[]{3661, 22, 22}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_x86simd.rulev[4166] = new Rule(4166, false, false, 10, "4166: void -> (JUMPC _ _3616 lab lab)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("jne", "$3")), null, null, 0L, false, false, new int[]{3662, 22, 22}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_x86simd.rulev[4168] = new Rule(4168, false, false, 10, "4168: void -> (JUMPC _ _3617 lab lab)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("jl", "$3")), null, null, 0L, false, false, new int[]{3663, 22, 22}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_x86simd.rulev[4170] = new Rule(4170, false, false, 10, "4170: void -> (JUMPC _ _3618 lab lab)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("jle", "$3")), null, null, 0L, false, false, new int[]{3664, 22, 22}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_x86simd.rulev[4172] = new Rule(4172, false, false, 10, "4172: void -> (JUMPC _ _3619 lab lab)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("jg", "$3")), null, null, 0L, false, false, new int[]{3665, 22, 22}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_x86simd.rulev[4174] = new Rule(4174, false, false, 10, "4174: void -> (JUMPC _ _3620 lab lab)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("jge", "$3")), null, null, 0L, false, false, new int[]{3666, 22, 22}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_x86simd.rulev[4176] = new Rule(4176, false, false, 10, "4176: void -> (JUMPC _ _3621 lab lab)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("jb", "$3")), null, null, 0L, false, false, new int[]{3667, 22, 22}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_x86simd.rulev[4178] = new Rule(4178, false, false, 10, "4178: void -> (JUMPC _ _3622 lab lab)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("jbe", "$3")), null, null, 0L, false, false, new int[]{3668, 22, 22}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_x86simd.rulev[4180] = new Rule(4180, false, false, 10, "4180: void -> (JUMPC _ _3623 lab lab)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("ja", "$3")), null, null, 0L, false, false, new int[]{3669, 22, 22}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_x86simd.rulev[4182] = new Rule(4182, false, false, 10, "4182: void -> (JUMPC _ _3624 lab lab)", ImList.list(ImList.list("cmpl", "$2", "$1"), ImList.list("jae", "$3")), null, null, 0L, false, false, new int[]{3670, 22, 22}, new String[]{null, "*reg-I32*", null, null, null});
        CodeGenerator_x86simd.rulev[4186] = new Rule(4186, false, false, 10, "4186: void -> (JUMPC _ _3627 lab lab)", ImList.list(ImList.list("cmpw", "$2", "$1"), ImList.list("je", "$3")), null, null, 0L, false, false, new int[]{3673, 22, 22}, new String[]{null, "*reg-I16*", null, null, null});
        CodeGenerator_x86simd.rulev[4188] = new Rule(4188, false, false, 10, "4188: void -> (JUMPC _ _3628 lab lab)", ImList.list(ImList.list("cmpw", "$2", "$1"), ImList.list("jne", "$3")), null, null, 0L, false, false, new int[]{3674, 22, 22}, new String[]{null, "*reg-I16*", null, null, null});
        CodeGenerator_x86simd.rulev[4190] = new Rule(4190, false, false, 10, "4190: void -> (JUMPC _ _3629 lab lab)", ImList.list(ImList.list("cmpw", "$2", "$1"), ImList.list("jl", "$3")), null, null, 0L, false, false, new int[]{3675, 22, 22}, new String[]{null, "*reg-I16*", null, null, null});
        CodeGenerator_x86simd.rulev[4192] = new Rule(4192, false, false, 10, "4192: void -> (JUMPC _ _3630 lab lab)", ImList.list(ImList.list("cmpw", "$2", "$1"), ImList.list("jle", "$3")), null, null, 0L, false, false, new int[]{3676, 22, 22}, new String[]{null, "*reg-I16*", null, null, null});
        CodeGenerator_x86simd.rulev[4194] = new Rule(4194, false, false, 10, "4194: void -> (JUMPC _ _3631 lab lab)", ImList.list(ImList.list("cmpw", "$2", "$1"), ImList.list("jg", "$3")), null, null, 0L, false, false, new int[]{3677, 22, 22}, new String[]{null, "*reg-I16*", null, null, null});
        CodeGenerator_x86simd.rulev[4196] = new Rule(4196, false, false, 10, "4196: void -> (JUMPC _ _3632 lab lab)", ImList.list(ImList.list("cmpw", "$2", "$1"), ImList.list("jge", "$3")), null, null, 0L, false, false, new int[]{3678, 22, 22}, new String[]{null, "*reg-I16*", null, null, null});
        CodeGenerator_x86simd.rulev[4198] = new Rule(4198, false, false, 10, "4198: void -> (JUMPC _ _3633 lab lab)", ImList.list(ImList.list("cmpw", "$2", "$1"), ImList.list("jb", "$3")), null, null, 0L, false, false, new int[]{3679, 22, 22}, new String[]{null, "*reg-I16*", null, null, null});
        CodeGenerator_x86simd.rulev[4200] = new Rule(4200, false, false, 10, "4200: void -> (JUMPC _ _3634 lab lab)", ImList.list(ImList.list("cmpw", "$2", "$1"), ImList.list("jbe", "$3")), null, null, 0L, false, false, new int[]{3680, 22, 22}, new String[]{null, "*reg-I16*", null, null, null});
        CodeGenerator_x86simd.rulev[4202] = new Rule(4202, false, false, 10, "4202: void -> (JUMPC _ _3635 lab lab)", ImList.list(ImList.list("cmpw", "$2", "$1"), ImList.list("ja", "$3")), null, null, 0L, false, false, new int[]{3681, 22, 22}, new String[]{null, "*reg-I16*", null, null, null});
        CodeGenerator_x86simd.rulev[4204] = new Rule(4204, false, false, 10, "4204: void -> (JUMPC _ _3636 lab lab)", ImList.list(ImList.list("cmpw", "$2", "$1"), ImList.list("jae", "$3")), null, null, 0L, false, false, new int[]{3682, 22, 22}, new String[]{null, "*reg-I16*", null, null, null});
        CodeGenerator_x86simd.rulev[4208] = new Rule(4208, false, false, 10, "4208: void -> (JUMPC _ _3639 lab lab)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("je", "$3")), null, null, 0L, false, false, new int[]{3685, 22, 22}, new String[]{null, "*reg-I8*", null, null, null});
        CodeGenerator_x86simd.rulev[4210] = new Rule(4210, false, false, 10, "4210: void -> (JUMPC _ _3640 lab lab)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("jne", "$3")), null, null, 0L, false, false, new int[]{3686, 22, 22}, new String[]{null, "*reg-I8*", null, null, null});
        CodeGenerator_x86simd.rulev[4212] = new Rule(4212, false, false, 10, "4212: void -> (JUMPC _ _3641 lab lab)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("jl", "$3")), null, null, 0L, false, false, new int[]{3687, 22, 22}, new String[]{null, "*reg-I8*", null, null, null});
        CodeGenerator_x86simd.rulev[4214] = new Rule(4214, false, false, 10, "4214: void -> (JUMPC _ _3642 lab lab)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("jle", "$3")), null, null, 0L, false, false, new int[]{3688, 22, 22}, new String[]{null, "*reg-I8*", null, null, null});
        CodeGenerator_x86simd.rulev[4216] = new Rule(4216, false, false, 10, "4216: void -> (JUMPC _ _3643 lab lab)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("jg", "$3")), null, null, 0L, false, false, new int[]{3689, 22, 22}, new String[]{null, "*reg-I8*", null, null, null});
        CodeGenerator_x86simd.rulev[4218] = new Rule(4218, false, false, 10, "4218: void -> (JUMPC _ _3644 lab lab)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("jge", "$3")), null, null, 0L, false, false, new int[]{3690, 22, 22}, new String[]{null, "*reg-I8*", null, null, null});
        CodeGenerator_x86simd.rulev[4220] = new Rule(4220, false, false, 10, "4220: void -> (JUMPC _ _3645 lab lab)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("jb", "$3")), null, null, 0L, false, false, new int[]{3691, 22, 22}, new String[]{null, "*reg-I8*", null, null, null});
        CodeGenerator_x86simd.rulev[4222] = new Rule(4222, false, false, 10, "4222: void -> (JUMPC _ _3646 lab lab)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("jbe", "$3")), null, null, 0L, false, false, new int[]{3692, 22, 22}, new String[]{null, "*reg-I8*", null, null, null});
        CodeGenerator_x86simd.rulev[4224] = new Rule(4224, false, false, 10, "4224: void -> (JUMPC _ _3647 lab lab)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("ja", "$3")), null, null, 0L, false, false, new int[]{3693, 22, 22}, new String[]{null, "*reg-I8*", null, null, null});
        CodeGenerator_x86simd.rulev[4226] = new Rule(4226, false, false, 10, "4226: void -> (JUMPC _ _3648 lab lab)", ImList.list(ImList.list("cmpb", "$2", "$1"), ImList.list("jae", "$3")), null, null, 0L, false, false, new int[]{3694, 22, 22}, new String[]{null, "*reg-I8*", null, null, null});
        CodeGenerator_x86simd.rulev[4228] = new Rule(4228, false, false, 10, "4228: void -> (JUMPC _ _3649 lab lab)", ImList.list(ImList.list("cmpl", "$1", "$2"), ImList.list("je", "$3")), null, null, 0L, false, false, new int[]{3695, 22, 22}, new String[]{null, null, "*reg-I32*", null, null});
        CodeGenerator_x86simd.rulev[4230] = new Rule(4230, false, false, 10, "4230: void -> (JUMPC _ _3650 lab lab)", ImList.list(ImList.list("cmpl", "$1", "$2"), ImList.list("jne", "$3")), null, null, 0L, false, false, new int[]{3696, 22, 22}, new String[]{null, null, "*reg-I32*", null, null});
        CodeGenerator_x86simd.rulev[4232] = new Rule(4232, false, false, 10, "4232: void -> (JUMPC _ _3651 lab lab)", ImList.list(ImList.list("cmpl", "$1", "$2"), ImList.list("jg", "$3")), null, null, 0L, false, false, new int[]{3697, 22, 22}, new String[]{null, null, "*reg-I32*", null, null});
        CodeGenerator_x86simd.rulev[4234] = new Rule(4234, false, false, 10, "4234: void -> (JUMPC _ _3652 lab lab)", ImList.list(ImList.list("cmpl", "$1", "$2"), ImList.list("jge", "$3")), null, null, 0L, false, false, new int[]{3698, 22, 22}, new String[]{null, null, "*reg-I32*", null, null});
        CodeGenerator_x86simd.rulev[4236] = new Rule(4236, false, false, 10, "4236: void -> (JUMPC _ _3653 lab lab)", ImList.list(ImList.list("cmpl", "$1", "$2"), ImList.list("jl", "$3")), null, null, 0L, false, false, new int[]{3699, 22, 22}, new String[]{null, null, "*reg-I32*", null, null});
        CodeGenerator_x86simd.rulev[4238] = new Rule(4238, false, false, 10, "4238: void -> (JUMPC _ _3654 lab lab)", ImList.list(ImList.list("cmpl", "$1", "$2"), ImList.list("jle", "$3")), null, null, 0L, false, false, new int[]{3700, 22, 22}, new String[]{null, null, "*reg-I32*", null, null});
        CodeGenerator_x86simd.rulev[4240] = new Rule(4240, false, false, 10, "4240: void -> (JUMPC _ _3655 lab lab)", ImList.list(ImList.list("cmpl", "$1", "$2"), ImList.list("ja", "$3")), null, null, 0L, false, false, new int[]{3701, 22, 22}, new String[]{null, null, "*reg-I32*", null, null});
        CodeGenerator_x86simd.rulev[4242] = new Rule(4242, false, false, 10, "4242: void -> (JUMPC _ _3656 lab lab)", ImList.list(ImList.list("cmpl", "$1", "$2"), ImList.list("jae", "$3")), null, null, 0L, false, false, new int[]{3702, 22, 22}, new String[]{null, null, "*reg-I32*", null, null});
        CodeGenerator_x86simd.rulev[4244] = new Rule(4244, false, false, 10, "4244: void -> (JUMPC _ _3657 lab lab)", ImList.list(ImList.list("cmpl", "$1", "$2"), ImList.list("jb", "$3")), null, null, 0L, false, false, new int[]{3703, 22, 22}, new String[]{null, null, "*reg-I32*", null, null});
        CodeGenerator_x86simd.rulev[4246] = new Rule(4246, false, false, 10, "4246: void -> (JUMPC _ _3658 lab lab)", ImList.list(ImList.list("cmpl", "$1", "$2"), ImList.list("jbe", "$3")), null, null, 0L, false, false, new int[]{3704, 22, 22}, new String[]{null, null, "*reg-I32*", null, null});
        CodeGenerator_x86simd.rulev[4248] = new Rule(4248, false, false, 10, "4248: void -> (JUMPC _ _3659 lab lab)", ImList.list(ImList.list("cmpw", "$1", "$2"), ImList.list("je", "$3")), null, null, 0L, false, false, new int[]{3705, 22, 22}, new String[]{null, null, "*reg-I16*", null, null});
        CodeGenerator_x86simd.rulev[4250] = new Rule(4250, false, false, 10, "4250: void -> (JUMPC _ _3660 lab lab)", ImList.list(ImList.list("cmpw", "$1", "$2"), ImList.list("jne", "$3")), null, null, 0L, false, false, new int[]{3706, 22, 22}, new String[]{null, null, "*reg-I16*", null, null});
        CodeGenerator_x86simd.rulev[4252] = new Rule(4252, false, false, 10, "4252: void -> (JUMPC _ _3661 lab lab)", ImList.list(ImList.list("cmpw", "$1", "$2"), ImList.list("jg", "$3")), null, null, 0L, false, false, new int[]{3707, 22, 22}, new String[]{null, null, "*reg-I16*", null, null});
        CodeGenerator_x86simd.rulev[4254] = new Rule(4254, false, false, 10, "4254: void -> (JUMPC _ _3662 lab lab)", ImList.list(ImList.list("cmpw", "$1", "$2"), ImList.list("jge", "$3")), null, null, 0L, false, false, new int[]{3708, 22, 22}, new String[]{null, null, "*reg-I16*", null, null});
        CodeGenerator_x86simd.rulev[4256] = new Rule(4256, false, false, 10, "4256: void -> (JUMPC _ _3663 lab lab)", ImList.list(ImList.list("cmpw", "$1", "$2"), ImList.list("jl", "$3")), null, null, 0L, false, false, new int[]{3709, 22, 22}, new String[]{null, null, "*reg-I16*", null, null});
        CodeGenerator_x86simd.rulev[4258] = new Rule(4258, false, false, 10, "4258: void -> (JUMPC _ _3664 lab lab)", ImList.list(ImList.list("cmpw", "$1", "$2"), ImList.list("jle", "$3")), null, null, 0L, false, false, new int[]{3710, 22, 22}, new String[]{null, null, "*reg-I16*", null, null});
        CodeGenerator_x86simd.rulev[4260] = new Rule(4260, false, false, 10, "4260: void -> (JUMPC _ _3665 lab lab)", ImList.list(ImList.list("cmpw", "$1", "$2"), ImList.list("ja", "$3")), null, null, 0L, false, false, new int[]{3711, 22, 22}, new String[]{null, null, "*reg-I16*", null, null});
        CodeGenerator_x86simd.rulev[4262] = new Rule(4262, false, false, 10, "4262: void -> (JUMPC _ _3666 lab lab)", ImList.list(ImList.list("cmpw", "$1", "$2"), ImList.list("jae", "$3")), null, null, 0L, false, false, new int[]{3712, 22, 22}, new String[]{null, null, "*reg-I16*", null, null});
    }

    /*
     * Opcode count of 19372 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void rrinit4100() {
        CodeGenerator_x86simd.rulev[4264] = new Rule(4264, false, false, 10, "4264: void -> (JUMPC _ _3667 lab lab)", ImList.list(ImList.list("cmpw", "$1", "$2"), ImList.list("jb", "$3")), null, null, 0L, false, false, new int[]{3713, 22, 22}, new String[]{null, null, "*reg-I16*", null, null});
        CodeGenerator_x86simd.rulev[4266] = new Rule(4266, false, false, 10, "4266: void -> (JUMPC _ _3668 lab lab)", ImList.list(ImList.list("cmpw", "$1", "$2"), ImList.list("jbe", "$3")), null, null, 0L, false, false, new int[]{3714, 22, 22}, new String[]{null, null, "*reg-I16*", null, null});
        CodeGenerator_x86simd.rulev[4268] = new Rule(4268, false, false, 10, "4268: void -> (JUMPC _ _3669 lab lab)", ImList.list(ImList.list("cmpb", "$1", "$2"), ImList.list("je", "$3")), null, null, 0L, false, false, new int[]{3715, 22, 22}, new String[]{null, null, "*reg-I8*", null, null});
        CodeGenerator_x86simd.rulev[4270] = new Rule(4270, false, false, 10, "4270: void -> (JUMPC _ _3670 lab lab)", ImList.list(ImList.list("cmpb", "$1", "$2"), ImList.list("jne", "$3")), null, null, 0L, false, false, new int[]{3716, 22, 22}, new String[]{null, null, "*reg-I8*", null, null});
        CodeGenerator_x86simd.rulev[4272] = new Rule(4272, false, false, 10, "4272: void -> (JUMPC _ _3671 lab lab)", ImList.list(ImList.list("cmpb", "$1", "$2"), ImList.list("jg", "$3")), null, null, 0L, false, false, new int[]{3717, 22, 22}, new String[]{null, null, "*reg-I8*", null, null});
        CodeGenerator_x86simd.rulev[4274] = new Rule(4274, false, false, 10, "4274: void -> (JUMPC _ _3672 lab lab)", ImList.list(ImList.list("cmpb", "$1", "$2"), ImList.list("jge", "$3")), null, null, 0L, false, false, new int[]{3718, 22, 22}, new String[]{null, null, "*reg-I8*", null, null});
        CodeGenerator_x86simd.rulev[4276] = new Rule(4276, false, false, 10, "4276: void -> (JUMPC _ _3673 lab lab)", ImList.list(ImList.list("cmpb", "$1", "$2"), ImList.list("jl", "$3")), null, null, 0L, false, false, new int[]{3719, 22, 22}, new String[]{null, null, "*reg-I8*", null, null});
        CodeGenerator_x86simd.rulev[4278] = new Rule(4278, false, false, 10, "4278: void -> (JUMPC _ _3674 lab lab)", ImList.list(ImList.list("cmpb", "$1", "$2"), ImList.list("jle", "$3")), null, null, 0L, false, false, new int[]{3720, 22, 22}, new String[]{null, null, "*reg-I8*", null, null});
        CodeGenerator_x86simd.rulev[4280] = new Rule(4280, false, false, 10, "4280: void -> (JUMPC _ _3675 lab lab)", ImList.list(ImList.list("cmpb", "$1", "$2"), ImList.list("ja", "$3")), null, null, 0L, false, false, new int[]{3721, 22, 22}, new String[]{null, null, "*reg-I8*", null, null});
        CodeGenerator_x86simd.rulev[4282] = new Rule(4282, false, false, 10, "4282: void -> (JUMPC _ _3676 lab lab)", ImList.list(ImList.list("cmpb", "$1", "$2"), ImList.list("jae", "$3")), null, null, 0L, false, false, new int[]{3722, 22, 22}, new String[]{null, null, "*reg-I8*", null, null});
        CodeGenerator_x86simd.rulev[4284] = new Rule(4284, false, false, 10, "4284: void -> (JUMPC _ _3677 lab lab)", ImList.list(ImList.list("cmpb", "$1", "$2"), ImList.list("jb", "$3")), null, null, 0L, false, false, new int[]{3723, 22, 22}, new String[]{null, null, "*reg-I8*", null, null});
        CodeGenerator_x86simd.rulev[4286] = new Rule(4286, false, false, 10, "4286: void -> (JUMPC _ _3678 lab lab)", ImList.list(ImList.list("cmpb", "$1", "$2"), ImList.list("jbe", "$3")), null, null, 0L, false, false, new int[]{3724, 22, 22}, new String[]{null, null, "*reg-I8*", null, null});
        CodeGenerator_x86simd.rulev[4288] = new Rule(4288, false, false, 10, "4288: void -> (JUMPC _ _3679 lab lab)", ImList.list(ImList.list("comisl", "$2", "$1"), ImList.list("je", "$3")), null, null, 0L, false, false, new int[]{3725, 22, 22}, new String[]{null, "*reg-tmp-F64*", null, null, null});
        CodeGenerator_x86simd.rulev[4290] = new Rule(4290, false, false, 10, "4290: void -> (JUMPC _ _3680 lab lab)", ImList.list(ImList.list("comisl", "$2", "$1"), ImList.list("jne", "$3")), null, null, 0L, false, false, new int[]{3726, 22, 22}, new String[]{null, "*reg-tmp-F64*", null, null, null});
        CodeGenerator_x86simd.rulev[4292] = new Rule(4292, false, false, 10, "4292: void -> (JUMPC _ _3681 lab lab)", ImList.list(ImList.list("comiss", "$2", "$1"), ImList.list("je", "$3")), null, null, 0L, false, false, new int[]{3727, 22, 22}, new String[]{null, "*reg-tmp-F32*", null, null, null});
        CodeGenerator_x86simd.rulev[4294] = new Rule(4294, false, false, 10, "4294: void -> (JUMPC _ _3682 lab lab)", ImList.list(ImList.list("comiss", "$2", "$1"), ImList.list("jne", "$3")), null, null, 0L, false, false, new int[]{3728, 22, 22}, new String[]{null, "*reg-tmp-F32*", null, null, null});
        CodeGenerator_x86simd.rulev[4296] = new Rule(4296, false, false, 10, "4296: void -> (JUMPC _ _3683 lab lab)", ImList.list(ImList.list("comisl", "$2", "$1"), ImList.list("je", "$3")), null, null, 0L, false, false, new int[]{3729, 22, 22}, new String[]{null, "*reg-tmp-F64*", null, null, null});
        CodeGenerator_x86simd.rulev[4298] = new Rule(4298, false, false, 10, "4298: void -> (JUMPC _ _3684 lab lab)", ImList.list(ImList.list("comisl", "$2", "$1"), ImList.list("jne", "$3")), null, null, 0L, false, false, new int[]{3730, 22, 22}, new String[]{null, "*reg-tmp-F64*", null, null, null});
        CodeGenerator_x86simd.rulev[4300] = new Rule(4300, false, false, 10, "4300: void -> (JUMPC _ _3685 lab lab)", ImList.list(ImList.list("comiss", "$2", "$1"), ImList.list("je", "$3")), null, null, 0L, false, false, new int[]{3731, 22, 22}, new String[]{null, "*reg-tmp-F32*", null, null, null});
        CodeGenerator_x86simd.rulev[4302] = new Rule(4302, false, false, 10, "4302: void -> (JUMPC _ _3686 lab lab)", ImList.list(ImList.list("comiss", "$2", "$1"), ImList.list("jne", "$3")), null, null, 0L, false, false, new int[]{3732, 22, 22}, new String[]{null, "*reg-tmp-F32*", null, null, null});
        CodeGenerator_x86simd.rulev[4304] = new Rule(4304, false, false, 10, "4304: void -> (JUMPC _ _3687 lab lab)", ImList.list(ImList.list("comisl", "$2", "$1"), ImList.list("je", "$3")), null, null, 0L, false, false, new int[]{3733, 22, 22}, new String[]{null, "*reg-tmp-F64*", null, null, null});
        CodeGenerator_x86simd.rulev[4306] = new Rule(4306, false, false, 10, "4306: void -> (JUMPC _ _3688 lab lab)", ImList.list(ImList.list("comisl", "$2", "$1"), ImList.list("jne", "$3")), null, null, 0L, false, false, new int[]{3734, 22, 22}, new String[]{null, "*reg-tmp-F64*", null, null, null});
        CodeGenerator_x86simd.rulev[4308] = new Rule(4308, false, false, 10, "4308: void -> (JUMPC _ _3689 lab lab)", ImList.list(ImList.list("comiss", "$2", "$1"), ImList.list("je", "$3")), null, null, 0L, false, false, new int[]{3735, 22, 22}, new String[]{null, "*reg-tmp-F32*", null, null, null});
        CodeGenerator_x86simd.rulev[4310] = new Rule(4310, false, false, 10, "4310: void -> (JUMPC _ _3690 lab lab)", ImList.list(ImList.list("comiss", "$2", "$1"), ImList.list("jne", "$3")), null, null, 0L, false, false, new int[]{3736, 22, 22}, new String[]{null, "*reg-tmp-F32*", null, null, null});
        CodeGenerator_x86simd.rulev[4311] = new Rule(4311, false, false, 10, "4311: void -> (CALL _ callarg)", ImList.list(ImList.list("call", "$1")), null, null, 0L, false, false, new int[]{48}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[131] = new Rule(131, false, false, 10, "131: void -> (PARALLEL _ _8 _10 _12 _14 _16 _19 _22 _25 _27 _30 _33 _36 _39 _42 _45 _48)", ImList.list(ImList.list("movdqu", "$2", "$1")), null, null, 0L, false, false, new int[]{51, 53, 55, 57, 59, 62, 65, 68, 70, 73, 76, 79, 82, 85, 88, 91}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null});
        CodeGenerator_x86simd.rulev[148] = new Rule(148, false, false, 10, "148: void -> (PARALLEL _ _50 _52 _54 _56 _58 _60 _62 _64)", ImList.list(ImList.list("movdqu", "$2", "$1")), null, null, 0L, false, false, new int[]{93, 95, 97, 99, 101, 103, 105, 107}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null});
        CodeGenerator_x86simd.rulev[157] = new Rule(157, false, false, 10, "157: void -> (PARALLEL _ _66 _68 _70 _72)", ImList.list(ImList.list("movdqu", "$2", "$1")), null, null, 0L, false, false, new int[]{109, 111, 113, 115}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null});
        CodeGenerator_x86simd.rulev[174] = new Rule(174, false, false, 10, "174: void -> (PARALLEL _ _73 _74 _75 _76 _77 _78 _79 _80 _81 _82 _83 _84 _85 _86 _87 _88)", ImList.list(ImList.list("movdqu", "$2", "$1")), null, null, 0L, false, false, new int[]{116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131}, new String[]{null, null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[183] = new Rule(183, false, false, 10, "183: void -> (PARALLEL _ _89 _90 _91 _92 _93 _94 _95 _96)", ImList.list(ImList.list("movdqu", "$2", "$1")), null, null, 0L, false, false, new int[]{132, 133, 134, 135, 136, 137, 138, 139}, new String[]{null, null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[188] = new Rule(188, false, false, 10, "188: void -> (PARALLEL _ _97 _98 _99 _100)", ImList.list(ImList.list("movdqu", "$2", "$1")), null, null, 0L, false, false, new int[]{140, 141, 142, 143}, new String[]{null, null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[205] = new Rule(205, false, false, 10, "205: void -> (PARALLEL _ _102 _104 _106 _108 _110 _112 _114 _116)", ImList.list(ImList.list("movq", "$2", "$1")), null, null, 0L, false, false, new int[]{145, 147, 149, 151, 153, 155, 157, 159}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", null, "*reg-simd-I64*", null, "*reg-simd-I64*", null, "*reg-simd-I64*", null, "*reg-simd-I64*", null, "*reg-simd-I64*", null, "*reg-simd-I64*", null});
        CodeGenerator_x86simd.rulev[214] = new Rule(214, false, false, 10, "214: void -> (PARALLEL _ _118 _120 _122 _124)", ImList.list(ImList.list("movq", "$2", "$1")), null, null, 0L, false, false, new int[]{161, 163, 165, 167}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", null, "*reg-simd-I64*", null, "*reg-simd-I64*", null});
        CodeGenerator_x86simd.rulev[219] = new Rule(219, false, false, 10, "219: void -> (PARALLEL _ _126 _128)", ImList.list(ImList.list("movq", "$2", "$1")), null, null, 0L, false, false, new int[]{169, 171}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", null});
        CodeGenerator_x86simd.rulev[228] = new Rule(228, false, false, 10, "228: void -> (PARALLEL _ _129 _130 _131 _132 _133 _134 _135 _136)", ImList.list(ImList.list("movq", "$2", "$1")), null, null, 0L, false, false, new int[]{172, 173, 174, 175, 176, 177, 178, 179}, new String[]{null, null, "*reg-simd-I64*", null, "*reg-simd-I64*", null, "*reg-simd-I64*", null, "*reg-simd-I64*", null, "*reg-simd-I64*", null, "*reg-simd-I64*", null, "*reg-simd-I64*", null, "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[233] = new Rule(233, false, false, 10, "233: void -> (PARALLEL _ _137 _138 _139 _140)", ImList.list(ImList.list("movq", "$2", "$1")), null, null, 0L, false, false, new int[]{180, 181, 182, 183}, new String[]{null, null, "*reg-simd-I64*", null, "*reg-simd-I64*", null, "*reg-simd-I64*", null, "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[236] = new Rule(236, false, false, 10, "236: void -> (PARALLEL _ _141 _142)", ImList.list(ImList.list("movq", "$2", "$1")), null, null, 0L, false, false, new int[]{184, 185}, new String[]{null, null, "*reg-simd-I64*", null, "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[297] = new Rule(297, false, false, 10, "297: void -> (PARALLEL _ _144 _146 _148 _150 _152 _154 _156 _158 _160 _162 _164 _166 _168 _170 _172 _174)", new ImList(ImList.list("movb", "$2", "%dl"), new ImList(ImList.list("movb", "$2", "%dh"), new ImList(ImList.list("pinsrw", ImList.list("imm", "0"), "%edx", "$1"), new ImList(ImList.list("pinsrw", ImList.list("imm", "1"), "%edx", "$1"), new ImList(ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "$1"), ImList.list(ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "4"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "5"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "6"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "7"), "%edx", "$1"))))))), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{187, 189, 191, 193, 195, 197, 199, 201, 203, 205, 207, 209, 211, 213, 215, 217}, new String[]{null, null, "*reg-I8*", null, "*reg-I8*", null, "*reg-I8*", null, "*reg-I8*", null, "*reg-I8*", null, "*reg-I8*", null, "*reg-I8*", null, "*reg-I8*", null, "*reg-I8*", null, "*reg-I8*", null, "*reg-I8*", null, "*reg-I8*", null, "*reg-I8*", null, "*reg-I8*", null, "*reg-I8*", null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[330] = new Rule(330, false, false, 10, "330: void -> (PARALLEL _ _176 _178 _180 _182 _184 _186 _188 _190)", new ImList(ImList.list("movw", "$2", "%dx"), new ImList(ImList.list("pinsrw", ImList.list("imm", "0"), "%edx", "$1"), new ImList(ImList.list("pinsrw", ImList.list("imm", "1"), "%edx", "$1"), new ImList(ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "$1"), ImList.list(ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "4"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "5"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "6"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "7"), "%edx", "$1")))))), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{219, 221, 223, 225, 227, 229, 231, 233}, new String[]{null, null, "*reg-I16*", null, "*reg-I16*", null, "*reg-I16*", null, "*reg-I16*", null, "*reg-I16*", null, "*reg-I16*", null, "*reg-I16*", null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[347] = new Rule(347, false, false, 10, "347: void -> (PARALLEL _ _192 _194 _196 _198)", new ImList(ImList.list("movd", "$2", "$1"), new ImList(ImList.list("pinsrw", ImList.list("imm", "2"), "$2", "$1"), new ImList(ImList.list("pinsrw", ImList.list("imm", "4"), "$2", "$1"), new ImList(ImList.list("pinsrw", ImList.list("imm", "6"), "$2", "$1"), ImList.list(ImList.list("rol", ImList.list("imm", "16"), "$2"), ImList.list("pinsrw", ImList.list("imm", "3"), "$2", "$1"), ImList.list("pinsrw", ImList.list("imm", "5"), "$2", "$1"), ImList.list("pinsrw", ImList.list("imm", "7"), "$2", "$1"), ImList.list("rol", ImList.list("imm", "16"), "$2")))))), null, null, 0L, false, false, new int[]{235, 237, 239, 241}, new String[]{null, null, "*reg-I32*", null, "*reg-I32*", null, "*reg-I32*", null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[382] = new Rule(382, false, false, 10, "382: void -> (PARALLEL _ _200 _202 _204 _206 _208 _210 _212 _214)", new ImList(ImList.list("movb", "$2", "%dl"), ImList.list(ImList.list("movb", "$2", "%dh"), ImList.list("pinsrw", ImList.list("imm", "0"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "1"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "$1"))), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{243, 245, 247, 249, 251, 253, 255, 257}, new String[]{null, null, "*reg-I8*", null, "*reg-I8*", null, "*reg-I8*", null, "*reg-I8*", null, "*reg-I8*", null, "*reg-I8*", null, "*reg-I8*", null, "*reg-I8*"});
        CodeGenerator_x86simd.rulev[399] = new Rule(399, false, false, 10, "399: void -> (PARALLEL _ _216 _218 _220 _222)", ImList.list(ImList.list("movw", "$2", "%dx"), ImList.list("pinsrw", ImList.list("imm", "0"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "1"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{259, 261, 263, 265}, new String[]{null, null, "*reg-I16*", null, "*reg-I16*", null, "*reg-I16*", null, "*reg-I16*"});
        CodeGenerator_x86simd.rulev[408] = new Rule(408, false, false, 10, "408: void -> (PARALLEL _ _224 _226)", ImList.list(ImList.list("movd", "$2", "$1"), ImList.list("pinsrw", ImList.list("imm", "2"), "$2", "$1"), ImList.list("rol", ImList.list("imm", "16"), "$2"), ImList.list("pinsrw", ImList.list("imm", "3"), "$2", "$1"), ImList.list("rol", ImList.list("imm", "16"), "$2")), null, null, 0L, false, false, new int[]{267, 269}, new String[]{null, null, "*reg-I32*", null, "*reg-I32*"});
        CodeGenerator_x86simd.rulev[419] = new Rule(419, false, false, 10, "419: void -> (PARALLEL _ _227 _228 _229 _230 _231 _232 _233 _234)", new ImList(ImList.list("movb", ImList.list("imm", "$2"), "%dl"), ImList.list(ImList.list("movb", ImList.list("imm", "$2"), "%dh"), ImList.list("pinsrw", ImList.list("imm", "0"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "1"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "$1"))), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{270, 271, 272, 273, 274, 275, 276, 277}, new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null});
        CodeGenerator_x86simd.rulev[424] = new Rule(424, false, false, 10, "424: void -> (PARALLEL _ _235 _236 _237 _238)", ImList.list(ImList.list("movw", ImList.list("imm", "$2"), "%dx"), ImList.list("pinsrw", ImList.list("imm", "0"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "1"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{278, 279, 280, 281}, new String[]{null, null, null, null, null, null, null, null, null});
        CodeGenerator_x86simd.rulev[427] = new Rule(427, false, false, 10, "427: void -> (PARALLEL _ _239 _240)", ImList.list(ImList.list("movl", ImList.list("imm", "$2"), "%edx"), ImList.list("movd", "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "$1"), ImList.list("rol", ImList.list("imm", "16"), "%edx"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "$1")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{282, 283}, new String[]{null, null, null, null, null});
        CodeGenerator_x86simd.rulev[444] = new Rule(444, false, false, 10, "444: void -> (PARALLEL _ _241 _242 _243 _244 _245 _246 _247 _248 _249 _250 _251 _252 _253 _254 _255 _256)", new ImList(ImList.list("movb", ImList.list("imm", "$2"), "%dl"), new ImList(ImList.list("movb", ImList.list("imm", "$2"), "%dh"), new ImList(ImList.list("pinsrw", ImList.list("imm", "0"), "%edx", "$1"), new ImList(ImList.list("pinsrw", ImList.list("imm", "1"), "%edx", "$1"), new ImList(ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "$1"), ImList.list(ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "4"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "5"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "6"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "7"), "%edx", "$1"))))))), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299}, new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null});
        CodeGenerator_x86simd.rulev[453] = new Rule(453, false, false, 10, "453: void -> (PARALLEL _ _257 _258 _259 _260 _261 _262 _263 _264)", new ImList(ImList.list("movw", ImList.list("imm", "$2"), "%dx"), new ImList(ImList.list("pinsrw", ImList.list("imm", "0"), "%edx", "$1"), new ImList(ImList.list("pinsrw", ImList.list("imm", "1"), "%edx", "$1"), new ImList(ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "$1"), ImList.list(ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "4"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "5"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "6"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "7"), "%edx", "$1")))))), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{300, 301, 302, 303, 304, 305, 306, 307}, new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null});
        CodeGenerator_x86simd.rulev[458] = new Rule(458, false, false, 10, "458: void -> (PARALLEL _ _265 _266 _267 _268)", new ImList(ImList.list("movl", ImList.list("imm", "$2"), "%edx"), new ImList(ImList.list("movd", "%edx", "$1"), new ImList(ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "$1"), new ImList(ImList.list("pinsrw", ImList.list("imm", "4"), "%edx", "$1"), ImList.list(ImList.list("pinsrw", ImList.list("imm", "6"), "%edx", "$1"), ImList.list("rol", ImList.list("imm", "16"), "%edx"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "5"), "%edx", "$1"), ImList.list("pinsrw", ImList.list("imm", "7"), "%edx", "$1")))))), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{308, 309, 310, 311}, new String[]{null, null, null, null, null, null, null, null, null});
        CodeGenerator_x86simd.rulev[627] = new Rule(627, false, false, 10, "627: void -> (PARALLEL _ _379 _435)", ImList.list(ImList.list("psadbw", "$3", "$2"), ImList.list("movd", "$2", "%eax"), ImList.list("pextrw", ImList.list("imm", "4"), "$2", "%edx"), ImList.list("addl", "%edx", "%eax")), null, ImList.list(ImList.list("REG", "I32", "%edx")), 0L, false, false, new int[]{422, 478}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[661] = new Rule(661, false, false, 10, "661: void -> (PARALLEL _ _440 _444 _448 _452 _456 _460 _464 _468)", ImList.list(ImList.list("pavgb", "$3", "$2")), null, null, 0L, false, false, new int[]{483, 487, 491, 495, 499, 503, 507, 511}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[710] = new Rule(710, false, false, 10, "710: void -> (PARALLEL _ _474 _480 _486 _492 _498 _504 _510 _516)", ImList.list(ImList.list("pavgb", "$3", "$2")), null, null, 0L, false, false, new int[]{517, 523, 529, 535, 541, 547, 553, 559}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[775] = new Rule(775, false, false, 10, "775: void -> (PARALLEL _ _520 _524 _528 _532 _536 _540 _544 _548 _552 _556 _560 _564 _568 _572 _576 _580)", ImList.list(ImList.list("pavgb", "$3", "$2")), null, null, 0L, false, false, new int[]{563, 567, 571, 575, 579, 583, 587, 591, 595, 599, 603, 607, 611, 615, 619, 623}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[872] = new Rule(872, false, false, 10, "872: void -> (PARALLEL _ _586 _592 _598 _604 _610 _616 _622 _628 _634 _640 _646 _652 _658 _664 _670 _676)", ImList.list(ImList.list("pavgb", "$3", "$2")), null, null, 0L, false, false, new int[]{629, 635, 641, 647, 653, 659, 665, 671, 677, 683, 689, 695, 701, 707, 713, 719}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[890] = new Rule(890, false, false, 10, "890: void -> (PARALLEL _ _681 _685 _689 _693)", ImList.list(ImList.list("pavgw", "$3", "$2")), null, null, 0L, false, false, new int[]{724, 728, 732, 736}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[915] = new Rule(915, false, false, 10, "915: void -> (PARALLEL _ _699 _705 _711 _717)", ImList.list(ImList.list("pavgw", "$3", "$2")), null, null, 0L, false, false, new int[]{742, 748, 754, 760}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[948] = new Rule(948, false, false, 10, "948: void -> (PARALLEL _ _721 _725 _729 _733 _737 _741 _745 _749)", ImList.list(ImList.list("pavgw", "$3", "$2")), null, null, 0L, false, false, new int[]{764, 768, 772, 776, 780, 784, 788, 792}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[997] = new Rule(997, false, false, 10, "997: void -> (PARALLEL _ _755 _761 _767 _773 _779 _785 _791 _797)", ImList.list(ImList.list("pavgw", "$3", "$2")), null, null, 0L, false, false, new int[]{798, 804, 810, 816, 822, 828, 834, 840}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[1046] = new Rule(1046, false, false, 10, "1046: void -> (PARALLEL _ _803 _809 _815 _821 _827 _833 _839 _845)", ImList.list(ImList.list("pmaxub", "$4", "$3")), null, null, 0L, false, false, new int[]{846, 852, 858, 864, 870, 876, 882, 888}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[1095] = new Rule(1095, false, false, 10, "1095: void -> (PARALLEL _ _851 _857 _863 _869 _875 _881 _887 _893)", ImList.list(ImList.list("pminub", "$4", "$3")), null, null, 0L, false, false, new int[]{894, 900, 906, 912, 918, 924, 930, 936}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[1192] = new Rule(1192, false, false, 10, "1192: void -> (PARALLEL _ _899 _905 _911 _917 _923 _929 _935 _941 _947 _953 _959 _965 _971 _977 _983 _989)", ImList.list(ImList.list("pmaxub", "$4", "$3")), null, null, 0L, false, false, new int[]{942, 948, 954, 960, 966, 972, 978, 984, 990, 996, 1002, 1008, 1014, 1020, 1026, 1032}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[1289] = new Rule(1289, false, false, 10, "1289: void -> (PARALLEL _ _995 _1001 _1007 _1013 _1019 _1025 _1031 _1037 _1043 _1049 _1055 _1061 _1067 _1073 _1079 _1085)", ImList.list(ImList.list("pminub", "$4", "$3")), null, null, 0L, false, false, new int[]{1038, 1044, 1050, 1056, 1062, 1068, 1074, 1080, 1086, 1092, 1098, 1104, 1110, 1116, 1122, 1128}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[1314] = new Rule(1314, false, false, 10, "1314: void -> (PARALLEL _ _1091 _1097 _1103 _1109)", ImList.list(ImList.list("pmaxsw", "$4", "$3")), null, null, 0L, false, false, new int[]{1134, 1140, 1146, 1152}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[1339] = new Rule(1339, false, false, 10, "1339: void -> (PARALLEL _ _1115 _1121 _1127 _1133)", ImList.list(ImList.list("pminsw", "$4", "$3")), null, null, 0L, false, false, new int[]{1158, 1164, 1170, 1176}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[1388] = new Rule(1388, false, false, 10, "1388: void -> (PARALLEL _ _1139 _1145 _1151 _1157 _1163 _1169 _1175 _1181)", ImList.list(ImList.list("pmaxsw", "$4", "$3")), null, null, 0L, false, false, new int[]{1182, 1188, 1194, 1200, 1206, 1212, 1218, 1224}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[1437] = new Rule(1437, false, false, 10, "1437: void -> (PARALLEL _ _1187 _1193 _1199 _1205 _1211 _1217 _1223 _1229)", ImList.list(ImList.list("pminsw", "$4", "$3")), null, null, 0L, false, false, new int[]{1230, 1236, 1242, 1248, 1254, 1260, 1266, 1272}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[1486] = new Rule(1486, false, false, 10, "1486: void -> (PARALLEL _ _1235 _1241 _1247 _1253 _1259 _1265 _1271 _1277)", ImList.list(ImList.list("pcmpeqb", "$4", "$3")), null, null, 0L, false, false, new int[]{1278, 1284, 1290, 1296, 1302, 1308, 1314, 1320}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[1535] = new Rule(1535, false, false, 10, "1535: void -> (PARALLEL _ _1283 _1289 _1295 _1301 _1307 _1313 _1319 _1325)", ImList.list(ImList.list("pcmpgtb", "$4", "$3")), null, null, 0L, false, false, new int[]{1326, 1332, 1338, 1344, 1350, 1356, 1362, 1368}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[1560] = new Rule(1560, false, false, 10, "1560: void -> (PARALLEL _ _1331 _1337 _1343 _1349)", ImList.list(ImList.list("pcmpeqw", "$4", "$3")), null, null, 0L, false, false, new int[]{1374, 1380, 1386, 1392}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[1585] = new Rule(1585, false, false, 10, "1585: void -> (PARALLEL _ _1355 _1361 _1367 _1373)", ImList.list(ImList.list("pcmpgtw", "$4", "$3")), null, null, 0L, false, false, new int[]{1398, 1404, 1410, 1416}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[1598] = new Rule(1598, false, false, 10, "1598: void -> (PARALLEL _ _1379 _1385)", ImList.list(ImList.list("pcmpeqd", "$4", "$3")), null, null, 0L, false, false, new int[]{1422, 1428}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[1611] = new Rule(1611, false, false, 10, "1611: void -> (PARALLEL _ _1391 _1397)", ImList.list(ImList.list("pcmpgtd", "$4", "$3")), null, null, 0L, false, false, new int[]{1434, 1440}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[1708] = new Rule(1708, false, false, 10, "1708: void -> (PARALLEL _ _1403 _1409 _1415 _1421 _1427 _1433 _1439 _1445 _1451 _1457 _1463 _1469 _1475 _1481 _1487 _1493)", ImList.list(ImList.list("pcmpeqb", "$4", "$3")), null, null, 0L, false, false, new int[]{1446, 1452, 1458, 1464, 1470, 1476, 1482, 1488, 1494, 1500, 1506, 1512, 1518, 1524, 1530, 1536}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[1805] = new Rule(1805, false, false, 10, "1805: void -> (PARALLEL _ _1499 _1505 _1511 _1517 _1523 _1529 _1535 _1541 _1547 _1553 _1559 _1565 _1571 _1577 _1583 _1589)", ImList.list(ImList.list("pcmpgtb", "$4", "$3")), null, null, 0L, false, false, new int[]{1542, 1548, 1554, 1560, 1566, 1572, 1578, 1584, 1590, 1596, 1602, 1608, 1614, 1620, 1626, 1632}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[1854] = new Rule(1854, false, false, 10, "1854: void -> (PARALLEL _ _1595 _1601 _1607 _1613 _1619 _1625 _1631 _1637)", ImList.list(ImList.list("pcmpeqw", "$4", "$3")), null, null, 0L, false, false, new int[]{1638, 1644, 1650, 1656, 1662, 1668, 1674, 1680}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[1903] = new Rule(1903, false, false, 10, "1903: void -> (PARALLEL _ _1643 _1649 _1655 _1661 _1667 _1673 _1679 _1685)", ImList.list(ImList.list("pcmpgtw", "$4", "$3")), null, null, 0L, false, false, new int[]{1686, 1692, 1698, 1704, 1710, 1716, 1722, 1728}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[1928] = new Rule(1928, false, false, 10, "1928: void -> (PARALLEL _ _1691 _1697 _1703 _1709)", ImList.list(ImList.list("pcmpeqd", "$4", "$3")), null, null, 0L, false, false, new int[]{1734, 1740, 1746, 1752}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[1953] = new Rule(1953, false, false, 10, "1953: void -> (PARALLEL _ _1715 _1721 _1727 _1733)", ImList.list(ImList.list("pcmpgtd", "$4", "$3")), null, null, 0L, false, false, new int[]{1758, 1764, 1770, 1776}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[2002] = new Rule(2002, false, false, 10, "2002: void -> (PARALLEL _ _1739 _1745 _1751 _1757 _1763 _1769 _1775 _1781)", new ImList(ImList.list("pcmpeqb", "$4", "$3"), ImList.list(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), ImList.list("movd", "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%MM7"), ImList.list("pxor", "%MM7", "$3"))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{1782, 1788, 1794, 1800, 1806, 1812, 1818, 1824}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[2035] = new Rule(2035, false, false, 10, "2035: void -> (PARALLEL _ _1785 _1789 _1793 _1797 _1801 _1805 _1809 _1813)", new ImList(ImList.list("pcmpgtb", "$4", "$3"), ImList.list(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), ImList.list("movd", "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%MM7"), ImList.list("pxor", "%MM7", "$3"))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{1828, 1832, 1836, 1840, 1844, 1848, 1852, 1856}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[2060] = new Rule(2060, false, false, 10, "2060: void -> (PARALLEL _ _1819 _1825 _1831 _1837)", new ImList(ImList.list("pcmpeqw", "$4", "$3"), ImList.list(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), ImList.list("movd", "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%MM7"), ImList.list("pxor", "%MM7", "$3"))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{1862, 1868, 1874, 1880}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[2085] = new Rule(2085, false, false, 10, "2085: void -> (PARALLEL _ _1843 _1849 _1855 _1861)", new ImList(ImList.list("pcmpgtw", "$4", "$3"), ImList.list(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), ImList.list("movd", "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%MM7"), ImList.list("pxor", "%MM7", "$3"))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{1886, 1892, 1898, 1904}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[2098] = new Rule(2098, false, false, 10, "2098: void -> (PARALLEL _ _1867 _1873)", new ImList(ImList.list("pcmpeqd", "$4", "$3"), ImList.list(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), ImList.list("movd", "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%MM7"), ImList.list("pxor", "%MM7", "$3"))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{1910, 1916}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[2111] = new Rule(2111, false, false, 10, "2111: void -> (PARALLEL _ _1879 _1885)", new ImList(ImList.list("pcmpgtd", "$4", "$3"), ImList.list(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), ImList.list("movd", "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%MM7"), ImList.list("pxor", "%MM7", "$3"))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{1922, 1928}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[2208] = new Rule(2208, false, false, 10, "2208: void -> (PARALLEL _ _1891 _1897 _1903 _1909 _1915 _1921 _1927 _1933 _1939 _1945 _1951 _1957 _1963 _1969 _1975 _1981)", new ImList(ImList.list("pcmpeqb", "$4", "$3"), new ImList(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), new ImList(ImList.list("movd", "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%XMM7"), ImList.list(ImList.list("pinsrw", ImList.list("imm", "4"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "5"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "6"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "7"), "%edx", "%XMM7"), ImList.list("pxor", "%XMM7", "$3"))))))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{1934, 1940, 1946, 1952, 1958, 1964, 1970, 1976, 1982, 1988, 1994, 2000, 2006, 2012, 2018, 2024}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[2273] = new Rule(2273, false, false, 10, "2273: void -> (PARALLEL _ _1985 _1989 _1993 _1997 _2001 _2005 _2009 _2013 _2017 _2021 _2025 _2029 _2033 _2037 _2041 _2045)", new ImList(ImList.list("pcmpgtb", "$4", "$3"), new ImList(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), new ImList(ImList.list("movd", "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%XMM7"), ImList.list(ImList.list("pinsrw", ImList.list("imm", "4"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "5"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "6"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "7"), "%edx", "%XMM7"), ImList.list("pxor", "%XMM7", "$3"))))))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{2028, 2032, 2036, 2040, 2044, 2048, 2052, 2056, 2060, 2064, 2068, 2072, 2076, 2080, 2084, 2088}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[2322] = new Rule(2322, false, false, 10, "2322: void -> (PARALLEL _ _2051 _2057 _2063 _2069 _2075 _2081 _2087 _2093)", new ImList(ImList.list("pcmpeqw", "$4", "$3"), new ImList(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), new ImList(ImList.list("movd", "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%XMM7"), ImList.list(ImList.list("pinsrw", ImList.list("imm", "4"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "5"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "6"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "7"), "%edx", "%XMM7"), ImList.list("pxor", "%XMM7", "$3"))))))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{2094, 2100, 2106, 2112, 2118, 2124, 2130, 2136}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[2371] = new Rule(2371, false, false, 10, "2371: void -> (PARALLEL _ _2099 _2105 _2111 _2117 _2123 _2129 _2135 _2141)", new ImList(ImList.list("pcmpgtw", "$4", "$3"), new ImList(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), new ImList(ImList.list("movd", "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%XMM7"), ImList.list(ImList.list("pinsrw", ImList.list("imm", "4"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "5"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "6"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "7"), "%edx", "%XMM7"), ImList.list("pxor", "%XMM7", "$3"))))))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{2142, 2148, 2154, 2160, 2166, 2172, 2178, 2184}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[2396] = new Rule(2396, false, false, 10, "2396: void -> (PARALLEL _ _2147 _2153 _2159 _2165)", new ImList(ImList.list("pcmpeqd", "$4", "$3"), new ImList(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), new ImList(ImList.list("movd", "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%XMM7"), ImList.list(ImList.list("pinsrw", ImList.list("imm", "4"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "5"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "6"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "7"), "%edx", "%XMM7"), ImList.list("pxor", "%XMM7", "$3"))))))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{2190, 2196, 2202, 2208}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[2421] = new Rule(2421, false, false, 10, "2421: void -> (PARALLEL _ _2171 _2177 _2183 _2189)", new ImList(ImList.list("pcmpgtd", "$4", "$3"), new ImList(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), new ImList(ImList.list("movd", "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%XMM7"), ImList.list(ImList.list("pinsrw", ImList.list("imm", "4"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "5"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "6"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "7"), "%edx", "%XMM7"), ImList.list("pxor", "%XMM7", "$3"))))))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{2214, 2220, 2226, 2232}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[2470] = new Rule(2470, false, false, 10, "2470: void -> (PARALLEL _ _2195 _2201 _2207 _2213 _2219 _2225 _2231 _2237)", ImList.list(ImList.list("movq", "$3", "%MM7"), ImList.list("pcmpgtb", "$4", "$3"), ImList.list("pcmpeqb", "$4", "%MM7"), ImList.list("por", "%MM7", "$3")), null, ImList.list(ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{2238, 2244, 2250, 2256, 2262, 2268, 2274, 2280}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[2487] = new Rule(2487, false, false, 10, "2487: void -> (PARALLEL _ _2241 _2245 _2249 _2253)", ImList.list(ImList.list("movq", "$3", "%MM7"), ImList.list("pcmpgtw", "$4", "$3"), ImList.list("pcmpeqw", "$4", "%MM7"), ImList.list("por", "%MM7", "$3")), null, ImList.list(ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{2284, 2288, 2292, 2296}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[2500] = new Rule(2500, false, false, 10, "2500: void -> (PARALLEL _ _2259 _2265)", ImList.list(ImList.list("movq", "$3", "%MM7"), ImList.list("pcmpgtd", "$4", "$3"), ImList.list("pcmpeqd", "$4", "%MM7"), ImList.list("por", "%MM7", "$3")), null, ImList.list(ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{2302, 2308}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[2597] = new Rule(2597, false, false, 10, "2597: void -> (PARALLEL _ _2271 _2277 _2283 _2289 _2295 _2301 _2307 _2313 _2319 _2325 _2331 _2337 _2343 _2349 _2355 _2361)", ImList.list(ImList.list("movdqu", "$3", "%XMM7"), ImList.list("pcmpgtb", "$4", "$3"), ImList.list("pcmpeqb", "$4", "%XMM7"), ImList.list("por", "%XMM7", "$3")), null, ImList.list(ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{2314, 2320, 2326, 2332, 2338, 2344, 2350, 2356, 2362, 2368, 2374, 2380, 2386, 2392, 2398, 2404}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[2630] = new Rule(2630, false, false, 10, "2630: void -> (PARALLEL _ _2365 _2369 _2373 _2377 _2381 _2385 _2389 _2393)", ImList.list(ImList.list("movdqu", "$3", "%XMM7"), ImList.list("pcmpgtw", "$4", "$3"), ImList.list("pcmpeqw", "$4", "%XMM7"), ImList.list("por", "%XMM7", "$3")), null, ImList.list(ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{2408, 2412, 2416, 2420, 2424, 2428, 2432, 2436}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[2655] = new Rule(2655, false, false, 10, "2655: void -> (PARALLEL _ _2399 _2405 _2411 _2417)", ImList.list(ImList.list("movdqu", "$3", "%XMM7"), ImList.list("pcmpgtd", "$4", "$3"), ImList.list("pcmpeqd", "$4", "%XMM7"), ImList.list("por", "%XMM7", "$3")), null, ImList.list(ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{2442, 2448, 2454, 2460}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[2704] = new Rule(2704, false, false, 10, "2704: void -> (PARALLEL _ _2423 _2429 _2435 _2441 _2447 _2453 _2459 _2465)", new ImList(ImList.list("movq", "$3", "%MM7"), new ImList(ImList.list("pcmpgtb", "$4", "$3"), new ImList(ImList.list("pcmpeqb", "$4", "%MM7"), new ImList(ImList.list("por", "%MM7", "$3"), ImList.list(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), ImList.list("movd", "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%MM7"), ImList.list("pxor", "%MM7", "$3")))))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{2466, 2472, 2478, 2484, 2490, 2496, 2502, 2508}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[2721] = new Rule(2721, false, false, 10, "2721: void -> (PARALLEL _ _2469 _2473 _2477 _2481)", new ImList(ImList.list("movq", "$3", "%MM7"), new ImList(ImList.list("pcmpgtw", "$4", "$3"), new ImList(ImList.list("pcmpeqw", "$4", "%MM7"), new ImList(ImList.list("por", "%MM7", "$3"), ImList.list(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), ImList.list("movd", "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%MM7"), ImList.list("pxor", "%MM7", "$3")))))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{2512, 2516, 2520, 2524}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[2734] = new Rule(2734, false, false, 10, "2734: void -> (PARALLEL _ _2487 _2493)", new ImList(ImList.list("movq", "$3", "%MM7"), new ImList(ImList.list("pcmpgtd", "$4", "$3"), new ImList(ImList.list("pcmpeqd", "$4", "%MM7"), new ImList(ImList.list("por", "%MM7", "$3"), ImList.list(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), ImList.list("movd", "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%MM7"), ImList.list("pxor", "%MM7", "$3")))))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{2530, 2536}, new String[]{null, "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[2831] = new Rule(2831, false, false, 10, "2831: void -> (PARALLEL _ _2499 _2505 _2511 _2517 _2523 _2529 _2535 _2541 _2547 _2553 _2559 _2565 _2571 _2577 _2583 _2589)", new ImList(ImList.list("movdqu", "$3", "%XMM7"), new ImList(ImList.list("pcmpgtb", "$4", "$3"), new ImList(ImList.list("pcmpeqb", "$4", "%XMM7"), new ImList(ImList.list("por", "%XMM7", "$3"), new ImList(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), new ImList(ImList.list("movd", "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%XMM7"), ImList.list(ImList.list("pinsrw", ImList.list("imm", "4"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "5"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "6"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "7"), "%edx", "%XMM7"), ImList.list("pxor", "%XMM7", "$3")))))))))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{2542, 2548, 2554, 2560, 2566, 2572, 2578, 2584, 2590, 2596, 2602, 2608, 2614, 2620, 2626, 2632}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*"});
    }

    private static void rrinit4200() {
        CodeGenerator_x86simd.rulev[2864] = new Rule(2864, false, false, 10, "2864: void -> (PARALLEL _ _2593 _2597 _2601 _2605 _2609 _2613 _2617 _2621)", new ImList(ImList.list("movdqu", "$3", "%XMM7"), new ImList(ImList.list("pcmpgtw", "$4", "$3"), new ImList(ImList.list("pcmpeqw", "$4", "%XMM7"), new ImList(ImList.list("por", "%XMM7", "$3"), new ImList(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), new ImList(ImList.list("movd", "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%XMM7"), ImList.list(ImList.list("pinsrw", ImList.list("imm", "4"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "5"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "6"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "7"), "%edx", "%XMM7"), ImList.list("pxor", "%XMM7", "$3")))))))))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{2636, 2640, 2644, 2648, 2652, 2656, 2660, 2664}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[2889] = new Rule(2889, false, false, 10, "2889: void -> (PARALLEL _ _2627 _2633 _2639 _2645)", new ImList(ImList.list("movdqu", "$3", "%XMM7"), new ImList(ImList.list("pcmpgtd", "$4", "$3"), new ImList(ImList.list("pcmpeqd", "$4", "%XMM7"), new ImList(ImList.list("por", "%XMM7", "$3"), new ImList(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), new ImList(ImList.list("movd", "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%XMM7"), ImList.list(ImList.list("pinsrw", ImList.list("imm", "4"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "5"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "6"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "7"), "%edx", "%XMM7"), ImList.list("pxor", "%XMM7", "$3")))))))))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{2670, 2676, 2682, 2688}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[2898] = new Rule(2898, false, false, 10, "2898: void -> (PARALLEL _ _2647 _2649 _2651 _2653)", ImList.list(ImList.list("movd", "%ecx", "%MM7"), ImList.list("psraw", "%MM7", "$2")), null, ImList.list(ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{2690, 2692, 2694, 2696}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-cx-I16*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-I16*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-I16*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-I16*"});
        CodeGenerator_x86simd.rulev[2915] = new Rule(2915, false, false, 10, "2915: void -> (PARALLEL _ _2655 _2657 _2659 _2661 _2663 _2665 _2667 _2669)", ImList.list(ImList.list("movd", "%ecx", "%XMM7"), ImList.list("psraw", "%XMM7", "$2")), null, ImList.list(ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{2698, 2700, 2702, 2704, 2706, 2708, 2710, 2712}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-cx-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*"});
        CodeGenerator_x86simd.rulev[2920] = new Rule(2920, false, false, 10, "2920: void -> (PARALLEL _ _2671 _2673)", ImList.list(ImList.list("movd", "%ecx", "%MM7"), ImList.list("psrad", "%MM7", "$2")), null, ImList.list(ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{2714, 2716}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-ecx-I32*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-I32*"});
        CodeGenerator_x86simd.rulev[2929] = new Rule(2929, false, false, 10, "2929: void -> (PARALLEL _ _2675 _2677 _2679 _2681)", ImList.list(ImList.list("movd", "%ecx", "%XMM7"), ImList.list("psrad", "%XMM7", "$2")), null, ImList.list(ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{2718, 2720, 2722, 2724}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-ecx-I32*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I32*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I32*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I32*"});
        CodeGenerator_x86simd.rulev[2938] = new Rule(2938, false, false, 10, "2938: void -> (PARALLEL _ _2683 _2685 _2687 _2689)", ImList.list(ImList.list("psraw", ImList.list("imm", "$3"), "$2")), null, null, 0L, false, false, new int[]{2726, 2728, 2730, 2732}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null});
        CodeGenerator_x86simd.rulev[2955] = new Rule(2955, false, false, 10, "2955: void -> (PARALLEL _ _2691 _2693 _2695 _2697 _2699 _2701 _2703 _2705)", ImList.list(ImList.list("psraw", ImList.list("imm", "$3"), "$2")), null, null, 0L, false, false, new int[]{2734, 2736, 2738, 2740, 2742, 2744, 2746, 2748}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null});
        CodeGenerator_x86simd.rulev[2960] = new Rule(2960, false, false, 10, "2960: void -> (PARALLEL _ _2707 _2709)", ImList.list(ImList.list("psrad", ImList.list("imm", "$3"), "$2")), null, null, 0L, false, false, new int[]{2750, 2752}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null});
        CodeGenerator_x86simd.rulev[2969] = new Rule(2969, false, false, 10, "2969: void -> (PARALLEL _ _2711 _2713 _2715 _2717)", ImList.list(ImList.list("psrad", ImList.list("imm", "$3"), "$2")), null, null, 0L, false, false, new int[]{2754, 2756, 2758, 2760}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null});
        CodeGenerator_x86simd.rulev[2978] = new Rule(2978, false, false, 10, "2978: void -> (PARALLEL _ _2719 _2721 _2723 _2725)", ImList.list(ImList.list("movd", "%ecx", "%MM7"), ImList.list("psrlw", "%MM7", "$2")), null, ImList.list(ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{2762, 2764, 2766, 2768}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-cx-I16*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-I16*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-I16*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-I16*"});
        CodeGenerator_x86simd.rulev[2995] = new Rule(2995, false, false, 10, "2995: void -> (PARALLEL _ _2727 _2729 _2731 _2733 _2735 _2737 _2739 _2741)", ImList.list(ImList.list("movd", "%ecx", "%XMM7"), ImList.list("psrlw", "%XMM7", "$2")), null, ImList.list(ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{2770, 2772, 2774, 2776, 2778, 2780, 2782, 2784}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-cx-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*"});
        CodeGenerator_x86simd.rulev[3000] = new Rule(3000, false, false, 10, "3000: void -> (PARALLEL _ _2743 _2745)", ImList.list(ImList.list("movd", "%ecx", "%MM7"), ImList.list("psrld", "%MM7", "$2")), null, ImList.list(ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{2786, 2788}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-ecx-I32*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-I32*"});
        CodeGenerator_x86simd.rulev[3009] = new Rule(3009, false, false, 10, "3009: void -> (PARALLEL _ _2747 _2749 _2751 _2753)", ImList.list(ImList.list("movd", "%ecx", "%XMM7"), ImList.list("psrld", "%XMM7", "$2")), null, ImList.list(ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{2790, 2792, 2794, 2796}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-ecx-I32*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I32*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I32*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I32*"});
        CodeGenerator_x86simd.rulev[3018] = new Rule(3018, false, false, 10, "3018: void -> (PARALLEL _ _2755 _2757 _2759 _2761)", ImList.list(ImList.list("psrlw", ImList.list("imm", "$3"), "$2")), null, null, 0L, false, false, new int[]{2798, 2800, 2802, 2804}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null});
        CodeGenerator_x86simd.rulev[3035] = new Rule(3035, false, false, 10, "3035: void -> (PARALLEL _ _2763 _2765 _2767 _2769 _2771 _2773 _2775 _2777)", ImList.list(ImList.list("psrlw", ImList.list("imm", "$3"), "$2")), null, null, 0L, false, false, new int[]{2806, 2808, 2810, 2812, 2814, 2816, 2818, 2820}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null});
        CodeGenerator_x86simd.rulev[3040] = new Rule(3040, false, false, 10, "3040: void -> (PARALLEL _ _2779 _2781)", ImList.list(ImList.list("psrld", ImList.list("imm", "$3"), "$2")), null, null, 0L, false, false, new int[]{2822, 2824}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null});
        CodeGenerator_x86simd.rulev[3049] = new Rule(3049, false, false, 10, "3049: void -> (PARALLEL _ _2783 _2785 _2787 _2789)", ImList.list(ImList.list("psrld", ImList.list("imm", "$3"), "$2")), null, null, 0L, false, false, new int[]{2826, 2828, 2830, 2832}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null});
        CodeGenerator_x86simd.rulev[3058] = new Rule(3058, false, false, 10, "3058: void -> (PARALLEL _ _2791 _2793 _2795 _2797)", ImList.list(ImList.list("movd", "%ecx", "%MM7"), ImList.list("psllw", "%MM7", "$2")), null, ImList.list(ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{2834, 2836, 2838, 2840}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-cx-I16*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-I16*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-I16*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-I16*"});
        CodeGenerator_x86simd.rulev[3075] = new Rule(3075, false, false, 10, "3075: void -> (PARALLEL _ _2799 _2801 _2803 _2805 _2807 _2809 _2811 _2813)", ImList.list(ImList.list("movd", "%ecx", "%XMM7"), ImList.list("psllw", "%XMM7", "$2")), null, ImList.list(ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{2842, 2844, 2846, 2848, 2850, 2852, 2854, 2856}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-cx-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I16*"});
        CodeGenerator_x86simd.rulev[3080] = new Rule(3080, false, false, 10, "3080: void -> (PARALLEL _ _2815 _2817)", ImList.list(ImList.list("movd", "%ecx", "%MM7"), ImList.list("pslld", "%MM7", "$2")), null, ImList.list(ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{2858, 2860}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-ecx-I32*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-I32*"});
        CodeGenerator_x86simd.rulev[3089] = new Rule(3089, false, false, 10, "3089: void -> (PARALLEL _ _2819 _2821 _2823 _2825)", ImList.list(ImList.list("movd", "%ecx", "%XMM7"), ImList.list("pslld", "%XMM7", "$2")), null, ImList.list(ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{2862, 2864, 2866, 2868}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-ecx-I32*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I32*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I32*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-I32*"});
        CodeGenerator_x86simd.rulev[3098] = new Rule(3098, false, false, 10, "3098: void -> (PARALLEL _ _2827 _2829 _2831 _2833)", ImList.list(ImList.list("psllw", ImList.list("imm", "$3"), "$2")), null, null, 0L, false, false, new int[]{2870, 2872, 2874, 2876}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null});
        CodeGenerator_x86simd.rulev[3115] = new Rule(3115, false, false, 10, "3115: void -> (PARALLEL _ _2835 _2837 _2839 _2841 _2843 _2845 _2847 _2849)", ImList.list(ImList.list("psllw", ImList.list("imm", "$3"), "$2")), null, null, 0L, false, false, new int[]{2878, 2880, 2882, 2884, 2886, 2888, 2890, 2892}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null});
        CodeGenerator_x86simd.rulev[3120] = new Rule(3120, false, false, 10, "3120: void -> (PARALLEL _ _2851 _2853)", ImList.list(ImList.list("pslld", ImList.list("imm", "$3"), "$2")), null, null, 0L, false, false, new int[]{2894, 2896}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", null, "*reg-simd-I64*", "*reg-simd-I64*", null});
        CodeGenerator_x86simd.rulev[3129] = new Rule(3129, false, false, 10, "3129: void -> (PARALLEL _ _2855 _2857 _2859 _2861)", ImList.list(ImList.list("pslld", ImList.list("imm", "$3"), "$2")), null, null, 0L, false, false, new int[]{2898, 2900, 2902, 2904}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null, "*reg-simd-I128*", "*reg-simd-I128*", null});
        CodeGenerator_x86simd.rulev[3151] = new Rule(3151, false, false, 10, "3151: void -> (PARALLEL _ _2864 _2867 _2870 _2873 _2876 _2879 _2882)", ImList.list(ImList.list("pandn", "$3", "$2")), null, null, 0L, false, false, new int[]{2907, 2910, 2913, 2916, 2919, 2922, 2925}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3164] = new Rule(3164, false, false, 10, "3164: void -> (PARALLEL _ _2885 _2888 _2891 _2894)", ImList.list(ImList.list("pandn", "$3", "$2")), null, null, 0L, false, false, new int[]{2928, 2931, 2934, 2937}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3171] = new Rule(3171, false, false, 10, "3171: void -> (PARALLEL _ _2897 _2900)", ImList.list(ImList.list("pandn", "$3", "$2")), null, null, 0L, false, false, new int[]{2940, 2943}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3220] = new Rule(3220, false, false, 10, "3220: void -> (PARALLEL _ _2903 _2906 _2909 _2912 _2915 _2918 _2921 _2924 _2927 _2930 _2933 _2936 _2939 _2942 _2945 _2948)", ImList.list(ImList.list("pandn", "$3", "$2")), null, null, 0L, false, false, new int[]{2946, 2949, 2952, 2955, 2958, 2961, 2964, 2967, 2970, 2973, 2976, 2979, 2982, 2985, 2988, 2991}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3245] = new Rule(3245, false, false, 10, "3245: void -> (PARALLEL _ _2951 _2954 _2957 _2960 _2963 _2966 _2969 _2972)", ImList.list(ImList.list("pandn", "$3", "$2")), null, null, 0L, false, false, new int[]{2994, 2997, 3000, 3003, 3006, 3009, 3012, 3015}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3258] = new Rule(3258, false, false, 10, "3258: void -> (PARALLEL _ _2975 _2978 _2981 _2984)", ImList.list(ImList.list("pandn", "$3", "$2")), null, null, 0L, false, false, new int[]{3018, 3021, 3024, 3027}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3267] = new Rule(3267, false, false, 10, "3267: void -> (PARALLEL _ _2985 _2986 _2987 _2988 _2989 _2990 _2991 _2992)", ImList.list(ImList.list("paddb", "$3", "$2")), null, null, 0L, false, false, new int[]{3028, 3029, 3030, 3031, 3032, 3033, 3034, 3035}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3276] = new Rule(3276, false, false, 10, "3276: void -> (PARALLEL _ _2993 _2994 _2995 _2996 _2997 _2998 _2999 _3000)", ImList.list(ImList.list("psubb", "$3", "$2")), null, null, 0L, false, false, new int[]{3036, 3037, 3038, 3039, 3040, 3041, 3042, 3043}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3293] = new Rule(3293, false, false, 10, "3293: void -> (PARALLEL _ _3002 _3004 _3006 _3008 _3010 _3012 _3014 _3016)", ImList.list(ImList.list("pand", "$3", "$2")), null, null, 0L, false, false, new int[]{3045, 3047, 3049, 3051, 3053, 3055, 3057, 3059}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3302] = new Rule(3302, false, false, 10, "3302: void -> (PARALLEL _ _3017 _3018 _3019 _3020 _3021 _3022 _3023 _3024)", ImList.list(ImList.list("por", "$3", "$2")), null, null, 0L, false, false, new int[]{3060, 3061, 3062, 3063, 3064, 3065, 3066, 3067}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3319] = new Rule(3319, false, false, 10, "3319: void -> (PARALLEL _ _3026 _3028 _3030 _3032 _3034 _3036 _3038 _3040)", ImList.list(ImList.list("pxor", "$3", "$2")), null, null, 0L, false, false, new int[]{3069, 3071, 3073, 3075, 3077, 3079, 3081, 3083}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3324] = new Rule(3324, false, false, 10, "3324: void -> (PARALLEL _ _3041 _3042 _3043 _3044)", ImList.list(ImList.list("paddw", "$3", "$2")), null, null, 0L, false, false, new int[]{3084, 3085, 3086, 3087}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3333] = new Rule(3333, false, false, 10, "3333: void -> (PARALLEL _ _3046 _3048 _3050 _3052)", ImList.list(ImList.list("psubw", "$3", "$2")), null, null, 0L, false, false, new int[]{3089, 3091, 3093, 3095}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3342] = new Rule(3342, false, false, 10, "3342: void -> (PARALLEL _ _3054 _3056 _3058 _3060)", ImList.list(ImList.list("pmullw", "$3", "$2")), null, null, 0L, false, false, new int[]{3097, 3099, 3101, 3103}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3351] = new Rule(3351, false, false, 10, "3351: void -> (PARALLEL _ _3062 _3064 _3066 _3068)", ImList.list(ImList.list("pand", "$3", "$2")), null, null, 0L, false, false, new int[]{3105, 3107, 3109, 3111}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3356] = new Rule(3356, false, false, 10, "3356: void -> (PARALLEL _ _3069 _3070 _3071 _3072)", ImList.list(ImList.list("por", "$3", "$2")), null, null, 0L, false, false, new int[]{3112, 3113, 3114, 3115}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3365] = new Rule(3365, false, false, 10, "3365: void -> (PARALLEL _ _3074 _3076 _3078 _3080)", ImList.list(ImList.list("pxor", "$3", "$2")), null, null, 0L, false, false, new int[]{3117, 3119, 3121, 3123}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3370] = new Rule(3370, false, false, 10, "3370: void -> (PARALLEL _ _3082 _3084)", ImList.list(ImList.list("paddd", "$3", "$2")), null, null, 0L, false, false, new int[]{3125, 3127}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3375] = new Rule(3375, false, false, 10, "3375: void -> (PARALLEL _ _3086 _3088)", ImList.list(ImList.list("psubd", "$3", "$2")), null, null, 0L, false, false, new int[]{3129, 3131}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3380] = new Rule(3380, false, false, 10, "3380: void -> (PARALLEL _ _3090 _3092)", ImList.list(ImList.list("pand", "$3", "$2")), null, null, 0L, false, false, new int[]{3133, 3135}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3385] = new Rule(3385, false, false, 10, "3385: void -> (PARALLEL _ _3094 _3096)", ImList.list(ImList.list("por", "$3", "$2")), null, null, 0L, false, false, new int[]{3137, 3139}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3390] = new Rule(3390, false, false, 10, "3390: void -> (PARALLEL _ _3098 _3100)", ImList.list(ImList.list("pxor", "$3", "$2")), null, null, 0L, false, false, new int[]{3141, 3143}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3407] = new Rule(3407, false, false, 10, "3407: void -> (PARALLEL _ _3101 _3102 _3103 _3104 _3105 _3106 _3107 _3108 _3109 _3110 _3111 _3112 _3113 _3114 _3115 _3116)", ImList.list(ImList.list("paddb", "$3", "$2")), null, null, 0L, false, false, new int[]{3144, 3145, 3146, 3147, 3148, 3149, 3150, 3151, 3152, 3153, 3154, 3155, 3156, 3157, 3158, 3159}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3424] = new Rule(3424, false, false, 10, "3424: void -> (PARALLEL _ _3117 _3118 _3119 _3120 _3121 _3122 _3123 _3124 _3125 _3126 _3127 _3128 _3129 _3130 _3131 _3132)", ImList.list(ImList.list("psubb", "$3", "$2")), null, null, 0L, false, false, new int[]{3160, 3161, 3162, 3163, 3164, 3165, 3166, 3167, 3168, 3169, 3170, 3171, 3172, 3173, 3174, 3175}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3457] = new Rule(3457, false, false, 10, "3457: void -> (PARALLEL _ _3134 _3136 _3138 _3140 _3142 _3144 _3146 _3148 _3150 _3152 _3154 _3156 _3158 _3160 _3162 _3164)", ImList.list(ImList.list("pand", "$3", "$2")), null, null, 0L, false, false, new int[]{3177, 3179, 3181, 3183, 3185, 3187, 3189, 3191, 3193, 3195, 3197, 3199, 3201, 3203, 3205, 3207}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3474] = new Rule(3474, false, false, 10, "3474: void -> (PARALLEL _ _3165 _3166 _3167 _3168 _3169 _3170 _3171 _3172 _3173 _3174 _3175 _3176 _3177 _3178 _3179 _3180)", ImList.list(ImList.list("por", "$3", "$2")), null, null, 0L, false, false, new int[]{3208, 3209, 3210, 3211, 3212, 3213, 3214, 3215, 3216, 3217, 3218, 3219, 3220, 3221, 3222, 3223}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3507] = new Rule(3507, false, false, 10, "3507: void -> (PARALLEL _ _3182 _3184 _3186 _3188 _3190 _3192 _3194 _3196 _3198 _3200 _3202 _3204 _3206 _3208 _3210 _3212)", ImList.list(ImList.list("pxor", "$3", "$2")), null, null, 0L, false, false, new int[]{3225, 3227, 3229, 3231, 3233, 3235, 3237, 3239, 3241, 3243, 3245, 3247, 3249, 3251, 3253, 3255}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3516] = new Rule(3516, false, false, 10, "3516: void -> (PARALLEL _ _3213 _3214 _3215 _3216 _3217 _3218 _3219 _3220)", ImList.list(ImList.list("paddw", "$3", "$2")), null, null, 0L, false, false, new int[]{3256, 3257, 3258, 3259, 3260, 3261, 3262, 3263}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3533] = new Rule(3533, false, false, 10, "3533: void -> (PARALLEL _ _3222 _3224 _3226 _3228 _3230 _3232 _3234 _3236)", ImList.list(ImList.list("psubw", "$3", "$2")), null, null, 0L, false, false, new int[]{3265, 3267, 3269, 3271, 3273, 3275, 3277, 3279}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3550] = new Rule(3550, false, false, 10, "3550: void -> (PARALLEL _ _3238 _3240 _3242 _3244 _3246 _3248 _3250 _3252)", ImList.list(ImList.list("pmullw", "$3", "$2")), null, null, 0L, false, false, new int[]{3281, 3283, 3285, 3287, 3289, 3291, 3293, 3295}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3567] = new Rule(3567, false, false, 10, "3567: void -> (PARALLEL _ _3254 _3256 _3258 _3260 _3262 _3264 _3266 _3268)", ImList.list(ImList.list("pand", "$3", "$2")), null, null, 0L, false, false, new int[]{3297, 3299, 3301, 3303, 3305, 3307, 3309, 3311}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3576] = new Rule(3576, false, false, 10, "3576: void -> (PARALLEL _ _3269 _3270 _3271 _3272 _3273 _3274 _3275 _3276)", ImList.list(ImList.list("por", "$3", "$2")), null, null, 0L, false, false, new int[]{3312, 3313, 3314, 3315, 3316, 3317, 3318, 3319}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3593] = new Rule(3593, false, false, 10, "3593: void -> (PARALLEL _ _3278 _3280 _3282 _3284 _3286 _3288 _3290 _3292)", ImList.list(ImList.list("pxor", "$3", "$2")), null, null, 0L, false, false, new int[]{3321, 3323, 3325, 3327, 3329, 3331, 3333, 3335}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3602] = new Rule(3602, false, false, 10, "3602: void -> (PARALLEL _ _3294 _3296 _3298 _3300)", ImList.list(ImList.list("paddd", "$3", "$2")), null, null, 0L, false, false, new int[]{3337, 3339, 3341, 3343}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3611] = new Rule(3611, false, false, 10, "3611: void -> (PARALLEL _ _3302 _3304 _3306 _3308)", ImList.list(ImList.list("psubd", "$3", "$2")), null, null, 0L, false, false, new int[]{3345, 3347, 3349, 3351}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3620] = new Rule(3620, false, false, 10, "3620: void -> (PARALLEL _ _3310 _3312 _3314 _3316)", ImList.list(ImList.list("pand", "$3", "$2")), null, null, 0L, false, false, new int[]{3353, 3355, 3357, 3359}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3629] = new Rule(3629, false, false, 10, "3629: void -> (PARALLEL _ _3318 _3320 _3322 _3324)", ImList.list(ImList.list("por", "$3", "$2")), null, null, 0L, false, false, new int[]{3361, 3363, 3365, 3367}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3638] = new Rule(3638, false, false, 10, "3638: void -> (PARALLEL _ _3326 _3328 _3330 _3332)", ImList.list(ImList.list("pxor", "$3", "$2")), null, null, 0L, false, false, new int[]{3369, 3371, 3373, 3375}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3655] = new Rule(3655, false, false, 10, "3655: void -> (PARALLEL _ _3334 _3336 _3338 _3340 _3342 _3344 _3346 _3348)", ImList.list(ImList.list("psllq", ImList.list("imm", "64"), "%MM7"), ImList.list("psubb", "$2", "%MM7"), ImList.list("movq", "%MM7", "$2")), null, ImList.list(ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{3377, 3379, 3381, 3383, 3385, 3387, 3389, 3391}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3688] = new Rule(3688, false, false, 10, "3688: void -> (PARALLEL _ _3350 _3352 _3354 _3356 _3358 _3360 _3362 _3364 _3366 _3368 _3370 _3372 _3374 _3376 _3378 _3380)", ImList.list(ImList.list("pslldq", ImList.list("imm", "16"), "%XMM7"), ImList.list("psubb", "$2", "%XMM7"), ImList.list("movdqu", "%XMM7", "$2")), null, ImList.list(ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{3393, 3395, 3397, 3399, 3401, 3403, 3405, 3407, 3409, 3411, 3413, 3415, 3417, 3419, 3421, 3423}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3697] = new Rule(3697, false, false, 10, "3697: void -> (PARALLEL _ _3382 _3384 _3386 _3388)", ImList.list(ImList.list("psllq", ImList.list("imm", "64"), "%MM7"), ImList.list("psubw", "$2", "%MM7"), ImList.list("movq", "%MM7", "$2")), null, ImList.list(ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{3425, 3427, 3429, 3431}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3714] = new Rule(3714, false, false, 10, "3714: void -> (PARALLEL _ _3390 _3392 _3394 _3396 _3398 _3400 _3402 _3404)", ImList.list(ImList.list("pslldq", ImList.list("imm", "16"), "%XMM7"), ImList.list("psubw", "$2", "%XMM7"), ImList.list("movdqu", "%XMM7", "$2")), null, ImList.list(ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{3433, 3435, 3437, 3439, 3441, 3443, 3445, 3447}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3719] = new Rule(3719, false, false, 10, "3719: void -> (PARALLEL _ _3406 _3408)", ImList.list(ImList.list("psllq", ImList.list("imm", "64"), "%MM7"), ImList.list("psubd", "$2", "%MM7"), ImList.list("movq", "%MM7", "$2")), null, ImList.list(ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{3449, 3451}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3728] = new Rule(3728, false, false, 10, "3728: void -> (PARALLEL _ _3410 _3412 _3414 _3416)", ImList.list(ImList.list("pslldq", ImList.list("imm", "16"), "%XMM7"), ImList.list("psubd", "$2", "%XMM7"), ImList.list("movdqu", "%XMM7", "$2")), null, ImList.list(ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{3453, 3455, 3457, 3459}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3738] = new Rule(3738, false, false, 10, "3738: void -> (PARALLEL _ _3417 _3418 _3419 _3420 _3422 _3423 _3424 _3425)", ImList.list(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), ImList.list("movd", "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%MM7"), ImList.list("pxor", "%MM7", "$2")), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{3460, 3461, 3462, 3463, 3465, 3466, 3467, 3468}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3755] = new Rule(3755, false, false, 10, "3755: void -> (PARALLEL _ _3426 _3427 _3428 _3429 _3430 _3431 _3432 _3433 _3434 _3435 _3436 _3437 _3438 _3439 _3440 _3441)", new ImList(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), new ImList(ImList.list("movd", "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%XMM7"), ImList.list(ImList.list("pinsrw", ImList.list("imm", "4"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "5"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "6"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "7"), "%edx", "%XMM7"), ImList.list("pxor", "%XMM7", "$2")))))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{3469, 3470, 3471, 3472, 3473, 3474, 3475, 3476, 3477, 3478, 3479, 3480, 3481, 3482, 3483, 3484}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3760] = new Rule(3760, false, false, 10, "3760: void -> (PARALLEL _ _3442 _3443 _3444 _3445)", ImList.list(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), ImList.list("movd", "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%MM7"), ImList.list("pxor", "%MM7", "$2")), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{3485, 3486, 3487, 3488}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3769] = new Rule(3769, false, false, 10, "3769: void -> (PARALLEL _ _3446 _3447 _3448 _3449 _3450 _3451 _3452 _3453)", new ImList(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), new ImList(ImList.list("movd", "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%XMM7"), ImList.list(ImList.list("pinsrw", ImList.list("imm", "4"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "5"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "6"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "7"), "%edx", "%XMM7"), ImList.list("pxor", "%XMM7", "$2")))))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{3489, 3490, 3491, 3492, 3493, 3494, 3495, 3496}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3772] = new Rule(3772, false, false, 10, "3772: void -> (PARALLEL _ _3454 _3455)", ImList.list(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), ImList.list("movd", "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%MM7"), ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%MM7"), ImList.list("pxor", "%MM7", "$2")), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I64", "%MM7")), 0L, false, false, new int[]{3497, 3498}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3777] = new Rule(3777, false, false, 10, "3777: void -> (PARALLEL _ _3456 _3457 _3458 _3459)", new ImList(ImList.list("movl", ImList.list("imm", "4294967295"), "%edx"), new ImList(ImList.list("movd", "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "2"), "%edx", "%XMM7"), new ImList(ImList.list("pinsrw", ImList.list("imm", "3"), "%edx", "%XMM7"), ImList.list(ImList.list("pinsrw", ImList.list("imm", "4"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "5"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "6"), "%edx", "%XMM7"), ImList.list("pinsrw", ImList.list("imm", "7"), "%edx", "%XMM7"), ImList.list("pxor", "%XMM7", "$2")))))), null, ImList.list(ImList.list("REG", "I32", "%edx"), ImList.list("REG", "I128", "%XMM7")), 0L, false, false, new int[]{3499, 3500, 3501, 3502}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3786] = new Rule(3786, false, false, 10, "3786: void -> (PARALLEL _ _3461 _3463 _3465 _3467)", ImList.list(ImList.list("movups", "$2", "$1")), null, null, 0L, false, false, new int[]{3504, 3506, 3508, 3510}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null});
        CodeGenerator_x86simd.rulev[3787] = new Rule(3787, false, false, 10, "3787: void -> (PARALLEL _ _3461 _3463)", ImList.list(ImList.list("movlps", "$2", "$1")), null, null, 0L, false, false, new int[]{3504, 3506}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", null});
        CodeGenerator_x86simd.rulev[3792] = new Rule(3792, false, false, 10, "3792: void -> (PARALLEL _ _3469 _3471)", ImList.list(ImList.list("movupd", "$2", "$1")), null, null, 0L, false, false, new int[]{3512, 3514}, new String[]{null, "*reg-simd-I128*", null, "*reg-simd-I128*", null});
        CodeGenerator_x86simd.rulev[3793] = new Rule(3793, false, false, 10, "3793: void -> (PARALLEL _ _3469)", ImList.list(ImList.list("movlpd", "$2", "$1")), null, null, 0L, false, false, new int[]{3512}, new String[]{null, "*reg-simd-I128*", null});
        CodeGenerator_x86simd.rulev[3798] = new Rule(3798, false, false, 10, "3798: void -> (PARALLEL _ _3472 _3473 _3474 _3475)", ImList.list(ImList.list("movups", "$2", "$1")), null, null, 0L, false, false, new int[]{3515, 3516, 3517, 3518}, new String[]{null, null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*", null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3799] = new Rule(3799, false, false, 10, "3799: void -> (PARALLEL _ _3472 _3473)", ImList.list(ImList.list("movlps", "$2", "$1")), null, null, 0L, false, false, new int[]{3515, 3516}, new String[]{null, null, "*reg-simd-I128*", null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3802] = new Rule(3802, false, false, 10, "3802: void -> (PARALLEL _ _3476 _3477)", ImList.list(ImList.list("movupd", "$2", "$1")), null, null, 0L, false, false, new int[]{3519, 3520}, new String[]{null, null, "*reg-simd-I128*", null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3803] = new Rule(3803, false, false, 10, "3803: void -> (PARALLEL _ _3476)", ImList.list(ImList.list("movlpd", "$2", "$1")), null, null, 0L, false, false, new int[]{3519}, new String[]{null, null, "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3808] = new Rule(3808, false, false, 10, "3808: void -> (PARALLEL _ _3478 _3479 _3480 _3481)", ImList.list(ImList.list("movups", "$2", "$1")), null, null, 0L, false, false, new int[]{3521, 3522, 3523, 3524}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3811] = new Rule(3811, false, false, 10, "3811: void -> (PARALLEL _ _3482 _3483)", ImList.list(ImList.list("movupd", "$2", "$1")), null, null, 0L, false, false, new int[]{3525, 3526}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3816] = new Rule(3816, false, false, 10, "3816: void -> (PARALLEL _ _3485 _3487)", ImList.list(ImList.list("cvtps2pi", "$2", "$1")), null, null, 0L, false, false, new int[]{3528, 3530}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I128*", "*reg-simd-I64*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3821] = new Rule(3821, false, false, 10, "3821: void -> (PARALLEL _ _3489 _3491)", ImList.list(ImList.list("cvtpd2pi", "$2", "$1")), null, null, 0L, false, false, new int[]{3532, 3534}, new String[]{null, "*reg-simd-I64*", "*reg-simd-I128*", "*reg-simd-I64*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3828] = new Rule(3828, false, false, 10, "3828: void -> (PARALLEL _ _3492 _3493 _3495 _3497)", ImList.list(ImList.list("cvtps2dq", "$2", "$1")), null, null, 0L, false, false, new int[]{3535, 3536, 3538, 3540}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3831] = new Rule(3831, false, false, 10, "3831: void -> (PARALLEL _ _3498 _3499)", ImList.list(ImList.list("cvtpd2dq", "$2", "$1")), null, null, 0L, false, false, new int[]{3541, 3542}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3836] = new Rule(3836, false, false, 10, "3836: void -> (PARALLEL _ _3501 _3503)", ImList.list(ImList.list("cvtpi2ps", "$2", "$1")), null, null, 0L, false, false, new int[]{3544, 3546}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I64*", "*reg-simd-I128*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3841] = new Rule(3841, false, false, 10, "3841: void -> (PARALLEL _ _3505 _3507)", ImList.list(ImList.list("cvtpi2pd", "$2", "$1")), null, null, 0L, false, false, new int[]{3548, 3550}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I64*", "*reg-simd-I128*", "*reg-simd-I64*"});
        CodeGenerator_x86simd.rulev[3850] = new Rule(3850, false, false, 10, "3850: void -> (PARALLEL _ _3509 _3511 _3513 _3515)", ImList.list(ImList.list("cvtdq2ps", "$2", "$1")), null, null, 0L, false, false, new int[]{3552, 3554, 3556, 3558}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3855] = new Rule(3855, false, false, 10, "3855: void -> (PARALLEL _ _3517 _3519)", ImList.list(ImList.list("cvtdq2pd", "$2", "$1")), null, null, 0L, false, false, new int[]{3560, 3562}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3860] = new Rule(3860, false, false, 10, "3860: void -> (PARALLEL _ _3521 _3523)", ImList.list(ImList.list("cvtpd2ps", "$2", "$1")), null, null, 0L, false, false, new int[]{3564, 3566}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3865] = new Rule(3865, false, false, 10, "3865: void -> (PARALLEL _ _3525 _3527)", ImList.list(ImList.list("cvtps2pd", "$2", "$1")), null, null, 0L, false, false, new int[]{3568, 3570}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3875] = new Rule(3875, false, false, 10, "3875: void -> (PARALLEL _ _3530 _3532 _3534 _3536)", ImList.list(ImList.list("rcpps", "$2", "$1")), null, null, 0L, false, false, new int[]{3573, 3575, 3577, 3579}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3884] = new Rule(3884, false, false, 10, "3884: void -> (PARALLEL _ _3538 _3540 _3542 _3544)", ImList.list(ImList.list("addps", "$3", "$2")), null, null, 0L, false, false, new int[]{3581, 3583, 3585, 3587}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3893] = new Rule(3893, false, false, 10, "3893: void -> (PARALLEL _ _3546 _3548 _3550 _3552)", ImList.list(ImList.list("subps", "$3", "$2")), null, null, 0L, false, false, new int[]{3589, 3591, 3593, 3595}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3902] = new Rule(3902, false, false, 10, "3902: void -> (PARALLEL _ _3554 _3556 _3558 _3560)", ImList.list(ImList.list("mulps", "$3", "$2")), null, null, 0L, false, false, new int[]{3597, 3599, 3601, 3603}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
    }

    private static void rrinit4300() {
        CodeGenerator_x86simd.rulev[3911] = new Rule(3911, false, false, 10, "3911: void -> (PARALLEL _ _3562 _3564 _3566 _3568)", ImList.list(ImList.list("divps", "$3", "$2")), null, null, 0L, false, false, new int[]{3605, 3607, 3609, 3611}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3916] = new Rule(3916, false, false, 10, "3916: void -> (PARALLEL _ _3570 _3572)", ImList.list(ImList.list("addpd", "$3", "$2")), null, null, 0L, false, false, new int[]{3613, 3615}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3921] = new Rule(3921, false, false, 10, "3921: void -> (PARALLEL _ _3574 _3576)", ImList.list(ImList.list("subpd", "$3", "$2")), null, null, 0L, false, false, new int[]{3617, 3619}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3926] = new Rule(3926, false, false, 10, "3926: void -> (PARALLEL _ _3578 _3580)", ImList.list(ImList.list("mulpd", "$3", "$2")), null, null, 0L, false, false, new int[]{3621, 3623}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3931] = new Rule(3931, false, false, 10, "3931: void -> (PARALLEL _ _3582 _3584)", ImList.list(ImList.list("divpd", "$3", "$2")), null, null, 0L, false, false, new int[]{3625, 3627}, new String[]{null, "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*", "*reg-simd-I128*"});
        CodeGenerator_x86simd.rulev[3958] = new Rule(3958, false, false, 10, "3958: void -> (PARALLEL _ _3589 _3590)", ImList.list(ImList.list("pushl", ImList.list("qhigh", "$1")), ImList.list("pushl", ImList.list("qlow", "$1"))), null, null, 0L, false, false, new int[]{3632, 3633}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[3963] = new Rule(3963, false, false, 10, "3963: void -> (PARALLEL _ _3593 _3594)", ImList.list(ImList.list("pushl", "$1")), null, null, 0L, false, false, new int[]{3636, 3637}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[3966] = new Rule(3966, false, false, 10, "3966: void -> (PARALLEL _ _3596 _3594)", ImList.list(ImList.list("pushl", "$1")), null, null, 0L, false, false, new int[]{3639, 3637}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[3969] = new Rule(3969, false, false, 10, "3969: void -> (PARALLEL _ _3598 _3590)", ImList.list(ImList.list("pushl", ImList.list("after", "$1", "4")), ImList.list("pushl", "$1")), null, null, 0L, false, false, new int[]{3641, 3633}, new String[]{null, null});
        CodeGenerator_x86simd.rulev[3971] = new Rule(3971, false, false, 10, "3971: void -> (PARALLEL _ _3599 _3594)", ImList.list(ImList.list("sub", ImList.list("imm", "4"), "%esp"), ImList.list("movss", "$1", ImList.list("mem", "float", ImList.list("addr", ImList.list("base", ImList.list(), "%esp"), ImList.list())))), null, null, 0L, false, false, new int[]{3642, 3637}, new String[]{null, "*reg-tmp-F32*"});
        CodeGenerator_x86simd.rulev[3973] = new Rule(3973, false, false, 10, "3973: void -> (PARALLEL _ _3600 _3590)", ImList.list(ImList.list("sub", ImList.list("imm", "8"), "%esp"), ImList.list("movsd", "$1", ImList.list("mem", "double", ImList.list("addr", ImList.list("base", ImList.list(), "%esp"), ImList.list())))), null, null, 0L, false, false, new int[]{3643, 3633}, new String[]{null, "*reg-tmp-F64*"});
    }

    String defaultRegsetForType(int type) {
        switch (type) {
            case 1026: {
                return "*reg-I64*";
            }
            case 514: {
                return "*reg-I32*";
            }
            case 258: {
                return "*reg-I16*";
            }
            case 130: {
                return "*reg-I8*";
            }
        }
        return null;
    }

    void initLabeling(LirFactory lir) {
        this.stateVec = new State[lir.idBound()];
    }

    String showLabel(LirNode t) {
        return this.stateVec[t.id].toString();
    }

    void labelTree(LirNode t) {
        if (this.stateVec[t.id] == null) {
            State st;
            int n = this.nActualOperands(t);
            State[] kid = new State[n];
            for (int i = 0; i < n; ++i) {
                LirNode s = t.kid(i);
                this.labelTree(s);
                kid[i] = this.stateVec[s.id];
            }
            this.stateVec[t.id] = st = new State();
            st.label(t, kid);
        }
    }

    Rule getRule(LirNode t, int goal) {
        return rulev[this.stateVec[t.id].rule[goal]];
    }

    int getCost1(LirNode t, int goal) {
        return this.stateVec[t.id].cost1[goal];
    }

    int getCost2(LirNode t, int goal) {
        return this.stateVec[t.id].cost2[goal];
    }

    int startNT() {
        return 10;
    }

    Object expandBuildMacro(ImList form) {
        String name = (String)form.elem();
        if (name == "reserve-tmpq") {
            return this.jmac2();
        }
        if (name == "reserve-tmpl") {
            return this.jmac3();
        }
        if (name == "reserve-cw0") {
            return this.jmac4();
        }
        if (name == "reserve-cw1") {
            return this.jmac5();
        }
        return null;
    }

    Object quiltLir(LirNode node) {
        switch (node.opCode) {
            case 7: {
                return this.jmac1(node);
            }
        }
        return this.quiltLirDefault(node);
    }

    String emitList(ImList form, boolean topLevel) {
        String name = (String)form.elem();
        if (name == "after") {
            return this.jmac6(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "+") {
            return this.jmac7(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "-") {
            return this.jmac8(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "-32") {
            return this.jmac9(this.emitObject(form.elem(1)));
        }
        if (name == "imm") {
            return this.jmac10(this.emitObject(form.elem(1)));
        }
        if (name == "ind") {
            return this.jmac11(this.emitObject(form.elem(1)));
        }
        if (name == "mem") {
            return this.jmac12(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "addr") {
            return this.jmac13(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "base") {
            return this.jmac14(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "index") {
            return this.jmac15(this.emitObject(form.elem(1)), this.emitObject(form.elem(2)));
        }
        if (name == "regwlow") {
            return this.jmac16(this.emitObject(form.elem(1)));
        }
        if (name == "regblow") {
            return this.jmac17(this.emitObject(form.elem(1)));
        }
        if (name == "qlow") {
            return this.jmac18(this.emitObject(form.elem(1)));
        }
        if (name == "qhigh") {
            return this.jmac19(this.emitObject(form.elem(1)));
        }
        if (name == "prologue") {
            return this.jmac20(form.elem(1));
        }
        if (name == "epilogue") {
            return this.jmac21(form.elem(1), this.emitObject(form.elem(2)));
        }
        if (name == "minus") {
            return this.jmac22(this.emitObject(form.elem(1)));
        }
        if (name == "line") {
            return this.jmac23(this.emitObject(form.elem(1)));
        }
        if (name == "symbol") {
            return this.jmac24(this.emitObject(form.elem(1)));
        }
        if (name == "genasm") {
            return this.jmac25(this.emitObject(form.elem(1)), form.elem(2));
        }
        return this.emitListDefault(form, topLevel);
    }

    String emitLir(LirNode node) {
        switch (node.opCode) {
            default: 
        }
        return this.emitLirDefault(node);
    }

    CodeGenerator.FunctionAttr newFunctionAttr(Function func) {
        return new X86Attr(func);
    }

    void setAllocaCalled() {
        X86Attr attr = (X86Attr)this.getFunctionAttr(this.func);
        attr.allocaCalled = true;
    }

    private boolean isConv(LirNode node) {
        switch (node.opCode) {
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    int makeVaStart(LirNode arg) {
        LirNode node = null;
        BiLink p = this.func.firstInstrList().first();
        while (!p.atEnd()) {
            node = (LirNode)p.elem();
            if (node.opCode == 54) break;
            p = p.next();
        }
        int n = node.nKids();
        int offset = 8;
        if (this.isConv(arg)) {
            arg = arg.kid(0);
        }
        for (int i = 1; i < n; ++i) {
            LirNode x = node.kid(i);
            offset += Type.bytes(x.type) + 3 & 0xFFFFFFFC;
            if (!this.equalArg(arg, x)) continue;
            return offset;
        }
        return 8;
    }

    boolean equalArg(LirNode x, LirNode y) {
        if (x.opCode == 47) {
            x = x.kid(0);
        }
        if (y.opCode == 47) {
            y = y.kid(0);
        }
        return ((LirSymRef)x).symbol == ((LirSymRef)y).symbol;
    }

    LirNode stripConv(LirNode tree) {
        switch (tree.opCode) {
            case 17: 
            case 18: {
                return tree.kid(0);
            }
        }
        return tree;
    }

    LirNode rewriteFrame(LirNode node) {
        Symbol ebp = this.func.getSymbol("%ebp");
        int off = ((SymAuto)((LirSymRef)node).symbol).offset();
        return this.lir.node(10, node.type, this.lir.symRef(ebp), this.lir.iconst(I32, off));
    }

    public Transformer[] earlyRewritingSequence() {
        return new Transformer[]{this.localEarlyRewritingTrig};
    }

    public Transformer[] lateRewritingSequence() {
        return new Transformer[]{AggregatePropagation.trig, this.localLateRewritingTrig, this.ProcessFramesTrig};
    }

    LirNode rewritePrologue(LirNode node, BiList post) {
        int location = 8;
        LirNode base = this.regnode(I32, "%ebp");
        if (this.func.origEpilogue.nKids() > 1 && Type.tag(this.func.origEpilogue.kid((int)1).type) == 1) {
            location += 4;
        }
        int n = node.nKids();
        for (int i = 1; i < n; ++i) {
            LirNode arg = node.kid(i);
            if (arg.opCode == 47) {
                if (arg.kid((int)0).opCode != 5) {
                    throw new CantHappenException("Malformed aggregate parameter");
                }
                SymAuto var = (SymAuto)((LirSymRef)arg.kid((int)0)).symbol;
                var.setOffset(location);
            } else {
                post.add(this.lir.node(48, arg.type, arg, this.stackMem(arg.type, location, base)));
            }
            location = location + Type.bytes(arg.type) + 3 & 0xFFFFFFFC;
        }
        return this.lir.node(54, 0, node.kid(0));
    }

    private LirNode regnode(int type, String name) {
        LirNode master = this.lir.symRef(this.module.globalSymtab.get(name));
        switch (Type.tag(type)) {
            case 2: {
                return master;
            }
            case 4: {
                if (type == F64) {
                    return master;
                }
                if (type != F32) break;
                return this.lir.node(7, F32, master, this.lir.untaggedIconst(I32, 0L));
            }
        }
        return null;
    }

    private LirNode stackMem(int type, int location, LirNode base) {
        return this.lir.node(47, type, this.lir.node(10, I32, base, this.lir.iconst(I32, location + this.adjustEndian(type))));
    }

    private int adjustEndian(int type) {
        return 0;
    }

    private LirNode makePush(LirNode operand) {
        LirNode stackPtr = this.regnode(I32, "%esp");
        if (Type.tag(operand.type) == 4) {
            int size = Type.bytes(operand.type);
            return this.lir.node(56, 0, this.lir.node(48, operand.type, this.lir.node(47, operand.type, this.lir.node(11, I32, stackPtr, this.lir.iconst(I32, size))), operand), this.lir.node(48, I32, stackPtr, this.lir.node(11, I32, stackPtr, this.lir.iconst(I32, size))));
        }
        if (Type.bits(operand.type) <= 32) {
            return this.lir.node(56, 0, this.lir.node(48, I32, this.lir.node(47, I32, this.lir.node(11, I32, stackPtr, this.lir.iconst(I32, 4L))), operand), this.lir.node(48, I32, stackPtr, this.lir.node(11, I32, stackPtr, this.lir.iconst(I32, 4L))));
        }
        return this.lir.node(56, 0, this.lir.node(48, I64, this.lir.node(47, I64, this.lir.node(11, I32, stackPtr, this.lir.iconst(I32, 8L))), operand), this.lir.node(48, I32, stackPtr, this.lir.node(11, I32, stackPtr, this.lir.iconst(I32, 8L))));
    }

    LirNode returnReg(int type) {
        switch (Type.tag(type)) {
            case 2: {
                switch (Type.bytes(type)) {
                    case 1: {
                        return this.regnode(type, "%al");
                    }
                    case 2: {
                        return this.regnode(type, "%ax");
                    }
                    case 4: {
                        return this.regnode(type, "%eax");
                    }
                    case 8: {
                        return this.regnode(type, "%edxeax");
                    }
                }
                return null;
            }
            case 4: {
                return this.regnode(type, "%XMM0");
            }
        }
        return null;
    }

    LirNode rewriteEpilogue(LirNode node, BiList pre) {
        if (node.nKids() < 2) {
            return node;
        }
        LirNode ret = node.kid(1);
        switch (Type.tag(ret.type)) {
            case 2: 
            case 4: {
                LirNode reg = this.returnReg(ret.type);
                pre.add(this.lir.node(48, ret.type, reg, ret));
                return this.lir.node(55, 0, node.kid(0), reg);
            }
            case 1: {
                pre.add(this.lir.node(48, ret.type, this.lir.operator(47, ret.type, this.stackMem(I32, 8, this.regnode(I32, "%ebp")), ImList.list("&align", "4")), ret));
                return this.lir.node(55, 0, new LirNode[0]);
            }
        }
        throw new CantHappenException();
    }

    LirNode rewriteCall(LirNode node, BiList pre, BiList post) {
        LirNode args = node.kid(1);
        LirNode ret = null;
        if (node.kid(2).nKids() > 0) {
            ret = node.kid(2).kid(0);
        }
        int loc = 0;
        int n = args.nKids();
        boolean paramCounter = false;
        LirNode spreg = this.regnode(I32, "%esp");
        int i = n;
        while (--i >= 0) {
            LirNode arg = args.kid(i);
            switch (Type.tag(arg.type)) {
                case 2: {
                    if (Type.bits(arg.type) < 32) {
                        arg = this.lir.node(18, I32, arg);
                    }
                    pre.add(this.makePush(arg));
                    loc += Type.bytes(arg.type);
                    break;
                }
                case 4: {
                    pre.add(this.makePush(arg));
                    loc += Type.bytes(arg.type);
                    break;
                }
                case 1: {
                    pre.add(this.lir.node(48, I32, spreg, this.lir.node(11, I32, spreg, this.lir.iconst(I32, Type.bytes(arg.type)))));
                    pre.add(this.lir.node(48, arg.type, this.lir.operator(47, arg.type, spreg, ImList.list("&align", "4")), arg));
                    loc += Type.bytes(arg.type) + 3 & 0xFFFFFFFC;
                }
            }
        }
        LirNode retReg = ret;
        if (ret != null) {
            switch (Type.tag(ret.type)) {
                case 2: 
                case 4: {
                    retReg = this.returnReg(ret.type);
                    break;
                }
                case 1: {
                    if (ret.opCode != 47) {
                        throw new CantHappenException();
                    }
                    pre.add(this.makePush(ret.kid(0)));
                    loc += 4;
                }
            }
        }
        LirNode[] emptyVector = new LirNode[]{};
        try {
            LirNode retNode = this.lir.node(61, 0, emptyVector);
            if (retReg != null) {
                retNode = this.lir.node(61, 0, retReg);
            }
            node = this.lir.node(56, 0, this.noRescan(this.lir.node(53, 0, node.kid(0), this.lir.node(61, 0, emptyVector), retNode)), this.lir.decodeLir(new ImList("CLOBBER", this.regCallClobbers), this.func, this.module));
        }
        catch (SyntaxError e) {
            throw new CantHappenException();
        }
        if (ret != null) {
            switch (Type.tag(ret.type)) {
                case 2: 
                case 4: {
                    if (this.isSimple(ret)) {
                        post.add(this.lir.node(48, ret.type, ret, retReg));
                        break;
                    }
                    LirNode tmp = this.func.newTemp(ret.type);
                    post.add(this.lir.node(48, ret.type, tmp, retReg));
                    post.add(this.lir.node(48, ret.type, ret, tmp));
                    break;
                }
            }
        }
        if (loc != 0) {
            post.add(this.lir.node(48, I32, spreg, this.lir.node(10, I32, spreg, this.lir.iconst(I32, loc))));
        }
        return node;
    }

    void peepHoleOpt(BiList list) {
        this.postRewriteFloatOps(list);
        if (this.root.traceOK("TMD", 1)) {
            this.debOut.println();
            this.debOut.println("After rewriting floatOps for function " + this.func.symbol.name + ":");
            BiLink p = list.first();
            while (!p.atEnd()) {
                this.debOut.println("  " + p.elem());
                p = p.next();
            }
            this.debOut.println();
        }
    }

    void postRewriteFloatOps(BiList list) {
        int counter = 1;
        int[] defAt = new int[9];
        int sp = 0;
        BiLink p = list.first();
        while (!p.atEnd()) {
            ImList inst = (ImList)p.elem();
            String op = (String)inst.elem();
            int dest = this.tregNum(inst.lastElem());
            int src = -1;
            int src2 = -1;
            if (op == "fldz" || op == "fld1") {
                inst = ImList.list(op);
                ++sp;
            } else if (op == "fldl" || op == "fildl" || op == "fildll" || op == "flds" || op == "filds") {
                src = this.fregNum(inst.elem2nd());
                inst = src >= 0 ? ImList.list(op, "%st(" + (src + sp) + ")") : ImList.list(op, inst.elem2nd());
                ++sp;
            } else if (op == "fchs") {
                inst = ImList.list(op);
            } else if (op == "fadd" || op == "fmul") {
                if (this.tregNum(inst.elem2nd()) >= 0 && this.tregNum(inst.elem3rd()) >= 0) {
                    inst = ImList.list((op + "p").intern(), "%st", "%st(1)");
                    --sp;
                } else {
                    src = this.fregNum(inst.elem2nd());
                    inst = src >= 0 ? ImList.list(op, "%st(" + (src + sp) + ")", "%st") : ImList.list((op + this.floatSizeSuffix(inst.elem2nd())).intern(), inst.elem2nd());
                }
            } else if (op == "fsub" || op == "fdiv") {
                src2 = this.tregNum(inst.elem2nd());
                if (src2 >= 0 && (src = this.tregNum(inst.elem3rd())) >= 0) {
                    inst = defAt[src2] > defAt[src] ? ImList.list((op + "rp").intern(), "%st", "%st(1)") : (defAt[src2] < defAt[src] ? ImList.list((op + "p").intern(), "%st", "%st(1)") : ImList.list((op + "?").intern()));
                    --sp;
                } else {
                    src = this.fregNum(inst.elem2nd());
                    inst = src >= 0 ? ImList.list(op, "%st(" + (src + sp) + ")", "%st") : ImList.list((op + this.floatSizeSuffix(inst.elem2nd())).intern(), inst.elem2nd());
                }
            } else if (op == "fcom") {
                src2 = this.tregNum(inst.elem2nd());
                if (src2 >= 0 && (src = this.tregNum(inst.elem3rd())) >= 0) {
                    if (defAt[src2] > defAt[src]) {
                        p.addBefore(ImList.list("fxch"));
                    }
                    inst = ImList.list("fcompp");
                    sp -= 2;
                } else {
                    src = this.fregNum(inst.elem2nd());
                    if (src >= 0) {
                        inst = ImList.list("fcomp", "%st(" + (src + sp) + ")");
                        --sp;
                    } else {
                        inst = ImList.list(("fcomp" + this.floatSizeSuffix(inst.elem2nd())).intern(), inst.elem2nd());
                        --sp;
                    }
                }
            } else if (op == "fstp") {
                src = this.fregNum(inst.elem3rd());
                inst = src >= 0 ? ImList.list(op, "%st(" + (src + sp) + ")") : ImList.list((op + this.floatSizeSuffix(inst.elem3rd())).intern(), inst.elem3rd());
                --sp;
            } else if (op == "fstps" || op == "fistpl" || op == "fistpll" || op == "fistps") {
                inst = ImList.list(op, inst.elem3rd());
                --sp;
            }
            if (dest >= 0) {
                defAt[dest] = counter++;
            }
            if (op == "fmov") {
                p.unlink();
            } else {
                p.setElem(inst);
            }
            p = p.next();
        }
    }

    int tregNum(Object operand) {
        if (operand instanceof String && ((String)operand).startsWith("%t")) {
            return Integer.parseInt(((String)operand).substring(2));
        }
        return -1;
    }

    int fregNum(Object operand) {
        if (operand instanceof String && ((String)operand).startsWith("%f")) {
            return Integer.parseInt(((String)operand).substring(2));
        }
        return -1;
    }

    String floatSizeSuffix(Object arg) {
        ImList mem = (ImList)arg;
        if (mem.elem() == "mem") {
            String size = (String)mem.elem2nd();
            if (size == "float") {
                return "s";
            }
            if (size == "double") {
                return "l";
            }
        }
        throw new CantHappenException();
    }

    Object jmac1(LirNode x) {
        Symbol reg = ((LirSymRef)x.kid((int)0)).symbol;
        int dtype = x.type;
        int offset = (int)((LirIconst)x.kid((int)1)).value;
        if (dtype == I16) {
            if (offset == 0) {
                return "%" + reg.name.substring(2);
            }
        } else if (dtype == I8) {
            int namel = reg.name.length();
            if (offset == 0) {
                return "%" + reg.name.substring(namel - 2, namel - 1) + "l";
            }
            if (offset == 1) {
                return "%" + reg.name.substring(namel - 2, namel - 1) + "h";
            }
        } else if ((dtype == F32 || dtype == F64) && offset == 0) {
            return reg.name;
        }
        throw new CantHappenException();
    }

    Object jmac2() {
        SymAuto sym = this.reserveFrame(".TMPQ", I64);
        return sym.offset() + "(%ebp)";
    }

    Object jmac3() {
        SymAuto sym = this.reserveFrame(".TMPL", I32);
        return sym.offset() + "(%ebp)";
    }

    Object jmac4() {
        SymAuto sym = this.reserveFrame(".CONVCW0", I16);
        return sym.offset() + "(%ebp)";
    }

    Object jmac5() {
        SymAuto sym = this.reserveFrame(".CONVCW1", I16);
        return sym.offset() + "(%ebp)";
    }

    String jmac6(String x, String y) {
        return this.emitAfter(x, y);
    }

    String emitAfter(String x, String y) {
        if (x.charAt(x.length() - 1) != ')') {
            return x + "+" + y;
        }
        if (x.charAt(0) == '-' || x.charAt(0) == '(') {
            return y + x;
        }
        return y + "+" + x;
    }

    String jmac7(String x, String y) {
        if (y.charAt(0) == '-') {
            return x + y;
        }
        return x + "+" + y;
    }

    String jmac8(String x, String y) {
        if (y.charAt(0) == '-') {
            return x + "+" + y.substring(1);
        }
        return x + "-" + y;
    }

    String jmac9(String x) {
        return "" + (Integer.parseInt(x) - 32);
    }

    String jmac10(String x) {
        return "$" + x;
    }

    String jmac11(String x) {
        return "*" + x;
    }

    String jmac12(String type, String x) {
        return x;
    }

    String jmac13(String base, String index) {
        if (index == "") {
            return base;
        }
        if (base == "" || base.charAt(base.length() - 1) != ')') {
            return base + "(," + index + ")";
        }
        return base.substring(0, base.length() - 1) + "," + index + ")";
    }

    String jmac14(String con, String reg) {
        if (reg == "") {
            return con;
        }
        return con + "(" + reg + ")";
    }

    String jmac15(String reg, String scale) {
        if (scale == "1") {
            return reg;
        }
        return reg + "," + scale;
    }

    String jmac16(String x) {
        return "%" + x.substring(2);
    }

    String jmac17(String x) {
        return "%" + x.substring(x.length() - 2, x.length() - 1) + "l";
    }

    String jmac18(String x) {
        if (x.charAt(0) == '$') {
            return "$" + (Long.parseLong(x.substring(1)) & 0xFFFFFFFFL);
        }
        if (x.charAt(0) == '%') {
            return "%" + x.substring(x.length() - 3);
        }
        return x;
    }

    String jmac19(String x) {
        if (x.charAt(0) == '$') {
            return "$" + (Long.parseLong(x.substring(1)) >> 32 & 0xFFFFFFFFL);
        }
        if (x.charAt(0) == '%') {
            return x.substring(0, x.length() - 3);
        }
        return this.emitAfter(x, "4");
    }

    String jmac20(Object f) {
        Function func = (Function)f;
        SaveRegisters saveList = (SaveRegisters)func.require(SaveRegisters.analyzer);
        int size = this.frameSize(func);
        size = size + 3 & 0xFFFFFFFC;
        String seq = "\tpushl\t%ebp\n\tmovl\t%esp,%ebp";
        if (size != 0) {
            seq = this.convention == "cygwin" && size > 4000 ? seq + "\n\tmovl\t$" + size + ",%eax" + "\n\tcall\t__alloca" : seq + "\n\tsubl\t$" + size + ",%esp";
        }
        NumberSet.Iterator it = saveList.calleeSave.iterator();
        while (it.hasNext()) {
            int reg = it.next();
            seq = seq + "\n\tpushl\t" + this.machineParams.registerToString(reg);
        }
        return seq;
    }

    String jmac21(Object f, String rettype) {
        Function func = (Function)f;
        SaveRegisters saveList = (SaveRegisters)func.require(SaveRegisters.analyzer);
        int size = this.frameSize(func);
        X86Attr attr = (X86Attr)this.getFunctionAttr(func);
        String pops = "";
        int n = 0;
        NumberSet.Iterator it = saveList.calleeSave.iterator();
        while (it.hasNext()) {
            int reg = it.next();
            pops = "\tpopl\t" + this.machineParams.registerToString(reg) + "\n" + pops;
            n += 4;
        }
        String seq = "";
        if (attr.allocaCalled && n != 0) {
            seq = "\tlea\t-" + (size + n) + "(%ebp),%esp\n";
        }
        return seq + pops + "\tleave\n\tret";
    }

    String jmac22(String con) {
        return -Integer.parseInt(con) + "";
    }

    String jmac23(String x) {
        return "# line " + x;
    }

    String jmac24(String x) {
        return this.makeAsmSymbol(x);
    }

    String jmac25(String format, Object args) {
        return this.emitAsmCode(format, (ImList)args);
    }

    void emitBeginningOfSegment(PrintWriter out, String segment) {
        if (this.convention == "cygwin") {
            if (segment.equals(".text") || segment.equals(".rodata")) {
                out.println("\t.text");
            } else if (segment.equals(".data")) {
                out.println("\t.data");
            } else {
                out.println("\t.section " + segment);
            }
        } else {
            out.println("\t.section " + segment);
        }
    }

    String makeAsmSymbol(String symbol) {
        if (this.convention == "cygwin" && symbol.charAt(0) != '.') {
            return "_" + symbol;
        }
        return symbol;
    }

    public int alignForType(int type) {
        switch (Type.bytes(type)) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
        }
        return 4;
    }

    String segmentForConst() {
        return ".rodata";
    }

    void emitData(PrintWriter out, int type, LirNode node) {
        if (type == I64) {
            long v = ((LirIconst)node).signedValue();
            out.println("\t.long\t" + (v & 0xFFFFFFFFL) + "," + (v >> 32 & 0xFFFFFFFFL));
        } else if (type == I32) {
            out.println("\t.long\t" + this.lexpConv.convert(node));
        } else if (type == I16) {
            out.println("\t.short\t" + ((LirIconst)node).signedValue());
        } else if (type == I8) {
            out.println("\t.byte\t" + ((LirIconst)node).signedValue());
        } else if (type == F64) {
            double value = ((LirFconst)node).value;
            long bits = Double.doubleToLongBits(value);
            out.println("\t.long\t0x" + Long.toString(bits & 0xFFFFFFFFL, 16) + ",0x" + Long.toString(bits >> 32 & 0xFFFFFFFFL, 16) + " /* " + value + " */");
        } else if (type == F32) {
            double value = ((LirFconst)node).value;
            long bits = Float.floatToIntBits((float)value);
            out.println("\t.long\t0x" + Long.toString(bits & 0xFFFFFFFFL, 16) + " /* " + value + " */");
        } else {
            throw new CantHappenException("unknown type: " + type);
        }
    }

    void emitCommon(PrintWriter out, SymStatic symbol, int bytes) {
        if (symbol.linkage == "LDEF") {
            out.println("\t.lcomm\t" + this.makeAsmSymbol(symbol.name) + "," + bytes);
        } else if (this.convention == "cygwin") {
            out.println("\t.comm\t" + this.makeAsmSymbol(symbol.name) + "," + bytes);
        } else {
            out.println("\t.comm\t" + this.makeAsmSymbol(symbol.name) + "," + bytes + "," + symbol.boundary);
        }
    }

    static {
        CodeGenerator_x86simd.rrinit0();
        CodeGenerator_x86simd.rrinit100();
        CodeGenerator_x86simd.rrinit200();
        CodeGenerator_x86simd.rrinit300();
        CodeGenerator_x86simd.rrinit400();
        CodeGenerator_x86simd.rrinit500();
        CodeGenerator_x86simd.rrinit600();
        CodeGenerator_x86simd.rrinit700();
        CodeGenerator_x86simd.rrinit800();
        CodeGenerator_x86simd.rrinit900();
        CodeGenerator_x86simd.rrinit1000();
        CodeGenerator_x86simd.rrinit1100();
        CodeGenerator_x86simd.rrinit1200();
        CodeGenerator_x86simd.rrinit1300();
        CodeGenerator_x86simd.rrinit1400();
        CodeGenerator_x86simd.rrinit1500();
        CodeGenerator_x86simd.rrinit1600();
        CodeGenerator_x86simd.rrinit1700();
        CodeGenerator_x86simd.rrinit1800();
        CodeGenerator_x86simd.rrinit1900();
        CodeGenerator_x86simd.rrinit2000();
        CodeGenerator_x86simd.rrinit2100();
        CodeGenerator_x86simd.rrinit2200();
        CodeGenerator_x86simd.rrinit2300();
        CodeGenerator_x86simd.rrinit2400();
        CodeGenerator_x86simd.rrinit2500();
        CodeGenerator_x86simd.rrinit2600();
        CodeGenerator_x86simd.rrinit2700();
        CodeGenerator_x86simd.rrinit2800();
        CodeGenerator_x86simd.rrinit2900();
        CodeGenerator_x86simd.rrinit3000();
        CodeGenerator_x86simd.rrinit3100();
        CodeGenerator_x86simd.rrinit3200();
        CodeGenerator_x86simd.rrinit3300();
        CodeGenerator_x86simd.rrinit3400();
        CodeGenerator_x86simd.rrinit3500();
        CodeGenerator_x86simd.rrinit3600();
        CodeGenerator_x86simd.rrinit3700();
        CodeGenerator_x86simd.rrinit3800();
        CodeGenerator_x86simd.rrinit3900();
        CodeGenerator_x86simd.rrinit4000();
        CodeGenerator_x86simd.rrinit4100();
        CodeGenerator_x86simd.rrinit4200();
        CodeGenerator_x86simd.rrinit4300();
    }

    static class X86Attr
    extends CodeGenerator.FunctionAttr {
        int stackRequired = 0;
        int tmpOffset = 0;
        boolean allocaCalled;

        X86Attr(Function func) {
            super(func);
        }
    }

    class State {
        static final int NNONTERM = 3737;
        static final int NRULES = 4312;
        static final int START_NT = 10;
        static final int NT__ = 0;
        static final int NT_regx = 1;
        static final int NT_regm = 2;
        static final int NT_regq = 3;
        static final int NT_regl = 4;
        static final int NT_reglb = 5;
        static final int NT_regw = 6;
        static final int NT_regb = 7;
        static final int NT_regf = 8;
        static final int NT_regd = 9;
        static final int NT_void = 10;
        static final int NT_xregb = 11;
        static final int NT_xregl = 12;
        static final int NT_xregw = 13;
        static final int NT_xregq = 14;
        static final int NT_xregf = 15;
        static final int NT_xregd = 16;
        static final int NT_xregx = 17;
        static final int NT_xregm = 18;
        static final int NT_con = 19;
        static final int NT_sta = 20;
        static final int NT_asmcon = 21;
        static final int NT_lab = 22;
        static final int NT_base = 23;
        static final int NT_index = 24;
        static final int NT__1 = 25;
        static final int NT__2 = 26;
        static final int NT__3 = 27;
        static final int NT__4 = 28;
        static final int NT__5 = 29;
        static final int NT_addr = 30;
        static final int NT_memq = 31;
        static final int NT_meml = 32;
        static final int NT_memw = 33;
        static final int NT_memb = 34;
        static final int NT_memf = 35;
        static final int NT_memd = 36;
        static final int NT_rcl = 37;
        static final int NT_rcw = 38;
        static final int NT_rcb = 39;
        static final int NT_mrcl = 40;
        static final int NT_mregl = 41;
        static final int NT_mrcw = 42;
        static final int NT_mregw = 43;
        static final int NT_mrcb = 44;
        static final int NT_mregb = 45;
        static final int NT_mregq = 46;
        static final int NT_mrcq = 47;
        static final int NT_callarg = 48;
        static final int NT__6 = 49;
        static final int NT__7 = 50;
        static final int NT__8 = 51;
        static final int NT__9 = 52;
        static final int NT__10 = 53;
        static final int NT__11 = 54;
        static final int NT__12 = 55;
        static final int NT__13 = 56;
        static final int NT__14 = 57;
        static final int NT__15 = 58;
        static final int NT__16 = 59;
        static final int NT__17 = 60;
        static final int NT__18 = 61;
        static final int NT__19 = 62;
        static final int NT__20 = 63;
        static final int NT__21 = 64;
        static final int NT__22 = 65;
        static final int NT__23 = 66;
        static final int NT__24 = 67;
        static final int NT__25 = 68;
        static final int NT__26 = 69;
        static final int NT__27 = 70;
        static final int NT__28 = 71;
        static final int NT__29 = 72;
        static final int NT__30 = 73;
        static final int NT__31 = 74;
        static final int NT__32 = 75;
        static final int NT__33 = 76;
        static final int NT__34 = 77;
        static final int NT__35 = 78;
        static final int NT__36 = 79;
        static final int NT__37 = 80;
        static final int NT__38 = 81;
        static final int NT__39 = 82;
        static final int NT__40 = 83;
        static final int NT__41 = 84;
        static final int NT__42 = 85;
        static final int NT__43 = 86;
        static final int NT__44 = 87;
        static final int NT__45 = 88;
        static final int NT__46 = 89;
        static final int NT__47 = 90;
        static final int NT__48 = 91;
        static final int NT__49 = 92;
        static final int NT__50 = 93;
        static final int NT__51 = 94;
        static final int NT__52 = 95;
        static final int NT__53 = 96;
        static final int NT__54 = 97;
        static final int NT__55 = 98;
        static final int NT__56 = 99;
        static final int NT__57 = 100;
        static final int NT__58 = 101;
        static final int NT__59 = 102;
        static final int NT__60 = 103;
        static final int NT__61 = 104;
        static final int NT__62 = 105;
        static final int NT__63 = 106;
        static final int NT__64 = 107;
        static final int NT__65 = 108;
        static final int NT__66 = 109;
        static final int NT__67 = 110;
        static final int NT__68 = 111;
        static final int NT__69 = 112;
        static final int NT__70 = 113;
        static final int NT__71 = 114;
        static final int NT__72 = 115;
        static final int NT__73 = 116;
        static final int NT__74 = 117;
        static final int NT__75 = 118;
        static final int NT__76 = 119;
        static final int NT__77 = 120;
        static final int NT__78 = 121;
        static final int NT__79 = 122;
        static final int NT__80 = 123;
        static final int NT__81 = 124;
        static final int NT__82 = 125;
        static final int NT__83 = 126;
        static final int NT__84 = 127;
        static final int NT__85 = 128;
        static final int NT__86 = 129;
        static final int NT__87 = 130;
        static final int NT__88 = 131;
        static final int NT__89 = 132;
        static final int NT__90 = 133;
        static final int NT__91 = 134;
        static final int NT__92 = 135;
        static final int NT__93 = 136;
        static final int NT__94 = 137;
        static final int NT__95 = 138;
        static final int NT__96 = 139;
        static final int NT__97 = 140;
        static final int NT__98 = 141;
        static final int NT__99 = 142;
        static final int NT__100 = 143;
        static final int NT__101 = 144;
        static final int NT__102 = 145;
        static final int NT__103 = 146;
        static final int NT__104 = 147;
        static final int NT__105 = 148;
        static final int NT__106 = 149;
        static final int NT__107 = 150;
        static final int NT__108 = 151;
        static final int NT__109 = 152;
        static final int NT__110 = 153;
        static final int NT__111 = 154;
        static final int NT__112 = 155;
        static final int NT__113 = 156;
        static final int NT__114 = 157;
        static final int NT__115 = 158;
        static final int NT__116 = 159;
        static final int NT__117 = 160;
        static final int NT__118 = 161;
        static final int NT__119 = 162;
        static final int NT__120 = 163;
        static final int NT__121 = 164;
        static final int NT__122 = 165;
        static final int NT__123 = 166;
        static final int NT__124 = 167;
        static final int NT__125 = 168;
        static final int NT__126 = 169;
        static final int NT__127 = 170;
        static final int NT__128 = 171;
        static final int NT__129 = 172;
        static final int NT__130 = 173;
        static final int NT__131 = 174;
        static final int NT__132 = 175;
        static final int NT__133 = 176;
        static final int NT__134 = 177;
        static final int NT__135 = 178;
        static final int NT__136 = 179;
        static final int NT__137 = 180;
        static final int NT__138 = 181;
        static final int NT__139 = 182;
        static final int NT__140 = 183;
        static final int NT__141 = 184;
        static final int NT__142 = 185;
        static final int NT__143 = 186;
        static final int NT__144 = 187;
        static final int NT__145 = 188;
        static final int NT__146 = 189;
        static final int NT__147 = 190;
        static final int NT__148 = 191;
        static final int NT__149 = 192;
        static final int NT__150 = 193;
        static final int NT__151 = 194;
        static final int NT__152 = 195;
        static final int NT__153 = 196;
        static final int NT__154 = 197;
        static final int NT__155 = 198;
        static final int NT__156 = 199;
        static final int NT__157 = 200;
        static final int NT__158 = 201;
        static final int NT__159 = 202;
        static final int NT__160 = 203;
        static final int NT__161 = 204;
        static final int NT__162 = 205;
        static final int NT__163 = 206;
        static final int NT__164 = 207;
        static final int NT__165 = 208;
        static final int NT__166 = 209;
        static final int NT__167 = 210;
        static final int NT__168 = 211;
        static final int NT__169 = 212;
        static final int NT__170 = 213;
        static final int NT__171 = 214;
        static final int NT__172 = 215;
        static final int NT__173 = 216;
        static final int NT__174 = 217;
        static final int NT__175 = 218;
        static final int NT__176 = 219;
        static final int NT__177 = 220;
        static final int NT__178 = 221;
        static final int NT__179 = 222;
        static final int NT__180 = 223;
        static final int NT__181 = 224;
        static final int NT__182 = 225;
        static final int NT__183 = 226;
        static final int NT__184 = 227;
        static final int NT__185 = 228;
        static final int NT__186 = 229;
        static final int NT__187 = 230;
        static final int NT__188 = 231;
        static final int NT__189 = 232;
        static final int NT__190 = 233;
        static final int NT__191 = 234;
        static final int NT__192 = 235;
        static final int NT__193 = 236;
        static final int NT__194 = 237;
        static final int NT__195 = 238;
        static final int NT__196 = 239;
        static final int NT__197 = 240;
        static final int NT__198 = 241;
        static final int NT__199 = 242;
        static final int NT__200 = 243;
        static final int NT__201 = 244;
        static final int NT__202 = 245;
        static final int NT__203 = 246;
        static final int NT__204 = 247;
        static final int NT__205 = 248;
        static final int NT__206 = 249;
        static final int NT__207 = 250;
        static final int NT__208 = 251;
        static final int NT__209 = 252;
        static final int NT__210 = 253;
        static final int NT__211 = 254;
        static final int NT__212 = 255;
        static final int NT__213 = 256;
        static final int NT__214 = 257;
        static final int NT__215 = 258;
        static final int NT__216 = 259;
        static final int NT__217 = 260;
        static final int NT__218 = 261;
        static final int NT__219 = 262;
        static final int NT__220 = 263;
        static final int NT__221 = 264;
        static final int NT__222 = 265;
        static final int NT__223 = 266;
        static final int NT__224 = 267;
        static final int NT__225 = 268;
        static final int NT__226 = 269;
        static final int NT__227 = 270;
        static final int NT__228 = 271;
        static final int NT__229 = 272;
        static final int NT__230 = 273;
        static final int NT__231 = 274;
        static final int NT__232 = 275;
        static final int NT__233 = 276;
        static final int NT__234 = 277;
        static final int NT__235 = 278;
        static final int NT__236 = 279;
        static final int NT__237 = 280;
        static final int NT__238 = 281;
        static final int NT__239 = 282;
        static final int NT__240 = 283;
        static final int NT__241 = 284;
        static final int NT__242 = 285;
        static final int NT__243 = 286;
        static final int NT__244 = 287;
        static final int NT__245 = 288;
        static final int NT__246 = 289;
        static final int NT__247 = 290;
        static final int NT__248 = 291;
        static final int NT__249 = 292;
        static final int NT__250 = 293;
        static final int NT__251 = 294;
        static final int NT__252 = 295;
        static final int NT__253 = 296;
        static final int NT__254 = 297;
        static final int NT__255 = 298;
        static final int NT__256 = 299;
        static final int NT__257 = 300;
        static final int NT__258 = 301;
        static final int NT__259 = 302;
        static final int NT__260 = 303;
        static final int NT__261 = 304;
        static final int NT__262 = 305;
        static final int NT__263 = 306;
        static final int NT__264 = 307;
        static final int NT__265 = 308;
        static final int NT__266 = 309;
        static final int NT__267 = 310;
        static final int NT__268 = 311;
        static final int NT__269 = 312;
        static final int NT__270 = 313;
        static final int NT__271 = 314;
        static final int NT__272 = 315;
        static final int NT__273 = 316;
        static final int NT__274 = 317;
        static final int NT__275 = 318;
        static final int NT__276 = 319;
        static final int NT__277 = 320;
        static final int NT__278 = 321;
        static final int NT__279 = 322;
        static final int NT__280 = 323;
        static final int NT__281 = 324;
        static final int NT__282 = 325;
        static final int NT__283 = 326;
        static final int NT__284 = 327;
        static final int NT__285 = 328;
        static final int NT__286 = 329;
        static final int NT__287 = 330;
        static final int NT__288 = 331;
        static final int NT__289 = 332;
        static final int NT__290 = 333;
        static final int NT__291 = 334;
        static final int NT__292 = 335;
        static final int NT__293 = 336;
        static final int NT__294 = 337;
        static final int NT__295 = 338;
        static final int NT__296 = 339;
        static final int NT__297 = 340;
        static final int NT__298 = 341;
        static final int NT__299 = 342;
        static final int NT__300 = 343;
        static final int NT__301 = 344;
        static final int NT__302 = 345;
        static final int NT__303 = 346;
        static final int NT__304 = 347;
        static final int NT__305 = 348;
        static final int NT__306 = 349;
        static final int NT__307 = 350;
        static final int NT__308 = 351;
        static final int NT__309 = 352;
        static final int NT__310 = 353;
        static final int NT__311 = 354;
        static final int NT__312 = 355;
        static final int NT__313 = 356;
        static final int NT__314 = 357;
        static final int NT__315 = 358;
        static final int NT__316 = 359;
        static final int NT__317 = 360;
        static final int NT__318 = 361;
        static final int NT__319 = 362;
        static final int NT__320 = 363;
        static final int NT__321 = 364;
        static final int NT__322 = 365;
        static final int NT__323 = 366;
        static final int NT__324 = 367;
        static final int NT__325 = 368;
        static final int NT__326 = 369;
        static final int NT__327 = 370;
        static final int NT__328 = 371;
        static final int NT__329 = 372;
        static final int NT__330 = 373;
        static final int NT__331 = 374;
        static final int NT__332 = 375;
        static final int NT__333 = 376;
        static final int NT__334 = 377;
        static final int NT__335 = 378;
        static final int NT__336 = 379;
        static final int NT__337 = 380;
        static final int NT__338 = 381;
        static final int NT__339 = 382;
        static final int NT__340 = 383;
        static final int NT__341 = 384;
        static final int NT__342 = 385;
        static final int NT__343 = 386;
        static final int NT__344 = 387;
        static final int NT__345 = 388;
        static final int NT__346 = 389;
        static final int NT__347 = 390;
        static final int NT__348 = 391;
        static final int NT__349 = 392;
        static final int NT__350 = 393;
        static final int NT__351 = 394;
        static final int NT__352 = 395;
        static final int NT__353 = 396;
        static final int NT__354 = 397;
        static final int NT__355 = 398;
        static final int NT__356 = 399;
        static final int NT__357 = 400;
        static final int NT__358 = 401;
        static final int NT__359 = 402;
        static final int NT__360 = 403;
        static final int NT__361 = 404;
        static final int NT__362 = 405;
        static final int NT__363 = 406;
        static final int NT__364 = 407;
        static final int NT__365 = 408;
        static final int NT__366 = 409;
        static final int NT__367 = 410;
        static final int NT__368 = 411;
        static final int NT__369 = 412;
        static final int NT__370 = 413;
        static final int NT__371 = 414;
        static final int NT__372 = 415;
        static final int NT__373 = 416;
        static final int NT__374 = 417;
        static final int NT__375 = 418;
        static final int NT__376 = 419;
        static final int NT__377 = 420;
        static final int NT__378 = 421;
        static final int NT__379 = 422;
        static final int NT__380 = 423;
        static final int NT__381 = 424;
        static final int NT__382 = 425;
        static final int NT__383 = 426;
        static final int NT__384 = 427;
        static final int NT__385 = 428;
        static final int NT__386 = 429;
        static final int NT__387 = 430;
        static final int NT__388 = 431;
        static final int NT__389 = 432;
        static final int NT__390 = 433;
        static final int NT__391 = 434;
        static final int NT__392 = 435;
        static final int NT__393 = 436;
        static final int NT__394 = 437;
        static final int NT__395 = 438;
        static final int NT__396 = 439;
        static final int NT__397 = 440;
        static final int NT__398 = 441;
        static final int NT__399 = 442;
        static final int NT__400 = 443;
        static final int NT__401 = 444;
        static final int NT__402 = 445;
        static final int NT__403 = 446;
        static final int NT__404 = 447;
        static final int NT__405 = 448;
        static final int NT__406 = 449;
        static final int NT__407 = 450;
        static final int NT__408 = 451;
        static final int NT__409 = 452;
        static final int NT__410 = 453;
        static final int NT__411 = 454;
        static final int NT__412 = 455;
        static final int NT__413 = 456;
        static final int NT__414 = 457;
        static final int NT__415 = 458;
        static final int NT__416 = 459;
        static final int NT__417 = 460;
        static final int NT__418 = 461;
        static final int NT__419 = 462;
        static final int NT__420 = 463;
        static final int NT__421 = 464;
        static final int NT__422 = 465;
        static final int NT__423 = 466;
        static final int NT__424 = 467;
        static final int NT__425 = 468;
        static final int NT__426 = 469;
        static final int NT__427 = 470;
        static final int NT__428 = 471;
        static final int NT__429 = 472;
        static final int NT__430 = 473;
        static final int NT__431 = 474;
        static final int NT__432 = 475;
        static final int NT__433 = 476;
        static final int NT__434 = 477;
        static final int NT__435 = 478;
        static final int NT__436 = 479;
        static final int NT__437 = 480;
        static final int NT__438 = 481;
        static final int NT__439 = 482;
        static final int NT__440 = 483;
        static final int NT__441 = 484;
        static final int NT__442 = 485;
        static final int NT__443 = 486;
        static final int NT__444 = 487;
        static final int NT__445 = 488;
        static final int NT__446 = 489;
        static final int NT__447 = 490;
        static final int NT__448 = 491;
        static final int NT__449 = 492;
        static final int NT__450 = 493;
        static final int NT__451 = 494;
        static final int NT__452 = 495;
        static final int NT__453 = 496;
        static final int NT__454 = 497;
        static final int NT__455 = 498;
        static final int NT__456 = 499;
        static final int NT__457 = 500;
        static final int NT__458 = 501;
        static final int NT__459 = 502;
        static final int NT__460 = 503;
        static final int NT__461 = 504;
        static final int NT__462 = 505;
        static final int NT__463 = 506;
        static final int NT__464 = 507;
        static final int NT__465 = 508;
        static final int NT__466 = 509;
        static final int NT__467 = 510;
        static final int NT__468 = 511;
        static final int NT__469 = 512;
        static final int NT__470 = 513;
        static final int NT__471 = 514;
        static final int NT__472 = 515;
        static final int NT__473 = 516;
        static final int NT__474 = 517;
        static final int NT__475 = 518;
        static final int NT__476 = 519;
        static final int NT__477 = 520;
        static final int NT__478 = 521;
        static final int NT__479 = 522;
        static final int NT__480 = 523;
        static final int NT__481 = 524;
        static final int NT__482 = 525;
        static final int NT__483 = 526;
        static final int NT__484 = 527;
        static final int NT__485 = 528;
        static final int NT__486 = 529;
        static final int NT__487 = 530;
        static final int NT__488 = 531;
        static final int NT__489 = 532;
        static final int NT__490 = 533;
        static final int NT__491 = 534;
        static final int NT__492 = 535;
        static final int NT__493 = 536;
        static final int NT__494 = 537;
        static final int NT__495 = 538;
        static final int NT__496 = 539;
        static final int NT__497 = 540;
        static final int NT__498 = 541;
        static final int NT__499 = 542;
        static final int NT__500 = 543;
        static final int NT__501 = 544;
        static final int NT__502 = 545;
        static final int NT__503 = 546;
        static final int NT__504 = 547;
        static final int NT__505 = 548;
        static final int NT__506 = 549;
        static final int NT__507 = 550;
        static final int NT__508 = 551;
        static final int NT__509 = 552;
        static final int NT__510 = 553;
        static final int NT__511 = 554;
        static final int NT__512 = 555;
        static final int NT__513 = 556;
        static final int NT__514 = 557;
        static final int NT__515 = 558;
        static final int NT__516 = 559;
        static final int NT__517 = 560;
        static final int NT__518 = 561;
        static final int NT__519 = 562;
        static final int NT__520 = 563;
        static final int NT__521 = 564;
        static final int NT__522 = 565;
        static final int NT__523 = 566;
        static final int NT__524 = 567;
        static final int NT__525 = 568;
        static final int NT__526 = 569;
        static final int NT__527 = 570;
        static final int NT__528 = 571;
        static final int NT__529 = 572;
        static final int NT__530 = 573;
        static final int NT__531 = 574;
        static final int NT__532 = 575;
        static final int NT__533 = 576;
        static final int NT__534 = 577;
        static final int NT__535 = 578;
        static final int NT__536 = 579;
        static final int NT__537 = 580;
        static final int NT__538 = 581;
        static final int NT__539 = 582;
        static final int NT__540 = 583;
        static final int NT__541 = 584;
        static final int NT__542 = 585;
        static final int NT__543 = 586;
        static final int NT__544 = 587;
        static final int NT__545 = 588;
        static final int NT__546 = 589;
        static final int NT__547 = 590;
        static final int NT__548 = 591;
        static final int NT__549 = 592;
        static final int NT__550 = 593;
        static final int NT__551 = 594;
        static final int NT__552 = 595;
        static final int NT__553 = 596;
        static final int NT__554 = 597;
        static final int NT__555 = 598;
        static final int NT__556 = 599;
        static final int NT__557 = 600;
        static final int NT__558 = 601;
        static final int NT__559 = 602;
        static final int NT__560 = 603;
        static final int NT__561 = 604;
        static final int NT__562 = 605;
        static final int NT__563 = 606;
        static final int NT__564 = 607;
        static final int NT__565 = 608;
        static final int NT__566 = 609;
        static final int NT__567 = 610;
        static final int NT__568 = 611;
        static final int NT__569 = 612;
        static final int NT__570 = 613;
        static final int NT__571 = 614;
        static final int NT__572 = 615;
        static final int NT__573 = 616;
        static final int NT__574 = 617;
        static final int NT__575 = 618;
        static final int NT__576 = 619;
        static final int NT__577 = 620;
        static final int NT__578 = 621;
        static final int NT__579 = 622;
        static final int NT__580 = 623;
        static final int NT__581 = 624;
        static final int NT__582 = 625;
        static final int NT__583 = 626;
        static final int NT__584 = 627;
        static final int NT__585 = 628;
        static final int NT__586 = 629;
        static final int NT__587 = 630;
        static final int NT__588 = 631;
        static final int NT__589 = 632;
        static final int NT__590 = 633;
        static final int NT__591 = 634;
        static final int NT__592 = 635;
        static final int NT__593 = 636;
        static final int NT__594 = 637;
        static final int NT__595 = 638;
        static final int NT__596 = 639;
        static final int NT__597 = 640;
        static final int NT__598 = 641;
        static final int NT__599 = 642;
        static final int NT__600 = 643;
        static final int NT__601 = 644;
        static final int NT__602 = 645;
        static final int NT__603 = 646;
        static final int NT__604 = 647;
        static final int NT__605 = 648;
        static final int NT__606 = 649;
        static final int NT__607 = 650;
        static final int NT__608 = 651;
        static final int NT__609 = 652;
        static final int NT__610 = 653;
        static final int NT__611 = 654;
        static final int NT__612 = 655;
        static final int NT__613 = 656;
        static final int NT__614 = 657;
        static final int NT__615 = 658;
        static final int NT__616 = 659;
        static final int NT__617 = 660;
        static final int NT__618 = 661;
        static final int NT__619 = 662;
        static final int NT__620 = 663;
        static final int NT__621 = 664;
        static final int NT__622 = 665;
        static final int NT__623 = 666;
        static final int NT__624 = 667;
        static final int NT__625 = 668;
        static final int NT__626 = 669;
        static final int NT__627 = 670;
        static final int NT__628 = 671;
        static final int NT__629 = 672;
        static final int NT__630 = 673;
        static final int NT__631 = 674;
        static final int NT__632 = 675;
        static final int NT__633 = 676;
        static final int NT__634 = 677;
        static final int NT__635 = 678;
        static fina