/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.contrib;

import coins.backend.Data;
import coins.backend.Function;
import coins.backend.LocalTransformer;
import coins.backend.Root;
import coins.backend.ana.LoopAnalysis;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.contrib.DobSym;
import coins.backend.contrib.RPloop;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import coins.driver.CompileSpecification;

public class RegPromote {
    BiList LoopList = new BiList();
    public static final Trigger trig = new Trigger();
    BiList postAMBlist = new BiList();

    public static void attach(CompileSpecification spec, Root root) {
        if (spec.getCoinsOptions().isSet("regpromote")) {
            root.addHook("+AfterEarlyRewriting", trig);
        }
    }

    public void doIt(Function f) {
        BasicBlk blk;
        FlowGraph cfg = f.flowGraph();
        LoopAnalysis loopana = (LoopAnalysis)f.require(LoopAnalysis.analyzer);
        BiLink p = cfg.basicBlkList.first();
        while (!p.atEnd()) {
            blk = (BasicBlk)p.elem();
            if (loopana.isLoop[blk.id] && !loopana.multiEntry[blk.id]) {
                this.LoopList.add(new RPloop(blk, loopana.nestLevel[blk.id], f));
            }
            p = p.next();
        }
        p = cfg.basicBlkList.first();
        while (!p.atEnd()) {
            blk = (BasicBlk)p.elem();
            BiLink q = this.LoopList.first();
            while (!q.atEnd()) {
                BasicBlk temp = ((RPloop)q.elem()).head;
                if (temp == loopana.loopHeader[blk.id]) {
                    ((RPloop)q.elem()).member.add(blk);
                }
                q = q.next();
            }
            p = p.next();
        }
        p = this.LoopList.first();
        while (!p.atEnd()) {
            RPloop loop = (RPloop)p.elem();
            if (loop.nestLevel == 1) {
                this.compMember(loop);
            }
            p = p.next();
        }
        p = this.LoopList.first();
        while (!p.atEnd()) {
            ((RPloop)p.elem()).addExit();
            p = p.next();
        }
        p = this.LoopList.first();
        while (!p.atEnd()) {
            RPloop pelm = (RPloop)p.elem();
            BiLink q = this.LoopList.first();
            while (!q.atEnd()) {
                RPloop qelm = (RPloop)q.elem();
                if (pelm.nestLevel != 1 && qelm.nestLevel < pelm.nestLevel) {
                    boolean temp = true;
                    BiLink h = pelm.member.first();
                    while (!h.atEnd()) {
                        if (!qelm.member.contains((BasicBlk)h.elem())) {
                            temp = false;
                            break;
                        }
                        h = h.next();
                    }
                    if (temp) {
                        pelm.srndLoop.add(qelm);
                    }
                } else if (pelm.nestLevel == 1) {
                    // empty if block
                }
                q = q.next();
            }
            p = p.next();
        }
        p = this.LoopList.first();
        while (!p.atEnd()) {
            ((RPloop)p.elem()).getGV(this.postAMBlist);
            p = p.next();
        }
        p = this.LoopList.first();
        while (!p.atEnd()) {
            ((RPloop)p.elem()).getLIFT();
            p = p.next();
        }
        BiList slist = new BiList();
        BiList dobsymlist = new BiList();
        BiLink p2 = this.LoopList.first();
        while (!p2.atEnd()) {
            BiList list = ((RPloop)p2.elem()).L_Lift;
            BiLink q = list.first();
            while (!q.atEnd()) {
                Symbol rsym = (Symbol)q.elem();
                if (!slist.contains(rsym)) {
                    slist.add(rsym);
                    String name = (rsym.name + "%").intern();
                    Symbol regsym = f.addSymbol(name, 2, rsym.type, rsym.boundary, 0, null);
                    dobsymlist.add(new DobSym(rsym, regsym));
                }
                q = q.next();
            }
            p2 = p2.next();
        }
        p2 = this.LoopList.first();
        while (!p2.atEnd()) {
            ((RPloop)p2.elem()).insertNewInst(cfg, dobsymlist);
            ((RPloop)p2.elem()).PreCTR();
            p2 = p2.next();
        }
    }

    public BiList compMember(RPloop loop) {
        BiList blist = loop.member;
        BiLink q = blist.first();
        while (!q.atEnd()) {
            BasicBlk blk = (BasicBlk)q.elem();
            BiLink p = this.LoopList.first();
            while (!p.atEnd()) {
                RPloop lp = (RPloop)p.elem();
                if (lp != loop && blk == lp.head) {
                    blist = this.compMember(lp);
                    BiLink r = blist.first();
                    while (!r.atEnd()) {
                        BasicBlk b = (BasicBlk)r.elem();
                        if (!loop.member.contains(b)) {
                            loop.member.add(b);
                        }
                        r = r.next();
                    }
                }
                p = p.next();
            }
            q = q.next();
        }
        return loop.member;
    }

    private static class Trigger
    implements LocalTransformer {
        private Trigger() {
        }

        public boolean doIt(Function func, ImList args) {
            new RegPromote().doIt(func);
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "RegPromote";
        }

        public String subject() {
            return "Register Promotion";
        }
    }
}

