/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.cfg;

import coins.backend.Function;
import coins.backend.LocalAnalysis;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.DfstHook;
import coins.backend.lir.LirLabelRef;
import coins.backend.lir.LirNode;
import coins.backend.sym.Label;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.ImList;
import java.io.PrintWriter;
import java.util.Iterator;

public class FlowGraph {
    public final Function function;
    public final BiList basicBlkList = new BiList();
    private int blkCounter = 1;
    private int maxDfn;
    private int timeStamp = 0;
    private int dfstTimeStamp = 0;
    private BasicBlk entryBlk;
    private BasicBlk exitBlk;

    public FlowGraph(Function f, BiList anInstrList) {
        BasicBlk blk;
        this.function = f;
        boolean prevJump = false;
        boolean prevLabel = false;
        BiLink ptr = anInstrList.first();
        while (!ptr.atEnd()) {
            BiLink left = ptr.next();
            LirNode node = (LirNode)ptr.elem();
            if (ptr != anInstrList.first() && (prevJump || node.opCode == 52 && !prevLabel)) {
                BiList fragment = anInstrList;
                anInstrList = anInstrList.split(ptr);
                if (!prevJump) {
                    fragment.add(this.function.newLir.operator(49, 0, node.kid(0), null));
                }
                BasicBlk newBlk = this.newBasicBlk(fragment);
                if (((LirNode)fragment.first().elem()).opCode == 55) {
                    this.exitBlk = newBlk;
                }
                this.basicBlkList.add(newBlk);
            }
            if (node.opCode == 52) {
                prevLabel = true;
                prevJump = false;
            } else if (node.isBranch()) {
                prevJump = true;
                prevLabel = false;
            } else {
                prevJump = false;
                prevLabel = false;
            }
            ptr = left;
        }
        if (!anInstrList.isEmpty()) {
            BasicBlk newBlk = this.newBasicBlk(anInstrList);
            if (((LirNode)anInstrList.first().elem()).opCode == 55) {
                this.exitBlk = newBlk;
            }
            this.basicBlkList.add(newBlk);
        }
        this.entryBlk = (BasicBlk)this.basicBlkList.first().elem();
        BiLink bp = this.basicBlkList.first();
        while (!bp.atEnd()) {
            blk = (BasicBlk)bp.elem();
            blk.maintEdges();
            bp = bp.next();
        }
        bp = this.basicBlkList.first();
        while (!bp.atEnd()) {
            blk = (BasicBlk)bp.elem();
            if (!blk.instrList().isEmpty()) {
                LirNode ins = (LirNode)blk.instrList().last().elem();
                this.unifyLabels(ins);
            }
            bp = bp.next();
        }
        this.touch();
        this.dfstOrder();
    }

    private void unifyLabels(LirNode ins) {
        int n = ins.nKids();
        for (int i = 0; i < n; ++i) {
            if (ins.kid(i) instanceof LirLabelRef) {
                Label x = ((LirLabelRef)ins.kid((int)i)).label;
                if (x.basicBlk().label() == x) continue;
                ins.setKid(i, this.function.newLir.labelRef(x.basicBlk().label()));
                continue;
            }
            this.unifyLabels(ins.kid(i));
        }
    }

    public int timeStamp() {
        return this.timeStamp;
    }

    public void touch() {
        ++this.timeStamp;
        this.function.touch();
    }

    BasicBlk newBasicBlk(BiList instr) {
        return new BasicBlk(this, this.blkCounter++, instr);
    }

    public BasicBlk insertNewBlkBefore(BasicBlk x) {
        BiList list = new BiList();
        BasicBlk blk = this.newBasicBlk(list);
        list.add(this.function.newLir.operator(49, 0, this.function.newLir.labelRef(x.label()), null));
        this.basicBlkList.locate(x).addBefore(blk);
        blk.maintEdges();
        return blk;
    }

    public int idBound() {
        return this.blkCounter;
    }

    public void dfstOrder() {
        this.dfstOrderHook(null);
    }

    public void dfstOrderHook(DfstHook h) {
        if (this.dfstTimeStamp >= this.timeStamp) {
            return;
        }
        this.dfstTimeStamp = this.timeStamp;
        BiLink p = this.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk x = (BasicBlk)p.elem();
            x.dfnPre = 0;
            x.dfn = 0;
            x.parent = null;
            p = p.next();
        }
        int[] cpre = new int[1];
        int[] crpost = new int[1];
        this.entryBlk().depthFirstSearch(h, null, cpre, crpost);
        this.maxDfn = crpost[0];
        BiLink p2 = this.basicBlkList.first();
        while (!p2.atEnd()) {
            BasicBlk x = (BasicBlk)p2.elem();
            if (x.dfn != 0) {
                x.dfn = crpost[0] - x.dfn + 1;
            }
            p2 = p2.next();
        }
    }

    public int maxDfn() {
        return this.maxDfn;
    }

    public BasicBlk[] blkVectorByRPost() {
        this.dfstOrder();
        BasicBlk[] vec = new BasicBlk[this.maxDfn + 1];
        BiLink p = this.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            if (blk.dfn != 0) {
                vec[blk.dfn] = blk;
            }
            p = p.next();
        }
        return vec;
    }

    public BasicBlk[] blkVectorByPre() {
        this.dfstOrder();
        BasicBlk[] vec = new BasicBlk[this.maxDfn + 1];
        BiLink p = this.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            if (blk.dfnPre != 0) {
                vec[blk.dfnPre] = blk;
            }
            p = p.next();
        }
        return vec;
    }

    public BasicBlk entryBlk() {
        return this.entryBlk;
    }

    public BasicBlk exitBlk() {
        return this.exitBlk;
    }

    public Iterator basicBlkIterator() {
        return this.basicBlkList.iterator();
    }

    public Object toSexp() {
        ImList list = ImList.Empty;
        BiLink bp = this.basicBlkList.first();
        while (!bp.atEnd()) {
            BasicBlk blk = (BasicBlk)bp.elem();
            list = ((ImList)blk.toSexp()).destructiveReverse(list);
            bp = bp.next();
        }
        return list.destructiveReverse();
    }

    public void printStandardForm(PrintWriter output, String indent) {
        BiLink bp = this.basicBlkList.first();
        while (!bp.atEnd()) {
            BasicBlk blk = (BasicBlk)bp.elem();
            blk.printStandardForm(output, indent);
            bp = bp.next();
        }
    }

    public void printIt(PrintWriter output) {
        this.dfstOrder();
        BiLink bp = this.basicBlkList.first();
        while (!bp.atEnd()) {
            BasicBlk blk = (BasicBlk)bp.elem();
            blk.printIt(output);
            bp = bp.next();
        }
    }

    public void printIt(PrintWriter output, LocalAnalysis[] anals) {
        this.dfstOrder();
        BiLink bp = this.basicBlkList.first();
        while (!bp.atEnd()) {
            BasicBlk blk = (BasicBlk)bp.elem();
            blk.printIt(output, anals);
            bp = bp.next();
        }
    }
}

