/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.asmpp;

import coins.backend.asmpp.CPU;
import java.util.StringTokenizer;

final class Thumb
extends CPU {
    Thumb() {
        this.bccRange = new int[]{-240, 250};
        this.braRange = new int[]{-2024, 2024};
        this.literalRange = new int[]{0, 1020};
        this.bccMnemo = new String[]{"beq", "bne", "bcs", "bcc", "bhs", "blo", "bmi", "bpl", "bvs", "bvc", "bhi", "bls", "bge", "blt", "bgt", "ble"};
        this.braMnemo = "b";
        this.braLength = 2;
        this.codeAlign = 1;
    }

    public int codeLength(String inst) {
        String mnemo;
        StringTokenizer tokens = new StringTokenizer(inst, " \t,");
        if (tokens.hasMoreTokens() && (mnemo = tokens.nextToken()).equalsIgnoreCase("bl")) {
            return 4;
        }
        return 2;
    }

    public String[] rewriteToLongBranch(String label) {
        return new String[]{"\tbl\t" + label};
    }

    public String toString() {
        return "Thumb";
    }
}

