/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.asmpp;

import coins.backend.asmpp.AlignInstruction;
import coins.backend.asmpp.Arm;
import coins.backend.asmpp.AsmLine;
import coins.backend.asmpp.BccInstruction;
import coins.backend.asmpp.BraInstruction;
import coins.backend.asmpp.BraLtorgInstruction;
import coins.backend.asmpp.ByteInstruction;
import coins.backend.asmpp.CPU;
import coins.backend.asmpp.InstWithCode;
import coins.backend.asmpp.LabelInstruction;
import coins.backend.asmpp.LiteralInstruction;
import coins.backend.asmpp.LtorgInstruction;
import coins.backend.asmpp.NormalInstruction;
import coins.backend.asmpp.OtherInstruction;
import coins.backend.asmpp.Sh4;
import coins.backend.asmpp.ShortInstruction;
import coins.backend.asmpp.Thumb;
import coins.backend.asmpp.WordInstruction;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class LiteralAndBranchProcessor
extends Thread {
    OutputStream finalOut;
    PipedOutputStream out;
    PipedInputStream stream;
    PrintWriter wrt;
    ArrayList Instructions = new ArrayList();
    Hashtable Labels = new Hashtable();
    Hashtable LiteralTable = new Hashtable();
    ArrayList Ltorgs = new ArrayList();
    CPU cpu;
    boolean changed;
    int serialNumber = 1;

    private void dumpInstructions() {
        for (int i = 0; i < this.Instructions.size(); ++i) {
            AsmLine inst = (AsmLine)this.Instructions.get(i);
            this.wrt.println(inst.generate());
        }
    }

    private void debugDumpInstructions() {
        for (int i = 0; i < this.Instructions.size(); ++i) {
            System.out.println(this.Instructions.get(i));
        }
    }

    private void dumpLabels() {
        System.out.println("Labels:");
        Enumeration e = this.Labels.elements();
        while (e.hasMoreElements()) {
            LabelInstruction l = (LabelInstruction)e.nextElement();
            System.out.println(l.getName() + " = " + l.getAddress());
        }
    }

    private void calcAddress() {
        int pc = 0;
        for (int index = 0; index < this.Instructions.size(); ++index) {
            AsmLine inst = (AsmLine)this.Instructions.get(index);
            if (!(inst instanceof InstWithCode)) continue;
            pc = inst.setAddress(pc);
        }
    }

    private void insertBraLtorg() {
        int counter = -1;
        int limit = this.cpu.literalRange[1] * 95 / 100;
        for (int index = 0; index < this.Instructions.size(); ++index) {
            AsmLine inst = (AsmLine)this.Instructions.get(index);
            if (inst instanceof LtorgInstruction) {
                this.Ltorgs.add(inst);
                counter = -1;
                while (index + 1 < this.Instructions.size() && (AsmLine)this.Instructions.get(index + 1) instanceof LtorgInstruction) {
                    this.Instructions.remove(index + 1);
                }
            } else if (inst instanceof LiteralInstruction) {
                if (counter < 0) {
                    counter = 0;
                }
                counter += ((LiteralInstruction)inst).getLiteralSize();
            } else if (inst instanceof BraInstruction) {
                this.Instructions.add(index + 1, new LtorgInstruction("\t.ltorg"));
            }
            if (counter < 0 || (counter += inst.getSize()) <= limit || index + 1 < this.Instructions.size() && this.Instructions.get(index + 1) instanceof BraInstruction) continue;
            String s = "\t" + this.cpu.braMnemo + "\tLABEL";
            inst = new BraLtorgInstruction(s);
            this.Instructions.add(index, inst);
            this.Ltorgs.add(inst);
            counter = -1;
        }
        this.calcAddress();
    }

    private void convertLiteral() {
        int i;
        for (i = 0; i < this.Ltorgs.size(); ++i) {
            ((LtorgInstruction)this.Ltorgs.get(i)).reset();
        }
        this.calcAddress();
        Enumeration e = this.LiteralTable.elements();
        while (e.hasMoreElements()) {
            ArrayList a = (ArrayList)e.nextElement();
            LtorgInstruction blo = null;
            LtorgInstruction llo = null;
            for (i = 0; i < a.size(); ++i) {
                LiteralInstruction li = (LiteralInstruction)a.get(i);
                String value = li.getLiteral();
                int addr = li.getAddress();
                if (llo != null && this.cpu.inLiteralRange(llo.getAddressOf(value) - addr)) {
                    llo.addLiteral(value);
                    li.setLtorg(llo);
                } else if (blo != null && this.cpu.inLiteralRange(blo.getAddressOf(value) - addr)) {
                    blo.addLiteral(value);
                    li.setLtorg(blo);
                } else {
                    blo = null;
                    llo = null;
                    for (int j = 0; j < this.Ltorgs.size(); ++j) {
                        LtorgInstruction lo = (LtorgInstruction)this.Ltorgs.get(j);
                        if (!this.cpu.inLiteralRange(lo.getAddressOf(value) - addr)) continue;
                        if (lo instanceof BraLtorgInstruction) {
                            blo = (BraLtorgInstruction)lo;
                            continue;
                        }
                        llo = lo;
                    }
                    if (llo != null) {
                        llo.addLiteral(value);
                        li.setLtorg(llo);
                        blo = null;
                    } else if (blo != null) {
                        blo.addLiteral(value);
                        li.setLtorg(blo);
                    } else {
                        System.err.println("Literal allocation failed...");
                        System.exit(1);
                    }
                }
                this.calcAddress();
            }
        }
    }

    private void convertBranch() {
        for (int index = 0; index < this.Instructions.size(); ++index) {
            BraInstruction bra;
            int offset;
            LabelInstruction label;
            String labelName;
            AsmLine inst = (AsmLine)this.Instructions.get(index);
            if (inst instanceof BccInstruction) {
                BccInstruction bcc = (BccInstruction)inst;
                labelName = bcc.getLabel();
                label = (LabelInstruction)this.Labels.get(labelName);
                offset = label.getAddress() - bcc.getAddress();
                if (this.cpu.inBccRange(offset)) continue;
                this.Instructions.remove(index);
                String newLabelName = ".LB" + this.serialNumber++;
                String[] newcode = new String[]{"\t" + bcc.getRevMnemo() + "\t" + newLabelName, "\t" + this.cpu.braMnemo + "\t" + labelName, "\t.ltorg", newLabelName + ":"};
                for (int j = 0; j < newcode.length; ++j) {
                    inst = this.createInstruction(newcode[j]);
                    this.Instructions.add(index++, inst);
                }
                this.calcAddress();
                this.changed = true;
                continue;
            }
            if (!(inst instanceof BraInstruction) || this.cpu.inBraRange(offset = (label = (LabelInstruction)this.Labels.get(labelName = (bra = (BraInstruction)inst).getLabel())).getAddress() - bra.getAddress())) continue;
            this.Instructions.remove(index);
            String[] newcode = this.cpu.rewriteToLongBranch(labelName);
            for (int j = 0; j < newcode.length; ++j) {
                inst = this.createInstruction(newcode[j]);
                this.Instructions.add(index++, inst);
            }
            this.calcAddress();
            this.changed = true;
        }
    }

    private void convert() {
        int pass = 0;
        this.calcAddress();
        this.convertBranch();
        this.insertBraLtorg();
        do {
            if (++pass > 10) {
                System.err.println("Too many passes...");
                System.exit(1);
            }
            this.changed = false;
            this.convertLiteral();
            this.convertBranch();
        } while (this.changed);
        for (int index = 0; index < this.Instructions.size(); ++index) {
            AsmLine l = (AsmLine)this.Instructions.get(index);
            if (!(l instanceof LtorgInstruction)) continue;
            int n = ((LtorgInstruction)l).setLabel(this.serialNumber);
            if (n > 0) {
                this.serialNumber += n;
                continue;
            }
            this.Instructions.remove(index);
            --index;
        }
        this.dumpInstructions();
    }

    private AsmLine parse(String line) {
        StringTokenizer tokens = new StringTokenizer(line, " \t,");
        if (tokens.hasMoreTokens()) {
            String s = tokens.nextToken();
            if (s.charAt(0) == '@' || s.charAt(0) == '#') {
                return new OtherInstruction(line);
            }
            if (s.charAt(s.length() - 1) == ':') {
                return new LabelInstruction(line, s.substring(0, s.length() - 1));
            }
            if (s.equalsIgnoreCase(".align")) {
                return new AlignInstruction(line, Integer.parseInt(tokens.nextToken()));
            }
            if (s.equalsIgnoreCase(".ltorg")) {
                return new LtorgInstruction(line);
            }
            if (s.equalsIgnoreCase(".ltorg2")) {
                return new BraLtorgInstruction(line);
            }
            if (s.equalsIgnoreCase(".word") || s.equalsIgnoreCase(".long")) {
                int params = 0;
                while (tokens.hasMoreTokens()) {
                    tokens.nextToken();
                    ++params;
                }
                return new WordInstruction(line, params);
            }
            if (s.equalsIgnoreCase(".short")) {
                int params = 0;
                while (tokens.hasMoreTokens()) {
                    tokens.nextToken();
                    ++params;
                }
                return new ShortInstruction(line, params);
            }
            if (s.equalsIgnoreCase(".byte")) {
                int params = 0;
                while (tokens.hasMoreTokens()) {
                    tokens.nextToken();
                    ++params;
                }
                return new ByteInstruction(line, params);
            }
            if (this.cpu.isBcc(s)) {
                return new BccInstruction(line, s, tokens.nextToken());
            }
            if (this.cpu.isBra(s)) {
                return new BraInstruction(line, tokens.nextToken());
            }
            if (s.charAt(0) == '.') {
                return new OtherInstruction(line);
            }
            while (tokens.hasMoreTokens()) {
                s = tokens.nextToken();
                if (!s.startsWith("=B") && !s.startsWith("=S") && !s.startsWith("=W") && !s.startsWith("=D")) continue;
                return new LiteralInstruction(line, s);
            }
            return new NormalInstruction(line);
        }
        return new OtherInstruction(line);
    }

    private AsmLine createInstruction(String line) {
        AsmLine inst = this.parse(line);
        if (inst instanceof LabelInstruction) {
            this.Labels.put(((LabelInstruction)inst).getName(), inst);
        }
        if (inst instanceof LiteralInstruction) {
            LiteralInstruction l = (LiteralInstruction)inst;
            String value = l.getLiteral();
            ArrayList<LiteralInstruction> a = (ArrayList<LiteralInstruction>)this.LiteralTable.get(value);
            if (a == null) {
                a = new ArrayList<LiteralInstruction>();
                this.LiteralTable.put(value, a);
            }
            a.add(l);
        }
        return inst;
    }

    private LiteralAndBranchProcessor(String name, OutputStream finalOut) {
        super(name);
        try {
            this.out = new PipedOutputStream();
            this.stream = new PipedInputStream(this.out);
            this.finalOut = finalOut;
        }
        catch (IOException e) {
            throw new Error(e.getMessage());
        }
    }

    public OutputStream pipeTo() {
        return this.out;
    }

    public void run() {
        try {
            String line;
            int pc = 0;
            BufferedReader rdr = new BufferedReader(new InputStreamReader(this.stream));
            this.wrt = new PrintWriter(this.finalOut);
            while ((line = rdr.readLine()) != null) {
                AsmLine inst = this.createInstruction(line);
                pc = inst.setAddress(pc);
                this.Instructions.add(inst);
                if (!inst.getLine().startsWith("@endfunction")) continue;
                this.convert();
                this.Instructions.clear();
                this.Labels.clear();
                this.LiteralTable.clear();
                this.Ltorgs.clear();
                pc = 0;
            }
            this.convert();
            this.wrt.close();
        }
        catch (IOException e) {
            throw new Error(e.getMessage());
        }
    }

    public static LiteralAndBranchProcessor postProcessor(OutputStream finalOut) {
        LiteralAndBranchProcessor thr = new LiteralAndBranchProcessor("LiteralAndBranchProcessor", finalOut);
        thr.start();
        return thr;
    }

    public void notifyEnd() {
        try {
            this.out.close();
            this.join();
        }
        catch (IOException e) {
            throw new Error(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new Error(e.getMessage());
        }
    }

    public void setCPU(CPU cpu) {
        this.cpu = cpu;
        AsmLine.cpu = cpu;
    }

    public static void main(String[] args) {
        boolean err = false;
        LiteralAndBranchProcessor pp = LiteralAndBranchProcessor.postProcessor(System.out);
        if (args.length > 0) {
            if (args[0].equalsIgnoreCase("arm")) {
                pp.setCPU(new Arm());
            } else if (args[0].equalsIgnoreCase("thumb")) {
                pp.setCPU(new Thumb());
            } else if (args[0].equalsIgnoreCase("sh4")) {
                pp.setCPU(new Sh4());
            } else {
                err = true;
            }
        } else {
            err = true;
        }
        if (err) {
            System.err.println("Usage: LiteralAndBranchProcessor arm|thumb|sh4");
            System.exit(1);
        }
        try {
            int len;
            OutputStream out = pp.pipeTo();
            byte[] buffer = new byte[1000];
            while ((len = System.in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            out.close();
            pp.notifyEnd();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

