/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.ana;

import coins.backend.Function;
import coins.backend.LocalAnalysis;
import coins.backend.LocalAnalyzer;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirNode;
import coins.backend.util.BiLink;
import java.io.PrintWriter;

public class ReverseDFST
implements LocalAnalysis {
    public static final Analyzer analyzer = new Analyzer();
    public final int[] dfn;
    public final int[] dfnPre;
    public final BasicBlk[] parent;
    public final int maxDfn;
    private FlowGraph flowGraph;
    private int timeStamp;
    private int cpre;
    private int crpost;

    private ReverseDFST(FlowGraph g) {
        this.flowGraph = g;
        this.timeStamp = this.flowGraph.timeStamp();
        int nblks = this.flowGraph.idBound();
        this.dfn = new int[nblks];
        this.dfnPre = new int[nblks];
        this.parent = new BasicBlk[nblks];
        this.crpost = 0;
        this.cpre = 0;
        this.depthFirstSearch(this.flowGraph.exitBlk(), null);
        this.maxDfn = this.cpre;
        BiLink p = this.flowGraph.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk x = (BasicBlk)p.elem();
            if (this.dfn[x.id] != 0) {
                int n = x.id;
                this.dfn[n] = this.dfn[n] + (1 - this.crpost);
            }
            p = p.next();
        }
    }

    void depthFirstSearch(BasicBlk blk, BasicBlk from) {
        BasicBlk y;
        this.dfnPre[blk.id] = ++this.cpre;
        this.parent[blk.id] = from;
        BiLink p = blk.predList().first();
        while (!p.atEnd()) {
            y = (BasicBlk)p.elem();
            if (this.dfnPre[y.id] == 0) {
                this.depthFirstSearch(y, blk);
            }
            p = p.next();
        }
        p = blk.dummyPredList().first();
        while (!p.atEnd()) {
            y = (BasicBlk)p.elem();
            if (this.dfnPre[y.id] == 0) {
                this.depthFirstSearch(y, blk);
            }
            p = p.next();
        }
        this.dfn[blk.id] = --this.crpost;
    }

    public boolean isUpToDate() {
        return this.timeStamp == this.flowGraph.timeStamp();
    }

    public void printBeforeFunction(PrintWriter output) {
    }

    public void printBeforeBlock(BasicBlk blk, PrintWriter output) {
        output.println("    Reverse DFN=(" + this.dfnPre[blk.id] + "," + this.dfn[blk.id] + ")");
    }

    public void printAfterBlock(BasicBlk blk, PrintWriter output) {
    }

    public void printBeforeStmt(LirNode stmt, PrintWriter output) {
    }

    public void printAfterStmt(LirNode stmt, PrintWriter output) {
    }

    public void printAfterFunction(PrintWriter out) {
    }

    public void printIt(PrintWriter out) {
    }

    private static class Analyzer
    implements LocalAnalyzer {
        private Analyzer() {
        }

        public LocalAnalysis doIt(Function func) {
            return new ReverseDFST(func.flowGraph());
        }

        public String name() {
            return "ReverseDFST";
        }
    }
}

