/*
 * Decompiled with CFR 0.152.
 */
package coins.backend.ana;

import coins.backend.Function;
import coins.backend.LocalAnalysis;
import coins.backend.LocalAnalyzer;
import coins.backend.ana.EnumRegVars;
import coins.backend.ana.LiveVariableAnalysis;
import coins.backend.ana.ScanVarReference;
import coins.backend.cfg.BasicBlk;
import coins.backend.cfg.FlowGraph;
import coins.backend.lir.LirNode;
import coins.backend.sym.Symbol;
import coins.backend.util.BiLink;
import coins.backend.util.BiList;
import coins.backend.util.HashNumberSet;
import coins.backend.util.Misc;
import coins.backend.util.NumberSet;
import java.io.PrintWriter;

public class LiveVariableSlotwise
implements LocalAnalysis,
LiveVariableAnalysis {
    public static final Analyzer analyzer = new Analyzer();
    private NumberSet[] in;
    private NumberSet[] out;
    private EnumRegVars rn;
    private Function function;
    private FlowGraph flowGraph;
    private int timeStamp;

    private LiveVariableSlotwise(Function f) {
        this.function = f;
        this.flowGraph = f.flowGraph();
        this.timeStamp = this.function.timeStamp();
        this.rn = (EnumRegVars)f.require(EnumRegVars.analyzer);
        ScanVarReference sc = (ScanVarReference)f.require(ScanVarReference.analyzer);
        int maxvar = this.rn.nRegvars();
        this.in = new NumberSet[this.flowGraph.idBound()];
        this.out = new NumberSet[this.flowGraph.idBound()];
        BiLink p = this.flowGraph.basicBlkList.first();
        while (!p.atEnd()) {
            BasicBlk blk = (BasicBlk)p.elem();
            this.in[blk.id] = new HashNumberSet(maxvar);
            this.out[blk.id] = new HashNumberSet(maxvar);
            p = p.next();
        }
        BasicBlk[] worklist = new BasicBlk[this.flowGraph.idBound()];
        int[] incheck = new int[this.flowGraph.idBound()];
        int[] outcheck = new int[this.flowGraph.idBound()];
        for (int vid = 1; vid < maxvar; ++vid) {
            BasicBlk blk;
            BiLink q;
            if (sc.useSites[vid] == null && sc.outUseSites[vid] == null) continue;
            int nw = 0;
            if (sc.useSites[vid] != null) {
                q = sc.useSites[vid].first();
                while (!q.atEnd()) {
                    blk = (BasicBlk)q.elem();
                    incheck[blk.id] = vid;
                    this.in[blk.id].add(vid);
                    worklist[nw++] = blk;
                    q = q.next();
                }
            }
            if (sc.defSites[vid] != null) {
                q = sc.defSites[vid].first();
                while (!q.atEnd()) {
                    blk = (BasicBlk)q.elem();
                    incheck[blk.id] = vid;
                    q = q.next();
                }
            }
            if (sc.outUseSites[vid] != null) {
                q = sc.outUseSites[vid].first();
                while (!q.atEnd()) {
                    blk = (BasicBlk)q.elem();
                    this.out[blk.id].add(vid);
                    outcheck[blk.id] = vid;
                    if (incheck[blk.id] != vid) {
                        incheck[blk.id] = vid;
                        this.in[blk.id].add(vid);
                        worklist[nw++] = blk;
                    }
                    q = q.next();
                }
            }
            while (nw > 0) {
                BasicBlk blk2;
                if (sc.phiDefSite[vid] == (blk2 = worklist[--nw])) continue;
                BiLink r = blk2.predList().first();
                while (!r.atEnd()) {
                    BasicBlk pred = (BasicBlk)r.elem();
                    if (outcheck[pred.id] != vid) {
                        outcheck[pred.id] = vid;
                        this.out[pred.id].add(vid);
                        if (incheck[pred.id] != vid) {
                            incheck[pred.id] = vid;
                            this.in[pred.id].add(vid);
                            worklist[nw++] = pred;
                        }
                    }
                    r = r.next();
                }
            }
        }
    }

    public boolean isLiveAtEntry(Symbol regvar, BasicBlk blk) {
        return this.in[blk.id].contains(this.rn.index(regvar));
    }

    public boolean isLiveAtEntry(int regvar, BasicBlk blk) {
        return this.in[blk.id].contains(regvar);
    }

    public boolean isLiveAtExit(Symbol regvar, BasicBlk blk) {
        return this.out[blk.id].contains(this.rn.index(regvar));
    }

    public boolean isLiveAtExit(int regvar, BasicBlk blk) {
        return this.out[blk.id].contains(regvar);
    }

    public BiList liveOut(BasicBlk blk) {
        BiList live = new BiList();
        NumberSet.Iterator it = this.out[blk.id].iterator();
        while (it.hasNext()) {
            live.add(this.rn.toSymbol(it.next()));
        }
        return live;
    }

    public BiList liveIn(BasicBlk blk) {
        BiList live = new BiList();
        NumberSet.Iterator it = this.in[blk.id].iterator();
        while (it.hasNext()) {
            live.add(this.rn.toSymbol(it.next()));
        }
        return live;
    }

    public NumberSet liveInSet(BasicBlk blk) {
        return this.in[blk.id];
    }

    public NumberSet liveOutSet(BasicBlk blk) {
        return this.out[blk.id];
    }

    public void getLiveOutSet(NumberSet x, BasicBlk blk) {
        x.copy(this.out[blk.id]);
    }

    public void addLiveOutSet(NumberSet x, BasicBlk blk) {
        x.addAll(this.out[blk.id]);
    }

    public void getLiveInSet(NumberSet x, BasicBlk blk) {
        x.copy(this.in[blk.id]);
    }

    public void addLiveInSet(NumberSet x, BasicBlk blk) {
        x.addAll(this.in[blk.id]);
    }

    public boolean isUpToDate() {
        return this.timeStamp == this.function.timeStamp();
    }

    private void printLive(String head, NumberSet live, PrintWriter output) {
        output.print(head);
        int[] v = new int[live.size()];
        live.toArray(v);
        Misc.sort(v, v.length);
        for (int i = 0; i < v.length; ++i) {
            output.print(" " + this.rn.toString(v[i]));
        }
        output.println();
    }

    public void printBeforeFunction(PrintWriter output) {
    }

    public void printBeforeBlock(BasicBlk blk, PrintWriter output) {
        this.printLive("    in:", this.in[blk.id], output);
    }

    public void printAfterBlock(BasicBlk blk, PrintWriter output) {
        this.printLive("   out:", this.out[blk.id], output);
    }

    public void printBeforeStmt(LirNode stmt, PrintWriter output) {
    }

    public void printAfterStmt(LirNode stmt, PrintWriter output) {
    }

    public void printAfterFunction(PrintWriter output) {
    }

    private static class Analyzer
    implements LocalAnalyzer {
        private Analyzer() {
        }

        public LocalAnalysis doIt(Function func) {
            return new LiveVariableSlotwise(func);
        }

        public String name() {
            return "LiveVariableSlotwise";
        }
    }
}

