/*
 * Decompiled with CFR 0.152.
 */
package coins.backend;

import coins.backend.CantHappenException;
import coins.backend.SyntaxError;

public class Type {
    private static final int TAGWIDTH = 4;
    private static final int TAGMASK = 15;
    private static final int BITSMASK = 0xFFFFFFF;
    private static final int MAXBITS = 0xFFFFFFF;
    private static final int AGGRBIT = 1;
    private static final int AGGRBYTEMASK = Integer.MAX_VALUE;
    private static final int MAXAGGRBYTES = Integer.MAX_VALUE;
    public static final int UNKNOWN = 0;
    public static final int AGGREGATE = 1;
    public static final int INT = 2;
    public static final int FLOAT = 4;

    private Type() {
    }

    public static String toString(int type) {
        if (Type.isAggregate(type)) {
            return "A" + (long)Type.aggregateBytes(type) * 8L;
        }
        int bits = Type.bits(type);
        switch (type & 0xF) {
            case 0: {
                return "UNKNOWN";
            }
            case 2: {
                return "I" + bits;
            }
            case 4: {
                return "F" + bits;
            }
            case 1: {
                return "A" + bits;
            }
        }
        throw new IllegalArgumentException("bad type");
    }

    public static boolean isAggregate(int type) {
        return (type & 1) != 0;
    }

    public static int tag(int type) {
        if (Type.isAggregate(type)) {
            return 1;
        }
        return type & 0xF;
    }

    private static int aggregateBytes(int type) {
        return type >> 1 & Integer.MAX_VALUE;
    }

    public static int bits(int type) {
        if (Type.isAggregate(type)) {
            throw new CantHappenException("aggregate bit required");
        }
        return type >> 4 & 0xFFFFFFF;
    }

    public static int bytes(int type) {
        if (Type.isAggregate(type)) {
            return Type.aggregateBytes(type);
        }
        return ((type >> 4 & 0xFFFFFFF) + 7) / 8;
    }

    public static int type(int tag, long bits) {
        try {
            return Type.typeCheck(tag, bits);
        }
        catch (SyntaxError e) {
            throw new CantHappenException(e.getMessage());
        }
    }

    private static int typeCheck(int tag, long bits) throws SyntaxError {
        if (tag == 1) {
            if (bits % 8L != 0L) {
                throw new SyntaxError("Aggregate size not multiple of 8: " + bits);
            }
            int bytes = (int)(bits / 8L);
            if (bytes < 0 || bytes > Integer.MAX_VALUE) {
                throw new SyntaxError("Aggregate size out of range: " + bits + " (MAX " + 0x3FFFFFFF8L + ")");
            }
            return 1 + (bytes << 1);
        }
        if (bits < 0L || bits > 0xFFFFFFFL) {
            throw new SyntaxError("Typebits out of range: " + bits + " (MAX " + 0xFFFFFFF + ")");
        }
        return tag + ((int)bits << 4);
    }

    public static int decode(String word) throws SyntaxError {
        if (word == "UNKNOWN") {
            return 0;
        }
        if (word.charAt(0) == 'I') {
            return Type.typeCheck(2, Integer.parseInt(word.substring(1)));
        }
        if (word.charAt(0) == 'F') {
            return Type.typeCheck(4, Integer.parseInt(word.substring(1)));
        }
        if (word.charAt(0) == 'A') {
            return Type.typeCheck(1, Long.parseLong(word.substring(1)));
        }
        throw new SyntaxError("Type expected but " + word);
    }
}

