/*
 * Decompiled with CFR 0.152.
 */
package coins.backend;

import coins.backend.CantHappenException;
import coins.backend.Data;
import coins.backend.Function;
import coins.backend.GlobalTransformer;
import coins.backend.LocalTransformer;
import coins.backend.MachineParams;
import coins.backend.Module;
import coins.backend.Root;
import coins.backend.SyntaxError;
import coins.backend.Tmd;
import coins.backend.Type;
import coins.backend.gen.CodeGenerator;
import coins.backend.lir.LirNode;
import coins.backend.sym.SymTab;
import coins.backend.util.ImList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.PushbackReader;
import java.io.StringReader;

public class TargetMachine {
    public final MachineParams machineParams;
    public final int typeAddress;
    public final int typeBool;
    private Root root;
    private Tmd tmd;
    private CodeGenerator targetCG;
    private OutputStream asmStream;
    public final GlobalTransformer earlyRewritingTrig = new GlobalTransformer(){

        public boolean doIt(Module module, ImList args) {
            if (((TargetMachine)TargetMachine.this).root.javaCG) {
                module.apply(TargetMachine.this.targetCG.earlyRewritingSequence());
            }
            return true;
        }

        public String name() {
            return "EarlyRewriting";
        }

        public String subject() {
            return "Early-time Rewriting";
        }
    };
    public final GlobalTransformer lateRewritingTrig = new GlobalTransformer(){

        public boolean doIt(Module module, ImList args) {
            if (((TargetMachine)TargetMachine.this).root.javaCG) {
                module.apply(TargetMachine.this.targetCG.lateRewritingSequence());
            } else {
                module.apply(TargetMachine.this.restructTrig);
            }
            return true;
        }

        public String name() {
            return "LateRewriting";
        }

        public String subject() {
            return "Late-time Rewriting";
        }
    };
    final LocalTransformer restructTrig = new LocalTransformer(){

        public boolean doIt(Function func, ImList args) {
            TargetMachine.this.restruct2(func);
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "LocalLateRewriting";
        }

        public String subject() {
            return "Late-time Rewriting (local)";
        }
    };
    public final LocalTransformer instSelTrig = new LocalTransformer(){

        public boolean doIt(Function func, ImList args) {
            TargetMachine.this.instSel2(func);
            return true;
        }

        public boolean doIt(Data data, ImList args) {
            return true;
        }

        public String name() {
            return "InstSel";
        }

        public String subject() {
            return "Instruction Selection";
        }
    };
    public final GlobalTransformer convToAsmTrig = new GlobalTransformer(){

        public boolean doIt(Module module, ImList args) {
            if (((TargetMachine)TargetMachine.this).root.javaCG) {
                TargetMachine.this.targetCG.genHeader(module);
                module.apply(TargetMachine.this.targetCG.convToAsm());
                TargetMachine.this.targetCG.genTrailer(module);
                TargetMachine.this.targetCG.close();
            } else {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                PrintWriter out = new PrintWriter(bytes);
                module.printStandardForm(out);
                out.close();
                TargetMachine.this.tmd.asmout(bytes.toString(), new PrintWriter(TargetMachine.this.asmStream));
            }
            return true;
        }

        public String name() {
            return "ConvToAsm";
        }

        public String subject() {
            return "Convert to Assembly Language";
        }
    };

    public TargetMachine(SymTab symTab, String targetName, String convention, Module module) {
        this.root = module.root;
        this.root.registerTransformer(this.earlyRewritingTrig);
        this.root.registerTransformer(this.lateRewritingTrig);
        this.root.registerTransformer(this.instSelTrig);
        this.root.registerTransformer(this.convToAsmTrig);
        try {
            if (this.root.javaCG) {
                this.machineParams = (MachineParams)Class.forName("coins.backend.gen.MachineParams_" + targetName).newInstance();
                this.machineParams.init(module, symTab);
                this.typeAddress = this.machineParams.typeAddress();
                this.typeBool = this.machineParams.typeBool();
                this.targetCG = (CodeGenerator)Class.forName("coins.backend.gen.CodeGenerator_" + targetName).newInstance();
                this.targetCG.initialize(this.root, module, this, targetName, convention);
            } else {
                this.machineParams = (MachineParams)Class.forName("coins.backend.tmd.MachineParams_" + targetName).newInstance();
                this.machineParams.init(module, symTab);
                this.typeAddress = this.machineParams.typeAddress();
                this.typeBool = this.machineParams.typeBool();
                this.tmd = (Tmd)Class.forName("coins.backend.tmd.TMD").newInstance();
                this.tmd.init(targetName);
                if (!this.root.traceOK("TMD", 3)) {
                    this.tmd.evals("(set! *debug* ())");
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new Error("Class not found: " + e.getMessage());
        }
        catch (InstantiationException e) {
            throw new Error("Can't new: " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new Error("Illegal access: " + e.getMessage());
        }
        catch (IOException e) {
            throw new Error("IOException: " + e.getMessage());
        }
    }

    public void setAsmStream(OutputStream stream) {
        this.asmStream = stream;
        if (this.root.javaCG) {
            this.targetCG.setAsmStream(stream);
        }
    }

    public int alignForType(int type) {
        if (this.root.javaCG) {
            return this.targetCG.alignForType(type);
        }
        int s = Type.bytes(type);
        switch (s) {
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                return 1;
            }
            case 2: 
            case 6: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 8: {
                return 8;
            }
        }
        return 8;
    }

    public void restruct2(Function func) {
        if (this.root.javaCG) {
            throw new CantHappenException();
        }
        try {
            Object sexp;
            String rewrittenCode = null;
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            PrintWriter out = new PrintWriter(bytes);
            func.printStandardForm(out);
            out.close();
            if (this.root.dispIntervalTime) {
                this.root.debOut.println(" ASCII-form convertion: " + this.root.timer.getIntervalTime());
            }
            if (this.root.traceOK("TMD", 2)) {
                this.root.debOut.println();
                this.root.debOut.println("Before restruct: ");
                this.root.debOut.print(bytes.toString());
                this.root.debOut.flush();
            }
            if (rewrittenCode == null) {
                rewrittenCode = this.tmd.restructure(bytes.toString());
            }
            if (this.root.dispIntervalTime) {
                this.root.debOut.println(" Restructuring: " + this.root.timer.getIntervalTime());
            }
            if (this.root.traceOK("TMD", 2)) {
                this.root.debOut.println();
                this.root.debOut.println("After restruct: ");
                this.root.debOut.print(rewrittenCode);
                this.root.debOut.println();
                this.root.debOut.flush();
            }
            if (!((sexp = ImList.readSexp(new PushbackReader(new StringReader(rewrittenCode)))) instanceof ImList)) {
                throw new CantHappenException("readSexp returns null or atom object");
            }
            func.reload((ImList)sexp);
            if (this.root.dispIntervalTime) {
                this.root.debOut.println(" Reload: " + this.root.timer.getIntervalTime());
            }
        }
        catch (SyntaxError e) {
            throw new CantHappenException(e.toString());
        }
        catch (IOException e) {
            throw new CantHappenException(e.toString());
        }
    }

    public CodeGenerator getTargetCG() {
        if (!this.root.javaCG) {
            throw new CantHappenException("not Java CG");
        }
        return this.targetCG;
    }

    public void instSel2(Function func) {
        if (this.root.javaCG) {
            this.targetCG.instructionSelection(func);
        } else {
            try {
                Object sexp;
                String machineDepStr = null;
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                PrintWriter out = new PrintWriter(bytes);
                func.printStandardForm(out);
                out.close();
                if (this.root.dispIntervalTime) {
                    this.root.debOut.println(" ASCII-form convertion: " + this.root.timer.getIntervalTime());
                }
                if (this.root.traceOK("TMD", 2)) {
                    this.root.debOut.println();
                    this.root.debOut.println("Before instsel: ");
                    this.root.debOut.print(bytes.toString());
                    this.root.debOut.flush();
                }
                if (machineDepStr == null) {
                    machineDepStr = this.tmd.instsel(bytes.toString());
                }
                if (this.root.dispIntervalTime) {
                    this.root.debOut.println(" Instruction Selection: " + this.root.timer.getIntervalTime());
                }
                if (this.root.traceOK("TMD", 2)) {
                    this.root.debOut.println();
                    this.root.debOut.println("After instsel: ");
                    this.root.debOut.print(machineDepStr);
                    this.root.debOut.println();
                    this.root.debOut.flush();
                }
                if (!((sexp = ImList.readSexp(new PushbackReader(new StringReader(machineDepStr)))) instanceof ImList)) {
                    throw new CantHappenException("readSexp returns null or atom object");
                }
                func.reload((ImList)sexp);
                if (this.root.dispIntervalTime) {
                    this.root.debOut.println(" Reload: " + this.root.timer.getIntervalTime());
                }
            }
            catch (SyntaxError e) {
                throw new CantHappenException(e.toString());
            }
            catch (IOException e) {
                throw new CantHappenException(e.toString());
            }
        }
    }

    public void emitNamedConst(String name, LirNode value) {
        if (this.root.javaCG) {
            this.targetCG.emitNamedConst(name, value);
        }
    }
}

