/*
 * Decompiled with CFR 0.152.
 */
package coins.backend;

import coins.backend.LocalAnalyzer;
import coins.backend.Module;
import coins.backend.Root;
import coins.backend.SyntaxError;
import coins.backend.sym.SymStatic;
import java.io.PrintWriter;

public abstract class ModuleElement {
    public final Module module;
    public final Root root;
    public final SymStatic symbol;
    public final int sourceLineNo;

    ModuleElement(Module module, String name) throws SyntaxError {
        this.module = module;
        this.root = module.root;
        this.symbol = (SymStatic)module.globalSymtab.get(name);
        if (this.symbol == null) {
            throw new SyntaxError("Undefined symbol: " + name);
        }
        this.symbol.setBody(this);
        this.sourceLineNo = module.getCurrentLineNo();
    }

    ModuleElement(Module module, SymStatic symbol) {
        this.module = module;
        this.root = module.root;
        this.symbol = symbol;
        symbol.setBody(this);
        this.sourceLineNo = module.getCurrentLineNo();
    }

    public abstract Object toSexp();

    public abstract void printStandardForm(PrintWriter var1);

    public abstract void printIt(PrintWriter var1);

    public abstract void printIt(PrintWriter var1, LocalAnalyzer[] var2);
}

