/*
 * Decompiled with CFR 0.152.
 */
package coins.backend;

import coins.backend.CantHappenException;
import coins.backend.LocalAnalyzer;
import coins.backend.LocalTransformer;
import coins.backend.Module;
import coins.backend.ModuleElement;
import coins.backend.SyntaxError;
import coins.backend.Type;
import coins.backend.lir.LirFactory;
import coins.backend.lir.LirFconst;
import coins.backend.lir.LirIconst;
import coins.backend.lir.LirNode;
import coins.backend.sym.SymStatic;
import coins.backend.sym.Symbol;
import coins.backend.util.ImList;
import coins.backend.util.QuotedString;
import java.io.PrintWriter;

public class Data
extends ModuleElement {
    public final LirNode[] components;
    private final LirFactory newLir;

    public Data(Module module, ImList ptr) throws SyntaxError {
        super(module, ((QuotedString)ptr.elem2nd()).body);
        this.newLir = module.newLir;
        if (ptr.elem() != "DATA") {
            throw new SyntaxError("DATA expected but: " + ptr.elem());
        }
        ptr = ptr.next();
        ptr = ptr.next();
        int nelem = ptr.length();
        this.components = new LirNode[nelem];
        for (int i = 0; i < nelem; ++i) {
            if (ptr.atEnd()) {
                throw new CantHappenException();
            }
            this.components[i] = this.newLir.evalTree(this.newLir.decodeDataCompo((ImList)ptr.elem(), module));
            ptr = ptr.next();
        }
    }

    public Data(Module module, Symbol sym, LirNode value) {
        super(module, (SymStatic)sym);
        this.newLir = module.newLir;
        this.components = new LirNode[1];
        switch (value.opCode) {
            case 2: 
            case 3: {
                this.components[0] = this.newLir.node(61, value.type, value);
                break;
            }
            case 63: 
            case 64: {
                this.components[0] = value;
                break;
            }
            default: {
                throw new CantHappenException("Attempt to make non-constant DATA object.");
            }
        }
    }

    public LirNode scalerValue() {
        if (this.components.length == 1 && this.components[0].opCode == 61 && this.components[0].nKids() == 1) {
            return this.components[0].kid(0);
        }
        return null;
    }

    public boolean apply(LocalTransformer xform, ImList args) {
        return xform.doIt(this, args);
    }

    public boolean apply(LocalTransformer xform) {
        return xform.doIt(this, ImList.list());
    }

    public Object toSexp() {
        ImList list = ImList.Empty;
        list = new ImList("DATA", list);
        list = new ImList(new QuotedString(this.symbol.name), list);
        for (int i = 0; i < this.components.length; ++i) {
            LirNode node = this.components[i];
            if (node.opCode == 61) {
                ImList sub = ImList.Empty;
                sub = new ImList(Type.toString(node.type), sub);
                int n = node.nKids();
                for (int j = 0; j < n; ++j) {
                    LirNode elem = node.kid(j);
                    sub = elem.opCode == 2 ? new ImList(((LirIconst)elem).value + "", sub) : (elem.opCode == 3 ? new ImList(((LirFconst)elem).value + "", sub) : new ImList(elem.toSexp(), sub));
                }
                list = new ImList(sub.destructiveReverse(), list);
                continue;
            }
            list = new ImList(node.toSexp(), list);
        }
        return list.destructiveReverse();
    }

    public void printStandardForm(PrintWriter out) {
        out.print("(DATA \"" + this.symbol.name + "\"");
        for (int i = 0; i < this.components.length; ++i) {
            LirNode node = this.components[i];
            if (node.opCode == 61) {
                out.print(" (" + Type.toString(node.type));
                int n = node.nKids();
                for (int j = 0; j < n; ++j) {
                    LirNode elem = node.kid(j);
                    if (elem.opCode == 2) {
                        out.print(" " + ((LirIconst)elem).value);
                        continue;
                    }
                    if (elem.opCode == 3) {
                        out.print(" " + ((LirFconst)elem).value);
                        continue;
                    }
                    out.print(" " + elem);
                }
                out.print(")");
                continue;
            }
            out.print(" " + node);
        }
        out.println(")");
    }

    public void printIt(PrintWriter out) {
        this.printStandardForm(out);
    }

    public void printIt(PrintWriter out, LocalAnalyzer[] anals) {
        this.printStandardForm(out);
    }
}

