/*
 * Decompiled with CFR 0.152.
 */
package coins.ast.expr;

import coins.ast.Expr;
import coins.ast.TokenId;
import coins.ast.Visitor;
import coins.ast.expr.BinaryExpr;

public class PointerBinaryExpr
extends BinaryExpr
implements TokenId {
    private int operatorToken;
    private byte[] resultType;

    public PointerBinaryExpr(Expr expr1, int op, Expr expr2) {
        super(expr1, expr2);
        this.operatorToken = op;
        this.resultType = expr1.getType();
    }

    public void accept(Visitor v) {
        v.atPointerBinaryExpr(this);
    }

    public byte[] getType() {
        return this.resultType;
    }

    public Expr getPointer() {
        return (Expr)((Object)this.getLeft());
    }

    public Expr getOffset() {
        return (Expr)((Object)this.getRight());
    }

    public int operatorId() {
        return this.operatorToken;
    }

    public String operatorName() {
        return new StringBuffer().append((char)this.operatorToken).toString();
    }
}

