/*
 * Decompiled with CFR 0.152.
 */
package coins.ast.expr;

import coins.ast.Expr;
import coins.ast.TokenId;
import coins.ast.Visitor;
import coins.ast.expr.UnaryExpr;

public class CastExpr
extends UnaryExpr
implements TokenId {
    private byte[] srcType;
    private byte[] destType;

    public CastExpr(Expr expr, byte[] stype, byte[] dtype) {
        super(expr);
        this.srcType = stype;
        this.destType = dtype;
    }

    public void accept(Visitor v) {
        v.atCastExpr(this);
    }

    public byte[] getType() {
        return this.destType;
    }

    public byte[] getOperandType() {
        return this.srcType;
    }

    public int operatorId() {
        return 380;
    }

    public String operatorName() {
        int i;
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<cast ");
        for (i = 0; i < this.srcType.length; ++i) {
            sbuf.append((char)this.srcType[i]);
        }
        sbuf.append("->");
        for (i = 0; i < this.destType.length; ++i) {
            sbuf.append((char)this.destType[i]);
        }
        sbuf.append('>');
        return sbuf.toString();
    }
}

