/*
 * Decompiled with CFR 0.152.
 */
package coins.ast;

import coins.ast.ASTree;
import coins.ast.Stmnt;
import coins.ast.Visitor;
import coins.ast.expr.ConstantExpr;

public class Enum
extends ASTree
implements Stmnt {
    private String typeName;
    private Item itemList;
    private Item itemTail;
    private String fileName;
    private int lineNumber;

    public Enum(String name, String fname, int line) {
        this.typeName = name;
        this.itemList = null;
        this.itemTail = null;
        this.fileName = fname;
        this.lineNumber = line;
    }

    public String name() {
        return this.typeName;
    }

    public Item getItems() {
        return this.itemList;
    }

    public void add(String name, ConstantExpr value) {
        Item i = new Item(name, value);
        if (this.itemTail == null) {
            this.itemList = this.itemTail = i;
        } else {
            this.itemTail.next = i;
            this.itemTail = i;
        }
    }

    public void accept(Visitor v) {
        v.atEnum(this);
    }

    public ASTree getLeft() {
        return null;
    }

    public ASTree getRight() {
        return null;
    }

    public void setLeft(ASTree _left) {
    }

    public void setRight(ASTree _right) {
    }

    public String fileName() {
        return this.fileName;
    }

    public int lineNumber() {
        return this.lineNumber;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("<enum ");
        sbuf.append(this.typeName);
        sbuf.append(' ');
        Item list = this.itemList;
        while (list != null) {
            sbuf.append(list.name);
            if (list.value != null) {
                sbuf.append('=');
                sbuf.append(list.value.toString());
            }
            sbuf.append(", ");
            list = list.next;
        }
        sbuf.append('>');
        return sbuf.toString();
    }

    public static class Item {
        Item next = null;
        String name;
        ConstantExpr value;

        Item(String n, ConstantExpr v) {
            this.name = n;
            this.value = v;
        }

        public Item getNext() {
            return this.next;
        }

        public String getName() {
            return this.name;
        }

        public ConstantExpr getValue() {
            return this.value;
        }
    }
}

