/*
 * Decompiled with CFR 0.152.
 */
package coins.ast;

import coins.ast.ASTree;
import coins.ast.DeclaratorList;
import coins.ast.Expr;
import coins.ast.Stmnt;
import coins.ast.TypeId;
import coins.ast.Visitor;

public class Declarator
extends ASTree
implements TypeId,
Stmnt {
    private String fileName;
    private int lineNumber;
    private String dname;
    private byte[] type;
    private long dSize;
    private int storage;
    private DeclaratorList argList;
    private Expr initialzer;
    private int bitFieldSize;
    private boolean isBitField;
    private boolean typedefed;
    private long arrayParamSize = 0L;

    public Declarator(String name, String fname, int line) {
        this.fileName = fname;
        this.lineNumber = line;
        this.dname = name;
        this.type = null;
        this.dSize = -1L;
        this.storage = 0;
        this.argList = null;
        this.initialzer = null;
        this.bitFieldSize = 0;
        this.isBitField = false;
        this.typedefed = false;
        this.arrayParamSize = 0L;
    }

    public ASTree getLeft() {
        return (ASTree)((Object)this.initialzer);
    }

    public ASTree getRight() {
        return null;
    }

    public void setLeft(ASTree _left) {
        this.initialzer = this.initialzer;
    }

    public void setRight(ASTree _right) {
        throw new RuntimeException("cannot do it");
    }

    public void accept(Visitor v) {
        v.atDeclarator(this);
    }

    public String fileName() {
        return this.fileName;
    }

    public int lineNumber() {
        return this.lineNumber;
    }

    public void setTypedefed(boolean b) {
        this.typedefed = b;
    }

    public void setName(String name) {
        this.dname = name;
    }

    public void setType(byte[] t, long s) {
        this.type = t;
        this.dSize = s;
    }

    public void setStorage(int s) {
        this.storage = s;
    }

    public void setArgs(DeclaratorList args) {
        this.argList = args;
    }

    public void setInitializer(Expr i) {
        this.initialzer = i;
    }

    public void setBitFieldSize(int s) {
        this.bitFieldSize = s;
    }

    public void setAsBitField() {
        this.isBitField = true;
    }

    public boolean isItBitField() {
        return this.isBitField;
    }

    public boolean isTypedef() {
        return this.typedefed;
    }

    public byte[] getType() {
        return this.type;
    }

    public long getSize() {
        return this.dSize;
    }

    public String getName() {
        return this.dname;
    }

    public int getStorage() {
        return this.storage;
    }

    public DeclaratorList getArgs() {
        return this.argList;
    }

    public Expr getInitializer() {
        return this.initialzer;
    }

    public int getBitFieldSize() {
        return this.bitFieldSize;
    }

    protected String getTag() {
        StringBuffer sbuf = new StringBuffer();
        if (this.typedefed) {
            sbuf.append("<typedef ");
        } else {
            sbuf.append("<decl ");
            sbuf.append(this.storage);
            sbuf.append(' ');
        }
        for (int i = 0; i < this.type.length; ++i) {
            sbuf.append((char)this.type[i]);
        }
        sbuf.append(' ');
        if (this.dname == null) {
            sbuf.append('?');
        } else {
            sbuf.append(this.dname);
        }
        sbuf.append('>');
        return sbuf.toString();
    }

    public long getArrayParamSize() {
        return this.arrayParamSize;
    }

    public void setArrayParamSize(long s) {
        this.arrayParamSize = s;
    }

    public String toString() {
        return new StringBuffer().append('(').append(this.getTag()).append("[").append(this.arrayParamSize).append("]").append(this.initialzer != null ? this.initialzer.toString() : "<null>").append(')').toString();
    }
}

