/*
 * Decompiled with CFR 0.152.
 */
package coins.alias;

import coins.HirRoot;
import coins.IoRoot;
import coins.alias.AliasAnal;
import coins.alias.AliasAnalHir1;
import coins.alias.AliasGroup;
import coins.flow.SubpFlow;
import coins.ir.hir.AssignStmt;
import coins.ir.hir.Exp;
import coins.ir.hir.FunctionExp;
import coins.ir.hir.HIR;
import coins.ir.hir.HirVisitorModel2;
import coins.ir.hir.PointedExp;
import coins.ir.hir.QualifiedExp;
import coins.ir.hir.SubpDefinition;
import coins.ir.hir.SubscriptedExp;
import coins.ir.hir.SymNode;
import coins.ir.hir.VarNode;
import coins.sym.FlowAnalSym;
import coins.sym.Param;
import coins.sym.Sym;
import coins.sym.Var;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RecordAlias {
    public final HirRoot hirRoot;
    public final IoRoot ioRoot0;
    public final AliasAnal fAliasAnal;
    protected Set fAddressTakenVars = new HashSet();
    protected Set fAliasOfAddressTakenVars = new HashSet();
    protected Set fSetOfGlobalVariables = new HashSet();
    protected Map fNodesOfSym = new HashMap();
    protected Set fSetOfSyms = new HashSet();
    protected Map fAliasGroupOfSym = new HashMap();
    protected boolean fCallWithSideEffectIncluded = false;
    protected int fDbgLevel;
    protected Set fEmptySet = new HashSet();

    public RecordAlias(AliasAnal pAliasAnal, SubpDefinition pSubpDef) {
        AliasAnalHir1 lAliasAnalHir = (AliasAnalHir1)pAliasAnal;
        this.hirRoot = lAliasAnalHir.hirRoot;
        this.ioRoot0 = this.hirRoot.ioRoot;
        this.ioRoot0.dbgAlias.print(1, "RecordAlias", pSubpDef.getSubpSym().toString());
        this.fDbgLevel = this.ioRoot0.dbgAlias.getLevel();
        this.fAliasAnal = pAliasAnal;
        this.fAliasAnal.prepareForAliasAnalHir(pSubpDef);
        AliasGroupInSubp lAliasGroup = new AliasGroupInSubp(lAliasAnalHir, pSubpDef);
        lAliasGroup.visit(pSubpDef.getHirBody());
        this.computeAliasGroupForSyms();
    }

    public RecordAlias(AliasAnal pAliasAnal, SubpDefinition pSubpDef, SubpFlow pSubpFlow) {
        AliasAnalHir1 lAliasAnalHir = (AliasAnalHir1)pAliasAnal;
        this.hirRoot = lAliasAnalHir.hirRoot;
        this.ioRoot0 = this.hirRoot.ioRoot;
        this.ioRoot0.dbgAlias.print(1, "RecordAlias", pSubpDef.getSubpSym().toString());
        this.fDbgLevel = this.ioRoot0.dbgAlias.getLevel();
        this.fAliasAnal = pAliasAnal;
        if (pSubpFlow == null || pSubpFlow.getComplexityLevel() <= 1) {
            this.fAliasAnal.prepareForAliasAnalHir(pSubpDef);
            AliasGroupInSubp lAliasGroup = new AliasGroupInSubp(lAliasAnalHir, pSubpDef);
            lAliasGroup.visit(pSubpDef.getHirBody());
            this.computeAliasGroupForSyms();
        } else {
            this.simplifiedAliasGrouping(pSubpFlow);
        }
    }

    public boolean possiblyAddressTaken(Sym pSym) {
        boolean lBool = this.fAliasOfAddressTakenVars.contains(pSym);
        this.ioRoot0.dbgAlias.print(3, "possiblyAddressTaken", pSym.toString() + " " + lBool);
        return lBool;
    }

    public boolean mayAlias(Sym pSym1, Sym pSym2) {
        boolean lMayAlias = false;
        if (this.fAliasGroupOfSym.containsKey(pSym1) && ((Set)this.fAliasGroupOfSym.get(pSym1)).contains(pSym2)) {
            lMayAlias = true;
        }
        if (!lMayAlias && this.fAliasGroupOfSym.containsKey(pSym2) && ((Set)this.fAliasGroupOfSym.get(pSym2)).contains(pSym1)) {
            lMayAlias = true;
        }
        if (this.fDbgLevel > 2) {
            this.ioRoot0.dbgAlias.print(3, "mayAlias", pSym1.toString() + " " + pSym2.toString() + " " + lMayAlias);
        }
        return lMayAlias;
    }

    public Set aliasSyms(Sym pSym) {
        Set lSymGroup = this.fEmptySet;
        if (this.fAliasGroupOfSym.containsKey(pSym)) {
            lSymGroup = (Set)this.fAliasGroupOfSym.get(pSym);
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot0.dbgAlias.print(4, "aliasSyms", pSym.toString() + " " + lSymGroup);
        }
        return lSymGroup;
    }

    public Set aliasSymGroup(Set pSet) {
        HashSet lSymGroup = new HashSet();
        for (Sym lSym : pSet) {
            if (!this.fAliasGroupOfSym.containsKey(lSym)) continue;
            lSymGroup.addAll((Set)this.fAliasGroupOfSym.get(lSym));
        }
        if (this.fDbgLevel > 2) {
            this.ioRoot0.dbgAlias.print(3, "aliasSymGroup", pSet.toString() + "=" + lSymGroup);
        }
        return lSymGroup;
    }

    public Set aliasExps(Exp pExp) {
        AliasGroup lAliasNodeSet = this.fAliasAnal.getAliasGroupFor(pExp);
        HashSet<FlowAnalSym> lAliasExpSet = new HashSet<FlowAnalSym>();
        if (lAliasNodeSet != null) {
            for (Exp lAliasNode : lAliasNodeSet) {
                FlowAnalSym lSym = lAliasNode.getSymOrExpId();
                if (lSym == null) continue;
                lAliasExpSet.add(lSym);
            }
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot0.dbgAlias.print(4, "aliasExps", pExp.toStringShort() + "=" + lAliasExpSet);
        }
        return lAliasExpSet;
    }

    public Set aliasExpGroup(Set pNodeSet) {
        HashSet<FlowAnalSym> lExpGroup = new HashSet<FlowAnalSym>();
        for (HIR lHir : pNodeSet) {
            AliasGroup lAliasNodeSet;
            if (!(lHir instanceof Exp) || (lAliasNodeSet = this.fAliasAnal.getAliasGroupFor((Exp)lHir)) == null) continue;
            for (Exp lAliasNode : lAliasNodeSet) {
                FlowAnalSym lSym = lAliasNode.getSymOrExpId();
                if (lSym == null) continue;
                lExpGroup.add(lSym);
            }
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot0.dbgAlias.print(4, "aliasExpGroup", pNodeSet.toString() + "=" + lExpGroup);
        }
        return lExpGroup;
    }

    protected void computeAliasGroupForSyms() {
        if (this.fDbgLevel > 0) {
            this.ioRoot0.dbgAlias.print(2, "computeAliasGroupOfSyms", this.fSetOfSyms.toString());
        }
        for (Var lVar : this.fSetOfSyms) {
            HashSet lAliasNodes = new HashSet();
            if (this.fNodesOfSym.containsKey(lVar)) {
                lAliasNodes.addAll((Set)this.fNodesOfSym.get(lVar));
            }
            if (this.fDbgLevel > 3) {
                this.ioRoot0.dbgAlias.print(5, " nodes of var " + lVar.toString() + ((Object)lAliasNodes).toString());
            }
            this.fNodesOfSym.put(lVar, lAliasNodes);
        }
        this.computeAliasFromNodeSet(this.fNodesOfSym, this.fAliasGroupOfSym);
        for (Var lVar : this.fAddressTakenVars) {
            if (!this.fAliasGroupOfSym.containsKey(lVar)) continue;
            this.fAliasOfAddressTakenVars.addAll((Set)this.fAliasGroupOfSym.get(lVar));
        }
    }

    private void computeAliasFromNodeSet(Map pNodeMap, Map pAliasMap) {
        if (this.fDbgLevel > 1) {
            this.ioRoot0.dbgAlias.print(2, "computeAliasFromNodeSet", " ");
        }
        if (this.fDbgLevel > 3) {
            this.printMapShort(" nodeMap ", pNodeMap);
        }
        Set lSetSyms = pNodeMap.keySet();
        for (Var lKeySym : lSetSyms) {
            Set lSetNodes = (Set)pNodeMap.get(lKeySym);
            if (this.fDbgLevel > 3) {
                this.ioRoot0.dbgAlias.print(5, " keySym " + lKeySym.getName() + lSetNodes.toString());
            }
            HashSet<Sym> lSymSet = new HashSet<Sym>();
            for (Exp lExpNode : lSetNodes) {
                AliasGroup lAliasNodes;
                Sym lSym = this.getLvalueSymbol(lExpNode);
                if (lSym != null) {
                    lSymSet.add(lSym);
                }
                if (this.fDbgLevel > 3) {
                    this.ioRoot0.dbgAlias.print(4, " expNode " + lExpNode.toStringShort());
                }
                if ((lAliasNodes = this.fAliasAnal.getAliasGroupFor((Exp)this.ChangeLvalue(lExpNode))) == null) continue;
                if (this.fDbgLevel > 3) {
                    System.out.print(" aliasNodes of " + lAliasNodes + "\n");
                }
                for (Exp lAliasNode : lAliasNodes) {
                    Sym lAliasSym = this.getLvalueSymbol(lAliasNode);
                    if (lAliasSym == null) continue;
                    lSymSet.add(lAliasSym);
                }
            }
            pAliasMap.put(lKeySym, lSymSet);
        }
        if (this.ioRoot0.dbgAlias.getLevel() >= 3) {
            this.printMapShort(" aliasMap", pAliasMap);
        }
    }

    public HIR ChangeLvalue(HIR pHir) {
        HIR lHir;
        if (pHir == null) {
            return null;
        }
        switch (pHir.getOperator()) {
            case 7: 
            case 9: 
            case 12: {
                lHir = pHir;
                break;
            }
            case 17: 
            case 64: 
            case 67: {
                lHir = this.ChangeLvalue((HIR)pHir.getChild1());
                break;
            }
            case 19: 
            case 20: {
                lHir = pHir;
                break;
            }
            default: {
                lHir = pHir;
            }
        }
        return lHir;
    }

    public Sym getLvalueSymbol(HIR pHir) {
        Sym lSym;
        if (pHir == null) {
            return null;
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot0.dbgAlias.print(5, "getLvalueSymbol", pHir.toStringShort());
        }
        switch (pHir.getOperator()) {
            case 7: 
            case 9: 
            case 12: {
                lSym = ((SymNode)pHir).getSymNodeSym();
                break;
            }
            case 17: 
            case 64: 
            case 67: {
                lSym = this.getLvalueSymbol((HIR)pHir.getChild1());
                break;
            }
            case 19: 
            case 20: {
                lSym = this.getLvalueSymbol((HIR)pHir.getChild2());
                break;
            }
            default: {
                lSym = null;
            }
        }
        if (this.fDbgLevel > 3) {
            this.ioRoot0.dbgAlias.print(5, " " + IoRoot.toStringObject(lSym));
        }
        return lSym;
    }

    public VarNode getLvalueSymNode(HIR pHir) {
        if (this.fDbgLevel > 3) {
            this.ioRoot0.dbgAlias.print(5, "getLvalueSymNode", pHir.toStringShort());
        }
        if (pHir instanceof VarNode) {
            return (VarNode)pHir;
        }
        switch (pHir.getOperator()) {
            case 17: 
            case 64: 
            case 67: {
                return this.getLvalueSymNode((HIR)pHir.getChild1());
            }
            case 19: 
            case 20: {
                return this.getLvalueSymNode((HIR)pHir.getChild2());
            }
        }
        return null;
    }

    void recordLvalueNodeForSym(Sym pSym, Exp pExp, Map pMap) {
        if (pSym == null || pExp == null) {
            return;
        }
        if (!pMap.containsKey(pSym)) {
            pMap.put(pSym, new HashSet());
        }
        Set lNodeSet = (Set)pMap.get(pSym);
        lNodeSet.add(pExp);
        if (this.fDbgLevel > 3) {
            this.ioRoot0.dbgAlias.print(5, " addNode ", lNodeSet.toString());
        }
    }

    public void printMapShort(String pHeader, Map pMap) {
        System.out.print(pHeader + "\n");
        if (pMap != null) {
            Set lKeySet = pMap.keySet();
            for (Object lKey : lKeySet) {
                Set lValueSet;
                if (!(lKey instanceof Var) && !(lKey instanceof HIR)) continue;
                if (lKey instanceof Var) {
                    System.out.print(" " + ((Var)lKey).getName() + "=[");
                    lValueSet = (Set)pMap.get((Var)lKey);
                } else {
                    System.out.print(" " + ((HIR)lKey).toStringShort() + "=[");
                    lValueSet = (Set)pMap.get((HIR)lKey);
                }
                for (Object lObject : lValueSet) {
                    if (lObject instanceof Sym) {
                        System.out.print(((Sym)lObject).getName() + " ");
                        continue;
                    }
                    if (!(lObject instanceof HIR)) continue;
                    System.out.print(((HIR)lObject).toStringShort() + " ");
                }
                System.out.print("]\n");
            }
        }
    }

    protected void simplifiedAliasGrouping(SubpFlow pSubpFlow) {
        this.ioRoot0.dbgAlias.print(2, "\nsimplifiedAliasGrouping", pSubpFlow.getSubpSym().getName() + "\n");
        this.fSetOfGlobalVariables = pSubpFlow.setOfGlobalVariables();
        this.fAddressTakenVars = pSubpFlow.setOfAddressTakenVariables();
        for (int lSymIndex = 0; lSymIndex < pSubpFlow.getSymExpCount(); ++lSymIndex) {
            FlowAnalSym lSym = pSubpFlow.getIndexedSym(lSymIndex);
            if (!(lSym instanceof Var)) continue;
            this.fSetOfSyms.add(lSym);
        }
        for (Var lKeyVar : this.fSetOfSyms) {
            if (!this.fAliasGroupOfSym.containsKey(lKeyVar)) {
                HashSet lAliasGroup = new HashSet();
                if (this.fAddressTakenVars.contains(lKeyVar)) {
                    lAliasGroup.addAll(this.fAddressTakenVars);
                }
                if (pSubpFlow.hasCall() && this.fSetOfGlobalVariables.contains(lKeyVar) || lKeyVar instanceof Param) {
                    lAliasGroup.addAll(this.fSetOfGlobalVariables);
                }
                this.fAliasGroupOfSym.put(lKeyVar, lAliasGroup);
            }
            if (this.ioRoot0.dbgAlias.getLevel() < 3) continue;
            this.printMapShort("fAliasGroupOfSym", this.fAliasGroupOfSym);
        }
    }

    private class AliasGroupInSubp
    extends HirVisitorModel2 {
        private AliasGroupInSubp(AliasAnalHir1 pAliasAnal, SubpDefinition pSubpDef) {
            super(pAliasAnal.hirRoot);
            RecordAlias.this.ioRoot0.dbgAlias.print(3, "AliasGroupInSubp", pSubpDef.toString());
        }

        public void atAssignStmt(AssignStmt pStmt) {
            Var lVar = null;
            Exp lValueExp = (Exp)pStmt.getChild1();
            VarNode lVarNode = RecordAlias.this.getLvalueSymNode(lValueExp);
            if (lVarNode instanceof VarNode) {
                if (this.fDbgLevel > 3) {
                    this.ioRoot.dbgAlias.print(4, "atAssignStmt", lVarNode.toStringShort());
                }
                lVar = (Var)lVarNode.getSymNodeSym();
                RecordAlias.this.recordLvalueNodeForSym(lVar, lValueExp, RecordAlias.this.fNodesOfSym);
            }
            this.visitChildren(pStmt);
        }

        public void atFunctionExp(FunctionExp pExp) {
            if (this.fDbgLevel > 3) {
                this.ioRoot.dbgAlias.print(4, "atFunctionExp", pExp.toStringShort());
            }
            SymNode lSubpNode = null;
            if (pExp.getChild1() instanceof SymNode) {
                lSubpNode = (SymNode)pExp.getChild1();
            } else if (pExp.getChild1().getOperator() == 64 && pExp.getChild1().getChild1() instanceof SymNode) {
                lSubpNode = (SymNode)pExp.getChild1().getChild1();
            }
            if (lSubpNode == null || !this.symRoot.sourceLanguage.functionsWithoutSideEffect.contains(lSubpNode.getSymNodeSym().getName())) {
                RecordAlias.this.fCallWithSideEffectIncluded = true;
                if (this.fDbgLevel > 3) {
                    this.ioRoot.dbgAlias.print(4, pExp.toStringShort(), "may change global variables.");
                }
            } else {
                this.ioRoot.dbgAlias.print(2, pExp.toStringShort(), "has no side effect.");
            }
            this.visitChildren(pExp);
        }

        public void atVarNode(VarNode pVarNode) {
            if (this.fDbgLevel > 3) {
                this.ioRoot.dbgAlias.print(4, "atVarNode", pVarNode.toStringShort());
            }
            Var lVar = (Var)pVarNode.getSymNodeSym();
            RecordAlias.this.fSetOfSyms.add(lVar);
            if (!RecordAlias.this.fNodesOfSym.containsKey(lVar) || ((Set)RecordAlias.this.fNodesOfSym.get(lVar)).contains(pVarNode)) {
                RecordAlias.this.recordLvalueNodeForSym(lVar, pVarNode, RecordAlias.this.fNodesOfSym);
            }
        }

        public void atSubscritedExp(SubscriptedExp pExp) {
            Sym lSym;
            if (this.fDbgLevel > 3) {
                this.ioRoot.dbgAlias.print(4, "atSubscriptedExp", pExp.toStringShort());
            }
            if (!RecordAlias.this.fNodesOfSym.containsKey(lSym = RecordAlias.this.getLvalueSymbol((Exp)pExp.getChild1())) || ((Set)RecordAlias.this.fNodesOfSym.get(lSym)).contains(pExp)) {
                RecordAlias.this.recordLvalueNodeForSym(lSym, pExp, RecordAlias.this.fNodesOfSym);
            }
            this.visitChildren(pExp);
        }

        public void atQualifiedExp(QualifiedExp pExp) {
            Sym lSym;
            if (this.fDbgLevel > 3) {
                this.ioRoot.dbgAlias.print(4, "atQualifiedExp", pExp.toStringShort());
            }
            if (!RecordAlias.this.fNodesOfSym.containsKey(lSym = RecordAlias.this.getLvalueSymbol((Exp)pExp.getChild2())) || ((Set)RecordAlias.this.fNodesOfSym.get(lSym)).contains(pExp)) {
                RecordAlias.this.recordLvalueNodeForSym(lSym, pExp, RecordAlias.this.fNodesOfSym);
            }
            this.visitChildren(pExp);
        }

        public void atPointedExp(PointedExp pExp) {
            if (this.fDbgLevel > 3) {
                this.ioRoot.dbgAlias.print(4, "atPointedExp", pExp.toStringShort());
            }
            Sym lSym = RecordAlias.this.getLvalueSymbol((Exp)pExp.getChild1());
            RecordAlias.this.recordLvalueNodeForSym(lSym, pExp, RecordAlias.this.fNodesOfSym);
            this.visitChildren(pExp);
        }

        public void atExp(Exp pExp) {
            if (this.fDbgLevel > 3) {
                this.ioRoot.dbgAlias.print(4, "atExp", pExp.toStringShort());
            }
            switch (pExp.getOperator()) {
                case 64: {
                    Exp lChild = (Exp)pExp.getChild1();
                    Sym lSym = RecordAlias.this.getLvalueSymbol(lChild);
                    if (lSym instanceof Var) {
                        RecordAlias.this.fAddressTakenVars.add(lSym);
                        if (!RecordAlias.this.fNodesOfSym.containsKey(lSym) || ((Set)RecordAlias.this.fNodesOfSym.get(lSym)).contains(pExp)) {
                            RecordAlias.this.recordLvalueNodeForSym(lSym, pExp, RecordAlias.this.fNodesOfSym);
                        }
                    }
                    this.visitChildren(pExp);
                    break;
                }
                case 67: 
                case 68: {
                    Sym lSym = RecordAlias.this.getLvalueSymbol((Exp)pExp.getChild1());
                    RecordAlias.this.recordLvalueNodeForSym(lSym, pExp, RecordAlias.this.fNodesOfSym);
                    this.visitChildren(pExp);
                    break;
                }
                default: {
                    this.visitChildren(pExp);
                }
            }
        }
    }
}

