/*
 * Decompiled with CFR 0.152.
 */
package coins.aflow.util;

import coins.aflow.util.FlowError;
import coins.aflow.util.Poset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PosetImpl
extends HashSet
implements Poset {
    Map directLessersAndGreatersInfo = new HashMap();

    public boolean add(Object o) {
        if (this.contains(o)) {
            return false;
        }
        this.directLessersAndGreatersInfo.put(o, new DirectInfo(new HashSet(), new HashSet()));
        super.add(o);
        return true;
    }

    public boolean add(Set directLessers, Set directGreaters, Object o) {
        return this.add(new DirectInfo(directLessers, directGreaters), o);
    }

    public boolean add(DirectInfo info, Object o) {
        Set directLessers = info.directLessers;
        Set directGreaters = info.directGreaters;
        boolean added = this.add(o);
        Iterator it = directLessers.iterator();
        while (it.hasNext()) {
            added |= this.connect(it.next(), o);
        }
        it = directGreaters.iterator();
        while (it.hasNext()) {
            added |= this.connect(o, it.next());
        }
        return added;
    }

    public boolean addMin(Set directGreaters, Object o) {
        return this.add(new HashSet(), directGreaters, o);
    }

    public boolean addMax(Set directLessers, Object o) {
        return this.add(directLessers, new HashSet(), o);
    }

    public boolean addMin(Object directGreater, Object o) {
        HashSet<Object> directGreaters = new HashSet<Object>();
        directGreaters.add(directGreater);
        return this.addMin(directGreaters, o);
    }

    public boolean addMax(Object directLesser, Object o) {
        HashSet<Object> directLessers = new HashSet<Object>();
        directLessers.add(directLesser);
        return this.addMax(directLessers, o);
    }

    public boolean addNew(Object o) {
        return this.add(new HashSet(), new HashSet(), o);
    }

    public boolean connect(Object lesser, Object greater) {
        if (this.greatersOf(lesser).contains(greater)) {
            return false;
        }
        DirectInfo info = (DirectInfo)this.directLessersAndGreatersInfo.get(lesser);
        boolean success = info.directGreaters.add(greater);
        info = (DirectInfo)this.directLessersAndGreatersInfo.get(greater);
        try {
        }
        catch (NullPointerException e) {
            throw new RuntimeException();
        }
        if (!(success |= info.directLessers.add(lesser))) {
            throw new FlowError();
        }
        return success;
    }

    public Set directLessersOf(Object o) {
        return ((DirectInfo)this.directLessersAndGreatersInfo.get((Object)o)).directLessers;
    }

    public Set directGreatersOf(Object o) {
        try {
            return ((DirectInfo)this.directLessersAndGreatersInfo.get((Object)o)).directGreaters;
        }
        catch (NullPointerException e) {
            System.out.println(this);
            throw e;
        }
    }

    public Set minimals() {
        HashSet minimals = new HashSet();
        for (Object element : this) {
            if (!this.strictLessersOf(element).isEmpty()) continue;
            minimals.add(element);
        }
        return minimals;
    }

    public Set maximals() {
        HashSet maximals = new HashSet();
        for (Object element : this) {
            if (!this.strictGreatersOf(element).isEmpty()) continue;
            maximals.add(element);
        }
        return maximals;
    }

    public Set lessersOf(Object entry) {
        ArrayList list = new ArrayList();
        this.dfSearch(list, entry, false);
        HashSet set = new HashSet();
        set.addAll(list);
        return set;
    }

    public Set greatersOf(Object entry) {
        ArrayList list = new ArrayList();
        this.dfSearch(list, entry, true);
        HashSet set = new HashSet();
        set.addAll(list);
        return set;
    }

    public Set strictLessersOf(Object entry) {
        Set lSet = this.lessersOf(entry);
        lSet.remove(entry);
        return lSet;
    }

    public Set strictGreatersOf(Object entry) {
        Set lSet = this.greatersOf(entry);
        lSet.remove(entry);
        return lSet;
    }

    public Iterator dfoIterator() {
        ArrayList order = new ArrayList();
        for (Object nextMin : this.minimals()) {
            this.dfSearch(order, nextMin, true);
        }
        return order.iterator();
    }

    public Iterator reverseDFOIterator() {
        ArrayList order = new ArrayList();
        for (Object nextMax : this.maximals()) {
            this.dfSearch(order, nextMax, false);
        }
        return order.iterator();
    }

    private void dfSearch(List order, Object entry, boolean pAscending) {
        if (!order.contains(entry)) {
            order.add(entry);
            Set lDirectNeighbors = pAscending ? this.directGreatersOf(entry) : this.directLessersOf(entry);
            Iterator it = lDirectNeighbors.iterator();
            while (it.hasNext()) {
                this.dfSearch(order, it.next(), pAscending);
            }
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        Iterator it = this.dfoIterator();
        while (it.hasNext()) {
            buffer.append(this.info(it.next()));
        }
        return buffer.toString();
    }

    public String info(Object o) {
        String lineSeparator = System.getProperty("line.separator");
        StringBuffer buffer = new StringBuffer();
        buffer.append(o);
        buffer.append(":" + lineSeparator);
        buffer.append(" Direct Lessers:" + lineSeparator);
        Iterator it = ((DirectInfo)this.directLessersAndGreatersInfo.get((Object)o)).directLessers.iterator();
        while (it.hasNext()) {
            buffer.append("  " + it.next() + lineSeparator);
        }
        buffer.append(" Direct Greaters:" + lineSeparator);
        it = ((DirectInfo)this.directLessersAndGreatersInfo.get((Object)o)).directGreaters.iterator();
        while (it.hasNext()) {
            buffer.append("  " + it.next() + lineSeparator);
        }
        return buffer.toString();
    }

    public static class DirectInfo {
        Set directLessers;
        Set directGreaters;

        public DirectInfo(Set directLessers, Set directGreaters) {
            this.directLessers = directLessers;
            this.directGreaters = directGreaters;
        }
    }
}

